<?php
function front_part_summary( $summary ) {
    $get = $summary[ 'get' ];
    $part_keys = $summary[ 'part_keys' ];
    $design_value = $summary[ 'design_value' ];
    $front_summary = $summary[ 'front_summary' ];
    $post_summary = $front_summary[ 'post_summary' ];
    $today = $summary[ 'today' ];
    $result = array();
    $page_id = isset( $front_summary[ 'page_info' ][ 'term_id' ] ) ? $front_summary[ 'page_info' ][ 'term_id' ] : false;
    $user_id = isset( $post_summary[ 'user_id' ] ) ? $post_summary[ 'user_id' ] : false;
    //記事ページでカテゴリー指定ある場合
    $select_hidden_taxs = false;
    if ( $front_summary[ 'page_info' ][ 'page_type' ] === 'single' ) {
        $page_id = isset( $front_summary[ 'page_info' ][ 'post_id' ] ) ? $front_summary[ 'page_info' ][ 'post_id' ] : false;
    }
    
    foreach( (array)$part_keys as $part_id ) {
        $parts = $design_value[ $part_id ];
        $flg = true;
        //指定非表示パーツの場合
        //記事ページでカテゴリー指定ある場合
        $hidden_tax = false;
        if ( $front_summary[ 'page_info' ][ 'page_type' ] === 'single' ) {
            if ( isset( $post_summary[ 'taxonomy' ] ) && is_array( $post_summary[ 'taxonomy' ] ) && count( $post_summary[ 'taxonomy' ] ) > 0 ) {
                foreach( (array)$post_summary[ 'taxonomy' ] as $tax_slug => $tax_val ) {
                    if ( isset( $parts[ 'hidden-tax' ][ $tax_slug ] ) && is_array( $parts[ 'hidden-tax' ][ $tax_slug ] ) && count( $parts[ 'hidden-tax' ][ $tax_slug ] ) > 0 ) {
                        $hidden_taxs = $parts[ 'hidden-tax' ][ $tax_slug ];
                        $this_taxs = array_column( $tax_val, 'term_id' );
                        foreach( (array)$hidden_taxs as $term_id ) {
                            $child_terms = get_term_children( $term_id, $tax_slug );
                            if ( !is_wp_error( $child_terms ) ) {
                                $hidden_taxs = array_merge( $hidden_taxs, $child_terms );
                            }
                        }
                        $check_taxs = array_intersect( $this_taxs, $hidden_taxs );
                        if ( is_array( $check_taxs ) && count( $check_taxs ) > 0 ) {
                            $hidden_tax = 'in';
                        } else {
                            $hidden_tax = 'out';
                        }
                    }
                }
            }
        }
        if ( isset( $parts[ 'hidden' ] ) && $parts[ 'hidden' ] === true ) {
            if ( $hidden_tax === 'in' || ( $page_id !== false && !is_array( $page_id ) && isset( $parts[ 'hidden-in' ] ) && in_array( (string)$page_id, $parts[ 'hidden-in' ], true ) === true ) || ( $user_id !== false && !is_array( $user_id ) && isset( $parts[ 'hidden-author' ] ) && in_array( (string)$user_id, $parts[ 'hidden-author' ], true ) === true ) ) {
                $flg = false;
            }
        } elseif ( isset( $parts[ 'hidden' ] ) && $parts[ 'hidden' ] === false ) {
            if ( $hidden_tax === 'in' || $page_id === false || ( $page_id !== false && !is_array( $page_id ) && isset( $parts[ 'hidden-in' ] ) && in_array( (string)$page_id, $parts[ 'hidden-in' ], true ) === true ) || ( $user_id !== false && !is_array( $user_id ) && isset( $parts[ 'hidden-author' ] ) && in_array( (string)$user_id, $parts[ 'hidden-author' ], true ) === true ) ) {
                $flg = true;
            } else {
                $flg = false;
            }
        }
        //GETパラメータによる非表示
        if ( $flg && isset( $parts[ 'get' ][ 'list' ] ) && is_array( $parts[ 'get' ][ 'list' ] ) && count( $parts[ 'get' ][ 'list' ] ) > 0 ) {
            $get_flg = false;
            foreach( (array)$parts[ 'get' ][ 'list' ] as $get_val ) {
                if ( isset( $get[ $get_val[ 'name' ] ] ) && ( !isset( $get_val[ 'value' ] ) || ( isset( $get_val[ 'value' ] ) && $get[ $get_val[ 'name' ] ] === $get_val[ 'value' ] ) ) ) {
                    $get_flg = true;
                }
            }
            if ( $parts[ 'get' ][ 'flg' ] === '1' ) {
                //非表示
                if ( $get_flg ) {
                    $flg = false;
                } else {
                    $flg = true;
                }
            } else {
                //表示
                if ( $get_flg ) {
                    $flg = true;
                } else {
                    $flg = false;
                }
            }
        }
        //タイマーによる非表示
        $start_time = isset( $parts[ 'timer' ][ 'start' ] ) ? new DateTime( $parts[ 'timer' ][ 'start' ] ) : false;
        $end_time = isset( $parts[ 'timer' ][ 'end' ] ) ? new DateTime( $parts[ 'timer' ][ 'end' ] ) : false;
        if ( $start_time !== false && $end_time !== false && ( $start_time > $today || $today > $end_time ) ) {
            $flg = false;
        } elseif ( $start_time !== false && $end_time === false && $start_time > $today ) {
            $flg = false;
        } elseif ( $start_time === false && $end_time !== false && $today > $end_time ) {
            $flg = false;
        }
        if ( $flg ) {
            if ( isset( $parts[ 'type' ] ) && $parts[ 'type' ] === 'area' ) {
                $result[ $part_id ] = $parts;
            } elseif ( isset( $parts[ 'type' ] ) && isset( $parts[ 'slug' ] ) ) {
                $result[ $part_id ] = front_original_summary( $front_summary, $part_id, $parts, $today );
            }
        } else {
            $result[ $part_id ] = false;
        }
    }
    return $result;
}

function front_cache_part( $summary, $fun_name ) {
    extract( $summary );
    $page_info = $front_summary[ 'page_info' ];
    $testab = isset( $page_info[ 'testab' ] ) ? $page_info[ 'testab' ] : '';
    $cache_name = 'DG_' . $part_id . $testab;
    if ( isset( $page_info[ 'lpFlg' ] ) ) {
        $cache_name = 'DG_' . $part_id . $page_info[ 'post_id' ];
    }
    $result = array();
    if ( !isset( $front_summary[ 'preview' ] ) && isset( $parts[ 'cache' ] ) && $parts[ 'cache' ] === '1' ) {
        $cache = get_transient( $cache_name );
        if ( !$cache ) {
            $cache = $fun_name( $summary );
            set_transient( $cache_name, $cache, DAY_IN_SECONDS );
        }
        $result = $cache;
    } else {
        $result = $fun_name( $summary );
    }
    return $result;
}

function front_original_summary( $front_summary, $part_id, $parts, $today ) {
    extract( $front_summary );
    $summary = [ 'front_summary' => $front_summary, 'part_id' => $part_id, 'parts' => $parts, 'today' => $today ];
    $fun_cache_arr = [
        'text' => 'text_image_part',
        'image' => 'text_image_part',
        'movie' => 'movie_music_part',
        'music' => 'movie_music_part',
        'post_list' => 'part_post_list',
        'html' => 'custom_html_part',
        'categories' => 'part_category_list',
        'tag-cloud' => 'part_tag_cloud',
        'archive' => 'part_archive',
        'new-comments' => 'part_new_comments',
        'author' => 'part_author',
    ];
    $fun_arr = [
        'taxonomy-brother' => 'front_main_part_archive_child',
        'taxonomy-child' => 'front_main_part_archive_child',
        'taxonomy-post_list' => 'front_main_part_archive_post_list',
        'taxonomy-paging' => 'front_main_part_archive_paging',
        'single-paging' => 'front_main_part_post_pagination',
        'single-author' => 'front_main_part_post_author',
        'single-recommend' => 'front_main_part_post_recommend',
    ];
    $result = [];
    if ( isset( $fun_cache_arr[ $parts[ 'slug' ] ] ) ) {
        $option = front_cache_part( $summary, $fun_cache_arr[ $parts[ 'slug' ] ] );
        if ( !$option ) {
            $option = [];
        }
        $result[ 'option' ] = $option;
    } elseif ( isset( $fun_arr[ $parts[ 'slug' ] ] ) ) {
        $option = $fun_arr[ $parts[ 'slug' ] ]( $summary );
        if ( !$option ) {
            $option = [];
        }
        $result[ 'option' ] = $option;
    } elseif ( $parts[ 'slug' ] === 'single-date' ) {
        $result[ 'option' ] = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array( 'date' => '1', 'date-format' => 'Y-m-d', 'update' => '1', 'update-format' => 'Y-m-d', );
    } else {
        $result[ 'option' ] = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array();
    }
    
    //その他値
    $result[ 'id' ] = $part_id;
    if ( isset( $parts[ 'name' ] ) ) {
        $result[ 'name' ] = $parts[ 'name' ];
    }
    if ( isset( $parts[ 'title' ] ) ) {
        $result[ 'title' ] = $parts[ 'title' ];
    }
    if ( isset( $parts[ 'event' ] ) ) {
        $result[ 'event' ] = $parts[ 'event' ];
    }
    if ( isset( $parts[ 'slide' ] ) ) {
        $result[ 'slide' ] = $parts[ 'slide' ];
    }
    if ( isset( $parts[ 'lazyload' ] ) ) {
        $result[ 'lazyload' ] = $parts[ 'lazyload' ];
    }
    $result[ 'type' ] = $parts[ 'type' ];
    $result[ 'order' ] = $parts[ 'order' ];
    $result[ 'slug' ] = $parts[ 'slug' ];
    $result[ 'parent' ] = isset( $parts[ 'parent' ] ) ? $parts[ 'parent' ] : 'page';
    return $result;
}

/*
 * テキスト＆イメージパーツ
*/
function text_image_part( $summary ) {
    extract( $summary );
    if ( $parts[ 'slug' ] !== 'text' && $parts[ 'slug' ] !== 'image' ) return false;
    $home_url = $front_summary[ 'home_url' ];
    $option = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array();
    $result = $option;
    unset( $result[ 'lt' ] );
    unset( $result[ 'pl' ] );
    if ( isset( $option[ 'lt' ] ) && $option[ 'lt' ] === '2' && isset( $option[ 'pl' ] ) && $option[ 'pl' ] !== '' ) {
        $pram = '';
        if ( isset( $option[ 'pram' ] ) && $option[ 'pram' ] !== '' ) {
            $pram = $option[ 'pram' ];
        }
        if ( $option[ 'pl' ] === 'top' ) {
            $result[ 'link' ] = $home_url . $pram;
        } else {
            $link_arr = explode( ',', $option[ 'pl' ] );
            $page_type = isset( $link_arr[ 1 ] ) ? $link_arr[ 1 ] : '';
            if ( $page_type === 'post' || strpos( $page_type, 'single-' ) !== false ) {
                $link = get_permalink( $link_arr[ 0 ] );
                if ( $link !== false ) {
                    $result[ 'link' ] = $link . $pram;
                }
            } elseif ( $page_type === 'author' ) {
                $result[ 'link' ] = get_author_posts_url( $link_arr[ 0 ] ) . $pram;
            } else {
                $page_type = str_replace( 'taxonomy-', '', $page_type );
                $link = get_term_link( (int)$link_arr[ 0 ], $page_type );
                if ( !is_wp_error( $link ) ) {
                    $result[ 'link' ] = $link . $pram;
                }
            }
        }
    }
    if ( $parts[ 'slug' ] === 'image' ) {
        if ( ( !isset( $option[ 'image-type' ] ) || ( isset( $option[ 'image-type' ] ) && $option[ 'image-type' ] === '1' ) ) && ( isset( $option[ 'image-url' ] ) && $option[ 'image-url' ] !== '' ) ) {
            $image_arr = explode( ',', $option[ 'image-url' ] );
            if ( isset( $image_arr[ 0 ] ) && is_numeric( $image_arr[ 0 ] ) ) {
                $result[ 'image-url' ] = post_image_src_list( $image_arr[ 0 ] );
            }
        }
    }
    return $result;
}

/*
 * 動画＆音楽パーツ
*/
function movie_music_part( $summary ) {
    extract( $summary );
    if ( $parts[ 'slug' ] !== 'movie' && $parts[ 'slug' ] !== 'music' ) return false;
    $type = $parts[ 'slug' ];
    $option = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array();
    $result = $option;
    if ( ( !isset( $option[ $type . '-type' ] ) || ( isset( $option[ $type . '-type' ] ) && $option[ $type . '-type' ] === '1' ) ) && ( isset( $option[ $type . '-url' ] ) && $option[ $type . '-url' ] !== '' ) ) {
        $data_arr = explode( ',', $option[ $type . '-url' ] );
        if ( isset( $data_arr[ 0 ] ) && is_numeric( $data_arr[ 0 ] ) ) {
            $result[ $type . '-url' ] = wp_get_attachment_url( $data_arr[ 0 ] );
        }
    }
    if ( $type === 'movie' ) {
        if ( ( !isset( $option[ 'image-type' ] ) || ( isset( $option[ 'image-type' ] ) && $option[ 'image-type' ] === '1' ) ) && ( isset( $option[ 'image-url' ] ) && $option[ 'image-url' ] !== '' ) ) {
            $image_arr = explode( ',', $option[ 'image-url' ] );
            if ( isset( $image_arr[ 0 ] ) && is_numeric( $image_arr[ 0 ] ) ) {
                $image = post_image_src_list( $image_arr[ 0 ] );
                if ( isset( $image[ 'full' ][ 'url' ] ) && $image[ 'full' ][ 'url' ] !== '' ) {
                    $result[ 'image-url' ] = $image[ 'full' ][ 'url' ];
                }
            }
        }
    }
    return $result;
}

function custom_html_part( $summary ) {
    extract( $summary );
    if ( $parts[ 'slug' ] !== 'html' ) return false;
    $loading_img = $front_summary[ 'loading_img' ];
    $option = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array();
    $result = $option;
    if ( isset( $option[ 'content' ] ) && $option[ 'content' ] !== '' ) {
        $html_content = apply_filters( 'the_content', $option[ 'content' ] );
        $html_content = str_replace( ']]>', ']]&gt;', $html_content );
        $html_content = replace_content_lightbox( $html_content );
        if ( !isset( $parts[ 'lazyload' ] ) ) {
            $html_content = replace_post_content( $html_content, $loading_img );
        }
        if ( isset( $option[ 'lazy' ] ) && $option[ 'lazy' ] === '1' ) {
            $html_content = preg_replace( '/<script([^>]+)(src=[\'"][^\'"]+[\'"])([^>]*)><\/script>/', '<div class="dg-lazy-blocks"$1data-$2$3></div>', $html_content );
        }
        $result[ 'content' ] = $html_content;
    } else {
        $result[ 'content' ] = '';
    }
    return $result;
}

/*
 * 記事リストパーツ
*/
function post_list_part( $post, $post_items, $option, $today, $sticky = false ) {
    if ( !is_object( $post ) ) {
        return false;
    }
    $post_id = $post->ID;
    //タクソノミー取得
    $hot_class = '';
    $class = '';
    //暗号ページの場合
    if ( $post->post_password !== '' ) {
        $class = ' locked';
    }
    if ( $sticky ) {
        $class = ' sticky';
    }
    $result = array();
    foreach( (array)$post_items as $order => $name ) {
        switch ( $name ) {
            case 'thumbnail' :
                $thumb = post_thumbnail_src( $post );
                $inner = array();
                if ( $thumb !== false ) {
                    $inner = $thumb;
                }
                if ( is_array( $inner ) && count( $inner ) > 0 ) {
                    $result[ 'part' ][ $name ] = $inner;
                } else {
                    $result[ 'part' ][ $name ] = false;
                }
                break;
            case 'content' :
                $content = preg_replace( '/<!-- (wp:core-embed).*?\1\/.+? -->/s', '', strip_shortcodes( $post->post_content ) );
                $content = str_replace( array( "\r\n", "\r", "\n" ), '', trim( strip_tags( $content ) ) );
                $result[ 'part' ][ 'content' ] = character_limit( $content, 150, '' );
                break;
            case 'date' :
                foreach( (array)$option[ 'date' ] as $id => $term ) {
                    $date = $post->post_date;
                    if ( $term[ 'type' ] === 'update' ) {
                        $date = $post->post_modified;
                    }
                    $date_arr = array( 'date' => $date );
                    $post_date = new DateTime( $date );
                    $date_arr[ 'format' ] = $post_date->format( $term[ 'format' ] );
                    if ( isset( $term[ 'days' ] ) && $term[ 'days' ] === '1' ) {
                        $interval = $today->diff( $post_date );
                        $days = false;
                        if ( $interval->invert === 1 ) {
                            $days = array();
                            $week = floor( $interval->d / 7 );
                            if ( $interval->y > 0 && $term[ 'terms2' ] === 'all' ) {
                                $days[ 'year' ] = $interval->y;
                                $days[ 'month' ] = $interval->m;
                            } elseif ( $interval->y === 0 && $interval->m > 0 && $term[ 'terms2' ] === 'month' && (int)$term[ 'terms1' ] >= $interval->m ) {
                                $days[ 'month' ] = $interval->m;
                            } elseif ( $interval->y === 0 && $interval->m === 0 && $week > 0 && ( ( $term[ 'terms2' ] === 'week' && (int)$term[ 'terms1' ] >= $week ) || $term[ 'terms2' ] === 'month' ) ) {
                                $days[ 'week' ] = $week;
                            } elseif ( $interval->y === 0 && $interval->m === 0 && $interval->d > 0 && ( ( $term[ 'terms2' ] === 'day' && (int)$term[ 'terms1' ] >= $interval->d ) || $term[ 'terms2' ] === 'month' || $term[ 'terms2' ] === 'week' ) ) {
                                $days[ 'day' ] = $interval->d;
                            } elseif ( $interval->y === 0 && $interval->m === 0 && $interval->d === 0 && $interval->h >= 0 ) {
                                $days[ 'time' ] = $interval->h;
                            }
                        }
                        $date_arr[ 'days' ] = $days;
                    }
                    $result[ 'part' ][ $name ][ $id ] = $date_arr;
                }
                break;
            case 'views' :
            case 'hot' :
                if ( isset( $option[ 'views' ] ) && is_array( $option[ 'views' ] ) && count( $option[ 'views' ] ) > 0 ) {
                    foreach( (array)$option[ 'views' ] as $type ) {
                        $view = get_post_meta( $post_id, $type, true );
                        $result[ 'part' ][ 'views' ][ $type ] = $view !== '' ? number_format( $view ) : 0;
                        if ( $name === 'hot' ) {
                            if ( (int)$option[ 'hot' ][ $type ] <= $view ) {
                                $result[ 'part' ][ 'hot' ][ $type ] = true;
                                $hot_class = ' hot';
                            }
                        }
                    }
                } else {
                    $view = get_post_meta( $post_id, 'views', true );
                    $result[ 'part' ][ 'views' ][ 'views' ] = $view !== '' ? number_format( $view ) : 0;
                    if ( $name === 'hot' ) {
                        if ( (int)$option[ 'hot' ][ 'views' ] <= $view ) {
                            $result[ 'part' ][ 'hot' ][ 'views' ] = true;
                            $hot_class = ' hot';
                        }
                    }
                }
                break;
            case 'comment' :
                $result[ 'part' ][ $name ] = number_format( get_comments_number( $post_id ) );
                break;
            case 'new' :
                foreach( (array)$option[ 'new' ] as $id => $term ) {
                    $date = $post->post_date;
                    if ( isset( $term[ 'terms3' ] ) && $term[ 'terms3' ] === 'update' ) {
                        $date = $post->post_modified;
                    }
                    $post_date = new DateTime( $date . ' +' . $term[ 'terms1' ] . ' ' . $term[ 'terms2' ] );
                    if ( $post_date >= $today ) {
                        $result[ 'part' ][ $name ][ $id ] = true;
                    }
                }
                break;
            case 'evaluate' :
                $evaluate_total = get_post_meta( $post_id, 'evaluate_total', true );
                $evaluate_table = get_post_meta( $post_id, 'evaluate_table', true );
                $result[ 'part' ][ $name ][ 'total' ] = $evaluate_total !== '' ? $evaluate_total : 0;
                $result[ 'part' ][ $name ][ 'table' ] = $evaluate_table !== '' ? json_decode( $evaluate_table, true ) : array();
                break;
            case 'bookmark' :
                $bookmark = get_post_meta( $post_id, 'dg_bookmark', true );
                $result[ 'part' ][ $name ] = $bookmark !== '' ? $bookmark : 0;
                break;
            case 'author' :
                if ( isset( $option[ 'author' ][ 'part' ] ) ) {
                    $result[ 'part' ][ $name ] = front_part_author_profile( $post->post_author, $option[ 'author' ][ 'part' ], isset( $option[ 'author' ][ 'option' ] ) ? $option[ 'author' ][ 'option' ] : array() );
                }
                break;
            case 'postmeta' :
                if ( isset( $option[ 'postmeta' ] ) && is_array( $option[ 'postmeta' ] ) && count( $option[ 'postmeta' ] ) > 0 ) {
                    foreach( (array)$option[ 'postmeta' ] as $type ) {
                        $result[ 'part' ][ $name ][ $type ] = get_post_meta( $post_id, $type, true );
                    }
                }
                break;
            case 'movie' :
                $movie = get_post_meta( $post_id, 'movie_thumbnail', true );
                $result[ 'part' ][ $name ] = $movie !== '' ? json_decode( $movie, true ) : false;
                break;
            default :
                if ( strpos( $name, 'tax-' ) !== false ) {
                    $tax_name = str_replace( 'tax-', '', $name );
                    $terms = front_part_taxonomy( $post_id, $tax_name );
                    if ( $terms !== false && isset( $terms[ 'terms' ] ) ) {
                        $result[ 'part' ][ $name ] = $terms[ 'terms' ];
                        $class .= $terms[ 'class' ];
                    } else {
                        $result[ 'part' ][ $name ] = false;
                    }
                }
                break;
        }
    }
    $result[ 'part' ][ 'title' ] = htmlspecialchars( $post->post_title, ENT_QUOTES, 'UTF-8' );
    $result[ 'part' ][ 'postId' ] = $post_id;
    $result[ 'class' ] = $class . $hot_class;
    $result[ 'url' ] = get_permalink( $post_id );
    return $result;
}

/*
 * 記事一覧記事リスト
*/
function part_taxonomy_post_list( $query, $value, $today, $sticky = null, $more_flg = null ) {
    $result = array();
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $result[ 'none' ] = isset( $option[ 'none' ] ) ? $option[ 'none' ] : '';
    $result[ 'bookmark' ] = isset( $option[ 'bookmark' ] ) ? $option[ 'bookmark' ] : '';
    $result[ 'plug' ] = isset( $option[ 'plug' ] ) ? $option[ 'plug' ] : '';
    $result[ 'point-class' ] = isset( $option[ 'point-class' ] ) ? $option[ 'point-class' ] : array();
    $result[ 'article_tag' ] = isset( $option[ 'article_tag' ] ) ? $option[ 'article_tag' ] : 'article';
    /* エリア生成 */
    $area = isset( $option[ 'area' ] ) ? $option[ 'area' ] : array();
    $list_values = set_post_list_value( $area );
    $post_items = $list_values[ 'post_items' ];
    $part_option = $list_values[ 'part_option' ];
    $result[ 'area' ] = $list_values[ 'area_items' ];
    /* 始まり終わり位置 */
    $start = isset( $option[ 'start' ] ) && $option[ 'start' ] !== '' ? (int)$option[ 'start' ] : false;
    $end = isset( $option[ 'end' ] ) && $option[ 'end' ] !== '' ? (int)$option[ 'end' ] : false;
    /* 広告差し込み */
    $result[ 'ad-cnt' ] = isset( $option[ 'ad-cnt' ] ) ? $option[ 'ad-cnt' ] : '';
    $result[ 'ad-multi' ] = isset( $option[ 'ad-multi' ] ) ? $option[ 'ad-multi' ] : '1';
    $result[ 'ad' ] = isset( $option[ 'ad' ] ) ? $option[ 'ad' ] : '';
    $result[ 'part-class' ] = isset( $option[ 'part-class' ] ) ? $option[ 'part-class' ] : '';
    $cnt = 1;
    $display_cnt = (int)$query->query[ 'posts_per_page' ] > 0 ? (int)$query->query[ 'posts_per_page' ] : (int)$query->post_count;
    if ( $sticky !== null && $cnt <= $display_cnt ) {
        if ( $sticky->have_posts() ) {
            while ( $sticky->have_posts() && $cnt <= $display_cnt ) {
                $sticky->the_post();
                if ( (
                    ( ( $start === false && $end === false ) || ( $start === false && $end !== false ) ) || 
                    ( $start !== false && $end === false && $start === $cnt ) ||
                    ( $start !== false && $end !== false && $start <= $cnt && $end >= $cnt )
                ) || $more_flg ) {
                    $result[ 'postList' ][] = post_list_part( $sticky->post, $post_items, $part_option, $today, true );
                    ++$cnt;
                }
            }
            wp_reset_postdata();
        }
        $sticky->rewind_posts();
    }
    if ( $query->have_posts() && $cnt <= $display_cnt ) {
        while ( $query->have_posts() && $cnt <= $display_cnt ) {
            $query->the_post();
            if ( (
                ( ( $start === false && $end === false ) || ( $start === false && $end !== false ) ) || 
                ( $start !== false && $end === false && $start === $cnt ) ||
                ( $start !== false && $end !== false && $start <= $cnt && $end >= $cnt )
            ) || $more_flg ) {
                $result[ 'postList' ][] = post_list_part( $query->post, $post_items, $part_option, $today );
                ++$cnt;
            }
        }
        wp_reset_postdata();
    }
    $query->rewind_posts();
    return $result;
}

/*
 * 記事パーツ設定
*/
function set_post_list_value( $area ) {
    $area_items = array();
    $post_items = array();
    $part_option = array();
    if ( isset( $area ) && is_array( $area ) && count( $area ) > 1 ) {
        $area_items = $area;
        $post_items = array_column( $area, 'slug' );
        $author_list = array();
        foreach( (array)$area as $id => $part ) {
            if ( isset( $part[ 'slug' ] ) ) {
                switch ( $part[ 'slug' ] ) {
                    case 'thumbnail' :
                    case 'movie' :
                        if ( $part[ 'slug' ] === 'movie' ) {
                            $post_items[] = 'thumbnail';
                        }
                        break;
                    case 'author' :
                        $part_option[ 'author' ][ 'part' ][ 'name' ] = 'name';
                        break;
                    case 'author_image' :
                        $post_items[] = 'author';
                        $author_image = isset( $part[ 'option' ][ 'type' ] ) && $part[ 'option' ][ 'type' ] !== '' ? $part[ 'option' ][ 'type' ] : 'user_image';
                        $part_option[ 'author' ][ 'part' ][ $author_image ] = $author_image;
                        break;
                    case 'date' :
                        $part_option[ 'date' ][ $id ][ 'type' ] = isset( $part[ 'option' ][ 'type' ] ) ? $part[ 'option' ][ 'type' ] : 'date';
                        $part_option[ 'date' ][ $id ][ 'days' ] = isset( $part[ 'option' ][ 'days' ] ) && $part[ 'option' ][ 'days' ] !== '' ? '1' : '';
                        $part_option[ 'date' ][ $id ][ 'terms1' ] = isset( $part[ 'option' ][ 'terms1' ] ) && $part[ 'option' ][ 'terms1' ] !== '' ? $part[ 'option' ][ 'terms1' ] : '7';
                        $part_option[ 'date' ][ $id ][ 'terms2' ] = isset( $part[ 'option' ][ 'terms2' ] ) ? $part[ 'option' ][ 'terms2' ] : 'day';
                        $part_option[ 'date' ][ $id ][ 'format' ] = isset( $part[ 'option' ][ 'format' ] ) && $part[ 'option' ][ 'format' ] !== '' ? $part[ 'option' ][ 'format' ] : 'Y-m-d';
                        break;
                    case 'new' :
                        $part_option[ 'new' ][ $id ][ 'terms1' ] = isset( $part[ 'option' ][ 'terms1' ] ) && $part[ 'option' ][ 'terms1' ] !== '' ? $part[ 'option' ][ 'terms1' ] : '3';
                        $part_option[ 'new' ][ $id ][ 'terms2' ] = isset( $part[ 'option' ][ 'terms2' ] ) && $part[ 'option' ][ 'terms2' ] !== '' ? $part[ 'option' ][ 'terms2' ] : 'day';
                        $part_option[ 'new' ][ $id ][ 'terms3' ] = isset( $part[ 'option' ][ 'terms3' ] ) && $part[ 'option' ][ 'terms3' ] !== '' ? $part[ 'option' ][ 'terms3' ] : 'date';
                        break;
                    case 'views' :
                    case 'hot' :
                        if ( isset( $part[ 'option' ][ 'type' ] ) && $part[ 'option' ][ 'type' ] !== '' ) {
                            $part_option[ 'views' ][ $part[ 'option' ][ 'type' ] ] = $part[ 'option' ][ 'type' ];
                            if ( $part[ 'slug' ] === 'hot' ) {
                                if ( isset( $part[ 'option' ][ 'count' ] ) && $part[ 'option' ][ 'count' ] !== '' ) {
                                    $hot = (int)$part[ 'option' ][ 'count' ];
                                } else {
                                    $hot = 0;
                                }
                                $part_option[ 'hot' ][ $part[ 'option' ][ 'type' ] ] = $hot;
                            }
                        } else {
                            $part_option[ 'views' ][ 'views' ] = 'views';
                            if ( isset( $part[ 'option' ][ 'count' ] ) && $part[ 'option' ][ 'count' ] !== '' ) {
                                $hot = (int)$part[ 'option' ][ 'count' ];
                            } else {
                                $hot = 0;
                            }
                            $part_option[ 'hot' ][ 'views' ] = $hot;
                        }
                        
                        break;
                    case 'postmeta' :
                        if ( isset( $part[ 'option' ][ 'type' ] ) && $part[ 'option' ][ 'type' ] !== '' ) {
                            $part_option[ 'postmeta' ][ $part[ 'option' ][ 'type' ] ] = $part[ 'option' ][ 'type' ];
                        }
                        break;
                }
            }
        }
        $post_items = array_unique( $post_items );
    }
    if ( is_array( $post_items ) && count( $post_items ) < 1 ) {
        $part_option[ 'views' ][ 'views' ] = 'views';
        $post_items = array( 'thumbnail', 'title', 'tax-category', );
    }
    return array( 'area_items' => $area_items, 'post_items' => $post_items, 'part_option' => $part_option, );
}

/*
 * 記事リスト
*/
function part_post_list( $summary ) {
    extract( $summary );
    if ( $parts[ 'slug' ] !== 'post_list' ) return false;
    $option = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array();
    $args = array( 'post_status' => 'publish', 'ignore_sticky_posts' => 1, );
    //ブックマーク表示の場合は絞り込み条件無視
    if ( isset( $option[ 'bookmark' ] ) && $option[ 'bookmark' ] === '1' ) {
        if ( isset( $_COOKIE[ 'dgbookmarkpost' ] ) && $_COOKIE[ 'dgbookmarkpost' ] !== 'none' ) {
            $bookmark_ids = explode( ',', $_COOKIE[ 'dgbookmarkpost' ] );
            $args[ 'post_type' ] = 'any';
            $args[ 'posts_per_page' ] = -1;
            $args[ 'post__in' ] = $bookmark_ids;
            $query = new WP_Query( $args );
            return part_taxonomy_post_list( $query, $parts, $today );
        }
        $result = array( 'postList' => array(), 'bookmark' => true );
        $result[ 'none' ] = isset( $option[ 'none' ] ) ? $option[ 'none' ] : '';
        return $result;
    }
    $paged = 1;
    $posts_per_page = isset( $option[ 'post-count' ] ) && $option[ 'post-count' ] !== '' ? $option[ 'post-count' ] : 5;
    $args[ 'posts_per_page' ] = $posts_per_page;
    $args[ 'offset' ] = isset( $option[ 'offset' ] ) && $option[ 'offset' ] !== '' ? ( (int)$option[ 'offset' ] - 1 ) : 0;
    $args[ 'order' ] = isset( $option[ 'order' ] ) ? $option[ 'order' ] : 'DESC';
    if ( isset( $option[ 'order-by' ] ) && ( $option[ 'order-by' ] === 'views' || $option[ 'order-by' ] === 'w_views' || $option[ 'order-by' ] === 'm_views' || $option[ 'order-by' ] === 'y_views' || $option[ 'order-by' ] === 'evaluate' ) ) {
        if ( $option[ 'order-by' ] === 'evaluate' ) {
            $args[ 'meta_key' ] = 'evaluate_total';
        } else {
            $args[ 'meta_key' ] = $option[ 'order-by' ];
        }
        $args[ 'orderby' ] = 'meta_value_num';
    } else {
        $args[ 'orderby' ] = isset( $option[ 'order-by' ] ) ? $option[ 'order-by' ] : 'date';
    }
    if ( isset( $parts[ 'option' ] ) ) {
        //キーワード検索
        if ( isset( $option[ 'keywords' ] ) && $option[ 'keywords' ] !== '' ) {
            $args[ 's' ] = $option[ 'keywords' ];
        }
        //INOUT設定
        if ( isset( $option[ 'inout' ] ) && $option[ 'inout' ] === '2' && isset( $option[ 'in' ] ) && $option[ 'in' ] !== '' ) {
            $args[ 'post__in' ] = explode( ',', $option[ 'in' ] );
        } elseif ( isset( $option[ 'inout' ] ) && $option[ 'inout' ] === '3' && isset( $option[ 'out' ] ) && $option[ 'out' ] !== '' ) {
            $args[ 'post__not_in' ] = explode( ',', $option[ 'out' ] );
        }
        //記事取得クエリ
        $args[ 'post_type' ] = isset( $option[ 'select-post-type' ] ) ? explode( ',', $option[ 'select-post-type' ] ) : '';
        if ( isset( $option[ 'select-users' ] ) && $option[ 'select-users' ] !== '' ) {
            $args[ 'author' ] = $option[ 'select-users' ];
        }
        //タクソノミー選択
        $relation = isset( $option[ 'relation' ] ) ? $option[ 'relation' ] : 'OR';
        $args[ 'tax_query' ][ 'relation' ] = $relation;
        foreach( (array)$option as $key => $tax ) {
            if ( strpos( $key, 'select-terms-' ) !== false && $tax !== '' ) {
                $tax_name = str_replace( 'select-terms-', '', $key );
                $args[ 'tax_query' ][] = array(
                    'taxonomy' => $tax_name,
                    'field' => 'term_id',
                    'terms' => explode( ',', $tax ),
                );
            }
        }
    }
    // 優先表示設定
    $sticky_query = null;
    if ( isset( $option[ 'sticky' ] ) && $option[ 'sticky' ] === '1' ) {
        $sticky = get_option( 'sticky_posts' );
        if ( is_array( $sticky ) && count( $sticky ) > 0 ) {
            $sticky_args = $args;
            $args[ 'ignore_sticky_posts' ] = true;
            if ( isset( $args[ 'post__not_in' ] ) ) {
                $args[ 'post__not_in' ] = array_merge( $sticky, $args[ 'post__not_in' ] );
            } else {
                $args[ 'post__not_in' ] = $sticky;
            }
            $sticky_args[ 'post__in' ] = $sticky;
            $sticky_cnt = count( $sticky );
            $over_cnt = $posts_per_page < $sticky_cnt ? $sticky_cnt - $posts_per_page : 0;
            if ( $paged > 1 ) {
                $args[ 'offset' ] = $posts_per_page * ( (int)$paged - 1 ) - $sticky_cnt + $over_cnt;
            }
            $sticky_flg = false;
            if ( ( $paged === 1 && $posts_per_page >= $sticky_cnt ) || ( $posts_per_page * ( $paged - 1 ) < $sticky_cnt && $sticky_cnt - $posts_per_page * ( $paged - 1 ) > 0 ) ) {
                $sticky_flg = true;
            }
            $wp_query_sticky = new WP_Query( $sticky_args );
            if ( (int)$wp_query_sticky->found_posts < $sticky_cnt ) {
                $sticky_cnt = (int)$wp_query_sticky->found_posts;
            }
            if ( $sticky_flg ) {
                $sticky_query = $wp_query_sticky;
            }
        }
    }
    $query = new WP_Query( $args );
    return part_taxonomy_post_list( $query, $parts, $today, $sticky_query );
}

/*
 * メニュー作成
*/
function create_menu_list_part( $menu_name ) {
    $menu = wp_get_nav_menu_object( $menu_name );
    if ( $menu === false ) {
        return false;
    }
    $args = array(
        'order' => 'ASC',
        'orderby' => 'menu_order',
        'post_type' => 'nav_menu_item',
        'post_status' => 'publish',
        'output' => ARRAY_A,
        'output_key' => 'menu_order',
        'nopaging' => true,
        'update_post_term_cache' => false
    );
    $menu_items = wp_get_nav_menu_items( $menu->term_id, $args );
    $menu_list = array();
    foreach ( (array)$menu_items as $key => $item ) {
        $menu_list[ $item->menu_order ][ 'menu_order' ] = $item->menu_order;
        $menu_list[ $item->menu_order ][ 'menu_id' ] = $item->ID;
        $menu_list[ $item->menu_order ][ 'object_id' ] = $item->object_id;
        $menu_list[ $item->menu_order ][ 'menu_item_parent' ] = $item->menu_item_parent;
        $menu_list[ $item->menu_order ][ 'url' ] = $item->url;
        $menu_list[ $item->menu_order ][ 'title' ] = $item->title;
        $menu_list[ $item->menu_order ][ 'target' ] = $item->target;
        $menu_list[ $item->menu_order ][ 'attr' ] = $item->attr_title;
        $menu_list[ $item->menu_order ][ 'class' ] = implode( ' ', $item->classes );
        switch ( $item->type ) {
            case 'taxonomy' :
                $menu_list[ $item->menu_order ][ 'slug' ] = get_term( $item->object_id, $item->object )->slug;
                $menu_list[ $item->menu_order ][ 'sub' ] = get_term_meta( $item->object_id, 'sub_title', true );
                break;
            case 'post' :
                $menu_list[ $item->menu_order ][ 'slug' ] = get_page( $item->object_id )->post_name;
                break;
            default :
                $menu_list[ $item->menu_order ][ 'slug' ] = $item->post_name;
                break;
        }
    }
    return create_menu_part_tree( $menu_list );
}

/*
 * メニューの親子設定作成
*/
function create_menu_part_tree( array &$menus, $parentId = 0, $cnt = 0 ) {
    $result = array();
    ++$cnt;
    foreach( $menus as &$item ) {
        if ( (int)$item[ 'menu_item_parent' ] === (int)$parentId ) {
            $item[ 'child-num' ] = $cnt;
            $item[ 'class' ] = $item[ 'class' ] !== '' ? $item[ 'class' ] : '';
            $children = create_menu_part_tree( $menus, $item['menu_id'], $cnt );
            if ( !empty( $children ) ) {
                $item[ 'child' ] = $children;
                $item[ 'has_children' ] = 1;
            }
            $result[ $item[ 'menu_order' ] ] = $item;
            unset( $item );
        }
    }
    return $result;
}

/*
 * カテゴリー
*/
function part_category_list( $summary ) {
    extract( $summary );
    if ( $parts[ 'slug' ] !== 'categories' ) return false;
    $option = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array();
    $result = array();
    $result[ 'part-class' ] = isset( $option[ 'part-class' ] ) ? $option[ 'part-class' ] : '';
    $result[ 'point-class' ] = isset( $option[ 'point-class' ] ) ? $option[ 'point-class' ] : array();
    $area_items = array();
    $part_items = array();
    if ( isset( $option[ 'area' ] ) && is_array( $option[ 'area' ] ) && count( $option[ 'area' ] ) > 1 ) {
        $area_items = $option[ 'area' ];
        $part_items = array_column( $option[ 'area' ], 'slug' );
        foreach( (array)$option[ 'area' ] as $id => $part ) {
            if ( isset( $part[ 'slug' ] ) && $part[ 'slug' ] === 'movie' ) {
                $part_items[] = 'thumbnail';
            }
        }
        $part_items = array_unique( $part_items );
    }
    if ( is_array( $part_items ) && count( $part_items ) < 1 ) {
        $part_items = array( 'title', 'sub', 'thumbnail', 'content', 'child', 'more', );
    }
    $result[ 'area' ] = $area_items;
    foreach( (array)$option as $key => $tax ) {
        if ( strpos( $key, 'select-terms-' ) !== false && $tax !== '' ) {
            $taxonomy = str_replace( 'select-terms-', '', $key );
            $terms = explode( ',', $tax );
            if ( is_array( $terms ) && count( $terms ) > 0 ) {
                foreach( (array)$terms as $term_id ) {
                    $item = get_term( $term_id, $taxonomy );
                    if ( $item !== null ) {
                        $term = array(
                            'term_id' => $item->term_id,
                            'slug' => $item->slug,
                            'count' => $item->count,
                            'url' => get_term_link( $item->term_id, $taxonomy ),
                        );
                        $term[ 'part' ][ 'title' ] = $item->name;
                        foreach( (array)$part_items as $order => $name ) {
                            switch ( $name ) {
                                case 'thumbnail' :
                                    $term[ 'part' ][ $name ] = get_taxonomy_thumbnail_image( $item->term_id );
                                    break;
                                case 'sub' :
                                    $term[ 'part' ][ $name ] = get_term_meta( $item->term_id, 'sub_title', true );
                                    break;
                                case 'content' :
                                    $term[ 'part' ][ $name ] = str_replace( array( "\r\n", "\r", "\n" ), '', trim( strip_tags( $item->description ) ) );
                                    break;
                                case 'movie' :
                                    $term[ 'part' ][ $name ] = get_taxonomy_thumbnail_movie( $item->term_id );
                                    break;
                            }
                        }
                        $result[ 'termList' ][] = $term;
                    }
                }
            }
        }
    }
    return $result;
}

/*
 * タグクラウド
*/
function part_tag_cloud( $summary ) {
    extract( $summary );
    if ( $parts[ 'slug' ] !== 'tag-cloud' ) return false;
    $option = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array();
    $taxs = isset( $option[ 'taxonomy' ] ) && $option[ 'taxonomy' ] !== '' ? explode( ',', $option[ 'taxonomy' ] ) : 'post_tag';
    $arg = array(
        'number' => isset( $option[ 'number' ] ) && $option[ 'number' ] !== '' ? $option[ 'number' ] : 45,
    );
    if ( isset( $option[ 'orderby' ] ) ) {
        $arg[ 'orderby' ] = $option[ 'orderby' ];
    }
    if ( isset( $option[ 'order' ] ) && $option[ 'order' ] !== 'RAND' ) {
        $arg[ 'order' ] = $option[ 'order' ];
    }
    $terms = get_terms( $taxs, $arg );
    $result = array();
    $result[ 'part-class' ] = isset( $option[ 'part-class' ] ) ? $option[ 'part-class' ] : '';
    if ( is_array( $terms ) && count( $terms ) > 0 && !is_wp_error( $terms ) ) {
        if ( isset( $option[ 'order' ] ) && $option[ 'order' ] === 'RAND' ) {
            shuffle( $terms );
        }
        $list = array();
        foreach( (array)$terms as $term ) {
            $list[] = array(
                'term_id' => $term->term_id,
                'slug' => $term->slug,
                'name' => $term->name,
                'count' => $term->count,
                'url' => get_term_link( $term->term_id, $term->taxonomy ),
            );
        }
        $result[ 'terms' ] = $list;
        
    } else {
        $result[ 'none' ] = true;
    }
    return $result;
}

/*
 * アカイブ
*/
function part_archive( $summary ) {
    extract( $summary );
    if ( $parts[ 'slug' ] !== 'archive' ) return false;
    $option = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array();
    $format = isset( $option[ 'type' ] ) && $option[ 'type' ] === '2' ? 'option' : 'html';
    $args = array(
        'format' => $format,
        'echo' => false,
        'show_post_count' => isset( $option[ 'count' ] ) && $option[ 'count' ] === '1' ? true : false,
    );
    if ( isset( $option[ 'limit' ] ) && $option[ 'limit' ] !== '' ) {
        $args[ 'limit' ] = $option[ 'limit' ];
    }
    $archive = wp_get_archives( $args );
    return array( 'list'=> $archive, 'format' => $format, 'part-class' => isset( $option[ 'part-class' ] ) ? $option[ 'part-class' ] : '' );
}

/*
 * 最新コメント
*/
function part_new_comments( $summary ) {
    extract( $summary );
    if ( $parts[ 'slug' ] !== 'new-comments' ) return false;
    $result = array();
    $option = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array();
    $result[ 'part-class' ] = isset( $option[ 'part-class' ] ) ? $option[ 'part-class' ] : '';
    $result[ 'point-class' ] = isset( $option[ 'point-class' ] ) ? $option[ 'point-class' ] : array();
    $args = array( 
        'orderby' => 'comment_date',
        'order' => 'DESC',
        'number' => isset( $option[ 'limit' ] ) && $option[ 'limit' ] !== '' ? $option[ 'limit' ] : 5,
    );
    $comments = get_comments( $args );
    if ( !empty( $comments ) ) {
        $list = array();
        foreach ( (array)$comments as $key => $comment ) {
            if ( $comment->comment_approved === '1' ) {
                $post_id = $comment->comment_post_ID;
                $list[ $key ] = array(
                    'url' => get_permalink( $post_id ),
                    'part' => array(
                        'title' => get_the_title( $post_id ),
                        'id' => $comment->comment_ID,
                        'author' => $comment->comment_author,
                        'comment' => str_replace( array( "\r\n", "\r", "\n" ), '', trim( strip_tags( $comment->comment_content ) ) ),
                        'date' => $comment->comment_date,
                    ),
                );
            }
        }
        $area = array();
        if ( isset( $option[ 'area' ] ) && is_array( $option[ 'area' ] ) && count( $option[ 'area' ] ) > 1 ) {
            $area = $option[ 'area' ];
        }
        $result[ 'list' ] = $list;
        $result[ 'area' ] = $area;
    } else {
        $result[ 'none' ] = true;
    }
    return $result;
}

/*
 * 作成者情報
*/
function part_author( $summary ) {
    extract( $summary );
    if ( $parts[ 'slug' ] !== 'author' ) return false;
    $option = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array();
    $users = isset( $option[ 'select-users' ] ) && $option[ 'select-users' ] !== '' ? explode( ',', $option[ 'select-users' ] ) : false;
    $result = array();
    $result[ 'part-class' ] = isset( $option[ 'part-class' ] ) ? $option[ 'part-class' ] : '';
    $result[ 'point-class' ] = isset( $option[ 'point-class' ] ) ? $option[ 'point-class' ] : array();
    if ( $users === false || ( is_array( $users ) && count( $users ) === 0 ) ) {
        $result[ 'userList' ] = false;
        return $result;
    }
    /* エリア生成 */
    $area_items = array();
    $post_items = array();
    $part_option = array();
    if ( isset( $option[ 'area' ] ) && is_array( $option[ 'area' ] ) && count( $option[ 'area' ] ) > 1 ) {
        $sns_list = array( 'site', 'mail', 'facebook', 'twitter', 'line', );
        $area_items = $option[ 'area' ];
        $post_items = array_column( $option[ 'area' ], 'slug' );
        foreach( (array)$option[ 'area' ] as $id => $part ) {
            if ( isset( $part[ 'slug' ] ) ) {
                switch ( $part[ 'slug' ] ) {
                    case 'gravatar' :
                    case 'user_image' :
                    case 'bg_image' :
                    case 'movie_thumbnail' :
                        if ( $part[ 'slug' ] === 'movie_thumbnail' ) {
                            $post_items[] = isset( $part[ 'option' ][ 'thumbnail-type' ] ) && $part[ 'option' ][ 'thumbnail-type' ] !== '' ? $part[ 'option' ][ 'thumbnail-type' ] : 'user_image';
                        }
                        if ( isset( $part[ 'option' ][ 'thumbnail-size' ] ) && $part[ 'option' ][ 'thumbnail-size' ] !== '' ) {
                            $part_option[ $part[ 'slug' ] ][ $part[ 'option' ][ 'thumbnail-size' ] ] = $part[ 'option' ][ 'thumbnail-size' ];
                        } else {
                            if ( $part[ 'slug' ] === 'gravatar' ) {
                                $part_option[ $part[ 'slug' ] ][ '150' ] = '150';
                            }
                        }
                        break;
                    case 'user_sns' :
                        foreach( (array)$sns_list as $sns ) {
                            if ( isset( $part[ 'option' ][ $sns ] ) && $part[ 'option' ][ $sns ] === '1' ) {
                                $part_option[ $part[ 'slug' ] ][ $sns ] = true;
                            }
                        }
                        break;
                }
            }
        }
        $post_items = array_unique( $post_items );
    }
    if ( is_array( $post_items ) && count( $post_items ) < 1 ) {
        $part_option = false;
        $post_items = array( 'name', 'description', 'gravatar', 'user_image', 'bg_image', 'user_sns', );
    }
    $result[ 'area' ] = $area_items;
    
    foreach( (array)$users as $user_id ) {
        $part = front_part_author_profile( $user_id, $post_items, $part_option );
        $result[ 'userList' ][] = array(
            'part' => $part,
            'url' => $part[ 'url' ],
        );
    }
    return $result;
}
/*
 * 記事コンテンツパーツ指定記事取得
*/
function get_select_post_content( $post_ids ) {
    $result = array();
    foreach( (array)$post_ids as $post_id ) {
        $post = get_post( $post_id );
        if ( $post !== null ) {
            $content = apply_filters( 'the_content', $post->post_content );
            $content = str_replace( ']]>', ']]&gt;', $content );
            $content = replace_content_lightbox( $content );
            $result[ $post_id ] = $content;
        }
    }
    return $result;
}

/*
 * 作成者情報取得
*/
function front_part_author_profile( $author_id, $fields = array(), $option = array() ) {
    if ( is_array( $fields ) && count( $fields ) > 0 ) {
        $user = get_userdata( $author_id );
        $result = array();
        $result[ 'url' ] = get_author_posts_url( $author_id );
        $result[ 'name' ] = isset( $user->display_name ) ? $user->display_name : '';
        foreach( (array)$fields as $name ) {
            switch ( $name ) {
                case 'description' :
                    $result[ 'description' ] = isset( $user->description ) ? nl2br( $user->description ) : '';
                    break;
                case 'gravatar' :
                    if ( !isset( $option[ 'gravatar' ] ) ) {
                        $option[ 'gravatar' ] = array( '300' => '300' );
                    }
                    foreach( (array)$option[ 'gravatar' ] as $size ) {
                        $result[ 'gravatar' ][ $size ] = get_avatar( $author_id, $size );
                    }
                    break;
                case 'user_image' :
                    if ( !isset( $option[ 'user_image' ] ) ) {
                        $option[ 'user_image' ] = array( 'thumbnail' => 'thumbnail', 'medium' => 'medium', 'large' => 'large', 'full' => 'full', );
                    }
                    $thumb = get_user_thumbnail_image( $author_id, 'user_image' );
                    $inner = array();
                    if ( $thumb !== false ) {
                        $inner = $thumb;
                    }
                    if ( is_array( $inner ) && count( $inner ) > 0 ) {
                        $result[ 'user_image' ] = $inner;
                    } else {
                        $result[ 'user_image' ] = false;
                    }
                    break;
                case 'bg_image' :
                    if ( !isset( $option[ 'bg_image' ] ) ) {
                        $option[ 'bg_image' ] = array( 'thumbnail' => 'thumbnail', 'medium' => 'medium', 'large' => 'large', 'full' => 'full', );
                    }
                    $thumb = get_user_thumbnail_image( $author_id, 'bg_image' );
                    $inner = array();
                    if ( $thumb !== false ) {
                        $inner = $thumb;
                    }
                    if ( is_array( $inner ) && count( $inner ) > 0 ) {
                        $result[ 'bg_image' ] = $inner;
                    } else {
                        $result[ 'bg_image' ] = false;
                    }
                    break;
                case 'user_sns' :
                    if ( !isset( $option[ 'user_sns' ] ) ) {
                        $option[ 'user_sns' ] = array( 'site' => true, 'mail' => true, 'facebook' => true, 'twitter' => true, 'line' => true, );
                    }
                    if ( isset( $option[ 'user_sns' ][ 'site' ] ) && isset( $user->user_url ) && $user->user_url !== '' ) {
                        $result[ 'user_sns' ][ 'site' ] = $user->user_url;
                    }
                    if ( isset( $option[ 'user_sns' ][ 'mail' ] ) && isset( $user->user_email ) && $user->user_email !== '' ) {
                        $result[ 'user_sns' ][ 'mail' ] = $user->user_email;
                    }
                    $user_sns = get_user_meta( $author_id, 'user_sns', true );
                    if ( $user_sns !== '' ) {
                        $user_sns = wp_unslash( $user_sns );
                        $user_sns = json_decode( $user_sns, true );
                        foreach( (array)$user_sns as $sns => $sns_value ) {
                            if ( isset( $option[ 'user_sns' ][ $sns ] ) && $sns_value !== '' ) {
                                $result[ 'user_sns' ][ $sns ] = $sns_value;
                            }
                        }
                    }
                    break;
                case 'movie_thumbnail' :
                    $movie = get_user_meta( $author_id, 'movie_thumbnail', true );
                    if ( $movie !== '' ) {
                        $movie = wp_unslash( $movie );
                        $movie = json_decode( $movie, true );
                        if ( isset( $movie[ 'value' ] ) && $movie[ 'value' ] !== '' ) {
                            $result[ 'movie_thumbnail' ] = $movie;
                        }
                    }
                    break;
            }
        }
        return $result;
    }
    return false;
}