<?php
/*
 * 記事リスト
*/
function front_main_part_archive_query( $page_info ) {
    if ( isset( $page_info[ 'page_type' ] ) ) {
        global $wp_query;
        $result = array();
        //更新URL
        if ( isset( $page_info[ 'result_url' ] ) ) {
            $result[ 'result_url' ] = $page_info[ 'result_url' ] ;
        }
        $paged = isset( $page_info[ 'paged' ] ) && is_numeric( $page_info[ 'paged' ] ) ? (int)$page_info[ 'paged' ] : 1;
        $result[ 'paged' ] = $paged;
        $result[ 'taxonomy' ] = $page_info[ 'taxonomy' ];
        if ( $result[ 'taxonomy' ] === 'author' ) {
            $user_id = $page_info[ 'term_id' ];
        } elseif ( $result[ 'taxonomy' ] === 'search' ) {
            $search_key = $page_info[ 'term_id' ];
        } elseif ( $page_info[ 'page_type' ] === 'taxonomy' && $result[ 'taxonomy' ] !== 'top' ) {
            //ページタイプにより切り替え
            if ( $result[ 'taxonomy' ] === 'date' ) {
                $result[ 'date' ] = '';
                if ( isset( $page_info[ 'term_id' ][ 'year' ] ) ) {
                    $year = $page_info[ 'term_id' ][ 'year' ];
                    $result[ 'date' ] .= $year;
                }
                if ( isset( $page_info[ 'term_id' ][ 'monthnum' ] ) ) {
                    $month = $page_info[ 'term_id' ][ 'monthnum' ];
                    $result[ 'date' ] .= '-' . $month;
                }
                if ( isset( $page_info[ 'term_id' ][ 'day' ] ) ) {
                    $day = $page_info[ 'term_id' ][ 'day' ];
                    $result[ 'date' ] .= '-' . $day;
                }
                if ( isset( $page_info[ 'term_id' ][ 'm' ] ) ) {
                    $date_m = $page_info[ 'term_id' ][ 'm' ];
                }
                if ( isset( $page_info[ 'term_id' ][ 'w' ] ) ) {
                    $week = $page_info[ 'term_id' ][ 'w' ];
                }
                if ( isset( $year ) && isset( $month ) && isset( $day ) ) {
                    $result[ 'mainUrl' ] = get_day_link( $year, $month, $day );
                } elseif ( isset( $year ) && isset( $month ) ) {
                    $result[ 'mainUrl' ] = get_month_link( $year, $month );
                } elseif ( isset( $year ) ) {
                    $result[ 'mainUrl' ] = get_year_link( $year );
                }
            } else {
                $result[ 'term_id' ] = $page_info[ 'term_id' ];
                $result[ 'mainUrl' ] = get_term_link( $page_info[ 'term_id' ], $page_info[ 'taxonomy' ] );
            }
        }
        //表示数
        $posts_per_page = (int)get_option( 'posts_per_page' );
        if ( isset( $page_info[ 'count' ] ) && $page_info[ 'count' ] !== '' ) {
            $posts_per_page = (int)$page_info[ 'count' ];
        }
        $order_value = array(
            'orderby' => 'date',
            'order' => 'DESC',
            'count' => $posts_per_page,
        );
        $args = array(
            'paged' => $paged,
            'orderby' => 'date',
            'order' => 'DESC',
            'post_status' => 'publish',
            'posts_per_page' => $posts_per_page,
        );
        //並び替え
        if ( isset( $page_info[ 'orderby' ] ) && $page_info[ 'orderby' ] !== '' ) {
            $order_value[ 'orderby' ] = $page_info[ 'orderby' ];
            if ( $page_info[ 'orderby' ] === 'views' || $page_info[ 'orderby' ] === 'w_views' || $page_info[ 'orderby' ] === 'm_views' || $page_info[ 'orderby' ] === 'y_views' || $page_info[ 'orderby' ] === 'evaluate' || $page_info[ 'orderby' ] === 'bookmark' ) {
                if ( $page_info[ 'orderby' ] === 'evaluate' ) {
                    $args[ 'meta_key' ] = 'evaluate_total';
                } elseif ( $page_info[ 'orderby' ] === 'bookmark' ) {
                    $args[ 'meta_key' ] = 'dg_bookmark';
                } else {
                    $args[ 'meta_key' ] = $page_info[ 'orderby' ];
                }
                $args[ 'orderby' ] = 'meta_value_num';
            } else {
                $args[ 'orderby' ] = $page_info[ 'orderby' ];
            }
        }
        if ( isset( $page_info[ 'order' ] ) && $page_info[ 'order' ] !== '' ) {
            $order_value[ 'order' ] = $page_info[ 'order' ];
            $args[ 'order' ] = $page_info[ 'order' ];
        }
        $result[ 'order_value' ] = $order_value;
        //タクソノミー絞り
        if ( isset( $result[ 'term_id' ] ) && isset( $result[ 'taxonomy' ] ) ) {
            $args[ 'tax_query' ] = array(
                array(
                    'taxonomy' => $result[ 'taxonomy' ],
                    'field' => 'term_id',
                    'terms' => array( (int)$result[ 'term_id' ] ),
                ),
            );
        }
        //投稿者
        if ( isset( $user_id ) ) {
            $args[ 'author' ] =  $user_id;
        }
        //検索
        $srange_type = '';
        if ( isset( $search_key ) ) {
            $args[ 's' ] = $search_key;
            if ( isset( $page_info[ 'srange' ] ) && $page_info[ 'srange' ] === '1' ) {
                $srange_type = 'custom_posts_where_title_only';
            } elseif ( isset( $page_info[ 'srange' ] ) && $page_info[ 'srange' ] === '2' ) {
                $srange_type = 'custom_posts_where_content_only';
            }
            
            if ( isset( $page_info[ 'stax' ] ) && $page_info[ 'stax' ] !== '' ) {
                $stax = explode( ',', $page_info[ 'stax' ] );
                $stax = array_filter( $stax, 'strlen' );
                $stax = array_values( $stax );
                $tax_list = array();
                foreach( (array)$stax as $value ) {
                    $tax = explode( '-', $value );
                    $tax_list[ $tax[ 0 ] ][] = $tax[ 1 ];
                }
                if ( is_array( $tax_list ) && count( $tax_list ) > 0 ) {
                    foreach( (array)$tax_list as $taxonomy => $value ) {
                        $args[ 'tax_query' ][] = array(
                            'taxonomy' => $taxonomy,
                            'field' => 'slug',
                            'terms' => $value,
                        );
                    }
                }
            }
        }
        //日付
        if ( isset( $year ) ) {
            $args[ 'date_query' ][ 0 ][ 'year' ] = $year;
        }
        if ( isset( $month ) ) {
            $args[ 'date_query' ][ 0 ][ 'month' ] = $month;
        }
        if ( isset( $day ) ) {
            $args[ 'date_query' ][ 0 ][ 'day' ] = $day;
        }
        if ( isset( $week ) ) {
            $args[ 'date_query' ][ 0 ][ 'w' ] = $week;
        }
        if ( isset( $date_m ) ) {
            $args[ 'm' ] = $date_m;
        }
        // 記事タイプある場合指定
        if ( isset( $page_info[ 'post_type' ] ) ) {
            $args[ 'post_type' ] = $page_info[ 'post_type' ];
        }
        $sticky_cnt = 0;
        if ( !isset( $page_info[ 'none_main_post' ] ) ) {
            //sticky記事
            $sticky = get_option( 'sticky_posts' );
            if ( is_array( $sticky ) && count( $sticky ) > 0 ) {
                $sticky_args = $args;
                $args[ 'ignore_sticky_posts' ] = true;
                $args[ 'post__not_in' ] = $sticky;
                $sticky_args[ 'post__in' ] = $sticky;
                $all_sticky_args = $sticky_args;
                $all_sticky_args[ 'posts_per_page' ] = -1;
                $wp_query_sticky_all = new WP_Query( $all_sticky_args );
                $sticky_cnt = (int)$wp_query_sticky_all->found_posts;
                $offset = $posts_per_page * ( (int)$paged - 1 ) - $sticky_cnt;
                $args[ 'offset' ] = $offset < 0 ? 0 : $offset;
                $sticky_flg = false;
                if ( ( $paged === 1 && $posts_per_page >= $sticky_cnt ) || ( $posts_per_page * ( $paged - 1 ) < $sticky_cnt && $sticky_cnt - $posts_per_page * ( $paged - 1 ) > 0 ) ) {
                    $sticky_flg = true;
                }
                $wp_query_sticky = new WP_Query( $sticky_args );
                if ( $sticky_flg ) {
                    $result[ 'sticky' ] = $wp_query_sticky;
                }
            }
            //検索範囲フィルターON
            if ( isset( $search_key ) && $srange_type !== '' ) {
                add_filter( 'posts_where', $srange_type, 10, 2 );
            }
            $wp_query = new WP_Query( $args );
            //検索範囲フィルターOFF
            if ( isset( $search_key ) && $srange_type !== '' ) {
                remove_filter( 'posts_where', $srange_type, 10, 2 );
            }
            $result[ 'query' ] = $wp_query;
        }
        //記事数
        $total = (int)$wp_query->found_posts + $sticky_cnt;
        $last_page = ceil( $total / $posts_per_page );
        $paged = isset( $wp_query->query[ 'paged' ] ) ? (int)$wp_query->query[ 'paged' ] : 1;
        $from = $paged === 1 ? 1 : ( $posts_per_page * ( $paged - 1 ) ) + 1;
        $until = (int)$paged === (int)$last_page ? $total : ( $total >= $posts_per_page ? ( (int)$posts_per_page * $paged ) : $total );
        $result[ 'postCount' ] = array(
            'from' => $from,
            'until' => $until,
            'total' => $total,
            'page' => $paged,
            'max_num_pages' => $last_page,
        );
        return $result;
    }
    return false;
}

/*
 * 記事一覧子カテゴリー
*/
function front_main_part_archive_post_list( $summary ) {
    extract( $summary );
    if ( $parts[ 'slug' ] !== 'taxonomy-post_list' || !$front_summary[ 'archive' ] || !isset( $front_summary[ 'archive' ][ 'query' ] ) ) return false;
    $archive = $front_summary[ 'archive' ];
    return part_taxonomy_post_list( $archive[ 'query' ], $parts, $today, ( isset( $archive[ 'sticky' ] ) ? $archive[ 'sticky' ] : null ), ( isset( $more_flg ) ? $more_flg : null ) );
}

/*
 * 記事一覧子カテゴリー
*/
function front_main_part_archive_child( $summary ) {
    extract( $summary );
    if ( ( $parts[ 'slug' ] !== 'taxonomy-brother' && $parts[ 'slug' ] !== 'taxonomy-child' ) || !$front_summary[ 'archive' ] ) return false;
    $page_info = $front_summary[ 'page_info' ];
    if ( $page_info[ 'page_type' ] !== 'taxonomy' || ( $page_info[ 'page_type' ] === 'taxonomy' && $page_info[ 'taxonomy' ] === 'date' ) ) {
        return false;
    }
    $option = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array();
    $result = array(
        'display' => '',
        'type' => isset( $option[ 'type' ] ) ? $option[ 'type' ] : '1',
        'count' => isset( $option[ 'count' ] ) ? $option[ 'count' ] : '',
        'part-class' => isset( $option[ 'part-class' ] ) ? $option[ 'part-class' ] : '',
        'p' => isset( $option[ 'p' ] ) ? $option[ 'p' ] : '1',
        'pn' => isset( $option[ 'pn' ] ) ? $option[ 'pn' ] : '',
        'point-class' => isset( $option[ 'point-class' ] ) ? $option[ 'point-class' ] : array(),
    );
    //兄弟カテゴリー表示判定
    $term_id = (string)$page_info[ 'term_id' ];
    if ( $parts[ 'slug' ] === 'taxonomy-brother' ) {
        $term_id = (string)$page_info[ 'parent_id' ];
    }
    $cnt = 0;
    $display_flg = false;
    foreach( (array)$option as $key => $tax ) {
        if ( strpos( $key, 'select-terms-' ) !== false && $tax !== '' ) {
            ++$cnt;
            $select_ids = explode( ',', $tax );
            if ( in_array( $term_id, $select_ids, true ) ) {
                $display_flg = true;
            }
        }
    }
    if ( $cnt === 0 || $display_flg === true ) {
        $result[ 'display' ] = '1';
    }
    return $result;
}

/*
 * ページネーション出力関数
 * $paged : 現在のページ
 * $pages : 全ページ数
 * $range : 左右に何ページ表示するか
*/
function front_main_part_archive_paging( $summary ) {
    extract( $summary );
    if ( $parts[ 'slug' ] !== 'taxonomy-paging' || !$front_summary[ 'archive' ] ) return false;
    $archive = $front_summary[ 'archive' ];
    $paged = (int)$archive[ 'paged' ];
    $pages = (int)$archive[ 'postCount' ][ 'max_num_pages' ];
    $option = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : '';
    $range = isset( $option[ 'range' ] ) ? (int)$option[ 'range' ] : 4;
    $showitems = ( $range * 2 ) + 1;
    if ( $paged === '' ) {
        $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    }
    $paged = (int)$paged;
    if( $pages === '' ) {
        global $wp_query;
        $pages = (int)$wp_query->max_num_pages;
        if( !$pages ) {
            $pages = 1;
        }
    }
    $pages = (int)$pages;
    if( 1 !== $pages ) {
        $result = array();
        $page = array();
        $cnt = 0;
        $current = 0;
        for ( $i = 1; $i <= $pages; $i++ ) {
            if ( 1 != $pages && ( !( $i >= $paged + $range + 1 || $i <= $paged - $range - 1 ) || $pages <= $showitems ) ) {
                if ( (int)$paged === (int)$i ) {
                    $page[ $cnt ] = $i;
                    $current = $cnt;
                } else {
                    $page[ $cnt ] = $i;
                }
                ++$cnt;
            }
        }
        if ( !isset( $page[ $current ] ) ) {
            return false;
        }
        $prev_cnt = $current - $range;
        if ( $prev_cnt < 0 ) {
            $result[ 'number' ][ 'prev' ] = array_slice( $page, 0, $current );
        } else {
            $result[ 'number' ][ 'prev' ] = array_slice( $page, $prev_cnt, $range );
        }
        $result[ 'number' ][ 'current' ] = $page[ $current ];
        $result[ 'number' ][ 'next'] = array_slice( $page, $current + 1, $range );
        if ( $paged > 1 ) {
            $result[ 'prev' ][ 'max' ] = 1;
        } else {
            $result[ 'prev' ][ 'max' ] = 'none';
        }
        if ( is_array( $result[ 'number' ][ 'prev'] ) && count( $result[ 'number' ][ 'prev'] ) > 0 ) {
            $result[ 'prev' ][ 'one' ] = $paged - 1;
        } else {
            $result[ 'prev' ][ 'one' ] = 'none';
        }
        if ( is_array( $result[ 'number' ][ 'next'] ) && count( $result[ 'number' ][ 'next'] ) > 0 ) {
            $result[ 'next' ][ 'one' ] = $paged + 1;
        } else {
            $result[ 'next' ][ 'one' ] = 'none';
        }
        if ( $paged < $pages ) {
            $result[ 'next' ][ 'max' ] = $pages;
        } else {
            $result[ 'next' ][ 'max' ] = 'none';
        }
        $result[ 'maxCount' ] = $pages;
        $result[ 'range' ] = $range;
        $result[ 'type' ] = isset( $option[ 'type' ] ) ? $option[ 'type' ] : '1';
        $result[ 'more' ] = isset( $option[ 'more' ] ) ? $option[ 'more' ] : '';
        $result[ 'count' ] = isset( $option[ 'count' ] ) ? $option[ 'count' ] : '';
        $result[ 'both' ] = isset( $option[ 'both' ] ) ? $option[ 'both' ] : '';
        $result[ 'pm' ] = isset( $option[ 'pm' ] ) ? $option[ 'pm' ] : '1';
        $result[ 'p' ] = isset( $option[ 'p' ] ) ? $option[ 'p' ] : '1';
        $result[ 'nm' ] = isset( $option[ 'nm' ] ) ? $option[ 'nm' ] : '1';
        $result[ 'n' ] = isset( $option[ 'n' ] ) ? $option[ 'n' ] : '1';
        $result[ 'pmn' ] = isset( $option[ 'pmn' ] ) ? $option[ 'pmn' ] : 'prev-max';
        $result[ 'pn' ] = isset( $option[ 'pn' ] ) ? $option[ 'pn' ] : 'prev';
        $result[ 'nmn' ] = isset( $option[ 'nmn' ] ) ? $option[ 'nmn' ] : 'next-max';
        $result[ 'nn' ] = isset( $option[ 'nn' ] ) ? $option[ 'nn' ] : 'next';
        $result[ 'count-text' ] = isset( $option[ 'count-text' ] ) ? $option[ 'count-text' ] : '';
        $result[ 'part-class' ] = isset( $option[ 'part-class' ] ) ? $option[ 'part-class' ] : '';
        $result[ 'target' ] = isset( $option[ 'target' ] ) ? $option[ 'target' ] : '';
        return $result;
    }
    return false;
}

/*
 * 閲覧数集計
*/
function set_post_views( $post ) {
    if ( 'publish' === $post->post_status && !is_search_robot() ) {
        $post_id = $post->ID;
        $all_view_field = 'views';
        $week_view_field = 'w_views';
        $month_view_field = 'm_views';
        $year_view_field = 'y_views';
        $all_views = get_post_meta( $post_id, $all_view_field, true );
        $week_views = get_post_meta( $post_id, $week_view_field, true );
        $month_views = get_post_meta( $post_id, $month_view_field, true );
        $year_views = get_post_meta( $post_id, $year_view_field, true );
        update_post_meta( $post_id, $all_view_field, ( (int)$all_views + 1 ) );
        update_post_meta( $post_id, $week_view_field, ( (int)$week_views + 1 ) );
        update_post_meta( $post_id, $month_view_field, ( (int)$month_views + 1 ) );
        update_post_meta( $post_id, $year_view_field, ( (int)$year_views + 1 ) );
    }
}

/*
 * 本文置換
*/
function replace_post_content( $content, $loading_img ) {
    //lazyloadイメージ
    $content = preg_replace( '/<img(?![^>]+loading=[\'\"]?lazy)([^<>]*?)>/s', '<img$1 loading="lazy">', $content );
    //lazyloadIframe
    $content = preg_replace( '/<iframe(?![^>]+data-src)([^<>]*?)src=[\'\"]([^<>\'\"]*?)[\'\"]([^<>]*?)>/s', '<iframe data-src="$2"$1$3>', $content );
    $content = preg_replace( '/<iframe(?![^>]+dg-lazy)([^<>]*?)class=[\'\"]([^<>\'\"]*?)[\'\"]([^<>]*?)>/s', '<iframe class="$2 dg-lazy DGEVENTITEM"$1$3>', $content );
    $content = preg_replace( '/<iframe(?![^>]+class)([^<>]*?)>/s', '<iframe class="dg-lazy DGEVENTITEM"$1>', $content );
    $content = preg_replace( '/<iframe(?![^>]+loading=[\'\"]?lazy)([^<>]*?)>/s', '<iframe$1 loading="lazy">', $content );
    return  $content;
}

/*
 * LIGHTBOX
*/
function replace_content_lightbox( $content ) {
    $content = preg_replace( '/<a([^<>]*?)\sclass=[\'\"]([^<>\'\"]*?)[\'\"]([^<>]*?href=[\'\"][^<>\'\"]*?\.(jpg|jpeg|png|gif|svg|svgz|webp)[^<>\'\"]*?[\'\"][^<>]*?)>/s', '<a$1 class="$2 DGLIGHTBOX"$3>', $content );
    $content = preg_replace( '/<a([^<>]*?href=[\'\"][^<>\'\"]*?\.(jpg|jpeg|png|gif|svg|svgz|webp)[^<>\'\"]*?[\'\"][^<>]*?)\sclass=[\'\"]([^<>\'\"]*?)[\'\"]([^<>]*?)>/s', '<a$1 class="$2 DGLIGHTBOX"$3>', $content );
    $content = preg_replace( '/<a(?![^>]+class)([^<>]*?href=[\'\"][^<>\'\"]*?\.(jpg|jpeg|png|gif|svg|svgz|webp)[^<>\'\"]*?[\'\"][^<>]*?)>/s', '<a class="DGLIGHTBOX"$1>', $content );
    return  $content;
}

/*
 * 埋め込みブロックのLazyLoad処理
*/
add_filter( 'render_block', 'wporg_block_wrapper', 10, 2 );
function wporg_block_wrapper( $block_content, $block ) {
    $embed = $block['blockName'] === 'core/embed' && isset( $block[ 'attrs' ][ 'providerNameSlug' ] ) && in_array( $block[ 'attrs' ][ 'providerNameSlug' ], array( 'twitter', 'tumblr', 'tiktok', 'issuu', 'imgur', ), true ) === true;
    if ( ( $block['blockName'] === 'core/html' || $block['blockName'] === 'dg-style/script' || $embed ) && isset( $block[ 'attrs' ][ 'lazyloadFlg' ] ) && $block[ 'attrs' ][ 'lazyloadFlg' ] === '1' ) {
        $content = preg_replace( '/<script([^>]+)(src=[\'"][^\'"]+[\'"])([^>]*)><\/script>/', '<div class="dg-lazy-blocks"$1data-$2$3></div>', $block_content );
        return $content;
    }
    return $block_content;
}

/*
 * 記事情報取得
*/
function front_single_post_get( $page_info, $pass = '' ) {
    if ( isset( $page_info[ 'post_id' ] ) && $page_info[ 'post_id' ] !== '' ) {
        global $post;
        $result = array();
        $post = get_post( $page_info[ 'post_id' ] );
        if ( $post === null ) {
            return false;
        }
        $post_id = $post->ID;
        //本文設定
        $title = htmlspecialchars( $post->post_title, ENT_QUOTES, 'UTF-8' );
        $content = apply_filters( 'the_content', $post->post_content );
        $content = str_replace( ']]>', ']]&gt;', $content );
        $content = replace_content_lightbox( $content );
        
        $date = get_the_date( 'c', $post_id );
        $update = get_the_modified_date( 'c', $post_id );
        //postmeta取得
        $result[ 'postData' ][ 'postMeta' ] = array(
            'evaluate_total' => 0,
            'evaluate_table' => array(),
        );
        if ( isset( $page_info[ 'meta_keys' ] ) && is_array( $page_info[ 'meta_keys' ] ) && count( $page_info[ 'meta_keys' ] ) > 0 ) {
            foreach( (array)$page_info[ 'meta_keys' ] as $meta_key ) {
                $meta_value = get_post_meta( $post_id, $meta_key, true );
                switch ( $meta_key ) {
                    case 'views' :
                    case 'w_views' :
                    case 'm_views' :
                    case 'y_views' :
                    case 'dg_bookmark' :
                        $meta_value = $meta_value !== '' ? number_format( $meta_value ) : 0;
                        break;
                    case 'evaluate_total' :
                        $meta_value = $meta_value !== '' ? $meta_value : 0;
                        break;
                    case 'evaluate_table' :
                        $meta_value = $meta_value !== '' ? json_decode( $meta_value, true ) : array();
                        break;
                    case 'movie_thumbnail' :
                        $meta_value = $meta_value !== '' ? json_decode( $meta_value, true ) : false;
                        break;
                }
                $result[ 'postData' ][ 'postMeta' ][ $meta_key ] = $meta_value;
            }
        }
        //サムネイル取得
        $thumbnail = post_thumbnail_src( $post );
        $author = front_part_author_profile( $post->post_author, array( 'name', 'description' ) );
        $result[ 'user_id' ] = $post->post_author;
        $result[ 'parent' ] = $post->post_parent;
        
        //コンテンツデータ
        $result[ 'postData' ][ 'postId' ] = $post_id;
        $result[ 'postData' ][ 'commentStatus' ] = $post->comment_status;
        $result[ 'postData' ][ 'commentCount' ] = number_format( $post->comment_count );
        
        //パスワード保護記事の場合
        if ( $post->post_password !== '' ) {
            $passed = post_password_required( $post );
            if ( $pass === $post->post_password ) {
                $passed = false;
            }
            if ( $passed === false ) {
                $post_content = create_post_index_list( $content );
                $result[ 'postData' ][ 'postContent' ] = $post_content[ 'content' ];
                $result[ 'postData' ][ 'indexList' ] = isset( $post_content[ 'index' ] ) ? $post_content[ 'index' ] : false;
                $result[ 'postData' ][ 'description' ] = character_limit( preg_replace( '/[\s\n]{1,}/s', '', strip_tags( $content ) ), 120 );
            } else {
                $result[ 'postData' ][ 'password' ] = true;
                $result[ 'postData' ][ 'postContent' ] = '';
                $result[ 'postData' ][ 'description' ] = '';
            }
        } else {
            $post_content = create_post_index_list( $content );
            $result[ 'postData' ][ 'postContent' ] = $post_content[ 'content' ];
            $result[ 'postData' ][ 'indexList' ] = isset( $post_content[ 'index' ] ) ? $post_content[ 'index' ] : false;
            $result[ 'postData' ][ 'description' ] = character_limit( preg_replace( '/[\s\n]{1,}/s', '', strip_tags( $content ) ), 120 );
        }
        $result[ 'postData' ][ 'postTitle' ] = $title;
        $result[ 'postData' ][ 'date' ] = $date;
        $result[ 'postData' ][ 'update' ] = $update;
        if ( $thumbnail !== false ) {
            $result[ 'postData' ][ 'thumbnail' ] = $thumbnail;
        }
        $result[ 'postData' ][ 'author' ] = $author;
        $taxonomise = default_taxonomy_exclusion( array( 'category', 'post_tag' ) );
        foreach( (array)$taxonomise as $tax ) {
            $terms = front_part_taxonomy( $post_id, $tax );
            if ( $terms !== false && isset( $terms[ 'terms' ] ) ) {
                $result[ 'postData' ][ 'taxonomy' ][ $tax ] = $terms[ 'terms' ];
            }
        }
        $prev = get_adjacent_post( true, '', true );
        $next = get_adjacent_post( true, '', false );
        $paging = array( 'prev'=> $prev, 'next'=> $next );
        foreach( $paging as $key => $value ) {
            if ( is_object( $value ) ) {
                $brother_id = $value->ID;
                $result[ 'postData' ][ $key ][ 'post_id' ] = $brother_id;
                $result[ 'postData' ][ $key ][ 'url' ] = get_permalink( $brother_id );
            }
        }
        //コメント関連フラッグ
        $result[ 'postData' ][ 'commentReg' ] = get_option( 'comment_registration' );
        if ( !isset( $page_info[ 'preview' ] ) ) {
            set_post_views( $post );//views更新
        }
        return $result;
    }
    return false;
}

/*
 * 目次作成
*/
function create_post_index_list( $content ) {
    preg_match_all( '/(<(h[1-6])[^<>]*?>.*?<\/\2>)/s', $content, $match );
    if ( isset( $match[ 1 ] ) && is_array( $match[ 1 ] ) && count( $match[ 1 ] ) > 0 ) {
        $post_content = $content;
        $index_arr = array();
        $cnt = 0;
        $h1 = '';
        $h2 = '';
        $h3 = '';
        $h4 = '';
        $h5 = '';
        $h6 = '';
        foreach( (array)$match[ 1 ] as $title ) {
            if ( preg_match( '/<(h[1-6])[^>]+id=[\'\"]([^<>\'\"]*?)[\'\"][^<>]*?>(.*?)<\/\1>/s', $title, $sub ) && isset( $sub[ 3 ] ) && $sub[ 3 ] !== '' ) {
                $tag = $sub[ 1 ];
                $text = $sub[ 3 ];
                if ( isset( $sub[ 2 ] ) && $sub[ 2 ] !== '' ) {
                    $id = $sub[ 2 ];
                    $new_title = preg_replace( '/<(h[1-6])([^<>]*?)class=[\'\"]([^<>\'\"]*?)[\'\"]([^<>]*?)>/s', '<$1 class="$3 heading-item DGEVENTITEM"$2$4>', $title );
                    $new_title = preg_replace( '/<(h[1-6])(?![^>]+class)([^<>]*?)>/s', '<$1 class="heading-item DGEVENTITEM"$2>', $new_title );
                    $pattern = preg_quote( $title , '/' );
                    $post_content = preg_replace( '/' . $pattern . '/s', $new_title, $post_content, 1 );
                } else {
                    $id = 'post-index-' . $cnt;
                    $new_title = preg_replace( '/<(h[1-6])([^>]+)id=[\'\"]([^<>\'\"]*?)[\'\"]([^<>]*?)>(.*?)<\/\1>/s', '<$1$2id="' . $id . '"$4>$5</$1>', $title );
                    $new_title = preg_replace( '/<(h[1-6])([^<>]*?)class=[\'\"]([^<>\'\"]*?)[\'\"]([^<>]*?)>/s', '<$1 class="$3 heading-item DGEVENTITEM"$2$4>', $new_title );
                    $new_title = preg_replace( '/<(h[1-6])(?![^>]+class)([^<>]*?)>/s', '<$1 class="heading-item DGEVENTITEM"$2>', $new_title );
                    $pattern = preg_quote( $title , '/' );
                    $post_content = preg_replace( '/' . $pattern . '/s', $new_title, $post_content, 1 );
                    ++$cnt;
                }
            } elseif ( preg_match( '/<(h[1-6])([^<>]*?)>(.*?)<\/\1>/s', $title, $sub ) && isset( $sub[ 3 ] ) && $sub[ 3 ] !== '' ) {
                $tag = $sub[ 1 ];
                $text = $sub[ 3 ];
                $id = 'post-index-' . $cnt;
                $new_title = preg_replace( '/<(h[1-6])([^<>]*?)>(.*?)<\/\1>/s', '<$1$2 id="' . $id . '">$3</$1>', $title );
                $new_title = preg_replace( '/<(h[1-6])([^<>]*?)class=[\'\"]([^<>\'\"]*?)[\'\"]([^<>]*?)>/s', '<$1 class="$3 heading-item DGEVENTITEM"$2$4>', $new_title );
                $new_title = preg_replace( '/<(h[1-6])(?![^>]+class)([^<>]*?)>/s', '<$1 class="heading-item DGEVENTITEM"$2>', $new_title );
                $pattern = preg_quote( $title , '/' );
                $post_content = preg_replace( '/' . $pattern . '/s', $new_title, $post_content, 1 );
                ++$cnt;
            }
            if ( isset( $text ) && isset( $id ) ) {
                $index_arr[ $id ][ 'text' ] = $text;
                $index_arr[ $id ][ 'id' ] = $id;
                switch ( $tag ) {
                    case 'h1' :
                        $index_arr[ $id ][ 'parent' ] = '';
                        $h1 = $id;
                        $h2 = '';
                        $h3 = '';
                        $h4 = '';
                        $h5 = '';
                        $h6 = '';
                        break;
                    case 'h2' :
                        $index_arr[ $id ][ 'parent' ] = $h1;
                        $h2 = $id;
                        $h3 = '';
                        $h4 = '';
                        $h5 = '';
                        $h6 = '';
                        break;
                    case 'h3' :
                        $index_arr[ $id ][ 'parent' ] = $h2;
                        if ( $h2 !== '' ) {
                            $index_arr[ $id ][ 'parent' ] = $h2;
                        } elseif ( $h1 !== '' ) {
                            $index_arr[ $id ][ 'parent' ] = $h1;
                        }
                        $h3 = $id;
                        $h4 = '';
                        $h5 = '';
                        $h6 = '';
                        break;
                    case 'h4' :
                        if ( $h3 !== '' ) {
                            $index_arr[ $id ][ 'parent' ] = $h3;
                        } elseif ( $h2 !== '' ) {
                            $index_arr[ $id ][ 'parent' ] = $h2;
                        } elseif ( $h1 !== '' ) {
                            $index_arr[ $id ][ 'parent' ] = $h1;
                        }
                        $h4 = $id;
                        $h5 = '';
                        $h6 = '';
                        break;
                    case 'h5' :
                        if ( $h4 !== '' ) {
                            $index_arr[ $id ][ 'parent' ] = $h4;
                        } elseif ( $h3 !== '' ) {
                            $index_arr[ $id ][ 'parent' ] = $h3;
                        } elseif ( $h2 !== '' ) {
                            $index_arr[ $id ][ 'parent' ] = $h2;
                        } elseif ( $h1 !== '' ) {
                            $index_arr[ $id ][ 'parent' ] = $h1;
                        }
                        $h5 = $id;
                        $h6 = '';
                        break;
                    case 'h6' :
                        if ( $h5 !== '' ) {
                            $index_arr[ $id ][ 'parent' ] = $h5;
                        } elseif ( $h4 !== '' ) {
                            $index_arr[ $id ][ 'parent' ] = $h4;
                        } elseif ( $h3 !== '' ) {
                            $index_arr[ $id ][ 'parent' ] = $h3;
                        } elseif ( $h2 !== '' ) {
                            $index_arr[ $id ][ 'parent' ] = $h2;
                        } elseif ( $h1 !== '' ) {
                            $index_arr[ $id ][ 'parent' ] = $h1;
                        }
                        $h6 = $id;
                        break;
                }
            }
        }
        return array( 'content' => $post_content, 'index' => $index_arr, );
    }
    return array( 'content' => $content );
}

/*
 * 前後ページで記事非表示フラグがある場合
*/
//add_filter( 'get_previous_post_where', 'front_adjacent_nodisplay_filter', 10, 3 );
//add_filter( 'get_next_post_where', 'front_adjacent_nodisplay_filter', 10, 3 );
function front_adjacent_nodisplay_filter( $where ) {
    global $wpdb;
    return $where . " AND p.ID NOT IN ( SELECT post_id FROM $wpdb->postmeta WHERE ($wpdb->postmeta.post_id = p.ID ) AND $wpdb->postmeta.meta_key = 'dg_nodisplay' AND $wpdb->postmeta.meta_value = '1' )";
}

/*
 * ページネーション出力関数
*/
function front_main_part_post_pagination( $summary ) {
    extract( $summary );
    if ( $parts[ 'slug' ] !== 'single-paging' || !$front_summary[ 'post_summary' ] ) return false;
    $post_summary = $front_summary[ 'post_summary' ];
    $result = array();
    $option = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array();
    $result[ 'part-class' ] = isset( $option[ 'part-class' ] ) ? $option[ 'part-class' ] : '';
    /* エリア生成 */
    $area = isset( $option[ 'area' ] ) ? $option[ 'area' ] : array();
    $list_values = set_post_list_value( $area );
    $post_items = $list_values[ 'post_items' ];
    $part_option = $list_values[ 'part_option' ];
    $result[ 'area' ] = $list_values[ 'area_items' ];
    if ( isset( $post_summary[ 'prev' ] ) ) {
        $prev = get_post( $post_summary[ 'prev' ][ 'post_id' ] );
        $result[ 'prev' ] = post_list_part( $prev, $post_items, $part_option, $today );
    }
    if ( isset( $post_summary[ 'next' ] ) ) {
        $next = get_post( $post_summary[ 'next' ][ 'post_id' ] );
        $result[ 'next' ] = post_list_part( $next, $post_items, $part_option, $today );
    }
    return $result;
}

/*
 * 記事作成者プロフィール
*/
function front_main_part_post_author( $summary ) {
    extract( $summary );
    if ( $parts[ 'slug' ] !== 'single-author' || !$front_summary[ 'post_summary' ] ) return false;
    $post_summary = $front_summary[ 'post_summary' ];
    $option = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array();
    $author_id = $post_summary[ 'user_id' ];
    $result = array();
    $result[ 'part-class' ] = isset( $option[ 'part-class' ] ) ? $option[ 'part-class' ] : '';
    /* エリア生成 */
    $sns_list = array( 'site', 'mail', 'facebook', 'twitter', 'line', );
    $area_items = array();
    $post_items = array();
    $part_option = array();
    if ( isset( $option[ 'area' ] ) && is_array( $option[ 'area' ] ) && count( $option[ 'area' ] ) > 1 ) {
        $area_items = $option[ 'area' ];
        $post_items = array_column( $option[ 'area' ], 'slug' );
        foreach( (array)$option[ 'area' ] as $id => $part ) {
            if ( isset( $part[ 'slug' ] ) ) {
                switch ( $part[ 'slug' ] ) {
                    case 'gravatar' :
                    case 'user_image' :
                    case 'bg_image' :
                    case 'movie_thumbnail' :
                        if ( $part[ 'slug' ] === 'movie_thumbnail' ) {
                            $post_items[] = isset( $part[ 'option' ][ 'thumbnail-type' ] ) && $part[ 'option' ][ 'thumbnail-type' ] !== '' ? $part[ 'option' ][ 'thumbnail-type' ] : 'user_image';
                        }
                        if ( isset( $part[ 'option' ][ 'srcset' ] ) && $part[ 'option' ][ 'srcset' ] === '1' ) {
                            $part_option[ $part[ 'slug' ] ][ 'srcset' ] = 'srcset';
                        } else {
                            if ( isset( $part[ 'option' ][ 'thumbnail-size' ] ) && $part[ 'option' ][ 'thumbnail-size' ] !== '' ) {
                                $part_option[ $part[ 'slug' ] ][ $part[ 'option' ][ 'thumbnail-size' ] ] = $part[ 'option' ][ 'thumbnail-size' ];
                            } else {
                                if ( $part[ 'slug' ] === 'gravatar' ) {
                                    $part_option[ $part[ 'slug' ] ][ '150' ] = '150';
                                } else {
                                    $part_option[ $part[ 'slug' ] ][ 'thumbnail' ] = 'thumbnail';
                                }
                            }
                        }
                        break;
                    case 'user_sns' :
                        foreach( (array)$sns_list as $sns ) {
                            if ( isset( $part[ 'option' ][ $sns ] ) && $part[ 'option' ][ $sns ] === '1' ) {
                                $part_option[ $part[ 'slug' ] ][ $sns ] = $sns;
                            }
                        }
                        break;
                }
            }
        }
        $post_items = array_unique( $post_items );
        $post_items = array_diff( $post_items, array( 'name', 'description' ) );
    }
    if ( is_array( $post_items ) && count( $post_items ) < 1 ) {
        $part_option = false;
        $post_items = array( 'gravatar', 'user_image', 'bg_image', );
    }
    $result[ 'area' ] = $area_items;
    $part = front_part_author_profile( $author_id, $post_items, $part_option );
    $part[ 'name' ] = isset( $post_summary[ 'author' ][ 'name' ] ) ? $post_summary[ 'author' ][ 'name' ] : '';
    $part[ 'description' ] = isset( $post_summary[ 'author' ][ 'description' ] ) ? $post_summary[ 'author' ][ 'description' ] : '';
    $result[ 'userList' ][] = array(
        'part' => $part,
        'url' => $part[ 'url' ],
    );
    return $result;
}

/*
 * 関連記事
*/
function front_main_part_post_recommend( $summary ) {
    extract( $summary );
    if ( $parts[ 'slug' ] !== 'single-recommend' || !$front_summary[ 'post_summary' ] ) return false;
    $post_summary = $front_summary[ 'post_summary' ];

    $result = array();
    $option = isset( $parts[ 'option' ] ) ? $parts[ 'option' ] : array();
    $args = array(
        'post_status' => 'publish',
        'ignore_sticky_posts' => 1,
        'posts_per_page' => isset( $option[ 'post-count' ] ) && $option[ 'post-count' ] !== '' ? $option[ 'post-count' ] : 5,
        'offset' => isset( $option[ 'offset' ] ) && $option[ 'offset' ] !== '' ? ( (int)$option[ 'offset' ] - 1 ) : 0,
        'point-class' => isset( $option[ 'point-class' ] ) ? $option[ 'point-class' ] : array(),
    );
    
    //関連する記事設定
    $recommend = isset( $option[ 'recommend' ] ) ? explode( ',', $option[ 'recommend' ] ) : array();
    if ( !is_array( $recommend ) || ( is_array( $recommend ) && count( $recommend ) < 1 ) ) {
        $recommend = array( 'category' );
    }
    
    /* 記事編集画面で設定した関連記事がある場合優先する */
    if ( in_array( 'author', $recommend, true ) !== true && isset( $post_summary[ 'postMeta' ][ 'dg_recommend_post' ] ) && $post_summary[ 'postMeta' ][ 'dg_recommend_post' ] !== '' ) {
        $args[ 'post__in' ] = array_diff( explode( ',', $post_summary[ 'postMeta' ][ 'dg_recommend_post' ] ), array( $post_summary[ 'postId' ] ) );
    } else {
        $args[ 'post__not_in' ] = array( $post_summary[ 'postId' ] );
        if ( in_array( 'author', $recommend, true ) === true ) {
            $args[ 'author' ] = $post_summary[ 'user_id' ];
        }
        $relation = isset( $option[ 'relation' ] ) ? $option[ 'relation' ] : 'OR';
        $args[ 'tax_query' ][ 'relation' ] = $relation;
        foreach( (array)$recommend as $tax ) {
            if ( isset( $post_summary[ 'taxonomy' ][ $tax ] ) && is_array( $post_summary[ 'taxonomy' ][ $tax ] ) && count( $post_summary[ 'taxonomy' ][ $tax ] ) > 0 ) {
                $terms = array_column( $post_summary[ 'taxonomy' ][ $tax ], 'term_id' );
                $args[ 'tax_query' ][] = array(
                    'taxonomy' => $tax,
                    'field' => 'term_id',
                    'terms' => $terms,
                );
            }
        }
    }
    //表示順番
    $args[ 'order' ] = isset( $option[ 'order' ] ) ? $option[ 'order' ] : 'DESC';
    if ( isset( $option[ 'order-by' ] ) && ( $option[ 'order-by' ] === 'views' || $option[ 'order-by' ] === 'w_views' || $option[ 'order-by' ] === 'm_views' || $option[ 'order-by' ] === 'y_views' || $option[ 'order-by' ] === 'evaluate' ) ) {
        if ( $option[ 'order-by' ] === 'evaluate' ) {
            $args[ 'meta_key' ] = 'evaluate_total';
        } else {
            $args[ 'meta_key' ] = $option[ 'order-by' ];
        }
        $args[ 'orderby' ] = 'meta_value_num';
    } else {
        $args[ 'orderby' ] = isset( $option[ 'order-by' ] ) ? $option[ 'order-by' ] : 'date';
    }
    
    $query = new WP_Query( $args );
    return part_taxonomy_post_list( $query, $parts, $today );
}