<?php
/*
 * エディター用スクリプト
*/
add_action( 'enqueue_block_editor_assets', 'add_custom_block_style_script' );
function add_custom_block_style_script() {
    global $post;
    $directory_url = get_template_directory_uri();
    wp_enqueue_script( 'jquery-ui-droppable' );
    $wp_js = array( 'wp-dom-ready', 'wp-edit-post', 'lodash', 'wp-rich-text','wp-element','wp-components', 'wp-blocks', 'wp-editor', 'wp-keycodes', 'wp-i18n', 'wp-data', 'wp-core-data', 'wp-block-editor', 'wp-block-directory' );
    wp_enqueue_script( 'add-post-editor-block-script', $directory_url . '/wp-admin/post/add-post-editor-block.js', $wp_js, '', true );
    //JS翻訳スクリプト追加
    wp_set_script_translations( 'add-post-editor-block-script', 'dg-style', get_template_directory() . '/languages' );
    //記事タイプ別CSS適用
    if ( $post->post_type === 'dg_patterns' ) {
        $css_name = 'editor-single-post-style.css';
    } else {
        $css_name = 'editor-single-' . $post->post_type . '-style.css';
    }
    $upload_dir = wp_upload_dir();
    $directory_path_editor_css = $upload_dir[ 'basedir' ] . '/design-json/editor-css/' . $css_name;
    $directory_uri_editor_css = $upload_dir[ 'baseurl' ] . '/design-json/editor-css/' . $css_name;
    if ( file_exists( $directory_path_editor_css ) ) {
        wp_enqueue_style( 'dg-style-editor-style', $directory_uri_editor_css );
    }
}

/*
 * DG-STYLE専用カテゴリー追加
*/
add_filter( 'block_categories', 'add_editor_block_categories', 10, 2 );
function add_editor_block_categories( $categories, $post ) {
    return array_merge(
        array(
            array(
                'slug' => 'dg-style-page',
                'title' => 'DG-STYLE ' . __( 'ページコンテンツ', 'dg-style' ),
                'icon'  => 'dashicons-layout',
            ),
        ),
        $categories
    );
}

/*
 * テーマサポート
*/
add_theme_support( 'align-wide' );//ワイドイメージ
add_theme_support( 'dark-editor-style' );

/*
 * ブロックスタイル追加
*/
add_action( 'init', 'add_custom_block_style' ); 
function add_custom_block_style() {
    if ( !is_admin() ) {
        return;
    }
    /*
     * エディター色設定
    */
    $upload_dir = wp_upload_dir();
    $design_path = $upload_dir[ 'basedir' ] . '/design-json/template/color.json';
    $color_value = false;
    if ( is_file( $design_path ) ) {
        $part_file = '';
        require_once( ABSPATH . 'wp-admin/includes/file.php' );
        if ( WP_Filesystem() ) {
            global $wp_filesystem;
            $part_file = $wp_filesystem->get_contents( $design_path );
            $color_value = json_decode( $part_file, true );
        }
    }
    $editor_color_palette = get_option( 'DG_site_editor_colors', false );
    if ( $editor_color_palette !== false ) {
        add_theme_support( 'editor-color-palette', $editor_color_palette );
    } elseif ( $color_value !== false ) {
        $editor_color_palette = array();
        if ( isset( $color_value[ 'select' ] ) && isset( $color_value[ 'palette' ][ $color_value[ 'select' ] ] ) ) {
            $palette = $color_value[ 'palette' ][ $color_value[ 'select' ] ];
            foreach( (array)$palette as $key => $code ) {
                $editor_color_palette[] = array(
                    'name' => $key . __( '色', 'dg-style' ),
                    'slug' =>  'post-' . preg_replace( '/([0-9])/', '-$1', $key ),
                    'color' => $code,
                );
            }
        }
        if ( isset( $color_value[ 'colorset' ] ) && is_array( $color_value[ 'colorset' ] ) && count( $color_value[ 'colorset' ] ) > 0 ) {
            foreach( (array)$color_value[ 'colorset' ] as $key => $code ) {
                $editor_color_palette[] = array(
                    'name' => $code[ 'name' ] . __( '色', 'dg-style' ),
                    'slug' =>  'post-' . $key,
                    'color' => $code[ 'color' ],
                );
            }
        }
        add_theme_support( 'editor-color-palette', $editor_color_palette );
    }
}

/*
 * サーバーレンダリング用コード
*/
add_action( 'init', 'add_custom_block_type' ); 
function add_custom_block_type() {
    if ( function_exists( 'register_block_type' ) ) {
        //記事本文
        register_block_type(
            'dg-style/onepost',
            array(
                'apiVersion' => 2,
                'attributes' => array(
                    'post_id' => array(
                        'type' => 'string'
                    ),
                    'postType' => array(
                        'type' => 'string',
                        'default' => 'post',
                    ),
                    'keyword' => array(
                        'type' => 'string',
                    ),
                    'className' => array(
                        'type' => 'string',
                    ),
                ),
                'render_callback' => 'render_dgstyle_onepost'//サーバーレンダリング
            )
        );
        //お問い合わせ
        register_block_type(
            'dg-style/contact',
            array(
                'apiVersion' => 2,
                'attributes' => array(
                    'post_id' => array(
                        'type' => 'string'
                    ),
                    'keyword' => array(
                        'type' => 'string',
                    ),
                    'className' => array(
                        'type' => 'string',
                    ),
                ),
                'render_callback' => 'render_dgstyle_contact'//サーバーレンダリング
            )
        );
        //記事リスト
        register_block_type(
            'dg-style/post-list',
            array(
                'apiVersion' => 2,
                'attributes' => array(
                    'type' => array(
                        'type' => 'string',
                        'default' => '1',
                    ),
                    'option' => array(
                        'type' => 'string',
                    ),
                    'post' => array(
                        'type' => 'string',
                    ),
                    'design' => array(
                        'type' => 'string',
                    ),
                    'title' => array(
                        'type' => 'string',
                    ),
                    'className' => array(
                        'type' => 'string',
                    ),
                ),
                'render_callback' => 'render_dgstyle_post_list'//サーバーレンダリング
            )
        );
        //広告
        register_block_type(
            'dg-style/script',
            array(
                'apiVersion' => 2,
                'attributes' => array(
                    'select' => array(
                        'type' => 'string'
                    ),
                    'lazyloadFlg' => array(
                        'type' => 'string'
                    ),
                    'className' => array(
                        'type' => 'string',
                    ),
                ),
                'render_callback' => 'render_dgstyle_ad'//サーバーレンダリング
            )
        );
    }
}
/*
 * 記事取得
*/
function render_dgstyle_ad( $attributes ) {
    $class = isset( $attributes[ 'className' ] ) ? ' ' . $attributes[ 'className' ] : '';
    $content = '';
    if ( isset( $attributes[ 'select' ] ) && $attributes[ 'select' ] !== '' ) {
        $adsense_block = get_option( 'DG_adsense_block', false );
        if ( $adsense_block !== false ) {
            $adsense_block = json_decode( wp_unslash( $adsense_block ), true );
            if ( isset( $adsense_block[ $attributes[ 'select' ] ][ 'script' ] ) && $adsense_block[ $attributes[ 'select' ] ][ 'script' ] !== '' ) {
                $content = urldecode( $adsense_block[ $attributes[ 'select' ] ][ 'script' ] );
            }
        }
        if ( $content === '' ) {
            $content = __( '広告スクリプトコードが空欄の為、表示できません。', 'dg-style' );
        }
    } else {
        $content = __( '広告を選択してください。', 'dg-style' );
    }
    return '<div class="wp-block-adsense' . $class . '">' . $content . '</div>';
}

/*
 * 記事取得
*/
function render_dgstyle_onepost( $attributes ) {
    $class = isset( $attributes[ 'className' ] ) ? ' ' . $attributes[ 'className' ] : '';
    $content = '';
    if ( isset( $attributes[ 'post_id' ] ) && $attributes[ 'post_id' ] !== '' ) {
        $post = get_post( $attributes[ 'post_id' ] );
        $content = $post->post_content;
        $content = apply_filters( 'the_content', $content );
        $content = str_replace( ']]>', ']]&gt;', $content );
    } else {
        $class .= ' no-select';
        $content = __( '記事を選択してください。', 'dg-style' );
    }
    return '<div class="one-post-inner wp-block-dg-style-onepost' . $class . '">' . $content . '</div>';
}

/*
 * 記事取得
*/
function render_dgstyle_contact( $attributes ) {
    $class = isset( $attributes[ 'className' ] ) ? ' ' . $attributes[ 'className' ] : '';
    $content = '';
    $post_id = '';
    if ( isset( $attributes[ 'post_id' ] ) && $attributes[ 'post_id' ] !== '' ) {
        $post = get_post( $attributes[ 'post_id' ] );
        $content = $post->post_content;
        $post_id = $attributes[ 'post_id' ];
    } else {
        $class .= ' no-select';
        $content = __( 'お問い合わせフォームを選択してください。', 'dg-style' );
    }
    $dg_contact = wp_create_nonce( 'dg_contact' . $post_id );
    return '<form method="post" data-form="' . $post_id . '" class="dg-contact-form wp-block-dg-style-contact' . $class . '" data-nonce="' . $dg_contact . '">' . $content . '<div class="dg-contact-message"></div></form>';
}

/*
 * 記事取得
*/
function render_dgstyle_post_list( $attributes ) {
    $class = isset( $attributes[ 'className' ] ) ? ' ' . $attributes[ 'className' ] : '';
    $content = '';
    $title = array(
        'text' => isset( $attributes[ 'title' ] ) ? $attributes[ 'title' ] : '',
        'span' => '2',
        'tag' => 'div',
    );
    $design = isset( $attributes[ 'design' ] ) && $attributes[ 'design' ] !== '' ? json_decode( $attributes[ 'design' ], true ) : array();
    $option = isset( $attributes[ 'option' ] ) && $attributes[ 'option' ] !== '' ? json_decode( $attributes[ 'option' ], true ) : array();
    if ( !isset( $option[ 'post-count' ] ) ) {
        $option[ 'post-count' ] = 3;
    }
    $option[ 'article_tag' ] = 'div';
    $option[ 'area' ] = array(
        'all' => array( 'slug' => 'area' ),
        'thumbnail-1' => array(
            'slug' => 'thumbnail',
            'parent' => 'all',
            'option' => array(
                'thumbnail-size' => 'full',
                'srcset' => '1',
                'width' => '150',
                'height' => '150',
                'nolazy' => true,
            )
        ),
        'inner' => array(
            'slug' => 'area',
            'parent' => 'all',
        ),
        'more-2' => array(
            'slug' => 'more',
            'parent' => 'all',
            'option' => array(
                'text' => '',
                'class' => '',
            )
        ),
        'title-3' => array(
            'slug' => 'title',
            'parent' => 'inner',
            'option' => array(
                'tag' => 'p',
                'count' => '',
                'after' => '',
                'link' => '',
            )
        ),
        'content-4' => array(
            'slug' => 'content',
            'parent' => 'inner',
            'option' => array(
                'count' => '80',
                'after' => '',
                'link' => '',
            )
        ),
        'tax-category-5' => array(
            'slug' => 'tax-category',
            'parent' => 'inner',
        ),
        'tax-post_tag-6' => array(
            'slug' => 'tax-post_tag',
            'parent' => 'inner',
        ),
        'meta' => array(
            'slug' => 'area',
            'parent' => 'inner',
        ),
        'author-7' => array(
            'slug' => 'author',
            'parent' => 'meta',
            'option' => array()
        ),
        'date-8' => array(
            'slug' => 'date',
            'parent' => 'meta',
            'option' => array(
                'format' => 'Y.m.d',
                'tag' => 'time',
                'type' => 'date',
                'days' => '1',
            )
        ),
    );
    if ( isset( $design[ 'thumbnail' ] ) && $design[ 'thumbnail' ] === '1' ) {
        unset( $option[ 'area' ][ 'thumbnail-1' ] );
    }
    if ( isset( $design[ 'content' ] ) && $design[ 'content' ] === '1' ) {
        unset( $option[ 'area' ][ 'content-4' ] );
    }
    if ( isset( $design[ 'category' ] ) && $design[ 'category' ] === '1' ) {
        unset( $option[ 'area' ][ 'tax-category-5' ] );
    }
    if ( isset( $design[ 'post_tag' ] ) && $design[ 'post_tag' ] === '1' ) {
        unset( $option[ 'area' ][ 'tax-post_tag-6' ] );
    }
    if ( isset( $design[ 'author' ] ) && $design[ 'author' ] === '1' ) {
        unset( $option[ 'area' ][ 'author-7' ] );
    }
    if ( isset( $design[ 'date' ] ) && $design[ 'date' ] === '1' ) {
        unset( $option[ 'area' ][ 'date-8' ] );
    }
    if ( isset( $design[ 'date' ] ) && $design[ 'date' ] === '1' && isset( $design[ 'author' ] ) && $design[ 'author' ] === '1' ) {
        unset( $option[ 'area' ][ 'meta' ] );
    }
    $testab = get_query_var( 'testab' );
    if ( get_option( 'DG_site_design_' . $testab, '' ) === '' ) {
        $testab = '';
    }
    $image_option = get_option( 'DG_image_option' . $testab, false );
    if ( $image_option !== false ) {
        $image_option = json_decode( $image_option, true );
    } else {
        $stylesheet_url = get_template_directory_uri();
        $image_option = array(
            'noImage' => $stylesheet_url . '/image/no-image.gif',
            'loadingImg' => $stylesheet_url . '/image/loading.gif',
        );
    }
    $option[ 'part-class' ] = 'wp-block-dg-style-post-list' . $class;
    if ( isset( $design[ 'type' ] ) && $design[ 'type' ] === '2' ) {
        $option[ 'part-class' ] .= ' column col' . ( isset( $design[ 'column' ] ) ? $design[ 'column' ] : '3' );
    }
    $today = new DateTime( wp_date( 'Y-m-d H:i:s' ) );
    if ( $attributes[ 'type' ] === '1' ) {
        $option[ 'part-class' ] .= ' recommend-post-list';
        $post = isset( $attributes[ 'post' ] ) && $attributes[ 'post' ] !== '' ? json_decode( $attributes[ 'post' ], true ) : array();
        $post[ 'postMeta' ][ 'dg_recommend_post' ] = get_post_meta( $post[ 'postId' ], 'dg_recommend_post', true );
        $option = front_main_part_post_recommend( array( 'parts' => [ 'slug' => 'single-recommend', 'option' => $option, ], 'front_summary' => [ 'post_summary' => $post ], 'today' => $today ) );
        $content = create_post_list_part( array( 'title' => $title, 'option' => $option, 'slug' => 'post_list' ), $image_option );
    } elseif ( $attributes[ 'type' ] === '2' ) {
        $option = part_post_list( array( 'parts' => [ 'option' => $option, 'slug' => 'post_list' ], 'today' => $today ) );
        $content = create_post_list_part( array( 'title' => $title, 'option' => $option, 'slug' => 'post_list' ), $image_option );
    }
    return $content;
}

/*
 * Gutenbergパターン
*/
add_action( 'init', 'add_dg_style_post_type_patterns' );
function add_dg_style_post_type_patterns() {
    $labels = array(
        'name' => __( 'Gutenbergパターン', 'dg-style' ),
        'singular_name' => __( 'Gutenbergパターン', 'dg-style' ),
        'menu_name' => __( 'Gutenbergパターン', 'dg-style' ),
        'name_admin_bar' => __( 'Gutenbergパターン', 'dg-style' ),
        'add_new' => __( '新規追加', 'dg-style' ),
        'add_new_item' => __( 'Gutenbergパターン追加', 'dg-style' ),
        'new_item' => __( '新しいGutenbergパターン', 'dg-style' ),
        'edit_item' => __( 'Gutenbergパターン修正', 'dg-style' ),
        'view_item' => __( 'Gutenbergパターン表示', 'dg-style' ),
        'all_items' => __( 'Gutenbergパターン一覧', 'dg-style' ),
        'search_items' => __( '検索', 'dg-style' ),
        'not_found' => __( 'Gutenbergパターンが見つかりません。', 'dg-style' ),
        'not_found_in_trash' => __( 'ゴミ箱にGutenbergパターンが見つかりません。', 'dg-style' )
    );
    $args = array(
        'labels' => $labels,
        'menu_icon' => 'dashicons-images-alt2',
        'public' => false,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_rest' => true,
        'query_var' => false,
        'rewrite' => false,
        'capability_type' => 'page',
        'capabilities' => array(
            'edit_post' => 'edit_others_posts',
            'read_post' => 'edit_others_posts',
            'delete_post' => 'edit_others_posts',
            'edit_posts' => 'edit_others_posts',
            'edit_others_posts' => 'edit_others_posts',
            'publish_posts' => 'edit_others_posts',
            'read_private_posts' => 'edit_others_posts',
        ),
        'hierarchical' => false,
        'menu_position' => null,
        'supports' => array( 'title', 'editor' )
    );
    register_post_type( 'dg_patterns', $args );
    
    $tax = array(
        'label' => __( 'パターン分類', 'dg-style' ),
        'labels' => array(
            'popular_items' => 'よく使うパターン分類',
            'edit_item' =>'パターン分類を編集',
            'add_new_item' => '新規パターン分類を追加',
            'search_items' => 'パターン分類を検索'
        ),
        'public' => false,
        'rewrite' => false,
        'description' => 'Gutenbergパターンのカテゴリーになります。',
        'hierarchical' => false,
        'show_in_rest' => true,
        'show_ui' => true,
        'show_tagcloud' => false,
    );
    register_taxonomy( 'patterns_type', 'dg_patterns', $tax );
}

add_action( 'init', 'set_dg_style_block_patterns' );
function set_dg_style_block_patterns() {
    if ( class_exists( 'WP_Block_Patterns_Registry' ) ) {
        //パターンカテゴリー設定
        $args = array(
            'orderby' => 'id',
            'hide_empty' => true,
            'parent' => 0
        );
        $terms = get_terms( 'patterns_type', $args );
        if ( !empty( $terms ) && !is_wp_error( $terms ) ) {
            foreach ( $terms as $term ) {
                register_block_pattern_category( $term->slug, array(
                    'label' => $term->name,
                ));
            }
        }
        
        $args = array(
            'post_type' => 'dg_patterns',
            'orderby' => 'date',
            'post_status' => 'publish',
            'order' => 'DESC',
            'posts_per_page' => -1,
        );
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) {
            while ( $query->have_posts() ) {
                $query->the_post();
                $post = $query->post;
                $terms = get_the_terms( $post->ID, 'patterns_type' );
                $terms_list = array();
                if ( !empty( $terms ) ) {
                    foreach( (array)$terms as $term ) {
                        $terms_list[] = $term->slug;
                    }
                }
                register_block_pattern( 'dg-style/pattern' . $post->ID, array(
                    'title' => $post->post_title,
                    'description' => '',
                    'content' => $post->post_content,
                    'categories' => $terms_list,
                ));
            }
            wp_reset_postdata();
        }
    }
}