const currentUrl = location.href;
if ( !currentUrl.match( /(^.*\/wp-admin\/.*|^.*\/wp-login.php.*|^.*[\?&]preview=true.*$|.+\wp-json\/wp\/v2\/.+)/ ) ) {
    const PWACACHESTATIC = 'static-v1';
    const PWACACHEDYNAMIC = 'dynamic-v1';
    /* サービスワーカーのインストール */
    self.addEventListener( 'install', function( event ) {
        if ( event.request !== undefined && event.request.method !== undefined && event.request.method === 'GET' && !event.request.url.match( /(^.*\/wp-admin\/.*|^.*\/wp-login.php.*|^.*[\?&]preview=true.*$|.+\wp-json\/wp\/v2\/.+)/ ) ) {
            /*console.log( '[Service Worker] Installing Service Worker...' );*/
            /* キャッシュできるまで次の処理を待つ */
            event.waitUntil(
                caches.open( PWACACHESTATIC ).then(function( cache ) {
                    /*console.log( '[Service Worker] Precaching App...' );*/
                    /* 何でもキャッシュできる。cssとかの中で更にリクエストが発生する場合は、動的にキャッシュする必要がある（後述）*/
                    cache.addAll( [ '/' ] );
                })
            );
        }
    });
    self.addEventListener( 'fetch', function( event ) {
        /* 管理画面関連は除外する */
        if ( event.request.headers.has( 'range' ) ) {
            return;
        }
        if ( event.request !== undefined && event.request.method !== undefined && event.request.method === 'GET' && !event.request.url.match( /(^.*\/wp-admin\/.*|^.*\/wp-login.php.*|^.*[\?&]preview=true.*$|.+\wp-json\/wp\/v2\/.+)/ ) ) {
            /*console.log( '[Service Worker] Fetching something ...' );*/
            event.respondWith(
                /*キャッシュの存在チェック*/
                caches.match( event.request ).then(function( response ) {
                    if ( response ) {
                        return response;
                    } else {
                        /* キャッシュがなければリクエストを投げて、レスポンスをキャッシュに入れる */
                        return fetch( event.request ).then(function( res ) {
                            return caches.open( PWACACHEDYNAMIC ).then(function( cache ) {
                                /* 最後に res を返せるように、ここでは clone() する必要がある */
                                cache.put( event.request.url, res.clone() );
                            return res;
                            })
                        })
                        .catch(function() {
                            /* エラーが発生しても何もしない */
                        });
                    }
                })
            );
        }
    });

    self.addEventListener( 'activate', function( event ) {
        /*console.log( '[Service Worker] Activating Service Worker...' );*/
        clients.claim();
        event.waitUntil(
            caches.keys().then(function( keyList ) {
                return Promise.all( keyList.map(function( key ) {
                    if ( key !== PWACACHESTATIC && key !== PWACACHEDYNAMIC ) {
                        /*console.log( '[Service Worker] Removing old cache...' );*/
                        return caches.delete( key );
                    }
                }));
            })
        );
        return self.clients.claim();
    });
    self.addEventListener( 'controllerchange', function(evt) {
        self.controller = navigator.serviceWorker.controller;
    });
    /* メッセージ受信時の処理 */
    self.addEventListener( 'message', function( e ) {
        switch ( e.data[ 'command' ] ) {
            case 'clearCacheAll':
                /*全キャッシュをクリアする*/
                this.console.log( 'all cache clear' );
                e.waitUntil(
                    caches.keys().then(function( names ) {
                        for ( let name of names ){
                            caches.delete( name );
                        }
                    })
                );
            break;
            case 'getCache':
                /* URLリストのキャッシュを取得する */
                e.waitUntil(
                    caches.open( CACHE_NAME ).then( function( cache ) {
                        this.console.log( e.data[ 'files' ] );
                        /* 指定されたリソースをキャッシュに追加する */
                        return cache.addAll( e.data[ 'files' ] );
                    })
                );
            break;
        };
    });
}