<?php
/*
 * 新規デザイン保存
*/
add_action( 'wp_ajax_save_new_site_design', 'save_new_site_design' );
add_action( 'wp_ajax_nopriv_save_new_site_design', 'save_new_site_design' );
function save_new_site_design( $type = false ) {
    //ログイン情報で判定
    if ( !is_user_logged_in() || ( !current_user_can( 'administrator' ) && !current_user_can( 'editor' ) ) ) {
        if ( isset( $_POST[ 'name' ] ) ) {
            echo json_encode( array( 'result' => 'logout' ) );
            exit();
        } else {
            return false;
        }
    }
    //nonceによる判定
    if ( isset( $_POST[ 'name' ] ) ) {
        $nonce_result = wp_verify_nonce( $_POST[ 'siteBuilderNonce' ], 'site_builder_nonce' );
        if ( !$nonce_result ) {
            echo json_encode( array( 'result' => 'nonce' ) );
            exit();
        }
    }
    require_once( ABSPATH . 'wp-admin/includes/file.php' );
    if ( WP_Filesystem() ) {
        global $wp_filesystem;
        if ( isset( $_POST[ 'name' ] ) || $type !== false ) {
            if ( isset( $_POST[ 'name' ] ) ) {
                $design_name = $_POST[ 'name' ];
            } elseif ( $type !== false ) {
                $design_name = $type;
            }
            $save_value = '';
            if ( isset( $_POST[ 'value' ] ) ) {
                $save_value = stripslashes( rawurldecode( $_POST[ 'value' ] ) );
            }
            if ( isset( $_POST[ 'first' ] ) ) {
                //CSS
                $color_input_value = htmlspecialchars( '{"palette":{"palette-1":{"label":"palette01","main":"#E63946","base":"#F1FAEE","text":"#141414","sub1":"#457B9D","sub2":"#1D3557"},"palette-2":{"label":"palette02","main":"#14213D","base":"#fff","text":"#000","sub1":"#FCA311","sub2":"#E5E5E5"},"palette-3":{"label":"palette03","main":"#f4acb7","base":"#ffe5d9","text":"#474747","sub1":"#d8e2dc","sub2":"#ffcad4"},"palette-4":{"label":"palette04","main":"#2ec4b6","base":"#fdfffc","text":"#011627","sub1":"#e71d36","sub2":"#ff9f1c"},"palette-5":{"label":"palette05","main":"#0a2463","base":"#fffaff","text":"#1e1b18","sub1":"#3e92cc","sub2":"#d8315b"},"palette-6":{"label":"palette06","main":"#ff6b35","base":"#efefd0","text":"#141414","sub1":"#f7c59f","sub2":"#004e89"},"palette-7":{"label":"palette07","main":"#c0b9dd","base":"#f7f4ea","text":"#141414","sub1":"#80a1d4","sub2":"#75c9c8"}},"select":"palette-1","colorset":{"color-1":{"color":"#fff","name":"white"},"color-2":{"color":"#000","name":"black"},"color-3":{"color":"#ccc","name":"gray"},"color-4":{"color":"#11abe8","name":"link"},"color-5":{"color":"#e81311","name":"active"},"color-6":{"color":"#e411e8","name":"visited"},"color-7":{"color":"#f3f2f2","name":"white-gray"},"color-8":{"color":"rgba(255,255,255,0.3)","name":"\u767d\u900f\u660e"},"color-9":{"color":"#1DA1F2","name":"twitter"},"color-10":{"color":"#3B5998","name":"facebook"},"color-11":{"color":"#BD081C","name":"pinterest"},"color-12":{"color":"#00c300","name":"line"},"color-13":{"color":"rgba(0,0,0,0.8)","name":"\u900f\u660e\u9ed2"},"color-14":{"color":"#00a4de","name":"hatebu"},"color-15":{"color":"#9d9d9d","name":"dark-gray"},"color-16":{"color":"#ef4155","name":"pocket"},"color-17":{"color":"#011835","name":"tumblr"}}}', ENT_QUOTES, 'UTF-8' );
                $color_value = json_decode( htmlspecialchars_decode( $color_input_value ), true );
                //アニメーション
                $template_value = htmlspecialchars( '{"anime-0":{"label":"\u62e1\u5927","design":{"css-0":{"order":"1","category":"all","selector":"0%","design":"transform:scale(1);","label":"0%"},"css-1":{"order":"2","category":"all","selector":"100%","design":"transform:scale(1.2);","label":"100%"}},"select":true},"anime-1":{"label":"\u53f3\u304b\u3089\u30b9\u30e9\u30a4\u30c9","design":{"css-0":{"order":"1","category":"all","label":"0%","selector":"0%","design":"position:relative;left:50%;opacity:0;"},"css-1":{"order":"2","category":"all","label":"100%","selector":"100%","design":"left:0%;opacity:1;"}},"select":true},"anime-2":{"label":"\u80cc\u666f\u30b9\u30e9\u30a4\u30c9","design":{"css-0":{"order":"0","category":"all","label":"0%","design":"transform:translateX(-25%);","selector":"0%"},"css-1":{"order":"1","category":"all","design":"transform:translateX(25%);","selector":"100%","label":"100%"}},"select":true},"anime-3":{"label":"\u4e0b\u304b\u3089\u4e0a\u3078","design":{"css-0":{"order":"0","category":"all","label":"0%","selector":"0%","design":"transform:translateY(100px);opacity:0;"},"css-1":{"order":"1","category":"all","label":"100%","selector":"100%","design":"transform:translateY(0);opacity:1;"}},"select":true},"anime-5":{"label":"\u4e0a\u304b\u3089\u4e0b\u3078\uff12","design":{"css-0":{"order":"0","category":"all","label":"0%","selector":"0%","design":"opacity:0;margin-top:50px;"},"css-1":{"order":"1","category":"all","label":"100%","selector":"100%","design":"opacity:1;margin-top:0;"}},"select":true},"anime-6":{"label":"\u30d1\u30fc\u30c7\u30a3\u30f3\u30b0\uff12","design":{"css-0":{"order":"0","category":"all","label":"0%","selector":"0%","design":"padding:0;"},"css-1":{"order":"1","category":"all","label":"100%","selector":"100%","design":"padding:50px;"}},"select":true},"anime-7":{"label":"\u30d1\u30fc\u30c7\u30a3\u30f3\u30b0","design":{"css-0":{"order":"0","category":"all","label":"0%","selector":"0%","design":"padding:0;"},"css-1":{"order":"1","category":"all","label":"100%","selector":"100%","design":"padding:25px;"}},"select":true}}', ENT_QUOTES, 'UTF-8' );
                $template_list = json_decode( htmlspecialchars_decode( $template_value ), true );
                $initial_value = array(
                    'ORIGINALCOLOR' => $color_value,
                    'ORIGINALANIMATION' => $template_list,
                    'ORIGINALDEVICE' => array( 320 => 'sp', 560 => 'tb', 960 => 'pc' ),
                    'ORIGINALLOGO' => array(),
                    'ORIGINALNOIMAGE' => array(),
                    'ORIGINALLOADING' => array(),
                    'ORIGINALFIXED' => array(),
                    'ORIGINALFONT' => array(),
                );
                $save_value = rawurldecode( json_encode( $initial_value ) );
            }
            //テンプレート保存
            if ( isset( $_POST[ 'template' ] ) ) {
                save_part_template_design( $_POST[ 'template' ] );
            }
            //共通オプション保存
            if ( isset( $_POST[ 'common' ] ) ) {
                save_part_common_option( $_POST[ 'common' ] );
            }
            //キャッシュ削除
            delete_all_transients();
            //DG-STYLEバージョン保存
            $theme = wp_get_theme( get_template() );
            update_option( 'DG_STYLE_VERSION', $theme->Version );
            
            //保存
            $license_key = get_option( 'DG_license_key', '' );
            $license_type = get_option( 'DG_license_type', '' );
            if ( isset( $_POST[ 'lp' ] ) ) {
                if ( $license_key !== '' && $license_type !== '' ) {
                    $post_id = $design_name;
                    $custom_meta = isset( $_POST[ 'postMeta' ] ) ? stripslashes( rawurldecode( $_POST[ 'postMeta' ] ) ) : '';
                    //同じキーが重複してある場合削除する
                    $double_list = array(
                        'views',
                        'w_views',
                        'm_views',
                        'y_views',
                        'evaluate_total',
                        'evaluate_table',
                        'dg_bookmark',
                        'site_builder',
                        'dg_meta',
                        'DG_site_sub_value',
                        'DG_script_option',
                    );
                    foreach( (array)$double_list as $key ) {
                        $postmeta = get_post_meta( $post_id, $key, false );
                        if ( is_array( $postmeta ) && count( $postmeta ) > 1 ) {
                            $meta_value = $postmeta[ 0 ];
                            delete_post_meta( $post_id, $key );
                            update_post_meta( $post_id, $key, $meta_value );
                        }
                    }
                    update_post_meta( $post_id, 'site_builder', wp_slash( $save_value ) );
                    update_post_meta( $post_id, 'dg_meta', wp_slash( $custom_meta ) );
                    update_post_meta( $post_id, '_thumbnail_id', $_POST[ 'thumbnail' ] );
                    $post_title = isset( $_POST[ 'lpTitle' ] ) ? $_POST[ 'lpTitle' ] : '';
                    $post_name = isset( $_POST[ 'lpUrl' ] ) ? $_POST[ 'lpUrl' ] : '';
                    $post_status = isset( $_POST[ 'status' ] ) ? $_POST[ 'status' ] : '';
                    $complate = create_main_design_set( $post_id, $save_value, false, array( 'ID' => $post_id, 'post_title' => $post_title, 'post_name' => $post_name, 'post_status' => $post_status ) );
                }
            } else {
                $upload_dir = wp_upload_dir();
                $directory_path = $upload_dir[ 'basedir' ] . '/design-json';
                if ( !file_exists( $directory_path ) ) {
                    if ( !mkdir( $directory_path, 0777, true ) ) {
                        if ( isset( $_POST[ 'name' ] ) ) {
                            echo json_encode( array( 'result' => false ) );
                            exit();
                        } else {
                            return false;
                        }
                    }
                }
                $design_file = $directory_path . '/' . $design_name . '.json';
                $wp_filesystem->put_contents( $design_file, mb_convert_encoding( $save_value, 'UTF-8' ) );
                $site_design = get_option( 'DG_site_design', '' );
                if ( $site_design === '' ) {
                    $site_design = 'default';
                    update_option( 'DG_site_design', $site_design );
                }
                $complate = true;
                //適用でデザインと保存デザインが同じ場合、上書き
                if ( $site_design === $design_name ) {
                    $complate = create_main_design_set( $_POST[ 'name' ], $save_value );
                }
            }
            //ABテスト用デザインの場合
            if ( isset( $_POST[ 'testType' ] ) && $_POST[ 'testType' ] !== '' && $license_key !== '' && $license_type !== '' ) {
                $complate = create_main_design_set( $_POST[ 'name' ], $save_value, $_POST[ 'testType' ] );
                
                if ( $complate === true ) {
                    save_ab_text_list( $_POST );
                }
            }
            if ( $complate === true ) {
                if ( isset( $_POST[ 'name' ] ) ) {
                    $result = array( 'result' => true );
                    if ( isset( $_POST[ 'lp' ] ) && is_numeric( $design_name ) ) {
                        $post = get_post( $design_name );
                        if ( $post !== null ) {
                            $result[ 'postName' ] = $post->post_name;
                            $result[ 'editUrl' ] = rawurlencode( get_edit_post_link( $post->ID ) );
                        }
                    }
                    if ( isset( $_POST[ 'first' ] ) ) {
                        $result[ 'firstValue' ] = $save_value;
                    }
                    echo json_encode( $result );
                    exit();
                } else {
                    return true;
                }
            }
        }
    }
    if ( isset( $_POST[ 'name' ] ) ) {
        echo json_encode( array( 'result' => false ) );
        exit();
    } else {
        return false;
    }
}
/*
 * ABテストリスト保存
*/
function save_ab_text_list( $post ) {
    if ( isset( $post[ 'abTestList' ] ) ) {
        $none_ab = false;
        if ( $post[ 'abTestList' ] !== '' ) {
            $list = json_decode( stripslashes( rawurldecode( $post[ 'abTestList' ] ) ), true );
            if ( isset( $_POST[ 'testType' ] ) && $_POST[ 'testType' ] !== '' ) {
                $list[ $_POST[ 'name' ] ] = $_POST[ 'testType' ];
            }
            if ( is_array( $list ) && count( $list ) > 0 ) {
                update_option( 'DG_abtest_designs', json_encode( $list ) );
            } else {
                $none_ab = true;
            }
        } else {
            $none_ab = true;
        }
        if ( $none_ab ) {
            update_option( 'DG_abtest_designs', '' );
        }
    }
}
/*
 * キャッシュ一括削除
*/
function delete_all_transients() {
    global $wpdb;
    $options = $wpdb->prefix . 'options';
    $wpdb->query( "DELETE FROM {$options} WHERE (`option_name` LIKE '%_transient_DG_%') OR (`option_name` LIKE '%_transient_timeout_DG_%')" );
}
/*
 * 期間別view削除
*/
function delete_post_view_data( $type ) {
    global $wpdb;
    $postmeta = $wpdb->prefix . 'postmeta';
    $pre = $wpdb->prepare( "UPDATE {$postmeta} SET `meta_value` = '0' WHERE `meta_key` = %s", array( $type ) );
    $wpdb->get_results( $pre );
}
/*
 * viewリセットチェック
*/
function check_site_views_reset() {
    $reset_year = get_transient( 'year_view_reset' );
    if ( $reset_year === false ) {
        delete_post_view_data( 'y_views' );
        update_option( 'dg_site_views_y', 0 );
        set_transient( 'year_view_reset', true, YEAR_IN_SECONDS );
    }
    $reset_month = get_transient( 'month_view_reset' );
    if ( $reset_month === false ) {
        delete_post_view_data( 'm_views' );
        update_option( 'dg_site_views_m', 0 );
        set_transient( 'month_view_reset', true, DAY_IN_SECONDS * 30 );
    }
    $reset_week = get_transient( 'week_view_reset' );
    if ( $reset_week === false ) {
        delete_post_view_data( 'w_views' );
        update_option( 'dg_site_views_w', 0 );
        set_transient( 'week_view_reset', true, WEEK_IN_SECONDS );
    }
}
/*
 * サイトデザイン削除
*/
add_action( 'wp_ajax_delete_site_design', 'delete_site_design' );
add_action( 'wp_ajax_nopriv_delete_site_design', 'delete_site_design' );
function delete_site_design() {
    if ( !is_user_logged_in() || ( !current_user_can( 'administrator' ) && !current_user_can( 'editor' ) ) ) {
        echo json_encode( array( 'result' => false ) );
        exit();
    }
    //nonceによる判定
    $nonce_result = wp_verify_nonce( $_POST[ 'siteBuilderNonce' ], 'site_builder_nonce' );
    if ( !$nonce_result ) {
        echo json_encode( array( 'result' => false ) );
        exit();
    }
    if ( isset( $_POST[ 'name' ] ) ) {
        $upload_dir = wp_upload_dir();
        $directory_path = $upload_dir[ 'basedir' ] . '/design-json/' . $_POST[ 'name' ] . '.json';
        if ( file_exists( $directory_path ) ) {
            if ( unlink( $directory_path ) ) {
                echo json_encode( array( 'result' => true ) );
                exit();
            }
        }
    }
    echo json_encode( array( 'result' => false ) );
    exit();
}

/*
 * デザインパーツ値取得
*/
add_action( 'wp_ajax_get_select_site_design', 'get_select_site_design' );
add_action( 'wp_ajax_nopriv_get_select_site_design', 'get_select_site_design' );
function get_select_site_design() {
    if ( !is_user_logged_in() || ( !current_user_can( 'administrator' ) && !current_user_can( 'editor' ) ) ) {
        echo json_encode( array( 'result' => false ) );
        exit();
    }
    $result = false;
    if ( isset( $_POST[ 'lp' ] ) && $_POST[ 'lp' ] !== '' && isset( $_POST[ 'name' ] ) && $_POST[ 'name' ] !== '' ) {
        $result = get_post_meta( $_POST[ 'name' ], 'site_builder', true );
    } elseif ( isset( $_POST[ 'name' ] ) && $_POST[ 'name' ] !== '' ) {
        $result = get_site_design_value( $_POST[ 'name' ], false );
    }
    echo json_encode( array( 'result' => $result ) );
    die();
}

/*
 * パーツデザイン取得
*/
function get_site_design_value( $type, $flg = true ) {
    require_once( ABSPATH . 'wp-admin/includes/file.php' );
    if ( WP_Filesystem() ) {
        global $wp_filesystem;
        //デザイン取得
        $upload_dir = wp_upload_dir();
        $design_url = $upload_dir[ 'basedir' ] . '/design-json/' . $type . '.json';
        if ( !file_exists( $design_url ) ) {
            return false;
        }
        $part_file = $wp_filesystem->get_contents( $design_url );
        if ( $flg === true ) {
            return json_decode( $part_file, $flg );
        } else {
            return $part_file;
        }
    }
    return false;
}

/*
 * 適用デザイン保存
*/
add_action( 'wp_ajax_save_apply_design_value', 'save_apply_design_value' );
add_action( 'wp_ajax_nopriv_save_apply_design_value', 'save_apply_design_value' );
function save_apply_design_value() {
    if ( !is_user_logged_in() || ( !current_user_can( 'administrator' ) && !current_user_can( 'editor' ) ) ) {
        echo json_encode( array( 'result' => false ) );
        exit();
    }
    //nonceによる判定
    $nonce_result = wp_verify_nonce( $_POST[ 'siteBuilderNonce' ], 'site_builder_nonce' );
    if ( !$nonce_result ) {
        echo json_encode( array( 'result' => 'nonce' ) );
        exit();
    }
    if ( isset( $_POST[ 'name' ] ) ) {
        $result = create_main_design_set( $_POST[ 'name' ], null );
        if ( $result === true ) {
            update_option( 'DG_site_design', $_POST[ 'name' ] );
            echo json_encode( array( 'result' => true ) );
            exit();
        }
    }
    echo json_encode( array( 'result' => false ) );
    exit();
}

/*
 * TESTデザイン保存
*/
add_action( 'wp_ajax_save_test_design_value', 'save_test_design_value' );
add_action( 'wp_ajax_nopriv_save_test_design_value', 'save_test_design_value' );
function save_test_design_value() {
    if ( !is_user_logged_in() || ( !current_user_can( 'administrator' ) && !current_user_can( 'editor' ) ) ) {
        echo json_encode( array( 'result' => false ) );
        exit();
    }
    //nonceによる判定
    $nonce_result = wp_verify_nonce( $_POST[ 'siteBuilderNonce' ], 'site_builder_nonce' );
    if ( !$nonce_result ) {
        echo json_encode( array( 'result' => 'nonce' ) );
        exit();
    }
    if ( isset( $_POST[ 'name' ] ) && isset( $_POST[ 'testType' ] ) && $_POST[ 'testType' ] !== '' ) {
        $result = create_main_design_set( $_POST[ 'name' ], null, $_POST[ 'testType' ] );
        if ( $result === true ) {
            save_ab_text_list( $_POST );
            update_option( 'DG_site_design_' . $_POST[ 'testType' ], $_POST[ 'name' ] );
            echo json_encode( array( 'result' => true ) );
            exit();
        }
    }
    echo json_encode( array( 'result' => false ) );
    exit();
}

/*
 * TESTデザイン削除
*/
add_action( 'wp_ajax_delete_test_design_value', 'delete_test_design_value' );
add_action( 'wp_ajax_nopriv_delete_test_design_value', 'delete_test_design_value' );
function delete_test_design_value() {
    if ( !is_user_logged_in() || ( !current_user_can( 'administrator' ) && !current_user_can( 'editor' ) ) ) {
        echo json_encode( array( 'result' => false ) );
        exit();
    }
    //nonceによる判定
    $nonce_result = wp_verify_nonce( $_POST[ 'siteBuilderNonce' ], 'site_builder_nonce' );
    if ( !$nonce_result ) {
        echo json_encode( array( 'result' => 'nonce' ) );
        exit();
    }
    require_once( ABSPATH . 'wp-admin/includes/file.php' );
    if ( isset( $_POST[ 'name' ] ) && isset( $_POST[ 'testType' ] ) && $_POST[ 'testType' ] !== '' ) {
        $test_type = $_POST[ 'testType' ];
        if ( WP_Filesystem() ) {
            global $wp_filesystem;
            
            $upload_dir = wp_upload_dir();
            $directory_path_css = $upload_dir[ 'basedir' ] . '/design-json/css/';
            $directory_path_editor_css = $upload_dir[ 'basedir' ] . '/design-json/editor-css/';
            
            //フロント用CSS
            $css_dirs = glob( $directory_path_css . '*', GLOB_ONLYDIR );
            foreach( (array)$css_dirs as $path ) {
                $dir_name = basename( $path );
                if ( $dir_name === $test_type ) {
                    $wp_filesystem->rmdir( $path, true );
                }
            }
            //エディター用CSS
            $editor_css_dirs = glob( $directory_path_editor_css . '*', GLOB_ONLYDIR );
            foreach( (array)$editor_css_dirs as $path ) {
                $dir_name = basename( $path );
                if ( $dir_name === $test_type ) {
                    $wp_filesystem->rmdir( $path, true );
                }
            }
        }
        
        //サイトオプション削除
        delete_option( 'DG_site_sub_value' . $test_type );
        delete_option( 'DG_site_design_' . $test_type );
        //ページリスト取得
        $page_types = array( 'taxonomy', 'custom-post-archive', 'single', 'other' );
        $page_list = get_page_types();
        $all_pages = array( 'top' );
        foreach( (array)$page_types as $page_type ) {
            foreach( (array)$page_list[ $page_type ] as $page => $page_name ) {
                $all_pages[] = $page_type . '-' . $page;
            }
        }
        foreach( (array)$all_pages as $page ) {
            delete_option( 'DG_site_value_' . $test_type . $page );
        }
        //script削除
        delete_option( 'DG_script_option' . $test_type  );
        delete_option( 'DG_image_option' . $test_type  );
        
        $DG_abtest_designs = get_option( 'DG_abtest_designs', '' );
        if ( $DG_abtest_designs !== '' ) {
            $DG_abtest_designs = json_decode( $DG_abtest_designs, true );
            if ( isset( $DG_abtest_designs[ $_POST[ 'name' ] ] ) ) {
                unset( $DG_abtest_designs[ $_POST[ 'name' ] ] );
                if ( is_array( $DG_abtest_designs ) && count( $DG_abtest_designs ) > 0 ) {
                    update_option( 'DG_abtest_designs', json_encode( $DG_abtest_designs ) );
                } else {
                    update_option( 'DG_abtest_designs', '' );
                }
            }
        }
        echo json_encode( array( 'result' => true ) );
        exit();
    }
    echo json_encode( array( 'result' => false ) );
    exit();
}

/*
 * 最初の登録時デフォルトデザイン公開
*/
function first_dg_style_design_setting() {
    $site_design = get_option( 'DG_site_design', '' );
    if ( $site_design !== '' ) {
        return false;
    }
    $stylesheet_path = get_template_directory();
    $default_path = $stylesheet_path . '/wp-admin/site_builder/default.json';
    require_once( ABSPATH . 'wp-admin/includes/file.php' );
    if ( WP_Filesystem() ) {
        global $wp_filesystem;
        //デフォルトサイトデザイン取得
        $part_file = $wp_filesystem->get_contents( $default_path );
        //uploadsフォルダーに保存
        $upload_dir = wp_upload_dir();
        $directory_path = $upload_dir[ 'basedir' ] . '/design-json';
        if ( !file_exists( $directory_path ) ) {
            if ( !mkdir( $directory_path, 0777, true ) ) {
                if ( isset( $_POST[ 'name' ] ) ) {
                    echo json_encode( array( 'result' => false ) );
                    exit();
                } else {
                    return false;
                }
            }
        }
        $design_file = $directory_path . '/default.json';
        $wp_filesystem->put_contents( $design_file, mb_convert_encoding( $part_file, 'UTF-8' ) );
        update_option( 'DG_site_design', 'default' );
        $complate = create_main_design_set( 'default', $part_file );
        if ( $complate === true ) {
            return true;
        }
    }
    return false;
}
/* ----------------------------------------------------------
 * 共通オプション
---------------------------------------------------------- */
function save_part_common_option( $common ) {
    $list = json_decode( stripslashes( rawurldecode( $common ) ), true );
    if ( is_array( $list ) && count( $list ) > 0 ) {
        foreach( (array)$list as $name => $value ) {
            if ( $name === 'favicon' ) {
                update_option( 'site_icon', $value );
            } elseif ( !empty( $value ) ) {
                update_option( 'DG_' . $name . '_value', json_encode( $value ) );
            } else {
                update_option( 'DG_' . $name . '_value', '' );
            }
        }
    }
    return true;
}

function save_part_font_option( $font ) {
    $scripts = get_option( 'DG_script_option' );
    if ( $scripts !== false ) {
        $scripts = json_decode( $scripts, true );
    } else {
        $scripts = array();
    }
    $scripts[ 'font' ] = json_decode( stripslashes( rawurldecode( $font ) ), true );
    $update_scripts = json_encode( $scripts );
    update_option( 'DG_script_option', $update_scripts );
}

/* ----------------------------------------------------------
 * テンプレート関連
---------------------------------------------------------- */
/*
 * テンプレート保存
*/
function save_part_template_design( $template ) {
    require_once( ABSPATH . 'wp-admin/includes/file.php' );
    if ( WP_Filesystem() ) {
        global $wp_filesystem;
        $upload_dir = wp_upload_dir();
        $directory_path = $upload_dir[ 'basedir' ] . '/design-json/template';
        if ( !file_exists( $directory_path ) ) {
            if ( !mkdir( $directory_path, 0777, true ) ) {
                return false;
            }
        }
        $list = json_decode( stripslashes( rawurldecode( $template ) ), true );
        if ( is_array( $list ) && count( $list ) > 0 ) {
            foreach( (array)$list as $name => $value ) {
                $design_file = $directory_path . '/' . $name . '.json';
                $save_value = json_encode( $value );
                $wp_filesystem->put_contents( $design_file, mb_convert_encoding( $save_value, 'UTF-8' ) );
            }
        }
        return true;
    }
    return false;
}
    
/* ----------------------------------------------------------
 * 適用デザインDB保存
---------------------------------------------------------- */
/*
 * メニューの親子設定作成
*/
function create_part_child_tree( $list, $parentId = 'page' ) {
    $result = array();
    foreach( (array)$list as $part_id => $value ) {
        if ( isset( $value[ 'parent' ] ) && $value[ 'parent' ] === $parentId ) {
            $children = create_part_child_tree( $list, $part_id );
            $result[] = $part_id;
            if ( !empty( $children ) ) {
                $result = array_merge( $result, $children );
            }
        }
    }
    return $result;
}

function create_main_design_set( $site_name, $site_value = null, $test_type = false, $lp = false ) {
    if ( !is_user_logged_in() || ( !current_user_can( 'administrator' ) && !current_user_can( 'editor' ) ) ) {
        return false;
    }
    if ( $site_value === null ) {
        $site_value = get_site_design_value( $site_name, true );
    } else {
        $site_value = json_decode( $site_value, true );
    }
    if ( !is_array( $site_value ) || ( is_array( $site_value ) && count( $site_value ) < 1 ) ) {
        if ( $lp === false ) {
            return false;
        }
    }
    
    //viewリセット時間設定
    $today_date = wp_date( 'Y-m-d H:i:s' );
    $today = new DateTime( $today_date );
    $today_unix = $today->format( 'U' );
    $year_date = new DateTime( 'last day of December this year' );
    $month_date = new DateTime( 'last day of this year' );
    $week_date = new DateTime( $today_date );
    $week_date->modify( 'Next Sunday' );
    set_transient( 'year_view_reset', true, ( $year_date->format( 'U' ) - $today_unix ) );
    set_transient( 'month_view_reset', true, ( $month_date->format( 'U' ) - $today_unix ) );
    set_transient( 'week_view_reset', true, ( $week_date->format( 'U' ) - $today_unix ) );
    
    //各今日オプション取得
    $logo = false;
    if ( isset( $site_value[ 'ORIGINALLOGO' ] ) ) {
        $logo = $site_value[ 'ORIGINALLOGO' ];
        unset( $site_value[ 'ORIGINALLOGO' ] );
    } else {
        $logo = get_option( 'DG_logo_value' );
        if ( $logo !== false ) {
            $logo = json_decode( $logo, true );
        }
    }
    $pc_logo = isset( $logo[ 'pc' ][ 'src' ] ) && $logo[ 'pc' ][ 'src' ] !== '' ? $logo[ 'pc' ][ 'src' ] : '';
    $sp_logo = isset( $logo[ 'sp' ][ 'src' ] ) && $logo[ 'sp' ][ 'src' ] !== '' ? $logo[ 'sp' ][ 'src' ] : '';
    $stylesheet_url = get_template_directory_uri();
    
    $no_image = '';
    if ( isset( $site_value[ 'ORIGINALNOIMAGE' ] ) ) {
        $noimage = $site_value[ 'ORIGINALNOIMAGE' ];
        unset( $site_value[ 'ORIGINALNOIMAGE' ] );
    } else {
        $noimage = get_option( 'DG_noimage_value' );
        if ( $noimage !== false ) {
            $noimage = json_decode( $noimage, true );
        }
    }
    if ( isset( $noimage[ 'src' ] ) && $noimage[ 'src' ] !== '' ) {
        $no_image = $noimage[ 'src' ];
    }
    if ( $no_image === '' ) {
        $no_image = $stylesheet_url . '/image/no-image.gif';
    }
    
    $loading_image = '';
    if ( isset( $site_value[ 'ORIGINALLOADING' ] ) ) {
        $loading = $site_value[ 'ORIGINALLOADING' ];
        unset( $site_value[ 'ORIGINALLOADING' ] );
    } else {
        $loading = get_option( 'DG_loading_value' );
        if ( $loading !== false ) {
            $loading = json_decode( $loading, true );
        }
    }
    if ( isset( $loading[ 'src' ] ) && $loading[ 'src' ] !== '' ) {
        $loading_image = $loading[ 'src' ];
    }
    if ( $loading_image === '' ) {
        $loading_image = $stylesheet_url . '/image/loading.gif';
    }
    
    $fixed_image = array();
    if ( isset( $site_value[ 'ORIGINALFIXED' ] ) ) {
        $fixed = $site_value[ 'ORIGINALFIXED' ];
        unset( $site_value[ 'ORIGINALFIXED' ] );
        if ( isset( $fixed[ 'type' ] ) && $fixed[ 'type' ] === '2' ) {
            if ( isset( $fixed[ 'src' ] ) && $fixed[ 'src' ] !== '' ) {
                $fixed_image[ 'url' ] = $fixed[ 'src' ];
            }
        } else {
            if ( isset( $fixed[ 'id' ] ) && $fixed[ 'id' ] !== '' ) {
                $fixed_arr = post_image_src_list( $fixed[ 'id' ], null );
                if ( $fixed_arr !== false ) {
                    $fixed_image = $fixed_arr;
                }
            }
        }
    }
    $site_url = site_url();
    $page_types = array( 'taxonomy', 'custom-post-archive', 'single', 'other' );
    $page_list = get_page_types();
    $taxonomy_part = array();
    $single_part = array();
    $display_part = array();
    
    /* ページごと値保存 */
    $hidden = array();
    $realtime = array();
    $page_value = array();
    /* ページごと値保存 */
    
    /* 事前に親子ツリーを作成 */
    $result_list = array();
    foreach( (array)$site_value as $part_id => $part ) {
        $child_list = create_part_child_tree( $site_value, $part_id );
        if ( is_array( $child_list ) && count( $child_list ) > 0 ) {
            $result_list[ $part_id ][ 'child' ] = $child_list;
        }
    }
    /* 非表示パーツ抽出 */
    foreach( (array)$site_value as $part_id => $part ) {
        if ( isset( $part[ 'type' ] ) && $part[ 'type' ] === 'taxonomy' ) {
            $taxonomy_part[] = $part_id;
        } else if ( isset( $part[ 'type' ] ) && $part[ 'type' ] === 'single' ) {
            $single_part[] = $part_id;
        }
        if ( isset( $part[ 'slug' ] ) && ( $part[ 'slug' ] === 'breadcrumb' || $part[ 'slug' ] === 'sns' ) ) {
            $realtime[] = $part_id;
        }
        
        if ( isset( $part[ 'hidden' ] ) ) {
            //TOPページ除外の場合
            if ( isset( $part[ 'hidden' ][ 'top' ] ) && $part[ 'hidden' ][ 'top' ] === '1' ) {
                $hidden[ 'top' ][] = $part_id;
                if ( isset( $result_list[ $part_id ][ 'child' ] ) ) {
                    $hidden[ 'top' ] = array_merge( $hidden[ 'top' ], $result_list[ $part_id ][ 'child' ] );
                }
            } else {
                if ( isset( $part[ 'type' ] ) && $part[ 'type' ] === 'area' ) {
                    $display_part[ 'top' ][] = $part_id;
                    if ( is_array( $display_part[ 'top' ] ) && is_array( $result_list[ $part_id ][ 'child' ] ) ) {
                        $display_part[ 'top' ] = array_merge( $display_part[ 'top' ], $result_list[ $part_id ][ 'child' ] );
                    }
                } elseif ( isset( $part[ 'type' ] ) && $part[ 'type' ] !== 'single' ) {
                    $display_part[ 'top' ][] = $part_id;
                }
            }
            //タクソノミ除外の場合
            foreach( (array)$page_types as $page_type ) {
                foreach( (array)$page_list[ $page_type ] as $page => $page_name ) {
                    $select_hidden = isset( $part[ 'hidden' ][ $page_type . '-' . $page . '-in' ] ) && $part[ 'hidden' ][ $page_type . '-' . $page . '-in' ] !== '';
                    //記事ページの場合、カテゴリー指定があるか判定ある場合は除外
                    if ( $page_type === 'single' ) {
                        foreach( (array)$page_list[ 'taxonomy' ] as $tax_slug => $tax_val ) {
                            if ( isset ( $part[ 'hidden' ][ $page_type . '-' . $page . '-' . $tax_slug . '-in' ] ) && $part[ 'hidden' ][ $page_type . '-' . $page . '-' . $tax_slug . '-in' ] !== '' ) {
                                $select_hidden = true;
                            }
                        }
                        if ( isset ( $part[ 'hidden' ][ $page_type . '-' . $page . '-author-in' ] ) && $part[ 'hidden' ][ $page_type . '-' . $page . '-author-in' ] !== '' ) {
                            $select_hidden = true;
                        }
                    }
                    
                    if ( isset( $part[ 'hidden' ][ $page_type . '-' . $page ] ) && $part[ 'hidden' ][ $page_type . '-' . $page ] === '1' && $select_hidden === false ) {
                        $hidden[ $page_type . '-' . $page ][] = $part_id;
                        if ( isset( $result_list[ $part_id ][ 'child' ] ) ) {
                            $hidden[ $page_type . '-' . $page ] = array_merge( $hidden[ $page_type . '-' . $page ], $result_list[ $part_id ][ 'child' ] );
                        }
                    } else {
                        if ( isset( $part[ 'type' ] ) && $part[ 'type' ] === 'area' ) {
                            $display_part[ $page_type . '-' . $page ][] = $part_id;
                            if ( is_array( $display_part[ $page_type . '-' . $page ] ) && is_array( $result_list[ $part_id ][ 'child' ] ) ) {
                                $display_part[ $page_type . '-' . $page ] = array_merge( $display_part[ $page_type . '-' . $page ], $result_list[ $part_id ][ 'child' ] );
                            }
                        } else if ( isset( $part[ 'type' ] ) && $part[ 'type' ] === 'all' ) {
                            $display_part[ $page_type . '-' . $page ][] = $part_id;
                        }
                    }
                }
            }
        }
    }
    /* 非表示パーツを除いたページごとのパーツを取得 */
    $preload_slugs = array( 'post_list', 'categories', 'author' );
    $post_list_preload_flg = array();
    $main_post_list_flg = array();
    $tax_names = array();
    $gmenu_names = array();
    $preload = array();
    $preload_parts = array();
    $postmeta_keys = array( 'evaluate_total', 'evaluate_table' );
    $post_ids = array();
    $contact_ids = array();
    $child_term_flg = array();
    $user_fields = array();
    $user_options = array();
    $author_sns_types = array( 'site', 'mail', 'facebook', 'twitter', 'line' );
    $single_content_css_flg = array();
    foreach( (array)$site_value as $part_id => $part ) {
        $part_value = array();
        if ( isset( $part[ 'area-type' ] ) ) {
            $part_value[ 'area-type' ] = $part[ 'area-type' ];
        }
        if ( isset( $part[ 'type' ] ) && $part[ 'type' ] === 'area' && isset( $part[ 'label' ] ) ) {
            $part_value[ 'label' ] = $part[ 'label' ];
        }
        if ( isset( $part[ 'slug' ] ) ) {
            $part_value[ 'slug' ] = $part[ 'slug' ];
            //検索フォーム用のタクソノミーリスト取得
            if ( $part[ 'slug' ] === 'search-form' && isset( $part[ 'option' ][ 'area' ] ) && is_array( $part[ 'option' ][ 'area' ] ) && count( $part[ 'option' ][ 'area' ] ) > 0 ) {
                foreach( (array)$part[ 'option' ][ 'area' ] as $tax => $val ) {
                    if ( isset( $val[ 'slug' ] ) && strpos( $val[ 'slug' ], 'tax-' ) !== false ) {
                        $tax_names[] = str_replace( 'tax-' , '', $val[ 'slug' ] );
                    }
                }
            }
            //グローバルメニュー
            if ( $part[ 'slug' ] === 'gmenu' && isset( $part[ 'option' ][ 'gmenu-type' ] ) && $part[ 'option' ][ 'gmenu-type' ] !== '' ) {
                $gmenu_names[] = $part[ 'option' ][ 'gmenu-type' ];
            }
            //postmetaキー取得
            if ( $part[ 'slug' ] === 'single-postmeta' && isset( $part[ 'option' ][ 'type' ] ) && $part[ 'option' ][ 'type' ] !== '' ) {
                $postmeta_keys[] = $part[ 'option' ][ 'type' ];
            }
            if ( $part[ 'slug' ] === 'single-views' ) {
                if ( isset( $part[ 'option' ][ 'type' ] ) && $part[ 'option' ][ 'type' ] !== '' ) {
                    $postmeta_keys[] = $part[ 'option' ][ 'type' ];
                } else {
                    $postmeta_keys[] = 'views';
                }
            }
            if ( $part[ 'slug' ] === 'single-recommend' ) {
                $postmeta_keys[] = 'dg_recommend_post';
            }
            if ( $part[ 'slug' ] === 'single-bookmark' ) {
                $postmeta_keys[] = 'dg_bookmark';
            }
            //作成者ページサムネイル
            if ( $part[ 'slug' ] === 'single-thumbnail' ) {
                if ( isset( $part[ 'preload' ] ) && $part[ 'preload' ] === '1' ) {
                    $preload[ 'single-thumbnail' ] = true;
                }
            }
            if ( $part[ 'slug' ] === 'taxonomy-thumbnail' ) {
                $user_type = isset( $part[ 'option' ][ 'user' ] ) && $part[ 'option' ][ 'user' ] === '2' ? 'user_image' : 'bg_image';
                $user_fields[] = $user_type;
                $size = isset( $part[ 'option' ][ 'size' ] ) && $part[ 'option' ][ 'size' ] !== '' ? $part[ 'option' ][ 'size' ] : 'thumbnail';
                $user_options[ $user_type ][ $size ] = $size;
                
                if ( isset( $part[ 'preload' ] ) && $part[ 'preload' ] === '1' ) {
                    $preload[ 'taxonomy-thumbnail' ] = true;
                }
            }
            //作成者ページSNS・連絡先
            if ( $part[ 'slug' ] === 'taxonomy-user_sns' ) {
                $user_fields[] = 'user_sns';
                foreach( (array)$author_sns_types as $sns_name ) {
                    if ( ( !isset( $part[ 'option' ][ $sns_name ] ) || isset( $part[ 'option' ][ $sns_name ] ) && $part[ 'option' ][ $sns_name ] === '1' ) ) {
                        $user_options[ 'user_sns' ][ $sns_name ] = true;
                    }
                }
            }
            //動画サムネイル
            if ( $part[ 'slug' ] === 'single-movie' ) {
                $postmeta_keys[] = 'movie_thumbnail';
                
                if ( isset( $part[ 'preload' ] ) && $part[ 'preload' ] === '1' ) {
                    $preload[ 'single-movie' ] = true;
                }
            }
            if ( $part[ 'slug' ] === 'taxonomy-movie' ) {
                $child_term_flg[ 'movie_thumbnail' ] = true;
                $user_fields[] = 'movie_thumbnail';
                $thumb_flg = isset( $part[ 'option' ][ 'thumb' ] ) ? $part[ 'option' ][ 'thumb' ] : '1';
                if ( $thumb_flg === '1' ) {
                    $user_type = isset( $part[ 'option' ][ 'user' ] ) && $part[ 'option' ][ 'user' ] === '2' ? 'user_image' : 'bg_image';
                    $user_fields[] = $user_type;
                    $size = isset( $part[ 'option' ][ 'size' ] ) && $part[ 'option' ][ 'size' ] !== '' ? $part[ 'option' ][ 'size' ] : 'thumbnail';
                    $user_options[ $user_type ][ $size ] = $size;
                }
                if ( isset( $part[ 'preload' ] ) && $part[ 'preload' ] === '1' ) {
                    $preload[ 'taxonomy-movie' ] = true;
                }
            }
            //子カテゴリー判定
            if ( $part[ 'slug' ] === 'taxonomy-brother' ) {
                $child_term_flg[ 'brother' ] = true;
            }
            if ( $part[ 'slug' ] === 'taxonomy-child' ) {
                $child_term_flg[ 'child' ] = true;
            }
            //記事コンテンツ
            if ( $part[ 'slug' ] === 'post-content' && isset( $part[ 'option' ][ 'ids' ] ) && $part[ 'option' ][ 'ids' ] !== '' ) {
                $post_ids = array_merge( $post_ids, explode( ',', $part[ 'option' ][ 'ids' ] ) );
            }
            //お問い合わせフォーム
            if ( $part[ 'slug' ] === 'contact' && isset( $part[ 'option' ][ 'id' ] ) && $part[ 'option' ][ 'id' ] !== '' ) {
                $contact_ids[] = $part[ 'option' ][ 'id' ];
            }
            //イメージURL設定
            if ( $part[ 'slug' ] === 'image' ) {
                if ( isset( $part[ 'option' ][ 'image-type' ] ) && ( $part[ 'option' ][ 'image-type' ] === '3' || $part[ 'option' ][ 'image-type' ] === '4' ) && isset( $part[ 'option' ][ 'image-url' ] ) ) {
                    unset( $part[ 'option' ][ 'image-url' ] );
                }
                if ( isset( $part[ 'preload' ] ) && $part[ 'preload' ] === '1' ) {
                    $image_type = isset( $part[ 'option' ][ 'image-type' ] ) && $part[ 'option' ][ 'image-type' ] !== '' ? $part[ 'option' ][ 'image-type' ] : '1';
                    $image_src = '';
                    $src_set = '';
                    if ( $image_type === '4' && $sp_logo !== '' ) {
                        $image_src = $sp_logo;
                    } elseif ( $image_type === '3' && $pc_logo !== '' ) {
                        $image_src = $pc_logo;
                    } elseif ( $image_type === '2' && isset( $part[ 'option' ][ 'image-url' ] ) && $part[ 'option' ][ 'image-url' ] !== '' ) {
                        $image_src = $part[ 'option' ][ 'image-url' ];
                    } elseif ( $image_type === '1' && isset( $part[ 'option' ][ 'image-url' ] ) && $part[ 'option' ][ 'image-url' ] !== '' ) {
                        $size = isset( $part[ 'option' ][ 'size' ] ) && $part[ 'option' ][ 'size' ] !== '' ? $part[ 'option' ][ 'size' ] : 'thumbnail';
                        $image_arr = explode( ',', $part[ 'option' ][ 'image-url' ] );
                        if ( isset( $image_arr[ 0 ] ) && is_numeric( $image_arr[ 0 ] ) ) {
                            $image_urls = post_image_src_list( $image_arr[ 0 ] );
                            if ( isset( $image_urls[ $size ][ 'url' ] ) && $image_urls[ $size ][ 'url' ] !== '' ) {
                                $image_src = $image_urls[ $size ][ 'url' ];
                            } elseif ( isset( $image_urls[ 'full' ][ 'url' ] ) && $image_urls[ 'full' ][ 'url' ] !== '' ) {
                                $image_src = $image_urls[ 'full' ][ 'url' ];
                            }
                            if ( isset( $part[ 'option' ][ 'srcset' ] ) && $part[ 'option' ][ 'srcset' ] === '1' && isset( $image_urls[ 'full' ][ 'url' ] ) ) {
                                foreach( (array)$image_urls as $img ) {
                                    if ( isset( $img[ 'width' ] ) && $img[ 'width' ] !== '' ) {
                                        if ( $src_set !== '' ) {
                                            $src_set .= ',';
                                        }
                                        $src_set .= $img[ 'url' ] . ' ' . $img[ 'width' ] . 'w';
                                    }
                                }
                            }
                        }
                    }
                    if ( $image_src !== '' ) {
                        $preload_parts[ $part_id ] = array(
                            'as' => 'image',
                            'url' => $image_src,
                            'imagesrcset' => $src_set,
                        );
                    }
                }
            }
            if ( $part[ 'slug' ] === 'movie' && isset( $part[ 'option' ][ 'movie-url' ] ) && $part[ 'option' ][ 'movie-url' ] !== '' ) {
                $video_type = '';
                $movie_url = '';
                $data_arr = explode( ',', $part[ 'option' ][ 'movie-url' ] );
                if ( isset( $data_arr[ 0 ] ) && is_numeric( $data_arr[ 0 ] ) ) {
                    $movie_url = wp_get_attachment_url( $data_arr[ 0 ] );
                } else {
                    $movie_url = $part[ 'option' ][ 'movie-url' ];
                }
                $pathinfo = pathinfo( $movie_url );
                if ( isset( $pathinfo[ 'extension' ] ) && $pathinfo[ 'extension' ] !== '' ) {
                    $video_type = 'video/' . $pathinfo[ 'extension' ];
                }
                $preload_parts[ $part_id ] = array(
                    'as' => 'video',
                    'url' => $movie_url,
                    'type' => $video_type,
                );
            } elseif ( $part[ 'slug' ] === 'music' && isset( $part[ 'option' ][ 'music-url' ] ) && $part[ 'option' ][ 'music-url' ] !== '' ) {
                $video_type = '';
                $movie_url = '';
                $data_arr = explode( ',', $part[ 'option' ][ 'music-url' ] );
                if ( isset( $data_arr[ 0 ] ) && is_numeric( $data_arr[ 0 ] ) ) {
                    $movie_url = wp_get_attachment_url( $data_arr[ 0 ] );
                } else {
                    $movie_url = $part[ 'option' ][ 'music-url' ];
                }
                $pathinfo = pathinfo( $movie_url );
                if ( isset( $pathinfo[ 'extension' ] ) && $pathinfo[ 'extension' ] !== '' ) {
                    $video_type = 'video/' . $pathinfo[ 'extension' ];
                }
                $preload_parts[ $part_id ] = array(
                    'as' => 'audio',
                    'url' => $movie_url,
                    'type' => $video_type,
                );
            }
            //各種HTMLエンコード処理
            //記事リストなど、項目追加系
            if ( isset( $part[ 'option' ][ 'area' ] ) && is_array( $part[ 'option' ][ 'area' ] ) && count( $part[ 'option' ][ 'area' ] ) > 0 ) {
                foreach( (array)$part[ 'option' ][ 'area' ] as $area_slug => $area_value ) {
                    if ( isset( $area_value[ 'option' ] ) && is_array( $area_value[ 'option' ] ) ) {
                        foreach( (array)$area_value[ 'option' ] as $value_key => $value_data ) {
                            $part[ 'option' ][ 'area' ][ $area_slug ][ 'option' ][ $value_key ] = htmlspecialchars( $value_data, ENT_QUOTES, 'UTF-8' );
                        }
                    }
                }
            }
            //テキストパーツ
            if ( $part[ 'slug' ] === 'text' && isset( $part[ 'option' ][ 'text' ] ) && $part[ 'option' ][ 'text' ] !== '' ) {
                $part[ 'option' ][ 'text' ] = htmlspecialchars( $part[ 'option' ][ 'text' ], ENT_QUOTES, 'UTF-8' );
            }
        }
        if ( isset( $part[ 'order' ] ) ) {
            $part_value[ 'order' ] = $part[ 'order' ];
        }
        if ( isset( $part[ 'type' ] ) ) {
            $part_value[ 'type' ] = $part[ 'type' ];
        }
        if ( isset( $part[ 'parent' ] ) ) {
            $part_value[ 'parent' ] = $part[ 'parent' ];
        }
        if ( isset( $part[ 'tag' ] ) ) {
            $part_value[ 'tag' ] = $part[ 'tag' ];
        }
        if ( isset( $part[ 'class' ] ) ) {
            $part_value[ 'class' ] = $part[ 'class' ];
        }
        if ( isset( $part[ 'cache' ] ) && $part[ 'cache' ] === '1' ) {
            $part_value[ 'cache' ] = $part[ 'cache' ];
        }
        if ( isset( $part[ 'lazyload' ] ) && $part[ 'lazyload' ] === '1' ) {
            $part_value[ 'lazyload' ] = $part[ 'lazyload' ];
        }
        //非表示タイマー追加
        if ( isset( $part[ 'hidden' ][ 'start' ] ) && $part[ 'hidden' ][ 'start' ] !== '' ) {
            $part_value[ 'timer' ][ 'start' ] = $part[ 'hidden' ][ 'start' ];
        }
        if ( isset( $part[ 'hidden' ][ 'end' ] ) && $part[ 'hidden' ][ 'end' ] !== '' ) {
            $part_value[ 'timer' ][ 'end' ] = $part[ 'hidden' ][ 'end' ];
        }
        //非表示GETパラメータ
        if ( isset( $part[ 'hidden' ][ 'get-in' ] ) && is_array( $part[ 'hidden' ][ 'get-in' ] ) && count( $part[ 'hidden' ][ 'get-in' ] ) > 0 ) {
            $get_values = array();
            foreach( (array)$part[ 'hidden' ][ 'get-in' ] as $key => $get_val ) {
                if ( isset( $get_val[ 'name' ] ) && $get_val[ 'name' ] !== '' ) {
                    $get_values[ $key ][ 'name' ] = $get_val[ 'name' ];
                    
                    if ( isset( $get_val[ 'value' ] ) && $get_val[ 'value' ] !== '' ) {
                        $get_values[ $key ][ 'value' ] = $get_val[ 'value' ];
                    }
                }
            }
            if ( is_array( $get_values ) && count( $get_values ) > 0 ) {
                $part_value[ 'get' ][ 'flg' ] = isset( $part[ 'hidden' ][ 'get' ] ) ? $part[ 'hidden' ][ 'get' ] : '';
                $part_value[ 'get' ][ 'list' ] = $get_values;
            }
        }
        
        if ( isset( $part[ 'option' ] ) ) {
            $part_value[ 'option' ] = $part[ 'option' ];
        }
        if ( isset( $part[ 'title' ] ) ) {
            if ( isset( $part[ 'title' ][ 'text' ] ) ) {
                $part[ 'title' ][ 'text' ] = htmlspecialchars( $part[ 'title' ][ 'text' ], ENT_QUOTES, 'UTF-8' );
            }
            $part_value[ 'title' ] = $part[ 'title' ];
        }
        if ( isset( $part[ 'event' ] ) ) {
            $part_value[ 'event' ] = $part[ 'event' ];
        }
        if ( isset( $part[ 'simple' ] ) ) {
            $part_value[ 'simple' ] = $part[ 'simple' ];
        }
        if ( isset( $part[ 'slide' ] ) && ( ( isset( $part[ 'area-type' ] ) && $part[ 'area-type' ] === '3' ) || ( isset( $part[ 'slide' ][ 'display' ] ) && $part[ 'slide' ][ 'display' ] === '1' ) ) ) {
            $part_value[ 'slide' ] = $part[ 'slide' ];
        }

        if ( ( !isset( $hidden[ 'top' ] ) || !in_array( $part_id, $hidden[ 'top' ], true ) ) && ( !isset( $part[ 'hidden' ][ 'top' ] ) || ( isset( $part[ 'hidden' ][ 'top' ] ) && $part[ 'hidden' ][ 'top' ] === '' ) ) && isset( $part[ 'type' ] ) && $part[ 'type' ] !== 'single' ) {
            $page_value[ 'top' ][ $part_id ] = $part_value;
            if ( isset( $preload_parts[ $part_id ] ) ) {
                $preload[ 'top' ][] = $preload_parts[ $part_id ];
            }
            //メイン記事リスト判定
            if ( isset( $part_value[ 'slug' ] ) && ( $part_value[ 'slug' ] === 'taxonomy-post_list' || $part_value[ 'slug' ] === 'taxonomy-paging' ) ) {
                $main_post_list_flg[ 'top' ] = true;
            }
            //記事リストがキャッシュ設定時にpreloadするように
            if ( isset( $part_value[ 'slug' ] ) && in_array( $part_value[ 'slug' ], $preload_slugs, true ) === true && isset( $part[ 'preload' ] ) && $part[ 'preload' ] === '1' && isset( $part[ 'cache' ] ) && $part[ 'cache' ] === '1' ) {
                $post_list_preload_flg[ 'top' ][ $part_id ] = $part_value[ 'slug' ];
            }
        }
        foreach( (array)$page_list[ 'taxonomy' ] as $page => $page_name ) {
            if ( isset( $part[ 'type' ] ) && $part[ 'type' ] !== 'single' && ( !isset( $hidden[ 'taxonomy-' . $page ] ) || !in_array( $part_id, $hidden[ 'taxonomy-' . $page ], true ) ) ) {
                $select_hidden = isset( $part[ 'hidden' ][ 'taxonomy-' . $page . '-in' ] ) && $part[ 'hidden' ][ 'taxonomy-' . $page . '-in' ] !== '' ? explode( ',', $part[ 'hidden' ][ 'taxonomy-' . $page . '-in' ] ) : false;
                if ( isset( $part[ 'hidden' ][ 'taxonomy-' . $page ] ) && $part[ 'hidden' ][ 'taxonomy-' . $page ] !== '' ) {
                    if ( $select_hidden !== false ) {
                        $part_value[ 'hidden' ] = true;
                        $part_value[ 'hidden-in' ] = $select_hidden;
                        $page_value[ 'taxonomy-' . $page ][ $part_id ] = $part_value;
                    }
                } else {
                    if ( $select_hidden !== false ) {
                        $part_value[ 'hidden' ] = false;
                        $part_value[ 'hidden-in' ] = $select_hidden;
                    }
                    $page_value[ 'taxonomy-' . $page ][ $part_id ] = $part_value;
                }
                if ( isset( $preload_parts[ $part_id ] ) ) {
                    $preload[ 'taxonomy-' . $page ][] = $preload_parts[ $part_id ];
                }
                //メイン記事リスト判定
                if ( isset( $part_value[ 'slug' ] ) && ( $part_value[ 'slug' ] === 'taxonomy-post_list' || $part_value[ 'slug' ] === 'taxonomy-paging' ) ) {
                    $main_post_list_flg[ 'taxonomy-' . $page ] = true;
                }
                //記事リストがキャッシュ設定時にpreloadするように
                if ( isset( $part_value[ 'slug' ] ) && in_array( $part_value[ 'slug' ], $preload_slugs, true ) === true && isset( $part[ 'preload' ] ) && $part[ 'preload' ] === '1' && isset( $part[ 'cache' ] ) && $part[ 'cache' ] === '1' ) {
                    $post_list_preload_flg[ 'taxonomy-' . $page ][ $part_id ] = $part_value[ 'slug' ];
                }
            }
        }
        foreach( (array)$page_list[ 'single' ] as $page => $page_name ) {
            if ( isset( $part[ 'type' ] ) && $part[ 'type' ] !== 'taxonomy' && ( !isset( $hidden[ 'single-' . $page ] ) || !in_array( $part_id, $hidden[ 'single-' . $page ], true ) ) ) {
                $select_hidden = isset( $part[ 'hidden' ][ 'single-' . $page . '-in' ] ) && $part[ 'hidden' ][ 'single-' . $page . '-in' ] !== '' ? explode( ',', $part[ 'hidden' ][ 'single-' . $page . '-in' ] ) : false;
                
                //記事ページでカテゴリー指定を確認
                $select_hidden_taxs = array();
                foreach( (array)$page_list[ 'taxonomy' ] as $tax_slug => $tax_val ) {
                    if ( isset( $part[ 'hidden' ][ 'single-' . $page . '-' . $tax_slug . '-in' ] ) && $part[ 'hidden' ][ 'single-' . $page . '-' . $tax_slug . '-in' ] !== '' ) {
                        $select_hidden_taxs[ $tax_slug ] = explode( ',', $part[ 'hidden' ][ 'single-' . $page . '-' . $tax_slug . '-in' ] );
                    }
                }
                //記事ページで作成者指定を確認
                $select_hidden_author = isset( $part[ 'hidden' ][ 'single-' . $page . '-author-in' ] ) && $part[ 'hidden' ][ 'single-' . $page . '-author-in' ] !== '' ? explode( ',', $part[ 'hidden' ][ 'single-' . $page . '-author-in' ] ) : false;
                
                if ( isset( $part[ 'hidden' ][ 'single-' . $page ] ) && $part[ 'hidden' ][ 'single-' . $page ] !== '' ) {
                    if ( $select_hidden !== false || ( is_array( $select_hidden_taxs ) && count( $select_hidden_taxs ) > 0 ) || $select_hidden_author !== false ) {
                        $part_value[ 'hidden' ] = true;
                        if ( $select_hidden !== false ) {
                            $part_value[ 'hidden-in' ] = $select_hidden;
                        }
                        if ( is_array( $select_hidden_taxs ) && count( $select_hidden_taxs ) > 0 ) {
                            $part_value[ 'hidden-tax' ] = $select_hidden_taxs;
                        }
                        if ( $select_hidden_author !== false ) {
                            $part_value[ 'hidden-author' ] = $select_hidden_author;
                        }
                        $page_value[ 'single-' . $page ][ $part_id ] = $part_value;
                    }
                } else {
                    if ( $select_hidden !== false || ( is_array( $select_hidden_taxs ) && count( $select_hidden_taxs ) > 0 ) || $select_hidden_author !== false ) {
                        $part_value[ 'hidden' ] = false;
                        if ( $select_hidden !== false ) {
                            $part_value[ 'hidden-in' ] = $select_hidden;
                        }
                        if ( is_array( $select_hidden_taxs ) && count( $select_hidden_taxs ) > 0 ) {
                            $part_value[ 'hidden-tax' ] = $select_hidden_taxs;
                        }
                        if ( $select_hidden_author !== false ) {
                            $part_value[ 'hidden-author' ] = $select_hidden_author;
                        }
                    }
                    $page_value[ 'single-' . $page ][ $part_id ] = $part_value;
                }
                
                //CSS判定
                if ( isset( $part[ 'slug' ] ) && $part[ 'slug' ] === 'single-content' && ( !isset( $part[ 'option' ][ 'block-css' ] ) || ( isset( $part[ 'option' ][ 'block-css' ] ) && $part[ 'option' ][ 'block-css' ] === '1' ) ) ) {
                    if ( isset( $part[ 'critical' ] ) && $part[ 'critical' ] === '1' ) {
                        $single_content_css_flg[ 'single-' . $page ][ 'block-critical' ] = true;
                    } else {
                        $single_content_css_flg[ 'single-' . $page ][ 'block' ] = true;
                    }
                }
                if ( isset( $part[ 'slug' ] ) && $part[ 'slug' ] === 'single-content' && ( !isset( $part[ 'option' ][ 'dg-css' ] ) || ( isset( $part[ 'option' ][ 'dg-css' ] ) && $part[ 'option' ][ 'dg-css' ] === '1' ) ) ) {
                    if ( isset( $part[ 'critical' ] ) && $part[ 'critical' ] === '1' ) {
                        $single_content_css_flg[ 'single-' . $page ][ 'dg-critical' ] = true;
                    } else {
                        $single_content_css_flg[ 'single-' . $page ][ 'dg' ] = true;
                    }
                }
                
                if ( isset( $preload_parts[ $part_id ] ) ) {
                    $preload[ 'single-' . $page ][] = $preload_parts[ $part_id ];
                }
                //記事リストがキャッシュ設定時にpreloadするように
                if ( isset( $part_value[ 'slug' ] ) && in_array( $part_value[ 'slug' ], $preload_slugs, true ) === true && isset( $part[ 'preload' ] ) && $part[ 'preload' ] === '1' && isset( $part[ 'cache' ] ) && $part[ 'cache' ] === '1' ) {
                    $post_list_preload_flg[ 'single-' . $page ][ $part_id ] = $part_value[ 'slug' ];
                }
            }
        }
        foreach( (array)$page_list[ 'other' ] as $page => $page_name ) {
            if ( $page === 404 ) {
                if ( isset( $part[ 'type' ] ) && ( isset( $part[ 'type' ] ) && $part[ 'type' ] !== 'single' ) && ( $part[ 'slug' ] === 'taxonomy-title' || $part[ 'type' ] !== 'taxonomy' ) && ( !isset( $hidden[ 'other-' . $page ] ) || !in_array( $part_id, $hidden[ 'other-' . $page ], true ) ) && ( !isset( $part[ 'hidden' ][ 'other-' . $page ] ) || ( isset( $part[ 'hidden' ][ 'other-' . $page ] ) && $part[ 'hidden' ][ 'other-' . $page ] === '' ) ) ) {
                    $page_value[ 'other-' . $page ][ $part_id ] = $part_value;
                    
                    if ( isset( $preload_parts[ $part_id ] ) ) {
                        $preload[ 'other-' . $page ][] = $preload_parts[ $part_id ];
                    }
                }
                //記事リストがキャッシュ設定時にpreloadするように
                if ( isset( $part_value[ 'slug' ] ) && in_array( $part_value[ 'slug' ], $preload_slugs, true ) === true && isset( $part[ 'preload' ] ) && $part[ 'preload' ] === '1' && isset( $part[ 'cache' ] ) && $part[ 'cache' ] === '1' ) {
                    $post_list_preload_flg[ 'other-' . $page ][ $part_id ] = $part_value[ 'slug' ];
                }
            } else {
                if ( isset( $part[ 'type' ] ) && $part[ 'type' ] !== 'single' && ( !isset( $hidden[ 'other-' . $page ] ) || !in_array( $part_id, $hidden[ 'other-' . $page ], true ) ) ) {
                    $select_hidden = isset( $part[ 'hidden' ][ 'other-' . $page . '-in' ] ) && $part[ 'hidden' ][ 'other-' . $page . '-in' ] !== '' ? explode( ',', $part[ 'hidden' ][ 'other-' . $page . '-in' ] ) : false;
                    if ( isset( $part[ 'hidden' ][ 'other-' . $page ] ) && $part[ 'hidden' ][ 'other-' . $page ] !== '' ) {
                        if ( $select_hidden !== false ) {
                            $part_value[ 'hidden' ] = true;
                            $part_value[ 'hidden-in' ] = $select_hidden;
                            $page_value[ 'other-' . $page ][ $part_id ] = $part_value;
                        }
                    } else {
                        if ( $select_hidden !== false ) {
                            $part_value[ 'hidden' ] = false;
                            $part_value[ 'hidden-in' ] = $select_hidden;
                        }
                        $page_value[ 'other-' . $page ][ $part_id ] = $part_value;
                    }
                    if ( isset( $preload_parts[ $part_id ] ) ) {
                        $preload[ 'other-' . $page ][] = $preload_parts[ $part_id ];
                    }
                    //メイン記事リスト判定
                    if ( isset( $part_value[ 'slug' ] ) && ( $part_value[ 'slug' ] === 'taxonomy-post_list' || $part_value[ 'slug' ] === 'taxonomy-paging' ) ) {
                        $main_post_list_flg[ 'other-' . $page ] = true;
                    }
                    //記事リストがキャッシュ設定時にpreloadするように
                    if ( isset( $part_value[ 'slug' ] ) && in_array( $part_value[ 'slug' ], $preload_slugs, true ) === true && isset( $part[ 'preload' ] ) && $part[ 'preload' ] === '1' && isset( $part[ 'cache' ] ) && $part[ 'cache' ] === '1' ) {
                        $post_list_preload_flg[ 'other-' . $page ][ $part_id ] = $part_value[ 'slug' ];
                    }
                }
            }
        }

        foreach( (array)$page_list[ 'custom-post-archive' ] as $page => $page_name ) {
            if ( isset( $part[ 'type' ] ) && $part[ 'type' ] !== 'single' && ( !isset( $hidden[ 'custom-post-archive-' . $page ] ) || !in_array( $part_id, $hidden[ 'custom-post-archive-' . $page ], true ) ) ) {
                $select_hidden = isset( $part[ 'hidden' ][ 'custom-post-archive-' . $page . '-in' ] ) && $part[ 'hidden' ][ 'custom-post-archive-' . $page . '-in' ] !== '' ? explode( ',', $part[ 'hidden' ][ 'custom-post-archive-' . $page . '-in' ] ) : false;
                if ( isset( $part[ 'hidden' ][ 'custom-post-archive-' . $page ] ) && $part[ 'hidden' ][ 'custom-post-archive-' . $page ] !== '' ) {
                    if ( $select_hidden !== false ) {
                        $part_value[ 'hidden' ] = true;
                        $part_value[ 'hidden-in' ] = $select_hidden;
                        $page_value[ 'custom-post-archive-' . $page ][ $part_id ] = $part_value;
                    }
                } else {
                    if ( $select_hidden !== false ) {
                        $part_value[ 'hidden' ] = false;
                        $part_value[ 'hidden-in' ] = $select_hidden;
                    }
                    $page_value[ 'custom-post-archive-' . $page ][ $part_id ] = $part_value;
                }
                if ( isset( $preload_parts[ $part_id ] ) ) {
                    $preload[ 'custom-post-archive-' . $page ][] = $preload_parts[ $part_id ];
                }
                //メイン記事リスト判定
                if ( isset( $part_value[ 'slug' ] ) && ( $part_value[ 'slug' ] === 'taxonomy-post_list' || $part_value[ 'slug' ] === 'taxonomy-paging' ) ) {
                    $main_post_list_flg[ 'custom-post-archive-' . $page ] = true;
                }
                //記事リストがキャッシュ設定時にpreloadするように
                if ( isset( $part_value[ 'slug' ] ) && in_array( $part_value[ 'slug' ], $preload_slugs, true ) === true && isset( $part[ 'preload' ] ) && $part[ 'preload' ] === '1' && isset( $part[ 'cache' ] ) && $part[ 'cache' ] === '1' ) {
                    $post_list_preload_flg[ 'custom-post-archive-' . $page ][ $part_id ] = $part_value[ 'slug' ];
                }
            }
        }
    }
    
    //検索フォーム用のタクソノミーリスト取得
    $tax_names = array_unique( $tax_names );
    $tax_names = array_values( $tax_names );
    
    //グローバルメニューリスト
    $gmenu_names = array_unique( $gmenu_names );
    $gmenu_names = array_values( $gmenu_names );
    
    //postmetaキー重複削除
    $postmeta_keys = array_unique( $postmeta_keys );
    $postmeta_keys = array_values( $postmeta_keys );
    
    //記事コンテンツパーツ用
    $post_ids = array_unique( $post_ids );
    $post_ids = array_values( $post_ids );
    
    //記事コンテンツパーツ用
    $contact_ids = array_unique( $contact_ids );
    $contact_ids = array_values( $contact_ids );
    
    //ユーザーページサムネイル
    $user_fields = array_unique( $user_fields );
    $user_fields = array_values( $user_fields );
    $user_fields_data = array(
        'field' => $user_fields,
        'option' => $user_options,
    );
    
    /* 重複削除 */
    if ( isset( $display_part[ 'top' ] ) ) {
        $display_part[ 'top' ] = array_unique( $display_part[ 'top' ] );
        $display_part[ 'top' ] = array_values( $display_part[ 'top' ] );
    }
    if ( isset( $hidden[ 'top' ] ) ) {
        $hidden[ 'top' ] = array_unique( $hidden[ 'top' ] );
        $hidden[ 'top' ] = array_values( $hidden[ 'top' ] );
    }
    foreach( (array)$page_types as $page_type ) {
        foreach( (array)$page_list[ $page_type ] as $page => $page_name ) {
            if ( isset( $display_part[ $page_type . '-' . $page ] ) ) {
                $display_part[ $page_type . '-' . $page ] = array_unique( $display_part[ $page_type . '-' . $page ] );
                $display_part[ $page_type . '-' . $page ] = array_values( $display_part[ $page_type . '-' . $page ] );
            }
            if ( isset( $hidden[ $page_type . '-' . $page ] ) ) {
                $hidden[ $page_type . '-' . $page ] = array_unique( $hidden[ $page_type . '-' . $page ] );
                $hidden[ $page_type . '-' . $page ] = array_values( $hidden[ $page_type . '-' . $page ] );
            }
        }
    }
    //デバイス取得
    $device = array( 320 => 'sp', 560 => 'tb', 960 => 'pc' );
    if ( isset( $site_value[ 'ORIGINALDEVICE' ] ) && is_array( $site_value[ 'ORIGINALDEVICE' ] ) && count( $site_value[ 'ORIGINALDEVICE' ] ) > 0 ) {
        $device = $site_value[ 'ORIGINALDEVICE' ];
        unset( $site_value[ 'ORIGINALDEVICE' ] );
        if ( $lp === false && $test_type === false ) {
            update_option( 'DG_device_value', json_encode( $device ) );
        }
    } else {
        $device_option = get_option( 'DG_device_value', '' );
        if ( $device_option !== '' ) {
            $device = json_decode( $device_option, true );
        }
    }
    
    /* サイト内部移動オプション */
    $scroll = array();
    if ( isset( $site_value[ 'page' ][ 'option' ][ 'move' ] ) && $site_value[ 'page' ][ 'option' ][ 'move' ] !== '' ) {
        $scroll[ 'move' ] = $site_value[ 'page' ][ 'option' ][ 'move' ];
    }
    if ( isset( $site_value[ 'page' ][ 'option' ][ 'speed' ] ) && $site_value[ 'page' ][ 'option' ][ 'speed' ] !== '' ) {
        $scroll[ 'speed' ] = $site_value[ 'page' ][ 'option' ][ 'speed' ];
    }
    //ページリスト取得
    $all_pages = array( 'top' );
    foreach( (array)$page_types as $page_type ) {
        foreach( (array)$page_list[ $page_type ] as $page => $page_name ) {
            $all_pages[] = $page_type . '-' . $page;
        }
    }
    // ライセンスチェック
    $license_key = get_option( 'DG_license_key', '' );
    $license_type = get_option( 'DG_license_type', '' );
    
    /* ページごとに保存する */
    $js_part_flg = array();
    $test_value_name = $test_type !== false ? $test_type : '';
    foreach( (array)$all_pages as $page ) {
        $main = isset( $page_value[ $page ] ) ? $page_value[ $page ] : array();
        $page_final_php = array(
            'main' => $main,
            'gmenu' => $gmenu_names,
            'terms' => $tax_names,
            'scroll' => $scroll,
            'pc_logo' => $pc_logo,
            'sp_logo' => $sp_logo,
            'no_image' => $no_image,
            'fixedImage' => $fixed_image,
            'loading_image' => $loading_image,
            'siteUrl' => $site_url,
        );
        if ( !isset( $main_post_list_flg[ $page ] ) ) {
            $page_final_php[ 'main_post_flg' ] = true;
        }
        if ( strpos( $page, 'single-' ) !== false ) {
            $page_final_php[ 'meta_keys' ] = $postmeta_keys;
        }
        if ( strpos( $page, 'taxonomy-' ) !== false ) {
            $page_final_php[ 'child_flg' ] = $child_term_flg;
        }
        if ( $page === 'other-author' ) {
            $page_final_php[ 'user_fields' ] = $user_fields_data;
        }
        //記事コンテンツパーツ用
        if ( is_array( $post_ids ) && count( $post_ids ) > 0 ) {
            $page_final_php[ 'select_post_ids' ] = $post_ids;
        }
        //記事コンテンツパーツ用
        if ( is_array( $contact_ids ) && count( $contact_ids ) > 0 ) {
            $page_final_php[ 'contact_ids' ] = $contact_ids;
        }
        if ( $lp !== false && $page === 'top' ) {
            $lp[ 'post_content' ] = wp_slash( json_encode( $page_final_php ) );
            wp_update_post( $lp );
        }
        if ( $lp === false  ) {
            update_option( 'DG_site_value_' . $test_value_name . $page, json_encode( $page_final_php ) );
        }
        //必要JSパーツ判定
        $js_part_flg[ $page ] = array();
        //ABテストリンク置換
        if ( $test_type !== false ) {
            $js_part_flg[ $page ][ '15-DGJS' ] = true;
        }
        if ( strpos( $page, 'single-' ) !== false ) {
            $js_part_flg[ $page ][ '2-DGJS' ] = true;
            $js_part_flg[ $page ][ '3-DGJS' ] = true;
            $js_part_flg[ $page ][ '20-DGJS' ] = true;
            $js_part_flg[ $page ][ 'SLIDER-DGJS' ] = true;
            $js_part_flg[ $page ][ 'CONTACT-DGJS' ] = true;
            $js_part_flg[ $page ][ 'ACCO-DGJS' ] = true;
            $js_part_flg[ $page ][ 'TAB-DGJS' ] = true;
            $js_part_flg[ $page ][ 'LIGHT-DGJS' ] = true;
            $js_part_flg[ $page ][ '24-DGJS' ] = true;
        }
        // ライセンスチェック
        if ( $license_key === '' && $license_type === '' ) {
            $js_part_flg[ $page ][ '99-DGJS' ] = true;
        }
        foreach( (array)$main as $part_id => $part_value ) {
            //スライドショー
            if ( ( isset( $part_value[ 'area-type' ] ) && $part_value[ 'area-type' ] === '3' ) || ( isset( $part_value[ 'slide' ][ 'display' ] ) && $part_value[ 'slide' ][ 'display' ] === '1' ) ) {
                $js_part_flg[ $page ][ 'SLIDER-DGJS' ] = true;
            }
            //タブ
            if ( isset( $part_value[ 'area-type' ] ) && $part_value[ 'area-type' ] === '2' ) {
                $js_part_flg[ $page ][ 'TAB-DGJS' ] = true;
            }
            if ( isset( $part_value[ 'slug' ] ) ) {
                //記事関連
                if ( $part_value[ 'slug' ] === 'post-content' ) {
                    $js_part_flg[ $page ][ 'CONTACT-DGJS' ] = true;
                    $js_part_flg[ $page ][ 'SLIDER-DGJS' ] = true;
                    $js_part_flg[ $page ][ 'ACCO-DGJS' ] = true;
                    $js_part_flg[ $page ][ 'TAB-DGJS' ] = true;
                    $js_part_flg[ $page ][ 'LIGHT-DGJS' ] = true;
                    $js_part_flg[ $page ][ '2-DGJS' ] = true;
                    $js_part_flg[ $page ][ '3-DGJS' ] = true;
                    $js_part_flg[ $page ][ '24-DGJS' ] = true;
                }
                
                //カテゴリーページング
                if ( $part_value[ 'slug' ] === 'taxonomy-paging' ) {
                    $type = isset( $part_value[ 'option' ][ 'type' ] ) ? $part_value[ 'option' ][ 'type' ] : '1';
                    if ( $type === '2' || $type === '4' ) {
                        $js_part_flg[ $page ][ '2-DGJS' ] = true;
                        $js_part_flg[ $page ][ '19-DGJS' ] = true;
                        $js_part_flg[ $page ][ 'POSTLIST-DGJS' ] = true;
                    } elseif ( $type === '3' ) {
                        $js_part_flg[ $page ][ '17-DGJS' ] = true;
                    }
                }
                //カテゴリーソート
                if ( $part_value[ 'slug' ] === 'taxonomy-sort' ) {
                    $js_part_flg[ $page ][ '18-DGJS' ] = true;
                }
                //ブックマーク&動画サムネイル
                if ( strpos( $part_value[ 'slug' ], 'post_list' ) !== false || $part_value[ 'slug' ] === 'single-recommend' ) {
                    if ( isset( $part_value[ 'option' ][ 'area' ] ) ) {
                        $area = $part_value[ 'option' ][ 'area' ];
                        foreach( (array)$area as $item_key => $item_value ) {
                            if ( strpos( $item_key, 'bookmark' ) !== false ) {
                                $js_part_flg[ $page ][ '2-DGJS' ] = true;
                                $js_part_flg[ $page ][ '3-DGJS' ] = true;
                                $js_part_flg[ $page ][ 'POSTLIST-DGJS' ] = true;
                            }
                            if ( strpos( $item_key, 'movie' ) !== false ) {
                                $js_part_flg[ $page ][ '10-DGJS' ] = true;
                            }
                            if ( strpos( $item_key, 'thumbnail' ) !== false && isset( $item_value[ 'option' ][ 'link-type' ] ) && $item_value[ 'option' ][ 'link-type' ] === '1' ) {
                                $js_part_flg[ $page ][ 'H2-DGJS' ] = true;
                                $js_part_flg[ $page ][ 'H3-DGJS' ] = true;
                                $js_part_flg[ $page ][ 'LIGHT-DGJS' ] = true;
                            }
                            if ( strpos( $item_key, 'more' ) !== false && isset( $item_value[ 'option' ][ 'link-type' ] ) && $item_value[ 'option' ][ 'link-type' ] === '2' ) {
                                $js_part_flg[ $page ][ 'CONTACT-DGJS' ] = true;
                                $js_part_flg[ $page ][ 'SLIDER-DGJS' ] = true;
                                $js_part_flg[ $page ][ 'ACCO-DGJS' ] = true;
                                $js_part_flg[ $page ][ 'TAB-DGJS' ] = true;
                                $js_part_flg[ $page ][ 'LIGHT-DGJS' ] = true;
                                $js_part_flg[ $page ][ '2-DGJS' ] = true;
                                $js_part_flg[ $page ][ '3-DGJS' ] = true;
                                $js_part_flg[ $page ][ '24-DGJS' ] = true;
                                $js_part_flg[ $page ][ '26-DGJS' ] = true;
                            }
                        }
                    }
                }
                if ( $part_value[ 'slug' ] === 'single-bookmark' ) {
                    $js_part_flg[ $page ][ '2-DGJS' ] = true;
                    $js_part_flg[ $page ][ '3-DGJS' ] = true;
                    $js_part_flg[ $page ][ 'POSTLIST-DGJS' ] = true;
                }
                
                //音声検索&カテゴリー指定
                if ( $part_value[ 'slug' ] === 'search-form' ) {
                    if ( isset( $part_value[ 'option' ][ 'area' ] ) ) {
                        $area = $part_value[ 'option' ][ 'area' ];
                        foreach( (array)$area as $item_key => $item_value ) {
                            if ( strpos( $item_key, 'speech' ) !== false ) {
                                $js_part_flg[ $page ][ '4-DGJS' ] = true;
                            }
                            if ( strpos( $item_key, 'tax-' ) !== false ) {
                                $js_part_flg[ $page ][ '9-DGJS' ] = true;
                            }
                        }
                    }
                    //リアルタイム検索の場合
                    if ( isset( $part_value[ 'option' ][ 'realtime' ] ) && $part_value[ 'option' ][ 'realtime' ] === '1' ) {
                        $js_part_flg[ $page ][ '2-DGJS' ] = true;
                        $js_part_flg[ $page ][ '25-DGJS' ] = true;
                        $js_part_flg[ $page ][ 'POSTLIST-DGJS' ] = true;
                        
                        if ( isset( $part_value[ 'option' ][ 'real' ] ) ) {
                            $real = $part_value[ 'option' ][ 'real' ];
                            foreach( (array)$real as $item_key => $item_value ) {
                                if ( strpos( $item_key, 'bookmark' ) !== false ) {
                                    $js_part_flg[ $page ][ '2-DGJS' ] = true;
                                    $js_part_flg[ $page ][ '3-DGJS' ] = true;
                                }
                                if ( strpos( $item_key, 'movie' ) !== false ) {
                                    $js_part_flg[ $page ][ '10-DGJS' ] = true;
                                }
                            }
                        }
                    }
                }
                
                //トーグル
                if ( $part_value[ 'slug' ] === 'text' || $part_value[ 'slug' ] === 'image' ) {
                    $tag = isset( $part_value[ 'option' ][ 'tag' ] ) ? $part_value[ 'option' ][ 'tag' ] : 'p';
                    $cookie_name = isset( $part_value[ 'option' ][ 'cookie-name' ] ) ? $part_value[ 'option' ][ 'cookie-name' ] : '';
                    if ( $tag === 'button' ) {
                        $toggle_type = isset( $part_value[ 'option' ][ 'toggle-type' ] ) ? $part_value[ 'option' ][ 'toggle-type' ] : '1';
                        if ( $toggle_type === '1' ) {
                            $js_part_flg[ $page ][ '5-DGJS' ] = true;
                        } elseif ( $toggle_type === '2' ) {
                            $js_part_flg[ $page ][ '7-DGJS' ] = true;
                        } elseif ( $toggle_type === '3' ) {
                            $js_part_flg[ $page ][ '12-DGJS' ] = true;
                        }
                        if ( $cookie_name !== '' ) {
                            $js_part_flg[ $page ][ '8-DGJS' ] = true;
                        }
                    } elseif ( $tag === 'a' ) {
                        $toggle_item = isset( $part_value[ 'option' ][ 'toggle-item' ] ) ? $part_value[ 'option' ][ 'toggle-item' ] : '';
                        if ( $toggle_item !== '' ) {
                            $js_part_flg[ $page ][ '5-DGJS' ] = true;
                        }
                        if ( $cookie_name !== '' ) {
                            $js_part_flg[ $page ][ '8-DGJS' ] = true;
                        }
                        $js_part_flg[ $page ][ '2-DGJS' ] = true;
                        $js_part_flg[ $page ][ '3-DGJS' ] = true;
                        $js_part_flg[ $page ][ 'LIGHT-DGJS' ] = true;
                    }
                }
                if ( isset( $part_value[ 'title' ][ 'text' ] ) && $part_value[ 'title' ][ 'text' ] !== '' && isset( $part_value[ 'title' ][ 'toggle-type' ] ) && $part_value[ 'title' ][ 'toggle-type' ] === '2' ) {
                    $js_part_flg[ $page ][ '5-DGJS' ] = true;
                }
                //スクロールイベント
                if ( isset( $part_value[ 'event' ] ) && is_array( $part_value[ 'event' ] ) && count( $part_value[ 'event' ] ) > 0 ) {
                    $js_part_flg[ $page ][ '11-DGJS' ] = true;
                }
                //html lazy
                if ( $part_value[ 'slug' ] === 'html' ) {
                    $js_part_flg[ $page ][ '2-DGJS' ] = true;
                    $js_part_flg[ $page ][ '3-DGJS' ] = true;
                    $js_part_flg[ $page ][ 'LIGHT-DGJS' ] = true;
                }
                if ( $part_value[ 'slug' ] === 'html' && isset( $part_value[ 'option' ][ 'lazy' ] ) && $part_value[ 'option' ][ 'lazy' ] === '1' ) {
                    $js_part_flg[ $page ][ '2-DGJS' ] = true;
                    $js_part_flg[ $page ][ '3-DGJS' ] = true;
                    $js_part_flg[ $page ][ '24-DGJS' ] = true;
                }
                //コメント
                if ( $part_value[ 'slug' ] === 'single-comment' ) {
                    $count = isset( $part_value[ 'option' ][ 'count' ] ) ? $part_value[ 'option' ][ 'count' ] : '1';
                    $list = isset( $part_value[ 'option' ][ 'list' ] ) ? $part_value[ 'option' ][ 'list' ] : '1';
                    $form = isset( $part_value[ 'option' ][ 'form' ] ) ? $part_value[ 'option' ][ 'form' ] : '1';
                    if ( $count === '1' || $list === '1' || $form === '1' ) {
                        $js_part_flg[ $page ][ '21-DGJS' ] = true;
                    }
                }
                //評価
                if ( $part_value[ 'slug' ] === 'single-evaluate' ) {
                    $form = isset( $part_value[ 'option' ][ 'form' ] ) ? $part_value[ 'option' ][ 'form' ] : '1';
                    if ( $form === '1' ) {
                        $js_part_flg[ $page ][ '22-DGJS' ] = true;
                    }
                }
                //GMENUトーグル
                if ( $part_value[ 'slug' ] === 'gmenu' && isset( $part_value[ 'option' ][ 'toggle' ] ) && $part_value[ 'option' ][ 'toggle' ] === '1' ) {
                    $js_part_flg[ $page ][ '6-DGJS' ] = true;
                }
                
                //お問い合わせフォーム
                if ( $part_value[ 'slug' ] === 'contact' ) {
                    $js_part_flg[ $page ][ 'CONTACT-DGJS' ] = true;
                }
            }
        }
    }
    
    $home_url = home_url();
    $site_update_time = date( 'YmdHis' );
    if( $lp === false ) {
        $image_option = array(
            'noImage' => $no_image,
            'loadingImg' => $loading_image,
        );
        if ( $test_type !== false ) {
            update_option( 'DG_image_option' . $test_type, json_encode( $image_option ) );
        } else {
            update_option( 'DG_image_option', json_encode( $image_option ) );
        }
        update_option( 'DG_site_value_update', $site_update_time );
    }
    
    //preloadコンテンツ保存
    if ( $test_type !== false ) {
        $scripts = get_option( 'DG_script_option' . $test_type );
        if ( $scripts === false ) {
            $scripts = get_option( 'DG_script_option' );
        }
    } else {
        $scripts = get_option( 'DG_script_option' );
    }
    if ( $scripts !== false ) {
        $scripts = json_decode( $scripts, true );
    } else {
        $scripts = array();
    }
    $scripts[ 'device' ] = $device;
    $scripts[ 'site_update' ] = $site_update_time;
    $scripts[ 'stylesheet_url' ] = $stylesheet_url;
    $scripts[ 'site_name' ] = get_option( 'blogname', '' );
    $scripts[ 'site_url' ] = $site_url;
    $scripts[ 'home_url' ] = $home_url;
    $scripts[ 'ajax_url' ] = admin_url( 'admin-ajax.php' );
    $scripts[ 'locale' ] = get_locale();
    $scripts[ 'post_preload' ] = $post_list_preload_flg;
    /* WP専用ファイル読み込み */
    require_once( ABSPATH . 'wp-admin/includes/file.php' );
    if ( WP_Filesystem() ) {
        global $wp_filesystem;
        $directory_path = get_template_directory();
        $upload_dir = wp_upload_dir();
        $directory_path_js = $upload_dir[ 'basedir' ] . '/design-json/js/';
        $directory_path_css = $upload_dir[ 'basedir' ] . '/design-json/css/';
        $directory_path_editor_css = $upload_dir[ 'basedir' ] . '/design-json/editor-css/';
        if ( $test_type !== false ) {
            $directory_path_js .= $test_type . '/';
            $directory_path_css .= $test_type . '/';
            $directory_path_editor_css .= $test_type . '/';
        }
        //CSSフォルダー初期化
        //ABテストで不要になったもの削除
        if( $lp === false ) {//LP作成じゃない場合のみ
            //フォルダー作成
            if ( !file_exists( $directory_path_js ) ) {
                if ( !mkdir( $directory_path_js, 0777, true ) ) {
                    return false;
                }
            }
            if ( !file_exists( $directory_path_css ) ) {
                if ( !mkdir( $directory_path_css, 0777, true ) ) {
                    return false;
                }
            }
            if ( !file_exists( $directory_path_editor_css ) ) {
                if ( !mkdir( $directory_path_editor_css, 0777, true ) ) {
                    return false;
                }
            }
            $DG_abtest_designs = get_option( 'DG_abtest_designs', '' );
            if ( $DG_abtest_designs !== '' ) {
                $DG_abtest_designs = json_decode( $DG_abtest_designs, true );
                if ( is_array( $DG_abtest_designs ) && count( $DG_abtest_designs ) > 0 ) {
                    $test_names = array();
                    foreach( (array)$DG_abtest_designs as $design_name => $test_name ) {
                        $test_names[ $test_name ] = $test_name;
                    }
                    //フロント用CSS
                    $js_dirs = glob( $directory_path_js . '*', GLOB_ONLYDIR );
                    foreach( (array)$js_dirs as $path ) {
                        $dir_name = basename( $path );
                        if ( !isset( $test_names[ $dir_name ] ) ) {
                            $wp_filesystem->rmdir( $path, true );
                        }
                    }
                    //フロント用CSS
                    $css_dirs = glob( $directory_path_css . '*', GLOB_ONLYDIR );
                    foreach( (array)$css_dirs as $path ) {
                        $dir_name = basename( $path );
                        if ( !isset( $test_names[ $dir_name ] ) ) {
                            $wp_filesystem->rmdir( $path, true );
                        }
                    }
                    //エディター用CSS
                    $editor_css_dirs = glob( $directory_path_editor_css . '*', GLOB_ONLYDIR );
                    foreach( (array)$editor_css_dirs as $path ) {
                        $dir_name = basename( $path );
                        if ( !isset( $test_names[ $dir_name ] ) ) {
                            $wp_filesystem->rmdir( $path, true );
                        }
                    }
                }
            }
            //ABテスト用スクリプト作成より、ABテストコード削除
            foreach( (array)$scripts as $sc_key => $sc ) {
                if ( strpos( $sc_key, 'css_path' ) !== false ) {
                    if ( $sc_key !== 'css_path' ) {
                        unset( $scripts[ $sc_key ] );
                    }
                }
                if ( strpos( $sc_key, 'critical' ) !== false ) {
                    if ( $sc_key !== 'critical' ) {
                        unset( $scripts[ $sc_key ] );
                    }
                }
                if ( strpos( $sc_key, 'js_path' ) !== false ) {
                    if ( $sc_key !== 'js_path' ) {
                        unset( $scripts[ $sc_key ] );
                    }
                }
            }

            //適用するCSSフォルダー初期化
            if ( file_exists( $directory_path_js ) ) {
                $js_files = glob( $directory_path_js . '*.js', GLOB_BRACE );
                if ( $js_files !== false && is_array( $js_files ) && count( $js_files ) > 0 ) {
                    foreach( (array)$js_files as $path ) {
                        $root_file_name = basename( $path );
                        $wp_filesystem->rmdir( $directory_path_js . $root_file_name, true );
                    }
                }
            }
            //適用するCSSフォルダー初期化
            if ( file_exists( $directory_path_css ) ) {
                $css_files = glob( $directory_path_css . '*.css', GLOB_BRACE );
                if ( $css_files !== false && is_array( $css_files ) && count( $css_files ) > 0 ) {
                    foreach( (array)$css_files as $path ) {
                        $root_file_name = basename( $path );
                        $wp_filesystem->rmdir( $directory_path_css . $root_file_name, true );
                    }
                }
            }
        }
        //テンプレートデフォルトCSS取得
        $default_css = '';
        $default_css_url = $directory_path . '/css/temp/template_default_first.css';
        if ( file_exists( $default_css_url ) ) {
            $default_css = $wp_filesystem->get_contents( $default_css_url );
            $default_css = preg_replace( '/\/\*.*?\*\//s', '', $default_css );
            $default_css = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $default_css );
            $default_css = preg_replace( '/\s\s/', '', $default_css );
        }
        //テンプレートデフォルトCSS取得
        $default2_css = '';
        $default2_css_url = $directory_path . '/css/temp/template_default_second.css';
        if ( file_exists( $default2_css_url ) ) {
            $default2_css = $wp_filesystem->get_contents( $default2_css_url );
            $default2_css = preg_replace( '/\/\*.*?\*\//s', '', $default2_css );
            $default2_css = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $default2_css );
            $default2_css = preg_replace( '/\s\s/', '', $default2_css );
        }
        $block_css = '';
        $block_css_url = ABSPATH . 'wp-includes/css/dist/block-library/style.min.css';
        if ( file_exists( $block_css_url ) ) {
            $block_css = $wp_filesystem->get_contents( $block_css_url );
            $block_css = preg_replace( '/\/\*.*?\*\//s', '', $block_css );
            $block_css = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $block_css );
            $block_css = preg_replace( '/\s\s/', '', $block_css );
        }
        $dg_css = '';
        $dg_css_sp_url = $directory_path . '/css/temp/dg_style_default_sp.css';
        if ( file_exists( $dg_css_sp_url ) ) {
            $dg_css = $wp_filesystem->get_contents( $dg_css_sp_url );
            $dg_css = preg_replace( '/\/\*.*?\*\//s', '', $dg_css );
            $dg_css = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $dg_css );
            $dg_css = preg_replace( '/\s\s/', '', $dg_css );
        }
        $dg_css_tb = '';
        $dg_css_tb_url = $directory_path . '/css/temp/dg_style_default_tb.css';
        if ( file_exists( $dg_css_tb_url ) ) {
            $dg_css_tb = $wp_filesystem->get_contents( $dg_css_tb_url );
            $dg_css_tb = preg_replace( '/\/\*.*?\*\//s', '', $dg_css_tb );
            $dg_css_tb = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $dg_css_tb );
            $dg_css_tb = preg_replace( '/\s\s/', '', $dg_css_tb );
        }
        $dg_css_pc = '';
        $dg_css_pc_url = $directory_path . '/css/temp/dg_style_default_pc.css';
        if ( file_exists( $dg_css_pc_url ) ) {
            $dg_css_pc = $wp_filesystem->get_contents( $dg_css_pc_url );
            $dg_css_pc = preg_replace( '/\/\*.*?\*\//s', '', $dg_css_pc );
            $dg_css_pc = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $dg_css_pc );
            $dg_css_pc = preg_replace( '/\s\s/', '', $dg_css_pc );
        }
        /* フォント設定 */
        $font_family = '"ヒラギノ角ゴ Pro W3", "Hiragino Kaku Gothic Pro", "メイリオ", Meiryo, Osaka, "ＭＳ Ｐゴシック", "MS PGothic", sans-serif';
        //フォントをオリジナル値で上書き
        if ( isset( $site_value[ 'ORIGINALFONT' ] ) ) {
            $scripts[ 'font' ] = $site_value[ 'ORIGINALFONT' ];
            unset( $site_value[ 'ORIGINALFONT' ] );
        }
        if ( isset( $scripts[ 'font' ] ) && $scripts[ 'font' ] !== '' ) {
            $font_json = $scripts[ 'font' ];
            if ( isset( $font_json[ 'base' ] ) && $font_json[ 'base' ] === 'serif' ) {
                $font_family = '"Hiragino Mincho ProN W3", "ヒラギノ明朝 ProN W3", "Hiragino Mincho ProN", "HG明朝E", "ＭＳ Ｐ明朝", "ＭＳ 明朝", serif';
            }
            if ( ( !isset( $font_json[ 'free' ] ) || ( isset( $font_json[ 'free' ] ) && $font_json[ 'free' ] === '' ) ) && isset( $font_json[ 'fonts' ] ) && is_array( $font_json[ 'fonts' ] ) && count( $font_json[ 'fonts' ] ) > 0 ) {
                $google_font = '';
                foreach( (array)$font_json[ 'fonts' ] as $font_name => $font_val ) {
                    $google_font .= '"' . str_replace( '+', ' ', $font_name ) . '",';
                }
                $font_family = $google_font . $font_family;
                //font
                foreach( (array)$all_pages as $page ) {
                    $js_part_flg[ $page ][ '13-DGJS' ] = true;
                }
            }
        }
        
        $html_css = <<< EOM
            html {
                font-family: {$font_family};
                font-size:62.5%;
                line-height: 1.7;
                -ms-text-size-adjust: 100%;
                -webkit-text-size-adjust: 100%;
            }
            .page-loader-area {
                display: flex;
                justify-content: center;
                align-items: center;
                width: 100%;
                height: 100%;
                position: absolute;
                top: 0;
                left: 0;
                background: rgba(0,0,0,0.5);
                z-index: 100;
            }
            .page-loader {
                display: block;
                width: 25px;
                flex: 0 0 25px;
                height: 25px;
                background: url("{$loading_image}") no-repeat;
                background-size: 100% auto;
                background-position: center;
            }
            @font-face {
                font-family: 'webicon';
                src:  url('{$stylesheet_url}/css/webicon/icomoon.eot?wwza6v');
                src:  url('{$stylesheet_url}/css/webicon/icomoon.eot?wwza6v#iefix') format('embedded-opentype'),
                url('{$stylesheet_url}/css/webicon/icomoon.ttf?wwza6v') format('truetype'),
                url('{$stylesheet_url}/css/webicon/icomoon.woff?wwza6v') format('woff'),
                url('{$stylesheet_url}/css/webicon/icomoon.svg?wwza6v#icomoon') format('svg');
                font-weight: normal;
                font-style: normal;
                font-display: swap;
            }
EOM;
        $html_css = preg_replace( '/\/\*.*?\*\//s', '', $html_css );
        $html_css = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $html_css );
        $html_css = preg_replace( '/\s\s/', '', $html_css );
        
        //色取得
        $design_path = $upload_dir[ 'basedir' ] . '/design-json/template/color.json';
        $color_value = false;
        if ( isset( $site_value[ 'ORIGINALCOLOR' ] ) ) {
            $color_value = $site_value[ 'ORIGINALCOLOR' ];
            unset( $site_value[ 'ORIGINALCOLOR' ] );
        } elseif ( is_file( $design_path ) ) {
            $part_file = $wp_filesystem->get_contents( $design_path );
            $color_value = json_decode( $part_file, true );
        }
        //エディター表示用カラー保存
        if ( $lp === false && $color_value !== false && $test_type === false ) {
            $editor_color_palette = array();
            if ( isset( $color_value[ 'select' ] ) && isset( $color_value[ 'palette' ][ $color_value[ 'select' ] ] ) ) {
                $palette = $color_value[ 'palette' ][ $color_value[ 'select' ] ];
                foreach( (array)$palette as $key => $code ) {
                    if ( $key !== 'label' ) {
                        $editor_color_palette[] = array(
                            'name' => $key . __( '色', 'dg-style' ),
                            'slug' =>  'post-' . preg_replace( '/([0-9])/', '-$1', $key ),
                            'color' => $code,
                        );
                    }
                }
            }
            if ( isset( $color_value[ 'colorset' ] ) && is_array( $color_value[ 'colorset' ] ) && count( $color_value[ 'colorset' ] ) > 0 ) {
                foreach( (array)$color_value[ 'colorset' ] as $key => $code ) {
                    $editor_color_palette[] = array(
                        'name' => $code[ 'name' ] . __( '色', 'dg-style' ),
                        'slug' =>  'post-' . $key,
                        'color' => $code[ 'color' ],
                    );
                }
            }
            update_option( 'DG_site_editor_colors', $editor_color_palette );
        }
        //マーカー色作成
        $markers = get_option( 'DG_marker_colors', false );
        $marker_colors = array();
        if ( $markers !== false ) {
            $marker_colors = json_decode( wp_unslash( $markers ), true );
        }
        foreach( array( 'blue' => '#9eceff', 'yellow' => '#fff799', 'pink' => '#ffc1e0', 'green' => '#b2ffb2', 'puple' => '#ce9eff', ) as $mk => $code ) {
            if ( !isset( $marker_colors[ $mk ] ) ) {
                $marker_colors[ $mk ] = $code;
            }
        }
        
        /* サイト用CSS保存 */
        $css = create_css_simulator( $page_value, $site_value, $device, $color_value, $marker_colors );
        $dark_mode_css = '';
        if ( isset( $css[ 'dark' ] ) ) {
            $dark_mode_css = $css[ 'dark' ];
        }
        $body_css = '';
        if ( isset( $css[ 'body' ] ) ) {
            $body_css = $css[ 'body' ];
        }
        
        $directory_uri_css = $upload_dir[ 'baseurl' ] . '/design-json/css/';
        if ( $test_type !== false ) {
            $directory_uri_css .= $test_type . '/';
        }
        $scripts[ 'css_path' ] = array();
        $scripts[ 'critical' ] = array();
        if ( $lp === false ) {
            $cnt = 0;
            foreach( (array)$all_pages as $page ) {
                $tb_flg = false;
                $pc_flg = false;
                foreach( (array)$device as $size => $type ) {
                    $css_path = $directory_path_css . $page . '-' . $type . '_style.css';
                    $complie = '';
                    if ( isset( $css[ $page ][ 'normal' ][ $type ] ) ) {
                        if ( $cnt === 0 ) {
                            if ( isset( $css[ $page ][ 'critical' ][ $type ] ) && $css[ $page ][ 'critical' ][ $type ] !== '' ) {
                                $first_css = '';
                            } else {
                                $first_css = $dark_mode_css . $html_css . $default_css . $body_css . $default2_css;
                            }
                            if ( preg_match( '/^single/', $page ) ) {
                                $color_css = '';
                                //block css追加
                                if ( isset( $single_content_css_flg[ $page ][ 'block' ] ) && $single_content_css_flg[ $page ][ 'block' ] === true ) {
                                    $first_css .= $block_css;
                                    $color_css = $css[ 'color' ];
                                }
                                //テーマCSS追加
                                if ( isset( $single_content_css_flg[ $page ][ 'dg' ] ) && $single_content_css_flg[ $page ][ 'dg' ] === true ) {
                                    $first_css .= $dg_css;
                                    $color_css = $css[ 'color' ];
                                }
                                $complie = $first_css . $css[ $page ][ 'normal' ][ $type ] . $color_css . $css[ 'anime' ];
                            } else {
                                $complie = $first_css . $css[ $page ][ 'normal' ][ $type ] . $css[ 'color' ] . $css[ 'anime' ];
                            }
                        } else {
                            $first_css = '';
                            if ( $tb_flg === false && preg_match( '/^tb/', $type ) && isset( $single_content_css_flg[ $page ][ 'dg' ] ) && $single_content_css_flg[ $page ][ 'dg' ] === true ) {
                                $first_css = $dg_css_tb;
                                $tb_flg = true;
                            }
                            if ( $pc_flg === false && preg_match( '/^pc/', $type ) && isset( $single_content_css_flg[ $page ][ 'dg' ] ) && $single_content_css_flg[ $page ][ 'dg' ] === true ) {
                                $first_css = $dg_css_pc;
                                $pc_flg = true;
                            }
                            $complie = $first_css . $css[ $page ][ 'normal' ][ $type ];
                        }
                    }
                    if ( isset( $css[ $page ][ 'critical' ][ $type ] ) && $css[ $page ][ 'critical' ][ $type ] !== '' ) {
                        $critical = $css[ $page ][ 'critical' ][ $type ];
                        $critical = str_replace( 'http://', '//', $critical );
                        $critical = str_replace( 'https://', '//', $critical );
                        if ( $cnt === 0 ) {
                            $color_css = '';
                            $gutenberg_css = '';
                            if ( isset( $single_content_css_flg[ $page ][ 'block-critical' ] ) && $single_content_css_flg[ $page ][ 'block-critical' ] === true ) {
                                $gutenberg_css .= $block_css;
                                $color_css = $css[ 'color' ];
                            }
                            //テーマCSS追加
                            if ( isset( $single_content_css_flg[ $page ][ 'dg-critical' ] ) && $single_content_css_flg[ $page ][ 'dg-critical' ] === true ) {
                                $gutenberg_css .= $dg_css;
                                $color_css = $css[ 'color' ];
                            }
                            $scripts[ 'critical' ][ $page ][ $type ] = $dark_mode_css . $html_css . $default_css . $body_css . $default2_css . $gutenberg_css . $critical . $color_css;
                        } else {
                            $gutenberg_css = '';
                            if ( $tb_flg === false && preg_match( '/^tb/', $type ) && isset( $single_content_css_flg[ $page ][ 'dg-critical' ] ) && $single_content_css_flg[ $page ][ 'dg-critical' ] === true ) {
                                $gutenberg_css = $dg_css_tb;
                                $tb_flg = true;
                            }
                            if ( $pc_flg === false && preg_match( '/^pc/', $type ) && isset( $single_content_css_flg[ $page ][ 'dg-critical' ] ) && $single_content_css_flg[ $page ][ 'dg-critical' ] === true ) {
                                $gutenberg_css = $dg_css_pc;
                                $pc_flg = true;
                            }
                            $scripts[ 'critical' ][ $page ][ $type ] = $gutenberg_css . $critical;
                        }
                        //CSS
                        $js_part_flg[ $page ][ '14-DGJS' ] = true;
                    }
                    //display classセット
                    $complie = '.no-view{display:none;} .view-display-' . $type . '{display:block;}' . $complie;
                    // http://削除
                    $complie = str_replace( 'http://', '//', $complie );
                    $complie = str_replace( 'https://', '//', $complie );
                    if ( $complie !== '' ) {
                        $css_data = mb_convert_encoding( '@charset "utf-8"; ' . $complie , 'utf-8' );
                        $wp_filesystem->put_contents( $css_path, $css_data );
                        $css_uri = $directory_uri_css . $page . '-' . $type . '_style.css?update=' . $site_update_time;
                        $scripts[ 'css_path' ][ $page ][ $type ] = $css_uri;
                    }
                    ++$cnt;
                    if ( end( $device ) === $type ) {
                        $cnt = 0;
                    }
                }
            }
        } else {
            $cnt = 0;
            //LP用のCSSはインライン化
            foreach( (array)$device as $size => $type ) {
                $css_data = '';
                if ( $cnt === 0 ) {
                    $css_data = $dark_mode_css . $html_css . $default_css . $body_css . $default2_css;
                }
                if ( isset( $css[ 'top' ][ 'critical' ][ $type ] ) ) {
                    $critical = $css[ 'top' ][ 'critical' ][ $type ];
                    $critical = str_replace( 'http://', '//', $critical );
                    $css_data .= str_replace( 'https://', '//', $critical );
                }
                $css_data .= isset( $css[ 'top' ][ 'normal' ][ $type ] ) ? $css[ 'top' ][ 'normal' ][ $type ] : '';
                if ( $cnt === 0 ) {
                    $css_data .= $css[ 'color' ] . $css[ 'anime' ];
                }
                $scripts[ 'critical' ][ 'top' ][ $type ] = $css_data;
            }
        }
        
        /* サブ値保存（SPA専用） */
        $sub_value = array(
            'display' => $display_part,
            'taxonomy' => $taxonomy_part,
            'single' => $single_part,
            'hidden' => $hidden,
            'real' => $realtime,
            'css' => $scripts[ 'css_path' ],
            'critical' => $scripts[ 'critical' ],
            'device' => $device,
        );
        if ( $lp === false ) {
            update_option( 'DG_site_sub_value' . $test_value_name, json_encode( $sub_value ) );
        } else {
            update_post_meta( $lp[ 'ID' ], 'DG_site_sub_value', wp_slash( json_encode( $sub_value ) ) );
        }
        
        /* エディター用CSS保存 */
        if ( $lp === false && isset( $css[ 'editor' ] ) ) {
            $default_editor_css = <<< EOM
                @font-face {
                    font-family: 'webicon';
                    src:  url('{$stylesheet_url}/css/webicon/icomoon.eot?wwza6v');
                    src:  url('{$stylesheet_url}/css/webicon/icomoon.eot?wwza6v#iefix') format('embedded-opentype'),
                    url('{$stylesheet_url}/css/webicon/icomoon.ttf?wwza6v') format('truetype'),
                    url('{$stylesheet_url}/css/webicon/icomoon.woff?wwza6v') format('woff'),
                    url('{$stylesheet_url}/css/webicon/icomoon.svg?wwza6v#icomoon') format('svg');
                    font-weight: normal;
                    font-style: normal;
                    font-display: swap;
                }
                .edit-post-visual-editor .editor-styles-wrapper,
                .edit-post-visual-editor .editor-post-title .editor-post-title__input {
                    font-family: ' . $font_family . ' !important;
                }
                #editor .edit-post-visual-editor .editor-styles-wrapper .wp-block {
                    margin-right: auto !important;
                    margin-left: auto !important;
                    position: relative !important;
                }
EOM;
            $dg_css_editor = '';
            $dg_css_editor_url = $directory_path . '/css/temp/dg_style_editor-default.css';
            if ( file_exists( $dg_css_editor_url ) ) {
                $dg_css_editor = $wp_filesystem->get_contents( $dg_css_editor_url );
                $dg_css_editor = preg_replace( '/\/\*.*?\*\//s', '', $dg_css_editor );
                $dg_css_editor = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $dg_css_editor );
                $dg_css_editor = preg_replace( '/\s\s/', '', $dg_css_editor );
            }
            $root_color = '';
            //root用CSSカラー設定
            if ( isset( $color_value[ 'select' ] ) && isset( $color_value[ 'palette' ][ $color_value[ 'select' ] ] ) ) {
                $palette = $color_value[ 'palette' ][ $color_value[ 'select' ] ];
                foreach( (array)$palette as $key => $code ) {
                    if ( $key !== 'label' ) {
                        $root_color .= '--' . $key . '-color:' . $code . ';';
                    }
                }
            }
            if ( isset( $site_value[ 'page' ][ 'dark' ] ) && $site_value[ 'page' ][ 'dark' ] !== '' ) {
                if ( isset( $site_value[ 'page' ][ 'dark' ][ 'root' ] ) && $site_value[ 'page' ][ 'dark' ][ 'root' ] !== '' ) {
                    $editor_root = replace_color_code( $color_value, $site_value[ 'page' ][ 'dark' ][ 'root' ] );
                    $root_color .= $editor_root;
                }
            }
            //マーカー色保存
            foreach( (array)$marker_colors as $mk => $mk_code ) {
                $root_color .= '--mk-' . $mk . ': ' . $mk_code . ';';
            }
            
            $editor_reset_css = '#wpwrap #editor .edit-post-visual-editor .editor-styles-wrapper { margin: 0 !important; padding: 10px 0 20vh !important; height: auto !important; min-height: 100% !important; width: 100% !important; position: relative !important; } #wpwrap #editor .edit-post-visual-editor .editor-styles-wrapper iframe { width: 100% !important; height: 100% !important; margin: 0 auto !important; } #wpwrap #editor .edit-post-visual-editor .editor-styles-wrapper .wp-block { margin-right: auto !important; margin-left: auto !important; position: relative !important; }';
            $editor_body_css = str_replace( 'important', '', $body_css );
            $editor_body_css = str_replace( ';', ' !important;', $editor_body_css );
            $editor_body_css = str_replace( 'body {' , '.edit-post-visual-editor .editor-styles-wrapper {', $editor_body_css );
            foreach( (array)$css[ 'editor' ] as $page => $value ) {
                $editor_css = ':root, .whitemode { ' . $root_color . ' }' . $default_editor_css . $editor_body_css . $dg_css_editor;
                foreach( (array)$value as $part_id => $editor ) {
                    foreach( (array)$editor as $editor_value ) {
                        $editor_css .= $editor_value;
                    }
                }
                $editor_css .= $css[ 'anime' ] . $css[ 'color' ] . $editor_reset_css;
                $editor_css_data = mb_convert_encoding( '@charset "utf-8"; ' . $editor_css, 'utf-8' );
                $wp_filesystem->put_contents( $directory_path_editor_css . 'editor-' . $page . '-style.css', $editor_css_data );
            }
        }
        //ABテストの場合には、manifest情報削除
        if ( $test_type !== false ) {
            if ( isset( $scripts[ 'manifest' ] ) ) {
                unset( $scripts[ 'manifest' ] );
            }
            if ( isset( $scripts[ 'pwa' ] ) ) {
                unset( $scripts[ 'pwa' ] );
            }
            //メインデザインにmanifest情報がある場合には登録　PWAは保存しちゃうので外したまま
            $main_scripts = get_option( 'DG_script_option' );
            if ( $main_scripts !== false ) {
                $main_scripts = json_decode( $main_scripts, true );
                if ( isset( $main_scripts[ 'manifest' ] ) ) {
                    $scripts[ 'manifest' ] = $main_scripts[ 'manifest' ];
                }
            }
        }
        //ABテストページ保存じゃない場合のみ実行
        if ( $lp === false && $test_type === false ) {
            /* ログインページ用CSS保存 */
            if ( isset( $css[ 'login' ] ) ) {
                $css[ 'login' ] .= 'body.login #login h1 a { background-image: url("' . $pc_logo . '"); }';
                update_option( 'DG_login_style', $css[ 'login' ] );
            }
            //PWA
            $manifest_url = ABSPATH . 'manifest.json';
            $pwa_js_url = ABSPATH . 'pwa.js';
            if ( file_exists( $manifest_url ) ) {
                $wp_filesystem->rmdir( $manifest_url, true );
            }
            if ( file_exists( $pwa_js_url ) ) {
                $wp_filesystem->rmdir( $pwa_js_url, true );
            }
            if ( isset( $scripts[ 'manifest' ] ) ) {
                unset( $scripts[ 'manifest' ] );
            }
            if ( isset( $scripts[ 'pwa' ] ) ) {
                unset( $scripts[ 'pwa' ] );
            }
            $site_display = get_option( 'DG_display_flg', '1' );
            $pwa = get_option( 'DG_pwa_value', '' );
            if ( $pwa !== '' && $site_display === '1' ) {
                $pwa_arr = json_decode( $pwa, true );
                if ( isset( $pwa_arr[ 'flg' ] ) && $pwa_arr[ 'flg' ] !== '' ) {
                    //manifest作成
                    $pwa_name = isset( $pwa_arr[ 'name' ] ) && $pwa_arr[ 'name' ] !== '' ? $pwa_arr[ 'name' ] : get_option( 'blogname', '' );
                    $pwa_display = isset( $pwa_arr[ 'display' ] ) && $pwa_arr[ 'display' ] !== '' ? $pwa_arr[ 'display' ] : 'browser';
                    $pwa_json = array(
                        'name' => $pwa_name,
                        'short_name' => $pwa_name,
                        'display' => $pwa_display,
                        'scope' => '/',
                        'start_url' => $home_url,
                    );
                    //色設定
                    if ( isset( $pwa_arr[ 'theme' ] ) && $pwa_arr[ 'theme' ] !== '' ) {
                        $theme_color = replace_color_code( $color_value, $pwa_arr[ 'theme' ] );
                        $pwa_json[ 'theme_color' ] = $theme_color;
                        $scripts[ 'pwa_theme' ] = $theme_color;
                    }
                    if ( isset( $pwa_arr[ 'bg' ] ) && $pwa_arr[ 'bg' ] !== '' ) {
                        $pwa_json[ 'background_color' ] = replace_color_code( $color_value, $pwa_arr[ 'bg' ] );
                    }
                    //faviconイメージ取得
                    $site_icon = get_option( 'site_icon', '' );
                    if ( $site_icon !== '' ) {
                        $favicon = post_image_src_list( $site_icon );
                        if ( $favicon !== false && is_array( $favicon ) && count( $favicon ) > 0 ) {
                            foreach( (array)$favicon as $image_key => $image_val ) {
                                if ( isset( $image_val[ 'url' ] ) && $image_val[ 'url' ] !== '' ) {
                                    $filepath = pathinfo( $image_val[ 'url' ] );
                                    $mani_image = array(
                                        'src' => $image_val[ 'url' ],
                                        'sizes' => $image_val[ 'width' ] . 'x' . $image_val[ 'width' ],
                                        'type' => 'image/' . $filepath[ 'extension' ],
                                    );
                                    if ( (int)$image_val[ 'width' ] === 512 ) {
                                        $mani_image[ 'purpose' ] = 'any maskable';
                                    }
                                    $pwa_json[ 'icons' ][] = $mani_image;
                                }
                            }
                        }
                    }
                    //ファイル作成
                    $wp_filesystem->put_contents( $manifest_url, mb_convert_encoding( stripslashes( json_encode( $pwa_json ) ), 'UTF-8' ) );
                    $scripts[ 'manifest' ] = $site_url . '/manifest.json';
                    //JS作成
                    if ( $pwa_arr[ 'flg' ] === '1' ) {
                        $pwa_js_path = preg_replace( '/http(s)?:\/\/' . $_SERVER[ 'HTTP_HOST' ] . '/s', '', $home_url );
                        $scripts[ 'pwa' ] = $pwa_js_path;
                        $original_pwa = $wp_filesystem->get_contents( $directory_path . '/js/pwa.js' );
                        $original_pwa = preg_replace( '/\/\*.*?\*\//s', '', $original_pwa );
                        $original_pwa = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $original_pwa );
                        $original_pwa = preg_replace( '/\s(?=\s)/', '', $original_pwa );
                        $wp_filesystem->put_contents( $pwa_js_url, mb_convert_encoding( $original_pwa, 'UTF-8' ) );
                        
                        foreach( (array)$all_pages as $page ) {
                            $js_part_flg[ $page ][ '23-DGJS' ] = true;
                        }
                    }
                }
            }
        }
        $license_check = true;
        if ( $lp === false ) {
            //jsデータ作成
            $directory_uri_js = $upload_dir[ 'baseurl' ] . '/design-json/js/';
            if ( $test_type !== false ) {
                $directory_uri_js .= $test_type . '/';
            }
            $temp_js = $wp_filesystem->get_contents( $directory_path . '/js/temp.js' );
            preg_match( '/\/\*HT-DGJS\*\/(.+)\/\*HT-DGJS\*\//', $temp_js, $js_header_t );
            preg_match( '/\/\*HB-DGJS\*\/(.+)\/\*HB-DGJS\*\//', $temp_js, $js_header_b );
            preg_match( '/\/\*END-DGJS\*\/(.+)\/\*END-DGJS\*\//', $temp_js, $js_footer );
            preg_match( '/\/\*GLOBAL-DGJS\*\/(.+)\/\*GLOBAL-DGJS\*\//', $temp_js, $js_global );
            $js_header_t = isset( $js_header_t[ 1 ] ) ? $js_header_t[ 1 ] : '';
            $js_header_b = isset( $js_header_b[ 1 ] ) ? $js_header_b[ 1 ] : '';
            $js_footer = isset( $js_footer[ 1 ] ) ? $js_footer[ 1 ] : '';
            $js_global = isset( $js_global[ 1 ] ) ? $js_global[ 1 ] : '';
            foreach( (array)$all_pages as $page ) {
                $js_path = $directory_path_js . $page . '_script.js';
                
                //記事リスト
                $post_list_js = '';
                if ( isset( $js_part_flg[ $page ][ 'POSTLIST-DGJS' ] ) ) {
                    preg_match( '/\/\*POSTLIST-DGJS\*\/(.+)\/\*POSTLIST-DGJS\*\//', $temp_js, $match );
                    $post_list_js = isset( $match[ 1 ] ) ? $match[ 1 ] : '';
                }
                
                //JSパーツ
                $js_header_names = array();
                $js_main = '';
                for( $i = 2; $i <= 26; $i++ ) {
                    if ( isset( $js_part_flg[ $page ][ $i . '-DGJS' ] ) ) {
                        preg_match( '/\/\*' . $i . '-DGJS\*\/(.+)\/\*' . $i . '-DGJS\*\//', $temp_js, $js_part );
                        $js_main .= isset( $js_part[ 1 ] ) ? $js_part[ 1 ] : '';

                        if ( $i === 2 ) {//front_part_top
                            $js_header_names[ 'H2' ] = true;
                            $js_header_names[ 'H3' ] = true;
                            
                            //記事リスト差し込み
                            if ( isset( $js_part_flg[ $page ][ 'POSTLIST-DGJS' ] ) ) {
                                $js_main .= $post_list_js;
                            }
                        } elseif ( $i === 3 ) {//bookmark
                            $js_header_names[ 'H1' ] = true;
                            $js_header_names[ 'H2' ] = true;
                            $js_header_names[ 'H4' ] = true;
                            $js_header_names[ 'H6' ] = true;
                        } elseif ( $i === 10 ) {//movie
                            $js_header_names[ 'H2' ] = true;
                        } elseif ( $i === 12 ) {//ab-toggle
                            $js_header_names[ 'H1' ] = true;
                        } elseif ( $i === 18 ) {//archive-sort
                            $js_header_names[ 'H1' ] = true;
                        } elseif ( $i === 19 ) {//archive
                            $js_header_names[ 'H1' ] = true;
                            $js_header_names[ 'H2' ] = true;
                            $js_header_names[ 'H4' ] = true;
                            $js_header_names[ 'H5' ] = true;
                            $js_header_names[ 'H6' ] = true;
                        } elseif ( $i === 21 ) {//post-comment
                            $js_header_names[ 'H2' ] = true;
                            $js_header_names[ 'H4' ] = true;
                            $js_header_names[ 'H5' ] = true;
                            $js_header_names[ 'H8' ] = true;
                        } elseif ( $i === 22 ) {//post-evaluate
                            $js_header_names[ 'H2' ] = true;
                            $js_header_names[ 'H3' ] = true;
                            $js_header_names[ 'H4' ] = true;
                            $js_header_names[ 'H7' ] = true;
                        } elseif ( $i === 23 ) {//pwa
                            $js_header_names[ 'H7' ] = true;
                        } elseif ( $i === 25 ) {//realtime search
                            $js_header_names[ 'H2' ] = true;
                            $js_header_names[ 'H3' ] = true;
                            $js_header_names[ 'H4' ] = true;
                            $js_header_names[ 'H5' ] = true;
                        } elseif ( $i === 26 ) {//realtime post
                            $js_header_names[ 'H2' ] = true;
                            $js_header_names[ 'H3' ] = true;
                            $js_header_names[ 'H4' ] = true;
                        }
                    }
                }
                if ( isset( $js_part_flg[ $page ][ '99-DGJS' ] ) ) {
                    preg_match( '/\/\*99-DGJS\*\/(.+)\/\*99-DGJS\*\//', $temp_js, $js_part );
                    if ( isset( $js_part[ 1 ] ) && $js_part[ 1 ] !== '' ) {
                        $js_main .= $js_part[ 1 ];
                        $js_header_names[ 'H2' ] = true;
                        $js_header_names[ 'H3' ] = true;
                        $js_header_names[ 'H4' ] = true;
                    } else {
                        $license_check = false;
                    }
                }
                //位置確定JS
                $js_slider = '';
                if ( isset( $js_part_flg[ $page ][ 'SLIDER-DGJS' ] ) ) {
                    preg_match( '/\/\*SLIDER-DGJS\*\/(.+)\/\*SLIDER-DGJS\*\//', $temp_js, $match );
                    $js_slider = isset( $match[ 1 ] ) ? $match[ 1 ] : '';
                }
                $js_contact = '';
                if ( isset( $js_part_flg[ $page ][ 'CONTACT-DGJS' ] ) ) {
                    preg_match( '/\/\*CONTACT-DGJS\*\/(.+)\/\*CONTACT-DGJS\*\//', $temp_js, $match );
                    $js_contact = isset( $match[ 1 ] ) ? $match[ 1 ] : '';
                    $js_header_names[ 'H1' ] = true;
                    $js_header_names[ 'H2' ] = true;
                    $js_header_names[ 'H4' ] = true;
                }
                //ヘッダーJSパーツ
                $js_header_part = '';
                for( $i = 1; $i <= 9; $i++ ) {
                    if ( isset( $js_header_names[ 'H' . $i ] ) ) {
                        preg_match( '/\/\*H' . $i . '-DGJS\*\/(.+)\/\*H' . $i . '-DGJS\*\//', $temp_js, $match );
                        $js_header_part .= isset( $match[ 1 ] ) ? $match[ 1 ] : '';
                    }
                }
                //ACCO
                if ( isset( $js_part_flg[ $page ][ 'ACCO-DGJS' ] ) ) {
                    preg_match( '/\/\*ACCO-DGJS\*\/(.+)\/\*ACCO-DGJS\*\//', $temp_js, $match );
                    $js_header_part .= isset( $match[ 1 ] ) ? $match[ 1 ] : '';
                }
                //TAB
                if ( isset( $js_part_flg[ $page ][ 'TAB-DGJS' ] ) ) {
                    preg_match( '/\/\*TAB-DGJS\*\/(.+)\/\*TAB-DGJS\*\//', $temp_js, $match );
                    $js_header_part .= isset( $match[ 1 ] ) ? $match[ 1 ] : '';
                }
                //LIGHT
                if ( isset( $js_part_flg[ $page ][ 'LIGHT-DGJS' ] ) ) {
                    preg_match( '/\/\*LIGHT-DGJS\*\/(.+)\/\*LIGHT-DGJS\*\//', $temp_js, $match );
                    $js_header_part .= isset( $match[ 1 ] ) ? $match[ 1 ] : '';
                }
                $complie = '(function(){ \'use strict\'; ' . $js_header_t . $js_header_part . $js_header_b . $js_slider . $js_global . $js_main . $js_contact . $js_footer . '}());';
                $js_data = mb_convert_encoding( $complie, 'UTF-8' );
                $wp_filesystem->put_contents( $js_path, $js_data );
                $js_uri = $directory_uri_js . $page . '_script.js?update=' . $site_update_time;
                $scripts[ 'js_path' ][ $page ] = $js_uri;
            }
        } else {
            $scripts[ 'js_path' ][ 'top' ] = $stylesheet_url . '/js/php_summary-post.js';
        }
        if ( !$license_check ) {
            foreach( (array)$all_pages as $page ) {
                update_option( 'DG_site_value_' . $test_value_name . $page, '' );
            }
            return false;
        }
        //スクリプト保存
        $scripts[ 'preload' ] = $preload;
        if ( $lp === false ) {
            $scripts = json_encode( $scripts );
            if ( $test_type !== false ) {
                update_option( 'DG_script_option' . $test_type, $scripts );
            } else {
                update_option( 'DG_script_option', $scripts );
            }
        } else {
            $scripts = wp_slash( json_encode( $scripts ) );
            update_post_meta( $lp[ 'ID' ], 'DG_script_option', $scripts );
        }
    }
    return true;
}

/*
 * パーツ並び替え
*/
function item_array_sort( $arr ) {
    $items = array();
    foreach( (array)$arr as $key => $value ) {
        if ( isset( $value[ 'order' ] ) ) {
            $items[ $key ] = $value;
        }
    }
    $sort = array();
    foreach( (array)$items as $key => $value ) {
        $sort[ $key ] = isset( $value['order'] ) ? $value['order'] : null;
    }
    array_multisort( $sort, SORT_ASC, $items );
    return $items;
}
/*
 * 色の置換
*/
function replace_color_code( $color, $value ) {
    if ( $color === false ){
        return $value;
    }
    $new_value = $value;
    if ( isset( $color[ 'select' ] ) && isset( $color[ 'palette' ][ $color[ 'select' ] ] ) ) {
        $palette = $color[ 'palette' ][ $color[ 'select' ] ];
        foreach( (array)$palette as $key => $code ) {
            $new_value = str_replace( '$' . $key . '$', $code, $new_value );
        }
    }
    if ( isset( $color[ 'colorset' ] ) && is_array( $color[ 'colorset' ] ) && count( $color[ 'colorset' ] ) > 0 ) {
        foreach( (array)$color[ 'colorset' ] as $key => $code ) {
            $new_value = str_replace( '$' . $code[ 'name' ] . '$', $code[ 'color' ], $new_value );
        }
    }
    
    return $new_value;
}
/*
 * アニメーション置換
*/
function replace_animation_code( $anime, $value ) {
    if ( $anime === false || ( is_array( $anime ) && count( $anime ) < 1 ) ){
        return $value;
    }
    $new_value = $value;
    foreach( (array)$anime as $key => $code ) {
        $new_value = str_replace( '$' . $code[ 'label' ] . '$', $key, $new_value );
    }
    return $new_value;
}

function create_css_simulator( $page_value, $design_value, $device, $color_value, $marker_colors ) {
    global $wp_filesystem;
    $css = array();
    if ( !is_user_logged_in() || ( !current_user_can( 'administrator' ) && !current_user_can( 'editor' ) ) ) {
        return $css;
    }
    $creds_url = wp_nonce_url( 'admin.php?page=site_builder' );
    if ( false === ( $creds = request_filesystem_credentials( $creds_url, '', false, false, null ) ) ) {
        return $css;
    }
    $upload_dir = wp_upload_dir();
    $directory_path = $upload_dir[ 'basedir' ];
    $editor = array();
    //通常用
    $area = array();
    $parts = array();
    $template_value = array();
    $template = array();
    $template_child_slug = array();
    $template_child = array();
    $template_editor = array();
    $template_slug = array();
    //クリティカル
    $cri_area = array();
    $cri_parts = array();
    $cri_template_value = array();
    $cri_template = array();
    $cri_template_child_slug = array();
    $cri_template_child = array();
    $critical_flg = array();
    foreach( (array)$page_value as $page => $main ) {
        //CSS初期値
        foreach( (array)$device as $type ) {
            $css[ $page ][ 'normal' ][ $type ] = '';
            $css[ $page ][ 'critical' ][ $type ] = '';
            if ( strpos( $page, 'single-' ) !== false ) {
                $css[ 'editor' ][ $page ][ $type ] = '';
            }
        }
        foreach( (array)$main as $part_id => $val ) {
            if ( $part_id !== 'page' ) {
                $part = $design_value[ $part_id ];
                if ( isset( $part[ 'critical' ] ) && $part[ 'critical' ] === '1' ) {
                    //エリア＆パーツデザイン
                    if ( isset( $part[ 'design' ] ) ) {
                        if ( isset( $part[ 'type' ] ) && $part[ 'type' ] === 'area' ) {
                            $cri_area[ $page ][ $part_id ][ 'design' ] = $part[ 'design' ];
                        } else {
                            $cri_parts[ $page ][ $part_id ][ 'design' ] = $part[ 'design' ];
                            //エディター用
                            if ( isset( $part[ 'slug' ] ) && $part[ 'slug' ] === 'single-content' ) {
                                $editor[ $page ][ $part_id ][ 'design' ] = $part[ 'design' ];
                            }
                        }
                        $critical_flg[ $page ] = true;
                    }
                    if ( isset( $part[ 'simple' ] ) ) {
                        if ( isset( $part[ 'type' ] ) && $part[ 'type' ] === 'area' ) {
                            $cri_area[ $page ][ $part_id ][ 'simple' ] = $part[ 'simple' ];
                        } else {
                            $cri_parts[ $page ][ $part_id ][ 'simple' ] = $part[ 'simple' ];
                            //エディター用
                            if ( isset( $part[ 'slug' ] ) && $part[ 'slug' ] === 'single-content' ) {
                                $editor[ $page ][ $part_id ][ 'simple' ] = $part[ 'simple' ];
                            }
                        }
                    }
                    //テンプレート
                    if ( isset( $part[ 'template' ] ) ) {
                        $slug = $part[ 'slug' ];
                        if ( isset( $part[ 'type' ] ) && $part[ 'type' ] === 'area' ) {
                            $slug = 'area';
                        }
                        if ( $slug === 'taxonomy-post_list' || $slug === 'single-recommend' ) {
                            $slug = 'post_list';
                        }
                        $template_slug[ $slug ] = $slug;
                        $cri_template_value[ $page ][ $slug ] = $slug;
                        $cri_template[ $page ][ $slug ][ $part[ 'template' ] ][] = $part_id;
                        if ( $slug === 'single-content' ) {
                            $template_editor[ $slug ][ $part[ 'template' ] ][] = $part_id;
                        }
                        $critical_flg[ $page ] = true;
                    }
                    //エリアテンプレート
                    if ( isset( $part[ 'areaTemplate' ] ) && $part[ 'areaTemplate' ] !== '' && isset( $part[ 'templateId' ] ) && $part[ 'templateId' ] !== '' ) {
                        $cri_template_value[ $page ][ 'area' ] = 'area';
                        $cri_template_child[ $page ][ $part[ 'areaTemplate' ] ][] = array(
                            'slug' => $part[ 'templateSlug' ],
                            'child_id' => $part[ 'templateId' ],
                            'part_id' => $part_id,
                        );
                        $cri_template_child_slug[ $page ][ $part[ 'areaTemplate' ] ][ $part[ 'templateSlug' ] ][] = array(
                            'child_id' => $part[ 'templateId' ],
                            'part_id' => $part_id,
                        );
                        $critical_flg[ $page ] = true;
                    }
                } else {
                    //エリア＆パーツデザイン
                    if ( isset( $part[ 'design' ] ) ) {
                        if ( isset( $part[ 'type' ] ) && $part[ 'type' ] === 'area' ) {
                            $area[ $page ][ $part_id ][ 'design' ] = $part[ 'design' ];
                        } else {
                            $parts[ $page ][ $part_id ][ 'design' ] = $part[ 'design' ];
                            //エディター用
                            if ( isset( $part[ 'slug' ] ) && $part[ 'slug' ] === 'single-content' ) {
                                $editor[ $page ][ $part_id ][ 'design' ] = $part[ 'design' ];
                            }
                        }
                    }
                    if ( isset( $part[ 'simple' ] ) ) {
                        if ( isset( $part[ 'type' ] ) && $part[ 'type' ] === 'area' ) {
                            $area[ $page ][ $part_id ][ 'simple' ] = $part[ 'simple' ];
                        } else {
                            $parts[ $page ][ $part_id ][ 'simple' ] = $part[ 'simple' ];
                            //エディター用
                            if ( isset( $part[ 'slug' ] ) && $part[ 'slug' ] === 'single-content' ) {
                                $editor[ $page ][ $part_id ][ 'simple' ] = $part[ 'simple' ];
                            }
                        }
                    }
                    //テンプレート
                    if ( isset( $part[ 'template' ] ) ) {
                        $slug = $part[ 'slug' ];
                        if ( isset( $part[ 'type' ] ) && $part[ 'type' ] === 'area' ) {
                            $slug = 'area';
                        }
                        if ( $slug === 'taxonomy-post_list' || $slug === 'single-recommend' ) {
                            $slug = 'post_list';
                        }
                        $template_slug[ $slug ] = $slug;
                        $template_value[ $page ][ $slug ] = $slug;
                        $template[ $page ][ $slug ][ $part[ 'template' ] ][] = $part_id;
                        if ( $slug === 'single-content' ) {
                            $template_editor[ $slug ][ $part[ 'template' ] ][] = $part_id;
                        }
                    }
                    //エリアテンプレート
                    if ( isset( $part[ 'areaTemplate' ] ) && $part[ 'areaTemplate' ] !== '' && isset( $part[ 'templateId' ] ) && $part[ 'templateId' ] !== '' ) {
                        $template_value[ $page ][ 'area' ] = 'area';
                        $template_child[ $page ][ $part[ 'areaTemplate' ] ][] = array(
                            'slug' => $part[ 'templateSlug' ],
                            'child_id' => $part[ 'templateId' ],
                            'part_id' => $part_id,
                        );
                        $template_child_slug[ $page ][ $part[ 'areaTemplate' ] ][ $part[ 'templateSlug' ] ][] = array(
                            'child_id' => $part[ 'templateId' ],
                            'part_id' => $part_id,
                        );
                    }
                }
            }
        }
    }
    
    //＃page差し込む
    foreach( (array)$page_value as $page => $main ) {
        if ( isset( $design_value[ 'page' ][ 'design' ] ) ) {
            $editor[ $page ][ 'page' ][ 'design' ] = $design_value[ 'page' ][ 'design' ];
            if ( isset( $critical_flg[ $page ] ) && $critical_flg[ $page ] === true ) {
                $cri_area[ $page ][ 'page' ][ 'design' ] = $design_value[ 'page' ][ 'design' ];
            } else {
                $area[ $page ][ 'page' ][ 'design' ] = $design_value[ 'page' ][ 'design' ];
            }
        }
    }
    //カラー
    $color_css = '';
    if ( $color_value !== false ) {
        $editor_color_palette = array();
        if ( isset( $color_value[ 'select' ] ) && isset( $color_value[ 'palette' ][ $color_value[ 'select' ] ] ) ) {
            $palette = $color_value[ 'palette' ][ $color_value[ 'select' ] ];
            foreach( (array)$palette as $key => $code ) {
                if ( $key !== 'label' ) {
                    $color_css .= '.has-post-' . preg_replace( '/([0-9])/', '-$1', $key ) . '-color {color:' . $code . ' !important;}';
                    $color_css .= '.has-post-' . preg_replace( '/([0-9])/', '-$1', $key ) . '-background-color {background:' . $code . ' !important;}';
                    $color_css .= '.has-post-' . preg_replace( '/([0-9])/', '-$1', $key ) . '-border-color {border-color:' . $code . ' !important;}';
                }
            }
        }
        if ( isset( $color_value[ 'colorset' ] ) && is_array( $color_value[ 'colorset' ] ) && count( $color_value[ 'colorset' ] ) > 0 ) {
            foreach( (array)$color_value[ 'colorset' ] as $key => $code ) {
                $color_css .= '.has-post-' . $key . '-color {color:' . $code[ 'color' ] . ' !important;}';
                $color_css .= '.has-post-' . $key . '-background-color {background:' . $code[ 'color' ] . ' !important;}';
                $color_css .= '.has-post-' . $key . '-border-color {border-color:' . $code[ 'color' ] . ' !important;}';
            }
        }
    }
    $css[ 'color' ] = $color_css;
    
    //アニメーション
    $design_path = $directory_path . '/design-json/template/animation.json';
    $anime_css = '';
    $anime_list = array();
    if ( isset( $design_value[ 'ORIGINALANIMATION' ] ) ) {
        $anime_list = $design_value[ 'ORIGINALANIMATION' ];
        unset( $site_value[ 'ORIGINALANIMATION' ] );
    } elseif ( is_file( $design_path ) ) {
        $part_file = $wp_filesystem->get_contents( $design_path );
        $anime_list = json_decode( $part_file, true );
    }
    if ( is_array( $anime_list ) && count( $anime_list ) > 0 ) {
        foreach( (array)$anime_list as $ani_id => $anime_value ) {
            if ( isset( $anime_value[ 'select' ] ) && isset( $anime_value[ 'design' ] ) ) {
                $anime_css .= '@keyframes ' . $ani_id . '{';
                $css_value = item_array_sort( $anime_value[ 'design' ] );
                foreach( (array)$css_value as $part ) {
                    $selector = $part[ 'selector' ];
                    $design = replace_color_code( $color_value, $part[ 'design' ] );
                    $anime_css .= $selector . '{' . $design . '}';
                }
                $anime_css .= '}';
            }
        }
    }
    $css[ 'anime' ] = $anime_css;
    
    //テンプレートパーツ
     $template_list = array();
    if ( is_array( $template_slug ) && count( $template_slug ) > 0 ) {
        foreach( (array) $template_slug as $slug ) {
            $design_path = $directory_path . '/design-json/template/' . $slug . '.json';
            if ( is_file( $design_path ) ) {
                $part_file = $wp_filesystem->get_contents( $design_path );
                $template_list[ $slug ] = json_decode( $part_file, true );
            }
        }
    }
    //normalCSS
    $tem_arr = array(
        'color_value' => $color_value,
        'template_list' => $template_list,
        'template_value' => $template_value,
        'template_child' => $template_child,
        'template' => $template,
        'template_child_slug' => $template_child_slug,
        'template_editor' => $template_editor,
    );
    $css = create_template_css_data( $css, 'normal', $tem_arr );
    
    //クリティカルCSS
    $tem_arr = array(
        'color_value' => $color_value,
        'template_list' => $template_list,
        'template_value' => $cri_template_value,
        'template_child' => $cri_template_child,
        'template' => $cri_template,
        'template_child_slug' => $cri_template_child_slug,
        'template_editor' => array(),
    );
    $css = create_template_css_data( $css, 'critical', $tem_arr );

    //エリアCSS
    $area_data = array(
        'color_value' => $color_value,
        'anime_list' => $anime_list,
        'parts' => $area,
    );
    $css = create_area_part_css_data( $css, 'normal', $area_data );
    
    //エリアクリティカルCSS
    $cri_area_data = array(
        'color_value' => $color_value,
        'anime_list' => $anime_list,
        'parts' => $cri_area,
    );
    $css = create_area_part_css_data( $css, 'critical', $cri_area_data );
    
    //パーツCSS
    $part_data = array(
        'color_value' => $color_value,
        'anime_list' => $anime_list,
        'parts' => $parts,
    );
    $css = create_area_part_css_data( $css, 'normal', $part_data );
    
    //パーツクリティカルCSS
    $cri_part_data = array(
        'color_value' => $color_value,
        'anime_list' => $anime_list,
        'parts' => $cri_parts,
    );
    $css = create_area_part_css_data( $css, 'critical', $cri_part_data );
    
    //テンプレートアニメーション作成
    if ( isset( $css[ 'TEMP_ANIME' ] ) && is_array( $css[ 'TEMP_ANIME' ] ) && count( $css[ 'TEMP_ANIME' ] ) > 0 ) {
        foreach( (array)$css[ 'TEMP_ANIME' ] as $anime_value ) {
            $css[ 'anime' ] .= $anime_value;
        }
        unset( $css[ 'TEMP_ANIME' ] );
    }
    //独自CSS反映
    if ( isset( $design_value[ 'ORIGINALCSS' ] ) ) {
        foreach( (array)$page_value as $page => $main ) {
            //CSS初期値
            foreach( (array)$device as $type ) {
                if ( isset( $design_value[ 'ORIGINALCSS' ][ 'all' ][ $type ] ) && $design_value[ 'ORIGINALCSS' ][ 'all' ][ $type ] !== '' ) {
                    $design_property = replace_color_code( $color_value, $design_value[ 'ORIGINALCSS' ][ 'all' ][ $type ] );
                    $design_property = replace_animation_code( $anime_list, $design_property );
                    $design_property = preg_replace( '/\/\*.*?\*\//s', '', $design_property );
                    $design_property = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $design_property );
                    $design_property = preg_replace( '/\s\s/', '', $design_property );
                    if ( isset( $design_value[ 'ORIGINALCSS' ][ 'all' ][ 'critical' ] ) && $design_value[ 'ORIGINALCSS' ][ 'all' ][ 'critical' ] === '1' ) {
                        $css[ $page ][ 'critical' ][ $type ] .= $design_property;
                    } else {
                        $css[ $page ][ 'normal' ][ $type ] .= $design_property;
                    }
                }
                if ( strpos( $page, 'taxonomy-' ) !== false || strpos( $page, 'single-' ) !== false ) {
                    $page_common = 'taxonomy';
                    if ( strpos( $page, 'single-' ) !== false ) {
                        $page_common = 'single';
                    }
                    if ( isset( $design_value[ 'ORIGINALCSS' ][ $page_common ][ $type ] ) && $design_value[ 'ORIGINALCSS' ][ $page_common ][ $type ] !== '' ) {
                        $design_property = replace_color_code( $color_value, $design_value[ 'ORIGINALCSS' ][ $page_common ][ $type ] );
                        $design_property = replace_animation_code( $anime_list, $design_property );
                        $design_property = preg_replace( '/\/\*.*?\*\//s', '', $design_property );
                        $design_property = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $design_property );
                        $design_property = preg_replace( '/\s\s/', '', $design_property );
                        if ( isset( $design_value[ 'ORIGINALCSS' ][ $page_common ][ 'critical' ] ) && $design_value[ 'ORIGINALCSS' ][ $page_common ][ 'critical' ] === '1' ) {
                            $css[ $page ][ 'critical' ][ $type ] .= $design_property;
                        } else {
                            $css[ $page ][ 'normal' ][ $type ] .= $design_property;
                        }
                    }
                }
                if ( isset( $design_value[ 'ORIGINALCSS' ][ $page ][ $type ] ) && $design_value[ 'ORIGINALCSS' ][ $page ][ $type ] !== '' ) {
                    $design_property = replace_color_code( $color_value, $design_value[ 'ORIGINALCSS' ][ $page ][ $type ] );
                    $design_property = replace_animation_code( $anime_list, $design_property );
                    $design_property = preg_replace( '/\/\*.*?\*\//s', '', $design_property );
                    $design_property = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $design_property );
                    $design_property = preg_replace( '/\s\s/', '', $design_property );
                    if ( isset( $design_value[ 'ORIGINALCSS' ][ $page ][ 'critical' ] ) && $design_value[ 'ORIGINALCSS' ][ $page ][ 'critical' ] === '1' ) {
                        $css[ $page ][ 'critical' ][ $type ] .= $design_property;
                    } else {
                        $css[ $page ][ 'normal' ][ $type ] .= $design_property;
                    }
                }
            }
        }
    }
    
    if ( is_array( $editor ) && count( $editor ) > 0 ) {
        foreach( (array)$editor as $page => $parts ) {
            if ( strpos( $page, 'single-' ) !== false ) {
                foreach( (array)$parts as $part_id => $value ) {
                    foreach( (array)$value[ 'design' ] as $device => $list ) {
                        $css_value = item_array_sort( $list );
                        foreach( (array)$css_value as $part ) {
                            if ( isset( $part[ 'selector' ] ) && $part[ 'selector' ] !== '' && isset( $part[ 'design' ] ) && $part[ 'design' ] !== '' ) {
                                $selector = '';
                                $selector_arr = explode( ',', $part[ 'selector' ] );
                                foreach( (array) $selector_arr as $item ) {
                                    $replace_selector = '#editor .edit-post-visual-editor .editor-styles-wrapper ';
                                    if ( $part_id === 'page' ) {
                                        $replace_selector = '#editor ';
                                    }
                                    if ( $item !== '#' . $part_id ) {
                                        if ( $selector !== '' ) {
                                            $selector .= ',';
                                        }
                                        if ( strpos( $item, '#' . $part_id ) === false ) {
                                            if ( strpos( $item, '!' ) !== false ) {
                                                $cut = explode( '!', $item );
                                                $selector .= $replace_selector . $cut[ 1 ];
                                            } else {
                                                $selector .= $replace_selector . $item;
                                            }
                                        } elseif ( strpos( $item, '!' ) !== false ) {
                                            $cut = explode( '!', $item );
                                            $selector .= $replace_selector . $cut[ 1 ];
                                        } else {
                                            $selector .= str_replace( '#' . $part_id, $replace_selector, $item );
                                        }
                                    } else {
                                        $selector .= str_replace( '#' . $part_id, $replace_selector, $item );
                                    }
                                }
                                $design_property = replace_color_code( $color_value, $part[ 'design' ] );
                                $design_property = replace_animation_code( $anime_list, $design_property );
                                if ( $design_property !== '' ) {
                                    $design_property = str_replace( 'important', '', $design_property );
                                    $design_property = str_replace( ';', ' !important;', $design_property );
                                    $css[ 'editor' ][ $page ][ $device ] .= $selector . '{' . $design_property . '}';
                                }
                            }
                        }
                    }
                    if ( isset( $value[ 'simple' ] ) ) {
                        foreach( (array)$value[ 'simple' ] as $device => $list ) {
                            foreach( (array)$list as $part ) {
                                if ( isset( $part[ 'selector' ] ) && $part[ 'selector' ] !== '' && isset( $part[ 'design' ] ) && $part[ 'design' ] !== '' ) {
                                    $selector = '';
                                    $selector_arr = explode( ',', $part[ 'selector' ] );
                                    foreach( (array) $selector_arr as $item ) {
                                        $replace_selector = '#editor .edit-post-visual-editor .editor-styles-wrapper ';
                                        if ( $part_id === 'page' ) {
                                            $replace_selector = '#editor ';
                                        }
                                        if ( $item !== '#' . $part_id ) {
                                            if ( $selector !== '' ) {
                                                $selector .= ',';
                                            }
                                            if ( strpos( $item, '#' . $part_id ) === false ) {
                                                if ( strpos( $item, '!' ) !== false ) {
                                                    $cut = explode( '!', $item );
                                                    $selector .= $replace_selector . $cut[ 1 ];
                                                } else {
                                                    $selector .= $replace_selector . $item;
                                                }
                                            } elseif ( strpos( $item, '!' ) !== false ) {
                                                $cut = explode( '!', $item );
                                                $selector .= $replace_selector . $cut[ 1 ];
                                            } else {
                                                $selector .= str_replace( '#' . $part_id, $replace_selector, $item );
                                            }
                                        } else {
                                            $selector .= str_replace( '#' . $part_id, $replace_selector, $item );
                                        }
                                    }
                                    $design_property = replace_color_code( $color_value, $part[ 'design' ] );
                                    $design_property = replace_animation_code( $anime_list, $design_property );
                                    if ( $design_property !== '' ) {
                                        $design_property = str_replace( 'important', '', $design_property );
                                        $design_property = str_replace( ';', ' !important;', $design_property );
                                        $css[ 'editor' ][ $page ][ $device ] .= $selector . '{' . $design_property . '}';
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    //ログインページ用CSS作成
    $login_css = <<< EOM
        body.login {
            background: \$base$ ;
        }
        body.login #login form {
            background: \$white$;
        }
        body.login #login label {
            color: \$main$ ;
        }
        .wp-core-ui #login .button,
        .wp-core-ui #login .button-secondary {
            color:\$main$;;
        }
        .wp-core-ui #login .button:hover,
        .wp-core-ui #login .button-secondary:hover {
            color:\$sub1$;
        }
        .wp-core-ui #login .button.button-primary {
            color: \$white$;
            background: \$main$;
            border-color: \$main$;
        }
        .wp-core-ui #login .button.button-primary:hover,
        .wp-core-ui #login .button.button-primary:focus {
            color: \$white$;
            background: \$sub1$;
            border-color: \$sub1$;
        }
EOM;
    $login_css = replace_color_code( $color_value, $login_css );
    $login_css = preg_replace( '/\/\*.*?\*\//s', '', $login_css );
    $login_css = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $login_css );
    $css[ 'login' ] = preg_replace( '/\s(?=\s)/', '', $login_css );
    
    $body_css = '';
    $dark_mode_css = '';
    $root_color = '';
    //root用CSSカラー設定
    if ( isset( $color_value[ 'select' ] ) && isset( $color_value[ 'palette' ][ $color_value[ 'select' ] ] ) ) {
        $palette = $color_value[ 'palette' ][ $color_value[ 'select' ] ];
        foreach( (array)$palette as $key => $code ) {
            if ( $key !== 'label' ) {
                $root_color .= '--' . $key . '-color:' . $code . ';';
            }
        }
    }
    //マーカー色保存
    foreach( (array)$marker_colors as $mk => $mk_code ) {
        $root_color .= '--mk-' . $mk . ': ' . $mk_code . ';';
    }
    if ( isset( $design_value[ 'page' ][ 'dark' ] ) && $design_value[ 'page' ][ 'dark' ] !== '' ) {
        if ( isset( $design_value[ 'page' ][ 'dark' ][ 'root' ] ) && $design_value[ 'page' ][ 'dark' ][ 'root' ] !== '' ) {
            $root_color .= $design_value[ 'page' ][ 'dark' ][ 'root' ];
        }
        if ( isset( $design_value[ 'page' ][ 'dark' ][ 'dark' ] ) && $design_value[ 'page' ][ 'dark' ][ 'dark' ] !== '' ) {
            $dark_mode_css .= '@media (prefers-color-scheme: dark) { :root { ' . $design_value[ 'page' ][ 'dark' ][ 'dark' ] . ' } } .darkmode { ' . $design_value[ 'page' ][ 'dark' ][ 'dark' ] . ' }';
        }
        if ( isset( $design_value[ 'page' ][ 'dark' ][ 'body' ] ) && $design_value[ 'page' ][ 'dark' ][ 'body' ] !== '' ) {
            $body_css .= 'body { ' . $design_value[ 'page' ][ 'dark' ][ 'body' ] . ' }';
        }
    }
    $dark_mode_css = ':root, .whitemode { ' . $root_color . ' }' . $dark_mode_css;
    //ダークモード
    if ( $dark_mode_css !== '' ) {
        $dark_mode_css = replace_color_code( $color_value, $dark_mode_css );
        $dark_mode_css = preg_replace( '/\/\*.*?\*\//s', '', $dark_mode_css );
        $dark_mode_css = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $dark_mode_css );
        $css[ 'dark' ] = preg_replace( '/\s(?=\s)/', '', $dark_mode_css );
    }
    if ( $body_css !== '' ) {
        $body_css = replace_color_code( $color_value, $body_css );
        $body_css = preg_replace( '/\/\*.*?\*\//s', '', $body_css );
        $body_css = preg_replace( '/(\t|\r\n|\r|\n)/s', '', $body_css );
        $css[ 'body' ] = preg_replace( '/\s(?=\s)/', '', $body_css );
    }
    return $css;
}

//テンプレートCSS作成
function create_template_css_data( $css, $type, $tem_arr ) {
    $color_value = $tem_arr[ 'color_value' ];
    $template_list = $tem_arr[ 'template_list' ];
    $template_value = $tem_arr[ 'template_value' ];
    $template_child = $tem_arr[ 'template_child' ];
    $template = $tem_arr[ 'template' ];
    $template_child_slug = $tem_arr[ 'template_child_slug' ];
    $template_editor = $tem_arr[ 'template_editor' ];
    $design_types = array( 'design', 'simple' );
    //テンプレートパーツ
    if ( is_array( $template_value ) && count( $template_value ) > 0 ) {
        foreach( (array)$template_value as $page => $slug_arr ) {
            foreach( (array)$slug_arr as $slug ) {
                if ( isset( $template_list[ $slug ] ) && is_array( $template_list[ $slug ] ) && count( $template_list[ $slug ] ) > 0 ) {
                    foreach( (array)$template_list[ $slug ] as $tmp_id => $tem_value ) {
                        //アニメーション作成
                        if ( isset( $tem_value[ 'animation' ] ) ) {
                            if ( is_array( $tem_value[ 'animation' ] ) && count( $tem_value[ 'animation' ] ) > 0 ) {
                                foreach( (array)$tem_value[ 'animation' ] as $ani_id => $anime_value ) {
                                    if ( isset( $anime_value[ 'design' ] ) ) {
                                        $anime_css = '@keyframes ' . $ani_id . '{';
                                        $css_value = item_array_sort( $anime_value[ 'design' ] );
                                        foreach( (array)$css_value as $part ) {
                                            $selector = $part[ 'selector' ];
                                            $design = replace_color_code( $color_value, $part[ 'design' ] );
                                            $anime_css .= $selector . '{' . $design . '}';
                                        }
                                        $anime_css .= '}';
                                    }
                                    $css[ 'TEMP_ANIME' ][ $ani_id ] = $anime_css;
                                }
                            }
                        }
                        /* エリア子パーツ用 */
                        if ( $slug === 'area' && isset( $template_child[ $page ][ $tmp_id ] ) ) {
                            $part_ids = $template_child[ $page ][ $tmp_id ];
                            foreach( (array)$part_ids as $id_value ) {
                                foreach( (array) $design_types as $design_type ) {
                                    if ( isset( $tem_value[ 'child' ][ $id_value[ 'child_id' ] ][ $design_type ] ) ) {
                                        $design = $tem_value[ 'child' ][ $id_value[ 'child_id' ] ][ $design_type ];
                                        foreach( (array)$design as $device => $list ) {
                                            if ( $design_type === 'simple' ) {
                                                $css_value = $list;
                                            } else {
                                                $css_value = item_array_sort( $list );
                                            }
                                            foreach( (array)$css_value as $part ) {
                                                if ( isset( $part[ 'selector' ] ) && $part[ 'selector' ] !== '' && isset( $part[ 'design' ] ) && $part[ 'design' ] !== '' ) {
                                                    $selector = '';
                                                    $part_selector = str_replace( 'DG-template-part-ID', $id_value[ 'part_id' ], $part[ 'selector' ] );
                                                    $selector_arr = explode( ',', $part_selector );
                                                    foreach( (array) $selector_arr as $item ) {
                                                        if ( $selector !== '' ) {
                                                            $selector .= ',';
                                                        }
                                                        if ( strpos( $item, '#' . $id_value[ 'part_id' ] ) === false ) {
                                                            if ( strpos( $item, '!' ) !== false ) {
                                                                $cut = explode( '!', $item );
                                                                if ( $id_value[ 'part_id' ] === 'page' ) {
                                                                    $selector .= $cut[ 0 ] . '#' . $id_value[ 'part_id' ] . ' ' . $cut[ 1 ];
                                                                } else {
                                                                    $selector .= $cut[ 0 ] . ' #' . $id_value[ 'part_id' ] . ' ' . $cut[ 1 ];
                                                                }
                                                            } else {
                                                                $selector .= '#' . $id_value[ 'part_id' ] . ' ' . $item;
                                                            }
                                                        } elseif ( strpos( $item, '!' ) !== false ) {
                                                            if ( $id_value[ 'part_id' ] === 'page' ) {
                                                                $selector .= str_replace( '!', '', $item );
                                                            } else {
                                                                $selector .= str_replace( '!', ' ', $item );
                                                            }
                                                        } else {
                                                            $selector .= $item;
                                                        }
                                                    }
                                                    $design_property = replace_color_code( $color_value, $part[ 'design' ] );
                                                    if ( isset( $tem_value[ 'animation' ] ) ) {
                                                        $design_property = replace_animation_code( $tem_value[ 'animation' ], $design_property );
                                                    }
                                                    if ( $design_property !== '' ) {
                                                        $css[ $page ][ $type ][ $device ] .= $selector . '{' . $design_property . '}';
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        /* パーツ用 */
                        if ( isset( $template[ $page ][ $slug ][ $tmp_id ] ) ) {
                            $part_ids = $template[ $page ][ $slug ][ $tmp_id ];
                            foreach( (array) $design_types as $design_type ) {
                                if ( isset( $tem_value[ $design_type ] ) ) {
                                    $design = $tem_value[ $design_type ];
                                    foreach( (array)$design as $device => $list ) {
                                        if ( $design_type === 'simple' ) {
                                            $css_value = $list;
                                        } else {
                                            $css_value = item_array_sort( $list );
                                        }
                                        foreach( (array)$css_value as $part ) {
                                            if ( isset( $part[ 'selector' ] ) && $part[ 'selector' ] !== '' && isset( $part[ 'design' ] ) && $part[ 'design' ] !== '' ) {
                                                $selector = '';
                                                foreach( (array)$part_ids as $part_id ) {
                                                    $part_selector = str_replace( 'DG-template-part-ID', $part_id, $part[ 'selector' ] );
                                                    $selector_arr = explode( ',', $part_selector );
                                                    foreach( (array) $selector_arr as $selector_item ) {
                                                        $item = $selector_item;
                                                        if ( $slug === 'area' && isset( $template_child_slug[ $page ][ $tmp_id ][ $part_id ] ) ) {
                                                            foreach( (array)$template_child_slug[ $page ][ $tmp_id ][ $part_id ] as $child ) {
                                                                $item = preg_replace( '/' . $child[ 'child_id' ] . '([\\s\\.\\>\\[:~]|$)/s', $child[ 'part_id' ] . '$1', $item );
                                                            }
                                                        }
                                                        if ( $selector !== '' ) {
                                                            $selector .= ',';
                                                        }
                                                        if ( strpos( $item, '#' . $part_id ) === false ) {
                                                            if ( strpos( $item, '!' ) !== false ) {
                                                                $cut = explode( '!', $item );
                                                                if ( $part_id === 'page' ) {
                                                                    $selector .= $cut[ 0 ] . '#' . $part_id . ' ' . $cut[ 1 ];
                                                                } else {
                                                                    $selector .= $cut[ 0 ] . ' #' . $part_id . ' ' . $cut[ 1 ];
                                                                }
                                                            } else {
                                                                $selector .= '#' . $part_id . ' ' . $item;
                                                            }
                                                        } elseif ( strpos( $item, '!' ) !== false ) {
                                                            if ( $part_id === 'page' ) {
                                                                $selector .= str_replace( '!', '', $item );
                                                            } else {
                                                                $selector .= str_replace( '!', ' ', $item );
                                                            }
                                                        } else {
                                                            $selector .= $item;
                                                        }
                                                    }
                                                }
                                                $design_property = replace_color_code( $color_value, $part[ 'design' ] );
                                                if ( isset( $tem_value[ 'animation' ] ) ) {
                                                    $design_property = replace_animation_code( $tem_value[ 'animation' ], $design_property );
                                                }
                                                if ( $design_property !== '' ) {
                                                    $css[ $page ][ $type ][ $device ] .= $selector . '{' . $design_property . '}';
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        /* エディター用 */
                        if ( strpos( $page, 'single-' ) !== false ) {
                            if ( isset( $template_editor[ $slug ][ $tmp_id ] ) ) {
                                $part_ids = $template_editor[ $slug ][ $tmp_id ];
                                foreach( (array) $design_types as $design_type ) {
                                    if ( isset( $tem_value[ $design_type ] ) ) {
                                        $design = $tem_value[ $design_type ];
                                        foreach( (array)$design as $device => $list ) {
                                            if ( $design_type === 'simple' ) {
                                                $css_value = $list;
                                            } else {
                                                $css_value = item_array_sort( $list );
                                            }
                                            foreach( (array)$css_value as $part ) {
                                                if ( isset( $part[ 'selector' ] ) && $part[ 'selector' ] !== '' && isset( $part[ 'design' ] ) && $part[ 'design' ] !== '' ) {
                                                    $selector = '';
                                                    foreach( (array)$part_ids as $part_id ) {
                                                        $part_selector = str_replace( 'DG-template-part-ID', $part_id, $part[ 'selector' ] );
                                                        $selector_arr = explode( ',', $part_selector );
                                                        foreach( (array) $selector_arr as $item ) {
                                                            if ( $item !== '#' . $part_id ) {
                                                                if ( $selector !== '' ) {
                                                                    $selector .= ',';
                                                                }
                                                                if ( strpos( $item, '#' . $part_id ) === false ) {
                                                                    if ( strpos( $item, '!' ) !== false ) {
                                                                        $cut = explode( '!', $item );
                                                                        $selector .= '#editor .edit-post-visual-editor .editor-styles-wrapper ' . $cut[ 1 ];
                                                                    } else {
                                                                        $selector .= '#editor .edit-post-visual-editor .editor-styles-wrapper ' . $item;
                                                                    }
                                                                } elseif ( strpos( $item, '!' ) !== false ) {
                                                                    $cut = explode( '!', $item );
                                                                    $selector .= '#editor .edit-post-visual-editor .editor-styles-wrapper ' . $cut[ 1 ];
                                                                } else {
                                                                    $selector .= str_replace( '#' . $part_id, '#editor .edit-post-visual-editor .editor-styles-wrapper ', $item );
                                                                }
                                                            } else {
                                                                $selector .= str_replace( '#' . $part_id, '#editor .edit-post-visual-editor .editor-styles-wrapper ', $item );
                                                            }
                                                        }
                                                    }
                                                    $design_property = replace_color_code( $color_value, $part[ 'design' ] );
                                                    if ( isset( $tem_value[ 'animation' ] ) ) {
                                                        $design_property = replace_animation_code( $tem_value[ 'animation' ], $design_property );
                                                    }
                                                    if ( $design_property !== '' ) {
                                                        $design_property = str_replace( 'important', '', $design_property );
                                                        $design_property = str_replace( ';', ' !important;', $design_property );
                                                        $css[ 'editor' ][ $page ][ $device ] .= $selector . '{' . $design_property . '}';
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    return $css;
}

//エリアorパーツCSS作成
function create_area_part_css_data( $css, $type, $data ) {
    $color_value = $data[ 'color_value' ];
    $anime_list = $data[ 'anime_list' ];
    $parts = $data[ 'parts' ];
    if ( is_array( $parts ) && count( $parts ) > 0 ) {
        foreach( (array)$parts as $page => $page_val ) {
            foreach( (array)$page_val as $part_id => $value ) {
                foreach( (array)$value[ 'design' ] as $device => $list ) {
                    $css_value = item_array_sort( $list );
                    foreach( (array)$css_value as $part ) {
                        if ( isset( $part[ 'selector' ] ) && $part[ 'selector' ] !== '' && isset( $part[ 'design' ] ) && $part[ 'design' ] !== '' ) {
                            $selector = '';
                            $selector_arr = explode( ',', $part[ 'selector' ] );
                            foreach( (array) $selector_arr as $item ) {
                                if ( $selector !== '' ) {
                                    $selector .= ',';
                                }
                                if ( strpos( $item, '#' . $part_id ) === false ) {
                                    if ( strpos( $item, '!' ) !== false ) {
                                        $cut = explode( '!', $item );
                                        if ( $part_id === 'page' ) {
                                            $selector .= $cut[ 0 ] . '#' . $part_id . ' ' . $cut[ 1 ];
                                        } else {
                                            $selector .= $cut[ 0 ] . ' #' . $part_id . ' ' . $cut[ 1 ];
                                        }
                                    } else {
                                        $selector .= '#' . $part_id . ' ' . $item;
                                    }
                                } elseif ( strpos( $item, '!' ) !== false ) {
                                    if ( $part_id === 'page' ) {
                                        $selector .= str_replace( '!', '', $item );
                                    } else {
                                        $selector .= str_replace( '!', ' ', $item );
                                    }
                                } else {
                                    $selector .= $item;
                                }
                            }
                            $design_property = replace_color_code( $color_value, $part[ 'design' ] );
                            $design_property = replace_animation_code( $anime_list, $design_property );
                            if ( $design_property !== '' ) {
                                $css[ $page ][ $type ][ $device ] .= $selector . '{' . $design_property . '}';
                            }
                        }
                    }
                }
                if ( isset( $value[ 'simple' ] ) ) {
                    foreach( (array)$value[ 'simple' ] as $device => $list ) {
                        foreach( (array)$list as $part ) {
                            if ( isset( $part[ 'selector' ] ) && $part[ 'selector' ] !== '' && isset( $part[ 'design' ] ) && $part[ 'design' ] !== '' ) {
                                $selector = '';
                                $selector_arr = explode( ',', $part[ 'selector' ] );
                                foreach( (array) $selector_arr as $item ) {
                                    if ( $selector !== '' ) {
                                        $selector .= ',';
                                    }
                                    if ( strpos( $item, '#' . $part_id ) === false ) {
                                        if ( strpos( $item, '!' ) !== false ) {
                                            $cut = explode( '!', $item );
                                            if ( $part_id === 'page' ) {
                                                $selector .= $cut[ 0 ] . '#' . $part_id . ' ' . $cut[ 1 ];
                                            } else {
                                                $selector .= $cut[ 0 ] . ' #' . $part_id . ' ' . $cut[ 1 ];
                                            }
                                        } else {
                                            $selector .= '#' . $part_id . ' ' . $item;
                                        }
                                    } elseif ( strpos( $item, '!' ) !== false ) {
                                        if ( $part_id === 'page' ) {
                                            $selector .= str_replace( '!', '', $item );
                                        } else {
                                            $selector .= str_replace( '!', ' ', $item );
                                        }
                                    } else {
                                        $selector .= $item;
                                    }
                                }
                                $design_property = replace_color_code( $color_value, $part[ 'design' ] );
                                $design_property = replace_animation_code( $anime_list, $design_property );
                                if ( $design_property !== '' ) {
                                    $css[ $page ][ $type ][ $device ] .= $selector . '{' . $design_property . '}';
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    return $css;
}