<?php
/*
 * サイトプレビューコンテンツ取得
*/
add_action( 'wp_ajax_site_builder_preview', 'site_builder_preview' );
add_action( 'wp_ajax_nopriv_site_builder_preview', 'site_builder_preview' );
function site_builder_preview() {
    $post = $_POST;
    if ( !isset( $post[ 'preview' ] ) && ( !isset( $post[ 'value' ] ) || ( isset( $post[ 'value' ] ) && $post[ 'value' ] === '' ) ) && !isset( $post[ 'page_type' ] ) ) {
        echo json_encode( array( 'preview' => true ) );
        exit();
    }
    $page_obj = new CreatePageInfoPreview( $post );
    $page_info = $page_obj->getPageInfo();
    $home_url = $page_obj->getHomeUrl();
    $stylesheet_url = get_template_directory_uri();
    //no-image
    $noimage_url = '';
    if ( isset( $post[ 'noimage' ] ) ) {
        $noimage = json_decode( stripslashes( rawurldecode( $post[ 'noimage' ] ) ), true );
        if ( isset( $noimage[ 'src' ] ) && $noimage[ 'src' ] !== '' ) {
            $noimage_url = $noimage[ 'src' ];
        }
    }
    if ( $noimage_url === '' ) {
        $noimage_url = $stylesheet_url . '/image/no-image.gif';
    }
    
    $fixed_url = array();
    if ( isset( $_POST[ 'fixed' ] ) ) {
        $fixed = json_decode( stripslashes( rawurldecode( $_POST[ 'fixed' ] ) ), true );
        if ( isset( $fixed[ 'type' ] ) && $fixed[ 'type' ] === '2' ) {
            if ( isset( $fixed[ 'src' ] ) && $fixed[ 'src' ] !== '' ) {
                $fixed_url[ 'url' ] = $fixed[ 'src' ];
            }
        } else {
            if ( isset( $fixed[ 'id' ] ) && $fixed[ 'id' ] !== '' ) {
                $fixed_arr = post_image_src_list( $fixed[ 'id' ], null );
                if ( $fixed_arr !== false ) {
                    $fixed_url = $fixed_arr;
                }
            }
        }
    }
    //loading-image
    $loading_img = '';
    if ( isset( $post[ 'loading' ] ) ) {
        $loading = json_decode( stripslashes( rawurldecode( $post[ 'loading' ] ) ), true );
        if ( isset( $loading[ 'src' ] ) && $loading[ 'src' ] !== '' ) {
            $loading_img = $loading[ 'src' ];
        }
    }
    if ( $loading_img === '' ) {
        $loading_img = $stylesheet_url . '/image/loading.gif';
    }
    
    $design_value = json_decode( stripslashes( rawurldecode( $post[ 'value' ] ) ), true );
    $site_option_value = array( 'main' => $design_value );
    $site_option_value[ 'loading_image' ] = $loading_img;
    $page_obj->createSiteOption( $site_option_value );
    $main_value = $page_obj->getSiteOption();
    if ( !isset( $main_value[ 'main' ] ) ) {
        echo json_encode( array( 'preview' => true ) );
        exit();
    }
    $design_value = $main_value[ 'main' ];
    $page_info = $page_obj->setCurrentPageInfo();
    $post_summary = $page_obj->getPostSummary();
    $archive = $page_obj->getArchive();
    $page_class = $page_obj->getPageClass();
    $result = $page_obj->getCacheDatas();
    $result[ 'post' ] = $post_summary;
    $result[ 'archive' ] = $archive;
    $result[ 'pageClass' ] = $page_class;
    $page_info[ 'preview' ] = true;
    $css_flg = $main_value[ 'css_flg' ];
    $breadcrumb_obj = new FrontBreadcrumb( $page_obj );
    $result[ 'breadcrumb' ] = $breadcrumb_obj->getBreadcrumb();
    /* viewリセットチェック */
    check_site_views_reset();
    /* コンテンツ作成 */
    $part_keys = is_array( $design_value ) ? array_keys( $design_value ) : array();
    $result[ 'pageType' ] = $page_info[ 'taxonomy' ];
    $result[ 'preview' ] = true;
    //コンテンツまとめ
    $front_summary = array(
        'archive' => $archive,
        'post_summary' => $post_summary,
        'page_info' => $page_info,
        'loading_img' => $loading_img,
        'home_url' => $home_url,
        'preview' => true,
    );
    $summary = array(
        'part_keys' => $part_keys,
        'design_value' => $design_value,
        'front_summary' => $front_summary,
        'today' => new DateTime( wp_date( 'Y-m-d H:i:s' ) ),
        'get' => array(),
    );
    //パーツ配列作成
    $part = front_part_summary( $summary );
    /* プレビュー用にデータ調整 */
    $result[ 'parts' ] = preview_hidden_part_filter( $design_value, $part, $page_info, $post_summary );
    //サイト内移動
    if ( isset( $design_value[ 'page' ][ 'option' ][ 'move' ] ) && $design_value[ 'page' ][ 'option' ][ 'move' ] !== '' ) {
        $result[ 'scroll' ][ 'move' ] = $design_value[ 'page' ][ 'option' ][ 'move' ];
    }
    if ( isset( $design_value[ 'page' ][ 'option' ][ 'speed' ] ) && $design_value[ 'page' ][ 'option' ][ 'speed' ] !== '' ) {
        $result[ 'scroll' ][ 'speed' ] = $design_value[ 'page' ][ 'option' ][ 'speed' ];
    }
    $result[ 'noImage' ] = $noimage_url;
    $result[ 'fixedImage' ] = $fixed_url;
    $logo = array();
    if ( isset( $post[ 'logo' ] ) ) {
        $logo = json_decode( stripslashes( rawurldecode( $post[ 'logo' ] ) ), true );
    }
    $result[ 'pcLogo' ] = isset( $logo[ 'pc' ][ 'src' ] ) && $logo[ 'pc' ][ 'src' ] ? $logo[ 'pc' ][ 'src' ] : '';
    $result[ 'spLogo' ] = isset( $logo[ 'sp' ][ 'src' ] ) && $logo[ 'sp' ][ 'src' ] ? $logo[ 'sp' ][ 'src' ] : '';
    $result[ 'loadingImg' ] = $loading_img;
    $result[ 'siteUrl' ] = site_url();
    //サイト全体Views
    $site_view_all = get_option( 'dg_site_views', 0 );
    $site_view_y = get_option( 'dg_site_views_y', 0 );
    $site_view_m = get_option( 'dg_site_views_m', 0 );
    $site_view_w = get_option( 'dg_site_views_w', 0 );
    $result[ 'siteViews' ] = array(
        'views' => number_format( $site_view_all ),
        'y_views' => number_format( $site_view_y ),
        'm_views' => number_format( $site_view_m ),
        'w_views' => number_format( $site_view_w ),
    );
    //CSS読み込み判定
    if ( isset( $css_flg[ 'block' ] ) && $css_flg[ 'block' ] === true ) {
        $result[ 'blockStyleFlg' ] = true;
    }
    if ( isset( $css_flg[ 'dg' ] ) && $css_flg[ 'dg' ] === true ) {
        $result[ 'DgStyleFlg' ] = true;
    }
    //CSSデザインを渡す
    if ( isset( $post[ 'design' ] ) ) {
        $result[ 'design' ] = $post[ 'design' ];
    }
    echo json_encode( $result );
    exit();
}

function preview_hidden_part_filter( $design_value, $part, $page_info, $post_summary ) {
    $preview_value = array();
    $page_id = $page_info[ 'page_type' ] === 'single' ? $page_info[ 'post_id' ] : $page_info[ 'term_id' ];
    $user_id = isset( $post_summary[ 'user_id' ] ) ? $post_summary[ 'user_id' ] : false;
    foreach( (array)$part as $part_id => $value ) {
        $parts = $design_value[ $part_id ];
        //ページによる非表示
        if ( $page_info[ 'page_type' ] === 'top' ) {
            $page_type = 'top';
        } elseif ( $page_info[ 'page_type' ] === 'taxonomy' || $page_info[ 'page_type' ] === 'custom-post-archive' || $page_info[ 'page_type' ] === 'single' ) {
            $page_type = $page_info[ 'page_type' ] . '-' . $page_info[ 'taxonomy' ];
        } else {
            $page_type = 'other-' . $page_info[ 'taxonomy' ];
        }
        $select_hidden_ids = isset ( $parts[ 'hidden' ][ $page_type . '-in' ] ) && $parts[ 'hidden' ][ $page_type . '-in' ] !== '' ?  explode( ',', $parts[ 'hidden' ][ $page_type . '-in' ] ) : false;
        //作成者設定
        $select_hidden_author = isset ( $parts[ 'hidden' ][ $page_type . '-author-in' ] ) && $parts[ 'hidden' ][ $page_type . '-author-in' ] !== '' ?  explode( ',', $parts[ 'hidden' ][ $page_type . '-author-in' ] ) : false;
        //記事ページで、タクソノミー指定の場合
        $select_hidden_taxs = false;
        if ( $page_info[ 'page_type' ] === 'single' ) {
            //カテゴリー設定
            if ( is_array( $post_summary[ 'taxonomy' ] ) && count( $post_summary[ 'taxonomy' ] ) > 0 ) {
                foreach( (array)$post_summary[ 'taxonomy' ] as $tax_slug => $tax_val ) {
                    if ( isset ( $parts[ 'hidden' ][ $page_type . '-' . $tax_slug . '-in' ] ) && $parts[ 'hidden' ][ $page_type . '-' . $tax_slug . '-in' ] !== '' ) {
                        $hidden_taxs = explode( ',', $parts[ 'hidden' ][ $page_type . '-' . $tax_slug . '-in' ] );
                        $this_taxs = array_column( $tax_val, 'term_id' );
                        foreach( (array)$hidden_taxs as $term_id ) {
                            $child_terms = get_term_children( $term_id, $tax_slug );
                            if ( !is_wp_error( $child_terms ) ) {
                                $hidden_taxs = array_merge( $hidden_taxs, $child_terms );
                            }
                        }
                        $check_taxs = array_intersect( $this_taxs, $hidden_taxs );
                        if ( is_array( $check_taxs ) && count( $check_taxs ) > 0 ) {
                            $select_hidden_taxs = 'in';
                        } else {
                            $select_hidden_taxs = 'out';
                        }
                    }
                }
            }
        }
        $flg = true;
        if ( $value === false ) {
            $flg = false;
        } elseif ( isset ( $parts[ 'hidden' ][ $page_type ] ) && $parts[ 'hidden' ][ $page_type ] === '1' ) {
            if ( $page_info[ 'page_type' ] === 'single' ) {
                if ( $select_hidden_taxs === false && $select_hidden_ids === false && $select_hidden_author === false ) {
                    $flg = false;
                } elseif ( $select_hidden_taxs === 'in' || ( $select_hidden_ids !== false && in_array( (string)$page_id, $select_hidden_ids, true ) === true ) || ( $select_hidden_author !== false && $user_id !== false && in_array( (string)$user_id, $select_hidden_author, true ) === true ) ) {
                    $flg = false;
                } else {
                    $flg = true;
                }
            } elseif ( ( $page_info[ 'page_type' ] === 'taxonomy' && $page_info[ 'taxonomy' ] !== 'date' ) || $page_info[ 'taxonomy' ] === 'author' ) {
                if ( $select_hidden_ids === false ) {
                    $flg = false;
                } elseif ( $select_hidden_ids !== false && in_array( (string)$page_id, $select_hidden_ids, true ) === true ) {
                    $flg = false;
                } else {
                    $flg = true;
                }
            } else {
                $flg = false;
            }
        } elseif ( ( $select_hidden_taxs !== false || $select_hidden_ids !== false && in_array( (string)$page_id, $select_hidden_ids, true ) === true ) || ( $select_hidden_author !== false && $user_id !== false ) ) {
            //各タクソノミーで判定
            if ( isset ( $parts[ 'hidden' ][ $page_type ] ) && $parts[ 'hidden' ][ $page_type ] === '1' ) {
                if ( ( $select_hidden_taxs === 'in' || ( $select_hidden_ids !== false && in_array( (string)$page_id, $select_hidden_ids, true ) === true ) ) || ( $select_hidden_author !== false && $user_id !== false && in_array( (string)$user_id, $select_hidden_author, true ) === true ) ) {
                    $flg = false;
                } else {
                    $flg = true;
                }
            } else {
                if ( ( $select_hidden_taxs === 'in' || ( $select_hidden_ids !== false && in_array( (string)$page_id, $select_hidden_ids, true ) === true ) ) || ( $select_hidden_author !== false && $user_id !== false && in_array( (string)$user_id, $select_hidden_author, true ) === true ) ) {
                    $flg = true;
                } else {
                    $flg = false;
                }
            }
        } elseif ( isset ( $parts[ 'type' ] ) ) {
            if ( $parts[ 'type' ] === 'single' && ( $page_info[ 'taxonomy' ] === 'search' || $page_info[ 'taxonomy' ] === 'author' || $page_info[ 'taxonomy' ] === 'top' || ( isset( $page_info[ 'page_type' ] ) && ( 'taxonomy' === $page_info[ 'page_type' ] || $page_info[ 'page_type' ] === 'custom-post-archive' ) ) ) ) {
                $flg = false;
            } elseif ( $parts[ 'type' ] === 'taxonomy' && isset( $page_info[ 'page_type' ] ) && 'single' === $page_info[ 'page_type' ] ) {
                $flg = false;
            } elseif ( $page_info[ 'page_type' ] === '404' && ( 'single' === $parts[ 'type' ] || ( 'taxonomy' === $parts[ 'type' ] && $parts[ 'slug' ] !== 'taxonomy-title' ) ) ) {
                $flg = false;
            } elseif ( $select_hidden_ids !== false && in_array( (string)$page_id, $select_hidden_ids, true ) !== true ) {
                $flg = false;
            } else {
                $flg = true;
            }
        } else {
            $flg = false;
        }
        //GETパラメータで非表示
        if ( $flg && isset( $parts[ 'hidden' ][ 'get-in' ] ) && is_array( $parts[ 'hidden' ][ 'get-in' ] ) && count( $parts[ 'hidden' ][ 'get-in' ] ) > 0 ) {
            $get = $page_info[ 'parm' ];
            $get_flg = false;
            foreach( (array)$parts[ 'hidden' ][ 'get-in' ] as $key => $get_val ) {
                if ( isset( $get_val[ 'name' ] ) && $get_val[ 'name' ] !== '' ) {
                    if ( isset( $get[ $get_val[ 'name' ] ] ) && ( !isset( $get_val[ 'value' ] ) || ( isset( $get_val[ 'value' ] ) && $get_val[ 'value' ] !== '' && $get[ $get_val[ 'name' ] ] === $get_val[ 'value' ] ) ) ) {
                        $get_flg = true;
                    }
                }
            }
            if ( isset( $parts[ 'hidden' ][ 'get' ] ) && $parts[ 'hidden' ][ 'get' ] === '1' ) {
                if ( $get_flg ) {
                    $flg = false;
                } else {
                    $flg = true;
                }
            } else {
                if ( $get_flg ) {
                    $flg = true;
                } else {
                    $flg = false;
                }
            }
        }
        if ( $flg ) {
            $preview_value[ $part_id ] = $value;
            $preview_value[ $part_id ][ 'preview' ] = true;
        } else {
            $preview_value[ $part_id ] = $parts;
            $preview_value[ $part_id ][ 'preview' ] = true;
            $preview_value[ $part_id ][ 'hiddenPart' ] = true;
        }
    }
    return $preview_value;
}

/*
 * もっと見るボタンプレビュー機能
*/
add_action( 'wp_ajax_site_builder_most_post_preview', 'site_builder_most_post_preview' );
add_action( 'wp_ajax_nopriv_site_builder_most_post_preview', 'site_builder_most_post_preview' );
function site_builder_most_post_preview() {
    if ( !isset( $_POST[ 'preview' ] ) && ( !isset( $_POST[ 'value' ] ) || ( isset( $_POST[ 'value' ] ) && $_POST[ 'value' ] === '' ) ) && !isset( $_POST[ 'page_type' ] ) ) {
        echo json_encode( array( 'preview' => true ) );
        exit();
    }
    $page_obj = new CreatePageInfoPreview( $_POST );
    $home_url = $page_obj->getHomeUrl();
    $design_value = json_decode( stripslashes( rawurldecode( $_POST[ 'value' ] ) ), true );
    $stylesheet_url = get_template_directory_uri();
    $loading_img = $stylesheet_url . '/image/loading.gif';
    //ページに合わせて事前に情報取得
    $site_option_value = array( 'main' => $design_value );
    $site_option_value[ 'loading_image' ] = $loading_img;
    $page_obj->createSiteOption( $site_option_value );
    $main_value = $page_obj->getSiteOption();
    if ( !isset( $main_value[ 'main' ] ) ) {
        echo json_encode( array( 'preview' => true ) );
        exit();
    }
    $design_value = $main_value[ 'main' ];
    $result = $page_obj->setCurrentPageInfoMore( $_POST );
    $page_info = $page_obj->getPageInfo();
    $post_summary = $page_obj->getPostSummary();
    $archive = $page_obj->getArchive();
    $page_class = $page_obj->getPageClass();
    $result[ 'post' ] = $post_summary;
    $result[ 'archive' ] = $archive;
    $result[ 'pageClass' ] = $page_class;
    $page_info[ 'preview' ] = true;
    
    //コンテンツまとめ
    $front_parts = isset( $_POST[ 'ids' ] ) && $_POST[ 'ids' ] !== '' ? explode( ',', $_POST[ 'ids' ] ) : false;
    $front_summary = array(
        'archive' => $archive,
        'post_summary' => $post_summary,
        'page_info' => $page_info,
        'home_url' => $home_url,
        'more_flg' => true,
    );
    $summary = array(
        'part_keys' => $front_parts,
        'design_value' => $design_value,
        'front_summary' => $front_summary,
        'today' => new DateTime( wp_date( 'Y-m-d H:i:s' ) ),
        'get' => array(),
    );
    $part = front_part_summary( $summary );
    $result[ 'parts' ] = preview_hidden_part_filter( $design_value, $part, $page_info, $post_summary );
    //ロゴとNoイメージセット
    $noimage_url = '';
    if ( isset( $_POST[ 'noimage' ] ) ) {
        $noimage = json_decode( stripslashes( rawurldecode( $_POST[ 'noimage' ] ) ), true );
        if ( isset( $noimage[ 'src' ] ) && $noimage[ 'src' ] !== '' ) {
            $noimage_url = $noimage[ 'src' ];
        }
    }
    if ( $noimage_url === '' ) {
        $noimage_url = $stylesheet_url . '/image/no-image.gif';
    }
    $fixed_url = array();
    if ( isset( $_POST[ 'fixed' ] ) ) {
        $fixed = json_decode( stripslashes( rawurldecode( $_POST[ 'fixed' ] ) ), true );
        if ( isset( $fixed[ 'type' ] ) && $fixed[ 'type' ] === '2' ) {
            if ( isset( $fixed[ 'src' ] ) && $fixed[ 'src' ] !== '' ) {
                $fixed_url[ 'url' ] = $fixed[ 'src' ];
            }
        } else {
            if ( isset( $fixed[ 'id' ] ) && $fixed[ 'id' ] !== '' ) {
                $fixed_arr = post_image_src_list( $fixed[ 'id' ], null );
                if ( $fixed_arr !== false ) {
                    $fixed_url = $fixed_arr;
                }
            }
        }
    }
    $result[ 'noImage' ] = $noimage_url;
    $result[ 'fixedImage' ] = $fixed_url;
    $result[ 'preview' ] = true;
    $logo = array();
    if ( isset( $_POST[ 'logo' ] ) ) {
        $logo = json_decode( stripslashes( rawurldecode( $_POST[ 'logo' ] ) ), true );
    }
    $result[ 'pcLogo' ] = isset( $logo[ 'pc' ][ 'src' ] ) && $logo[ 'pc' ][ 'src' ] ? $logo[ 'pc' ][ 'src' ] : '';
    $result[ 'spLogo' ] = isset( $logo[ 'sp' ][ 'src' ] ) && $logo[ 'sp' ][ 'src' ] ? $logo[ 'sp' ][ 'src' ] : '';
    $result[ 'loadingImg' ] = $loading_img;
    echo json_encode( $result );
    exit();
}

/*
 * シミュレーター内サイトリンク情報取得
*/
add_action( 'wp_ajax_get_in_site_link_page', 'get_in_site_link_page' );
add_action( 'wp_ajax_nopriv_get_in_site_link_page', 'get_in_site_link_page' );
function get_in_site_link_page() {
    $result = false;
    if ( isset( $_POST[ 'href' ] ) && $_POST[ 'href' ] !== '' ) {
        $home_url = home_url();
        $href = $_POST[ 'href' ];
        if ( !preg_match( '/^(http(s)?:\/\/)www\./', $home_url ) && preg_match( '/^(http(s)?:\/\/)www\./', $href ) ) {
            $href = preg_replace( '/^(http(s)?:\/\/)www\./', '$1', $href );
        } elseif ( preg_match( '/^(http(s)?:\/\/)www\./', $home_url ) && !preg_match( '/^(http(s)?:\/\/)www\./', $href ) ) {
            $href = preg_replace( '/^(http(s)?:\/\/)/', '$1www.', $href );
        }
        $url_pattern = str_replace( '/', '\/', $url_pattern );
        $url_pattern = str_replace( '-', '\-', $url_pattern );
        $url_pattern = str_replace( '.', '\.', $url_pattern );
        $url_pattern = str_replace( '?', '\?', $url_pattern );
        $url_pattern = str_replace( '+', '\+', $url_pattern );
        if ( !preg_match( '/^\//', $href ) && !preg_match( '/^' . $url_pattern . '/', $href ) ) {
            $result = false;
        } else {
            $page_obj = new CreatePageInfoUrl( $href );
            $result = $page_obj->getPageInfo();
            if ( $result[ 'page_type' ] === 'single' && $result[ 'taxonomy' ] === 'lp' ) {
                $result = 'lp';
            }
        }
    }
    echo json_encode( $result );
    exit();
}

/*
 * シミュレーター内サイトリンク情報取得
*/
add_action( 'wp_ajax_get_site_favicon_url', 'get_site_favicon_url' );
add_action( 'wp_ajax_nopriv_get_site_favicon_url', 'get_site_favicon_url' );
function get_site_favicon_url() {
    $result = false;
    if ( isset( $_POST[ 'id' ] ) && $_POST[ 'id' ] !== '' ) {
        $result = post_image_src_list( $_POST[ 'id' ] );
    }
    echo json_encode( $result );
    exit();
}