<?php
/*
 * エリアオプション
*/
function option_window_add_area() {
    //翻訳
    $text_add_area_name = __( 'エリア追加', 'dg-style' );
    $text_current_area_list = __( '現在のエリアリスト', 'dg-style' );
    $text_page_all = __( 'page (全体)', 'dg-style' );
    $text_new_area_name = __( 'エリア名', 'dg-style' );
    $text_new_area_id = __( 'エリアID', 'dg-style' );
    $text_new_area_class = __( 'エリアClass', 'dg-style' );
    $text_new_area_tag = __( 'エリアTag', 'dg-style' );
    $text_new_area_caution = __( '英字で始まる半角英数字のみ', 'dg-style' );
    $text_example = __( '例）', 'dg-style' );
    $text_example_header = __( 'ヘッダー', 'dg-style' );
    return <<< EOM
        <div id="add-area-option" class="option-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_add_area_name}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_current_area_list}</div>
                <div id="current-area-list-inner">
                    <ul id="current-area-list" class="select-area-list">
                        <li class="area-list-item" data-area="page">
                            <div class="add-area-item area-item select moving-area-item">{$text_page_all}</div>
                        </li>
                    </ul>
                </div>
                <table class="area-input-table">
                    <tbody>
                        <tr>
                            <th>{$text_new_area_name}</th>
                            <td class="add-area-input-area"><input type="text" data-level="name" class="add-area-input" placeholder="{$text_example}{$text_example_header}"></td>
                        </tr>
                        <tr>
                            <th>{$text_new_area_id}</th>
                            <td class="add-area-input-area"><input type="text" data-level="id" class="add-area-input" placeholder="{$text_example}header"></td>
                        </tr>
                        <tr>
                            <th>{$text_new_area_class}</th>
                            <td class="add-area-input-area"><input type="text" data-level="class" class="add-area-input" placeholder="{$text_example}header-inner"></td>
                        </tr>
                        <tr>
                            <th>{$text_new_area_tag}</th>
                            <td>
                                <select class="add-area-tag-select" data-level="tag">
                                    <option value="div" selected>div</option>
                                    <option value="header">header</option>
                                    <option value="footer">footer</option>
                                    <option value="main">main</option>
                                    <option value="nav">nav</option>
                                    <option value="section">section</option>
                                    <option value="article">article</option>
                                    <option value="aside">aside</option>
                                </select>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <p class="caution">※{$text_new_area_caution}</p>
                <button type="button" class="add-area-btn">{$text_add_area_name}</button>
            </div>
        </div>
        <div id="area-add-area" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_add_area_name}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <table class="area-input-table">
                    <tbody>
                        <tr>
                            <th>{$text_new_area_name}</th>
                            <td class="add-area-input-area"><input type="text" data-level="name" class="add-area-input" placeholder="{$text_example}{$text_example_header}"></td>
                        </tr>
                        <tr>
                            <th>{$text_new_area_id}</th>
                            <td class="add-area-input-area"><input type="text" data-level="id" class="add-area-input" placeholder="{$text_example}header"></td>
                        </tr>
                        <tr>
                            <th>{$text_new_area_class}</th>
                            <td class="add-area-input-area"><input type="text" data-level="class" class="add-area-input" placeholder="{$text_example}header-inner"></td>
                        </tr>
                        <tr>
                            <th>{$text_new_area_tag}</th>
                            <td>
                                <select class="add-area-tag-select" data-level="tag">
                                    <option value="div" selected>div</option>
                                    <option value="header">header</option>
                                    <option value="footer">footer</option>
                                    <option value="main">main</option>
                                    <option value="nav">nav</option>
                                    <option value="section">section</option>
                                    <option value="article">article</option>
                                    <option value="aside">aside</option>
                                </select>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <p class="caution">※{$text_new_area_caution}</p>
                <button type="button" class="add-area-btn">{$text_add_area_name}</button>
            </div>
        </div>
EOM;
}

/*
 * エリアオプション
*/
function option_window_select_area() {
    //翻訳
    $text_area_select = __( 'エリア選択', 'dg-style' );
    $text_current_area_list = __( '現在のエリアリスト', 'dg-style' );
    $text_page_all = __( 'page (全体)', 'dg-style' );
    $text_part_name = __( 'パーツ名入力', 'dg-style' );
    $text_part_name_caution = __( '区別しやすいパーツ名を入力', 'dg-style' );
    $text_insert_part_btn = __( '選択したエリアにパーツ追加', 'dg-style' );
    return <<< EOM
        <div id="select-area-option" class="option-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_area_select}</div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_current_area_list}</div>
                <div id="add-part-select-area-inner">
                    <ul id="add-part-select-area" class="select-area-list">
                        <li class="area-list-item" data-area="page">
                            <div class="select-area-item area-item select moving-area-item">{$text_page_all}</div>
                        </li>
                    </ul>
                </div>
                <div class="window-title">{$text_part_name}</div>
                <input type="text" class="add-part-label-input" placeholder="{$text_part_name_caution}">
                <div class="add-part-area-btn">{$text_insert_part_btn}</div>
            </div>
        </div>
EOM;
}

/*
 * エリアオプション
*/
function option_window_moving_area_list() {
    //翻訳
    $text_moving_name = __( '移動先エリア選択', 'dg-style' );
    $text_current_area_list = __( '現在のエリアリスト', 'dg-style' );
    $text_page_all = __( 'page (全体)', 'dg-style' );
    return <<< EOM
        <div id="moving-area-option" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_moving_name}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_current_area_list}</div>
                <ul id="moving-area-list" class="select-area-list">
                    <li class="area-list-item" data-area="page">
                        <div class="area-item select moving-area-item">{$text_page_all}</div>
                    </li>
                </ul>
            </div>
        </div>
EOM;
}

/*
 * パーツオプション窓
*/
function option_part_template_window( $part_list ) {
    //翻訳
    $text_template_list_title = __( 'テンプレートリスト', 'dg-style' );
    $text_template_list_registered = __( '登録済み', 'dg-style' );
    $text_template_list_search = __( '検索', 'dg-style' );
    $text_template_list_free = __( 'テンプレートなし', 'dg-style' );
    //定義
    global $wp_filesystem;
    $upload_dir = wp_upload_dir();
    $directory_path = $upload_dir[ 'basedir' ];
    $stylesheet_url = get_template_directory_uri();
    $window = '';
    foreach( (array)$part_list as $key => $value ) {
        if ( $key !== 'taxonomy-post_list' && $key !== 'single-recommend' ) {
            $design_path = $directory_path . '/design-json/template/' . $key . '.json';
            $template_value = '';
            $template_list = array();
            if ( !is_file( $design_path ) ) {
                save_part_template_design( $key );
            } else {
                $part_file = $wp_filesystem->get_contents( $design_path );
                $template_value = htmlspecialchars( $part_file, ENT_QUOTES, 'UTF-8' );
                $template_list = json_decode( $part_file, true );
            }
            $narrow_label = array();
            $template_items = '';
            if ( is_array( $template_list ) && count( $template_list ) > 0 ) {
                foreach( (array)$template_list as $level => $template_val ) {
                    $image = isset( $template_val[ 'image' ] ) && $template_val[ 'image' ] !== '' ? $template_val[ 'image' ] : $stylesheet_url . '/image/no-image.gif';
                    $group = isset( $template_val[ 'temp-group' ] ) && $template_val[ 'temp-group' ] !== '' ? $template_val[ 'temp-group' ] : 'common';
                    $name = isset( $template_val[ 'temp-name' ] ) && $template_val[ 'temp-name' ] !== '' ? $template_val[ 'temp-name' ] : $level;
                    $narrow_label[ $group ] = '<button type="button" class="part-template-type" data-level="' . $group . '">' . $group . '</button>';
                    $template_items .= <<< EOM
                        <div class="part-template-design part-template-item display" data-level="{$level}" data-group="{$group}">
                            <div class="template-image"><img loading="lazy" src="{$image}"></div>
                            <div class="template-name">{$name}</div>
                            <button type="button" class="edit-template-btn close-pass"></button>
                            <button type="button" class="overwrite-template-btn close-pass"></button>
                            <button type="button" class="delete-template-btn close-pass"></button>
                        </div>
EOM;
                }
            }
            $narrow_label = implode( '', $narrow_label );
            $window .= <<< EOM
                <div id="template-{$key}-option" class="option-window add-part-window template-window">
                    <div class="window-header">
                        <div class="window-name">{$value[ 'name' ]}</div>
                        <!--<div class="window-info header-btn"></div>-->
                        <div class="window-close header-btn"></div>
                    </div>
                    <div class="window-content">
                        <div class="upload-template-field-area">
                            <button type="button" class="upload-template-btn" title="テンプレートアップロード"></button>
                            <div class="template-upload-form-area">
                                <div class="window-title">テンプレートアップロード</div>
                                <textarea class="upload-template-input" rows="3"></textarea>
                                <div class="uploda-error-message"></div>
                                <p class="caution">※クリップボードにコピーした値を貼り付けて適用してください。</p>
                                <div class="upload-btns">
                                    <button type="button" class="template-upload-sumit upload-btn upload" value="{$key}">適用</button>
                                    <button type="button" class="template-upload-cancel upload-btn cancel">取り消し</button>
                                </div>
                            </div>
                        </div>
                        <button type="button" class="download-template-btn" value="{$key}" title="テンプレートダウンロード"></button>
                        <div class="window-title">{$text_template_list_title}</div>
                        <div class="tab-inner">
                            <div class="tab-list part-template-labels flex">
                                <button class="tab-label part-template-label on">{$text_template_list_registered}</button>
                                <button class="tab-label part-template-label">{$text_template_list_search}</button>
                            </div>
                            <div class="tab-contents part-template-contents">
                                <div class="tab-content narrow-inner on">
                                    <div class="part-template-types original-template-labels flex">
                                        <button type="button" class="part-template-type on" data-level="all">all</button>
                                        {$narrow_label}
                                    </div>
                                    <div class="narrow-contents part-template-list original-template-list" data-level="all">
                                        <div class="part-template-design part-template-item free-template-item" data-level="free">
                                            <div class="template-icon">{$text_template_list_free}</div>
                                        </div>
                                        {$template_items}
                                    </div>
                                </div>
                                <div class="tab-content fixed-template-area narrow-inner">
                                    <div class="part-template-types fixed-template-types flex"></div>
                                    <div class="narrow-contents part-template-list search-template-list fixed-template-list" data-level="all"></div>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" class="template-value-input" id="{$key}-template-input" value="{$template_value}" data-level="{$key}">
                        <input type="hidden" id="{$key}-template-extra-input">
                    </div>
                </div>
EOM;
        }
    }
    return $window;
}

/*
 * 非表示オプション
*/
function option_window_hidden_page( $page_list, $page_type ) {
    //翻訳
    $text_top_page = __( 'TOPページ', 'dg-style' );
    $text_hidden_page_select = __( '非表示ページ選択', 'dg-style' );
    $text_hidden_selected = __( '選択した', 'dg-style' );
    $text_hidden_selected_only = __( 'のみ', 'dg-style' );
    $text_hidden_specify = __( '指定する', 'dg-style' );
    $text_hidden_not_selected_caution = __( '選択ない場合は全部', 'dg-style' );
    $text_hidden_there_is_only = __( 'がある場合のみ', 'dg-style' );
    $text_hidden_specify_the_creator = __( '作成者指定する', 'dg-style' );
    $text_hidden_only_selected_authors = __( '選択した作成者のみ', 'dg-style' );
    $text_hidden_enter_creator_specify = __( '指定する作成者を入力', 'dg-style' );
    $text_hidden_selected_author = __( '選択した「作成者」', 'dg-style' );
    //定義
    $tab_label = '';
    $tab_content = '';
    if ( $page_type === 'site-builder' ) {
        foreach( (array)$page_list as $key => $value ) {
            if ( $key === 'top' ) {
                $tab_label .= '<button type="button" class="tab-label option-menu-label on"><span class="toggle-label">' . $text_top_page . '</span></button>';
                $tab_content .= <<< EOM
                    <div class="tab-content on">
                        <div class="window-title">{$text_hidden_page_select}</div>
                        <div class="check-hidden-page-inner">
                            <input type="checkbox" id="hidden-page-top" class="set-value none-display" value="1" data-level="top">
                            <label class="hidden-page-label" for="hidden-page-top"><span class="name">{$text_top_page}</span></label>
                        </div>
                    </div>
EOM;
            } else {
                if ( $key === 'taxonomy' ) {
                    $label = __( 'カテゴリー種類', 'dg-style' );
                } elseif ( $key === 'custom-post-archive' ) {
                    $label = __( '記事タイプ種類', 'dg-style' );
                } elseif ( $key === 'single' ) {
                    $label = __( '記事種類', 'dg-style' );
                } elseif ( $key === 'other' ) {
                    $label = __( 'その他', 'dg-style' );
                }
                $tab_label .= '<button type="button" class="tab-label option-menu-label"><span class="toggle-label">' . $label . '</span></button>';
                $tab_content .= '<div class="tab-content"><div class="window-title">' . $text_hidden_page_select . '</div>';
                foreach( (array)$value as $slug => $name ) {
                    $tab_content .= <<< EOM
                        <div class="check-hidden-page-inner">
                            <input type="checkbox" id="hidden-page-{$key}-{$slug}" class="set-value none-display" value="1" data-level="{$key}-{$slug}">
                            <label class="hidden-page-label" for="hidden-page-{$key}-{$slug}">
                                <span class="name">{$name}</span>
                            </label>
EOM;
                    if ( $key !== 'custom-post-archive' && $slug !== 'date' && $slug !== 404 && $slug !== 'search' ) {
                        //記事指定
                        if ( $key === 'single' && $slug !== 'page' ) {
                            $tab_content .= '<div class="accordion-area also-accordion-area"><div class="accordion-title also-accordion-title">' . __( '記事指定する', 'dg-style' ) . '</div>';
                        }
                        $type = $slug;
                        if ( $key === 'single' ) {
                            $type = 'post';
                        }
                        $tab_content .= <<< EOM
                            <div class="also-accordion-content check-hidden-content narrow-search-area">
                                <div class="window-title hidden-page-title">{$text_hidden_selected}{$name}{$text_hidden_selected_only}</div>
                                <input type="search" class="narrow-search-post-input" data-type="{$type}" data-page="{$slug}" placeholder="{$text_hidden_specify}{$name}">
                                <div class="narrow-search-result"></div>
                                <div class="narrow-title">{$text_hidden_selected}「{$name}」</div>
                                <div class="narrow-selected-posts"></div>
                                <p class="caution hidden-page-title">※{$text_hidden_not_selected_caution}</p>
                                <input type="hidden" class="set-value narrow-search-value" data-level="{$key}-{$slug}-in" data-type="{$type}" data-page="{$key}-{$slug}">
                            </div>
EOM;
                        if ( $key === 'single' && $slug !== 'page' ) {
                            $tab_content .= '</div>';
                        }
                    }
                    //記事ページの場合、カテゴリーによる非表示追加
                    if ( $key === 'single' && $slug !== 'page' ) {
                        $tab_content .= '<div class="accordion-area also-accordion-area"><div class="accordion-title also-accordion-title">' . __( 'カテゴリー種類で絞る', 'dg-style' ) . '</div>';
                        foreach( (array)$page_list[ 'taxonomy' ] as $tax_slug => $tax_name ) {
                            if ( $tax_slug !== 'date' ) {
                                $tab_content .= <<< EOM
                                    <div class="also-accordion-content check-hidden-content narrow-search-area">
                                        <div class="window-title hidden-page-title">{$text_hidden_selected}{$tax_name}{$text_hidden_there_is_only}</div>
                                        <input type="search" class="narrow-search-post-input" data-type="{$tax_slug}" placeholder="{$text_hidden_specify}{$tax_name}">
                                        <div class="narrow-search-result"></div>
                                        <div class="narrow-title">{$text_hidden_selected}「{$tax_name}」</div>
                                        <div class="narrow-selected-posts"></div>
                                        <p class="caution hidden-page-title">※{$text_hidden_not_selected_caution}</p>
                                        <input type="hidden" class="set-value narrow-search-value" data-level="{$key}-{$slug}-{$tax_slug}-in" data-type="{$tax_slug}" data-page="{$key}-{$slug}">
                                    </div>
EOM;
                            }
                        }
                        $tab_content .= '</div>';
                        //ユーザー指定
                        $tab_content .= <<< EOM
                            <div class="accordion-area also-accordion-area">
                                <div class="accordion-title also-accordion-title">{$text_hidden_specify_the_creator}</div>
                                <div class="also-accordion-content check-hidden-content narrow-search-area">
                                    <div class="window-title hidden-page-title">{$text_hidden_only_selected_authors}</div>
                                    <input type="search" class="narrow-search-post-input" data-type="author" data-page="author" placeholder="{$text_hidden_enter_creator_specify}">
                                    <div class="narrow-search-result"></div>
                                    <div class="narrow-title">{$text_hidden_selected_author}</div>
                                    <div class="narrow-selected-posts"></div>
                                    <p class="caution hidden-page-title">※{$text_hidden_not_selected_caution}</p>
                                    <input type="hidden" class="set-value narrow-search-value" data-level="{$key}-{$slug}-author-in" data-type="author" data-page="{$key}-{$slug}">
                                </div>
                            </div>
EOM;
                    }
                    $tab_content .= '</div>';
                }
                $tab_content .= '</div>';
            }
        }
    }
    
    //翻訳
    $text_hidden_menu_title = __( '非表示設定', 'dg-style' );
    $text_hidden_select_date = __( '日時を設定して表示', 'dg-style' );
    $text_hidden_select_date_caution = __( '指定した日時のみ表示されます。<br>表示エリアは指定したページになります。', 'dg-style' );
    $text_hidden_date_start = __( '開始日時', 'dg-style' );
    $text_hidden_date_end = __( '終了日時', 'dg-style' );
    $text_hidden_label_date = __( 'タイマー', 'dg-style' );
    $text_hidden_label_get = __( 'GETパラメータ', 'dg-style' );
    $text_hidden_get_caution = __( '指定したGETパラメータがある場合の表示方法を設定します。', 'dg-style' );
    return <<< EOM
        <div id="option-part-hidden" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_hidden_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        {$tab_label}
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_hidden_label_date}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_hidden_label_get}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        {$tab_content}
                        <div class="tab-content">
                            <div class="window-title">{$text_hidden_select_date}</div>
                            <p class="caution">※{$text_hidden_select_date_caution}</p>
                            <div class="window-title">{$text_hidden_date_start}</div>
                            <input type="datetime-local" class="set-value" data-level="start">
                            <div class="window-title">{$text_hidden_date_end}</div>
                            <input type="datetime-local" class="set-value" data-level="end">
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_hidden_label_get}</div>
                            <div class="check-hidden-page-inner">
                                <input type="checkbox" id="hidden-page-get-parameter" class="set-value none-display" value="1" data-level="get">
                                <label class="hidden-page-label" for="hidden-page-get-parameter">
                                    <span class="name">{$text_hidden_label_get}</span>
                                </label>
                                <div class="also-accordion-content check-hidden-content get-parameter-area">
                                    <div class="get-parameter-list">
                                        <div class="get-item" data-level="1">
                                            <input type="text" class="get-input name" data-level="name" placeholder="name">
                                            <input type="text" class="get-input value" data-level="value" placeholder="value">
                                            <button type="button" class="get-button add add-get-parameter"></button>
                                            <button type="button" class="get-button delete delete-get-parameter"></button>
                                        </div>
                                    </div>
                                    <p class="caution">※{$text_hidden_get_caution}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * リンク検索
*/
function option_window_search_page_link() {
    //翻訳
    $text_top_page = __( 'TOPページ', 'dg-style' );
    $text_post = __( '記事', 'dg-style' );
    $text_author = __( '作成者', 'dg-style' );
    $text_search = __( 'ページ検索', 'dg-style' );
    //定義
    $tax_labels = '';
    $taxonomise = default_taxonomy_exclusion( array( 'category', 'post_tag' ) );
    foreach( (array)$taxonomise as $tax ) {
        $taxonomy = get_taxonomy( $tax );
        $tax_labels .= '<button type="button" class="narrow-label page-link-label" data-level="' . $tax . '">' . $taxonomy->label . '</button>';
    }
    return <<< EOM
        <div id="search-page-link-window">
            <button type="button" class="page-link-close close-pass"></button>
            <div class="narrow-inner">
                <div class="search-page-link-labels">
                    <button type="button" class="narrow-label page-link-label top-link-label on" data-level="top">{$text_top_page}</button>
                    {$tax_labels}
                    <button type="button" class="narrow-label page-link-label" data-level="post">{$text_post}</button>
                    <button type="button" class="narrow-label page-link-label" data-level="single-lp">LP</button>
                    <button type="button" class="narrow-label page-link-label" data-level="author">{$text_author}</button>
                </div>
                <div class="narrow-contents search-page-link-contents" data-level="top">
                    <div class="window-title">{$text_search}</div>
                    <input type="search" class="link-search-page-input">
                    <div id="search-link-result"></div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * パーツ名変更
*/
function option_window_part_name_edit() {
    $text_area_copy_name = __( 'エリアコピー', 'dg-style' );
    $text_area_copy_title = __( 'コピー先のエリアID入力', 'dg-style' );
    $text_area_copy_enter = __( 'コピーする', 'dg-style' );
    $text_area_copy_cancel = __( 'キャンセル', 'dg-style' );
    return <<< EOM
        <div id="option-part-area-copy" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_area_copy_name}</div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_area_copy_title}</div>
                <p class="add-plug-input-area">
                    <input type="text" id="area-copy-input">
                </p>
                <div class="area-copy-btn-area">
                    <button type="button" id="area-copy-submit" class="area-copy-btn close-pass">{$text_area_copy_enter}</button>
                    <button type="button" id="area-copy-cancel" class="area-copy-btn close-pass">{$text_area_copy_cancel}</button>
                </div>
            </div>
        </div>
EOM;
}

/*
 * パーツタイトル設定
*/
function option_window_part_title() {
    $text_part_title = __( 'パーツタイトル', 'dg-style' );
    $text_title_name = __( 'タイトル名', 'dg-style' );
    $text_inner_tag = __( '内部タグ指定', 'dg-style' );
    $text_inner_tag_select1 = __( 'なし', 'dg-style' );
    $text_inner_tag_select2 = __( '全体をspanで囲む', 'dg-style' );
    $text_inner_tag_select3 = __( '改行ごとにspanで囲む', 'dg-style' );
    $text_tag_title = __( 'タイトルタグ設定', 'dg-style' );
    $text_tag_select = __( 'タグ指定（初期値：h2）', 'dg-style' );
    $text_toggle_btn = __( 'トーグルボタン指定', 'dg-style' );
    $text_toggle_tab1 = __( 'トーグルボタンにしない', 'dg-style' );
    $text_toggle_tab2 = __( 'トーグルボタンにする', 'dg-style' );
    $text_toggle_caution = __( '「open」Classが追加されます。', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-part-title" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_part_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_title_name}</div>
                <textarea class="set-value insert-set-value" data-level="text" rows="2"></textarea>
                <div class="window-title">{$text_inner_tag}</div>
                <select class="set-value insert-set-value" data-level="span">
                    <option value="">{$text_inner_tag_select1}</option>
                    <option value="1">{$text_inner_tag_select2}</option>
                    <option value="2">{$text_inner_tag_select3}</option>
                </select>
                <div class="window-title">{$text_tag_title}</div>
                <select class="set-value insert-set-value" data-level="tag">
                    <option value="">{$text_tag_select}</option>
                    <option value="h1">h1</option>
                    <option value="h2">h2</option>
                    <option value="h3">h3</option>
                    <option value="h4">h4</option>
                    <option value="h5">h5</option>
                    <option value="h6">h6</option>
                    <option value="strong">strong</option>
                    <option value="p">p</option>
                    <option value="div">div</option>
                </select>
                <div class="window-title">{$text_toggle_btn}</div>
                <div class="tab-inner">
                    <div class="tab-list option-labels flex">
                        <label class="tab-label option-label on"><input type="radio" name="part-title-toggle-type" value="1" class="set-value none-display insert-set-value" data-level="toggle-type" checked><span class="toggle-label">{$text_toggle_tab1}</span></label>
                        <label class="tab-label option-label"><input type="radio" name="part-title-toggle-type" value="2" class="set-value none-display insert-set-value" data-level="toggle-type"><span class="toggle-label">{$text_toggle_tab2}</span></label>
                    </div>
                    <div class="tab-contents option-contents">
                        <div class="tab-content on"></div>
                        <div class="tab-content">
                        <p class="caution">※{$text_toggle_caution}</p>
                        </div>
                    </div>
                </div>
                <div class="window-title">{$text_add_class}</div>
                <input type="text" class="set-value insert-set-value" data-level="class">
            </div>
        </div>
EOM;
}

/*
 * スライドショー
*/
function option_window_part_slide( $device_list ) {
    $text_slide_menu_title = __( 'スライド設定', 'dg-style' );
    $text_device_select = __( 'デバイス選択', 'dg-style' );
    $text_device_caution = __( 'デバイスごと別設定の場合は、すべての値を設定してください。', 'dg-style' );
    $text_area_caution = __( 'エリアの場合はオプションの「エリア機能」からスライドショーを選択してから利用できます。', 'dg-style' );
    $text_area_option = __( 'オプションに移動', 'dg-style' );
    $text_menu_slide_on = __( 'スライドで表示', 'dg-style' );
    $text_menu_slide_option = __( 'スライドオプション', 'dg-style' );
    $text_menu_slide_auto = __( '自動スライド', 'dg-style' );
    $text_menu_slide_loop = __( 'ループ', 'dg-style' );
    $text_menu_slide_arrow = __( '矢印ボタン表示', 'dg-style' );
    $text_menu_slide_dot1 = __( 'なし', 'dg-style' );
    $text_menu_slide_dot2 = __( 'ドットボタン', 'dg-style' );
    $text_menu_slide_dot3 = __( 'イメージボタン', 'dg-style' );
    $text_menu_slide_dot_caution1 = __( 'ドットボタンナビゲーションが表示されます。', 'dg-style' );
    $text_menu_slide_dot_caution2 = __( 'スライドイメージと同じイメージのボタンナビゲーションが表示されます。', 'dg-style' );
    $text_menu_slide_type = __( 'スライドタイプ', 'dg-style' );
    $text_menu_slide_type_select1 = __( '横スライド', 'dg-style' );
    $text_menu_slide_type_select2 = __( 'フェイド', 'dg-style' );
    $text_menu_slide_speed = __( 'スライドスピード', 'dg-style' );
    $text_menu_slide_padding = __( '中央表示', 'dg-style' );
    $text_menu_slide_padding_caution = __( '左右に指定値の余白を追加して中央寄せにします。', 'dg-style' );
    $text_menu_slide_show = __( '複数表示', 'dg-style' );
    $text_menu_slide_width = __( '横幅固定', 'dg-style' );
    $text_menu_slide_height = __( '高さ固定', 'dg-style' );
    $text_menu_slide_height_select1 = __( 'なし', 'dg-style' );
    $text_menu_slide_height_select2 = __( 'CSS優先', 'dg-style' );
    $text_menu_slide_height_select3 = __( '高さ指定', 'dg-style' );
    $text_menu_slide_height_caution1 = __( 'CSSで設定した高さを優先します。', 'dg-style' );
    $text_menu_slide_height_caution2 = __( '空欄の場合は高さ固定されません。', 'dg-style' );
    $text_menu_slide_height_caution3 = __( '複数表示を使用中には反映されません。', 'dg-style' );
    return <<< EOM
        <div id="slide-option" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_slide_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_device_select}</div>
                <p class="caution">※{$text_device_caution}</p>
                <div class="site-device-select">
                    {$device_list}
                </div>
                <div class="area-caution-area">
                    <p class="caution">※{$text_area_caution}</p>
                    <button type="button" class="open-part-option-window close-pass">{$text_area_option}</button>
                </div>
                <label class="check-toggle-label slide-display-item"><input type="checkbox" class="set-value slide-set-value slide-display-value" value="1" data-level="display"><span class="check-name">{$text_menu_slide_on}</span><span class="check-button"></span></label>
                <div id="slide-option-menu-area">
                    <div class="window-title">{$text_menu_slide_option}</div>
                    <label class="check-toggle-label"><input type="checkbox" class="set-value slide-set-value" value="1" data-level="auto"><span class="check-name">{$text_menu_slide_auto}</span><span class="check-button"></span></label>
                    <label class="check-toggle-label"><input type="checkbox" class="set-value slide-set-value" value="1" data-level="loop"><span class="check-name">{$text_menu_slide_loop}</span><span class="check-button"></span></label>
                    <label class="check-toggle-label"><input type="checkbox" class="set-value slide-set-value" value="1" data-level="arrow"><span class="check-name">{$text_menu_slide_arrow}</span><span class="check-button"></span></label>
                    <div class="tab-inner">
                        <div class="tab-list option-labels flex">
                            <label class="tab-label option-label on"><input type="radio" name="area-dots-type" value="1" class=" set-value slide-set-value none-display" data-level="dots"><span class="toggle-label">{$text_menu_slide_dot1}</span></label>
                            <label class="tab-label option-label"><input type="radio" name="area-dots-type" value="2" class="set-value slide-set-value none-display" data-level="dots"><span class="toggle-label">{$text_menu_slide_dot2}</span></label>
                            <label class="tab-label option-label"><input type="radio" name="area-dots-type" value="3" class="set-value slide-set-value none-display" data-level="dots"><span class="toggle-label">{$text_menu_slide_dot3}</span></label>
                        </div>
                        <div class="tab-contents option-contents">
                            <div class="tab-content on"></div>
                            <div class="tab-content">
                                <p class="caution">※{$text_menu_slide_dot_caution1}</p>
                            </div>
                            <div class="tab-content">
                                <p class="caution">※{$text_menu_slide_dot_caution2}</p>
                            </div>
                        </div>
                    </div>
                    <div class="window-title">{$text_menu_slide_type}</div>
                    <select class="set-value slide-set-value" data-level="slide-type">
                        <option value="slide">{$text_menu_slide_type_select1}</option>
                        <option value="fade">{$text_menu_slide_type_select2}</option>
                    </select>
                    <div class="window-title">{$text_menu_slide_speed}</div>
                    <input type="number" class="set-value slide-set-value" data-level="speed" placeholder="3000：3sec">
                    <div class="window-title">{$text_menu_slide_padding}</div>
                    <input type="number" class="set-value slide-set-value" data-level="padding" placeholder="50">
                    <p class="caution">※{$text_menu_slide_padding_caution}</p>
                    <div class="window-title">{$text_menu_slide_show}</div>
                    <input type="number" class="set-value slide-set-value" data-level="showslide" placeholder="3">
                    <div class="window-title">{$text_menu_slide_width}</div>
                    <input type="number" class="set-value slide-set-value" data-level="width" placeholder="400">
                    <div class="window-title">{$text_menu_slide_height}</div>
                    <div class="tab-inner">
                        <div class="tab-list option-labels flex">
                            <label class="tab-label option-label on"><input type="radio" name="area-height-type" value="1" class="set-value slide-set-value none-display" data-level="height-type"><span class="toggle-label">{$text_menu_slide_height_select1}</span></label>
                            <label class="tab-label option-label"><input type="radio" name="area-height-type" value="2" class="set-value slide-set-value none-display" data-level="height-type"><span class="toggle-label">{$text_menu_slide_height_select2}</span></label>
                            <label class="tab-label option-label"><input type="radio" name="area-height-type" value="3" class="set-value slide-set-value none-display" data-level="height-type"><span class="toggle-label">{$text_menu_slide_height_select3}</span></label>
                        </div>
                        <div class="tab-contents option-contents">
                            <div class="tab-content on"></div>
                            <div class="tab-content">
                                <p class="caution">※{$text_menu_slide_height_caution1}</p>
                            </div>
                            <div class="tab-content">
                                <p class="caution">※{$text_menu_slide_height_caution2}</p>
                                <p class="caution">※{$text_menu_slide_height_caution3}</p>
                                <input type="number" class="set-value slide-set-value" data-level="height" placeholder="300">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * イベントオプション
*/
function option_window_part_event() {
    $text_event_menu_title = __( 'イベント設定', 'dg-style' );
    $text_event_scroll_tab = __( 'スクロール', 'dg-style' );
    $text_event_css_tab = __( 'CSS連動', 'dg-style' );
    $text_event_cookie_tab = __( 'クッキー', 'dg-style' );
    $text_event_scroll_title = __( 'スクロールイベント', 'dg-style' );
    $text_event_css_title = __( 'CSS連動イベント', 'dg-style' );
    $text_event_cookie_title = __( 'クッキーイベント', 'dg-style' );
    $text_event_repeat = __( 'イベント繰り返し', 'dg-style' );
    $text_event_caution = __( '「,」半角コンマで区切る', 'dg-style' );
    $text_event_target_id_class = __( '指定したパーツIDにもClass追加', 'dg-style' );
    $text_event_add_class = __( 'イベントで追加するClass', 'dg-style' );
    $text_event_default = __( 'デフォルト', 'dg-style' );
    $text_event_example = __( '例）', 'dg-style' );
    $text_event_window_position = __( '画面の位置（指定値）', 'dg-style' );
    $text_event_scroll_vol = __( 'スクロール量指定（指定値）', 'dg-style' );
    $text_event_o_label = __( '要素が画面に入る', 'dg-style' );
    $text_event_ot_label = __( '要素を上から通り過ぎる', 'dg-style' );
    $text_event_od_label = __( '要素を下から通り過ぎる', 'dg-style' );
    $text_event_et_label = __( '要素の上部が画面の上段と一致', 'dg-style' );
    $text_event_eb_label = __( '要素の下部が画面の下段の指定値と一致', 'dg-style' );
    $text_event_wt_label = __( '画面の上から指定値まで動く', 'dg-style' );
    $text_event_wd_label = __( '画面の下から指定値まで動く', 'dg-style' );
    $text_event_rt_label = __( '下移動中、上にする', 'dg-style' );
    $text_event_rd_label = __( '上移動中、下にする', 'dg-style' );
    $text_event_ci_label = __( 'クッキーがある場合', 'dg-style' );
    $text_event_cn_label = __( 'クッキーがない場合', 'dg-style' );
    $text_event_cookie_name = __( 'クッキー名指定', 'dg-style' );
    
    $text_event_ap_label = __( 'ページ全体基準', 'dg-style' );
    $text_event_el_label = __( '現在パーツ基準', 'dg-style' );
    $text_event_se_label = __( '指定パーツ基準', 'dg-style' );
    $text_event_se_taget_id = __( '指定パーツID', 'dg-style' );
    $text_event_se_taget_caution = __( 'パーツ指定は１つのみできます。', 'dg-style' );
    $text_event_css_setting = __( '各CSSごとの設定', 'dg-style' );
    $text_event_css_name= __( 'CSS名', 'dg-style' );
    $text_event_css_start_po = __( '開始位置', 'dg-style' );
    $text_event_css_start_val= __( '開始時のCSS値', 'dg-style' );
    $text_event_css_end_po = __( '終了位置', 'dg-style' );
    $text_event_css_end_val = __( '終了時のCSS値', 'dg-style' );
    
    return <<< EOM
        <div id="event-option" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_event_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_event_scroll_tab}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_event_css_tab}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_event_cookie_tab}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_event_scroll_title}</div>
                            <div class="check-event-inner">
                                <input type="checkbox" id="event-element-over" class="set-value none-display" value="1" data-level="o">
                                <label class="check-event-label check-toggle-label" for="event-element-over">
                                    <span class="check-name">{$text_event_o_label}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="o-p"><span class="check-name">{$text_event_repeat}</span><span class="check-button"></span></label>
                                    <div class="window-title">{$text_event_add_class}</div>
                                    <input type="text" class="set-value" data-level="o-c" placeholder="{$text_event_default}：over">
                                    <div class="window-title">{$text_event_target_id_class}</div>
                                    <div class="toggle-name-input-area">
                                        <input type="text" class="set-value toggle-name-input" data-level="o-o" placeholder="{$text_event_example}header,fooer">
                                    </div>
                                    <p class="caution">※{$text_event_caution}</p>
                                </div>
                            </div>

                            <div class="check-event-inner">
                                <input type="checkbox" id="event-element-over-top" class="set-value none-display" value="1" data-level="ot">
                                <label class="check-event-label check-toggle-label" for="event-element-over-top">
                                    <span class="check-name">{$text_event_ot_label}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="ot-p"><span class="check-name">{$text_event_repeat}</span><span class="check-button"></span></label>
                                    <div class="window-title">{$text_event_add_class}</div>
                                    <input type="text" class="set-value" data-level="ot-c" placeholder="{$text_event_default}：over-top">
                                    <div class="window-title">{$text_event_target_id_class}</div>
                                    <div class="toggle-name-input-area">
                                        <input type="text" class="set-value toggle-name-input" data-level="ot-o" placeholder="{$text_event_example}header,fooer">
                                    </div>
                                    <p class="caution">※{$text_event_caution}</p>
                                </div>
                            </div>

                            <div class="check-event-inner">
                                <input type="checkbox" id="event-element-over-down" class="set-value none-display" value="1" data-level="od">
                                <label class="check-event-label check-toggle-label" for="event-element-over-down">
                                    <span class="check-name">{$text_event_od_label}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="od-p"><span class="check-name">{$text_event_repeat}</span><span class="check-button"></span></label>
                                    <div class="window-title">{$text_event_add_class}</div>
                                    <input type="text" class="set-value" data-level="od-c" placeholder="{$text_event_default}：over-bottom">
                                    <div class="window-title">{$text_event_target_id_class}</div>
                                    <div class="toggle-name-input-area">
                                        <input type="text" class="set-value toggle-name-input" data-level="od-o" placeholder="{$text_event_example}header,fooer">
                                    </div>
                                    <p class="caution">※{$text_event_caution}</p>
                                </div>
                            </div>

                            <div class="check-event-inner">
                                <input type="checkbox" id="event-element-top" class="set-value none-display" value="1" data-level="et">
                                <label class="check-event-label check-toggle-label" for="event-element-top">
                                    <span class="check-name">{$text_event_et_label}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="et-p"><span class="check-name">{$text_event_repeat}</span><span class="check-button"></span></label>
                                    <div class="window-title">{$text_event_window_position}</div>
                                    <input type="number" class="set-value" data-level="et-v" placeholder="0">
                                    <div class="window-title">{$text_event_add_class}</div>
                                    <input type="text" class="set-value" data-level="et-c" placeholder="{$text_event_default}：overlap-top">
                                    <div class="window-title">{$text_event_target_id_class}</div>
                                    <div class="toggle-name-input-area">
                                        <input type="text" class="set-value toggle-name-input" data-level="et-o" placeholder="{$text_event_example}header,fooer">
                                    </div>
                                    <p class="caution">※{$text_event_caution}</p>
                                </div>
                            </div>

                            <div class="check-event-inner">
                                <input type="checkbox" id="event-element-bottom" class="set-value none-display" value="1" data-level="eb">
                                <label class="check-event-label check-toggle-label" for="event-element-bottom">
                                    <span class="check-name">{$text_event_eb_label}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="eb-p"><span class="check-name">{$text_event_repeat}</span><span class="check-button"></span></label>
                                    <div class="window-title">{$text_event_window_position}</div>
                                    <input type="number" class="set-value" data-level="eb-v" placeholder="0">
                                    <div class="window-title">{$text_event_add_class}</div>
                                    <input type="text" class="set-value" data-level="eb-c" placeholder="{$text_event_default}：overlap-bottom">
                                    <div class="window-title">{$text_event_target_id_class}</div>
                                    <div class="toggle-name-input-area">
                                        <input type="text" class="set-value toggle-name-input" data-level="eb-o" placeholder="{$text_event_example}header,fooer">
                                    </div>
                                    <p class="caution">※{$text_event_caution}</p>
                                </div>
                            </div>

                            <div class="check-event-inner">
                                <input type="checkbox" id="event-window-top" class="set-value none-display" value="1" data-level="wt">
                                <label class="check-event-label check-toggle-label" for="event-window-top">
                                    <span class="check-name">{$text_event_wt_label}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="wt-p"><span class="check-name">{$text_event_repeat}</span><span class="check-button"></span></label>
                                    <div class="window-title">{$text_event_scroll_vol}</div>
                                    <input type="number" class="set-value" data-level="wt-v" placeholder="60">
                                    <div class="window-title">{$text_event_add_class}</div>
                                    <input type="text" class="set-value" data-level="wt-c" placeholder="{$text_event_default}：win-top">
                                    <div class="window-title">{$text_event_target_id_class}</div>
                                    <div class="toggle-name-input-area">
                                        <input type="text" class="set-value toggle-name-input" data-level="wt-o" placeholder="{$text_event_example}header,fooer">
                                    </div>
                                    <p class="caution">※{$text_event_caution}</p>
                                </div>
                            </div>

                            <div class="check-event-inner">
                                <input type="checkbox" id="event-window-down" class="set-value none-display" value="1" data-level="wd">
                                <label class="check-event-label check-toggle-label" for="event-window-down">
                                    <span class="check-name">{$text_event_wd_label}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="wd-p"><span class="check-name">{$text_event_repeat}</span><span class="check-button"></span></label>
                                    <div class="window-title">{$text_event_scroll_vol}</div>
                                    <input type="number" class="set-value" data-level="wd-v" placeholder="60">
                                    <div class="window-title">{$text_event_add_class}</div>
                                    <input type="text" class="set-value" data-level="wd-c" placeholder="{$text_event_default}：win-bottom">
                                    <div class="window-title">{$text_event_target_id_class}</div>
                                    <div class="toggle-name-input-area">
                                        <input type="text" class="set-value toggle-name-input" data-level="wd-o" placeholder="{$text_event_example}header,fooer">
                                    </div>
                                    <p class="caution">※{$text_event_caution}</p>
                                </div>
                            </div>

                            <div class="check-event-inner">
                                <input type="checkbox" id="event-reverse-top" class="set-value none-display" value="1" data-level="rt">
                                <label class="check-event-label check-toggle-label" for="event-reverse-top">
                                    <span class="check-name">{$text_event_rt_label}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="rt-p"><span class="check-name">{$text_event_repeat}</span><span class="check-button"></span></label>
                                    <div class="window-title">{$text_event_add_class}</div>
                                    <input type="text" class="set-value" data-level="rt-c" placeholder="{$text_event_default}：reverse-top">
                                    <div class="window-title">{$text_event_target_id_class}</div>
                                    <div class="toggle-name-input-area">
                                        <input type="text" class="set-value toggle-name-input" data-level="rt-o" placeholder="{$text_event_example}header,fooer">
                                    </div>
                                    <p class="caution">※{$text_event_caution}</p>
                                </div>
                            </div>

                            <div class="check-event-inner">
                                <input type="checkbox" id="event-reverse-down" class="set-value none-display" value="1" data-level="rd">
                                <label class="check-event-label check-toggle-label" for="event-reverse-down">
                                    <span class="check-name">{$text_event_rd_label}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="rd-p"><span class="check-name">{$text_event_repeat}</span><span class="check-button"></span></label>
                                    <div class="window-title">{$text_event_add_class}</div>
                                    <input type="text" class="set-value" data-level="rd-c" placeholder="{$text_event_default}：reverse-bottom">
                                    <div class="window-title">{$text_event_target_id_class}</div>
                                    <div class="toggle-name-input-area">
                                        <input type="text" class="set-value toggle-name-input" data-level="rd-o" placeholder="{$text_event_example}header,fooer">
                                    </div>
                                    <p class="caution">※{$text_event_caution}</p>
                                </div>
                            </div>
                            
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_event_css_title}</div>
                            <div class="check-event-inner">
                                <input type="checkbox" id="event-all-page" class="set-value none-display" value="1" data-level="ap">
                                <label class="check-event-label check-toggle-label" for="event-all-page">
                                    <span class="check-name">{$text_event_ap_label}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="ap-p"><span class="check-name">{$text_event_repeat}</span><span class="check-button"></span></label>
                                    <div class="window-title">{$text_event_css_setting}</div>
                                    <div class="css-scroll-event-inner" data-level="ap-v">
                                        <div class="css-event-item" data-level="0">
                                            <button type="button" class="css-event-option add close-pass"></button>
                                            <button type="button" class="css-event-option delete close-pass"></button>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_name}</span>
                                                <input type="text" class="set-value css-event-value" data-level="n" placeholder="font-size">
                                            </div>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_start_po}(%)</span>
                                                <input type="number" class="set-value css-event-value" min="0" max="100" data-level="s" placeholder="0">
                                            </div>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_start_val}</span>
                                                <input type="text" class="set-value css-event-value" data-level="sc" placeholder="10px">
                                            </div>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_end_po}(%)</span>
                                                <input type="number" class="set-value css-event-value" min="0" max="100" data-level="e" placeholder="100">
                                            </div>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_end_val}</span>
                                                <input type="text" class="set-value css-event-value" data-level="ec" placeholder="50px">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="check-event-inner">
                                <input type="checkbox" id="event-select-element" class="set-value none-display" value="1" data-level="el">
                                <label class="check-event-label check-toggle-label" for="event-select-element">
                                    <span class="check-name">{$text_event_el_label}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="el-p"><span class="check-name">{$text_event_repeat}</span><span class="check-button"></span></label>
                                    <div class="window-title">{$text_event_css_setting}</div>
                                    <div class="css-scroll-event-inner" data-level="el-v">
                                        <div class="css-event-item" data-level="0">
                                            <button type="button" class="css-event-option add"></button>
                                            <button type="button" class="css-event-option delete"></button>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_name}</span>
                                                <input type="text" class="set-value css-event-value" data-level="n" placeholder="font-size">
                                            </div>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_start_po}(%)</span>
                                                <input type="number" class="set-value css-event-value" min="0" max="100" data-level="s" placeholder="0">
                                            </div>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_start_val}</span>
                                                <input type="text" class="set-value css-event-value" data-level="sc" placeholder="10px">
                                            </div>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_end_po}(%)</span>
                                                <input type="number" class="set-value css-event-value" min="0" max="100" data-level="e" placeholder="100">
                                            </div>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_end_val}</span>
                                                <input type="text" class="set-value css-event-value" data-level="ec" placeholder="50px">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="check-event-inner">
                                <input type="checkbox" id="event-target-element" class="set-value none-display" value="1" data-level="se">
                                <label class="check-event-label check-toggle-label" for="event-target-element">
                                    <span class="check-name">{$text_event_se_label}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="se-p"><span class="check-name">{$text_event_repeat}</span><span class="check-button"></span></label>
                                    <div class="window-title">{$text_event_se_taget_id}</div>
                                    <div class="toggle-name-input-area">
                                        <input type="text" class="set-value toggle-name-input" data-level="se-t" placeholder="{$text_event_example}header">
                                    </div>
                                    <p class="caution">※{$text_event_se_taget_caution}</p>
                                    <div class="window-title">{$text_event_css_setting}</div>
                                    <div class="css-scroll-event-inner" data-level="se-v">
                                        <div class="css-event-item" data-level="0">
                                            <button type="button" class="css-event-option add"></button>
                                            <button type="button" class="css-event-option delete"></button>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_name}</span>
                                                <input type="text" class="set-value css-event-value" data-level="n" placeholder="font-size">
                                            </div>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_start_po}(%)</span>
                                                <input type="number" class="set-value css-event-value" min="0" max="100" data-level="s" placeholder="0">
                                            </div>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_start_val}</span>
                                                <input type="text" class="set-value css-event-value" data-level="sc" placeholder="10px">
                                            </div>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_end_po}(%)</span>
                                                <input type="number" class="set-value css-event-value" min="0" max="100" data-level="e" placeholder="100">
                                            </div>
                                            <div class="css-event-column">
                                                <span class="css-event-label">{$text_event_css_end_val}</span>
                                                <input type="text" class="set-value css-event-value" data-level="ec" placeholder="50px">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_event_cookie_title}</div>
                            <div class="check-event-inner">
                                <input type="checkbox" id="event-cookie-is" class="set-value none-display" value="1" data-level="ci">
                                <label class="check-event-label check-toggle-label" for="event-cookie-is">
                                    <span class="check-name">{$text_event_ci_label}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <div class="window-title">{$text_event_cookie_name}</div>
                                    <input type="text" class="set-value" data-level="ci-v" placeholder="test-cookie">
                                    <p class="caution">※{$text_event_caution}</p>
                                    <div class="window-title">{$text_event_add_class}</div>
                                    <input type="text" class="set-value" data-level="ci-c" placeholder="{$text_event_default}：reverse-bottom">
                                    <div class="window-title">{$text_event_target_id_class}</div>
                                    <div class="toggle-name-input-area">
                                        <input type="text" class="set-value toggle-name-input" data-level="ci-o" placeholder="{$text_event_example}header,fooer">
                                    </div>
                                    <p class="caution">※{$text_event_caution}</p>
                                </div>
                            </div>
                            
                            <div class="check-event-inner">
                                <input type="checkbox" id="event-cookie-not" class="set-value none-display" value="1" data-level="cn">
                                <label class="check-event-label check-toggle-label" for="event-cookie-not">
                                    <span class="check-name">{$text_event_cn_label}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <div class="window-title">{$text_event_cookie_name}</div>
                                    <input type="text" class="set-value" data-level="cn-v" placeholder="test-cookie">
                                    <p class="caution">※{$text_event_caution}</p>
                                    <div class="window-title">{$text_event_add_class}</div>
                                    <input type="text" class="set-value" data-level="cn-c" placeholder="{$text_event_default}：reverse-bottom">
                                    <div class="window-title">{$text_event_target_id_class}</div>
                                    <div class="toggle-name-input-area">
                                        <input type="text" class="set-value toggle-name-input" data-level="cn-o" placeholder="{$text_event_example}header,fooer">
                                    </div>
                                    <p class="caution">※{$text_event_caution}</p>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * エリア専用オプション
*/
function option_window_area() {
    $text_area_option_title = __( 'エリアオプション', 'dg-style' );
    $text_area_tab_menu1 = __( '基本設定', 'dg-style' );
    $text_area_tab_menu2 = __( 'エリア直下パーツ', 'dg-style' );
    $text_area_tab_menu3 = __( 'エリア機能', 'dg-style' );
    $text_area_tab_menu4 = __( 'サイト内移動設定', 'dg-style' );
    $text_area_class_change = __( 'エリアClass変更', 'dg-style' );
    $text_area_tag_change = __( 'エリアタグ設定', 'dg-style' );
    $text_area_child_caution = __( '非表示中のパーツは上下移動できません。', 'dg-style' );
    $text_area_sys_tab1 = __( '機能なし', 'dg-style' );
    $text_area_sys_tab2 = __( 'タブ式', 'dg-style' );
    $text_area_sys_tab3 = __( 'スライドショー', 'dg-style' );
    $text_area_tab_label = __( 'ラベル名設定', 'dg-style' );
    $text_area_slide_caution = __( 'オプション設定は以下の「スライド設定」ボタンをクリニックしてください。', 'dg-style' );
    $text_area_slide_btn = __( 'スライド設定', 'dg-style' );
    $text_area_scroll_position = __( 'スクロール位置調整', 'dg-style' );
    $text_area_scroll_caution1 = __( '内部アンカーリンクで移動する場合のスクロールの位置を調整できます。', 'dg-style' );
    $text_area_scroll_caution2 = __( '-50の場合、通常より-50px上で止まります。', 'dg-style' );
    $text_area_scroll_speed = __( 'スクロール速度調整', 'dg-style' );
    $text_area_scroll_caution3 = __( '数字が大きいほど早くなります。', 'dg-style' );
    return <<< EOM
        <div id="option-area" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_area_option_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_area_tab_menu1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_area_tab_menu2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_area_tab_menu3}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_area_tab_menu4}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content option-menu-content on">
                            <div class="window-title">{$text_area_class_change}</div>
                            <input type="text" class="set-value area-set-value" data-level="class">
                            <div class="window-title">{$text_area_tag_change}</div>
                            <select class="set-value area-set-value" data-level="tag">
                                <option value="div" selected>div</option>
                                <option value="header">header</option>
                                <option value="footer">footer</option>
                                <option value="main">main</option>
                                <option value="nav">nav</option>
                            </select>
                        </div>
                        <div class="tab-content option-menu-content">
                            <div class="window-title group-area-title">{$text_area_tab_menu2}</div>
                            <div id="group-area-list" class="group-area-list"></div>
                            <p class="caution">※{$text_area_child_caution}</p>
                        </div>
                        <div class="tab-content option-menu-content">
                            <div class="window-title">{$text_area_tab_menu3}</div>
                            <div class="tab-inner">
                                <div class="tab-list option-labels flex">
                                    <label class="tab-label option-label on"><input type="radio" name="area-type" value="1" class="area-set-value set-value none-display" data-level="area-type"><span class="toggle-label">{$text_area_sys_tab1}</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="area-type" value="2" class="area-set-value set-value none-display" data-level="area-type"><span class="toggle-label">{$text_area_sys_tab2}</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="area-type" value="3" class="area-set-value set-value none-display" data-level="area-type"><span class="toggle-label">{$text_area_sys_tab3}</span></label>
                                </div>
                                <div class="tab-contents option-contents">
                                    <div class="tab-content on"></div>
                                    <div class="tab-content">
                                        <div class="window-title">{$text_area_tab_label}</div>
                                        <div id="area-tab-labels" class="area-tab-labels"></div>
                                    </div>
                                    <div class="tab-content">
                                        <p class="caution">※{$text_area_slide_caution}</p>
                                        <button type="button" class="open-slide-setting close-pass">{$text_area_slide_btn}</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-content option-menu-content">
                            <div class="window-title">{$text_area_scroll_position}</div>
                            <input type="number" class="set-value area-set-value area-option-set-value" data-level="move">
                            <p class="caution">※{$text_area_scroll_caution1}<br>※{$text_area_scroll_caution2}</p>
                            <div class="window-title">{$text_area_scroll_speed}</div>
                            <input type="number" class="set-value area-set-value area-option-set-value" data-level="speed" min="1">
                            <p class="caution">※{$text_area_scroll_caution3}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * グローバルメニューオプション
*/
function option_window_gmenu( $item_list = array() ) {
    $admin_url = admin_url( 'nav-menus.php' );
    //メニューリスト
    $nav_menus = wp_get_nav_menus();
    $options = '<option value="">' . __( 'メニューがありません。', 'dg-style' ) . '</option>';
    if ( is_array( $nav_menus ) && count( $nav_menus ) > 0 ) {
        $options = '';
        foreach ( (array) $nav_menus as $menu ) {
            $options .= '<option value="' . $menu->name . '">' . $menu->name . '</option>';
        }
    }
    //翻訳
    $text_menu_title = __( 'グローバルメニュー', 'dg-style' );
    $text_menu_tab1 = __( '基本設定', 'dg-style' );
    $text_menu_tab2 = __( '下層メニュー', 'dg-style' );
    $text_menu_tab3 = __( 'その他', 'dg-style' );
    $text_menu_select_title = __( 'メニュー選択', 'dg-style' );
    $text_menu_select_info = __( 'メニューを選択してください', 'dg-style' );
    $text_menu_add_menu_link = __( 'WPメニュー追加', 'dg-style' );
    $text_menu_reload = __( 'メニュー更新', 'dg-style' );
    $text_menu_sub_title_toggle = __( 'サブタイトル表示', 'dg-style' );
    $text_menu_sub_title_menu1 = __( 'なし', 'dg-style' );
    $text_menu_sub_title_menu2 = __( 'サブタイトル優先', 'dg-style' );
    $text_menu_sub_title_menu3 = __( 'タイトル属性優先', 'dg-style' );
    $text_menu_sub_title_menu4 = __( '両方表示', 'dg-style' );
    $text_menu_sub_title_caution1 = __( 'カテゴリーの「サブタイトル」', 'dg-style' );
    $text_menu_sub_title_caution2 = __( 'メニュー設定の「タイトル属性」', 'dg-style' );
    $text_menu_sub_title_caution3 = __( 'がそれぞれ設定されている場合、', 'dg-style' );
    $text_menu_sub_title_caution4 = __( '「サブタイトル」を優先して表示します。', 'dg-style' );
    $text_menu_sub_title_caution5 = __( '「タイトル属性」を優先して表示します。', 'dg-style' );
    $text_menu_sub_title_caution6 = __( '「サブタイトル」と「タイトル属性」両方表示します。', 'dg-style' );
    $text_menu_child_menu_title = __( '下層メニュー表示', 'dg-style' );
    $text_menu_child_menu_add_btn = __( 'トーグルボタン追加', 'dg-style' );
    $text_menu_child_menu_caution = __( '下層メニューがある場合、「menu-open」Classをトーグルボタンに追加します。', 'dg-style' );
    $text_menu_child_menu_type1 = __( '個別', 'dg-style' );
    $text_menu_child_menu_type2 = __( '連動', 'dg-style' );
    $text_menu_child_menu_type_caution1 = __( '他の兄弟メニューと同時にClassを追加できます。', 'dg-style' );
    $text_menu_child_menu_type_caution2 = __( '他の兄弟メニューがすでにClassがある場合、Classを削除してクリックしたメニューのみ追加します。', 'dg-style' );
    $text_menu_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-gmenu" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_menu_select_title}</div>
                            <select class="set-value gmenu-list-select" data-level="gmenu-type">
                                <option value="">{$text_menu_select_info}</option>
                                {$options}
                            </select>
                            <p class="caution">※<a href="{$admin_url}" target="_blank" id="gmenu-add-page-link">{$text_menu_add_menu_link}</a><br><button type="button" id="gmenu-reload-btn">{$text_menu_reload}</button></p>
                            <div class="window-title">{$text_menu_sub_title_toggle}</div>
                            <div class="tab-inner">
                                <div class="tab-list option-labels four">
                                    <label class="tab-label option-label on"><input type="radio" name="gmenu-sub-title-toggle-type" value="1" class="set-value none-display insert-set-value" data-level="sub"><span class="toggle-label">{$text_menu_sub_title_menu1}</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="gmenu-sub-title-toggle-type" value="2" class="set-value none-display insert-set-value" data-level="sub"><span class="toggle-label">{$text_menu_sub_title_menu2}</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="gmenu-sub-title-toggle-type" value="3" class="set-value none-display insert-set-value" data-level="sub"><span class="toggle-label">{$text_menu_sub_title_menu3}</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="gmenu-sub-title-toggle-type" value="4" class="set-value none-display insert-set-value" data-level="sub"><span class="toggle-label">{$text_menu_sub_title_menu4}</span></label>
                                </div>
                                <div class="tab-contents option-contents">
                                    <div class="tab-content on"></div>
                                    <div class="tab-content">
                                        <p class="caution">※{$text_menu_sub_title_caution1}<br>{$text_menu_sub_title_caution2}<br>{$text_menu_sub_title_caution3}{$text_menu_sub_title_caution4}</p>
                                    </div>
                                    <div class="tab-content">
                                        <p class="caution">※{$text_menu_sub_title_caution1}<br>{$text_menu_sub_title_caution2}<br>{$text_menu_sub_title_caution3}{$text_menu_sub_title_caution5}</p>
                                    </div>
                                    <div class="tab-content">
                                        <p class="caution">※{$text_menu_sub_title_caution6}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_menu_child_menu_title}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="toggle"><span class="check-name">{$text_menu_child_menu_add_btn}</span><span class="check-button"></span></label>
                            <p class="caution">※{$text_menu_child_menu_caution}</p>
                            <div class="tab-inner">
                                <div class="tab-list option-labels flex">
                                    <label class="tab-label option-label on"><input type="radio" name="gmenu-toggle-type" value="1" class="set-value none-display insert-set-value" data-level="toggle-type"><span class="toggle-label">{$text_menu_child_menu_type1}</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="gmenu-toggle-type" value="2" class="set-value none-display insert-set-value" data-level="toggle-type"><span class="toggle-label">{$text_menu_child_menu_type2}</span></label>
                                </div>
                                <div class="tab-contents option-contents">
                                    <div class="tab-content on">
                                        <p class="caution">※{$text_menu_child_menu_type_caution1}</p>
                                    </div>
                                    <div class="tab-content">
                                        <p class="caution">※{$text_menu_child_menu_type_caution2}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_menu_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 記事パーツリスト
*/
function option_windows_post_list_part( $item_list ) {
    //翻訳
    $text_srcset = __( 'srcsetにする', 'dg-style' );
    $text_srcset_caution = __( 'srcsetにする場合、サイズの選択は無効になります。', 'dg-style' );
    $text_example = __( '例）', 'dg-style' );
    $text_evaluate1 = __( 'すごく', 'dg-style' );
    $text_evaluate2 = __( 'いいね', 'dg-style' );
    $text_evaluate3 = __( 'ふつう', 'dg-style' );
    $text_evaluate4 = __( 'あんまり', 'dg-style' );
    $text_evaluate5 = __( 'ぜんぜん', 'dg-style' );
    //定義
    $items = '';
    foreach ( (array)$item_list as $key => $name ) {
        if ( isset( $name[ 'options' ] ) ) {
            $options = '';
            foreach( (array)$name[ 'options' ] as $level => $val ) {
                $class = isset( $val[ 'insert' ] ) ? ' insert-post-option-value' : ' post-option-value';
                $class .= isset( $val[ 'class' ] ) ? ' ' . $val[ 'class' ] : '';
                if ( $level === 'thumbnail-size' ) {
                    $options .= '<div class="window-title">' . $val[ 'title' ] . '</div>';
                    $options .= '<select class="set-value' . $class . '" data-level="' . $level . '">';
                    if ( isset( $val[ 'list' ] ) ) {
                        $list = explode( ',', $val[ 'list' ] );
                        foreach( (array)$list as $option ) {
                            $options .= '<option value="' . $option . '">' . $option . '</option>';
                        }
                    } elseif ( isset( $val[ 'list2' ] ) ) {
                        foreach( (array)$val[ 'list2' ] as $option_key => $option_name ) {
                            $options .= '<option value="' . $option_key . '">' . $option_name . '</option>';
                        }
                    }
                    $options .= '</select>';
                    if ( $key !== 'gravatar' ) {
                        $options .= '<label class="check-toggle-label"><input type="checkbox" class="set-value default-check' . $class . '" value="1" data-level="srcset" checked><span class="check-name">' . $text_srcset . '</span><span class="check-button"></span></label>';
                        $options .= '<p class="caution">※' . $text_srcset_caution . '</p>';
                    }
                } elseif ( $val[ 'type' ] === 'select' ) {
                    $options .= '<div class="window-title">' . $val[ 'title' ] . '</div>';
                    $options .= '<select class="set-value' . $class . '" data-level="' . $level . '">';
                    if ( isset( $val[ 'list' ] ) ) {
                        $list = explode( ',', $val[ 'list' ] );
                        foreach( (array)$list as $option ) {
                            $options .= '<option value="' . $option . '">' . $option . '</option>';
                        }
                    } elseif ( isset( $val[ 'list2' ] ) ) {
                        foreach( (array)$val[ 'list2' ] as $option_key => $option_name ) {
                            $options .= '<option value="' . $option_key . '">' . $option_name . '</option>';
                        }
                    }
                    $options .= '</select>';
                } elseif ( $val[ 'type' ] === 'check' ) {
                    $checked = isset( $val[ 'default' ] ) && $val[ 'default' ] === false ? '' : ' checked';
                    $options .= '<label class="check-toggle-label"><input type="checkbox" class="set-value default-check' . $class . '" value="1" data-level="' . $level . '"' . $checked . '><span class="check-name">' . $val[ 'title' ] . '</span><span class="check-button"></span></label>';
                } elseif ( $val[ 'type' ] === 'caution' ) {
                    $options .= '<div class="caution">' . $val[ 'content' ] . '</div>';
                } elseif ( $val[ 'type' ] === 'unit' ) {
                    $options .= '<div class="window-title">' . $val[ 'title' ] . '</div>';
                    $options .= '<div class="unit-input-area">';
                    $placeholder = isset( $val[ 'text' ][ 'placeholder' ] ) ? ' placeholder="' . $val[ 'text' ][ 'placeholder' ] . '"' : '';
                    $options .= '<input type="' . $val[ 'text' ][ 'type' ] . '" class="set-value' . $class . '" data-level="' . $level . '1"' . $placeholder . '>';
                    if ( isset( $val[ 'select1' ] ) ) {
                        $options .= '<select class="set-value' . $class . '" data-level="' . $level . '2">';
                        foreach( (array)$val[ 'select1' ] as $option_key => $option_name ) {
                            $options .= '<option value="' . $option_key . '">' . $option_name . '</option>';
                        }
                        $options .= '</select>';
                    }
                    if ( isset( $val[ 'select2' ] ) ) {
                        $options .= '<select class="set-value' . $class . '" data-level="' . $level . '3">';
                        foreach( (array)$val[ 'select2' ] as $option_key => $option_name ) {
                            $options .= '<option value="' . $option_key . '">' . $option_name . '</option>';
                        }
                        $options .= '</select>';
                    }
                    $options .= '</div>';
                } elseif ( $val[ 'type' ] === 'size' ) {
                    $options .= <<< EOM
                        <div class="window-title">{$val[ 'title' ]}</div>
                        <div class="movie-range-area">
                            <input type="number" class="set-value insert-post-option-value" data-level="width" placeholder="300">
                            <span class="text">×</span>
                            <input type="number" class="set-value insert-post-option-value" data-level="height" placeholder="300">
                        </div>
EOM;
                } elseif ( $val[ 'type' ] === 'evaluate' ) {
                    $options .= <<< EOM
                        <div class="window-title">{$val[ 'title' ]}</div>
                        <input type="text" class="set-value insert-post-option-value mb10" data-level="very-good" placeholder="{$text_example}{$text_evaluate1}" data-example="{$text_evaluate1}">
                        <input type="text" class="set-value insert-post-option-value mb10" data-level="good" placeholder="{$text_example}{$text_evaluate2}" data-example="{$text_evaluate2}">
                        <input type="text" class="set-value insert-post-option-value mb10" data-level="average" placeholder="{$text_example}{$text_evaluate3}" data-example="{$text_evaluate3}">
                        <input type="text" class="set-value insert-post-option-value mb10" data-level="fair" placeholder="{$text_example}{$text_evaluate4}" data-example="{$text_evaluate4}">
                        <input type="text" class="set-value insert-post-option-value" data-level="poor" placeholder="{$text_example}{$text_evaluate5}" data-example="{$text_evaluate5}">
EOM;
                } else {
                    $options .= '<div class="window-title">' . $val[ 'title' ] . '</div>';
                    $placeholder = isset( $val[ 'placeholder' ] ) ? ' placeholder="' . $val[ 'placeholder' ] . '"' : '';
                    $options .= '<input type="' . $val[ 'type' ] . '" class="set-value' . $class . '" data-level="' . $level . '"' . $placeholder . '>';
                }
            }
            $items .= <<< EOM
                <div class="accordion-area display-item-handle display-part-item" data-slug="{$key}" title="{$name[ 'name' ]}">
                    <div class="accordion-title item-option-title">
                        {$name[ 'name' ]}
                        <div class="option-btns">
                            <button type="button" class="move-up"></button>
                            <button type="button" class="move-down"></button>
                            <button type="button" class="add-part-item"></button>
                            <button type="button" class="delete-part-item"></button>
                        </div>
                    </div>
                    <div class="accordion-content item-option-content">
                        {$options}
                    </div>
                </div>
EOM;
        } else {
            $items .= <<< EOM
                <div class="display-item-handle display-part-item" data-slug="{$key}">
                    <div class="item-option-title">
                        {$name}
                        <div class="option-btns">
                            <button type="button" class="move-up"></button>
                            <button type="button" class="move-down"></button>
                            <button type="button" class="add-part-item"></button>
                            <button type="button" class="delete-part-item"></button>
                        </div>
                    </div>
                </div>
EOM;
        }
    }
    return '<div class="display-sorting-area display-handle-list">' . $items . '</div>';
}

/*
 * 記事リストオプション
*/
function option_window_post_list( $item_list = array() ) {
    //翻訳
    $text_display_post_type = __( '表示する記事タイプ', 'dg-style' );
    $text_user_select = __( 'ユーザー選択', 'dg-style' );
    //記事タイプリスト
    $post_types = get_post_types( array( 'public' => true, ), 'objects' );
    $post_type_list = '';
    foreach ( $post_types as $post_type ) {
        if ( $post_type->name !== 'attachment' ) {
            $post_type_list .= <<< EOM
                <li class="term-item">
                    <div class="term-names">
                        <label class="term-label"><input type="checkbox" class="term-input" value="{$post_type->name}">{$post_type->label}</label>
                    </div>
                </li>
EOM;
        }
    }
    $post_type_select = <<< EOM
        <div class="check-value-inner">
            <div class="window-title">{$text_display_post_type}</div>
            <ul class="parent-taxonomy-area parent-items-area select-terms-post-type" data-tax="post-type">
            {$post_type_list}
            </ul>
            <input type="hidden" class="check-value-summary set-value" data-level="select-post-type">
        </div>
EOM;
    //タクソノミーリスト
    $term_list = get_terms_for_each_taxonomies();
    //ユーザーリスト
    $user_list = '';
    $users = get_users( array( 'orderby' => 'ID','order'=> 'ASC' ) );
    if ( is_array( $users ) && count( $users ) > 0 ) {
        foreach( (array)$users as $user ) {
            $user_list .= <<< EOM
                <li class="term-item">
                    <div class="term-names">
                        <label class="term-label"><input type="checkbox" class="term-input" value="{$user->ID}">{$user->display_name}</label>
                    </div>
                </li>
EOM;
        }
    }
    $user_list_select = <<< EOM
        <div class="check-value-inner">
            <div class="window-title">{$text_user_select}</div>
            <ul class="parent-taxonomy-area parent-items-area select-terms-users" data-tax="users">
            {$user_list}
            </ul>
            <input type="hidden" class="check-value-summary set-value" data-level="select-users">
        </div>
EOM;
    //並び替え
    $order_by_option = '';
    $order_option = '';
    $order_by = array( 'date' => __( '公開日', 'dg-style' ), 'modified' => __( '更新日', 'dg-style' ), 'views' => __( '人気順（全体）', 'dg-style' ), 'w_views' => __( '人気順（週間）', 'dg-style' ), 'm_views' => __( '人気順（月間）', 'dg-style' ), 'y_views' => __( '人気順（年間）', 'dg-style' ), 'evaluate' => __( '評価順', 'dg-style' ), 'bookmark' => __( 'ブックマーク数順', 'dg-style' ), 'comment_count' => __( 'コメント多い順', 'dg-style' ), 'author' => __( '作成者順', 'dg-style' ), 'rand' => __( 'ランダム', 'dg-style' ), 'title' => __( '記事タイトル', 'dg-style' ), );
    $order = array( 'DESC' => __( '降順（最新）', 'dg-style' ), 'ASC' => __( '昇順（古い）', 'dg-style' ), );
    foreach( (array)$order_by as $key => $name ) {
        $order_by_option .= '<option value="' . $key . '">' . $name . '</option>';
    }
    foreach( (array)$order as $key => $name ) {
        $order_option .= '<option value="' . $key . '">' . $name . '</option>';
    }
    $post_item = option_windows_post_list_part( $item_list );
    $area_items = option_post_area_items( $post_item );
    $plug_area = option_plug_area();
    $dynamic_class = option_dynamic_add_class();
    //翻訳
    $text_menu_title = __( '記事リスト', 'dg-style' );
    $text_menu_tab1 = __( '記事表示数', 'dg-style' );
    $text_menu_tab2 = __( '記事絞り込み', 'dg-style' );
    $text_menu_tab3 = __( 'ブックマーク', 'dg-style' );
    $text_menu_tab4 = __( '各項目表示設定', 'dg-style' );
    $text_menu_tab5 = __( '差し込みエリア', 'dg-style' );
    $text_menu_tab6 = __( 'その他', 'dg-style' );
    $text_menu_offset1 = __( '番目から', 'dg-style' );
    $text_menu_offset2 = __( '件表示', 'dg-style' );
    $text_menu_relation = __( '記事絞り込み条件', 'dg-style' );
    $text_menu_relation_or = __( '選択したどれかのカテゴリーに一致', 'dg-style' );
    $text_menu_relation_and = __( '選択したすべてのカテゴリーに一致', 'dg-style' );
    $text_menu_orderby_title = __( '表示順', 'dg-style' );
    $text_menu_more_title = __( 'さらに絞り込みする', 'dg-style' );
    $text_menu_more_keyword = __( 'キーワードで絞る', 'dg-style' );
    $text_menu_more_keyword_caution = __( '入力したキーワードを含む記事を表示', 'dg-style' );
    $text_menu_more_specific_post = __( '特定記事を指定', 'dg-style' );
    $text_menu_more_specific_post1 = __( '指定なし', 'dg-style' );
    $text_menu_more_specific_post2 = __( '指定記事を表示', 'dg-style' );
    $text_menu_more_specific_post3 = __( '指定記事は除外', 'dg-style' );
    $text_menu_more_specific_narrow_info = __( '指定する記事タイトルを入力', 'dg-style' );
    $text_menu_more_specific_narrow_info1 = __( '選択した「記事」', 'dg-style' );
    $text_menu_more_specific_narrow_info2 = __( '除外する記事タイトルを入力', 'dg-style' );
    $text_menu_more_sticky = __( '固定記事表示', 'dg-style' );
    $text_menu_bookmark_toggle = __( 'ブックマーク記事表示', 'dg-style' );
    $text_menu_bookmark_caution1 = __( 'ブックマークに追加した記事のみ表示します。', 'dg-style' );
    $text_menu_bookmark_caution2 = __( '既存の絞り込み条件は無視されます。', 'dg-style' );
    $text_menu_none_post_title = __( '記事がない場合', 'dg-style' );
    $text_menu_none_post_toggle = __( '専用エリアを追加する', 'dg-style' );
    $text_menu_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-post_list" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab4}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab5}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab6}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_menu_tab1}</div>
                            <div class="range-flex">
                                <input type="number" class="set-value" data-level="offset" placeholder="1">
                                <span class="text">{$text_menu_offset1}</span>
                                <input type="number" class="set-value" data-level="post-count" placeholder="5">
                                <span class="text">{$text_menu_offset2}</span>
                            </div>
                        </div>
                        <div class="tab-content">
                            {$post_type_select}
                            {$term_list}
                            <div class="window-title">{$text_menu_relation}</div>
                            <select class="set-value" data-level="relation">
                                <option value="OR">{$text_menu_relation_or}</option>
                                <option value="AND">{$text_menu_relation_and}</option>
                            </select>
                            <div class="window-title">{$text_menu_orderby_title}</div>
                            <div class="post-order-area">
                                <select class="set-value" data-level="order-by">{$order_by_option}</select>
                                <span>で</span>
                                <select class="set-value" data-level="order">{$order_option}</select>
                            </div>
                            <div class="accordion-area also-accordion-area">
                                <div class="accordion-title also-accordion-title">{$text_menu_more_title}</div>
                                <div class="accordion-content also-accordion-content">
                                    {$user_list_select}
                                    <div class="window-title">{$text_menu_more_keyword}</div>
                                    <input type="text" class="set-value" data-level="keywords" placeholder="{$text_menu_more_keyword_caution}">
                                    <div class="window-title">{$text_menu_more_specific_post}</div>
                                    <div class="tab-inner">
                                        <div class="tab-list option-labels flex">
                                            <label class="tab-label option-label on"><input type="radio" name="post_list-in-type" value="1" class="set-value none-display" data-level="inout"><span class="toggle-label">{$text_menu_more_specific_post1}</span></label>
                                            <label class="tab-label option-label"><input type="radio" name="post_list-in-type" value="2" class="set-value none-display" data-level="inout"><span class="toggle-label">{$text_menu_more_specific_post2}</span></label>
                                            <label class="tab-label option-label"><input type="radio" name="post_list-in-type" value="3" class="set-value none-display" data-level="inout"><span class="toggle-label">{$text_menu_more_specific_post3}</span></label>
                                        </div>
                                        <div class="tab-contents option-contents">
                                            <div class="tab-content on"></div>
                                            <div class="tab-content narrow-search-area">
                                                <input type="search" class="narrow-search-post-input" data-type="post" placeholder="{$text_menu_more_specific_narrow_info}">
                                                <div class="narrow-search-result"></div>
                                                <div class="narrow-title">{$text_menu_more_specific_narrow_info1}</div>
                                                <div class="narrow-selected-posts"></div>
                                                <input type="hidden" class="set-value narrow-search-value" data-level="in" data-type="post">
                                            </div>
                                            <div class="tab-content narrow-search-area">
                                                <input type="search" class="narrow-search-post-input" data-type="post" placeholder="{$text_menu_more_specific_narrow_info2}">
                                                <div class="narrow-search-result"></div>
                                                <div class="narrow-title">{$text_menu_more_specific_narrow_info1}</div>
                                                <div class="narrow-selected-posts"></div>
                                                <input type="hidden" class="set-value narrow-search-value" data-level="out" data-type="post">
                                            </div>
                                        </div>
                                    </div>
                                    <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="sticky"><span class="check-name">{$text_menu_more_sticky}</span><span class="check-button"></span></label>
                                </div>
                            </div>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_menu_tab3}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="bookmark"><span class="check-name">{$text_menu_bookmark_toggle}</span><span class="check-button"></span></label>
                            <p class="caution">※{$text_menu_bookmark_caution1}<br>※{$text_menu_bookmark_caution2}</p>
                        </div>
                        <div class="tab-content">
                            {$area_items}
                        </div>
                        <div class="tab-content">
                            {$plug_area}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_menu_none_post_title}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value add-none-post-area" value="1" data-level="none"><span class="check-name">{$text_menu_none_post_toggle}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_menu_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                            {$dynamic_class}
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

function option_post_area_items( $post_item, $type = false, $area_type = 'area' ) {
    $text_menu = __( '各項目表示設定', 'dg-style' );
    $text_area = __( '子エリア追加', 'dg-style' );
    $caution = '';
    if ( $type === 'search' ) {
        $caution = '<p class="caution">※' . __( '検索フォームは、「自由テキスト」以外で複数設定すると正常に動作しない可能性があります。', 'dg-style' ) . '</p>';
    }
    return <<< EOM
        <div class="window-title">{$text_menu}</div>
        {$caution}
        <div class="post-area-inner" data-type="{$area_type}">
            <ul class="post-item-area-list">
                <li class="post-area-item select" data-area="all">
                    <button type="button" class="select-post-part-btn">all</button>
                    <button type="button" class="add-post-part close-pass" title="{$text_area}"></button>
                </li>
            </ul>
            <div class="display-post-items-inner">
                <div class="display-post-items display-sorting-area all on" data-level="all"></div>
            </div>
            {$post_item}
        </div>
EOM;
}
function option_plug_area( $type = false ) {
    $text_menu = __( '差し込みエリア', 'dg-style' );
    $text_area = __( 'エリア追加', 'dg-style' );
    $text_name = __( 'エリア名', 'dg-style' );
    $text_id = __( 'エリアID入力', 'dg-style' );
    $text_class = __( 'クラス名入力(class)', 'dg-style' );
    $text_tag = __( 'エリアタグ設定', 'dg-style' );
    $text_example = __( '例）3番目の記事の後', 'dg-style' );
    
    $caution = '';
    if ( $type === true ) {
        $caution = '<p class="caution">※' . __( 'classやID指定の場合、順番は無視されます。', 'dg-style' ) . '</p>';
        $text_example = __( '例）2番目の見出しの後', 'dg-style' );
    }
    return <<< EOM
        <div class="window-title">{$text_menu}</div>
        {$caution}
        <div class="plug-area-list"></div>
        <div class="window-title">{$text_area}</div>
        <div class="add-plug-area">
            <table class="plug-area-table">
                <tbody>
                    <tr>
                        <th>{$text_name}</th>
                        <td class="add-plug-input-area"><input type="text" data-level="name" class="add-plug-input" placeholder="{$text_example}"></td>
                    </tr>
                    <tr>
                        <th>{$text_id}</th>
                        <td class="add-plug-input-area"><input type="text" data-level="id" class="add-plug-input" placeholder="plug-area"></td>
                    </tr>
                    <tr>
                        <th>{$text_class}</th>
                        <td class="add-plug-input-area"><input type="text" data-level="class" class="add-plug-input" placeholder="plug-inner"></td>
                    </tr>
                    <tr>
                        <th>{$text_tag}</th>
                        <td>
                            <select class="add-plug-input" data-level="tag">
                                <option value="div" selected="">div</option>
                                <option value="section">section</option>
                            </select>
                        </td>
                    </tr>
                </tbody>
            </table>
            <button type="button" class="add-plug-btn">{$text_area}</button>
        </div>
EOM;
}
function option_dynamic_add_class() {
    $text_menu_point_class = __( '単一Class追加', 'dg-style' );
    $text_point_option1 = __( '番目', 'dg-style' );
    $text_point_option2 = __( 'ごと', 'dg-style' );
    $text_caution = __( '指定した順番の要素にclassを追加します。', 'dg-style' );
    return <<< EOM
        <div class="window-title">{$text_menu_point_class}</div>
        <div class="dynamic-class-items">
            <div class="dynamic-class-item">
                <input type="number" class="dynamic-class-input dynamic-class-order" placeholder="1">
                <select class="dynamic-class-input dynamic-class-select">
                    <option value="n">{$text_point_option1}</option>
                    <option value="e">{$text_point_option2}</option>
                </select>
                <input type="text" class="dynamic-class-input dynamic-class-class" placeholder="class">
                <button type="button" class="dynamic-class-move-btn add close-pass"></button>
                <button type="button" class="dynamic-class-move-btn delete close-pass"></button>
            </div>
        </div>
        <p class="caution">※{$text_caution}</p>
EOM;
}

/*
 * 検索フォームオプション
*/
function option_window_search_form( $post_item_list ) {
    //翻訳
    $text_input_name = __( '入力フォーム', 'dg-style' );
    $text_input_text = __( '案内テキスト', 'dg-style' );
    $text_input_placeholder = __( '検索キーワードを入力', 'dg-style' );
    $text_add_class = __( 'class追加', 'dg-style' );
    $text_btn_text = __( 'ボタンテキスト', 'dg-style' );
    $text_submit_name = __( '検索ボタン', 'dg-style' );
    $text_submit_placeholder = __( '検索', 'dg-style' );
    $text_speech_name = __( '音声入力開始ボタン', 'dg-style' );
    $text_speech_placeholder = __( '音声', 'dg-style' );
    $text_speech_caution1 = __( '音声入力機能は「Chrome」ブラウザでしか対応できません。', 'dg-style' );
    $text_speech_caution2 = __( '音声言語がない場合は「日本語」がデフォルトになります。', 'dg-style' );
    $text_lang_name = __( '音声言語', 'dg-style' );
    $text_srange_name = __( '検索範囲', 'dg-style' );
    $text_srange_text = __( '検索範囲選択', 'dg-style' );
    $text_srange_caution1 = __( '「タイトル＋本文」で設定する場合は、追加した検索反映を全部削除してください。', 'dg-style' );
    $text_srange_caution2 = __( '「フォーム表示」以外は「input type="hidden"」で追加されます。', 'dg-style' );
    $text_srange_caution3 = __( '「検索反映選択」で「<strong>選択式</strong>」を選択した場合のみ適用されます。', 'dg-style' );
    $text_free_name = __( '自由テキスト', 'dg-style' );
    $text_category_name = __( 'カテゴリー', 'dg-style' );
    $text_category_display_type = __( '表示方法', 'dg-style' );
    $text_category_display_title = __( 'タイトル表示', 'dg-style' );
    $text_realtime = __( 'リアルタイム検索', 'dg-style' );
    //記事リスト用配列
    $item_list = array(
        'input' => array(
            'name' => $text_input_name,
            'options' => array(
                'text' => array( 'title' => $text_input_text, 'type' => 'text', 'placeholder' => $text_input_placeholder, 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'submit' => array(
            'name' => $text_submit_name,
            'options' => array(
                'text' => array( 'title' => $text_btn_text, 'type' => 'text', 'placeholder' => $text_submit_placeholder, 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'speech' => array(
            'name' => $text_speech_name,
            'options' => array(
                'text' => array( 'title' => $text_btn_text, 'type' => 'text', 'placeholder' => $text_speech_placeholder, 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
                'caution' => array( 'type' => 'caution', 'content' => '※' . $text_speech_caution1, ),
                'caution2' => array( 'type' => 'caution', 'content' => '※' . $text_speech_caution2, ),
            ),
        ),
        'lang' => array(
            'name' => $text_lang_name,
            'options' => array(
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'srange' => array(
            'name' => $text_srange_name,
            'options' => array(
                'type' => array( 'title' => $text_srange_text, 'type' => 'select', 'list2' => array( '1' => __( 'タイトルのみ', 'dg-style' ), '2' => __( '本文のみ', 'dg-style' ), '3' => __( '選択式', 'dg-style' ), ), ),
                'caution' => array( 'type' => 'caution', 'content' => '※' . $text_srange_caution1 . '<br>※' . $text_srange_caution2, ),
                'form' => array( 'title' => '表示方法', 'type' => 'select', 'list2' => array( '1' => __( 'セレクター', 'dg-style' ), '2' => __( 'ラジオボタン', 'dg-style' ), ), ),
                'caution' => array( 'type' => 'caution', 'content' => '※' . $text_srange_caution3, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'free' => array(
            'name' => $text_free_name,
            'options' => array(
                'tag' => array( 'title' => __( 'タグ設定', 'dg-style' ), 'type' => 'select', 'list' => 'h2,h3,h4,h5,h6,strong,div,span,p', 'insert' => true, ),
                'text' => array( 'title' => __( 'テキスト入力', 'dg-style' ), 'type' => 'text', 'placeholder' => __( '自由入力', 'dg-style' ), 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'tax-category' => array(
            'name' => $text_category_name,
            'options' => array(
                'form' => array( 'title' => $text_category_display_type, 'type' => 'select', 'list2' => array( '1' => __( 'セレクター', 'dg-style' ), '2' => __( 'チェックボタン', 'dg-style' ), ), ),
                'title' => array( 'title' => $text_category_display_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'tax-post_tag' => array(
            'name' => 'タグ',
            'options' => array(
                'form' => array( 'title' => $text_category_display_type, 'type' => 'select', 'list2' => array( '1' => __( 'セレクター', 'dg-style' ), '2' => __( 'チェックボタン', 'dg-style' ), ), ),
                'title' => array( 'title' => $text_category_display_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
    );
    $taxonomise = default_taxonomy_exclusion();
    foreach( (array)$taxonomise as $tax ) {
        $taxonomy = get_taxonomy( $tax );
        $item_list[ 'tax-' . $tax ] = array(
            'name' => $taxonomy->label,
            'options' => array(
                'form' => array( 'title' => $text_category_display_type, 'type' => 'select', 'list2' => array( '1' => __( 'セレクター', 'dg-style' ), '2' => __( 'チェックボタン', 'dg-style' ), ), ),
                'title' => array( 'title' => $text_category_display_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        );
    }
    $post_item = option_windows_post_list_part( $item_list );
    $area_items = option_post_area_items( $post_item, 'search' );
    $area_items_real = option_post_area_items( option_windows_post_list_part( $post_item_list ), 'search', 'real' );
    //翻訳
    $text_menu_title = __( '検索フォーム', 'dg-style' );
    $text_menu_tab1 = __( '各項目表示設定', 'dg-style' );
    $text_menu_tab2 = __( 'リアルタイム検索', 'dg-style' );
    $text_menu_tab3 = __( 'リアルタイム検索<br>記事リスト', 'dg-style' );
    $text_menu_tab4 = __( 'その他', 'dg-style' );
    $text_menu_add_class = __( 'Class追加', 'dg-style' );
    $text_realtime = __( 'リアルタイム検索', 'dg-style' );
    $text_realtime_on = __( 'リアルタイム検索を使う', 'dg-style' );
    $text_realtime_cnt = __( 'リアルタイム検索結果表示数', 'dg-style' );
    $text_realtime_none = __( '検索結果がない場合', 'dg-style' );
    return <<< EOM
        <div id="option-search-form" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab4}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">{$area_items}</div>
                        <div class="tab-content">
                            <div class="window-title">{$text_realtime_on}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="realtime"><span class="check-name">{$text_realtime_on}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_realtime_cnt}</div>
                            <input type="number" class="set-value insert-set-value" data-level="realcnt" placeholder="5" min="1">
                            <div class="window-title">{$text_realtime_none}</div>
                            <input type="text" class="set-value insert-set-value" data-level="realnone" placeholder="Not Found">
                        </div>
                        <div class="tab-content">{$area_items_real}</div>
                        <div class="tab-content">
                            <div class="window-title">{$text_menu_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * パンくずリスト
*/
function option_window_breadcrumb( $page_list ) {
    //翻訳
    $text_date_title = __( '日付のタイトル', 'dg-style' );
    $text_date_caution = __( '[year]年で入力時、「2020年」で表示されます。', 'dg-style' );
    $text_list_title = __( 'のタイトル', 'dg-style' );
    $text_search_caution = __( '[keyword]で検索結果<br>「テストで検索結果」で表示されます。', 'dg-style' );
    $text_author_caution = __( '[name]が書いた記事<br>「作成者が書いた記事」で表示されます。', 'dg-style' );
    //定義
    $page_list_option = '';
    foreach( (array)$page_list as $key => $value ) {
        if ( $key !== 'top' ) {
            foreach( (array)$value as $slug => $name ) {
                $placeholder = '[title]';
                if ( $slug === 'search' ) {
                    $placeholder = '[keyword]';
                } elseif ( $slug === 'author' ) {
                    $placeholder = '[name]';
                } elseif ( $slug === 404 ) {
                    $placeholder = __( '自由入力', 'dg-style' );
                }
                if ( $slug === 'date' ) {
                    $page_list_option .= <<< EOM
                        <div class="window-title">{$text_date_title}</div>
                        <input type="text" class="set-value insert-set-value mb10" data-level="taxonomy-year" placeholder="[year]">
                        <input type="text" class="set-value insert-set-value mb10" data-level="taxonomy-monthnum" placeholder="[month]">
                        <input type="text" class="set-value insert-set-value" data-level="taxonomy-day" placeholder="[day]">
                        <p class="caution">※{$text_date_caution}</p>
EOM;
                } else {
                    $page_list_option .= '<div class="window-title">' . $name . $text_list_title . '</div><input type="text" class="set-value insert-set-value" data-level="' . $key . '-'. $slug . '" placeholder="' . $placeholder . '">';
                }
                if ( $slug === 'search' ) {
                    $page_list_option .= '<p class="caution">※' . $text_search_caution . '</p>';
                } elseif ( $slug === 'author' ) {
                    $page_list_option .= '<p class="caution">※' . $text_author_caution . '</p>';
                }
            }
        }
    }
    $site_name = get_bloginfo( 'name' );
    //翻訳
    $text_menu_title = __( 'パンくずリスト', 'dg-style' );
    $text_menu_tab1 = __( '基本設定', 'dg-style' );
    $text_menu_tab2 = __( 'その他', 'dg-style' );
    $text_top_link_text = __( 'TOPリンクテキスト', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-breadcrumb" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_top_link_text}</div>
                            <input type="text" class="set-value insert-set-value" data-level="top" placeholder="{$site_name}">
                            {$page_list_option}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * SNSボタンオプション
*/
function option_window_sns_btn() {
    //翻訳
    $text_display_btn = __( 'の表示', 'dg-style' );
    $text_display_name = __( '表示名設定', 'dg-style' );
    $text_menu_title = __( 'SNSボタン', 'dg-style' );
    $text_select_title = __( '表示するボタン選択', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    //定義
    $check_list = '';
    $sns_list = array(
        'facebook' => '1',
        'twitter' => '1',
        'line' => '1',
        'pocket' => '1',
        'tumblr' => '1',
        'hatebu' => '1',
        'pinterest' => '1',
    );
    foreach( (array)$sns_list as $key => $val ) {
        $check_list .= <<< EOM
            <div class="check-event-inner">
                <input type="checkbox" id="sns-option-display-{$key}" class="set-value none-display insert-set-value default-check" value="1" data-level="{$key}" checked>
                <label class="check-event-label check-toggle-label" for="sns-option-display-{$key}">
                    <span class="check-name">{$key}{$text_display_btn}</span><span class="check-button"></span>
                </label>
                <div class="check-event-content">
                    <div class="window-title">{$text_display_name}</div>
                    <input type="text" class="set-value insert-set-value" data-level="{$key}n">
                </div>
            </div>
EOM;
    }
    return <<< EOM
        <div id="option-sns" class="part-menu-window add-part-window insert-part-area">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_select_title}</div>
                <div class="sns-check-list">
                    {$check_list}
                </div>
                <div class="window-title">{$text_add_class}</div>
                <input type="text" class="set-value insert-set-value" data-level="part-class">
            </div>
        </div>
EOM;
}

/*
 * 記事コンテンツ
*/
function option_window_post_content() {
    $text_menu_title = __( '記事コンテンツ', 'dg-style' );
    $text_select_title = __( '記事選択', 'dg-style' );
    $text_narrow_placeholder = __( '指定する記事タイトルを入力', 'dg-style' );
    $text_selected_post = __( '選択した「記事」', 'dg-style' );
    $text_post_caution = __( '暗号化されたページも本文が表示されます。', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    $dynamic_class = option_dynamic_add_class();
    return <<< EOM
        <div id="option-post-content" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_select_title}</div>
                <div class="narrow-search-area">
                    <input type="search" class="narrow-search-post-input" data-type="post" placeholder="{$text_narrow_placeholder}">
                    <div class="narrow-search-result"></div>
                    <div class="narrow-title">{$text_selected_post}</div>
                    <div class="narrow-selected-posts"></div>
                    <input type="hidden" class="set-value narrow-search-value" data-level="ids" data-type="post">
                </div>
                <p class="caution">※{$text_post_caution}</p>
                <div class="window-title">{$text_add_class}</div>
                <input type="text" class="set-value insert-set-value" data-level="part-class">
                {$dynamic_class}
            </div>
        </div>
EOM;
}

/*
 * お問い合わせ
*/
function option_window_contact() {
    $text_menu_title = __( 'お問い合わせフォーム', 'dg-style' );
    $text_select_title = __( 'お問い合わせ選択', 'dg-style' );
    $text_narrow_placeholder = __( '指定するお問い合わせタイトルを入力', 'dg-style' );
    $text_selected_post = __( '選択した「お問い合わせ」', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-contact" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_select_title}</div>
                <div class="narrow-search-area">
                    <input type="search" class="narrow-search-post-input" data-type="post" data-page="dg_contact" data-limit="1" placeholder="{$text_narrow_placeholder}">
                    <div class="narrow-search-result"></div>
                    <div class="narrow-title">{$text_selected_post}</div>
                    <div class="narrow-selected-posts"></div>
                    <input type="hidden" class="set-value narrow-search-value" data-level="id" data-type="post">
                </div>
                <div class="window-title">{$text_add_class}</div>
                <input type="text" class="set-value insert-set-value" data-level="part-class">
            </div>
        </div>
EOM;
}

/*
 * タクソノミータイトル
*/
function option_window_taxonomy_title( $page_list ) {
    //翻訳
    $text_date_caution = __( '[year:年][month:月][day:日]で入力時<br>「2020年8月18日」で表示されます。', 'dg-style' );
    $text_search_caution = __( '[keyword]で検索結果<br>「テストで検索結果」で表示されます。', 'dg-style' );
    $text_author_caution = __( '[name]が書いた記事<br>「作成者が書いた記事」で表示されます。', 'dg-style' );
    //定義
    $page_list_option = '';
    foreach( (array)$page_list as $key => $value ) {
        if ( $key !== 'top' && $key !== 'single' ) {
            foreach( (array)$value as $slug => $name ) {
                if ( $slug !== 404 ) {
                    $placeholder = '[title]';
                    if ( $slug === 'date' ) {
                        $placeholder = __( '[year:年][month:月][day:日]', 'dg-style' );
                    } elseif ( $slug === 'search' ) {
                        $placeholder = '[keyword]';
                    } elseif ( $slug === 'author' ) {
                        $placeholder = '[name]';
                    }
                    $page_list_option .= '<div class="window-title">' . $name . 'のタイトル</div><input type="text" class="set-value insert-set-value" data-level="' . $key . '-'. $slug . '" placeholder="' . $placeholder . '">';
                    if ( $slug === 'date' ) {
                        $page_list_option .= '<p class="caution">※' . $text_date_caution . '</p>';
                    } elseif ( $slug === 'search' ) {
                        $page_list_option .= '<p class="caution">※' . $text_search_caution . '</p>';
                    } elseif ( $slug === 'author' ) {
                        $page_list_option .= '<p class="caution">※' . $text_author_caution . '</p>';
                    }
                }
            }
        }
    }
    
    //表示アイテム
    $text_part_add_class = __( 'class指定', 'dg-style' );
    $text_part_notag = __( 'タグなし', 'dg-style' );
    $text_part_notag_caution = __( 'タグなしの場合は、classは適用されません。', 'dg-style' );
    $item_list = array(
        'title' => array(
            'name' => __( 'タイトル', 'dg-style' ),
            'options' => array(
                'tag' => array( 'title' => __( 'タグ設定', 'dg-style' ), 'type' => 'select', 'list2' => array( 'none' => $text_part_notag, 'div' => 'div', 'strong' => 'strong', 'span' => 'span', ), 'insert' => true, ),
                'caution' => array( 'type' => 'caution', 'content' => '※' . $text_part_notag_caution, ),
                'class' => array( 'title' => $text_part_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'sub' => array(
            'name' => __( 'サブタイトル', 'dg-style' ),
            'options' => array(
                'tag' => array( 'title' => __( 'タグ設定', 'dg-style' ), 'type' => 'select', 'list2' => array( 'none' => $text_part_notag, 'div' => 'div', 'strong' => 'strong', 'span' => 'span', ), 'insert' => true, ),
                'caution' => array( 'type' => 'caution', 'content' => '※' . $text_part_notag_caution, ),
                'class' => array( 'title' => $text_part_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'free' => array(
            'name' => __( '自由テキスト', 'dg-style' ),
            'options' => array(
                'text' => array( 'title' => __( 'テキスト入力', 'dg-style' ), 'type' => 'text', 'placeholder' => 'from', 'insert' => true, ),
                'tag' => array( 'title' => __( 'タグ設定', 'dg-style' ), 'type' => 'select', 'list2' => array( 'none' => $text_part_notag, 'div' => 'div', 'strong' => 'strong', 'span' => 'span', ), 'insert' => true, ),
                'caution' => array( 'type' => 'caution', 'content' => '※' . $text_part_notag_caution, ),
                'class' => array( 'title' => $text_part_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
    );
    $display_area = option_windows_post_list_part( $item_list );
    $area_items = option_post_area_items( $display_area );
    //翻訳
    $text_menu_title = __( '記事一覧タイトル', 'dg-style' );
    $text_menu_tab1 = __( '各項目表示設定', 'dg-style' );
    $text_menu_tab2 = __( 'タイトル置換', 'dg-style' );
    $text_menu_tab3 = __( 'その他', 'dg-style' );
    $text_top_page_title = __( 'TOPページのタイトル', 'dg-style' );
    $text_free_text = __( '自由入力', 'dg-style' );
    $text_404_page_title = __( '404ページのタイトル', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    $text_tag_title = __( 'タグ選択', 'dg-style' );
    return <<< EOM
        <div id="option-taxonomy-title" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            {$area_items}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_top_page_title}</div>
                            <input type="text" class="set-value insert-set-value" data-level="top" placeholder="{$text_free_text}">
                            <p class="caution">※{$text_free_text}</p>
                            {$page_list_option}
                            <div class="window-title">{$text_404_page_title}</div>
                            <input type="text" class="set-value insert-set-value" data-level="404" placeholder="{$text_free_text}">
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                            <div class="window-title">{$text_tag_title}</div>
                            <select class="set-value insert-set-value" data-level="tag">
                                <option value="h1">h1</option>
                                <option value="h2">h2</option>
                                <option value="h3">h3</option>
                                <option value="h4">h4</option>
                                <option value="h5">h5</option>
                                <option value="h6">h6</option>
                                <option value="strong">strong</option>
                                <option value="p">p</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * タクソノミー説明文
*/
function option_window_taxonomy_description() {
    $text_menu_title = __( '一覧ページ説明文', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-taxonomy-description" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_add_class}</div>
                <input type="text" class="set-value insert-set-value" data-level="part-class">
            </div>
        </div>
EOM;
}

/*
 * タクソノミーサムネイル
*/
function option_window_taxonomy_thumbnail() {
    $text_menu_title = __( '記事一覧サムネイル', 'dg-style' );
    $text_thumb_size = __( 'サムネイルサイズ', 'dg-style' );
    $text_srcset = __( 'srcsetにする', 'dg-style' );
    $text_srcset_caution = __( 'srcsetにする場合、サイズの選択は無効になります。', 'dg-style' );
    $text_thumb_fixed = __( '固定サムネイル表示', 'dg-style' );
    $text_thumb_fixed_menu1 = __( '表示しない', 'dg-style' );
    $text_thumb_fixed_menu2 = __( '常に固定サムネイル表示', 'dg-style' );
    $text_thumb_fixed_menu3 = __( 'サムネイルがない場合(No-imageより優先)', 'dg-style' );
    $text_noimage_title = __( 'イメージがない場合の表示設定', 'dg-style' );
    $text_noimage_label = __( 'No-imageを表示する', 'dg-style' );
    $text_author_page_title = __( '作成者ページの場合表示イメージ', 'dg-style' );
    $text_author_page_image1 = __( '背景イメージ', 'dg-style' );
    $text_author_page_image2 = __( 'ユーザーイメージ', 'dg-style' );
    $text_image_tag_size = __( 'イメージタグサイズ', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-taxonomy-thumbnail" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_thumb_size}</div>
                <select class="set-value insert-set-value" data-level="size">
                    <option value="thumbnail">thumbnail</option>
                    <option value="medium">medium</option>
                    <option value="large">large</option>
                    <option value="full">full</option>
                </select>
                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="srcset"><span class="check-name">{$text_srcset}</span><span class="check-button"></span></label>
                <p class="caution">※{$text_srcset_caution}</p>
                <div class="window-title">{$text_thumb_fixed}</div>
                <select class="set-value insert-set-value" data-level="fixed">
                    <option value="">{$text_thumb_fixed_menu1}</option>
                    <option value="1">{$text_thumb_fixed_menu2}</option>
                    <option value="2">{$text_thumb_fixed_menu3}</option>
                </select>
                <div class="window-title">{$text_noimage_title}</div>
                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value default-check" value="1" data-level="none" checked><span class="check-name">{$text_noimage_label}</span><span class="check-button"></span></label>
                <div class="window-title">{$text_author_page_title}</div>
                <select class="set-value" data-level="user">
                    <option value="1">{$text_author_page_image1}</option>
                    <option value="2">{$text_author_page_image2}</option>
                </select>
                <div class="window-title">{$text_image_tag_size}</div>
                <div class="movie-range-area">
                    <input type="number" class="set-value insert-set-value" data-level="width" placeholder="300">
                    <span class="text">×</span>
                    <input type="number" class="set-value insert-set-value" data-level="height" placeholder="300">
                </div>
                <div class="window-title">{$text_add_class}</div>
                <input type="text" class="set-value insert-set-value" data-level="part-class">
            </div>
        </div>
EOM;
}

/*
 * タクソノミー動画サムネイル
*/
function option_window_taxonomy_movie() {
    $text_menu_title = __( '記事一覧動画サムネイル', 'dg-style' );
    $text_menu_tab1 = __( '動画オプション', 'dg-style' );
    $text_menu_tab2 = __( '動画サムネイル', 'dg-style' );
    $text_menu_tab3 = __( 'その他', 'dg-style' );
    $text_movie_auto = __( '自動再生', 'dg-style' );
    $text_movie_repeat = __( '繰り返し再生', 'dg-style' );
    $text_movie_controls = __( 'インターフェース表示', 'dg-style' );
    $text_movie_mute = __( '消音', 'dg-style' );
    $text_movie_preload = __( 'preload設定', 'dg-style' );
    $text_thumb_display = __( '動画サムネイルを表示', 'dg-style' );
    $text_thumb_caution1 = __( 'サムネイルイメージが使われます。', 'dg-style' );
    $text_thumb_caution2 = __( 'iframeの場合は反映されません。', 'dg-style' );
    $text_thumb_none = __( '動画がない場合', 'dg-style' );
    $text_thumb_only = __( 'サムネイルのみ表示', 'dg-style' );
    $text_thumb_size = __( '動画サムネイルサイズ', 'dg-style' );
    $text_srcset = __( 'srcsetにする', 'dg-style' );
    $text_srcset_caution = __( 'srcsetにする場合、サイズの選択は無効になります。', 'dg-style' );
    $text_image_tag_size = __( 'イメージタグサイズ', 'dg-style' );
    $text_author_page_image = __( '作成者ページの場合動画サムネイルイメージ', 'dg-style' );
    $text_author_page_image1 = __( '背景イメージ', 'dg-style' );
    $text_author_page_image2 = __( 'ユーザーイメージ', 'dg-style' );
    $text_aadd_class = __( 'Class追加', 'dg-style' );
    
    return <<< EOM
        <div id="option-taxonomy-movie" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_menu_tab1}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="autoplay"><span class="check-name">{$text_movie_auto}</span><span class="check-button"></span></label>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="loop"><span class="check-name">{$text_movie_repeat}</span><span class="check-button"></span></label>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="controls"><span class="check-name">{$text_movie_controls}</span><span class="check-button"></span></label>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="muted"><span class="check-name">{$text_movie_mute}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_movie_preload}</div>
                            <select class="set-value insert-set-value" data-level="preload">
                                <option value="">auto</option>
                                <option value="1">metadata</option>
                                <option value="2">none</option>
                            </select>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_menu_tab2}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value default-check" value="1" data-level="thumb" checked><span class="check-name">{$text_thumb_display}</span><span class="check-button"></span></label>
                            <p class="caution">※{$text_thumb_caution1}<br>※{$text_thumb_caution2}</p>
                            <div class="window-title">{$text_thumb_none}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value default-check" value="1" data-level="none" checked><span class="check-name">{$text_thumb_only}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_thumb_size}</div>
                            <select class="set-value insert-set-value" data-level="size">
                                <option value="thumbnail">thumbnail</option>
                                <option value="medium">medium</option>
                                <option value="large">large</option>
                                <option value="full">full</option>
                            </select>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="srcset"><span class="check-name">{$text_srcset}</span><span class="check-button"></span></label>
                            <p class="caution">※{$text_srcset_caution}</p>
                            <div class="window-title">{$text_image_tag_size}</div>
                            <div class="movie-range-area">
                                <input type="number" class="set-value insert-set-value" data-level="width" placeholder="300">
                                <span class="text">×</span>
                                <input type="number" class="set-value insert-set-value" data-level="height" placeholder="300">
                            </div>
                            <div class="window-title">{$text_author_page_image}</div>
                            <select class="set-value" data-level="user">
                                <option value="1">{$text_author_page_image1}</option>
                                <option value="2">{$text_author_page_image2}</option>
                            </select>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_aadd_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * タクソノミー兄弟ターム
*/
function option_window_taxonomy_brother() {
    $term_list = get_terms_for_each_taxonomies();
    $dynamic_class = option_dynamic_add_class();
    //翻訳
    $text_menu_title = __( '記事一覧兄弟タクソノミー', 'dg-style' );
    $text_menu_tab1 = __( '表示絞り込み', 'dg-style' );
    $text_menu_tab2 = __( '表示方法', 'dg-style' );
    $text_menu_tab3 = __( 'その他', 'dg-style' );
    $text_menu_caution1 = __( '選択したカテゴリーが親カテゴリーの場合の兄弟カテゴリーが表示されます。', 'dg-style' );
    $text_menu_caution2 = __( '登録記事がないカテゴリーは表示されません。', 'dg-style' );
    $text_menu_caution3 = __( '選択されてない場合は、すべての一覧ページに適用されます。', 'dg-style' );
    $text_link_list = __( 'リンクリスト', 'dg-style' );
    $text_selector = __( 'セレクター', 'dg-style' );
    $text_post_count = __( '記事数表示', 'dg-style' );
    $text_post_count_toggle = __( '記事数を表示する', 'dg-style' );
    $text_parent_title = __( '親タクソノミー表示', 'dg-style' );
    $text_parent_toggle = __( '親タクソノミーを表示する', 'dg-style' );
    $text_parent_name_title = __( '親タクソノミー名を変更', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    
    return <<< EOM
        <div id="option-taxonomy-brother" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_menu_tab1}</div>
                            {$term_list}
                            <p class="caution">※{$text_menu_caution1}</p>
                            <p class="caution">※$text_menu_caution2</p>
                            <p class="caution">※{$text_menu_caution3}</p>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_menu_tab2}</div>
                            <select class="set-value insert-set-value" data-level="type">
                                <option value="1">{$text_link_list}</option>
                                <option value="2">{$text_selector}</option>
                            </select>
                            <div class="window-title">{$text_post_count}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="count"><span class="check-name">{$text_post_count_toggle}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_parent_title}</div>
                            <div class="check-event-inner">
                                <input type="checkbox" id="taxonomy-brother-parent-display" class="set-value none-display insert-set-value default-check" value="1" data-level="p" checked>
                                <label class="check-event-label check-toggle-label" for="taxonomy-brother-parent-display">
                                    <span class="check-name">{$text_parent_toggle}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <div class="window-title">{$text_parent_name_title}</div>
                                    <input type="text" class="set-value insert-set-value" data-level="pn" placeholder="all">
                                </div>
                            </div>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                            {$dynamic_class}
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * タクソノミー子ターム
*/
function option_window_taxonomy_child() {
    $term_list = get_terms_for_each_taxonomies();
    $dynamic_class = option_dynamic_add_class();
    //翻訳
    $text_menu_title = __( '記事一覧子タクソノミー', 'dg-style' );
    $text_menu_tab1 = __( '表示絞り込み', 'dg-style' );
    $text_menu_tab2 = __( '表示方法', 'dg-style' );
    $text_menu_tab3 = __( 'その他', 'dg-style' );
    $text_menu_caution1 = __( '選択されてない場合は、すべての一覧ページに適用されます。', 'dg-style' );
    $text_menu_caution2 = __( '登録記事がないカテゴリーは表示されません。', 'dg-style' );
    $text_link_list = __( 'リンクリスト', 'dg-style' );
    $text_selector = __( 'セレクター', 'dg-style' );
    $text_post_count = __( '記事数表示', 'dg-style' );
    $text_post_count_toggle = __( '記事数を表示する', 'dg-style' );
    $text_this_title = __( '現在タクソノミー表示', 'dg-style' );
    $text_this_toggle = __( '現在タクソノミーを表示する', 'dg-style' );
    $text_this_name_title = __( '現在タクソノミー名を変更', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    
    return <<< EOM
        <div id="option-taxonomy-child" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_menu_tab1}</div>
                            {$term_list}
                            <p class="caution">※{$text_menu_caution1}</p>
                            <p class="caution">※{$text_menu_caution2}</p>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_menu_tab2}</div>
                            <select class="set-value insert-set-value" data-level="type">
                                <option value="1">{$text_link_list}</option>
                                <option value="2">{$text_selector}</option>
                            </select>
                            <div class="window-title">{$text_post_count}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="count"><span class="check-name">{$text_post_count_toggle}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_this_title}</div>
                            <div class="check-event-inner">
                                <input type="checkbox" id="taxonomy-child-parent-display" class="set-value none-display insert-set-value default-check" value="1" data-level="p" checked>
                                <label class="check-event-label check-toggle-label" for="taxonomy-child-parent-display">
                                    <span class="check-name">{$text_this_toggle}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <div class="window-title">{$text_this_name_title}</div>
                                    <input type="text" class="set-value insert-set-value" data-level="pn" placeholder="all">
                                </div>
                            </div>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                            {$dynamic_class}
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * タクソノミータイトル
*/
function option_window_taxonomy_page_count() {
    //表示アイテム
    $text_item_add_class = __( 'class指定', 'dg-style' );
    $item_list = array(
        'from' => array(
            'name' => __( '現ページ記事の最初カウント', 'dg-style' ),
            'options' => array(
                'class' => array( 'title' => $text_item_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'until' => array(
            'name' => __( '現ページ記事の最後カウント', 'dg-style' ),
            'options' => array(
                'class' => array( 'title' => $text_item_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'total' => array(
            'name' => __( 'すべての記事数', 'dg-style' ),
            'options' => array(
                'class' => array( 'title' => $text_item_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'page' => array(
            'name' => __( '現ページ番号', 'dg-style' ),
            'options' => array(
                'class' => array( 'title' => $text_item_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'free' => array(
            'name' => __( '自由テキスト', 'dg-style' ),
            'options' => array(
                'text' => array( 'title' => __( 'テキスト入力', 'dg-style' ), 'type' => 'text', 'placeholder' => 'from', 'insert' => true, ),
                'class' => array( 'title' => $text_item_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
    );
    $display_area = option_windows_post_list_part( $item_list );
    $area_items = option_post_area_items( $display_area );
    //翻訳
    $text_menu_title = __( '一覧ページ記事数カウント', 'dg-style' );
    $text_menu_tab1 = __( '各項目表示設定', 'dg-style' );
    $text_menu_tab2 = __( 'その他', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-taxonomy-page_count" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            {$area_items}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 一覧ページ記事リストオプション
*/
function option_window_taxonomy_post_list( $item_list = array() ) {
    $post_item = option_windows_post_list_part( $item_list );
    $area_items = option_post_area_items( $post_item );
    $plug_area = option_plug_area();
    $dynamic_class = option_dynamic_add_class();
    $admin_url = admin_url( 'options-reading.php' );
    $posts_per_page = (int)get_option( 'posts_per_page' );
    $range_option = '<option value="">' . __( '範囲指定', 'dg-style' ) . '</option>';
    for( $i = 1; $i <= $posts_per_page; ++$i ) {
        $range_option .= '<option value="' . $i . '">' . $i . __( '番目', 'dg-style' ) . '</option>';
    }
    //翻訳
    $text_menu_title = __( '一覧ページ記事リスト', 'dg-style' );
    $text_menu_tab1 = __( '記事表示反映', 'dg-style' );
    $text_menu_tab2 = __( '各項目表示設定', 'dg-style' );
    $text_menu_tab3 = __( '差し込みエリア', 'dg-style' );
    $text_menu_tab4 = __( 'その他', 'dg-style' );
    $text_offset_start = __( 'から', 'dg-style' );
    $text_offset_end = __( 'まで', 'dg-style' );
    $text_menu_none_post_title = __( '記事がない場合', 'dg-style' );
    $text_menu_none_post_toggle = __( '専用エリアを追加する', 'dg-style' );
    $text_menu_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-taxonomy-post_list" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab4}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_menu_tab1}</div>
                            <div class="range-flex">
                                <select class="set-value" data-level="start">{$range_option}</select>
                                <span class="text">{$text_offset_start}</span>
                                <select class="set-value" data-level="end">{$range_option}</select>
                                <span class="text">{$text_offset_end}</span>
                            </div>
                        </div>
                        <div class="tab-content">
                            {$area_items}
                        </div>
                        <div class="tab-content">
                            {$plug_area}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_menu_none_post_title}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value add-none-post-area" value="1" data-level="none"><span class="check-name">{$text_menu_none_post_toggle}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_menu_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                            {$dynamic_class}
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 一覧ページページングオプション
*/
function option_window_taxonomy_sort() {
    $order_by = array( 'date' => __( '公開日', 'dg-style' ), 'modified' => __( '更新日', 'dg-style' ), 'views' => __( '人気順（全体）', 'dg-style' ), 'w_views' => __( '人気順（週間）', 'dg-style' ), 'm_views' => __( '人気順（月間）', 'dg-style' ), 'y_views' => __( '人気順（年間）', 'dg-style' ), 'evaluate' => __( '評価順', 'dg-style' ), 'bookmark' => __( 'ブックマーク数順', 'dg-style' ), 'comment_count' => __( 'コメント多い順', 'dg-style' ), 'author' => __( '作成者順', 'dg-style' ), 'rand' => __( 'ランダム', 'dg-style' ), 'title' => __( '記事タイトル', 'dg-style' ), );
    $order_list = '';
    foreach( (array)$order_by as $key => $name ) {
        $order_list .= '<label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value default-check" value="1" data-level="' . $key . '" checked><span class="check-name">' . $name . '</span><span class="check-button"></span></label>';
    }
    //翻訳
    $text_menu_title = __( '一覧ページ並び替え', 'dg-style' );
    $text_menu_tab1 = __( '並び替え基準', 'dg-style' );
    $text_menu_tab2 = __( '並び替え順番', 'dg-style' );
    $text_menu_tab3 = __( '記事件数', 'dg-style' );
    $text_menu_tab4 = __( 'その他', 'dg-style' );
    $text_orderby_toggle = __( '並び替え基準表示', 'dg-style' );
    $text_orderby_title = __( '並び替え基準タイトル', 'dg-style' );
    $text_orderby_list = __( '並び替え基準', 'dg-style' );
    $text_orderby_type = __( '並び替え基準表示方法', 'dg-style' );
    $text_orderby_select1 = __( 'セレクトボックス', 'dg-style' );
    $text_orderby_select2 = __( 'ラジオボタン', 'dg-style' );
    $text_order_toggle = __( '並び替え順番表示', 'dg-style' );
    $text_order_title = __( '並び替え順番タイトル', 'dg-style' );
    $text_order_type = __( '並び替え順番表示方法', 'dg-style' );
    $text_count_title_display = __( '表示設定', 'dg-style' );
    $text_count_toggle = __( '記事件数表示', 'dg-style' );
    $text_count_title = __( '記事件数タイトル', 'dg-style' );
    $text_count_number = __( '記事件数', 'dg-style' );
    $text_count_type = __( '記事件数表示方法', 'dg-style' );
    $text_count_caution = __( '半角コンマ「,」区切りで入力してください。', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-taxonomy-sort" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab4}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_count_title_display}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value default-check" value="1" data-level="orderby-display" checked><span class="check-name">{$text_orderby_toggle}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_orderby_title}</div>
                            <input type="text" class="set-value insert-set-value" data-level="orderby-title">
                            <div class="window-title">{$text_orderby_list}</div>
                            {$order_list}
                            <div class="window-title">{$text_orderby_type}</div>
                            <select class="set-value insert-set-value" data-level="orderby-type">
                                <option value="1" selected>{$text_orderby_select1}</option>
                                <option value="2">{$text_orderby_select2}</option>
                            </select>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_count_title_display}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value default-check" value="1" data-level="order-display" checked><span class="check-name">{$text_order_toggle}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_order_title}</div>
                            <input type="text" class="set-value insert-set-value" data-level="order-title">
                            <div class="window-title">{$text_order_type}</div>
                            <select class="set-value insert-set-value" data-level="order-type">
                                <option value="1" selected>{$text_orderby_select1}</option>
                                <option value="2">{$text_orderby_select2}</option>
                            </select>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_count_title_display}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value default-check" value="1" data-level="count-display" checked><span class="check-name">{$text_count_toggle}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_count_title}</div>
                            <input type="text" class="set-value insert-set-value" data-level="count-title">
                            <div class="window-title">{$text_count_number}</div>
                            <input type="text" class="set-value insert-set-value" data-level="count-item">
                            <p class="caution">※{$text_count_caution}</p>
                            <div class="window-title">{$text_count_type}</div>
                            <select class="set-value insert-set-value" data-level="count-type">
                                <option value="1" selected>{$text_orderby_select1}</option>
                                <option value="2">{$text_orderby_select2}</option>
                            </select>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 一覧ページページングオプション
*/
function option_window_taxonomy_paging() {
    $inner = '';
    $ways = array( 'pm' => __( '最初のページ', 'dg-style' ), 'p' => __( '前のページ', 'dg-style' ), 'nm' => __( '最後のページ', 'dg-style' ), 'n' => __( '次のページ', 'dg-style' ), );
    $text_btn_name = __( 'ボタン名', 'dg-style' );
    $text_btn_placeholder = __( '例）nextなど', 'dg-style' );
    foreach( (array)$ways as $slug => $name ) {
        $caution = '';
        if ( $slug === 'pm' ) {
            $caution = '<p class="caution">※' . __( 'デフォルト：最初のページ番号', 'dg-style' ) . '</p>';
        } elseif ( $slug === 'nm' ) {
            $caution = '<p class="caution">※' . __( 'デフォルト：最後のページ番号', 'dg-style' ) . '</p>';
        } elseif ( $slug === 'p' ) {
            $caution = '<p class="caution">※' . __( 'デフォルト：prev', 'dg-style' ) . '</p>';
        } elseif ( $slug === 'n' ) {
            $caution = '<p class="caution">※' . __( 'デフォルト：next', 'dg-style' ) . '</p>';
        }
        $inner .= <<< EOM
            <div class="check-event-inner">
                <input type="checkbox" id="taxonomy-paging-btn-{$slug}" class="set-value none-display insert-set-value default-check" value="1" data-level="{$slug}" checked>
                <label class="check-event-label check-toggle-label" for="taxonomy-paging-btn-{$slug}">
                    <span class="check-name">{$name}</span><span class="check-button"></span>
                </label>
                <div class="check-event-content">
                    <div class="window-title">{$text_btn_name}</div>
                    <input type="text" class="set-value insert-set-value" data-level="{$slug}n" placeholder="{$text_btn_placeholder}">
                </div>
            </div>
EOM;
    }
    //翻訳
    $text_menu_title = __( '一覧ページページング', 'dg-style' );
    $text_menu_tab1 = __( '基本設定', 'dg-style' );
    $text_menu_tab2 = __( '前後ボタン表示', 'dg-style' );
    $text_menu_tab3 = __( 'その他', 'dg-style' );
    $text_paging_type_title = __( 'ページングタイプ', 'dg-style' );
    $text_paging_type1 = __( 'ナンバリング', 'dg-style' );
    $text_paging_type2 = __( 'もっと見る', 'dg-style' );
    $text_paging_type3 = __( 'セレクト式', 'dg-style' );
    $text_paging_type4 = __( 'スクロール表示', 'dg-style' );
    $text_paging_range_title = __( 'ボタン表示数', 'dg-style' );
    $text_paging_range_both = __( '最初・最後ページ表示', 'dg-style' );
    $text_more_btn_name = __( 'ボタン名', 'dg-style' );
    $text_more_post_title = __( '残り記事数', 'dg-style' );
    $text_more_post_count = __( '残り記事数表示', 'dg-style' );
    $text_more_post_placeholder = __( '残り[count]記事', 'dg-style' );
    $text_more_post_caution = __( '[count]必須<br>例）残り[count]記事の場合、「残り10記事」と表示されます。', 'dg-style' );
    $text_scroll_caution = __( '該当パーツまでスクロールされたら、自動で次のリストを読み込み表示します。', 'dg-style' );
    $text_toggle_target_title = __( '指定先にのみ記事リスト追加', 'dg-style' );
    $text_toggle_target_caution = __( '複数の「一覧ページ記事リスト」を使う場合にご利用ください。', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    
    return <<< EOM
        <div id="option-taxonomy-paging" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_paging_type_title}</div>
                            <div class="tab-inner">
                                <div class="tab-list option-labels four">
                                    <label class="tab-label option-label on"><input type="radio" name="taxonomy-paging-type" value="1" class="set-value none-display insert-set-value" data-level="type"><span class="toggle-label">{$text_paging_type1}</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="taxonomy-paging-type" value="2" class="set-value none-display insert-set-value" data-level="type"><span class="toggle-label">{$text_paging_type2}</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="taxonomy-paging-type" value="3" class="set-value none-display insert-set-value" data-level="type"><span class="toggle-label">{$text_paging_type3}</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="taxonomy-paging-type" value="4" class="set-value none-display insert-set-value" data-level="type"><span class="toggle-label">{$text_paging_type4}</span></label>
                                </div>
                                <div class="tab-contents option-contents">
                                    <div class="tab-content on">
                                        <div class="window-title">{$text_paging_range_title}</div>
                                        <input type="number" class="set-value" data-level="range">
                                        <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="both"><span class="check-name">{$text_paging_range_both}</span><span class="check-button"></span></label>
                                    </div>
                                    <div class="tab-content">
                                        <div class="window-title">{$text_more_btn_name}</div>
                                        <input type="text" class="set-value insert-set-value" data-level="more">
                                        <div class="window-title">{$text_more_post_title}</div>
                                        <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="count"><span class="check-name">{$text_more_post_count}</span><span class="check-button"></span></label>
                                        <input type="text" class="set-value insert-set-value" data-level="count-text" placeholder="{$text_more_post_placeholder}">
                                        <p class="caution">※{$text_more_post_caution}</p>
                                        <div class="window-title">{$text_toggle_target_title}</div>
                                        <div class="toggle-name-input-area">
                                            <input type="text" class="set-value insert-set-value toggle-name-input" data-level="target" data-exclusive="taxonomy-post_list">
                                        </div>
                                        <p class="caution">※{$text_toggle_target_caution}</p>
                                    </div>
                                    <div class="tab-content"></div>
                                    <div class="tab-content">
                                        <p class="caution">※{$text_scroll_caution}</p>
                                        <div class="window-title">{$text_toggle_target_title}</div>
                                        <div class="toggle-name-input-area">
                                            <input type="text" class="set-value insert-set-value toggle-name-input" data-level="target" data-exclusive="taxonomy-post_list">
                                        </div>
                                        <p class="caution">※{$text_toggle_target_caution}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_menu_tab2}</div>
                            {$inner}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 作成者ページSNS・連絡先
*/
function option_window_taxonomy_user_sns() {
    $type = array( 'site' => __( 'サイトURL', 'dg-style' ), 'mail' => __( 'メールアドレス', 'dg-style' ), 'facebook' => 'Facebook', 'twitter' => 'Twitter', 'line' => 'Line' );
    $text_name_display = __( 'の表示', 'dg-style' );
    $text_name_title = __( '表示名設定', 'dg-style' );
    $item_list = '';
    foreach( (array)$type as $key => $name ) {
        $item_list .= <<< EOM
            <div class="check-event-inner">
                <input type="checkbox" id="taxonomy-usersns-option-display-{$key}" class="set-value none-display insert-set-value default-check" value="1" data-level="{$key}" checked>
                <label class="check-event-label check-toggle-label" for="taxonomy-usersns-option-display-{$key}">
                    <span class="check-name">{$name}{$text_name_display}</span><span class="check-button"></span>
                </label>
                <div class="check-event-content">
                    <div class="window-title">{$text_name_title}</div>
                    <input type="text" class="set-value insert-set-value" data-level="{$key}n">
                </div>
            </div>
EOM;
    }
    //翻訳
    $text_menu_title = __( '作成者ページSNS・連絡先', 'dg-style' );
    $text_menu_tab1 = __( '基本設定', 'dg-style' );
    $text_menu_tab2 = __( 'その他', 'dg-style' );
    $text_display_item_title = __( '表示する項目', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-taxonomy-user_sns" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_display_item_title}</div>
                            {$item_list}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 記事タイトル
*/
function option_window_single_title() {
    //翻訳
    $text_menu_title = __( '記事タイトル', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    $text_tag_title = __( 'タグ選択', 'dg-style' );
    return <<< EOM
        <div id="option-single-title" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_add_class}</div>
                <input type="text" class="set-value insert-set-value" data-level="part-class">
                <div class="window-title">{$text_tag_title}</div>
                <select class="set-value insert-set-value" data-level="tag">
                    <option value="h1">h1</option>
                    <option value="h2">h2</option>
                    <option value="h3">h3</option>
                    <option value="h4">h4</option>
                    <option value="h5">h5</option>
                    <option value="h6">h6</option>
                    <option value="strong">strong</option>
                    <option value="p">p</option>
                </select>
            </div>
        </div>
EOM;
}

/*
 * 記事目次
*/
function option_window_single_index() {
    //翻訳
    $text_menu_title = __( '記事目次', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-single-index" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_add_class}</div>
                <input type="text" class="set-value insert-set-value" data-level="part-class">
            </div>
        </div>
EOM;
}

/*
 * 記事タクソノミーオプション
*/
function option_window_single_taxonomy() {
    //翻訳
    $text_tax_label = __( 'の表示', 'dg-style' );
    $text_tax_count = __( '表示数制限', 'dg-style' );
    $item_list = '';
    $taxonomise = default_taxonomy_exclusion( array( 'category', 'post_tag' ) );
    foreach( (array)$taxonomise as $tax ) {
        $check_class = '';
        $checked = '';
        if ( $tax === 'category' ) {
            $check_class = ' default-check';
            $checked = ' checked';
        }
        $taxonomy = get_taxonomy( $tax );
        $item_list .= <<< EOM
            <div class="check-event-inner">
                <input type="checkbox" id="single-taxonomy-option-display-{$tax}" class="set-value none-display insert-set-value{$check_class}" value="1" data-level="{$tax}"{$checked}>
                <label class="check-event-label check-toggle-label" for="single-taxonomy-option-display-{$tax}">
                    <span class="check-name">{$taxonomy->label}{$text_tax_label}</span><span class="check-button"></span>
                </label>
                <div class="check-event-content">
                    <div class="window-title">{$text_tax_count}</div>
                    <input type="number" class="set-value insert-set-value" data-level="{$tax}-count">
                </div>
            </div>
EOM;
    }
    //翻訳
    $text_menu_title = __( '記事タクソノミー', 'dg-style' );
    $text_menu_tab1 = __( '基本設定', 'dg-style' );
    $text_menu_tab2 = __( 'その他', 'dg-style' );
    $text_tax_title = __( 'タクソノミー選択', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-single-taxonomy" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_tax_title}</div>
                            {$item_list}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 記事サムネイル
*/
function option_window_single_thumbnail() {
    //翻訳
    $text_menu_title = __( '記事サムネイル', 'dg-style' );
    $text_thumb_size = __( 'サムネイルサイズ', 'dg-style' );
    $text_srcset_title = __( 'srcsetにする', 'dg-style' );
    $text_srcset_caution = __( 'srcsetにする場合、サイズの選択は無効になります。', 'dg-style' );
    $text_thumb_fixed = __( '固定サムネイル表示', 'dg-style' );
    $text_thumb_fixed_menu1 = __( '表示しない', 'dg-style' );
    $text_thumb_fixed_menu2 = __( '常に固定サムネイル表示', 'dg-style' );
    $text_thumb_fixed_menu3 = __( 'サムネイルがない場合(No-imageより優先)', 'dg-style' );
    $text_noimage_title = __( 'イメージがない場合の表示設定', 'dg-style' );
    $text_noimage_toggle = __( 'no-imageを表示する', 'dg-style' );
    $text_image_tag_size = __( 'イメージタグサイズ', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-single-thumbnail" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_thumb_size}</div>
                <select class="set-value insert-set-value" data-level="size">
                    <option value="thumbnail">thumbnail</option>
                    <option value="medium">medium</option>
                    <option value="large">large</option>
                    <option value="full">full</option>
                </select>
                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="srcset"><span class="check-name">{$text_srcset_title}</span><span class="check-button"></span></label>
                <p class="caution">※{$text_srcset_caution}</p>
                <div class="window-title">{$text_thumb_fixed}</div>
                <select class="set-value insert-set-value" data-level="fixed">
                    <option value="">{$text_thumb_fixed_menu1}</option>
                    <option value="1">{$text_thumb_fixed_menu2}</option>
                    <option value="2">{$text_thumb_fixed_menu3}</option>
                </select>
                <div class="window-title">{$text_noimage_title}</div>
                <label class="check-toggle-label"><input type="checkbox" class="set-value default-check" value="1" data-level="none"><span class="check-name" checked>{$text_noimage_toggle}</span><span class="check-button"></span></label>
                <div class="window-title">{$text_image_tag_size}</div>
                <div class="movie-range-area">
                    <input type="number" class="set-value insert-set-value" data-level="width" placeholder="300">
                    <span class="text">×</span>
                    <input type="number" class="set-value insert-set-value" data-level="height" placeholder="300">
                </div>
                <div class="window-title">{$text_add_class}</div>
                <input type="text" class="set-value insert-set-value" data-level="part-class">
            </div>
        </div>
EOM;
}

/*
 * タクソノミー動画サムネイル
*/
function option_window_single_movie() {
    //翻訳
    $text_menu_title = __( '記事動画サムネイル', 'dg-style' );
    $text_menu_tab1 = __( '動画オプション', 'dg-style' );
    $text_menu_tab2 = __( '動画サムネイル', 'dg-style' );
    $text_menu_tab3 = __( 'その他', 'dg-style' );
    $text_movie_option1 = __( '自動再生', 'dg-style' );
    $text_movie_option2 = __( '繰り返し再生', 'dg-style' );
    $text_movie_option3 = __( 'インターフェース表示', 'dg-style' );
    $text_movie_option4 = __( '消音', 'dg-style' );
    $text_movie_option5 = __( 'preload設定', 'dg-style' );
    $text_movie_thumb = __( '動画サムネイルを表示', 'dg-style' );
    $text_movie_thumb_caution1 = __( 'サムネイルイメージが使われます。', 'dg-style' );
    $text_movie_thumb_caution2 = __( 'iframeの場合は反映されません。', 'dg-style' );
    $text_movie_noimage_title = __( '動画がない場合', 'dg-style' );
    $text_movie_noimage_toggle = __( 'サムネイルのみ表示', 'dg-style' );
    $text_movie_thumb_size = __( '動画サムネイルサイズ', 'dg-style' );
    $text_srcset_title = __( 'srcsetにする', 'dg-style' );
    $text_srcset_caution = __( 'srcsetにする場合、サイズの選択は無効になります。', 'dg-style' );
    $text_image_tag_size = __( 'イメージタグサイズ', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-single-movie" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_menu_tab1}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="autoplay"><span class="check-name">{$text_movie_option1}</span><span class="check-button"></span></label>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="loop"><span class="check-name">{$text_movie_option2}</span><span class="check-button"></span></label>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="controls"><span class="check-name">{$text_movie_option3}</span><span class="check-button"></span></label>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="muted"><span class="check-name">{$text_movie_option4}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_movie_option5}</div>
                            <select class="set-value insert-set-value" data-level="preload">
                                <option value="">auto</option>
                                <option value="1">metadata</option>
                                <option value="2">none</option>
                            </select>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_menu_tab2}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value default-check" value="1" data-level="thumb" checked><span class="check-name">{$text_movie_thumb}</span><span class="check-button"></span></label>
                            <p class="caution">※{$text_movie_thumb_caution1}<br>※{$text_movie_thumb_caution2}</p>
                            <div class="window-title">{$text_movie_noimage_title}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value default-check" value="1" data-level="none" checked><span class="check-name">{$text_movie_noimage_toggle}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_movie_thumb_size}</div>
                            <select class="set-value insert-set-value" data-level="size">
                                <option value="thumbnail">thumbnail</option>
                                <option value="medium">medium</option>
                                <option value="large">large</option>
                                <option value="full">full</option>
                            </select>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="srcset"><span class="check-name">{$text_srcset_title}</span><span class="check-button"></span></label>
                            <p class="caution">※{$text_srcset_caution}</p>
                            <div class="window-title">{$text_image_tag_size}</div>
                            <div class="movie-range-area">
                                <input type="number" class="set-value insert-set-value" data-level="width" placeholder="300">
                                <span class="text">×</span>
                                <input type="number" class="set-value insert-set-value" data-level="height" placeholder="300">
                            </div>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 記事Views
*/
function option_window_single_views() {
    //翻訳
    $text_menu_title = __( '記事Views数', 'dg-style' );
    $text_views1 = __( '全体', 'dg-style' );
    $text_views2 = __( '週間', 'dg-style' );
    $text_views3 = __( '月間', 'dg-style' );
    $text_views4 = __( '年間', 'dg-style' );
    $text_text_title = __( 'テキスト設定', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-single-views" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">表示する期間</div>
                <select class="set-value" data-level="type">
                    <option value="views">{$text_views1} views</option>
                    <option value="w_views">{$text_views2} views</option>
                    <option value="m_views">{$text_views3} views</option>
                    <option value="y_views">{$text_views4} views</option>
                </select>
                <div class="window-title">{$text_text_title}</div>
                <input type="text" class="set-value insert-set-value" data-level="text">
                <div class="window-title">{$text_add_class}</div>
                <input type="text" class="set-value insert-set-value" data-level="part-class">
            </div>
        </div>
EOM;
}

/*
 * ブックマーク
*/
function option_window_single_bookmark() {
    //翻訳
    $text_menu_title = __( 'ブックマークボタン', 'dg-style' );
    $text_btn_title = __( 'ボタン名', 'dg-style' );
    $text_btn_toggle = __( 'ブックマーク数を表示', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-single-bookmark" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_btn_title}</div>
                <input type="text" class="set-value insert-set-value" data-level="text">
                <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="count" checked><span class="check-name">{$text_btn_toggle}</span><span class="check-button"></span></label>
                <div class="window-title">{$text_add_class}</div>
                <input type="text" class="set-value insert-set-value" data-level="part-class">
            </div>
        </div>
EOM;
}

/*
 * カスタムフィールド
*/
function option_window_single_postmeta( $field_list ) {
    $options = '';
    $field_list = explode( ',', $field_list );
    if ( is_array( $field_list ) && count( $field_list ) > 0 ) {
        foreach( (array)$field_list as $name ) {
            $options .= '<option value="' . $name . '">' . $name . '</option>';
        }
    }
    //翻訳
    $text_menu_tab1 = __( 'オプション', 'dg-style' );
    $text_menu_tab2 = __( 'その他', 'dg-style' );
    $text_menu_title = __( 'カスタムフィールド', 'dg-style' );
    $text_custom_title = __( 'カスタムフィールド選択', 'dg-style' );
    $text_custom1 = __( '選択してください', 'dg-style' );
    $text_update = __( 'リスト更新', 'dg-style' );
    $text_select_tags = __( 'タグ設定', 'dg-style' );
    $text_attr = __( '属性指定', 'dg-style' );
    $text_attr_caution = __( 'hrefやsrcなどカスタムフィールドを適用したいHTML属性を指定', 'dg-style' );
    $text_subtext = __( '代用テキスト', 'dg-style' );
    $text_subtext_caution = __( 'hrefなどカスタムフィールドを属性に設定した場合、代用テキストで文字を表示できます', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-single-postmeta" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_custom_title}</div>
                            <select class="set-value postmeta-select-input" data-level="type">
                                <option value="">{$text_custom1}</option>
                                {$options}
                            </select>
                            <div class="caution"><button type="button" class="update-postmeta-list">{$text_update}</button></div>
                            <div class="window-title">{$text_select_tags}</div>
                            <input type="text" class="set-value insert-set-value" data-level="tag" placeholder="divなど">
                            <div class="window-title">{$text_attr}</div>
                            <input type="text" class="set-value insert-set-value" data-level="attr">
                            <p class="caution">※{$text_attr_caution}</p>
                            <div class="window-title">{$text_subtext}</div>
                            <input type="text" class="set-value insert-set-value" data-level="subtext">
                            <p class="caution">※{$text_subtext_caution}</p>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 記事日付
*/
function option_window_single_date() {
    //翻訳
    $text_menu_title = __( '記事公開日', 'dg-style' );
    $text_menu_tab1 = __( '公開日関連', 'dg-style' );
    $text_menu_tab2 = __( '更新日関連', 'dg-style' );
    $text_menu_tab3 = __( 'その他', 'dg-style' );
    $text_date_toggle = __( '公開日を表示', 'dg-style' );
    $text_date_tag_title = __( 'タグ設定', 'dg-style' );
    $text_date_format = __( '日付フォーマット', 'dg-style' );
    $text_date_example = __( '例）Y年m月d日', 'dg-style' );
    $text_update_toggle = __( '更新日を表示', 'dg-style' );
    
    $text_add_class = __( 'Class追加', 'dg-style' );
    
    return <<< EOM
        <div id="option-single-date" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value default-check" value="1" data-level="date" checked><span class="check-name">{$text_date_toggle}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_date_tag_title}</div>
                            <select class="set-value insert-set-value" data-level="date-tag">
                                <option value="time">time</option>
                                <option value="strong">strong</option>
                                <option value="div">div</option>
                                <option value="span">span</option>
                                <option value="p">p</option>
                            </select>
                            <div class="window-title">{$text_date_format}</div>
                            <input type="text" class="set-value insert-set-value" data-level="date-format" placeholder="{$text_date_example}">
                        </div>
                        <div class="tab-content">
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value default-check" value="1" data-level="update" checked><span class="check-name">{$text_update_toggle}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_date_tag_title}</div>
                            <select class="set-value insert-set-value" data-level="update-tag">
                                <option value="time">time</option>
                                <option value="strong">strong</option>
                                <option value="div">div</option>
                                <option value="span">span</option>
                                <option value="p">p</option>
                            </select>
                            <div class="window-title">{$text_date_format}</div>
                            <input type="text" class="set-value insert-set-value" data-level="update-format" placeholder="{$text_date_example}">
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 記事評価
*/
function option_window_single_evaluate() {
    //翻訳
    $text_menu_title = __( '記事評価', 'dg-style' );
    $text_display_title = __( '表示設定', 'dg-style' );
    $text_display_toggle = __( '評価結果表示', 'dg-style' );
    $text_display_form_toggle = __( '評価フォーム表示', 'dg-style' );
    $text_display_item_title = __( '評価項目表示名', 'dg-style' );
    $text_very_example = __( '例）すごく', 'dg-style' );
    $text_good_example = __( '例）いいね', 'dg-style' );
    $text_average_example = __( '例）ふつう', 'dg-style' );
    $text_fair_example = __( '例）あんまり', 'dg-style' );
    $text_poor_example = __( '例）ぜんぜん', 'dg-style' );
    $text_confirm_title = __( '確認メッセージテキスト', 'dg-style' );
    $text_confirm_caution = __( '選択した内容で評価しますか？', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    
    return <<< EOM
        <div id="option-single-evaluate" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_display_title}</div>
                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value default-check" value="1" data-level="result" checked><span class="check-name">{$text_display_toggle}</span><span class="check-button"></span></label>
                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value default-check" value="1" data-level="form" checked><span class="check-name">{$text_display_form_toggle}</span><span class="check-button"></span></label>
                <div class="window-title">{$text_display_item_title}</div>
                <input type="text" class="set-value insert-set-value mb10" data-level="very-good" placeholder="{$text_very_example}">
                <input type="text" class="set-value insert-set-value mb10" data-level="good" placeholder="{$text_good_example}">
                <input type="text" class="set-value insert-set-value mb10" data-level="average" placeholder="{$text_average_example}">
                <input type="text" class="set-value insert-set-value mb10" data-level="fair" placeholder="{$text_fair_example}">
                <input type="text" class="set-value insert-set-value" data-level="poor" placeholder="{$text_poor_example}">
                <div class="window-title">{$text_confirm_title}</div>
                <input type="text" class="set-value insert-set-value" data-level="confirm" placeholder="{$text_confirm_caution}">
                <div class="window-title">{$text_add_class}</div>
                <input type="text" class="set-value insert-set-value" data-level="part-class">
            </div>
        </div>
EOM;
}

/*
 * 記事本文オプション
*/
function option_window_single_content() {
    //翻訳
    $text_menu_title = __( '記事本文', 'dg-style' );
    $text_menu_tab1 = __( '差し込みエリア', 'dg-style' );
    $text_menu_tab2 = __( 'CSS関連', 'dg-style' );
    $text_menu_tab3 = __( 'パスワード保護', 'dg-style' );
    $text_menu_tab4 = __( 'その他', 'dg-style' );
    $text_menu_tab5 = __( '分割表示', 'dg-style' );
    $text_block_css_toggle = __( 'BLOCK STYLE CSS適用', 'dg-style' );
    $text_dg_css_toggle = __( 'DG STYLE CSS適用', 'dg-style' );
    $text_pass_title = __( 'パスワード保護ページ文設定', 'dg-style' );
    $text_pass_placeholder = __( 'パスワード入力例文', 'dg-style' );
    $text_btn_title = __( 'ボタン名', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    $text_split_label = __( '分割する', 'dg-style' );
    $text_split_number = __( '表示するコンテンツ番号', 'dg-style' );
    $text_split_caption1 = __( '分割は記事作成時にGutenbergブロックの「区切り線」を設置する必要があります。', 'dg-style' );
    $text_split_caption2 = __( '分けられたコンテンツの中で表示するコンテンツ番号を指定します。', 'dg-style' );
    $text_split_caption3 = __( '番号を１にして分けられなかった場合にもコンテンツがないものと見なします。', 'dg-style' );
    $text_split_none_display = __( '指定した番号のコンテンツがない場合', 'dg-style' );
    $plug_area = option_plug_area( true );
    return <<< EOM
        <div id="option-single-content" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab5}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab4}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            {$plug_area}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_menu_tab5}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="split"><span class="check-name">{$text_split_label}</span><span class="check-button"></span></label>
                            <div class="caution">※{$text_split_caption1}</div>
                            <div class="window-title">{$text_split_number}</div>
                            <input type="number" class="set-value insert-set-value" data-level="split-n" min="1">
                            <div class="caution">※{$text_split_caption2}<br>※{$text_split_caption3}</div>
                            <div class="window-title">{$text_split_none_display}</div>
                            <select class="set-value insert-set-value" data-level="split-d">
                                <option value="">全コンテンツ表示</option>
                                <option value="1">非表示</option>
                            </select>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">Block Editor Default CSS</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value default-check" value="1" data-level="block-css" checked><span class="check-name">{$text_block_css_toggle}</span><span class="check-button"></span></label>
                            <div class="window-title">DG-STYLE Default CSS</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value default-check" value="1" data-level="dg-css" checked><span class="check-name">{$text_dg_css_toggle}</span><span class="check-button"></span></label>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_pass_title}</div>
                            <textarea rows="5" class="set-value insert-set-value" data-level="pass"></textarea>
                            <div class="window-title">{$text_pass_placeholder}</div>
                            <input type="text" class="set-value insert-set-value" data-level="placeholder">
                            <div class="window-title">{$text_btn_title}</div>
                            <input type="text" class="set-value insert-set-value" data-level="button">
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 記事ページングオプション
*/
function option_window_single_paging( $item_list = array() ) {
    $post_item = option_windows_post_list_part( $item_list );
    $area_items = option_post_area_items( $post_item );
    //翻訳
    $text_menu_title = __( '記事ページング', 'dg-style' );
    $text_menu_tab1 = __( '各項目表示設定', 'dg-style' );
    $text_menu_tab2 = __( 'その他', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-single-paging" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">その他</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            {$area_items}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 記事コメントオプション
*/
function option_window_single_comment() {
    //表示アイテム
    $text_class_title = __( 'class指定', 'dg-style' );
    $item_list = array(
        'author' => array(
            'name' => __( '作成者', 'dg-style' ),
            'options' => array(
                'class' => array( 'title' => $text_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'comment' => array(
            'name' => __( 'コメント本文', 'dg-style' ),
            'options' => array(
                'class' => array( 'title' => $text_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'date' => array(
            'name' => __( '登録日', 'dg-style' ),
            'options' => array(
                'tag' => array( 'title' => __( 'タグ設定', 'dg-style' ), 'type' => 'select', 'list' => 'time,strong,div,span,p', 'insert' => true, ),
                'format' => array( 'title' => __( '日付表示フォーマット', 'dg-style' ), 'type' => 'text', 'placeholder' => __( '例）Y年m月d日', 'dg-style' ), 'insert' => true, ),
                'class' => array( 'title' => $text_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'reply' => array(
            'name' => __( '返信ボタン', 'dg-style' ),
            'options' => array(
                'reply-text' => array( 'title' => __( 'ボタン名', 'dg-style' ), 'type' => 'text', 'placeholder' => __( '例）返信', 'dg-style' ), 'insert' => true, ),
                'class' => array( 'title' => $text_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
    );
    $post_item = option_windows_post_list_part( $item_list );
    $area_items = option_post_area_items( $post_item );
    //翻訳
    $text_menu_title = __( '記事コメント', 'dg-style' );
    $text_menu_tab1 = __( 'コメント数', 'dg-style' );
    $text_menu_tab2 = __( 'コメントリスト', 'dg-style' );
    $text_menu_tab3 = __( 'コメントフォーム', 'dg-style' );
    $text_menu_tab4 = __( 'その他', 'dg-style' );
    $text_count_display_title = __( 'コメント数表示設定', 'dg-style' );
    $text_count_display = __( '表示する', 'dg-style' );
    $text_count_text = __( '表示する', 'dg-style' );
    $text_list_display_title = __( 'コメントリスト表示設定', 'dg-style' );
    $text_display_item_title = __( '各項目表示設定', 'dg-style' );
    $text_form_display_title = __( 'コメントフォーム表示設定', 'dg-style' );
    $text_form_placeholder_title = __( 'placeholder設定', 'dg-style' );
    $text_form_button_title = __( '送信ボタン名変更', 'dg-style' );
    $text_form_button_placeholder = __( '送信', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    
    return <<< EOM
        <div id="option-single-comment" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab4}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_count_display_title}</div>
                            <div class="check-event-inner">
                                <input type="checkbox" id="comment-count-display" class="set-value none-display default-check" value="1" data-level="count" checked>
                                <label class="check-event-label check-toggle-label" for="comment-count-display">
                                    <span class="check-name">{$text_count_display}</span><span class="check-button"></span>
                                </label>
                                <div class="check-event-content">
                                    <div class="window-title">{$text_count_text}</div>
                                    <input type="text" class="set-value" data-level="cct" placeholder="comments">
                                </div>
                            </div>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_list_display_title}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value default-check" value="1" data-level="list" checked><span class="check-name">{$text_count_display}</span><span class="check-button"></span></label>
                            {$area_items}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_form_display_title}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value default-check" value="1" data-level="form" checked><span class="check-name">{$text_count_display}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_form_placeholder_title}</div>
                            <input type="text" class="set-value mb10" data-level="pn" placeholder="name">
                            <input type="text" class="set-value mb10" data-level="pm" placeholder="mail">
                            <input type="text" class="set-value mb10" data-level="ps" placeholder="site">
                            <input type="text" class="set-value" data-level="pc" placeholder="comment">
                            <div class="window-title">{$text_form_button_title}</div>
                            <input type="text" class="set-value" data-level="submit" placeholder="{$text_form_button_placeholder}">
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 関連記事
*/
function option_window_single_recommend( $item_list = array(), $tax_labels = '' ) {
    $order_by_option = '';
    $order_option = '';
    $order_by = array( 'date' => __( '公開日', 'dg-style' ), 'modified' => __( '更新日', 'dg-style' ), 'views' => __( '人気順（全体）', 'dg-style' ), 'w_views' => __( '人気順（週間）', 'dg-style' ), 'm_views' => __( '人気順（月間）', 'dg-style' ), 'y_views' => __( '人気順（年間）', 'dg-style' ), 'evaluate' => __( '評価順', 'dg-style' ), 'bookmark' => __( 'ブックマーク数順', 'dg-style' ), 'comment_count' => __( 'コメント多い順', 'dg-style' ), 'author' => __( '作成者順', 'dg-style' ), 'rand' => __( 'ランダム', 'dg-style' ), 'title' => __( '記事タイトル', 'dg-style' ), );
    $order = array( 'DESC' => '降順（最新）', 'ASC' => '昇順（古い）', );
    
    foreach( (array)$order_by as $key => $name ) {
        $order_by_option .= '<option value="' . $key . '">' . $name . '</option>';
    }
    foreach( (array)$order as $key => $name ) {
        $order_option .= '<option value="' . $key . '">' . $name . '</option>';
    }
    
    $post_item = option_windows_post_list_part( $item_list );
    $area_items = option_post_area_items( $post_item );
    $plug_area = option_plug_area();
    $dynamic_class = option_dynamic_add_class();
    //翻訳
    $text_post_type_title = __( '表示する記事タイプ', 'dg-style' );
    $text_author_title = __( '作成者一致', 'dg-style' );
    $text_category_title = __( 'カテゴリー一致', 'dg-style' );
    $text_tag_title = __( 'タグ一致', 'dg-style' );
    $recommend_type = <<< EOM
        <div class="check-value-inner">
            <div class="window-title">{$text_post_type_title}</div>
            <ul class="parent-taxonomy-area parent-items-area select-terms-post-type" data-tax="post-type">
                <li class="term-item">
                    <div class="term-names">
                        <label class="term-label"><input type="checkbox" class="term-input" value="author">{$text_author_title}</label>
                    </div>
                </li>
                <li class="term-item">
                    <div class="term-names">
                        <label class="term-label"><input type="checkbox" class="term-input" value="category" checked>{$text_category_title}</label>
                    </div>
                </li>
                <li class="term-item">
                    <div class="term-names">
                        <label class="term-label"><input type="checkbox" class="term-input" value="post_tag">{$text_tag_title}</label>
                    </div>
                </li>
                {$tax_labels}
            </ul>
            <input type="hidden" class="check-value-summary set-value" data-level="recommend">
        </div>
EOM;
    //翻訳
    $text_menu_title = __( '関連記事リスト', 'dg-style' );
    $text_menu_tab1 = __( '記事表示数', 'dg-style' );
    $text_menu_tab2 = __( '記事絞り込み', 'dg-style' );
    $text_menu_tab3 = __( '各項目表示設定', 'dg-style' );
    $text_menu_tab4 = __( '差し込みエリア', 'dg-style' );
    $text_menu_tab5 = __( 'その他', 'dg-style' );
    $text_post_offset1 = __( '番目から', 'dg-style' );
    $text_post_offset2 = __( '件表示', 'dg-style' );
    $text_narrow_caution = __( '記事編集ページで関連記事を選択した場合、選択した記事が優先されます。', 'dg-style' );
    $text_narrow_title = __( '記事絞り込み条件', 'dg-style' );
    $text_narrow1 = __( '選択したどれかのカテゴリーに一致する', 'dg-style' );
    $text_narrow2 = __( '選択したすべてのカテゴリーに一致', 'dg-style' );
    $text_sort = __( '表示順', 'dg-style' );
    $text_menu_none_post_title = __( '記事がない場合', 'dg-style' );
    $text_menu_none_post_toggle = __( '専用エリアを追加する', 'dg-style' );
    $text_menu_add_class = __( 'Class追加', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-single-recommend" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab4}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab5}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_menu_tab1}</div>
                            <div class="range-flex">
                                <input type="number" class="set-value" data-level="offset" placeholder="1">
                                <span class="text">{$text_post_offset1}</span>
                                <input type="number" class="set-value" data-level="post-count" placeholder="5">
                                <span class="text">{$text_post_offset2}</span>
                            </div>
                        </div>
                        <div class="tab-content">
                            <p class="caution">※{$text_narrow_caution}</p>
                            {$recommend_type}
                            <div class="window-title">{$text_narrow_title}</div>
                            <select class="set-value" data-level="relation">
                                <option value="OR">{$text_narrow1}</option>
                                <option value="AND">{$text_narrow2}</option>
                            </select>
                            <div class="window-title">{$text_sort}</div>
                            <div class="post-order-area">
                                <select class="set-value" data-level="order-by">{$order_by_option}</select>
                                <span>で</span>
                                <select class="set-value" data-level="order">{$order_option}</select>
                            </div>
                        </div>
                        <div class="tab-content">
                            {$area_items}
                        </div>
                        <div class="tab-content">
                            {$plug_area}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_menu_none_post_title}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value add-none-post-area" value="1" data-level="none"><span class="check-name">{$text_menu_none_post_toggle}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                            {$dynamic_class}
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 作成者情報
*/
function option_window_single_author() {
    //表示アイテム
    $text_item_link_title = __( 'リンク追加', 'dg-style' );
    $text_item_class_title = __( 'class指定', 'dg-style' );
    $text_item_size_title = __( 'サイズ', 'dg-style' );
    $text_item_imagetag_size_title = __( 'イメージタグサイズ', 'dg-style' );
    $item_list = array(
        'name' => array(
            'name' => __( '作成者名', 'dg-style' ),
            'options' => array(
                'tag' => array( 'title' => __( 'タグ設定', 'dg-style' ), 'type' => 'select', 'list' => 'h2,h3,h4,h5,h6,strong,div,span,p', 'insert' => true, ),
                'link' => array( 'title' => $text_item_link_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'description' => array(
            'name' => __( '紹介文', 'dg-style' ),
            'options' => array(
                'count' => array( 'title' => __( '文字数', 'dg-style' ), 'type' => 'number', 'insert' => true, ),
                'after' => array( 'title' => __( '省略文字', 'dg-style' ), 'type' => 'text', 'placeholder' => __( '例）続きを読む', 'dg-style' ), 'insert' => true, ),
                'link' => array( 'title' => $text_item_link_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'gravatar' => array(
            'name' => __( 'プロフィール写真（Gravatar）', 'dg-style' ),
            'options' => array(
                'thumbnail-size' => array( 'title' => $text_item_size_title, 'type' => 'select', 'list' => '150,300,512', ),
                'link' => array( 'title' => $text_item_link_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'user_image' => array(
            'name' => __( 'ユーザーイメージ', 'dg-style' ),
            'options' => array(
                'thumbnail-size' => array( 'title' => $text_item_size_title, 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_item_imagetag_size_title, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_item_link_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'bg_image' => array(
            'name' => __( '背景イメージ', 'dg-style' ),
            'options' => array(
                'thumbnail-size' => array( 'title' => $text_item_size_title, 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_item_imagetag_size_title, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_item_link_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'movie_thumbnail' => array(
            'name' => __( '動画サムネイル', 'dg-style' ),
            'options' => array(
                'caution' => array( 'type' => 'caution', 'content' => '※' . __( 'サムネイルイメージが動画サムネイルとして利用されます。', 'dg-style' ), ),
                'thumbnail-type' => array( 'title' => __( 'サムネイル選択', 'dg-style' ), 'type' => 'select', 'list2' => array( 'user_image' => __( 'ユーザーイメージ', 'dg-style' ), 'bg_image' => __( '背景イメージ', 'dg-style' ), ), ),
                'thumbnail-size' => array( 'title' => __( '動画サムネイルサイズ', 'dg-style' ), 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_item_imagetag_size_title, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_item_link_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'fixed' => array(
            'name' => __( '固定サムネイル', 'dg-style' ),
            'options' => array(
                'thumbnail-size' => array( 'title' => __( 'サイズ', 'dg-style' ), 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_item_imagetag_size_title, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_item_link_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'user_sns' => array(
            'name' => __( 'SNS・連絡先', 'dg-style' ),
            'options' => array(
                'site' => array( 'title' => __( 'サイトURL', 'dg-style' ), 'type' => 'check', ),
                'mail' => array( 'title' => __( 'メールアドレス', 'dg-style' ), 'type' => 'check', ),
                'facebook' => array( 'title' => 'Facebook', 'type' => 'check', ),
                'twitter' => array( 'title' => 'Twitter', 'type' => 'check', ),
                'line' => array( 'title' => 'Line', 'type' => 'check', ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'more' => array(
            'name' => __( 'ページリンク', 'dg-style' ),
            'options' => array(
                'text' => array( 'title' => __( 'リンクテキスト', 'dg-style' ), 'type' => 'text', 'placeholder' => __( '例）ページを見る', 'dg-style' ), 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
    );
    $post_item = option_windows_post_list_part( $item_list );
    $area_items = option_post_area_items( $post_item );
    //翻訳
    $text_menu_title = __( '作成者プロフィール', 'dg-style' );
    $text_menu_tab1 = __( '各項目表示設定', 'dg-style' );
    $text_menu_tab2 = __( 'その他', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-single-author" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            {$area_items}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * テキスト
*/
function option_window_text() {
    //翻訳
    $text_menu_title = __( 'テキスト', 'dg-style' );
    $text_menu_tab1 = __( 'テキスト設定', 'dg-style' );
    $text_menu_tab2 = __( 'その他', 'dg-style' );
    $text_input_title = __( 'テキスト入力', 'dg-style' );
    $text_inner_tag_title = __( '内部タグ指定', 'dg-style' );
    $text_inner_tag1 = __( 'なし', 'dg-style' );
    $text_inner_tag2 = __( '全体をspanで囲む', 'dg-style' );
    $text_inner_tag3 = __( '改行ごとにspanで囲む', 'dg-style' );
    $text_tag_select_title = __( 'タグ指定', 'dg-style' );
    $text_link_input_title = __( 'リンク先指定', 'dg-style' );
    $text_link_select1 = __( '直書き', 'dg-style' );
    $text_link_select2 = __( '内部リンク', 'dg-style' );
    $text_url_input_title = __( 'URL入力', 'dg-style' );
    $text_url_search_title = __( 'URL検索', 'dg-style' );
    $text_url_search_btn = __( 'ページ検索', 'dg-style' );
    $text_url_search_parm = __( 'URLパラメータ追加', 'dg-style' );
    $text_url_newtab = __( '新しいタブで開く', 'dg-style' );
    $text_parent_tag_title = __( '親タグ追加', 'dg-style' );
    $text_parent_select1 = __( '親タグなし', 'dg-style' );
    $text_parent_select2 = __( 'pタグで囲む', 'dg-style' );
    $text_parent_select3 = __( 'divタグで囲む', 'dg-style' );
    $text_parent_select4 = __( 'h1タグで囲む', 'dg-style' );
    $text_parent_select5 = __( 'h2タグで囲む', 'dg-style' );
    $text_parent_select6 = __( 'h3タグで囲む', 'dg-style' );
    $text_parent_select7 = __( 'h4タグで囲む', 'dg-style' );
    $text_parent_select8 = __( 'h5タグで囲む', 'dg-style' );
    $text_parent_select9 = __( 'h6タグで囲む', 'dg-style' );
    $text_more_title = __( 'さらに設定追加', 'dg-style' );
    $text_rel_title = __( 'rel設定', 'dg-style' );
    $text_aria_label_title = __( 'Aria-label設定', 'dg-style' );
    $text_toggle_more_title = __( 'トーグル設定', 'dg-style' );
    $text_toggle_type_title = __( 'トーグルタイプ', 'dg-style' );
    $text_toggle_tab1 = __( '通常', 'dg-style' );
    $text_toggle_tab2 = __( 'ダークモード', 'dg-style' );
    $text_toggle_tab3 = __( 'ABテスト', 'dg-style' );
    $text_toggle_target_title = __( 'トーグル先指定', 'dg-style' );
    $text_toggle_target_caution1 = __( '半角コンマ「,」で区切る', 'dg-style' );
    $text_toggle_target_caution2 = __( '「open」Classが追加されます。', 'dg-style' );
    $text_toggle_cookie_title = __( 'クッキー設定', 'dg-style' );
    $text_toggle_cookie_name = __( 'クッキー名', 'dg-style' );
    $text_toggle_cookie_placeholder = __( '半角英数字', 'dg-style' );
    $text_toggle_cookie_save = __( 'クッキー保存期間', 'dg-style' );
    $text_toggle_cookie_select1 = __( '分', 'dg-style' );
    $text_toggle_cookie_select2 = __( '時', 'dg-style' );
    $text_toggle_cookie_select3 = __( '日', 'dg-style' );
    $text_toggle_cookie_select4 = __( '週', 'dg-style' );
    $text_toggle_cookie_select5 = __( '月', 'dg-style' );
    $text_toggle_cookie_caution = __( '期間がない場合は、ブラウザの仕様に従います。', 'dg-style' );
    $text_toggle_dark_caution = __( 'bodyへ「whitemode」「darkmode」Classが切り替わります。', 'dg-style' );
    $text_toggle_test_title = __( '切り替えデザイン選択', 'dg-style' );
    $text_toggle_test_caution = __( '現在ページを指定したテストデザインに表示します。', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    
    return <<< EOM
        <div id="option-text" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_input_title}</div>
                            <textarea class="set-value insert-set-value" data-level="text" rows="5"></textarea>
                            <div class="window-title">{$text_inner_tag_title}</div>
                            <select class="set-value insert-set-value" data-level="span">
                                <option value="">{$text_inner_tag1}</option>
                                <option value="1">{$text_inner_tag2}</option>
                                <option value="2">{$text_inner_tag3}</option>
                            </select>
                            <div class="window-title">{$text_tag_select_title}</div>
                            <div class="tab-inner">
                                <div class="tab-list option-labels flex">
                                    <label class="tab-label option-label on"><input type="radio" name="text-tag-type" value="p" class="set-value none-display insert-set-value" data-level="tag" checked><span class="toggle-label">p</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="text-tag-type" value="h1" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">h1</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="text-tag-type" value="h2" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">h2</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="text-tag-type" value="h3" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">h3</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="text-tag-type" value="h4" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">h4</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="text-tag-type" value="h5" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">h5</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="text-tag-type" value="h6" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">h6</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="text-tag-type" value="a" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">a</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="text-tag-type" value="button" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">button</span></label>
                                </div>
                                <div class="tab-contents option-contents">
                                    <div class="tab-content on"></div>
                                    <div class="tab-content"></div>
                                    <div class="tab-content"></div>
                                    <div class="tab-content"></div>
                                    <div class="tab-content"></div>
                                    <div class="tab-content"></div>
                                    <div class="tab-content"></div>
                                    <div class="tab-content">
                                        <div class="window-title">{$text_link_input_title}</div>
                                        <div class="tab-inner">
                                            <div class="tab-list option-labels flex">
                                                <label class="tab-label option-label on"><input type="radio" name="text-link-type" value="1" class="set-value none-display" data-level="lt" checked><span class="toggle-label">{$text_link_select1}</span></label>
                                                <label class="tab-label option-label"><input type="radio" name="text-link-type" value="2" class="set-value none-display" data-level="lt"><span class="toggle-label">{$text_link_select2}</span></label>
                                            </div>
                                            <div class="tab-contents option-contents">
                                                <div class="tab-content on">
                                                    <div class="window-title">{$text_url_input_title}</div>
                                                    <input type="text" class="set-value insert-set-value" data-level="link">
                                                </div>
                                                <div class="tab-content">
                                                    <div class="window-title">{$text_url_search_title}</div>
                                                    <div class="search-page-link-area">
                                                        <button type="button" class="search-page-link-btn">{$text_url_search_btn}</button>
                                                        <input type="hidden" class="set-value search-page-link-input" data-level="pl">
                                                    </div>
                                                    <div class="window-title">{$text_url_search_parm}</div>
                                                    <input type="text" class="set-value" data-level="pram">
                                                </div>
                                            </div>
                                        </div>
                                        <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="new-tab"><span class="check-name">{$text_url_newtab}</span><span class="check-button"></span></label>
                                        <div class="window-title">{$text_parent_tag_title}</div>
                                        <select class="set-value insert-set-value" data-level="parent">
                                            <option value="">{$text_parent_select1}</option>
                                            <option value="p">{$text_parent_select2}</option>
                                            <option value="div">{$text_parent_select3}</option>
                                            <option value="h1">{$text_parent_select4}</option>
                                            <option value="h2">$text_parent_select5</option>
                                            <option value="h3">{$text_parent_select6}</option>
                                            <option value="h4">{$text_parent_select7}</option>
                                            <option value="h5">{$text_parent_select8}</option>
                                            <option value="h6">{$text_parent_select9}</option>
                                        </select>
                                        <div class="accordion-area also-accordion-area">
                                            <button type="button" class="accordion-title also-accordion-title">{$text_toggle_more_title}</button>
                                            <div class="accordion-content also-accordion-content">
                                                <div class="window-title">{$text_toggle_target_title}</div>
                                                <div class="toggle-name-input-area">
                                                    <input type="text" class="set-value insert-set-value toggle-name-input" data-level="toggle-item">
                                                </div>
                                                <p class="caution">※{$text_toggle_target_caution1}<br>※{$text_toggle_target_caution2}</p>
                                                <div class="window-title">{$text_toggle_cookie_title}</div>
                                                <div class="movie-range-area mb10">
                                                    <span class="text">{$text_toggle_cookie_name}：</span>
                                                    <input type="text" class="set-value insert-set-value" data-level="cookie-name" placeholder="{$text_toggle_cookie_placeholder}">
                                                </div>
                                                <div class="movie-range-area">
                                                    <span class="text">{$text_toggle_cookie_save}：</span>
                                                    <input type="number" class="set-value insert-set-value" data-level="cookie-date">
                                                    <select class="set-value insert-set-value" data-level="cookie-unit">
                                                        <option value="1">{$text_toggle_cookie_select1}</option>
                                                        <option value="2">{$text_toggle_cookie_select2}</option>
                                                        <option value="3">{$text_toggle_cookie_select3}</option>
                                                        <option value="4">{$text_toggle_cookie_select4}</option>
                                                        <option value="5">{$text_toggle_cookie_select5}</option>
                                                    </select>
                                                </div>
                                                <p class="caution">※{$text_toggle_cookie_caution}</p>
                                            </div>
                                        </div>
                                        <div class="accordion-area also-accordion-area">
                                            <button type="button" class="accordion-title also-accordion-title">{$text_more_title}</button>
                                            <div class="accordion-content also-accordion-content">
                                                <div class="window-title">{$text_rel_title}</div>
                                                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="nofollow"><span class="check-name">nofollow</span><span class="check-button"></span></label>
                                                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="noreferrer"><span class="check-name">noreferrer</span><span class="check-button"></span></label>
                                                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="prefetch"><span class="check-name">prefetch</span><span class="check-button"></span></label>
                                                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="ugc"><span class="check-name">ugc</span><span class="check-button"></span></label>
                                                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="sponsored"><span class="check-name">sponsored</span><span class="check-button"></span></label>
                                                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="alternate"><span class="check-name">alternate</span><span class="check-button"></span></label>
                                                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="author"><span class="check-name">author</span><span class="check-button"></span></label>
                                                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="bookmark"><span class="check-name">bookmark</span><span class="check-button"></span></label>
                                                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="help"><span class="check-name">help</span><span class="check-button"></span></label>
                                                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="license"><span class="check-name">license</span><span class="check-button"></span></label>
                                                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="search"><span class="check-name">search</span><span class="check-button"></span></label>
                                                <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="post-tag"><span class="check-name">tag</span><span class="check-button"></span></label>
                                                <div class="window-title">{$text_aria_label_title}</div>
                                                <input type="text" class="set-value insert-set-value" data-level="aria-label">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-content">
                                        <div class="window-title">{$text_toggle_type_title}</div>
                                        <div class="tab-inner">
                                            <div class="tab-list option-labels flex">
                                                <label class="tab-label option-label on"><input type="radio" name="text-toggle-button-type" value="1" class="set-value none-display insert-set-value" data-level="toggle-type" checked><span class="toggle-label">{$text_toggle_tab1}</span></label>
                                                <label class="tab-label option-label"><input type="radio" name="text-toggle-button-type" value="2" class="set-value none-display insert-set-value" data-level="toggle-type"><span class="toggle-label">{$text_toggle_tab2}</span></label>
                                                <label class="tab-label option-label"><input type="radio" name="text-toggle-button-type" value="3" class="set-value none-display insert-set-value" data-level="toggle-type"><span class="toggle-label">{$text_toggle_tab3}</span></label>
                                            </div>
                                            <div class="tab-contents option-contents">
                                                <div class="tab-content on">
                                                    <div class="window-title">{$text_toggle_target_title}</div>
                                                    <div class="toggle-name-input-area">
                                                        <input type="text" class="set-value insert-set-value toggle-name-input" data-level="toggle-item">
                                                    </div>
                                                    <p class="caution">※{$text_toggle_target_caution1}<br>※{$text_toggle_target_caution2}</p>
                                                    <div class="window-title">{$text_toggle_cookie_title}</div>
                                                    <div class="movie-range-area mb10">
                                                        <span class="text">{$text_toggle_cookie_name}：</span>
                                                        <input type="text" class="set-value insert-set-value" data-level="cookie-name" placeholder="{$text_toggle_cookie_placeholder}">
                                                    </div>
                                                    <div class="movie-range-area">
                                                        <span class="text">{$text_toggle_cookie_save}：</span>
                                                        <input type="number" class="set-value insert-set-value" data-level="cookie-date">
                                                        <select class="set-value insert-set-value" data-level="cookie-unit">
                                                            <option value="1">{$text_toggle_cookie_select1}</option>
                                                            <option value="2">{$text_toggle_cookie_select2}</option>
                                                            <option value="3">{$text_toggle_cookie_select3}</option>
                                                            <option value="4">{$text_toggle_cookie_select4}</option>
                                                            <option value="5">{$text_toggle_cookie_select5}</option>
                                                        </select>
                                                    </div>
                                                    <p class="caution">※{$text_toggle_cookie_caution}</p>
                                                </div>
                                                <div class="tab-content">
                                                    <p class="caution">※{$text_toggle_dark_caution}</p>
                                                </div>
                                                <div class="tab-content">
                                                    <div class="window-title">{$text_toggle_test_title}</div>
                                                    <select class="set-value insert-set-value abtest-select" data-level="testab">
                                                    </select>
                                                    <p class="caution">※{$text_toggle_test_caution}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="window-title">{$text_aria_label_title}</div>
                                        <input type="text" class="set-value insert-set-value" data-level="aria-label">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * イメージ
*/
function option_window_image( $logo_value ) {
    //PCロゴ
    $pc_logo = '';
    $sp_logo = '';
    if ( isset( $logo_value[ 'pc' ][ 'src' ] ) && $logo_value[ 'pc' ][ 'src' ] !== '' ) {
        $pc_logo = '<img id="pc-logo-img" src="' . $logo_value[ 'pc' ][ 'src' ] . '">';
    }
    //SPロゴ
    if ( isset( $logo_value[ 'sp' ][ 'src' ] ) && $logo_value[ 'sp' ][ 'src' ] !== '' ) {
        $sp_logo = '<img id="sp-logo-img" src="' . $logo_value[ 'sp' ][ 'src' ] . '">';
    }
    //翻訳
    $text_menu_title = __( 'イメージ', 'dg-style' );
    $text_menu_tab1 = __( 'イメージ設定', 'dg-style' );
    $text_menu_tab2 = __( 'その他', 'dg-style' );
    $text_image_select_title = __( 'イメージ選択', 'dg-style' );
    $text_image_tab3 = __( 'PCロゴ', 'dg-style' );
    $text_image_tab4 = __( 'SPロゴ', 'dg-style' );
    $text_image_tab5 = __( '固定', 'dg-style' );
    $text_image_delete = __( '削除', 'dg-style' );
    $text_image_size_title = __( 'イメージサイズ', 'dg-style' );
    $text_image_size_caution = __( '指定したサイズがない場合はfullサイズで表示されます。', 'dg-style' );
    $text_image_srcset = __( 'srcsetにする', 'dg-style' );
    $text_image_srcset_caution = __( 'srcsetにする場合、サイズの選択は無効になります。', 'dg-style' );
    $text_image_url_title = __( 'イメージURL', 'dg-style' );
    $text_image_alt_title = __( 'イメージ説明', 'dg-style' );
    $text_imagetag_size = __( 'イメージタグサイズ', 'dg-style' );
    
    $text_tag_select_title = __( 'タグ指定', 'dg-style' );
    $text_link_input_title = __( 'リンク先指定', 'dg-style' );
    $text_link_select1 = __( '直書き', 'dg-style' );
    $text_link_select2 = __( '内部リンク', 'dg-style' );
    $text_url_input_title = __( 'URL入力', 'dg-style' );
    $text_url_search_title = __( 'URL検索', 'dg-style' );
    $text_url_search_btn = __( 'ページ検索', 'dg-style' );
    $text_url_search_parm = __( 'URLパラメータ追加', 'dg-style' );
    $text_url_newtab = __( '新しいタブで開く', 'dg-style' );
    $text_parent_tag_title = __( '親タグ追加', 'dg-style' );
    $text_parent_select1 = __( '親タグなし', 'dg-style' );
    $text_parent_select2 = __( 'pタグで囲む', 'dg-style' );
    $text_parent_select3 = __( 'divタグで囲む', 'dg-style' );
    $text_parent_select4 = __( 'h1タグで囲む', 'dg-style' );
    $text_parent_select5 = __( 'h2タグで囲む', 'dg-style' );
    $text_parent_select6 = __( 'h3タグで囲む', 'dg-style' );
    $text_parent_select7 = __( 'h4タグで囲む', 'dg-style' );
    $text_parent_select8 = __( 'h5タグで囲む', 'dg-style' );
    $text_parent_select9 = __( 'h6タグで囲む', 'dg-style' );
    $text_more_title = __( 'さらに設定追加', 'dg-style' );
    $text_toggle_more_title = __( 'トーグル設定', 'dg-style' );
    $text_rel_title = __( 'rel設定', 'dg-style' );
    $text_aria_label_title = __( 'Aria-label設定', 'dg-style' );
    $text_toggle_type_title = __( 'トーグルタイプ', 'dg-style' );
    $text_toggle_tab1 = __( '通常', 'dg-style' );
    $text_toggle_tab2 = __( 'ダークモード', 'dg-style' );
    $text_toggle_tab3 = __( 'ABテスト', 'dg-style' );
    $text_toggle_target_title = __( 'トーグル先指定', 'dg-style' );
    $text_toggle_target_caution1 = __( '半角コンマ「,」で区切る', 'dg-style' );
    $text_toggle_target_caution2 = __( '「open」Classが追加されます。', 'dg-style' );
    $text_toggle_cookie_title = __( 'クッキー設定', 'dg-style' );
    $text_toggle_cookie_name = __( 'クッキー名', 'dg-style' );
    $text_toggle_cookie_placeholder = __( '半角英数字', 'dg-style' );
    $text_toggle_cookie_save = __( 'クッキー保存期間', 'dg-style' );
    $text_toggle_cookie_select1 = __( '分', 'dg-style' );
    $text_toggle_cookie_select2 = __( '時', 'dg-style' );
    $text_toggle_cookie_select3 = __( '日', 'dg-style' );
    $text_toggle_cookie_select4 = __( '週', 'dg-style' );
    $text_toggle_cookie_select5 = __( '月', 'dg-style' );
    $text_toggle_cookie_caution = __( '期間がない場合は、ブラウザの仕様に従います。', 'dg-style' );
    $text_toggle_dark_caution = __( 'bodyへ「whitemode」「darkmode」Classが切り替わります。', 'dg-style' );
    $text_toggle_test_title = __( '切り替えデザイン選択', 'dg-style' );
    $text_toggle_test_caution = __( '現在ページを指定したテストデザインに表示します。', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-image" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_image_select_title}</div>
                                <div class="tab-inner image-select-tabs">
                                    <div class="tab-list option-labels image-labels">
                                        <label class="tab-label option-label on"><input type="radio" name="image-type" value="1" class="set-value none-display insert-set-value" data-level="image-type"><span class="toggle-label">WP</span></label>
                                        <label class="tab-label option-label"><input type="radio" name="image-type" value="2" class="set-value none-display insert-set-value" data-level="image-type"><span class="toggle-label">URL</span></label>
                                        <label class="tab-label option-label"><input type="radio" name="image-type" value="3" class="set-value none-display insert-set-value" data-level="image-type"><span class="toggle-label">{$text_image_tab3}</span></label>
                                        <label class="tab-label option-label"><input type="radio" name="image-type" value="4" class="set-value none-display insert-set-value" data-level="image-type"><span class="toggle-label">{$text_image_tab4}</span></label>
                                        <label class="tab-label option-label"><input type="radio" name="image-type" value="5" class="set-value none-display insert-set-value" data-level="image-type"><span class="toggle-label">{$text_image_tab5}</span></label>
                                    </div>
                                    <div class="tab-contents option-contents">
                                        <div class="tab-content on">
                                            <div class="image-box">
                                                <a href="#" class="img-upload-btn ui-btn">{$text_image_select_title}</a><a class="img-remove-btn ui-btn">{$text_image_delete}</a>
                                                <input type="hidden" class="set-value image-url" data-level="image-url">
                                            </div>
                                            <div class="window-title">{$text_image_size_title}</div>
                                            <select class="set-value" data-level="size">
                                                <option value="thumbnail">thumbnail</option>
                                                <option value="medium">medium</option>
                                                <option value="large">large</option>
                                                <option value="full">full</option>
                                            </select>
                                            <p class="caution">※{$text_image_size_caution}</p>
                                            <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="srcset"><span class="check-name">{$text_image_srcset}</span><span class="check-button"></span></label>
                                            <p class="caution">※{$text_image_srcset_caution}</p>
                                        </div>
                                        <div class="tab-content">
                                            <div class="window-title">{$text_image_url_title}</div>
                                            <input type="text" class="set-value image-url-value insert-set-value" data-level="image-url">
                                            <div class="image-simulator"></div>
                                        </div>
                                        <div id="pc-logo-image-inner" class="tab-content logo-image-inner">{$pc_logo}</div>
                                        <div id="sp-logo-image-inner" class="tab-content logo-image-inner">{$sp_logo}</div>
                                        <div class="tab-content">
                                            <div id="fixed-image-inner" class="fixed-image-inner"></div>
                                            <div class="window-title">{$text_image_size_title}</div>
                                            <select class="set-value" data-level="size">
                                                <option value="thumbnail">thumbnail</option>
                                                <option value="medium">medium</option>
                                                <option value="large">large</option>
                                                <option value="full">full</option>
                                            </select>
                                            <p class="caution">※{$text_image_size_caution}</p>
                                            <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="srcset"><span class="check-name">{$text_image_srcset}</span><span class="check-button"></span></label>
                                            <p class="caution">※{$text_image_srcset_caution}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="window-title">{$text_image_alt_title}</div>
                                <input type="text" class="set-value insert-set-value" data-level="image-alt">
                                <div class="window-title">{$text_imagetag_size}</div>
                                <div class="movie-range-area">
                                    <input type="number" class="set-value insert-set-value" data-level="width" placeholder="300">
                                    <span class="text">×</span>
                                    <input type="number" class="set-value insert-set-value" data-level="height" placeholder="300">
                                </div>
                                <div class="window-title">{$text_tag_select_title}</div>
                                <div class="tab-inner">
                                    <div class="tab-list option-labels flex">
                                        <label class="tab-label option-label on"><input type="radio" name="image-tag-type" value="div" class="set-value none-display insert-set-value" data-level="tag" checked><span class="toggle-label">div</span></label>
                                        <label class="tab-label option-label"><input type="radio" name="image-tag-type" value="h1" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">h1</span></label>
                                        <label class="tab-label option-label"><input type="radio" name="image-tag-type" value="h2" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">h2</span></label>
                                        <label class="tab-label option-label"><input type="radio" name="image-tag-type" value="h3" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">h3</span></label>
                                        <label class="tab-label option-label"><input type="radio" name="image-tag-type" value="h4" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">h4</span></label>
                                        <label class="tab-label option-label"><input type="radio" name="image-tag-type" value="h5" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">h5</span></label>
                                        <label class="tab-label option-label"><input type="radio" name="image-tag-type" value="h6" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">h6</span></label>
                                        <label class="tab-label option-label"><input type="radio" name="image-tag-type" value="p" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">p</span></label>
                                        <label class="tab-label option-label"><input type="radio" name="image-tag-type" value="a" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">a</span></label>
                                        <label class="tab-label option-label"><input type="radio" name="image-tag-type" value="button" class="set-value none-display insert-set-value" data-level="tag"><span class="toggle-label">button</span></label>
                                    </div>
                                    <div class="tab-contents option-contents">
                                        <div class="tab-content on"></div>
                                        <div class="tab-content"></div>
                                        <div class="tab-content"></div>
                                        <div class="tab-content"></div>
                                        <div class="tab-content"></div>
                                        <div class="tab-content"></div>
                                        <div class="tab-content"></div>
                                        <div class="tab-content"></div>
                                        <div class="tab-content">
                                            <div class="window-title">{$text_link_input_title}</div>
                                            <div class="tab-inner">
                                                <div class="tab-list option-labels flex">
                                                    <label class="tab-label option-label on"><input type="radio" name="image-link-type" value="1" class="set-value none-display" data-level="lt" checked><span class="toggle-label">{$text_link_select1}</span></label>
                                                    <label class="tab-label option-label"><input type="radio" name="image-link-type" value="2" class="set-value none-display" data-level="lt"><span class="toggle-label">{$text_link_select2}</span></label>
                                                </div>
                                                <div class="tab-contents option-contents">
                                                    <div class="tab-content on">
                                                        <div class="window-title">{$text_url_input_title}</div>
                                                        <input type="text" class="set-value insert-set-value" data-level="link">
                                                    </div>
                                                    <div class="tab-content">
                                                        <div class="window-title">{$text_url_search_title}</div>
                                                        <div class="search-page-link-area">
                                                            <button type="button" class="search-page-link-btn">{$text_url_search_btn}</button>
                                                            <input type="hidden" class="set-value search-page-link-input" data-level="pl">
                                                        </div>
                                                        <div class="window-title">{$text_url_search_parm}</div>
                                                        <input type="text" class="set-value" data-level="pram">
                                                    </div>
                                                </div>
                                            </div>
                                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="new-tab"><span class="check-name">{$text_url_newtab}</span><span class="check-button"></span></label>
                                            <div class="window-title">{$text_parent_tag_title}</div>
                                            <select class="set-value insert-set-value" data-level="parent">
                                                <option value="">{$text_parent_select1}</option>
                                                <option value="p">{$text_parent_select2}</option>
                                                <option value="div">{$text_parent_select3}</option>
                                                <option value="h1">{$text_parent_select4}</option>
                                                <option value="h2">$text_parent_select5</option>
                                                <option value="h3">{$text_parent_select6}</option>
                                                <option value="h4">{$text_parent_select7}</option>
                                                <option value="h5">{$text_parent_select8}</option>
                                                <option value="h6">{$text_parent_select9}</option>
                                            </select>
                                            <div class="accordion-area also-accordion-area">
                                                <button type="button" class="accordion-title also-accordion-title">{$text_toggle_more_title}</button>
                                                <div class="accordion-content also-accordion-content">
                                                    <div class="window-title">{$text_toggle_target_title}</div>
                                                    <div class="toggle-name-input-area">
                                                        <input type="text" class="set-value insert-set-value toggle-name-input" data-level="toggle-item">
                                                    </div>
                                                    <p class="caution">※{$text_toggle_target_caution1}<br>※{$text_toggle_target_caution2}</p>
                                                    <div class="window-title">{$text_toggle_cookie_title}</div>
                                                    <div class="movie-range-area mb10">
                                                        <span class="text">{$text_toggle_cookie_name}：</span>
                                                        <input type="text" class="set-value insert-set-value" data-level="cookie-name" placeholder="{$text_toggle_cookie_placeholder}">
                                                    </div>
                                                    <div class="movie-range-area">
                                                        <span class="text">{$text_toggle_cookie_save}：</span>
                                                        <input type="number" class="set-value insert-set-value" data-level="cookie-date">
                                                        <select class="set-value insert-set-value" data-level="cookie-unit">
                                                            <option value="1">{$text_toggle_cookie_select1}</option>
                                                            <option value="2">{$text_toggle_cookie_select2}</option>
                                                            <option value="3">{$text_toggle_cookie_select3}</option>
                                                            <option value="4">{$text_toggle_cookie_select4}</option>
                                                            <option value="5">{$text_toggle_cookie_select5}</option>
                                                        </select>
                                                    </div>
                                                    <p class="caution">※{$text_toggle_cookie_caution}</p>
                                                </div>
                                            </div>
                                            <div class="accordion-area also-accordion-area">
                                                <button type="button" class="accordion-title also-accordion-title">{$text_more_title}</button>
                                                <div class="accordion-content also-accordion-content">
                                                    <div class="window-title">{$text_rel_title}</div>
                                                    <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="nofollow"><span class="check-name">nofollow</span><span class="check-button"></span></label>
                                                    <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="noreferrer"><span class="check-name">noreferrer</span><span class="check-button"></span></label>
                                                    <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="prefetch"><span class="check-name">prefetch</span><span class="check-button"></span></label>
                                                    <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="ugc"><span class="check-name">ugc</span><span class="check-button"></span></label>
                                                    <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="sponsored"><span class="check-name">sponsored</span><span class="check-button"></span></label>
                                                    <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="alternate"><span class="check-name">alternate</span><span class="check-button"></span></label>
                                                    <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="author"><span class="check-name">author</span><span class="check-button"></span></label>
                                                    <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="bookmark"><span class="check-name">bookmark</span><span class="check-button"></span></label>
                                                    <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="help"><span class="check-name">help</span><span class="check-button"></span></label>
                                                    <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="license"><span class="check-name">license</span><span class="check-button"></span></label>
                                                    <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="search"><span class="check-name">search</span><span class="check-button"></span></label>
                                                    <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="post-tag"><span class="check-name">tag</span><span class="check-button"></span></label>
                                                    <div class="window-title">{$text_aria_label_title}</div>
                                                    <input type="text" class="set-value insert-set-value" data-level="aria-label">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-content">
                                            <div class="window-title">{$text_toggle_type_title}</div>
                                            <div class="tab-inner">
                                                <div class="tab-list option-labels flex">
                                                    <label class="tab-label option-label on"><input type="radio" name="text-toggle-button-type" value="1" class="set-value none-display insert-set-value" data-level="toggle-type" checked><span class="toggle-label">{$text_toggle_tab1}</span></label>
                                                    <label class="tab-label option-label"><input type="radio" name="text-toggle-button-type" value="2" class="set-value none-display insert-set-value" data-level="toggle-type"><span class="toggle-label">{$text_toggle_tab2}</span></label>
                                                    <label class="tab-label option-label"><input type="radio" name="text-toggle-button-type" value="3" class="set-value none-display insert-set-value" data-level="toggle-type"><span class="toggle-label">{$text_toggle_tab3}</span></label>
                                                </div>
                                                <div class="tab-contents option-contents">
                                                    <div class="tab-content on">
                                                        <div class="window-title">{$text_toggle_target_title}</div>
                                                        <div class="toggle-name-input-area">
                                                            <input type="text" class="set-value insert-set-value toggle-name-input" data-level="toggle-item">
                                                        </div>
                                                        <p class="caution">※{$text_toggle_target_caution1}<br>※{$text_toggle_target_caution2}</p>
                                                        <div class="window-title">{$text_toggle_cookie_title}</div>
                                                        <div class="movie-range-area mb10">
                                                            <span class="text">{$text_toggle_cookie_name}：</span>
                                                            <input type="text" class="set-value insert-set-value" data-level="cookie-name" placeholder="{$text_toggle_cookie_placeholder}">
                                                        </div>
                                                        <div class="movie-range-area">
                                                            <span class="text">{$text_toggle_cookie_save}：</span>
                                                            <input type="number" class="set-value insert-set-value" data-level="cookie-date">
                                                            <select class="set-value insert-set-value" data-level="cookie-unit">
                                                                <option value="1">{$text_toggle_cookie_select1}</option>
                                                                <option value="2">{$text_toggle_cookie_select2}</option>
                                                                <option value="3">{$text_toggle_cookie_select3}</option>
                                                                <option value="4">{$text_toggle_cookie_select4}</option>
                                                                <option value="5">{$text_toggle_cookie_select5}</option>
                                                            </select>
                                                        </div>
                                                        <p class="caution">※{$text_toggle_cookie_caution}</p>
                                                    </div>
                                                    <div class="tab-content">
                                                        <p class="caution">※{$text_toggle_dark_caution}</p>
                                                    </div>
                                                    <div class="tab-content">
                                                        <div class="window-title">{$text_toggle_test_title}</div>
                                                        <select class="set-value insert-set-value abtest-select" data-level="testab">
                                                        </select>
                                                        <p class="caution">※{$text_toggle_test_caution}</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="window-title">{$text_aria_label_title}</div>
                                            <input type="text" class="set-value insert-set-value" data-level="aria-label">
                                        </div>
                                    </div>
                                </div>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * HTML
*/
function option_window_html() {
    /*$settings = array(
        'textarea_rows' => 15,
        'editor_class' => 'set-value',
        'tinymce' => false
    );
    ob_start();
    wp_editor( '', 'html-part-content', $settings );
    $data = ob_get_contents();
    ob_end_clean();*/
    //翻訳
    $text_menu_tab1 = __( '基本設定', 'dg-style' );
    $text_menu_tab2 = __( 'その他', 'dg-style' );
    $text_option_title1 = __( '内容入力', 'dg-style' );
    $text_option_title2 = __( 'パーツタグ設定', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-html" class="part-menu-window add-part-window insert-part-area">
            <div class="window-header">
                <div class="window-name">HTML</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_option_title1}</div>
                            <div id="code-mirror-resize">
                            <textarea class="set-value insert-set-value" id="html-part-content" data-level="content" rows="15"></textarea>
                            </div>
                            <div class="window-title">{$text_option_title2}</div>
                            <select class="set-value insert-set-value" data-level="tag">
                                <option value="">div</option>
                                <option value="h1">h1</option>
                                <option value="h2">h2</option>
                                <option value="h3">h3</option>
                                <option value="h4">h4</option>
                                <option value="h5">h5</option>
                                <option value="h6">h6</option>
                                <option value="p">p</option>
                                <option value="article">article</option>
                                <option value="aside">aside</option>
                                <option value="nav">nav</option>
                                <option value="section">section</option>
                            </select>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                            <div class="window-title">Lazy Load</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value insert-set-value" value="1" data-level="lazy"><span class="check-name">Lazy Load</span><span class="check-button"></span></label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 動画
*/
function option_window_movie() {
    //翻訳
    $text_menu_title = __( '動画', 'dg-style' );
    $text_menu_tab1 = __( '動画選択', 'dg-style' );
    $text_menu_tab2 = __( '動画オプション', 'dg-style' );
    $text_menu_tab3 = __( 'その他', 'dg-style' );
    $text_movie_tab1 = __( 'WP動画', 'dg-style' );
    $text_movie_tab2 = __( '動画URL', 'dg-style' );
    $text_delete = __( '削除', 'dg-style' );
    $text_movie_thumb_select_title = __( '動画サムネイル選択', 'dg-style' );
    $text_image_tab1 = __( 'WPイメージ', 'dg-style' );
    $text_image_tab2 = __( 'イメージURL', 'dg-style' );
    $text_image_btn = __( 'イメージ選択', 'dg-style' );
    $text_movie_option1 = __( '自動再生', 'dg-style' );
    $text_movie_option2 = __( '繰り返し再生', 'dg-style' );
    $text_movie_option3 = __( 'インターフェース表示', 'dg-style' );
    $text_movie_option4 = __( '消音', 'dg-style' );
    $text_movie_option5 = __( 'preload設定', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    
    return <<< EOM
        <div id="option-movie" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_menu_tab1}</div>
                            <div class="tab-inner movie-select-tabs">
                                <div class="tab-list option-labels flex">
                                    <label class="tab-label option-label on"><input type="radio" name="movie-type" value="1" class="set-value none-display" data-level="movie-type"><span class="toggle-label">{$text_movie_tab1}</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="movie-type" value="2" class="set-value none-display" data-level="movie-type"><span class="toggle-label">{$text_movie_tab2}</span></label>
                                </div>
                                <div class="tab-contents option-contents">
                                    <div class="tab-content on">
                                        <div class="image-box">
                                            <a href="#" class="img-upload-btn ui-btn movie-btn">{$text_menu_tab1}</a><a class="img-remove-btn ui-btn">{$text_delete}</a>
                                            <input type="hidden" class="set-value image-url" data-level="movie-url">
                                        </div>
                                    </div>
                                    <div class="tab-content">
                                        <div class="window-title">{$text_movie_tab2}</div>
                                        <input type="text" class="set-value image-url-value movie" data-level="movie-url">
                                        <div class="movie-simulator"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="window-title">{$text_movie_thumb_select_title}</div>
                            <div class="tab-inner movie-select-tabs">
                                <div class="tab-list option-labels flex">
                                    <label class="tab-label option-label on"><input type="radio" name="movie-image-type" value="1" class="set-value none-display" data-level="image-type"><span class="toggle-label">{$text_image_tab1}</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="movie-image-type" value="2" class="set-value none-display" data-level="image-type"><span class="toggle-label">{$text_image_tab2}</span></label>
                                </div>
                                <div class="tab-contents option-contents">
                                    <div class="tab-content on">
                                        <div class="image-box">
                                            <a href="#" class="img-upload-btn ui-btn">{$text_image_btn}</a><a class="img-remove-btn ui-btn">{$text_delete}</a>
                                            <input type="hidden" class="set-value image-url" data-level="image-url">
                                        </div>
                                    </div>
                                    <div class="tab-content">
                                        <div class="window-title">{$text_image_tab2}</div>
                                        <input type="text" class="set-value image-url-value" data-level="image-url">
                                        <div class="image-simulator"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_menu_tab2}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="autoplay"><span class="check-name">{$text_movie_option1}</span><span class="check-button"></span></label>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="loop"><span class="check-name">{$text_movie_option2}</span><span class="check-button"></span></label>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="controls"><span class="check-name">{$text_movie_option3}</span><span class="check-button"></span></label>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="muted"><span class="check-name">{$text_movie_option4}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_movie_option5}</div>
                            <select class="set-value" data-level="preload">
                                <option value="">auto</option>
                                <option value="1">metadata</option>
                                <option value="2">none</option>
                            </select>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 音楽
*/
function option_window_music() {
    //翻訳
    $text_menu_title = __( '音楽', 'dg-style' );
    $text_menu_tab1 = __( '音楽選択', 'dg-style' );
    $text_menu_tab2 = __( '動画オプション', 'dg-style' );
    $text_music_title = __( '音楽選択', 'dg-style' );
    $text_music_tab1 = __( 'WP音楽', 'dg-style' );
    $text_music_tab2 = __( '音楽URL', 'dg-style' );
    $text_delete = __( '削除', 'dg-style' );
    $text_option_title = __( '音楽オプション', 'dg-style' );
    $text_option1 = __( '自動再生', 'dg-style' );
    $text_option2 = __( '繰り返し再生', 'dg-style' );
    $text_option3 = __( '消音', 'dg-style' );
    $text_option4 = __( 'preload設定', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    
    return <<< EOM
        <div id="option-music" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_music_title}</div>
                            <div class="tab-inner music-select-tabs">
                                <div class="tab-list option-labels flex">
                                    <label class="tab-label option-label on"><input type="radio" name="music-type" value="1" class="set-value none-display" data-level="music-type"><span class="toggle-label">{$text_music_tab1}</span></label>
                                    <label class="tab-label option-label"><input type="radio" name="music-type" value="2" class="set-value none-display" data-level="music-type"><span class="toggle-label">{$text_music_tab2}</span></label>
                                </div>
                                <div class="tab-contents option-contents">
                                    <div class="tab-content on">
                                        <div class="image-box">
                                            <a href="#" class="img-upload-btn ui-btn music-btn">{$text_music_title}</a><a class="img-remove-btn ui-btn">{$text_delete}</a>
                                            <input type="hidden" class="set-value image-url" data-level="music-url">
                                        </div>
                                    </div>
                                    <div class="tab-content">
                                        <div class="window-title">{$text_music_tab2}</div>
                                        <input type="text" class="set-value image-url-value music" data-level="music-url">
                                        <div class="image-simulator"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="window-title">{$text_option_title}</div>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="autoplay"><span class="check-name">{$text_option1}</span><span class="check-button"></span></label>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="loop"><span class="check-name">{$text_option2}</span><span class="check-button"></span></label>
                            <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="muted"><span class="check-name">{$text_option3}</span><span class="check-button"></span></label>
                            <div class="window-title">{$text_option4}</div>
                            <select class="set-value" data-level="preload">
                                <option value="">auto</option>
                                <option value="1">metadata</option>
                                <option value="2">none</option>
                            </select>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * カテゴリーリスト
*/
function option_window_categories() {
    //翻訳
    $text_item_link = __( 'リンク追加', 'dg-style' );
    $text_item_class = __( 'class指定', 'dg-style' );
    $text_image_tag_size = __( 'イメージタグサイズ', 'dg-style' );
    //表示アイテム
    $item_list = array(
        'title' => array(
            'name' => __( 'カテゴリータイトル', 'dg-style' ),
            'options' => array(
                'tag' => array( 'title' => __( 'タグ設定', 'dg-style' ), 'type' => 'select', 'list' => 'h2,h3,h4,h5,h6,strong,div,span,p', 'insert' => true, ),
                'link' => array( 'title' => $text_item_link, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'sub' => array(
            'name' => __( 'サブタイトル', 'dg-style' ),
            'options' => array(
                'class' => array( 'title' => $text_item_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'thumbnail' => array(
            'name' => __( 'サムネイル', 'dg-style' ),
            'options' => array(
                'thumbnail-size' => array( 'title' => __( 'サイズ', 'dg-style' ), 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_image_tag_size, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_item_link, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'movie' => array(
            'name' => __( '動画サムネイル', 'dg-style' ),
            'options' => array(
                'caution' => array( 'type' => 'caution', 'content' => '※' . __( 'サムネイルイメージが動画サムネイルとして利用されます。', 'dg-style' ), ),
                'thumbnail-size' => array( 'title' => __( '動画サムネイルサイズ', 'dg-style' ), 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_image_tag_size, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_item_link, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'fixed' => array(
            'name' => __( '固定サムネイル', 'dg-style' ),
            'options' => array(
                'thumbnail-size' => array( 'title' => __( 'サイズ', 'dg-style' ), 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_image_tag_size, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_item_link, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'content' => array(
            'name' => __( '説明文', 'dg-style' ),
            'options' => array(
                'count' => array( 'title' => __( '文字数', 'dg-style' ), 'type' => 'number', 'insert' => true, ),
                'after' => array( 'title' => __( '省略文字', 'dg-style' ), 'type' => 'text', 'placeholder' => __( '例）続きを読む', 'dg-style' ), 'insert' => true, ),
                'link' => array( 'title' => $text_item_link, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'more' => array(
            'name' => __( 'ページリンク', 'dg-style' ),
            'options' => array(
                'text' => array( 'title' => __( 'リンクテキスト', 'dg-style' ), 'type' => 'text', 'placeholder' => __( '例）ページを見る', 'dg-style' ), 'insert' => true, ),
                'class' => array( 'title' => $text_item_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
    );
    $post_item = option_windows_post_list_part( $item_list );
    $area_items = option_post_area_items( $post_item );
    $dynamic_class = option_dynamic_add_class();
    //タクソノミーリスト
    $term_list = get_terms_for_each_taxonomies();
    //翻訳
    $text_menu_title = __( 'カテゴリーリスト', 'dg-style' );
    $text_menu_tab1 = __( 'カテゴリー選択', 'dg-style' );
    $text_menu_tab2 = __( '各項目表示設定', 'dg-style' );
    $text_menu_tab3 = __( 'その他', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-categories" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">{$term_list}</div>
                        <div class="tab-content">
                            {$area_items}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                            {$dynamic_class}
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * タグクラウド
*/
function option_window_tag_cloud() {
    //タクソノミーリスト
    $list = '';
    $taxonomise = default_taxonomy_exclusion( array( 'category', 'post_tag' ) );
    foreach( (array)$taxonomise as $tax ) {
        $taxonomy = get_taxonomy( $tax );
        $list .= <<< EOM
            <li class="term-item">
                <div class="term-names">
                    <label class="term-label"><input type="checkbox" class="term-input" value="{$tax}">{$taxonomy->label}</label>
                </div>
            </li>
EOM;
    }
    $text_tax_title = __( 'タクソノミー選択', 'dg-style' );
    $taxonomy_list = <<< EOM
        <div class="check-value-inner">
            <div class="window-title">{$text_tax_title}</div>
            <ul class="parent-taxonomy-area parent-items-area select-terms-taxonomy" data-tax="taxonomy">
            {$list}
            </ul>
            <input type="hidden" class="check-value-summary set-value" data-level="taxonomy">
        </div>
EOM;
    //翻訳
    $text_menu_title = __( 'タグクラウド', 'dg-style' );
    $text_menu_tab1 = __( '基本設定', 'dg-style' );
    $text_menu_tab2 = __( 'その他', 'dg-style' );
    $text_option_title1 = __( '表示数', 'dg-style' );
    $text_option_title2 = __( '表示順', 'dg-style' );
    $text_option_select1 = __( 'タグ名', 'dg-style' );
    $text_option_select2 = __( '使用数', 'dg-style' );
    $text_option_title3 = __( 'ソート順', 'dg-style' );
    $text_option_select3 = __( '昇順', 'dg-style' );
    $text_option_select4 = __( '降順', 'dg-style' );
    $text_option_select5 = __( 'ランダム', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    
    return <<< EOM
        <div id="option-tag-cloud" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            {$taxonomy_list}
                            <div class="window-title">{$text_option_title1}</div>
                            <input type="number" class="set-value" data-level="number" placeholder="45">
                            <div class="window-title">{$text_option_title2}</div>
                            <select class="set-value" data-level="orderby">
                                <option value="name">{$text_option_select1}</option>
                                <option value="count">{$text_option_select2}</option>
                            </select>
                            <div class="window-title">{$text_option_title3}</div>
                            <select class="set-value" data-level="order">
                                <option value="ASC">{$text_option_select3}</option>
                                <option value="DESC">{$text_option_select4}</option>
                                <option value="RAND">{$text_option_select5}</option>
                            </select>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * アカイブ
*/
function option_window_archive() {
    //翻訳
    $text_menu_title = __( 'アカイブ', 'dg-style' );
    $text_option_title1 = __( '表示方法選択', 'dg-style' );
    $text_option_select1 = __( 'リスト表示', 'dg-style' );
    $text_option_select2 = __( 'セレクター', 'dg-style' );
    $text_option_title2 = __( '表示数', 'dg-style' );
    $text_option_placeholder = __( '空欄の場合はすべて表示', 'dg-style' );
    $text_option_post_label = __( '記事数表示', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    
    return <<< EOM
        <div id="option-archive" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_option_title1}</div>
                <select class="set-value" data-level="type">
                    <option value="1">{$text_option_select1}</option>
                    <option value="2">{$text_option_select2}</option>
                </select>
                <div class="window-title">{$text_option_title2}</div>
                <input type="number" class="set-value" data-level="limit" placeholder="{$text_option_placeholder}">
                <label class="check-toggle-label"><input type="checkbox" class="set-value" value="1" data-level="count"><span class="check-name">{$text_option_post_label}</span><span class="check-button"></span></label>
                <div class="window-title">{$text_add_class}</div>
                <input type="text" class="set-value insert-set-value" data-level="part-class">
            </div>
        </div>
EOM;
}

/*
 * サイトViews
*/
function option_window_site_views() {
    //翻訳
    $text_menu_title = __( 'サイトViews', 'dg-style' );
    $text_views1 = __( '全体', 'dg-style' );
    $text_views2 = __( '週間', 'dg-style' );
    $text_views3 = __( '月間', 'dg-style' );
    $text_views4 = __( '年間', 'dg-style' );
    $text_text_title = __( 'テキスト設定', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-site-views" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">表示する期間</div>
                <select class="set-value" data-level="type">
                    <option value="views">{$text_views1} views</option>
                    <option value="w_views">{$text_views2} views</option>
                    <option value="m_views">{$text_views3} views</option>
                    <option value="y_views">{$text_views4} views</option>
                </select>
                <div class="window-title">{$text_text_title}</div>
                <input type="text" class="set-value insert-set-value" data-level="text">
                <div class="window-title">{$text_add_class}</div>
                <input type="text" class="set-value insert-set-value" data-level="part-class">
            </div>
        </div>
EOM;
}

/*
 * 最新コメント
*/
function option_window_new_comments() {
    $text_item_count = __( '文字数', 'dg-style' );
    $text_item_after = __( '例）続きを読む', 'dg-style' );
    $text_item_link = __( 'リンク追加', 'dg-style' );
    $text_item_abb = __( '省略文字', 'dg-style' );
    $text_item_class = __( 'class指定', 'dg-style' );
    //表示アイテム
    $item_list = array(
        'title' => array(
            'name' => __( '記事タイトル', 'dg-style' ),
            'options' => array(
                'tag' => array( 'title' => __( 'タグ設定', 'dg-style' ), 'type' => 'select', 'list' => 'h2,h3,h4,h5,h6,strong,div,span,p', 'insert' => true, ),
                'count' => array( 'title' => $text_item_count, 'type' => 'number', 'insert' => true, ),
                'after' => array( 'title' => $text_item_abb, 'type' => 'text', 'placeholder' => $text_item_after, 'insert' => true, ),
                'link' => array( 'title' => $text_item_link, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'author' => array(
            'name' => __( '作成者', 'dg-style' ),
            'options' => array(
                'count' => array( 'title' => $text_item_count, 'type' => 'number', 'insert' => true, ),
                'after' => array( 'title' => $text_item_abb, 'type' => 'text', 'placeholder' => $text_item_after, 'insert' => true, ),
                'link' => array( 'title' => $text_item_link, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'comment' => array(
            'name' => __( 'コメント本文', 'dg-style' ),
            'options' => array(
                'count' => array( 'title' => $text_item_count, 'type' => 'number', 'insert' => true, ),
                'after' => array( 'title' => $text_item_abb, 'type' => 'text', 'placeholder' => $text_item_after, 'insert' => true, ),
                'link' => array( 'title' => $text_item_link, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'date' => array(
            'name' => __( '登録日', 'dg-style' ),
            'options' => array(
                'tag' => array( 'title' => __( 'タグ設定', 'dg-style' ), 'type' => 'select', 'list' => 'time,strong,div,span,p', 'insert' => true, ),
                'format' => array( 'title' => __( '日付表示フォーマット', 'dg-style' ), 'type' => 'text', 'placeholder' => __( '例）Y年m月d日', 'dg-style' ), 'insert' => true, ),
                'class' => array( 'title' => $text_item_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'more' => array(
            'name' => __( 'ページリンク', 'dg-style' ),
            'options' => array(
                'text' => array( 'title' => __( 'リンクテキスト', 'dg-style' ), 'type' => 'text', 'placeholder' => __( '例）ページを見る', 'dg-style' ), 'insert' => true, ),
                'class' => array( 'title' => $text_item_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
    );
    $post_item = option_windows_post_list_part( $item_list );
    $area_items = option_post_area_items( $post_item );
    $dynamic_class = option_dynamic_add_class();
    //翻訳
    $text_menu_title = __( '最新コメント', 'dg-style' );
    $text_menu_tab1 = __( '基本設定', 'dg-style' );
    $text_menu_tab2 = __( '各項目表示設定', 'dg-style' );
    $text_menu_tab3 = __( 'その他', 'dg-style' );
    $text_comment_count = __( '表示数', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    
    return <<< EOM
        <div id="option-new-comments" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">
                            <div class="window-title">{$text_comment_count}</div>
                            <input type="number" class="set-value" data-level="limit" placeholder="5" min="1">
                        </div>
                        <div class="tab-content">
                            {$area_items}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                            {$dynamic_class}
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 作成者情報
*/
function option_window_author() {
    //ユーザーリスト
    $user_list = '';
    $users = get_users( array( 'orderby' => 'ID','order'=> 'ASC' ) );
    if ( is_array( $users ) && count( $users ) > 0 ) {
        foreach( (array)$users as $user ) {
            $user_list .= <<< EOM
                <li class="term-item">
                    <div class="term-names">
                        <label class="term-label"><input type="checkbox" class="term-input" value="{$user->ID}">{$user->display_name}</label>
                    </div>
                </li>
EOM;
        }
    }
    $text_user_select = __( 'ユーザー選択', 'dg-style' );
    $user_list_select = <<< EOM
        <div class="check-value-inner">
            <div class="window-title">{$text_user_select}</div>
            <ul class="parent-taxonomy-area parent-items-area select-terms-users" data-tax="users">
            {$user_list}
            </ul>
            <input type="hidden" class="check-value-summary set-value" data-level="select-users">
        </div>
EOM;
    
    //表示アイテム
    $text_item_link_title = __( 'リンク追加', 'dg-style' );
    $text_item_class_title = __( 'class指定', 'dg-style' );
    $text_item_size_title = __( 'サイズ', 'dg-style' );
    $text_item_imagetag_size_title = __( 'イメージタグサイズ', 'dg-style' );
    $item_list = array(
        'name' => array(
            'name' => __( '作成者名', 'dg-style' ),
            'options' => array(
                'tag' => array( 'title' => __( 'タグ設定', 'dg-style' ), 'type' => 'select', 'list' => 'h2,h3,h4,h5,h6,strong,div,span,p', 'insert' => true, ),
                'link' => array( 'title' => $text_item_link_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'description' => array(
            'name' => __( '紹介文', 'dg-style' ),
            'options' => array(
                'count' => array( 'title' => __( '文字数', 'dg-style' ), 'type' => 'number', 'insert' => true, ),
                'after' => array( 'title' => __( '省略文字', 'dg-style' ), 'type' => 'text', 'placeholder' => __( '例）続きを読む', 'dg-style' ), 'insert' => true, ),
                'link' => array( 'title' => $text_item_link_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'gravatar' => array(
            'name' => __( 'プロフィール写真（Gravatar）', 'dg-style' ),
            'options' => array(
                'thumbnail-size' => array( 'title' => $text_item_size_title, 'type' => 'select', 'list' => '150,300,512', ),
                'link' => array( 'title' => $text_item_link_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'user_image' => array(
            'name' => __( 'ユーザーイメージ', 'dg-style' ),
            'options' => array(
                'thumbnail-size' => array( 'title' => $text_item_size_title, 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_item_imagetag_size_title, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_item_link_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'bg_image' => array(
            'name' => __( '背景イメージ', 'dg-style' ),
            'options' => array(
                'thumbnail-size' => array( 'title' => $text_item_size_title, 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_item_imagetag_size_title, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_item_link_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'movie_thumbnail' => array(
            'name' => __( '動画サムネイル', 'dg-style' ),
            'options' => array(
                'caution' => array( 'type' => 'caution', 'content' => '※' . __( 'サムネイルイメージが動画サムネイルとして利用されます。', 'dg-style' ), ),
                'thumbnail-type' => array( 'title' => __( 'サムネイル選択', 'dg-style' ), 'type' => 'select', 'list2' => array( 'user_image' => __( 'ユーザーイメージ', 'dg-style' ), 'bg_image' => __( '背景イメージ', 'dg-style' ), ), ),
                'thumbnail-size' => array( 'title' => __( '動画サムネイルサイズ', 'dg-style' ), 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_item_imagetag_size_title, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_item_link_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'fixed' => array(
            'name' => __( '固定サムネイル', 'dg-style' ),
            'options' => array(
                'thumbnail-size' => array( 'title' => __( 'サイズ', 'dg-style' ), 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_item_imagetag_size_title, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_item_link_title, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'user_sns' => array(
            'name' => __( 'SNS・連絡先', 'dg-style' ),
            'options' => array(
                'site' => array( 'title' => __( 'サイトURL', 'dg-style' ), 'type' => 'check', ),
                'mail' => array( 'title' => __( 'メールアドレス', 'dg-style' ), 'type' => 'check', ),
                'facebook' => array( 'title' => 'Facebook', 'type' => 'check', ),
                'twitter' => array( 'title' => 'Twitter', 'type' => 'check', ),
                'line' => array( 'title' => 'Line', 'type' => 'check', ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'more' => array(
            'name' => __( 'ページリンク', 'dg-style' ),
            'options' => array(
                'text' => array( 'title' => __( 'リンクテキスト', 'dg-style' ), 'type' => 'text', 'placeholder' => __( '例）ページを見る', 'dg-style' ), 'insert' => true, ),
                'class' => array( 'title' => $text_item_class_title, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
    );
    $post_item = option_windows_post_list_part( $item_list );
    $area_items = option_post_area_items( $post_item );
    $dynamic_class = option_dynamic_add_class();
    //翻訳
    $text_menu_title = __( '作成者プロフィール', 'dg-style' );
    $text_menu_tab1 = __( 'ユーザー選択', 'dg-style' );
    $text_menu_tab2 = __( '各項目表示設定', 'dg-style' );
    $text_menu_tab3 = __( 'その他', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    return <<< EOM
        <div id="option-author" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="tab-inner option-menu-inner">
                    <div class="tab-list option-menu-labels">
                        <button type="button" class="tab-label option-menu-label on"><span class="toggle-label">{$text_menu_tab1}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab2}</span></button>
                        <button type="button" class="tab-label option-menu-label"><span class="toggle-label">{$text_menu_tab3}</span></button>
                    </div>
                    <div class="tab-contents option-menu-contents">
                        <div class="tab-content on">{$user_list_select}</div>
                        <div class="tab-content">
                            {$area_items}
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_add_class}</div>
                            <input type="text" class="set-value insert-set-value" data-level="part-class">
                            {$dynamic_class}
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * ロゴ設定
*/
function common_window_logo( $logo_value, $option_value ) {
    $text_image_btn = __( 'イメージ選択', 'dg-style' );
    $text_image_delete = __( '削除', 'dg-style' );
    
    //PCロゴ
    $pc_logo_wp = '<a href="#" class="logo-upload-btn ui-btn">' . $text_image_btn . '</a><a class="logo-remove-btn ui-btn">' . $text_image_delete . '</a>';
    $pc_logo_img = '';
    $pc_logo_url = '';
    $pc_check1 = '';
    $pc_check2 = '';
    $pc_on1 = '';
    $pc_on2 = '';
    if ( !isset( $logo_value[ 'pc' ][ 'type' ] ) || isset( $logo_value[ 'pc' ][ 'type' ] ) && $logo_value[ 'pc' ][ 'type' ] === '1' ) {
        $pc_check1 = ' checked';
        $pc_check2 = '';
        $pc_on1 = ' on';
        $pc_on2 = '';
        if ( isset( $logo_value[ 'pc' ][ 'src' ] ) && $logo_value[ 'pc' ][ 'src' ] !== '' ) {
            $pc_logo_wp = '<a href="#" class="logo-upload-btn"><img src="' . $logo_value[ 'pc' ][ 'src' ] . '"></a><a class="logo-remove-btn ui-btn on">' . $text_image_delete . '</a>';
        }
    } elseif ( isset( $logo_value[ 'pc' ][ 'type' ] ) && $logo_value[ 'pc' ][ 'type' ] === '2' ) {
        $pc_check1 = '';
        $pc_check2 = ' checked';
        $pc_on1 = '';
        $pc_on2 = ' on';
        if ( isset( $logo_value[ 'pc' ][ 'src' ] ) && $logo_value[ 'pc' ][ 'src' ] !== '' ) {
            $pc_logo_img = '<img src="' . $logo_value[ 'pc' ][ 'src' ] . '">';
            $pc_logo_url = $logo_value[ 'pc' ][ 'src' ];
        }
    }
    //SPロゴ
    $sp_logo_wp = '<a href="#" class="logo-upload-btn ui-btn">' . $text_image_btn . '</a><a class="logo-remove-btn ui-btn">' . $text_image_delete . '</a>';
    $sp_logo_img = '';
    $sp_logo_url = '';
    $sp_check1 = '';
    $sp_check2 = '';
    $sp_on1 = '';
    $sp_on2 = '';
    if ( !isset( $logo_value[ 'sp' ][ 'type' ] ) || isset( $logo_value[ 'sp' ][ 'type' ] ) && $logo_value[ 'sp' ][ 'type' ] === '1' ) {
        $sp_check1 = ' checked';
        $sp_check2 = '';
        $sp_on1 = ' on';
        $sp_on2 = '';
        if ( isset( $logo_value[ 'sp' ][ 'src' ] ) && $logo_value[ 'sp' ][ 'src' ] !== '' ) {
            $sp_logo_wp = '<a href="#" class="logo-upload-btn"><img src="' . $logo_value[ 'sp' ][ 'src' ] . '"></a><a class="logo-remove-btn ui-btn on">' . $text_image_delete . '</a>';
        }
    } elseif ( isset( $logo_value[ 'sp' ][ 'type' ] ) && $logo_value[ 'sp' ][ 'type' ] === '2' ) {
        $sp_check1 = '';
        $sp_check2 = ' checked';
        $sp_on1 = '';
        $sp_on2 = ' on';
        if ( isset( $logo_value[ 'sp' ][ 'src' ] ) && $logo_value[ 'sp' ][ 'src' ] !== '' ) {
            $sp_logo_img = '<img src="' . $logo_value[ 'sp' ][ 'src' ] . '">';
            $sp_logo_url = $logo_value[ 'sp' ][ 'src' ];
        }
    }
    //翻訳
    $text_menu_title = __( 'ロゴ設定', 'dg-style' );
    $text_pc_title = __( 'PCロゴ', 'dg-style' );
    $text_wp_image = __( 'WPイメージ', 'dg-style' );
    $text_image_url = __( 'イメージURL', 'dg-style' );
    $text_sp_title = __( 'SPロゴ', 'dg-style' );
    return <<< EOM
        <div id="common-logo-option" class="option-window add-part-window common-option-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_pc_title}</div>
                <div id="pc-logo-select-area" class="tab-inner image-select-tabs">
                    <div class="tab-list option-labels flex">
                        <label class="tab-label option-label{$pc_on1}"><input type="radio" name="pc-logo-type" value="1" class="logo-type-input none-display" data-level="pc"{$pc_check1}><span class="toggle-label">{$text_wp_image}</span></label>
                        <label class="tab-label option-label{$pc_on2}"><input type="radio" name="pc-logo-type" value="2" class="logo-type-input none-display" data-level="pc"{$pc_check2}><span class="toggle-label">{$text_image_url}</span></label>
                    </div>
                    <div class="tab-contents option-contents">
                        <div class="tab-content{$pc_on1}">
                            <div id="pc-logo-wp-image" class="image-box" data-level="pc">{$pc_logo_wp}</div>
                        </div>
                        <div class="tab-content{$pc_on2}">
                            <div class="window-title">{$text_image_url}</div>
                            <input id="pc-logo-url-input" type="text" class="logo-url-input image-url-value" data-level="pc" value="{$pc_logo_url}">
                            <div id="pc-logo-simulator" class="image-simulator">{$pc_logo_img}</div>
                        </div>
                    </div>
                </div>
                <div class="window-title">{$text_sp_title}</div>
                <div id="sp-logo-select-area" class="tab-inner image-select-tabs">
                    <div class="tab-list option-labels flex">
                        <label class="tab-label option-label{$sp_on1}"><input type="radio" name="sp-logo-type" value="1" class="logo-type-input none-display" data-level="sp"{$sp_check1}><span class="toggle-label">{$text_wp_image}</span></label>
                        <label class="tab-label option-label{$sp_on2}"><input type="radio" name="sp-logo-type" value="2" class="logo-type-input none-display" data-level="sp"{$sp_check2}><span class="toggle-label">{$text_image_url}</span></label>
                    </div>
                    <div class="tab-contents option-contents">
                        <div class="tab-content{$sp_on1}">
                            <div id="sp-logo-wp-image" class="image-box" data-level="sp">{$sp_logo_wp}</div>
                        </div>
                        <div class="tab-content{$sp_on2}">
                            <div class="window-title">{$text_image_url}</div>
                            <input id="sp-logo-url-input" type="text" class="logo-url-input image-url-value" data-level="sp" value="{$sp_logo_url}">
                            <div id="sp-logo-simulator" class="image-simulator">{$sp_logo_img}</div>
                        </div>
                    </div>
                </div>
                <input type="hidden" class="common-option-input" id="site-optiton-logo-value" data-level="logo" value="{$option_value}">
            </div>
        </div>
EOM;
}

/*
 * カラー設定
*/
function common_window_color( $color_value, $option_value ) {
    $color_set = '';
    $palette_set = '';
    $select = '';
    $select_name = '';
    $select_palette_id = '';
    if ( $color_value !== false ) {
        if ( isset( $color_value[ 'palette' ] ) && is_array( $color_value[ 'palette' ] ) && count( $color_value[ 'palette' ] ) > 0 ) {
            foreach( (array)$color_value[ 'palette' ] as $key => $value ) {
                $select = '';
                if ( isset( $color_value[ 'select' ] ) && $color_value[ 'select' ] === $key ) {
                    $select = ' select';
                } elseif ( !isset( $color_value[ 'select' ] ) && $key === 'palette-1' ) {
                    $select = ' select';
                }
                $palette_set .= <<< EOM
                    <div class="palette-design palette-item{$select}" data-palette="{$key}" data-label="{$value[ 'label' ]}">
                        <div class="palette-color" data-color="{$value[ 'main' ]}" data-name="main" style="background:{$value[ 'main' ]};"></div>
                        <div class="palette-color" data-color="{$value[ 'base' ]}" data-name="base" style="background:{$value[ 'base' ]};"></div>
                        <div class="palette-color" data-color="{$value[ 'text' ]}" data-name="text" style="background:{$value[ 'text' ]};"></div>
                        <div class="palette-color" data-color="{$value[ 'sub1' ]}" data-name="sub1" style="background:{$value[ 'sub1' ]};"></div>
                        <div class="palette-color" data-color="{$value[ 'sub2' ]}" data-name="sub2" style="background:{$value[ 'sub2' ]};"></div>
                    </div>
EOM;
            }
        }
        
        /* 選択したパレット */
        if ( isset( $color_value[ 'select' ] ) ) {
            $select_palette = $color_value[ 'palette' ][ $color_value[ 'select' ] ];
            $select_name = $select_palette[ 'label' ];
            $select_palette_id = $color_value[ 'select' ];
            $select = <<< EOM
                <div class="palette-color" data-color="{$select_palette[ 'main' ]}" data-name="main" style="background:{$select_palette[ 'main' ]};"></div>
                <div class="palette-color" data-color="{$select_palette[ 'base' ]}" data-name="base" style="background:{$select_palette[ 'base' ]};"></div>
                <div class="palette-color" data-color="{$select_palette[ 'text' ]}" data-name="text" style="background:{$select_palette[ 'text' ]};"></div>
                <div class="palette-color" data-color="{$select_palette[ 'sub1' ]}" data-name="sub1" style="background:{$select_palette[ 'sub1' ]};"></div>
                <div class="palette-color" data-color="{$select_palette[ 'sub2' ]}" data-name="sub2" style="background:{$select_palette[ 'sub2' ]};"></div>
EOM;
        } elseif ( isset( $color_value[ 'palette' ][ 'palette-1' ] ) ) {
            $select_palette = $color_value[ 'palette' ][ 'palette-1' ];
            $select_name = $select_palette[ 'label' ];
            $select_palette_id = 'palette-1';
            $select = <<< EOM
                <div class="palette-color" data-color="{$select_palette[ 'main' ]}" data-name="main" style="background:{$select_palette[ 'main' ]};"></div>
                <div class="palette-color" data-color="{$select_palette[ 'base' ]}" data-name="base" style="background:{$select_palette[ 'base' ]};"></div>
                <div class="palette-color" data-color="{$select_palette[ 'text' ]}" data-name="text" style="background:{$select_palette[ 'text' ]};"></div>
                <div class="palette-color" data-color="{$select_palette[ 'sub1' ]}" data-name="sub1" style="background:{$select_palette[ 'sub1' ]};"></div>
                <div class="palette-color" data-color="{$select_palette[ 'sub2' ]}" data-name="sub2" style="background:{$select_palette[ 'sub2' ]};"></div>
EOM;
        }
        
        /* カラーセット */
        if ( isset( $color_value[ 'colorset' ] ) && is_array( $color_value[ 'colorset' ] ) && count( $color_value[ 'colorset' ] ) > 0 ) {
            foreach( (array)$color_value[ 'colorset' ] as $key => $value ) {
                $color_set .= <<< EOM
                    <div class="color-item set-color-item" data-level="{$key}" data-color="{$value[ 'color' ]}" data-name="{$value[ 'name' ]}">
                        <div class="color-icon" style="background:{$value[ 'color' ]};"></div>
                        <div class="color-name">{$value[ 'name' ]}</div>
                    </div>
EOM;
            }
        }
    }
    //翻訳
    $text_menu_title = __( 'カラー設定', 'dg-style' );
    $text_select_title = __( '選択パレット', 'dg-style' );
    $text_change_btn = __( '変更', 'dg-style' );
    $text_add_pallete_btn = __( 'パレット追加', 'dg-style' );
    $text_color_set = __( 'カラーセット', 'dg-style' );
    $text_add_color_btn = __( '色追加', 'dg-style' );
    $text_transparent = __( '透明', 'dg-style' );
    $text_unset = __( '色なし', 'dg-style' );
    $text_delete = __( '設定色を消す', 'dg-style' );
    
    return <<< EOM
        <div id="common-color-option" class="option-window add-part-window common-option-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn close-pass"></div>
                <div class="window-close header-btn close-pass"></div>
            </div>
            <div class="window-content">
                <div class="color-palette-area">
                    <div class="window-title">{$text_select_title}（<span id="selected-palette-name">{$select_name}</span>）</div>
                    <div class="change-palette-btn">{$text_change_btn}</div>
                    <div id="selected-palette" class="palette-design" data-palette="{$select_palette_id}">
                        {$select}
                    </div>
                    <div id="palette-set-panel" class="palette-list">
                        <div id="saved-palette-list">{$palette_set}</div>
                        <div class="add-palette-btn">{$text_add_pallete_btn}</div>
                    </div>
                </div>
                <div class="window-title color-set-title">
                    {$text_color_set}
                    <button type="button" class="add-color-item">{$text_add_color_btn}</button>
                </div>
                <div id="color-set-panel" class="color-set-list">{$color_set}</div>
                <div id="default-colors-area">
                    <button type="button" id="transparent-set-color" value="transparent">{$text_transparent}</button>
                    <button type="button" id="unset-set-color" value="unset">{$text_unset}</button>
                    <button type="button" id="cancel-set-color">{$text_delete}</button>
                </div>
                <input type="hidden" class="template-value-input" id="site-optiton-color-value" value="{$option_value}" data-level="color">
            </div>
        </div>
EOM;
}

/*
 * デバイス設定
*/
function common_window_device( $option, $device ) {
    $device_list = array(
        'sp' => array(
            '320' => 'sp',
            '375' => 'sp375',
            '414' => 'sp414',
        ),
        'tb' => array(
            '560' => 'tb',
            '768' => 'tb768',
            '810' => 'tb810',
            '834' => 'tb834',
        ),
        'pc' => array(
            '960' => 'pc',
            '1024' => 'pc1024',
            '1200' => 'pc1200',
        )
    );
    $text_moving = __( 'デバイス引っ越し', 'dg-style' );
    $sp_html = '';
    $tb_html = '';
    $pc_html = '';
    $option_value = htmlspecialchars( json_encode( array( 320 => 'sp', 560 => 'tb', 960 => 'pc' ) ) );
    if ( $option !== '' ) {
        $option_value = htmlspecialchars( $option, ENT_QUOTES, 'UTF-8' );
    }
    foreach( (array)$device_list as $type => $value ) {
        foreach( (array)$value as $size => $name ) {
            $checked = '';
            if ( isset( $device[ $size ] ) ) {
                $checked = ' checked';
            } elseif ( ( $device === false || $device === NULL || ( !is_array( $device ) || is_array( $device ) && count( $device ) < 1 ) ) && ( (int)$size === 320 || (int)$size === 560 || (int)$size === 960 ) ) {
                $checked = ' checked';
            }
            if ( $type === 'sp' ) {
                $sp_html .= '<div class="device-box"><label class="device-label"><input type="checkbox" class="none-display device-select-input" value="' . $size . '" data-level="' . $name . '"' . $checked . '><span class="device-name">' . $type . $size . '</span></label><div class="moving-area"><button type="button" class="moving-device-value" value="' . $size . '" data-level="' . $name . '" title=""></button></div></div>';
            } elseif ( $type === 'tb' ) {
                $tb_html .= '<div class="device-box"><label class="device-label"><input type="checkbox" class="none-display device-select-input" value="' . $size . '" data-level="' . $name . '"' . $checked . '><span class="device-name">' . $type . $size . '</span></label><div class="moving-area"><button type="button" class="moving-device-value" value="' . $size . '" data-level="' . $name . '" title=""></button></div></div>';
            } elseif ( $type === 'pc' ) {
                $pc_html .= '<div class="device-box"><label class="device-label"><input type="checkbox" class="none-display device-select-input" value="' . $size . '" data-level="' . $name . '"' . $checked . '><span class="device-name">' . $type . $size . '</span></label><div class="moving-area"><button type="button" class="moving-device-value" value="' . $size . '" data-level="' . $name . '" title=""></button></div></div>';
            }
        }
    }
    //翻訳
    $text_menu_title = __( 'デバイス設定', 'dg-style' );
    $text_sp_title = __( 'SPサイズ', 'dg-style' );
    $text_tb_title = __( 'TBサイズ', 'dg-style' );
    $text_pc_title = __( 'PCサイズ', 'dg-style' );
    return <<< EOM
        <div id="common-device-option" class="option-window add-part-window common-option-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_sp_title}</div>
                {$sp_html}
                <div class="window-title">{$text_tb_title}</div>
                {$tb_html}
                <div class="window-title">{$text_pc_title}</div>
                {$pc_html}
                <input type="hidden" class="common-option-input" id="site-optiton-device-value" data-level="device" value="{$option_value}">
            </div>
        </div>
EOM;
}

/*
 * 固定サムネイル
*/
function common_window_fixedimage( $page_type ) {
    $no_image = false;
    $text_image_btn = __( 'イメージ選択', 'dg-style' );
    $text_image_delete = __( '削除', 'dg-style' );
    $image_wp = '<a href="#" class="fixed-image-upload-btn ui-btn">' . $text_image_btn . '</a><a class="fixed-image-remove-btn ui-btn">' . $text_image_delete . '</a>';
    //翻訳
    $text_menu_title = __( '固定サムネイル設定', 'dg-style' );
    $text_wp_image = __( 'WPイメージ', 'dg-style' );
    $text_image_url = __( 'イメージURL', 'dg-style' );
    return <<< EOM
        <div id="common-fixed-option" class="option-window add-part-window common-option-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_menu_title}</div>
                <div class="tab-inner image-select-tabs">
                    <div class="tab-list option-labels flex">
                        <label class="tab-label option-label on"><input type="radio" name="fixed-image-type" value="1" class="fixed-image-type-input none-display" checked><span class="toggle-label">{$text_wp_image}</span></label>
                        <label class="tab-label option-label"><input type="radio" name="fixed-image-type" value="2" class="fixed-image-type-input none-display"><span class="toggle-label">{$text_image_url}</span></label>
                    </div>
                    <div class="tab-contents option-contents">
                        <div class="tab-content on">
                            <div id="fixed-image-wp-image" class="image-box">{$image_wp}</div>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_image_url}</div>
                            <input id="fixed-image-url-input" type="text" class="fixed-image-url-input image-url-value">
                            <div id="fixed-image-simulator" class="image-simulator"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * No-Image設定
*/
function common_window_noimage( $page_type ) {
    $no_image = false;
    $option_value = '';
    if ( $page_type !== 'lp' ) {
        $option = get_option( 'DG_noimage_value' );
        if ( $option !== false ) {
            $no_image = json_decode( $option, true );
            $option_value = wp_unslash( htmlspecialchars( $option, ENT_QUOTES, 'UTF-8' ) );
        }
    }
    
    $text_image_btn = __( 'イメージ選択', 'dg-style' );
    $text_image_delete = __( '削除', 'dg-style' );
    $image_wp = '<a href="#" class="no-image-upload-btn ui-btn">' . $text_image_btn . '</a><a class="no-image-remove-btn ui-btn">' . $text_image_delete . '</a>';
    $image_img = '';
    $image_url = '';
    $check1 = '';
    $check2 = '';
    $on1 = '';
    $on2 = '';
    if ( !isset( $no_image[ 'type' ] ) || isset( $no_image[ 'type' ] ) && $no_image[ 'type' ] === '1' ) {
        $check1 = ' checked';
        $check2 = '';
        $on1 = ' on';
        $on2 = '';
        if ( isset( $no_image[ 'src' ] ) && $no_image[ 'src' ] !== '' ) {
            $image_wp = '<a href="#" class="no-image-upload-btn"><img src="' . $no_image[ 'src' ] . '"></a><a class="no-image-remove-btn ui-btn on">' . $text_image_delete . '</a>';
        }
    } elseif ( isset( $no_image[ 'type' ] ) && $no_image[ 'type' ] === '2' ) {
        $check1 = '';
        $check2 = ' checked';
        $on1 = '';
        $on2 = ' on';
        if ( isset( $no_image[ 'src' ] ) && $no_image[ 'src' ] !== '' ) {
            $image_img = '<img src="' . $no_image[ 'src' ] . '">';
            $image_url = $no_image[ 'src' ];
        }
    }
    //翻訳
    $text_menu_title = __( 'No-Image設定', 'dg-style' );
    $text_wp_image = __( 'WPイメージ', 'dg-style' );
    $text_image_url = __( 'イメージURL', 'dg-style' );
    return <<< EOM
        <div id="common-noimage-option" class="option-window add-part-window common-option-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_menu_title}</div>
                <div class="tab-inner image-select-tabs">
                    <div class="tab-list option-labels flex">
                        <label class="tab-label option-label{$on1}"><input type="radio" name="no-image-type" value="1" class="no-image-type-input none-display"{$check1}><span class="toggle-label">{$text_wp_image}</span></label>
                        <label class="tab-label option-label{$on2}"><input type="radio" name="no-image-type" value="2" class="no-image-type-input none-display"{$check2}><span class="toggle-label">{$text_image_url}</span></label>
                    </div>
                    <div class="tab-contents option-contents">
                        <div class="tab-content{$on1}">
                            <div id="no-image-wp-image" class="image-box">{$image_wp}</div>
                        </div>
                        <div class="tab-content{$on2}">
                            <div class="window-title">{$text_image_url}</div>
                            <input id="no-image-url-input" type="text" class="no-image-url-input image-url-value" value="{$image_url}">
                            <div id="no-image-simulator" class="image-simulator">{$image_img}</div>
                        </div>
                    </div>
                </div>
                <input type="hidden" class="common-option-input" id="site-optiton-noimage-value" data-level="noimage" value="{$option_value}">
            </div>
        </div>
EOM;
}

/*
 * Loading-Image設定
*/
function common_window_loading_image( $page_type ) {
    $loading = false;
    $option_value = '';
    if ( $page_type !== 'lp' ) {
        $option = get_option( 'DG_loading_value' );
        if ( $option !== false ) {
            $loading = json_decode( $option, true );
            $option_value = wp_unslash( htmlspecialchars( $option, ENT_QUOTES, 'UTF-8' ) );
        }
    }
    
    $text_image_btn = __( 'イメージ選択', 'dg-style' );
    $text_image_delete = __( '削除', 'dg-style' );
    $image_wp = '<a href="#" class="loading-image-upload-btn ui-btn">' . $text_image_btn . '</a><a class="loading-image-remove-btn ui-btn">' . $text_image_delete . '</a>';
    $image_img = '';
    $image_url = '';
    $check1 = '';
    $check2 = '';
    $on1 = '';
    $on2 = '';
    if ( !isset( $loading[ 'type' ] ) || isset( $loading[ 'type' ] ) && $loading[ 'type' ] === '1' ) {
        $check1 = ' checked';
        $check2 = '';
        $on1 = ' on';
        $on2 = '';
        if ( isset( $loading[ 'src' ] ) && $loading[ 'src' ] !== '' ) {
            $image_wp = '<a href="#" class="loading-image-upload-btn"><img src="' . $loading[ 'src' ] . '"></a><a class="loading-image-remove-btn ui-btn on">' . $text_image_delete . '</a>';
        }
    } elseif ( isset( $loading[ 'type' ] ) && $loading[ 'type' ] === '2' ) {
        $check1 = '';
        $check2 = ' checked';
        $on1 = '';
        $on2 = ' on';
        if ( isset( $loading[ 'src' ] ) && $loading[ 'src' ] !== '' ) {
            $image_img = '<img src="' . $loading[ 'src' ] . '">';
            $image_url = $loading[ 'src' ];
        }
    }
    //翻訳
    $text_menu_title = __( 'Loading-Image設定', 'dg-style' );
    $text_image_title1 = __( 'WPイメージ', 'dg-style' );
    $text_image_title2 = __( 'イメージURL', 'dg-style' );
    
    return <<< EOM
        <div id="common-loading-option" class="option-window add-part-window common-option-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_menu_title}</div>
                <div class="tab-inner image-select-tabs">
                    <div class="tab-list option-labels flex">
                        <label class="tab-label option-label{$on1}"><input type="radio" name="loading-image-type" value="1" class="loading-image-type-input none-display"{$check1}><span class="toggle-label">{$text_image_title1}</span></label>
                        <label class="tab-label option-label{$on2}"><input type="radio" name="loading-image-type" value="2" class="loading-image-type-input none-display"{$check2}><span class="toggle-label">{$text_image_title2}</span></label>
                    </div>
                    <div class="tab-contents option-contents">
                        <div class="tab-content{$on1}">
                            <div id="loading-image-wp-image" class="image-box">{$image_wp}</div>
                        </div>
                        <div class="tab-content{$on2}">
                            <div class="window-title">{$text_image_title2}</div>
                            <input id="loading-image-url-input" type="text" class="loading-image-url-input image-url-value" value="{$image_url}">
                            <div id="loading-image-simulator" class="image-simulator">{$image_img}</div>
                        </div>
                    </div>
                </div>
                <input type="hidden" class="common-option-input" id="site-optiton-loading-value" data-level="loading" value="{$option_value}">
            </div>
        </div>
EOM;
}

/*
 * フォント設定
*/
function common_window_font( $page_type ) {
    $text_eng = __( '英語', 'dg-style' );
    $text_kr = __( '韓国語', 'dg-style' );
    $text_ja = __( '日本語', 'dg-style' );
    $font_sort = array();
    $font_list = array(
        'ja' => array(
            'noto-sans-jp' => array(
                'name' => 'Noto Sans JP',
                'weight' => array( 100, 300, 400, 500, 700, 900 ),
                'slug' => 'Noto+Sans+JP',
            ),
            'noto-serif-jp' => array(
                'name' => 'Noto Serif JP',
                'weight' => array( 200, 300, 400, 500, 600, 700, 900 ),
                'slug' => 'Noto+Serif+JP',
            ),
            'm-plus-1p' => array(
                'name' => 'M PLUS 1p',
                'weight' => array( 100, 300, 400, 500, 700, 800, 900 ),
                'slug' => 'M+PLUS+1p',
            ),
            'm-plus-rounded-1c' => array(
                'name' => 'M PLUS Rounded 1c',
                'weight' => array( 100, 300, 400, 500, 700, 800, 900 ),
                'slug' => 'M+PLUS+Rounded+1c',
            ),
            'sawarabi-gothic' => array(
                'name' => 'Sawarabi Gothic',
                'slug' => 'Sawarabi+Gothic',
            ),
            'sawarabi-mincho' => array(
                'name' => 'Sawarabi Mincho',
                'slug' => 'Sawarabi+Mincho',
            ),
            'kosugi' => array(
                'name' => 'Kosugi',
                'slug' => 'Kosugi',
            ),
            'kosugi-maru' => array(
                'name' => 'Kosugi Maru',
                'slug' => 'Kosugi+Maru',
            ),
        ),
        'kr' => array(
            'noto-sans-kr' => array(
                'name' => 'Noto Sans KR',
                'weight' => array( 100, 300, 400, 500, 700, 900 ),
                'slug' => 'Noto+Sans+KR',
            ),
            'noto-serif-kr' => array(
                'name' => 'Noto Serif KR',
                'weight' => array( 200, 300, 400, 500, 600, 700, 900 ),
                'slug' => 'Noto+Serif+KR',
            ),
            'nanum-gothic' => array(
                'name' => '나눔 고딕',
                'weight' => array( 400, 700, 800 ),
                'slug' => 'Nanum+Gothic',
            ),
            'nanum-myeongjo' => array(
                'name' => '나눔 명조',
                'weight' => array( 400, 700, 800 ),
                'slug' => 'Nanum+Myeongjo',
            ),
            'nanum-pen-script' => array(
                'name' => '나눔 펜 스크립',
                'weight' => array( 400 ),
                'slug' => 'Nanum+Pen+Script',
            ),
            'nanum-gothic-coding' => array(
                'name' => '나눔 고딕 코딩',
                'weight' => array( 400, 700 ),
                'slug' => 'Nanum+Gothic+Coding',
            ),
            'nanum-brush-script' => array(
                'name' => '나눔 브러쉬 스크립',
                'weight' => array( 400 ),
                'slug' => 'Nanum+Brush+Script',
            ),
        ),
        'eng' => array(
            'noto-sans' => array(
                'name' => 'Noto Sans',
                'weight' => array( 400, 700 ),
                'slug' => 'Noto+Sans',
            ),
            'noto-serif' => array(
                'name' => 'Noto Serif',
                'weight' => array( 200, 300, 400, 500, 600, 700, 900 ),
                'slug' => 'Noto+Serif',
            ),
            'roboto' => array(
                'name' => 'Roboto',
                'weight' => array( 100, 300, 400, 500, 700, 900 ),
                'slug' => 'Roboto',
            ),
            'roboto-mono' => array(
                'name' => 'Roboto Mono',
                'weight' => array( 100, 200, 300, 400, 500, 600, 700 ),
                'slug' => 'Roboto+Mono',
            ),
            'roboto-slab' => array(
                'name' => 'Roboto Slab',
                'weight' => array( 100, 200, 300, 400, 500, 600, 700, 800, 900 ),
                'slug' => 'Roboto+Slab',
            ),
            'oswald' => array(
                'name' => 'Oswald',
                'weight' => array( 200, 300, 400, 500, 600, 700 ),
                'slug' => 'Oswald',
            ),
            'open-sans' => array(
                'name' => 'Open Sans',
                'weight' => array( 300, 400, 600, 700, 800 ),
                'slug' => 'Open+Sans',
            ),
            'allura' => array(
                'name' => 'Allura',
                'weight' => array( 400 ),
                'slug' => 'Allura',
            ),
        )
    );
    $locale = get_locale();
    if ( $locale === 'ko_KR' ) {
        $font_sort = array( 'kr' => $text_kr, 'eng' => $text_eng, 'ja' => $text_ja );
    } elseif ( $locale === 'ja' ) {
        $font_sort = array( 'ja' => $text_ja, 'eng' => $text_eng, 'kr' => $text_kr, );
    } else {
        $font_sort = array( 'eng' => $text_eng, 'kr' => $text_kr, 'ja' => $text_ja, );
    }
    $text_font_weight = __( 'フォント太さ', 'dg-style' );
    $font_html = array( 'eng' => '', 'kr' => '', 'ja' => '', );
    foreach( (array)$font_list as $type => $font ) {
        foreach( (array)$font as $key => $value ) {
            if ( isset( $value[ 'weight' ] ) ) {
                $weight_html = '';
                foreach( (array)$value[ 'weight' ] as $weight ) {
                    $weight_html .= '<label class="weight-label"><input type="checkbox" class="none-display font-weight-input" value="' . $weight . '"><span class="weight-name">' . $weight  . '</span></label>';
                }
                $font_html[ $type ] .= <<< EOM
                    <div class="font-item" data-level="{$type}">
                        <label class="font-use-label">
                            <input type="checkbox" class="none-display font-type-input weight-font" value="{$value[ 'slug' ]}">
                            <span class="font-name">{$value[ 'name' ]}</span>
                        </label>
                        <div class="font-weight-list">
                            <div class="weight-title">{$text_font_weight}</div>
                            {$weight_html}
                        </div>
                    </div>
EOM;
            } else {
                $font_html[ $type ] .= '<div class="font-item"><label class="font-use-label"><input type="checkbox" class="none-display font-type-input" value="' . $value[ 'slug' ] . '"><span class="font-name">' . $value[ 'name' ]  . '</span></label></div>';
            }
        }
    }
    $text_caution = __( '複数選択可', 'dg-style' );
    $cnt = 0;
    $tab_labels = '';
    $tab_contents = '';
    foreach( (array)$font_sort as $key => $name ) {
        $on = '';
        if ( $cnt === 0 ) {
            $on = ' on';
        }
        $tab_labels .= '<button type="button" class="tab-label font-label' . $on . '">' . $name . '</button>';
        $tab_contents .= '<div class="tab-content' . $on . '"><p class="caution">※' . $text_caution . '</p>' . $font_html[ $key ] . '</div>';
        ++$cnt;
    }
    //翻訳
    $text_menu_title = __( 'フォント設定', 'dg-style' );
    $text_label_base = __( '基本フォント', 'dg-style' );
    $text_base_font1 = __( 'ゴシック', 'dg-style' );
    $text_base_font2 = __( '明朝', 'dg-style' );
    $text_label_lazyload = __( 'LazyLoad設定', 'dg-style' );
    $text_lazyload_font1 = __( '設定する', 'dg-style' );
    $text_lazyload_font2 = __( '設定しない', 'dg-style' );
    $text_label_select = __( 'フォント選択', 'dg-style' );
    $text_label_free = __( '手入力', 'dg-style' );
    $text_label_free_caution = __( 'フォント用スクリプトを手入力できます。', 'dg-style' );
    $text_label_free_caution2 = __( '選択したフォントより優先されます。', 'dg-style' );
    $text_label_free_caution3 = __( 'CSSのfont-familyも手動で設定する必要があります。', 'dg-style' );
    return <<< EOM
        <div id="common-font-option" class="option-window add-part-window common-option-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content" id="font-family-list">
                <div class="window-title">{$text_label_base}</div>
                <div class="base-font-labels">
                    <label class="base-font-label"><input type="radio" class="base-font-input" name="base-font-type" value="sans-serif"><span class="text">{$text_base_font1}</span></label>
                    <label class="base-font-label"><input type="radio" class="base-font-input" name="base-font-type" value="serif"><span class="text">{$text_base_font2}</span></label>
                </div>
                <div class="window-title">{$text_label_lazyload}</div>
                <div class="base-font-labels">
                    <label class="base-font-label"><input type="radio" class="font-lazyload-input" name="font-lazyload-type" value="1"><span class="text">{$text_lazyload_font1}</span></label>
                    <label class="base-font-label"><input type="radio" class="font-lazyload-input" name="font-lazyload-type" value="2"><span class="text">{$text_lazyload_font2}</span></label>
                </div>
                <div class="window-title">{$text_label_select}</div>
                <div class="tab-inner font-tab-inner">
                    <div class="tab-list font-labels">
                        {$tab_labels}
                        <button type="button" class="tab-label font-label">{$text_label_free}</button>
                    </div>
                    <div class="tab-contents option-contents font-tab-contents">
                        {$tab_contents}
                        <div class="tab-content">
                            <div class="window-title">{$text_label_free}</div>
                            <textarea class="font-free-input" rows="10"></textarea>
                            <p class="caution">※{$text_label_free_caution}<br>※{$text_label_free_caution2}<br>※{$text_label_free_caution3}</p>
                        </div>
                    </div>
                </div>
                <input type="hidden" id="site-optiton-font-value" data-level="font" value="">
            </div>
        </div>
EOM;
}

/*
 * Favicon設定
*/
function common_window_favion( $color_value ) {
    //favicon
    $site_name = get_option( 'blogname', '' );
    $site_url = site_url();
    $preview_bg = $site_url . '/wp-admin/images/browser.png';
    $image_url = '';
    $option_value = get_option( 'site_icon', '' );
    if ( $option_value !== '' ) {
        $image = wp_get_attachment_image_src( $option_value, 'full' );
        if ( $image !== false ) {
            $image_url = $image[ 0 ];
        }
    }
    //PWA
    $pwa = get_option( 'DG_pwa_value', '' );
    $pwa_value = '';
    $pwa_name = '';
    $pwa_theme = '';
    $theme_code = '';
    $pwa_bg = '';
    $bg_code = '';
    $pwa_flg1 = '';
    $pwa_flg2 = '';
    $pwa_flg3 = '';
    $pwa_display1 = '';
    $pwa_display2 = '';
    $pwa_display3 = '';
    $pwa_display4 = '';
    $pwa_description = '';
    if ( $pwa !== '' ) {
        $pwa_arr = json_decode( $pwa, true );
        $pwa_flg1 = isset( $pwa_arr[ 'flg' ] ) && $pwa_arr[ 'flg' ] === '' ? ' selected' : '';
        $pwa_flg2 = isset( $pwa_arr[ 'flg' ] ) && $pwa_arr[ 'flg' ] === '1' ? ' selected' : '';
        $pwa_flg3 = isset( $pwa_arr[ 'flg' ] ) && $pwa_arr[ 'flg' ] === '2' ? ' selected' : '';
        $pwa_name = isset( $pwa_arr[ 'name' ] ) ? $pwa_arr[ 'name' ] : '';
        if ( isset( $pwa_arr[ 'theme' ] ) && $pwa_arr[ 'theme' ] !== '' ) {
            $pwa_theme = $pwa_arr[ 'theme' ];
            $theme_code = replace_color_code( $color_value, $pwa_arr[ 'theme' ] );
        }
        if ( isset( $pwa_arr[ 'bg' ] ) && $pwa_arr[ 'bg' ] !== '' ) {
            $pwa_bg = $pwa_arr[ 'bg' ];
            $bg_code = replace_color_code( $color_value, $pwa_arr[ 'bg' ] );
        }
        $pwa_display1 = isset( $pwa_arr[ 'display' ] ) && $pwa_arr[ 'display' ] === '' ? ' selected' : '';
        $pwa_display2 = isset( $pwa_arr[ 'display' ] ) && $pwa_arr[ 'display' ] === 'minimal-ui' ? ' selected' : '';
        $pwa_display3 = isset( $pwa_arr[ 'display' ] ) && $pwa_arr[ 'display' ] === 'standalone' ? ' selected' : '';
        $pwa_display4 = isset( $pwa_arr[ 'display' ] ) && $pwa_arr[ 'display' ] === 'fullscreen' ? ' selected' : '';
        $pwa_description = isset( $pwa_arr[ 'description' ] ) ? $pwa_arr[ 'description' ] : '';
        $pwa_value = htmlspecialchars( $pwa, ENT_QUOTES, 'UTF-8' );
    }
    
    //翻訳
    $text_menu_title = __( 'Favicon＆PWA設定', 'dg-style' );
    $text_favicon_title = __( 'Favicon設定', 'dg-style' );
    $text_image_btn = __( 'イメージ選択', 'dg-style' );
    $text_image_delete = __( '削除', 'dg-style' );
    $text_pwa_title = __( 'PWA設定', 'dg-style' );
    $text_pwa_select1 = __( 'PWAしない', 'dg-style' );
    $text_pwa_select2 = __( 'PWAする', 'dg-style' );
    $text_pwa_select3 = __( 'manifestのみ設置', 'dg-style' );
    $text_pwa_caution1 = __( 'SPAの場合は利用できません。', 'dg-style' );
    $text_pwa_caution2 = __( '管理画面ツールバーが表示されている場合、ツールバーもキャッシュされるのでご注意ください。', 'dg-style' );
    $text_pwa_option1 = __( 'サイト名', 'dg-style' );
    $text_pwa_option2 = __( 'テーマ色', 'dg-style' );
    $text_pwa_option3 = __( '背景色', 'dg-style' );
    $text_pwa_option4 = __( '表示方法', 'dg-style' );
    $text_pwa_option5 = __( 'アプリ説明', 'dg-style' );
    
    return <<< EOM
        <div id="common-favicon-option" class="option-window add-part-window common-option-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div id="favicon-setting-area" class="mb30">
                    <div class="window-title">{$text_favicon_title}</div>
                    <div class="favicon-preview-area">
                        <div class="favicon-preview">
                            <img src="{$preview_bg}">
                            <img id="favicon-preview-image" src="{$image_url}">
                            <span id="browser-site-name">{$site_name}</span>
                        </div>
                        <div class="favicon-image-area"><img id="favicon-image-big" src="{$image_url}"></div>
                    </div>
                    <div class="favicon-btns">
                        <button id="add-favicon-btn" type="button">{$text_image_btn}</button>
                        <button id="remove-favicon-btn" type="button">{$text_image_delete}</button>
                    </div>
                </div>
                <div class="window-title">{$text_pwa_title}</div>
                <select class="pwa-common-input" data-level="flg">
                    <option value=""{$pwa_flg1}>{$text_pwa_select1}</option>
                    <option value="1"{$pwa_flg2}>{$text_pwa_select2}</option>
                    <option value="2"{$pwa_flg3}>{$text_pwa_select3}</option>
                </select>
                <p class="caution">※{$text_pwa_caution1}<br>※{$text_pwa_caution2}</p>
                <table class="pwa-table">
                    <tr>
                        <th>{$text_pwa_option1}</th>
                        <td><input type="text" class="pwa-common-input" data-level="name" value="{$pwa_name}" placeholder="{$site_name}"></td>
                    </tr>
                    <tr>
                        <th>{$text_pwa_option2}</th>
                        <td><div class="color-picker-btn pwa-color" style="background:{$theme_code};"><input type="hidden" class="pwa-common-input" data-level="theme" value="{$pwa_theme}"></div></td>
                    </tr>
                    <tr>
                        <th>{$text_pwa_option3}</th>
                        <td><div class="color-picker-btn pwa-color" style="background:{$bg_code};"><input type="hidden" class="pwa-common-input" data-level="bg" value="{$pwa_bg}"></div></td>
                    </tr>
                    <tr>
                        <th>$text_pwa_option4</th>
                        <td>
                            <select class="pwa-common-input" data-level="display">
                                <option value=""{$pwa_display1}>browser</option>
                                <option value="minimal-ui"{$pwa_display2}>minimal-ui</option>
                                <option value="standalone"{$pwa_display3}>standalone</option>
                                <option value="fullscreen"{$pwa_display4}>fullscreen</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th>{$text_pwa_option5}</th>
                        <td><textarea class="pwa-common-input" data-level="description" rows="5">{$pwa_description}</textarea></td>
                    </tr>
                </table>
                <input type="hidden" class="common-option-input" id="site-optiton-pwa-value" data-level="pwa" value="{$pwa_value}">
                <input type="hidden" class="common-option-input" id="site-optiton-favicon-value" data-level="favicon" value="{$option_value}">
            </div>
        </div>
EOM;
}

/*
 * Favicon設定
*/
function common_window_custom_meta( $post_id ) {
    $dg_meta = get_post_meta( $post_id, 'dg_meta', true );
    $title = '';
    $description = '';
    $canonical = '';
    $noindex = '';
    if ( $dg_meta !== '' ) {
        $dg_meta = json_decode( $dg_meta, true );
        $title = isset( $dg_meta[ 'title' ] ) ? $dg_meta[ 'title' ] : '';
        $description = isset( $dg_meta[ 'description' ] ) ? $dg_meta[ 'description' ] : '';
        $canonical = isset( $dg_meta[ 'canonical' ] ) ? $dg_meta[ 'canonical' ] : '';
        $noindex = isset( $dg_meta[ 'noindex' ] ) && $dg_meta[ 'noindex' ] === '1' ? ' checked' : '';
    }
    
    //翻訳
    $text_menu_title = __( 'カスタムMETA', 'dg-style' );
    $text_title1 = __( 'METAタイトル', 'dg-style' );
    $text_title2 = __( 'METAディスクリプション', 'dg-style' );
    $text_title3 = __( 'Canonical設定', 'dg-style' );
    $text_title4 = __( 'Noindexにする', 'dg-style' );
    $text_count = __( '文字数', 'dg-style' );
    $text_thumb = __( 'アイキャッチ画像', 'dg-style' );
    $text_image_select_title = __( 'イメージ選択', 'dg-style' );
    $text_image_delete = __( '削除', 'dg-style' );
    
    //サムネイル
    $thumbnail = '<a href="#" class="lp-img-upload-btn ui-btn">' . $text_image_select_title . '</a><a class="lp-img-remove-btn ui-btn">' . $text_image_delete . '</a>';
    $thumbnail_id = get_post_meta( $post_id, '_thumbnail_id', true );
    if ( $thumbnail_id !== '' ) {
        $thumbnail_url = wp_get_attachment_image_src( $thumbnail_id, 'full' );
        $thumbnail = '<a href="#" class="lp-img-upload-btn"><img src="' . $thumbnail_url[ 0 ] . '"></a><a class="lp-img-remove-btn ui-btn on">' . $text_image_delete . '</a>';
    }
    return <<< EOM
        <div id="common-favicon-option" class="option-window add-part-window common-option-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_title1} {$text_count}：<strong id="dg_meta_title_count"></strong></div>
                <input type="text" id="dg_meta_title" value="{$title}">
                <div class="window-title">{$text_title2} {$text_count}：<strong id="dg_meta_description_count"></strong></div>
                <textarea id="dg_meta_description" rows="4">{$description}</textarea>
                <div class="window-title">{$text_title3}</div>
                <input type="text" id="dg_meta_canonical" value="{$canonical}">
                <label class="check-toggle-label"><input type="checkbox" id="dg_meta_noindex" class="display-none" value="1"{$noindex}><span class="check-name">{$text_title4}</span><span class="check-button"></span></label>
                <div class="window-title">{$text_thumb}</div>
                <div class="image-box">
                    {$thumbnail}
                    <input type="hidden" class="image-url" id="lp-thumbnail-image" value="{$thumbnail_id}">
                </div>
            </div>
        </div>
EOM;
}

/*
 * 簡単デザインメニュー
*/
function window_simple_design_menus( $page_list = false ) {
    //翻訳
    $text_select_part_name = __( 'パーツ名指定', 'dg-style' );
    $text_label_edit = __( 'デザインラベル編集', 'dg-style' );
    $text_label_placeholder = __( 'ラベル入力', 'dg-style' );
    $text_selector_edit = __( 'セレクター編集', 'dg-style' );
    $text_selector_submit = __( '反映する', 'dg-style' );
    $text_selector_title = __( '入力した内容でセレクターを', 'dg-style' );
    $text_selector_submit_edit = __( '編集する', 'dg-style' );
    $text_selector_submit_new = __( '新規作成', 'dg-style' );
    $text_open_current_list = __( '登録済のデザインリスト', 'dg-style' );
    $text_open_css_copy = __( '外部CSSで上書き', 'dg-style' );
    $text_css_important = __( '優先適用', 'dg-style' );
    $text_reset_simple_design = __( 'デザインリセット', 'dg-style' );
    $text_open_design_setting = __( 'デザイン設定を開く', 'dg-style' );
    $text_margin = __( '余白', 'dg-style' );
    $text_other = __( 'その他', 'dg-style' );
    $text_size = __( '大きさ', 'dg-style' );
    $text_font = __( 'フォント', 'dg-style' );
    $text_bg = __( '背景', 'dg-style' );
    $text_border = __( '線', 'dg-style' );
    $text_radius = __( '角', 'dg-style' );
    $text_layout = __( 'レイアウト', 'dg-style' );
    $text_filter = __( 'フィルタ', 'dg-style' );
    $text_transform = __( '変形', 'dg-style' );
    $text_position = __( '配置', 'dg-style' );
    $text_parent = __( '親移動', 'dg-style' );
    $text_next = __( '次の要素', 'dg-style' );
    $text_prev = __( '前の要素', 'dg-style' );
    $text_left = __( '左', 'dg-style' );
    $text_right = __( '右', 'dg-style' );
    $text_top = __( '上', 'dg-style' );
    $text_bottom = __( '下', 'dg-style' );
    $text_justify = __( '均等', 'dg-style' );
    $text_center = __( '中央', 'dg-style' );
    $text_font_size = __( 'フォント サイズ', 'dg-style' );
    $text_font_color = __( '文字色', 'dg-style' );
    $text_font_weight = __( '太字', 'dg-style' );
    $text_font_italic = __( '斜字', 'dg-style' );
    $text_font_cancel = __( '取り消し線', 'dg-style' );
    $text_font_under = __( '下線', 'dg-style' );
    $text_font_clear = __( '装飾削除', 'dg-style' );
    $text_font_keep = __( 'はみ出す', 'dg-style' );
    $text_font_break = __( '折り返す', 'dg-style' );
    $text_font_vertical = __( '縦書き', 'dg-style' );
    $text_line_height = __( '行の高さ', 'dg-style' );
    $text_letter_space = __( '文字間隔', 'dg-style' );
    $text_flex_child = __( 'flex子要素', 'dg-style' );
    $text_flex_order = __( '順番', 'dg-style' );
    $text_float = __( '浮動位置', 'dg-style' );
    $text_float_left = __( '左', 'dg-style' );
    $text_float_right = __( '右', 'dg-style' );
    $text_float_clear = __( '浮動クリア', 'dg-style' );
    $text_shadow = __( 'シャドー', 'dg-style' );
    $text_shadow_telescopic = __( '伸縮', 'dg-style' );
    $text_size_weight = __( '横幅', 'dg-style' );
    $text_size_height = __( '高さ', 'dg-style' );
    $text_box_shadow = __( 'ボックスシャドー', 'dg-style' );
    $text_bg_color = __( '背景色', 'dg-style' );
    $text_bg_image = __( '背景イメージ', 'dg-style' );
    $text_image_select = __( 'イメージ選択', 'dg-style' );
    $text_bg_gra = __( 'グラデーション', 'dg-style' );
    $text_bg_style = __( 'グラデーション種類', 'dg-style' );
    $text_bg_style_circle = __( '円', 'dg-style' );
    $text_bg_angle = __( '角度', 'dg-style' );
    $text_bg_repeat = __( '繰り返し', 'dg-style' );
    $text_bg_position = __( '座標', 'dg-style' );
    $text_bg_clip = __( '背景範囲', 'dg-style' );
    $text_bg_origin = __( '背景基点', 'dg-style' );
    $text_bg_attachment = __( '固定表示', 'dg-style' );
    $text_bg_display = __( '表示方法', 'dg-style' );
    $text_border_weight = __( '線の太さ', 'dg-style' );
    $text_border_style = __( '線の種類', 'dg-style' );
    $text_border_color = __( '線の色', 'dg-style' );
    $text_radius_tl = __( '左上', 'dg-style' );
    $text_radius_tr = __( '右上', 'dg-style' );
    $text_radius_bl = __( '左下', 'dg-style' );
    $text_radius_br = __( '右下', 'dg-style' );
    $text_display = __( '表示型', 'dg-style' );
    $text_display_inline = __( 'インライン', 'dg-style' );
    $text_display_inline_block = __( 'インラインブロック', 'dg-style' );
    $text_display_block = __( 'ブロック', 'dg-style' );
    $text_display_none = __( '非表示', 'dg-style' );
    $text_column = __( 'カラム', 'dg-style' );
    $text_column_align = __( '整列', 'dg-style' );
    $text_column_align_v = __( '縦整列', 'dg-style' );
    $text_column_direction = __( '並ぶ向き', 'dg-style' );
    $text_column_row = __( '左から右', 'dg-style' );
    $text_column_row_reverse = __( '右から左', 'dg-style' );
    $text_column_column = __( '上から下', 'dg-style' );
    $text_column_column_reverse = __( '下から上', 'dg-style' );
    $text_z_index = __( '重なり順', 'dg-style' );
    $text_opacity = __( '透明度', 'dg-style' );
    $text_Animation = __( 'アニメーション', 'dg-style' );
    $text_Animation_name = __( 'アニメーション名', 'dg-style' );
    $text_Animation_delay = __( '開始時間', 'dg-style' );
    $text_Animation_direction = __( '方向', 'dg-style' );
    $text_Animation_duration = __( '持続時間', 'dg-style' );
    $text_Animation_fill_mode = __( '前後スタイル', 'dg-style' );
    $text_Animation_iteration = __( '再生回数', 'dg-style' );
    $text_Animation_state = __( 'ステータス', 'dg-style' );
    $text_Animation_timing = __( '再生アクション', 'dg-style' );
    $text_select_default = __( '選択', 'dg-style' );
    $text_required = __( '必須', 'dg-style' );
    //各種オプション
    $blend_option = '';
    $blend_unit = array( 'normal', 'multiply', 'screen', 'overlay', 'darken', 'lighten', 'color-dodge', 'color-burn', 'hard-light', 'soft-light', 'difference', 'exclusion', 'hue', 'saturation', 'color', 'luminosity', 'inherit', 'initial', 'unset', );
    foreach( (array)$blend_unit as $key ) {
        $blend_option .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $trans_option = '';
    $trans_unit = array( 'matrix', 'matrix3d', 'perspective', 'rotate', 'rotate3d', 'rotateX', 'rotateY', 'rotateZ', 'translate', 'translate3d', 'translateX', 'translateY', 'translateZ', 'scale', 'scale3d', 'scaleX', 'scaleY', 'scaleZ', 'skew', 'skewX', 'skewY', 'none', 'inherit', 'initial', 'unset', );
    foreach( (array)$trans_unit as $key ) {
        $trans_option .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $filter_option = '';
    $filter_unit = array( 'none'=>__( 'なし', 'dg-style' ), 'brightness'=>__( '明るさ', 'dg-style' ), 'contrast'=>__( 'コントラスト', 'dg-style' ), 'grayscale'=>__( 'グレースケール', 'dg-style' ), 'saturate'=>__( '彩度', 'dg-style' ), 'sepia'=>__( 'セピア', 'dg-style' ), 'hue-rotate'=>__( '色相回転', 'dg-style' ), 'invert'=>__( '階調反転', 'dg-style' ), 'blur'=>__( 'ぼかし', 'dg-style' ), );
    foreach( (array)$filter_unit as $key => $name ) {
        $filter_option .= '<option value="' . $key . '">' . $name . '</option>';
    }
    $cursor_option = '';
    $cursor_unit = array( 'default', 'auto', 'none', 'context-menu', 'help', 'pointer', 'progress', 'wait', 'cell', 'crosshair', 'text', 'vertical-text', 'alias', 'copy', 'move', 'no-drop', 'not-allowed', 'grab', 'grabbing', 'all-scroll', 'col-resize', 'row-resize', 'n-resize', 'e-resize', 's-resize', 'w-resize', 'ne-resize', 'nw-resize', 'se-resize', 'sw-resize', 'ew-resize', 'ns-resize', 'nesw-resize', 'nwse-resize', );
    foreach( (array)$cursor_unit as $key ) {
        $cursor_option .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $unit_option = '';
    $size_unit = array( 'px', 'auto', 'rem', '%', 'em', 'vmin', 'vmax', 'vw', 'vh', 'lvw', 'lvh', 'lvmin', 'lvmax', 'svw', 'svh', 'svmin', 'svmax', 'dvw', 'dvh', 'dvmin', 'dvmax', 'deg', 'inherit', 'initial', 'unset', );
    foreach( (array)$size_unit as $unit ) {
        $unit_option .= '<option value="' . $unit . '">' . $unit . '</option>';
    }
    $margin = '';
    $padding = '';
    $border = '';
    $ways = array( 'left' => $text_left, 'right' => $text_right, 'top' => $text_top, 'bottom' => $text_bottom );
    foreach( (array)$ways as $way => $name ) {
        $margin .= <<< EOM
            <div class="simple-input-column">
                <label for="simple-margin-{$way}">{$name}</label>
                <input type="number" id="simple-margin-{$way}" class="simple-input add-unit margin-input" data-level="margin" data-way="{$way}" title="{$text_margin}">
                <select class="simple-input unit-input margin-unit-input" data-level="margin" data-way="{$way}" title="{$text_margin}">{$unit_option}</select>
            </div>
EOM;
        $padding .= <<< EOM
            <div class="simple-input-column">
                <label for="simple-padding-{$way}">{$name}</label>
                <input type="number" id="simple-padding-{$way}" class="simple-input add-unit padding-input" data-level="padding" data-way="{$way}" title="{$text_margin}">
                <select class="simple-input unit-input padding-unit-input" data-level="padding" data-way="{$way}" title="{$text_margin}">{$unit_option}</select>
            </div>
EOM;
        $border .= <<< EOM
            <div class="simple-border-column">
                <span class="simple-label">{$name}</span>
                <input type="number" class="simple-border-intput simple-input border-input" data-level="border" data-way="{$way}" data-type="weight" placeholder="{$text_border_weight}" title="{$text_border}">
                <select class="simple-border-select simple-input border-input" data-level="border" data-way="{$way}" data-type="style" title="{$text_border}">
                    <option value="">{$text_border_style}</option>
                    <option value="solid">solid</option>
                    <option value="double">double</option>
                    <option value="dashed">dashed</option>
                    <option value="dotted">dotted</option>
                    <option value="groove">groove</option>
                    <option value="ridge">ridge</option>
                    <option value="inset">inset</option>
                    <option value="outset">outset</option>
                    <option value="none">none</option>
                </select>
                <button type="button" class="simple-border-color simple-design-color-btn border-input" data-level="border" data-way="{$way}" data-type="color" title="{$text_border_color}" title="{$text_border}"></button>
            </div>
EOM;
    }
    
    //ページセレクター
    $move_design_setting = '';
    $page_list_option = '';
    if ( $page_list !== false ) {
        $move_design_setting = '<button id="move-design-setting" title="' . $text_open_design_setting . '"></button>';
        $page_list_option = '<option value="">' . __( 'ページ指定なし', 'dg-style' ) . '</option>';
        foreach( (array)$page_list as $key => $value ) {
            if ( $key === 'top' ) {
                $page_list_option .= '<option value="top">' . __( 'TOPページ', 'dg-style' ) . '</option>';
            } else {
                if ( $key === 'taxonomy' ) {
                    $label = __( 'カテゴリー種類', 'dg-style' );
                    $label_type = __( '全カテゴリー', 'dg-style' );
                } elseif ( $key === 'custom-post-archive' ) {
                    $label = __( '記事タイプ種類', 'dg-style' );
                    $label_type = __( '全カスタム投稿タイプ', 'dg-style' );
                } elseif ( $key === 'single' ) {
                    $label = __( '記事種類', 'dg-style' );
                    $label_type = __( '全記事', 'dg-style' );
                } elseif ( $key === 'other' ) {
                    $label = __( 'その他', 'dg-style' );
                    $label_type = '';
                }
                $page_list_option .= '<optgroup label="' . $label . '">';
                if ( $key === 'taxonomy' || $key === 'single' || $key === 'custom-post-archive' ) {
                    $page_list_option .= '<option value="' . $key . '">' . $label_type . '</option>';
                }
                foreach( (array)$value as $slug => $name ) {
                    if ( $slug === 404 ) {
                        $page_list_option .= '<option value="page' . $slug . '">' . $name . '</option>';
                    } else {
                        $page_list_option .= '<option value="' . $slug . '">' . $name . '</option>';
                    }
                }
                $page_list_option .= '</optgroup>';
            }
        }
        $page_list_option .= '<option value="freetext">' . __( '自由入力', 'dg-style' ) . '</option>';
        $page_list_option = <<< EOM
            <select class="page-selector-select">{$page_list_option}</select>
            <div class="page-selector-free">
                <input type="text" class="free-page-selector-input">
                <button type="button" class="close-free-selector" title="cancel"></button>
            </div>
EOM;
    }
    
    return <<< EOM
        <div id="simple-design-menus">
            <div class="moving-panel close-pass">
                <div class="simple-selector-panel">
                    <span id="simple-selector-name"></span>
                    <button type="button" id="edit-simple-label-btn" title="{$text_label_edit}"></button>
                    <input type="text" id="edit-simple-label-input" placeholder="{$text_label_placeholder}" title="{$text_label_edit}">
                </div>
                <div id="add-selector-panel">
                    <button id="open-simple-selector-list" class="open-simple-selector" title="{$text_selector_edit}"></button>
                    <div class="simple-selector-area">
                        <div class="simple-title">{$text_selector_edit}</div>
                        <div class="selector-line-list adding-area simple-selector-list">
                            <div class="selector-line-item adding-line">
                                {$page_list_option}
                                <input type="text" class="selector-item-input adding-input active-selector-input" placeholder="{$text_select_part_name}">
                            </div>
                        </div>
                        <div class="simple-title">{$text_selector_title}</div>
                        <div class="submit-btns-area">
                            <button type="button" id="edit-simple-selector" class="simple-panel-submit">{$text_selector_submit_edit}</button>
                            <button type="button" id="submit-simple-selector" class="simple-panel-submit">{$text_selector_submit_new}</button>
                        </div>
                    </div>
                </div>
                <div id="simple-current-designs-panel">
                    <button id="open-simple-current-designs" class="open-simple-selector" title="{$text_open_current_list}"></button>
                    <div class="simple-selector-area">
                        <div class="simple-title">{$text_open_current_list}</div>
                        <div id="simple-current-designs"></div>
                    </div>
                </div>
                <div id="simple-css-copy-panel">
                    <button id="open-simple-copy-area" class="open-simple-selector" title="{$text_open_css_copy}"></button>
                    <div class="simple-selector-area">
                        <div class="simple-title">{$text_open_css_copy}</div>
                        <textarea id="simple-css-copy-area" rows="5" title="{$text_open_css_copy}"></textarea>
                        <button type="button" id="submit-simple-css-copy" class="simple-panel-submit">{$text_selector_submit}</button>
                    </div>
                </div>
                <button id="css-important" title="{$text_css_important}"></button>
                <button id="reset-simple-design" title="{$text_reset_simple_design}"></button>
                {$move_design_setting}
            </div>
            <div class="simple-item">
                <button type="button" class="simple-menu-btn simple-menu font close-pass" title="{$text_font}"></button>
                <div class="simple-control-menu close-pass">
                    <div class="simple-title">{$text_font}</div>
                    <div class="simple-input-column">
                        <label for="simple-font-size">{$text_font_size}</label>
                        <input type="number" id="simple-font-size" class="simple-input add-unit" data-level="font-size" title="{$text_font_size}">
                        <select class="simple-input unit-input" data-level="font-size" title="{$text_font_size}">{$unit_option}</select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-line-height">{$text_line_height}</label>
                        <input type="number" id="simple-line-height" class="simple-input add-unit" data-level="line-height" title="{$text_line_height}">
                        <select class="simple-input unit-input" data-level="line-height" title="{$text_line_height}">{$unit_option}</select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-letter-spacing">{$text_letter_space}</label>
                        <input type="number" id="simple-letter-spacing" class="simple-input add-unit" data-level="letter-spacing" title="{$text_letter_space}">
                        <select class="simple-input unit-input" data-level="letter-spacing" title="{$text_letter_space}">{$unit_option}</select>
                    </div>
                    <div class="simple-font-styles">
                        <div class="font-style-icon color" title="{$text_font_color}"><button type="button" id="simple-font-color" class="simple-design-color-btn" data-level="color" title="{$text_font_color}"></button></div>
                        <button type="button" id="simple-font-weight" class="font-style-icon weight simple-design-btn" data-level="font-weight" value="bold" data-sub="normal" title="{$text_font_weight}"></button>
                        <button type="button" id="simple-font-italic" class="font-style-icon italic simple-design-btn" data-level="font-style" value="italic" data-sub="normal" title="{$text_font_italic}"></button>
                        <button type="button" id="simple-font-cancel" class="font-style-icon cancel simple-design-btn" data-level="text-decoration" value="line-through" title="{$text_font_cancel}"></button>
                        <button type="button" id="simple-font-under" class="font-style-icon under simple-design-btn" data-level="text-decoration" value="underline" title="{$text_font_under}"></button>
                        <button type="button" id="simple-font-font-clear" class="font-style-icon font-clear simple-design-btn" data-level="text-decoration" value="none" title="{$text_font_clear}"></button>
                        <button type="button" id="simple-font-word-break-keep" class="font-style-icon keep simple-design-btn" data-level="word-break" value="keep-all" title="{$text_font_keep}"></button>
                        <button type="button" id="simple-font-word-break-break" class="font-style-icon break simple-design-btn" data-level="word-break" value="break-all" title="{$text_font_break}"></button>
                        <button type="button" id="simple-font-writing-mode-vertical" class="font-style-icon vertical simple-design-btn" data-level="writing-mode" value="vertical-rl" title="{$text_font_vertical}"></button>
                        <button type="button" id="simple-font-text-overflow" class="font-style-icon text-overflow simple-design-btn" data-level="text-overflow" value="ellipsis" data-sub="clip" title="text-overflow"></button>
                    </div>
                    <div class="simple-title">{$text_column_align}</div>
                    <div class="simple-font-styles few col6">
                        <button type="button" id="simple-font-align-left" class="font-style-icon left simple-design-btn" data-level="text-align" value="left" title="{$text_left}"></button>
                        <button type="button" id="simple-font-align-center" class="font-style-icon center simple-design-btn" data-level="text-align" value="center" title="{$text_center}"></button>
                        <button type="button" id="simple-font-align-right" class="font-style-icon right simple-design-btn" data-level="text-align" value="right" title="{$text_right}"></button>
                        <button type="button" id="simple-display-vertical-top" class="font-style-icon flex-start simple-design-btn" data-level="vertical-align" value="text-top" title="{$text_top}"></button>
                        <button type="button" id="simple-display-vertical-middle" class="font-style-icon flex-center simple-design-btn" data-level="vertical-align" value="middle" title="{$text_center}"></button>
                        <button type="button" id="simple-display-vertical-bottom" class="font-style-icon flex-end simple-design-btn" data-level="vertical-align" value="text-bottom" title="{$text_bottom}"></button>
                    </div>
                    <div class="simple-title">{$text_shadow}</div>
                    <div id="simple-shadow-text" class="simple-shadow-area simple-dynamic-items">
                        <div class="shadow-item simple-dynamic-item">
                            <input type="number" class="simple-input shadow-input" data-level="text-shadow" data-type="x" placeholder="X" title="{$text_shadow}">
                            <input type="number" class="simple-input shadow-input" data-level="text-shadow" data-type="y" placeholder="Y" title="{$text_shadow}">
                            <input type="number" class="simple-input shadow-input" data-level="text-shadow" data-type="blur" placeholder="Blur" title="{$text_shadow}">
                            <button type="button" class="shadow-color-btn simple-design-color-btn" data-level="text-shadow" data-type="color" title="{$text_shadow}"></button>
                            <button type="button" class="shadow-move-btn simple-css-edit-btn add close-pass"></button>
                            <button type="button" class="shadow-move-btn simple-css-edit-btn delete close-pass"></button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="simple-item">
                <button type="button" class="simple-menu-btn simple-menu bg close-pass" title="{$text_bg}"></button>
                <div class="simple-control-menu close-pass">
                    <div class="simple-title">{$text_bg_color}</div>
                    <div class="simple-font-styles few col1">
                        <div class="font-style-icon color" title="{$text_bg_color}"><button type="button" id="simple-bg-color" class="simple-design-color-btn" data-level="background-color" title="{$text_bg_color}"></button></div>
                    </div>
                    <div class="simple-title">{$text_bg}</div>
                    <div class="simple-font-styles few col2">
                        <button type="button" id="simple-background-gra" class="font-style-icon gradient simple-event-btn simple-toggle" data-level="background" value="gradient" title="{$text_bg_gra}"></button>
                        <button type="button" id="simple-background-image" class="font-style-icon image simple-event-btn simple-toggle" data-level="background" value="image" title="{$text_bg_image}"></button>
                    </div>
                    <div id="simple-toggle-area-gradient" class="simple-toggle-area">
                        <div class="simple-title">{$text_bg_gra}</div>
                        <div id="simple-gradient-colors">
                            <div class="gradient-color-item">
                                <button type="button" class="gradient-color-btn simple-design-color-btn" data-level="gradient" data-type="color" title="{$text_bg_gra}"></button>
                                <input type="number" class="simple-input gradient-color-input" data-level="gradient" data-type="position" min="0" max="100" title="{$text_bg_gra}">
                                <button type="button" class="gradient-move-btn simple-css-edit-btn up close-pass"></button>
                                <button type="button" class="gradient-move-btn simple-css-edit-btn down close-pass"></button>
                                <button type="button" class="gradient-move-btn simple-css-edit-btn add close-pass"></button>
                                <button type="button" class="gradient-move-btn simple-css-edit-btn delete close-pass"></button>
                            </div>
                            <div class="gradient-color-item">
                                <button type="button" class="gradient-color-btn simple-design-color-btn" data-level="gradient" data-type="color" title="{$text_bg_gra}"></button>
                                <input type="number" class="simple-input gradient-color-input" data-level="gradient" data-type="position" min="0" max="100" title="{$text_bg_gra}">
                                <button type="button" class="gradient-move-btn simple-css-edit-btn up close-pass"></button>
                                <button type="button" class="gradient-move-btn simple-css-edit-btn down close-pass"></button>
                                <button type="button" class="gradient-move-btn simple-css-edit-btn add close-pass"></button>
                                <button type="button" class="gradient-move-btn simple-css-edit-btn delete close-pass"></button>
                            </div>
                        </div>
                        <div class="simple-input-column">
                            <label for="simple-gradient-style">{$text_bg_style}</label>
                            <select id="simple-gradient-style" class="simple-input" data-level="gradient" data-type="style" title="{$text_bg_style}">
                                <option value="linear">{$text_border}</option>
                                <option value="radial">{$text_bg_style_circle}</option>
                            </select>
                        </div>
                        <div class="simple-input-column">
                            <label for="simple-gradient-angle">{$text_bg_angle}</label>
                            <input type="number" id="simple-gradient-angle" class="simple-input" data-level="gradient" data-type="angle" placeholder="90" title="{$text_bg_angle}">
                        </div>
                    </div>
                    <div id="simple-toggle-area-image" class="simple-toggle-area">
                        <div class="simple-title">{$text_bg_image}</div>
                        <div class="simple-image-box">
                            <div class="simple-image-column">
                                <input type="text" class="simple-input simple-image-url-input" data-level="background-image">
                                <a href="#" class="bg-image-btn simple-image-btn">{$text_image_select}</a>
                            </div>
                            <div class="simple-image-simulator"></div>
                        </div>
                        <div class="simple-input-column">
                            <label for="simple-background-repeat">{$text_bg_repeat}</label>
                            <select id="simple-background-repeat" class="simple-input" data-level="background-repeat" title="{$text_bg_repeat}">
                                <option value="">{$text_select_default}</option>
                                <option value="no-repeat">no-repeat</option>
                                <option value="repeat">repeat</option>
                                <option value="repeat-x">repeat-x</option>
                                <option value="repeat-y">repeat-y</option>
                                <option value="space">space</option>
                                <option value="round">round</option>
                                <option value="inherit">inherit</option>
                                <option value="initial">initial</option>
                                <option value="unset">unset</option>
                            </select>
                        </div>
                        <div class="simple-title">{$text_size}</div>
                        <div class="simple-link-value">
                            <div class="simple-input-column">
                                <label for="simple-background-size-width">{$text_size_weight}</label>
                                <input type="number" id="simple-background-size-width" class="simple-input add-unit" data-level="background-size" data-way="width" title="{$text_size_weight}">
                                <select class="simple-input unit-input" data-level="background-size" data-way="width" title="{$text_size_weight}">{$unit_option}</select>
                            </div>
                            <div class="simple-input-column">
                                <label for="simple-background-size-height">{$text_size_height}</label>
                                <input type="number" id="simple-background-size-height" class="simple-input add-unit" data-level="background-size" data-way="height" title="{$text_size_height}">
                                <select class="simple-input unit-input" data-level="background-size" data-way="height" title="{$text_size_height}">{$unit_option}</select>
                            </div>
                        </div>
                        <div class="simple-title">{$text_position}</div>
                        <div class="simple-link-value">
                            <div class="simple-input-column">
                                <label for="simple-background-position-x">X{$text_bg_position}</label>
                                <select class="simple-input way-input" data-level="background-position" data-way="x" title="X{$text_bg_position}">
                                    <option value="">{$text_select_default}</option>
                                    <option value="center">center</option>
                                    <option value="left">left</option>
                                    <option value="right">right</option>
                                </select>
                                <input type="number" id="simple-background-position-x" class="simple-input add-unit" data-level="background-position" data-way="x" title="X{$text_bg_position}">
                                <select class="simple-input unit-input" data-level="background-position" data-way="x" title="X{$text_bg_position}">{$unit_option}</select>
                            </div>
                            <div class="simple-input-column">
                                <label for="simple-background-position-y">Y{$text_bg_position}</label>
                                <select class="simple-input way-input" data-level="background-position" data-way="y" title="Y{$text_bg_position}">
                                    <option value="">{$text_select_default}</option>
                                    <option value="center">center</option>
                                    <option value="top">top</option>
                                    <option value="bottom">bottom</option>
                                </select>
                                <input type="number" id="simple-background-position-y" class="simple-input add-unit" data-level="background-position" data-way="y" title="Y{$text_bg_position}">
                                <select class="simple-input unit-input" data-level="background-position" data-way="y" title="Y{$text_bg_position}">{$unit_option}</select>
                            </div>
                        </div>
                    </div>
                    <div id="simple-toggle-area-image-double" class="simple-toggle-area">
                        <div class="simple-title">{$text_bg_display}</div>
                        <div class="simple-input-column">
                            <label for="simple-background-attachment">{$text_bg_attachment}</label>
                            <select id="simple-background-attachment" class="simple-input" data-level="background-attachment" title="{$text_bg_attachment}">
                                <option value="">{$text_select_default}</option>
                                <option value="scroll">scroll</option>
                                <option value="fixed">fixed</option>
                                <option value="local">local</option>
                                <option value="inherit">inherit</option>
                                <option value="initial">initial</option>
                                <option value="unset">unset</option>
                            </select>
                        </div>
                        <div class="simple-input-column">
                            <label for="simple-background-clip">{$text_bg_clip}</label>
                            <select id="simple-background-clip" class="simple-input" data-level="background-clip" title="{$text_bg_clip}">
                                <option value="">{$text_select_default}</option>
                                <option value="border-box">border-box</option>
                                <option value="padding-box">padding-box</option>
                                <option value="content-box">content-box</option>
                                <option value="text">text</option>
                                <option value="inherit">inherit</option>
                                <option value="initial">initial</option>
                                <option value="unset">unset</option>
                            </select>
                        </div>
                        <div class="simple-input-column">
                            <label for="simple-background-origin">{$text_bg_origin}</label>
                            <select id="simple-background-origin" class="simple-input" data-level="background-origin" title="{$text_bg_origin}">
                                <option value="">{$text_select_default}</option>
                                <option value="border-box">border-box</option>
                                <option value="padding-box">padding-box</option>
                                <option value="content-box">content-box</option>
                                <option value="inherit">inherit</option>
                                <option value="initial">initial</option>
                                <option value="unset">unset</option>
                            </select>
                        </div>
                    </div>
                    <div class="simple-title">{$text_box_shadow}</div>
                    <div id="simple-shadow-box" class="simple-shadow-area simple-dynamic-items">
                        <div class="shadow-item simple-dynamic-item">
                            <input type="number" class="simple-input shadow-input" data-level="box-shadow" data-type="x" placeholder="X" title="{$text_box_shadow}">
                            <input type="number" class="simple-input shadow-input" data-level="box-shadow" data-type="y" placeholder="Y" title="{$text_box_shadow}">
                            <input type="number" class="simple-input shadow-input" data-level="box-shadow" data-type="blur" placeholder="Blur" title="{$text_box_shadow}">
                            <input type="number" class="simple-input shadow-input" data-level="box-shadow" data-type="position" placeholder="{$text_shadow_telescopic}" title="{$text_box_shadow}">
                            <button type="button" class="shadow-color-btn simple-design-color-btn" data-level="box-shadow" data-type="color" title="{$text_box_shadow}"></button>
                            <button type="button" class="shadow-move-btn simple-css-edit-btn add close-pass"></button>
                            <button type="button" class="shadow-move-btn simple-css-edit-btn delete close-pass"></button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="simple-item">
                <button type="button" class="simple-menu-btn simple-menu margin close-pass" title="{$text_margin}"></button>
                <div class="simple-control-menu close-pass">
                    <div class="simple-title">Margin<button type="button" id="simple-summary-margin" class="simple-summary-btn" data-level="margin"></button></div>
                    {$margin}
                    <div class="simple-title">Padding<button type="button" id="simple-summary-padding" class="simple-summary-btn" data-level="padding"></button></div>
                    {$padding}
                </div>
            </div>
            <div class="simple-item">
                <button type="button" class="simple-menu-btn simple-menu border close-pass" title="{$text_border}"></button>
                <div class="simple-control-menu close-pass">
                    <div class="simple-title">{$text_border}<button type="button" id="simple-summary-border" class="simple-summary-btn" data-level="border"></button></div>
                    {$border}
                    <div class="simple-title">{$text_radius}<button type="button" id="simple-summary-border-radius" class="simple-summary-btn" data-level="border-radius"></button></div>
                    <div class="simple-input-column">
                        <label for="simple-radius-top-left">{$text_radius_tl}</label>
                        <input type="number" id="simple-radius-top-left" class="simple-input add-unit border-radius-input" data-level="border-radius" data-way="top-left" title="{$text_radius}">
                        <select class="simple-input unit-input border-radius-unit-input" data-level="border-radius" data-way="top-left" title="{$text_radius}">{$unit_option}</select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-radius-top-right">{$text_radius_tr}</label>
                        <input type="number" id="simple-radius-top-right" class="simple-input add-unit border-radius-input" data-level="border-radius" data-way="top-right" title="{$text_radius}">
                        <select class="simple-input unit-input border-radius-unit-input" data-level="border-radius" data-way="top-right" title="{$text_radius}">{$unit_option}</select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-radius-bottom-left">{$text_radius_bl}</label>
                        <input type="number" id="simple-radius-bottom-left" class="simple-input add-unit border-radius-input" data-level="border-radius" data-way="bottom-left" title="{$text_radius}">
                        <select class="simple-input unit-input border-radius-unit-input" data-level="border-radius" data-way="bottom-left" title="{$text_radius}">{$unit_option}</select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-radius-bottom-right">{$text_radius_br}</label>
                        <input type="number" id="simple-radius-bottom-right" class="simple-input add-unit border-radius-input" data-level="border-radius" data-way="bottom-right" title="{$text_radius}">
                        <select class="simple-input unit-input border-radius-unit-input" data-level="border-radius" data-way="bottom-right" title="{$text_radius}">{$unit_option}</select>
                    </div>
                </div>
            </div>
            <div class="simple-item">
                <button type="button" class="simple-menu-btn simple-menu layout close-pass" title="{$text_layout}"></button>
                <div class="simple-control-menu close-pass">
                    <div class="simple-title">{$text_size}</div>
                    <div class="simple-input-column">
                        <label for="simple-box-width">{$text_size_weight}</label>
                        <input type="number" id="simple-box-width" class="simple-input add-unit" data-level="width" title="{$text_size_weight}">
                        <select class="simple-input unit-input" data-level="width" title="{$text_size_weight}">{$unit_option}</select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-box-height">{$text_size_height}</label>
                        <input type="number" id="simple-box-height" class="simple-input add-unit" data-level="height" title="{$text_size_height}">
                        <select class="simple-input unit-input" data-level="height" title="{$text_size_height}">{$unit_option}</select>
                    </div>
                    <div class="simple-title">{$text_display}</div>
                    <div class="simple-font-styles few col5">
                        <button type="button" id="simple-display-inline" class="font-style-icon inline simple-design-btn" data-level="display" value="inline" title="{$text_display_inline}"></button>
                        <button type="button" id="simple-display-inline-block" class="font-style-icon inline-block simple-design-btn" data-level="display" value="inline-block" title="{$text_display_inline_block}"></button>
                        <button type="button" id="simple-display-block" class="font-style-icon block simple-design-btn" data-level="display" value="block" title="{$text_display_block}"></button>
                        <button type="button" id="simple-display-flex" class="font-style-icon flex simple-design-btn simple-toggle" data-level="display" value="flex" title="{$text_column}"></button>
                        <button type="button" id="simple-display-none" class="font-style-icon none simple-design-btn" data-level="display" value="none" title="{$text_display_none}"></button>
                    </div>
                    <div id="simple-toggle-area-flex" class="simple-toggle-area">
                        <div class="simple-title">{$text_column_align}</div>
                        <div class="simple-font-styles few col4">
                            <button type="button" id="simple-display-align-left" class="font-style-icon left simple-design-btn" data-level="justify-content" value="flex-start" title="{$text_left}"></button>
                            <button type="button" id="simple-display-align-center" class="font-style-icon center simple-design-btn" data-level="justify-content" value="center" title="{$text_center}"></button>
                            <button type="button" id="simple-display-align-right" class="font-style-icon right simple-design-btn" data-level="justify-content" value="right" title="{$text_right}"></button>
                            <button type="button" id="simple-display-align-justify" class="font-style-icon justify simple-design-btn" data-level="justify-content" value="space-between" title="{$text_justify}"></button>
                        </div>
                        <div class="simple-title">{$text_font_break}</div>
                        <div class="simple-font-styles few col1">
                            <button type="button" id="simple-display-flex-wrap" class="font-style-icon break simple-design-btn" data-level="flex-wrap" value="wrap" title="{$text_font_break}"></button>
                        </div>
                        <div class="simple-title">{$text_column_align_v}</div>
                        <div class="simple-font-styles few col3">
                            <button type="button" id="simple-display-flex-start" class="font-style-icon flex-start simple-design-btn" data-level="align-items" value="flex-start" title="{$text_top}"></button>
                            <button type="button" id="simple-display-flex-center" class="font-style-icon flex-center simple-design-btn" data-level="align-items" value="center" title="{$text_center}"></button>
                            <button type="button" id="simple-display-flex-end" class="font-style-icon flex-end simple-design-btn" data-level="align-items" value="flex-end" title="{$text_bottom}"></button>
                        </div>
                        <div class="simple-title">{$text_column_direction}</div>
                        <div class="simple-font-styles few col4">
                            <button type="button" id="simple-flex-direction-row" class="font-style-icon row simple-design-btn" data-level="flex-direction" value="row" title="{$text_column_row}"></button>
                            <button type="button" id="simple-flex-direction-row-reverse" class="font-style-icon row-reverse simple-design-btn" data-level="flex-direction" value="row-reverse" title="{$text_column_row_reverse}"></button>
                            <button type="button" id="simple-flex-direction-column" class="font-style-icon column-di simple-design-btn" data-level="flex-direction" value="column" title="{$text_column_column}"></button>
                            <button type="button" id="simple-flex-direction-column-reverse" class="font-style-icon column-reverse simple-design-btn" data-level="flex-direction" value="column-reverse" title="{$text_column_column_reverse}"></button>
                        </div>
                    </div>
                    <div id="simple-toggle-area-flex-child" class="simple-toggle-area">
                        <div class="simple-title">{$text_flex_child}</div>
                        <div class="simple-input-column small">
                            <label for="simple-flex-basis">flex-basis</label>
                            <input type="number" id="simple-flex-grow" class="simple-input" data-level="flex" data-type="grow" title="flex-grow" placeholder="grow">
                            <input type="number" id="simple-flex-shrink" class="simple-input" data-level="flex" data-type="shrink" title="flex-shrink" placeholder="shrink">
                            <input type="number" id="simple-flex-basis" class="simple-input add-unit" data-level="flex" data-type="basis" title="flex-basis" placeholder="basis">
                            <select class="simple-input unit-input" data-level="flex" title="flex-basis">
                                {$unit_option}
                                <option value="none">none</option>
                            </select>
                        </div>
                        <div class="simple-input-column">
                            <label for="simple-flex-order">order</label>
                            <input type="number" id="simple-flex-order" class="simple-input" data-level="order" title="{$text_flex_order}">
                        </div>
                        <div class="simple-title">{$text_column_align_v}</div>
                        <div class="simple-font-styles few col3">
                            <button type="button" id="simple-display-self-start" class="font-style-icon flex-start simple-design-btn" data-level="align-self" value="flex-start" title="{$text_top}"></button>
                            <button type="button" id="simple-display-self-center" class="font-style-icon flex-center simple-design-btn" data-level="align-self" value="center" title="{$text_center}"></button>
                            <button type="button" id="simple-display-self-end" class="font-style-icon flex-end simple-design-btn" data-level="align-self" value="flex-end" title="{$text_bottom}"></button>
                        </div>
                    </div>
                    <div class="simple-title">{$text_float}</div>
                    <div class="simple-font-styles few col3">
                        <button type="button" id="simple-display-float-left" class="font-style-icon float-left simple-design-btn" data-level="float" value="left" title="{$text_float_left}"></button>
                        <button type="button" id="simple-display-float-right" class="font-style-icon float-right simple-design-btn" data-level="float" value="right" title="{$text_float_right}"></button>
                        <button type="button" id="simple-display-clear-both" class="font-style-icon clear-both simple-design-btn" data-level="clear" value="both" title="{$text_float_clear}"></button>
                    </div>
                </div>
            </div>
            <div class="simple-item">
                <button type="button" class="simple-menu-btn simple-menu position close-pass" title="{$text_position}"></button>
                <div class="simple-control-menu close-pass">
                    <div class="simple-title">{$text_position}</div>
                    <div class="simple-font-styles few col5">
                        <button type="button" id="simple-position-static" class="font-style-icon relative simple-design-btn" data-level="position" value="static" title="static"></button>
                        <button type="button" id="simple-position-relative" class="font-style-icon relative simple-design-btn" data-level="position" value="relative" title="relative"></button>
                        <button type="button" id="simple-position-absolute" class="font-style-icon absolute simple-design-btn" data-level="position" value="absolute" title="absolute"></button>
                        <button type="button" id="simple-position-fixed" class="font-style-icon absolute simple-design-btn" data-level="position" value="fixed" title="fixed"></button>
                        <button type="button" id="simple-position-sticky" class="font-style-icon absolute simple-design-btn" data-level="position" value="sticky" title="sticky"></button>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-position-left">{$text_left}</label>
                        <input type="number" id="simple-position-left" class="simple-input add-unit" data-level="left" title="{$text_left}">
                        <select class="simple-input unit-input" data-level="left" title="{$text_left}">{$unit_option}</select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-position-right">{$text_right}</label>
                        <input type="number" id="simple-position-right" class="simple-input add-unit" data-level="right" title="{$text_right}">
                        <select class="simple-input unit-input" data-level="right" title="{$text_right}">{$unit_option}</select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-position-top">{$text_top}</label>
                        <input type="number" id="simple-position-top" class="simple-input add-unit" data-level="top" title="{$text_top}">
                        <select class="simple-input unit-input" data-level="top" title="{$text_top}">{$unit_option}</select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-position-bottom">{$text_bottom}</label>
                        <input type="number" id="simple-position-bottom" class="simple-input add-unit" data-level="bottom" title="{$text_bottom}">
                        <select class="simple-input unit-input" data-level="bottom" title="{$text_bottom}">{$unit_option}</select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-z-index">{$text_z_index}</label>
                        <input type="number" id="simple-z-index" class="simple-input" data-level="z-index" title="{$text_z_index}">
                    </div>
                </div>
            </div>
            <div class="simple-item">
                <button type="button" class="simple-menu-btn simple-menu filter-icon close-pass" title="{$text_filter}"></button>
                <div class="simple-control-menu close-pass">
                    <div class="simple-title">{$text_filter}</div>
                    <div id="simple-filter-items" class="simple-dynamic-items">
                        <div class="filter-item simple-dynamic-item">
                            <select class="simple-input filter-input" data-level="filter" data-type="type" title="{$text_filter}">
                                <option value="">{$text_select_default}</option>
                                {$filter_option}
                                <option value="inherit">inherit</option>
                                <option value="initial">initial</option>
                                <option value="unset">unset</option>
                            </select>
                            <input type="number" class="simple-input filter-input add-unit" data-level="filter" data-type="value" title="{$text_filter}">
                            <select class="simple-input filter-input unit-input" data-level="filter" data-type="unit" title="{$text_filter}">
                                <option value="px">px</option>
                                <option value="%">%</option>
                                <option value="deg">deg</option>
                            </select>
                            <button type="button" class="filter-move-btn simple-css-edit-btn add close-pass"></button>
                            <button type="button" class="filter-move-btn simple-css-edit-btn delete close-pass"></button>
                        </div>
                    </div>
                    <div class="simple-title">drop-shadow</div>
                    <div id="simple-shadow-drop" class="simple-shadow-area simple-dynamic-items">
                        <div class="shadow-item simple-dynamic-item">
                            <input type="number" class="simple-input shadow-input" data-level="filter" data-type="x" placeholder="X" title="{$text_filter}">
                            <input type="number" class="simple-input shadow-input" data-level="filter" data-type="y" placeholder="Y" title="{$text_filter}">
                            <input type="number" class="simple-input shadow-input" data-level="filter" data-type="blur" placeholder="Blur" title="{$text_filter}">
                            <button type="button" class="shadow-color-btn simple-design-color-btn" data-level="filter" data-type="color" title="{$text_filter}"></button>
                            <button type="button" class="shadow-move-btn simple-css-edit-btn add close-pass"></button>
                            <button type="button" class="shadow-move-btn simple-css-edit-btn delete close-pass"></button>
                        </div>
                    </div>
                    <div class="simple-title">Blend-mode</div>
                    <div class="simple-input-column">
                        <label for="simple-mix-blend-mode">mix-blend-mode</label>
                        <select id="simple-mix-blend-mode" class="simple-input" data-level="mix-blend-mode" title="mix-blend-mode">
                            <option value="">{$text_select_default}</option>
                            {$blend_option}
                        </select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-background-blend-mode">background-blend-mode</label>
                        <select id="simple-background-blend-mode" class="simple-input" data-level="background-blend-mode" title="background-blend-mode">
                            <option value="">{$text_select_default}</option>
                            {$blend_option}
                        </select>
                    </div>
                </div>
            </div>
            <div class="simple-item">
                <button type="button" class="simple-menu-btn simple-menu transform close-pass" title="{$text_transform}"></button>
                <div class="simple-control-menu close-pass">
                    <div class="simple-title">{$text_transform}</div>
                    <div id="simple-transform-items" class="simple-dynamic-items">
                        <div class="transform-item simple-dynamic-item">
                            <select class="simple-input transform-input" data-level="transform" data-type="type" title="{$text_filter}">
                                <option value="">{$text_select_default}</option>
                                {$trans_option}
                            </select>
                            <input type="text" class="simple-input transform-input add-unit" data-level="transform" data-type="value" title="{$text_transform}">
                            <button type="button" class="transform-move-btn simple-css-edit-btn add close-pass"></button>
                            <button type="button" class="transform-move-btn simple-css-edit-btn delete close-pass"></button>
                        </div>
                    </div>
                    <div class="simple-title">Transition</div>
                    <div class="simple-input-column">
                        <label for="simple-transition">Transition</label>
                        <input type="text" id="simple-transition" class="simple-input" data-level="transition" title="transition">
                    </div>
                    <div class="simple-title">{$text_opacity}</div>
                    <div class="simple-input-column">
                        <label for="simple-opacity">{$text_opacity}</label>
                        <input type="number" id="simple-opacity" class="simple-input" step="0.05" min="0" max="1" data-level="opacity" title="{$text_opacity}">
                    </div>
                    <div class="simple-title">Shape-outside</div>
                    <div class="simple-input-column">
                        <label for="simple-shape-outside">Shape-outside</label>
                        <input type="text" id="simple-shape-outside" list="shape-outside-datalist" class="simple-input" data-level="shape-outside" title="Shape-outside">
                        <datalist id="shape-outside-datalist">
                            <option value="none">none</option>
                            <option value="margin-box">margin-box</option>
                            <option value="content-box">content-box</option>
                            <option value="border-box">border-box</option>
                            <option value="padding-box">padding-box</option>
                            <option value="circle(50%)">circle(50%)</option>
                            <option value="ellipse(130px 140px at 20% 20%)">ellipse(150px 150px at 40% 20%)</option>
                            <option value="inset(10px 10px 10px 10px)">inset(10px 10px 10px 10px)</option>
                            <option value="polygon(10px 10px, 20px 20px, 30px 30px)">polygon(10px 10px, 20px 20px, 30px 30px)</option>
                            <option value="inset(10px 10px 10px 10px)">inset(10px 10px 10px 10px)</option>
                            <option value="url()">url()</option>
                            <option value="linear-gradient(45deg, rgba(255, 255, 255, 0) 150px, red 150px)">linear-gradient(45deg, rgba(255, 255, 255, 0) 150px, red 150px)</option>
                        </datalist>
                    </div>
                </div>
            </div>
            <div class="simple-item">
                <button type="button" class="simple-menu-btn simple-menu animation close-pass" title="{$text_Animation}"></button>
                <div class="simple-control-menu close-pass">
                    <div class="simple-title">{$text_Animation}</div>
                    <div class="simple-input-column">
                        <label for="simple-animation-name">{$text_Animation_name}</label>
                        <input type="text" id="simple-animation-name" class="simple-input simple-animation-input" data-level="animation-name" title="{$text_Animation_name}">
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-animation-delay">{$text_Animation_delay}</label>
                        <input type="number" id="simple-animation-delay" class="simple-input add-unit" data-level="animation-delay" title="{$text_Animation_delay}">
                        <input type="hidden" class="simple-input unit-input fixed-input" data-level="animation-delay" title="{$text_Animation_delay}" value="s">
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-animation-direction">{$text_Animation_direction}</label>
                        <select id="simple-animation-direction" class="simple-input" data-level="animation-direction" title="{$text_Animation_direction}">
                            <option value="">{$text_select_default}</option>
                            <option value="normal">normal</option>
                            <option value="reverse">reverse</option>
                            <option value="alternate">alternate</option>
                            <option value="alternate-reverse">alternate-reverse</option>
                            <option value="inherit">inherit</option>
                            <option value="initial">initial</option>
                            <option value="unset">unset</option>
                        </select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-animation-duration">{$text_Animation_duration}<span class="text-required">({$text_required})</span></label>
                        <input type="number" id="simple-animation-duration" class="simple-input add-unit" data-level="animation-duration" title="{$text_Animation_duration}">
                        <input type="hidden" class="simple-input unit-input fixed-input" data-level="animation-duration" title="{$text_Animation_duration}" value="s">
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-animation-fill-mode">{$text_Animation_fill_mode}</label>
                        <select id="simple-animation-fill-mode" class="simple-input" data-level="animation-fill-mode" title="{$text_Animation_fill_mode}">
                            <option value="">{$text_select_default}</option>
                            <option value="none">none</option>
                            <option value="forwards">forwards</option>
                            <option value="backwards">backwards</option>
                            <option value="both">both</option>
                            <option value="inherit">inherit</option>
                            <option value="initial">initial</option>
                            <option value="unset">unset</option>
                        </select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-animation-iteration-count">{$text_Animation_iteration}<span class="text-required">({$text_required})</span></label>
                        <input type="text" id="simple-animation-iteration-count" list="animation-iteration-datalist" class="simple-input" data-level="animation-iteration-count" title="{$text_Animation_iteration}">
                        <datalist id="animation-iteration-datalist">
                            <option value="infinite">infinite</option>
                            <option value="1">1</option>
                            <option value="2">2</option>
                            <option value="3">3</option>
                        </datalist>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-animation-play-state">{$text_Animation_state}</label>
                        <select id="simple-animation-play-state" class="simple-input" data-level="animation-play-state" title="{$text_Animation_state}">
                            <option value="">{$text_select_default}</option>
                            <option value="running">running</option>
                            <option value="paused">paused</option>
                            <option value="inherit">inherit</option>
                            <option value="initial">initial</option>
                            <option value="unset">unset</option>
                        </select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-animation-timing-function">{$text_Animation_timing}</label>
                        <input type="text" id="simple-animation-timing-function" class="simple-input" data-level="animation-timing-function" title="{$text_Animation_timing}">
                    </div>
                </div>
            </div>
            <div class="simple-item">
                <button type="button" class="simple-menu-btn simple-menu icon close-pass" title="Content"></button>
                <div class="simple-control-menu close-pass">
                    <div class="simple-title">Content</div>
                    <div class="web-icon-design simple-web-icon"><input type="text" class="web-icon-input simple-input" data-level="content" title="content"></div>
                    <div class="simple-title">Counter</div>
                    <div class="simple-input-column">
                        <label for="simple-counter-increment">counter-increment</label>
                        <input type="text" id="simple-counter-increment" class="simple-input" data-level="counter-increment" title="counter-increment">
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-counter-reset">counter-reset</label>
                        <input type="text" id="simple-counter-reset" class="simple-input" data-level="counter-reset" title="counter-reset">
                    </div>
                </div>
            </div>
            <div class="simple-item">
                <button type="button" class="simple-menu-btn simple-menu other close-pass" title="{$text_other}"></button>
                <div class="simple-control-menu close-pass">
                    <div class="simple-title">Overflow</div>
                    <div class="simple-input-column">
                        <label for="simple-overflow">overflow</label>
                        <select id="simple-overflow" class="simple-input" data-level="overflow" title="overflow">
                            <option value="">{$text_select_default}</option>
                            <option value="auto">auto</option>
                            <option value="visible">visible</option>
                            <option value="hidden">hidden</option>
                            <option value="clip">clip</option>
                            <option value="scroll">scroll</option>
                            <option value="overlay">overlay</option>
                            <option value="inherit">inherit</option>
                            <option value="initial">initial</option>
                            <option value="unset">unset</option>
                        </select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-overflow-x">overflow-x</label>
                        <select id="simple-overflow-x" class="simple-input" data-level="overflow-x" title="overflow-x">
                            <option value="">{$text_select_default}</option>
                            <option value="auto">auto</option>
                            <option value="visible">visible</option>
                            <option value="hidden">hidden</option>
                            <option value="clip">clip</option>
                            <option value="scroll">scroll</option>
                            <option value="overlay">overlay</option>
                            <option value="inherit">inherit</option>
                            <option value="initial">initial</option>
                            <option value="unset">unset</option>
                        </select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-overflow-y">overflow-y</label>
                        <select id="simple-overflow-y" class="simple-input" data-level="overflow-y" title="overflow-y">
                            <option value="">{$text_select_default}</option>
                            <option value="auto">auto</option>
                            <option value="visible">visible</option>
                            <option value="hidden">hidden</option>
                            <option value="clip">clip</option>
                            <option value="scroll">scroll</option>
                            <option value="overlay">overlay</option>
                            <option value="inherit">inherit</option>
                            <option value="initial">initial</option>
                            <option value="unset">unset</option>
                        </select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-scroll-snap-type">scroll-snap-type</label>
                        <select id="simple-scroll-snap-type" class="simple-input" data-level="scroll-snap-type" title="scroll-snap-type">
                            <option value="">{$text_select_default}</option>
                            <option value="none">none</option>
                            <option value="x">x</option>
                            <option value="y">y</option>
                            <option value="block">block</option>
                            <option value="inline">inline</option>
                            <option value="both">both</option>
                            <option value="x mandatory">x mandatory</option>
                            <option value="x proximity">x proximity</option>
                            <option value="y mandatory">y mandatory</option>
                            <option value="y proximity">y proximity</option>
                            <option value="both mandatory">both mandatory</option>
                            <option value="both proximity">both proximity</option>
                            <option value="inherit">inherit</option>
                            <option value="initial">initial</option>
                            <option value="unset">unset</option>
                        </select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-scroll-snap-align">scroll-snap-align</label>
                        <select id="simple-scroll-snap-align" class="simple-input" data-level="scroll-snap-align" title="scroll-snap-align">
                            <option value="">{$text_select_default}</option>
                            <option value="none">none</option>
                            <option value="start">start</option>
                            <option value="end">end</option>
                            <option value="center">center</option>
                            <option value="inherit">inherit</option>
                            <option value="initial">initial</option>
                            <option value="unset">unset</option>
                        </select>
                    </div>
                    <div class="simple-title">object-fit</div>
                    <div class="simple-input-column">
                        <label for="simple-object-fit">object-fit</label>
                        <select id="simple-object-fit" class="simple-input" data-level="object-fit" title="object-fit">
                            <option value="">{$text_select_default}</option>
                            <option value="contain">contain</option>
                            <option value="cover">cover</option>
                            <option value="fill">fill</option>
                            <option value="scale-down">scale-down</option>
                            <option value="none">none</option>
                            <option value="inherit">inherit</option>
                            <option value="initial">initial</option>
                            <option value="unset">unset</option>
                        </select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-object-position">object-position</label>
                        <input type="text" id="simple-object-position" class="simple-input" data-level="object-position" title="object-position">
                    </div>
                    <div class="simple-title">Cursor</div>
                    <div class="simple-input-column">
                        <label for="simple-cursor">Cursor</label>
                        <select id="simple-cursor" class="simple-input" data-level="cursor" title="cursor">
                            <option value="">{$text_select_default}</option>
                            {$cursor_option}
                            <option value="inherit">inherit</option>
                            <option value="initial">initial</option>
                            <option value="unset">unset</option>
                        </select>
                    </div>
                    <div class="simple-title">Table</div>
                    <div class="simple-input-column">
                        <label for="simple-table-layout">table-layout</label>
                        <select id="simple-table-layout" class="simple-input" data-level="table-layout" title="table-layout">
                            <option value="">{$text_select_default}</option>
                            <option value="auto">auto</option>
                            <option value="fixed">fixed</option>
                            <option value="inherit">inherit</option>
                            <option value="initial">initial</option>
                            <option value="unset">unset</option>
                        </select>
                    </div>
                    <div class="simple-input-column">
                        <label for="simple-border-collapse">border-collapse</label>
                        <select id="simple-border-collapse" class="simple-input" data-level="border-collapse" title="border-collapse">
                            <option value="">{$text_select_default}</option>
                            <option value="collapse">collapse</option>
                            <option value="separate">separate</option>
                            <option value="inherit">inherit</option>
                            <option value="initial">initial</option>
                            <option value="unset">unset</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="simple-item">
                <button type="button" class="simple-move-btn simple-menu parent close-pass" title="{$text_parent}"></button>
            </div>
            <div class="simple-item">
                <button type="button" class="simple-move-btn simple-menu prev close-pass" title="{$text_prev}"></button>
            </div>
            <div class="simple-item">
                <button type="button" class="simple-move-btn simple-menu next close-pass" title="{$text_next}"></button>
            </div>
        </div>
EOM;
}