<?php
/*
 * ページタイプ取得
*/
function get_page_types( $lp_flg = false ) {
    $result = array(
        'top' => __( 'TOPページ', 'dg-style' ),
    );
    //タクソノミータイプ取得
    $types = default_taxonomy_exclusion( array( 'category', 'post_tag' ) );
    if ( !empty( $types ) ) {
        foreach( (array)$types as $slug ) {
            $taxonomy = get_taxonomy( $slug );
            $result[ 'taxonomy' ][ $slug ] = $taxonomy->label;
        }
        $result[ 'taxonomy' ][ 'date' ] = __( '日付', 'dg-style' );
    }

    $custom_post_types = get_post_types( array( 'public' => true, 'has_archive' => true, '_builtin' => false ), 'objects' );
    foreach ( $custom_post_types as $post_type ) {
        if ( $post_type->name !== 'lp' ) {
            $result[ 'custom-post-archive' ][ $post_type->name ] = $post_type->label;
        }
    }

    //カスタム投稿タイプ取得
    $post_types = get_post_types( array( 'public' => true, ), 'objects' );
    foreach ( $post_types as $post_type ) {
        if ( $post_type->name !== 'attachment' ) {
            if ( $post_type->name === 'lp' ) {
                if ( $lp_flg ) {
                    $result[ 'single' ][ $post_type->name ] = $post_type->label;
                }
            } else {
                $result[ 'single' ][ $post_type->name ] = $post_type->label;
            }
        }
    }
    $add_types = array(
        'search' => __( '検索結果ページ', 'dg-style' ),
        '404' => __( '404ページ', 'dg-style' ),
        'author' => __( '記事作成者ページ', 'dg-style' ),
    );
    foreach( (array)$add_types as $key => $name ) {
        $result[ 'other' ][ $key ] = $name;
    }
    return $result;
}

/*
 * リンク検索
*/
add_action( 'wp_ajax_get_wordpress_page_link', 'get_wordpress_page_link' );
add_action( 'wp_ajax_nopriv_get_wordpress_page_link', 'get_wordpress_page_link' );
function get_wordpress_page_link() {
    $result = false;
    if ( isset( $_POST[ 'type' ] ) && $_POST[ 'type' ] !== 'top' && $_POST[ 'type' ] !== 'date' && $_POST[ 'type' ] !== 'author' && isset( $_POST[ 'keyword' ] ) && $_POST[ 'keyword' ] !== '' ) {
        $result = array();
        $keyword = $_POST[ 'keyword' ];
        if ( $_POST[ 'type' ] === 'post' || $_POST[ 'type' ] === 'single-lp' ) {
            $page_type = 'any';
            if ( $_POST[ 'type' ] === 'single-lp' ) {
                $page_type = 'lp';
            }
            if ( isset( $_POST[ 'page_type' ] ) && $_POST[ 'page_type' ] !== '' ) {
                $page_type = $_POST[ 'page_type' ];
            }
            $args = array(
                'post_type' => $page_type,
                'orderby' => 'date',
                'order' => 'DESC',
                'post_status' => array( 'publish', 'private' ),
                'posts_per_page' => 20,
                's' => $keyword,
            );
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) {
                while ( $query->have_posts() ) {
                    $query->the_post();
                    $post = $query->post;
                    $result[] = array(
                        'id' => $post->ID,
                        'title' => $post->post_title,
                        'link' => get_permalink( $post->ID ),
                        'type' => 'post',
                    );
                }
                wp_reset_postdata();
            }
        } else {
            global $wpdb;
            $terms = $wpdb->prefix . 'terms';
            $term_taxonomy = $wpdb->prefix . 'term_taxonomy';
            $pre = $wpdb->prepare( "SELECT * FROM $terms WHERE 1=%d AND name LIKE %s", 1, "%" . $keyword . "%" );
            if( $list = $wpdb->get_results( $pre ) ) {
                foreach( (array)$list as $term ) {
                    $term_link = get_term_link( (int)$term->term_id, $_POST[ 'type' ] );
                    if ( !is_wp_error( $term_link ) ) {
                        $result[] = array(
                            'id' => $term->term_id,
                            'title' => $term->name,
                            'link' => $term_link,
                            'type' => $_POST[ 'type' ],
                        );
                    }
                }
            }
        }
        if ( is_array( $result ) && count( $result ) === 0 ) {
            $result = false;
        }
    } else if ( isset( $_POST[ 'type' ] ) && $_POST[ 'type' ] === 'date' && isset( $_POST[ 'keyword' ] ) && $_POST[ 'keyword' ] !== '' ) {
        $result = array();
        $date = explode( '-', $_POST[ 'keyword' ] );
        if ( isset( $date[ 2 ] ) && is_numeric( $date[ 2 ] ) ) {
            $url = get_day_link( $date[ 0 ], $date[ 1 ], $date[ 2 ] );
        } elseif ( isset( $date[ 1 ] ) && is_numeric( $date[ 1 ] ) ) {
            $url = get_month_link( $date[ 0 ], $date[ 1 ] );
        } elseif ( isset( $date[ 0 ] ) && is_numeric( $date[ 0 ] ) ) {
            $url = get_year_link( $date[ 0 ] );
        }
        $result[] = array(
            'id' => '',
            'title' => $_POST[ 'keyword' ],
            'link' => $url
        );
    } else if ( isset( $_POST[ 'type' ] ) && $_POST[ 'type' ] === 'author' && isset( $_POST[ 'keyword' ] ) && $_POST[ 'keyword' ] !== '' ) {
        $args = array(
            'search' => '*' . $_POST[ 'keyword' ] . '*',
        );
        $user_query = new WP_User_Query( $args );
        if ( !empty( $user_query->results ) ) {
            $result = array();
            foreach ( $user_query->results as $user ) {
                $result[] = array(
                    'id' => $user->ID,
                    'title' => $user->display_name,
                    'link' => get_author_posts_url( $user->ID ),
                    'type' => 'author',
                );
            }
        }
    }
    echo json_encode( $result );
    exit();
}

/*
 * IDから情報取得
*/
add_action( 'wp_ajax_get_selected_ids_by_page', 'get_selected_ids_by_page' );
add_action( 'wp_ajax_nopriv_get_selected_ids_by_page', 'get_selected_ids_by_page' );
function get_selected_ids_by_page() {
    $result = false;
    if ( empty( $_POST[ 'type' ] ) ) {
        echo json_encode( $result );
        exit();
    }
    if ( $_POST[ 'type' ] === 'post' && isset( $_POST[ 'ids' ] ) && $_POST[ 'ids' ] !== '' ) {
        $result = array();
        $post_ids = explode( ',', $_POST[ 'ids' ] );
        foreach( (array)$post_ids as $post_id ) {
            $title = get_the_title( $post_id );
            $result[] = array(
                'id' => $post_id,
                'title' => $title,
            );
        }
    } else if ( $_POST[ 'type' ] === 'author' && isset( $_POST[ 'ids' ] ) && $_POST[ 'ids' ] !== '' ) {
        $result = array();
        $author_ids = explode( ',', $_POST[ 'ids' ] );
        foreach( (array)$author_ids as $user_id ) {
            $part = front_part_author_profile( $user_id, array( 'name' ) );
            $result[] = array(
                'id' => $user_id,
                'title' => $part[ 'name' ],
            );
        }
    } else if ( isset( $_POST[ 'ids' ] ) && $_POST[ 'ids' ] !== '' ) {
        $result = array();
        $taxonomy = $_POST[ 'type' ];
        $term_ids = explode( ',', $_POST[ 'ids' ] );
        foreach( (array)$term_ids as $term_id ) {
            $term = get_term( $term_id, $taxonomy );
            if ( !is_wp_error( $term ) ) {
                $result[] = array(
                    'id' => $term_id,
                    'title' => $term->name,
                );
            }
        }
    }
    echo json_encode( $result );
    exit();
}

/*
 * ターム取得
*/
add_action( 'wp_ajax_get_child_terms', 'get_child_terms' );
add_action( 'wp_ajax_nopriv_get_child_terms', 'get_child_terms' );
function get_child_terms() {
    $result = false;
    if ( isset( $_POST[ 'taxonomy' ] ) && isset( $_POST[ 'parent_id' ] ) ) {
        $args = array(
            'parent' => $_POST[ 'parent_id' ],
            'orderby' => 'id',
            'hide_empty' => false,
        );
        $terms = get_terms( $_POST[ 'taxonomy' ], $args );
        if ( !empty( $terms ) && !is_wp_error( $terms ) ){
            $result = array();
            foreach( (array)$terms as $term ) {
                $result[] = array(
                    'term_id' => $term->term_id,
                    'name' => $term->name
                );
            }
        }
    }
    echo json_encode( $result );
    exit();
}

/*
 * メニュー取得
*/
add_action( 'wp_ajax_get_wp_gmenus', 'get_wp_gmenus' );
add_action( 'wp_ajax_nopriv_get_wp_gmenus', 'get_wp_gmenus' );
function get_wp_gmenus() {
    $result = array();
    $nav_menus = wp_get_nav_menus();
    if ( is_array( $nav_menus ) && count( $nav_menus ) > 0 ) {
        foreach ( (array) $nav_menus as $menu ) {
            $result[] = $menu->name;
        }
    }
    echo json_encode( $result );
    exit();
}