<?php
/*
 * プロパティー追加
*/
function set_part_attr( $class, $value, $tab = false ) {
    $add_class = '';
    $attr = '';
    $css_property = '';
    if ( isset( $value[ 'event' ] ) ) {
        $event = $value[ 'event' ];
        $types = array( 'o', 'ot', 'od', 'et', 'eb', 'wt', 'wd', 'rt', 'rd', 'ci', 'cn', 'ap', 'el', 'se', );
        foreach( (array)$types as $key ) {
            if ( isset( $event[ $key ] ) && $event[ $key ] === '1' ) {
                $add_flg = false;
                /* CSS */
                if ( $key === 'ap' || $key === 'el' || $key === 'se' ) {
                    if ( isset( $event[ $key . '-v' ] ) && is_array( $event[ $key . '-v' ] ) && count( $event[ $key . '-v' ] ) > 0 ) {
                        $start_arr = array();
                        $end_arr = array();
                        foreach( (array)$event[ $key . '-v' ] as $css ) {
                            if ( isset( $css[ 'n' ] ) && $css[ 'n' ] !== '' && isset( $css[ 's' ] ) && $css[ 's' ] !== '' && isset( $css[ 'sc' ] ) && $css[ 'sc' ] !== '' && isset( $css[ 'e' ] ) && $css[ 'e' ] !== '' && isset( $css[ 'ec' ] ) && $css[ 'ec' ] !== '' ) {
                                $css_name = lcfirst( strtr( ucwords( strtr( $css[ 'n' ], [ '-' => ' ' ] ) ), [ ' ' => '' ] ) );
                                $css_property .= $css[ 'n' ] . ':' . $css[ 'sc' ] . ';';
                                $start_arr[ $css_name ] = array( 's' => $css[ 's' ], 'sc' => $css[ 'sc' ] );
                                $end_arr[ $css_name ] = array( 'e' => $css[ 'e' ], 'ec' => $css[ 'ec' ] );
                                $add_flg = true;
                            }
                        }
                        if ( $key === 'se' && isset( $event[ $key . '-t' ] ) ) {
                            if ( $event[ $key . '-t' ] !== '' ) {
                                $attr .= ' data-' . $key . '_target="' . $event[ $key . '-t' ] . '"';
                            } else {
                                $add_flg = false;
                            }
                        }
                        if ( $add_flg ) {
                            $attr .= ' data-' . $key . '_start="' . htmlspecialchars( json_encode( $start_arr ) ) . '"';
                            $attr .= ' data-' . $key . '_end="' . htmlspecialchars( json_encode( $end_arr ) ) . '"';
                        }
                    }
                } else {
                    $add_flg = true;
                }
                if ( $add_flg ) {
                    $big = strtoupper( $key );
                    $add_class .= ' DG' . $big;
                    /* 繰り返し */
                    if ( isset( $event[ $key . '-p' ] ) && $event[ $key . '-p' ] === '1' ) {
                        $add_class .= ' DG' . $big . 'P';
                    } else {
                        $add_class .= ' DG' . $big . 'S';
                    }
                    /* class */
                    if ( isset( $event[ $key . '-c' ] ) && $event[ $key . '-c' ] !== '' ) {
                        $attr .= ' data-' . $key . '_class="' . $event[ $key . '-c' ] . '"';
                    }
                    /* target */
                    if ( isset( $event[ $key . '-o' ] ) && $event[ $key . '-o' ] !== '' ) {
                        $attr .= ' data-' . $key . '_target="' . $event[ $key . '-o' ] . '"';
                    }
                    /* value */
                    if ( $key === 'et' || $key === 'eb' || $key === 'wt' || $key === 'wd' || $key === 'ci' || $key === 'cn' ) {
                        $point = '0';
                        if ( isset( $event[ $key . '-v' ] ) && $event[ $key . '-v' ] !== '' ) {
                            $point = $event[ $key . '-v' ];
                        }
                        $attr .= ' data-' . $key . '_value="' . $point . '"';
                    }
                }
            }
        }
        if ( $add_class !== '' ) {
            $add_class .= ' DGEVENTITEM';
        }
    }
    if ( $css_property !== '' ) {
        $attr .= ' style="' . $css_property . '"';
    }
    if ( $tab !== false ) {
        $attr .= ' aria-labelledby="' . $value[ 'parent' ] . '-' . $value[ 'id' ] . '" role="tabpanel"';
    }
    if ( $tab === true ) {
        $class .= ' tab-content on';
        $attr .= ' aria-hidden="false"';
    } elseif ( $tab === 'child' ) {
        $class .= ' tab-content';
        $attr .= ' aria-hidden="true"';
    }
    
    return ' class="' . $class . $add_class . '"' . $attr;
}

/*
 * スライドオプション設定
*/
function set_slide_attr( $slide ) {
    return ' data-slide="' . htmlspecialchars( json_encode( $slide ), ENT_QUOTES, 'UTF-8' ) . '"';
}

/*
 * rel追加
*/
function add_link_rel_value( $option ) {
    $attr = '';
    if ( isset( $option[ 'tag' ] ) && $option[ 'tag' ] === 'a' ) {
        $rels = array();
        $rel = array( 'nofollow', 'noreferrer', 'prefetch', 'alternate', 'author', 'bookmark', 'help', 'license', 'search', 'post-tag', 'ugc', 'sponsored' );
        foreach( (array)$rel as $name ) {
            if ( isset( $option[ $name ] ) && $option[ $name ] === '1' ) {
                $rels[] = $name;
            }
        }
        if ( is_array( $rels ) && count( $rels ) > 0 ) {
            $attr .= ' rel="' . implode( ' ', $rels ) . '"';
        }
    }
    if ( isset( $option[ 'aria-label' ] ) && $option[ 'aria-label' ] !== '' ) {
        $attr .= ' aria-label="' . $option[ 'aria-label' ] . '"';
    }
    return $attr;
}

/*
 * toggleデータ
*/
function add_toggle_data( $option ) {
    $attr = '';
    $class = '';
    if ( isset( $option[ 'toggle-item' ] ) && $option[ 'toggle-item' ] !== '' ) {
        $attr .= ' data-toggle="' . $option[ 'toggle-item' ] . '"';
        $class .= ' toggle-btn';
    }
    if ( isset( $option[ 'cookie-name' ] ) && $option[ 'cookie-name' ] !== '' ) {
        $attr .= ' data-cookie="' . $option[ 'cookie-name' ] . '"';
        $class .= ' cookie-btn';

        if ( isset( $option[ 'cookie-date' ] ) && $option[ 'cookie-date' ] !== '' ) {
            $time = (int)$option[ 'cookie-date' ];
            $unit = isset( $option[ 'cookie-unit' ] ) && $option[ 'cookie-unit' ] !== '' ? $option[ 'cookie-unit' ] : '1';
            switch ( $unit ) {
                case '1' :
                    $time = $time * 60;
                    break;
                case '2' :
                    $time = $time * 3600;
                    break;
                case '3' :
                    $time = $time * 86400;
                    break;
                case '4' :
                    $time = $time * 604800;
                    break;
                case '5' :
                    $time = $time * 2592000;
                    break;
            }
            $attr .= ' data-cookie_date="' . $time . '"';
        }
    }
    return array( 'attr' => $attr, 'class' => $class );
}

function get_part_item_thumbnail_src( $image, $option, $info ) {
    $size = 'thumbnail';
    if ( isset( $option[ 'size' ] ) ) {
        $size = $option[ 'size' ];
    }
    $src = '';
    $src_set = '';
    $alt = '';
    if ( $info[ 'page_info' ][ 'page_type' ] === 'author' ) {
        $user_image = isset( $option[ 'user' ] ) && $option[ 'user' ] === '2' ? 'user_image' : 'bg_image';
        if ( isset( $image[ $user_image ] ) ) {
            $image = $image[ $user_image ];
        }
    }
    if ( isset( $image[ $size ][ 'url' ] ) ) {
        $src = $image[ $size ][ 'url' ];
        $alt = isset( $image[ $size ][ 'alt' ] ) ? $image[ $size ][ 'alt' ] : '';
    } elseif ( isset( $image[ 'full' ][ 'url' ] ) ) {
        $src = $image[ 'full' ][ 'url' ];
        $alt = isset( $image[ 'full' ][ 'alt' ] ) ? $image[ 'full' ][ 'alt' ] : '';
    } elseif ( isset( $image[ 'url' ] ) ) {
        $src = $image[ 'url' ];
        $alt = isset( $image[ 'alt' ] ) ? $image[ 'alt' ]: '';
    }
    if ( isset( $option[ 'srcset' ] ) && $option[ 'srcset' ] === '1' && isset( $image[ 'full' ][ 'url' ] ) ) {
        foreach( (array)$image as $img ) {
            if ( isset( $img[ 'width' ] ) && $img[ 'width' ] !== '' ) {
                if ( $src_set !== '' ) {
                    $src_set .= ',';
                }
                $src_set .= $img[ 'url' ] . ' ' . $img[ 'width' ] . 'w';
            }
        }
    }
    return array( 'src' => $src, 'src_set' => $src_set, 'alt' => $alt );
}

function get_image_item_data( $arr ) {
    extract( $arr );
    $no_image_class = '';
    if ( $src === '' && $no_image_flg ) {
        $no_image_class = ' no-image';
        $src = $no_image;
    }
    $img_size = '';
    if ( isset( $option[ 'width' ] ) && $option[ 'width' ] !== '' ) {
        $img_size .= ' width="' . $option[ 'width' ] . '"';
    }
    if ( isset( $option[ 'height' ] ) && $option[ 'height' ] !== '' ) {
        $img_size .= ' height="' . $option[ 'height' ] . '"';
    }
    $lazy_load = $lazy_flg ? '' : ' loading="lazy"';
    if ( $src_set !== '' ) {
        $src_set = ' srcset="' . $src_set . '"';
    }
    $image = '<img src="' . $src . '"' . $src_set . ' alt="' . $alt . '" class="' . $class . '"' . $img_size . $lazy_load . '>';

    return [ 'image' => $image, 'no_image_class' => $no_image_class ];
}

function get_image_src_srcset( $images, $option ) {
    $src = '';
    $src_set = [];
    $size = 'thumbnail';
    if ( isset( $option[ 'thumbnail-size' ] ) && $option[ 'thumbnail-size' ] !== '' ) {
        $size = $option[ 'thumbnail-size' ];
    } elseif ( isset( $option[ 'size' ] ) && $option[ 'size' ] !== '' ) {
        $size = $option[ 'size' ];
    }
    if ( isset( $images[ $size ][ 'url' ] ) && $images[ $size ][ 'url' ] !== '' ) {
        $src = $images[ $size ][ 'url' ];
    } elseif ( isset( $images[ 'full' ][ 'url' ] ) && $images[ 'full' ][ 'url' ] !== '' ) {
        $src = $images[ 'full' ][ 'url' ];
    } elseif ( isset( $images[ 'url' ] ) ) {
        $src = $images[ 'url' ];
    }
    if ( isset( $option[ 'srcset' ] ) && $option[ 'srcset' ] === '1' && isset( $images[ 'full' ][ 'url' ] ) ) {
        foreach( (array)$images as $img ) {
            if ( isset( $img[ 'width' ] ) && $img[ 'width' ] !== '' ) {
                $src_set[] = $img[ 'url' ] . ' ' . $img[ 'width' ] . 'w';
            }
        }
    }
    return array( 'src' => $src, 'src_set' => implode( ',', $src_set ), );
}

function get_movie_music_attr( $arr ) {
    extract( $arr );
    /* 自動再生 */
    if ( isset( $option[ 'autoplay' ] ) && $option[ 'autoplay' ] !== '' ) {
        $attr .= ' autoplay';
    }
    /* ループ再生 */
    if ( isset( $option[ 'loop' ] ) && $option[ 'loop' ] !== '' ) {
        $attr .= ' loop';
    }
    /* 消音 */
    if ( isset( $option[ 'muted' ] ) && $option[ 'muted' ] !== '' ) {
        $attr .= ' muted';
    }
    /* preload */
    if ( isset( $option[ 'preload' ] ) && $option[ 'preload' ] !== '' ) {
        $preload = $option[ 'preload' ] === '1' ? 'metadata' : 'none';
        $attr .= ' preload="' . $preload . '"';
    }
    if ( $type === 'movie' ) {
        /* コントロール表示 */
        if ( isset( $option[ 'controls' ] ) && $option[ 'controls' ] !== '' ) {
            $attr .= ' controls';
        }
        /* サムネイル */
        if ( $image_flg && $image_src !== '' ) {
            $attr .= ' poster="' . $image_src . '"';
        }
    }
    return $attr;
}

function get_part_item_movie_src( $str ) {
    $str = preg_replace( '/<iframe([^<>]*?)src=[\'\"](.*?)[\'\"]([^<>]*?)>/s', '<iframe data-src="$2"$1$3>', $str );
    $str = preg_replace( '/<iframe([^<>]*?)class=[\'\"](.*?)[\'\"]([^<>]*?)>/s', '<iframe class="$2 dg-lazy DGEVENTITEM"$1$3>', $str );
    $str = preg_replace( '/<iframe(?![^>]+class)([^<>]*?)>/s', '<iframe class="dg-lazy DGEVENTITEM"$1>', $str );
    return preg_replace( '/<iframe(?![^>]+loading=[\'\"]?lazy)([^<>]*?)>/s', '<iframe$1 loading="lazy">', $str );
}

function get_part_item_thumbnail( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( in_array( $name, [ 'thumbnail', 'fixed', 'movie', 'author_image', 'user_image', 'bg_image', 'movie_thumbnail' ], true ) !== true || ( $name !== 'author_image' && $name !== 'fixed' && !isset( $value[ $name ] ) ) ) return false;
    $thumb_arr = [ 'lazyload' => $lazyload, 'option' => $option, 'info' => $info ];
    switch ( $name ) {
        case 'thumbnail' :
        case 'user_image' :
        case 'bg_image' :
            $thumb_arr[ 'value' ] = $value[ $name ];
            $thumb_arr[ 'url' ] = $url;
            $thumb_arr[ 'add_class' ] = '';
            if ( $part_slug === 'author' || $part_slug === 'single-author' ) {
                $thumb_arr[ 'title' ] = $value[ 'name' ];
            } else {
                $thumb_arr[ 'title' ] = $value[ 'title' ];
            }
            break;
        case 'fixed' :
            $thumb_arr[ 'value' ] = $info[ 'fixedImage' ];
            $thumb_arr[ 'url' ] = $url;
            $thumb_arr[ 'add_class' ] = '';
            if ( $part_slug === 'author' || $part_slug === 'single-author' ) {
                $thumb_arr[ 'title' ] = $value[ 'name' ];
            } else {
                $thumb_arr[ 'title' ] = $value[ 'title' ];
            }
            break;
        case 'author_image' :
            $type = isset( $option[ 'type' ] ) && $option[ 'type' ] !== '' ? $option[ 'type' ] : 'user_image';
            $thumb_arr[ 'value' ] = $value[ 'author' ][ $type ];
            $thumb_arr[ 'url' ] = $value[ 'author' ][ 'url' ];
            $thumb_arr[ 'title' ] = $value[ 'author' ][ 'name' ];
            $thumb_arr[ 'add_class' ] = 'author-image';
            break;
        case 'movie' :
        case 'movie_thumbnail' :
            $image_type = 'thumbnail';
            if ( isset( $option[ 'thumbnail-type' ] ) && $option[ 'thumbnail-type' ] !== '' ) {
                $image_type = $option[ 'thumbnail-type' ];
            }
            $thumb_arr[ 'value' ] = $value[ $image_type ];
            $thumb_arr[ 'url' ] = $url;
            $thumb_arr[ 'title' ] = isset( $value[ 'name' ] ) ? $value[ 'name' ] : $value[ 'title' ];
            $thumb_arr[ 'add_class' ] = '';
            if ( !is_array( $option ) ) {
                $option = array();
            }
            $option[ 'movie' ] = isset( $value[ $name ][ 'value' ] ) ? $value[ $name ][ 'value' ] : '';
            $thumb_arr[ 'option' ] = $option;
            break;
    }
    if ( ( $name === 'movie' || $name === 'movie_thumbnail' ) && isset( $value[ $name ][ 'value' ] ) && $value[ $name ][ 'value' ] !== '' && $value[ $name ][ 'type' ] === '3' ) {
        $video = get_part_item_movie_src( $value[ $name ][ 'value' ] );
        $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'movie-thumbnail ' . $option[ 'class' ] : 'movie-thumbnail';
        return '<div class="' . $class . '">' . $video . '</div>';
    } else {
        return create_one_post_thumbnail( $thumb_arr );
    }
}

function get_text_image_btn_html( $arr ) {
    extract( $arr );
    $class = '';
    $attr = '';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    if ( $tag === 'button' ) {
        $attr = ' type="button"';
        $attr .= add_link_rel_value( $option );
        if ( isset( $option[ 'toggle-type' ] ) && $option[ 'toggle-type' ] === '3' ) {
            $class .= ' ab-toggle-btn';
            $attr .= ' value="' . ( isset( $option[ 'testab' ] ) ? $option[ 'testab' ] : 'main' ) . '"';
        } elseif ( isset( $option[ 'toggle-type' ] ) && $option[ 'toggle-type' ] === '2' ) {
            $class .= ' dark-toggle-btn';
        } else {
            $toggle_data = add_toggle_data( $option );
            $attr .= $toggle_data[ 'attr' ];
            $class .= $toggle_data[ 'class' ];
        }
    } elseif ( $tag === 'a' && isset( $option[ 'link' ] ) && $option[ 'link' ] !== '' ) {
        if ( isset( $option[ 'parent' ] ) && $option[ 'parent' ] !== '' ) {
            $a_attr = add_link_rel_value( $option );
            $target = isset( $option[ 'new-tab' ] ) && $option[ 'new-tab' ] === '1' ? ' target="_blank"' : '';
            $item_html = '<a href="' . $option[ 'link' ] . '" class="link-tag link-item"' . $target . $a_attr . '>' . $item_html . '</a>';
            $tag = $option[ 'parent' ];
        } else {
            $class .= ' link-tag';
            $attr = ' href="' . $option[ 'link' ] . '"';
            $attr .= add_link_rel_value( $option );
            if ( isset( $option[ 'new-tab' ] ) && $option[ 'new-tab' ] === '1' ) {
                $attr .= ' target="_blank"';
            }
        }
        $toggle_data = add_toggle_data( $option );
        $attr .= $toggle_data[ 'attr' ];
        $class .= $toggle_data[ 'class' ];
    }
    return [ 'tag' => $tag, 'class' => $class, 'attr' => $attr, 'item_html' => $item_html ];
}

function get_part_item_text( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( in_array( $name, [ 'title', 'author', 'comment', 'sub', 'name' ], true ) !== true || !isset( $value[ $name ] ) || $value[ $name ] === '' ) return false;
    $part_class = '';
    $tag = 'h2';
    $rel = ' rel="author"';
    switch ( $part_slug ) {
        case 'post_list' :
        case 'taxonomy-post_list' :
        case 'single-recommend' :
        case 'single-paging' :
            $part_class = 'page-title';
            break;
        case 'categories' :
            $part_class = 'category-name';
            if ( $name === 'sub' ) {
                $part_class = 'sub-title';
                $tag = 'span';
            }
            break;
        case 'new-comments' :
            $part_class = 'comment-' . $name;
            $tag = 'span';
            if ( $name === 'title' ) {
                $tag = 'h2';
            } else if ( $name === 'comment' ) {
                $tag = 'p';
            }
            break;
        case 'taxonomy-title' :
            $part_class = $name . '-text';
            $tag = 'none';
            break;
        case 'author' :
        case 'single-author' :
            $part_class = 'author-name';
            $tag = 'h2';
            break;
    }
    $title = $value[ $name ];
    if ( isset( $option[ 'count' ] ) && $option[ 'count' ] !== '' ) {
        $after = '';
        if ( isset( $option[ 'after' ] ) && $option[ 'after' ] !== '' ) {
            $after = $option[ 'after' ];
        }
        $title = character_limit( $title, (int)$option[ 'count' ], $after );
    }
    if ( isset( $option[ 'tag' ] ) && $option[ 'tag' ] !== '' ) {
        $tag = $option[ 'tag' ];
    }
    if ( $part_slug === 'taxonomy-title' && ( !( isset( $option[ 'tag' ] ) && $option[ 'tag' ] !== '' ) || $tag === 'none' ) ) {
        return $title;
    }
    if ( isset( $option[ 'link' ] ) && $option[ 'link' ] === '1' ) {
        $text_aria_label = __( 'のページをもっと見る', 'dg-style' );
        $title = '<a href="' . $url . '" class="page-link link-tag" aria-label="' . $title . $text_aria_label . '"' . $rel . '>' . $title . '</a>';
    }
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? $part_class . ' ' . $option[ 'class' ] : $part_class;
    return '<' . $tag . ' class="' . $class . '">' . $title . '</' . $tag . '>';
}

function get_part_item_description( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( ( $name !== 'content' && $name !== 'description' ) || $value[ $name ] === '' ) return false;
    $part_class = 'page-content';
    $label = '';
    $rel = '';
    switch ( $part_slug ) {
        case 'categories' :
            $part_class = 'description';
            $label = $value[ 'title' ];
            break;
        case 'author' :
        case 'single-author' :
            $part_class = 'description';
            $label = $value[ 'name' ];
            $rel = ' rel="author"';
            break;
    }
    if ( $part_slug === 'categories' || $name === 'description' ) {
        $part_class = 'description';
    }
    $content = $value[ $name ];
    if ( isset( $option[ 'count' ] ) && $option[ 'count' ] !== '' ) {
        $after = '';
        if ( isset( $option[ 'after' ] ) && $option[ 'after' ] !== '' ) {
            $after = $option[ 'after' ];
        }
        $content = character_limit( $content, (int)$option[ 'count' ], $after );
    }
    if ( isset( $option[ 'link' ] ) && $option[ 'link' ] === '1' ) {
        $text_aria_label = __( 'のページをもっと見る', 'dg-style' );
        $content = '<a href="' . $url . '" class="page-link link-tag" aria-label="' . $label . $text_aria_label . '"' . $rel . '>' . $content . '</a>';
    }
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? $part_class . ' ' . $option[ 'class' ] : $part_class;
    return '<p class="' . $class . '">' . $content . '</p>';
}

function get_part_item_more( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( $name !== 'more' ) return false;
    $text_aria_label = __( 'のページをもっと見る', 'dg-style' );
    $label = $value[ 'title' ];
    $rel = '';
    if ( $part_slug === 'author' || $part_slug === 'single-author' ) {
        $label = $value[ 'name' ];
        $rel = ' rel="author"';
    }
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? ' ' . $option[ 'class' ] : '';
    $text = isset( $option[ 'text' ] ) ? $option[ 'text' ] : '';
    if ( isset( $option[ 'link-type' ] ) && $option[ 'link-type' ] === '2' ) {
        return '<button type="button" data-post_id="' . $value[ 'postId' ] . '" class="DGREALTIMEPOST' . $class . '" aria-label="' . $label . $text_aria_label . '"' . $rel . '>' . $text . '</button>';
    }
    return '<a href="' . $url . '" class="page-link link-tag more-link' . $class . '" aria-label="' . $label . $text_aria_label . '"' . $rel . '>' . $text . '</a>';
}

function get_part_item_date( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( $name !== 'date' || !isset( $value[ $name ] ) ) return false;
    $tag = isset( $option[ 'tag' ] ) && $option[ 'tag' ] !== '' ? $option[ 'tag' ] : 'time';
    $format = '';
    $attr = '';
    $time = '';
    switch ( $part_slug ) {
        case 'post_list' :
        case 'taxonomy-post_list' :
        case 'single-recommend' :
        case 'single-paging' :
            $id = $item[ 'id' ];
            $time = $value[ $name ][ $id ][ 'format' ];
            if ( $tag === 'time' ) {
                $attr = ' datetime="' . $value[ $name ][ $id ][ 'date' ] . '"';
            }
            if ( isset( $value[ $name ][ $id ][ 'days' ][ 'year' ] ) ) {
                $time = $value[ $name ][ $id ][ 'days' ][ 'year' ] . __( '年', 'dg-style' );
                if ( isset( $value[ $name ][ $id ][ 'days' ][ 'month' ] ) && $value[ $name ][ $id ][ 'days' ][ 'month' ] > 0 ) {
                    $time .= $value[ $name ][ $id ][ 'days' ][ 'month' ] . __( 'ヶ月', 'dg-style' );
                }
                $time .= __( '前', 'dg-style' );
            } elseif ( isset( $value[ $name ][ $id ][ 'days' ][ 'month' ] ) ) {
                $time = $value[ $name ][ $id ][ 'days' ][ 'month' ] . __( 'ヶ月前', 'dg-style' );
            } elseif ( isset( $value[ $name ][ $id ][ 'days' ][ 'week' ] ) ) {
                $time = $value[ $name ][ $id ][ 'days' ][ 'week' ] . __( '週間前', 'dg-style' );
            } elseif ( isset( $value[ $name ][ $id ][ 'days' ][ 'day' ] ) ) {
                $time = $value[ $name ][ $id ][ 'days' ][ 'day' ] . __( '日前', 'dg-style' );
            } elseif ( isset( $value[ $name ][ $id ][ 'days' ][ 'time' ] ) ) {
                $time = $value[ $name ][ $id ][ 'days' ][ 'time' ] . __( '時間前', 'dg-style' );
            }
            break;
        case 'new-comments' :
            $format = isset( $option[ 'format' ] ) && $option[ 'format' ] !== '' ? $option[ 'format' ] : 'Y-m-d';
            $date = new DateTime( $value[ $name ] );
            $time = $date->format( $format );
            if ( $tag === 'time' ) {
                $attr = ' datetime="' . $value[ $name ] . '"';
            }
            break;
    }
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'page-date ' . $name . ' ' . $option[ 'class' ] : 'page-date ' . $name;
    return '<' . $tag . ' class="' . $class . '"' . $attr . '>' . $time . '</' . $tag . '>';
}

function get_part_item_gravatar( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    $size = '300';
    if ( isset( $option[ 'thumbnail-size' ] ) ) {
        $size = $option[ 'thumbnail-size' ];
    }
    if ( $name !== 'gravatar' || !isset( $value[ $name ] ) || !isset( $value[ $name ][ $size ] ) ) return false;
    $gravatar =  $value[ $name ][ $size ];
    if ( isset( $option[ 'link' ] ) && $option[ 'link' ] === '1' ) {
        $text_aria_label = __( 'のページをもっと見る', 'dg-style' );
        $gravatar = '<a href="' . $url . '" class="page-link link-tag" aria-label="' . $value[ 'name' ] . $text_aria_label . '" rel="author">' . $gravatar . '</a>';
    }
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'author-gravatar ' . $option[ 'class' ] : 'author-gravatar';
    return '<div class="' . $class . '">' . $gravatar . '</div>';
}

function get_part_item_user_sns( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( $name !== 'user_sns' || !isset( $value[ $name ] ) || !( is_array( $value[ $name ] ) && count( $value[ $name ] ) > 0 ) ) return false;
    $sns_list = '';
    foreach( (array)$value[ $name ] as $sns => $sns_url ) {
        if ( $sns === 'mail' ) {
            $sns_url = 'mailto:' . $sns_url;
        }
        $sns_list .= '<a href="' . $sns_url . '" class="sns-item link-tag ' . $sns . '" target="_blank">' . $sns . '</a>';
    }
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'user-sns ' . $option[ 'class' ] : 'user-sns';
    return '<div class="' . $class . '">' . $sns_list . '</div>';

}

function get_part_item_author_name( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( $name !== 'author' || !isset( $value[ $name ] ) || !isset( $value[ $name ][ 'name' ] ) ) return false;
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'author vcord author-name ' . $option[ 'class' ] : 'author vcord author-name';
    if ( isset( $option[ 'link' ] ) && $option[ 'link' ] === '1' ) {
        $text_aria_label = __( 'のページをもっと見る', 'dg-style' );
        return '<a href="' . $value[ $name ][ 'url' ] . '" class="' . $class . 'author-link link-tag" rel="author" aria-label="' . $value[ $name ][ 'name' ] . $text_aria_label . '">' . $value[ $name ][ 'name' ] . '</a>';
    } else {
        return '<span class="' . $class . '">' . $value[ $name ][ 'name' ] . '</span>';
    }
}

function get_part_item_views_hot( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    $type = isset( $option[ 'type' ] ) && $option[ 'type' ] !== '' ? $option[ 'type' ] : 'views';
    if ( ( $name !== 'views' && $name !== 'hot' ) || !isset( $value[ $name ] ) || !isset( $value[ $name ][ $type ] ) ) return false;
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? ' ' . $option[ 'class' ] : '';
    switch ( $name ) {
        case 'views' :
            $text = isset( $option[ 'text' ] ) && $option[ 'text' ] !== '' ? $option[ 'text' ] : 'view';
            return '<span class="view' . $class . '"><span class="view-count">' . $value[ $name ][ $type ] . '</span><span class="view-text">' . $text . '</span></span>';
            break;
        case 'hot' :
            $text = isset( $option[ 'text' ] ) && $option[ 'text' ] !== '' ? $option[ 'text' ] : '';
            return '<span class="hot-text' . $class . '">' . $text . '</span>';
            break;
    }
}

function get_part_item_comment( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( $name !== 'comment' || !isset( $value[ $name ] ) ) return false;
    $text = isset( $option[ 'text' ] ) && $option[ 'text' ] !== '' ? $option[ 'text' ] : 'comments';
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'comment ' . $option[ 'class' ] : 'comment';
    return '<span class="' . $class . '"><span class="comment-count">' . $value[ $name ] . '</span><span class="comment-text">' . $text . '</span></span>';
}

function get_part_item_postmeta( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( $name !== 'postmeta' || !isset( $value[ $name ] ) || !( isset( $option[ 'type' ] ) && $option[ 'type' ] !== '' ) ) return false;
    $type = $option[ 'type' ];
    $post_meta = $value[ $name ][ $option[ 'type' ] ];
    $tag = isset( $option[ 'tag' ] ) && $option[ 'tag' ] !== '' ? $option[ 'tag' ] : 'div';
    $class = 'post-meta ' . $type . ( isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? ' ' . $option[ 'class' ] : '' );
    if ( isset( $option[ 'attr' ] ) && $option[ 'attr' ] !== '' ) {
        $add_attr = $tag === 'button' ? ' type="button"' : '';
        $subtext = isset( $option[ 'subtext' ] ) ? $option[ 'subtext' ] : '';
        return '<' . $tag . ' class="' . $class . '" ' . $option[ 'attr' ] . '="' . $post_meta . '"' . $add_attr . '>' . $subtext . '</' . $tag . '>';
    }
    return '<' . $tag . ' class="' . $class . '">' . $post_meta . '</' . $tag . '>';
}

function get_part_item_new_mark( $arr ) {
    extract( $arr );
    $id = $item[ 'id' ];
    $name = $item[ 'slug' ];
    if ( $name !== 'new' || !isset( $value[ $name ] ) || !isset( $value[ $name ][ $id ] ) ) return false;
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'new-mark ' . $id . ' ' . $option[ 'class' ] : 'new-mark ' . $id;
    $text = isset( $option[ 'text' ] ) && $option[ 'text' ] !== '' ? $option[ 'text' ] : '';
    return '<div class="' . $class . '">' . $text . '</div>';
}

function get_part_item_bookmark( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( $name !== 'bookmark' || !isset( $value[ $name ] ) || !( isset( $value[ 'postId' ] ) && $value[ 'postId' ] !== '' ) ) return false;
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'add-bookmark bookmark-btn ' . $option[ 'class' ] : 'add-bookmark bookmark-btn';
    $text = '';
    if ( isset( $option[ 'text' ] ) && $option[ 'text' ] !== '' ) {
        $text = '<span class="text">' . $option[ 'text' ] . '</span>';
    }
    $count = '';
    if ( isset( $option[ 'count' ] ) && $option[ 'count' ] === '1' ) {
        $count = '<span class="count">' . $value[ $name ] . '</span>';
    }
    return '<button type="button" class="' . $class . '" value="' . $value[ 'postId' ] . '" aria-label="' . __( 'この記事をブックマークする', 'dg-style' ) . '">' . $text . $count . '</button>';
}

/*
 * タクソノミーリスト
*/
function get_part_item_taxonomy( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( strpos( $name, 'tax-' ) === false || !isset( $value[ $name ] ) || !( is_array( $value[ $name ] ) && count( $value[ $name ] ) > 0 ) ) return false;
    $tax_list = $value[ $name ];
    if ( isset( $option[ 'count' ] ) && $option[ 'count' ] !== '' && $option[ 'count' ] !== '0' ) {
        $tax_list = array_slice( $tax_list, 0, (int)$option[ 'count' ] );
    }
    $list = '';
    $taxonomy = str_replace( 'tax-', '', $name );
    foreach( (array)$tax_list as $term ) {
        $rel = '';
        if ( $taxonomy === 'post_tag' ) {
            $rel = ' rel="tag"';
        }
        $list .= '<li class="term-item ' . $term[ 'slug' ] . ' ' . $taxonomy . '-item"><a href="' . $term[ 'term_link' ] . '" class="' . $taxonomy . '-link term-link link-tag" aria-label="' . $term[ 'name' ] . __( 'のページをもっと見る', 'dg-style' ) . '"' . $rel . '>' . $term[ 'name' ] . '</a></li>';
    }
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? $taxonomy . '-list taxonomy-list ' . $option[ 'class' ] : $taxonomy . '-list taxonomy-list';
    return '<ul class="' . $class . '">' . $list . '</ul>';
}

function get_part_item_sns( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( $name !== 'sns' ) return false;
    return get_part_item_sns_list( $option, $url );
}

function get_part_item_evaluate( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( $name !== 'evaluate' || !isset( $value[ $name ] ) ) return false;
    return get_part_item_evaluate_summary( $value[ $name ], $option );
}

function get_part_item_search_input( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( $name !== 'input' ) return false;
    $keyword = '';
    if ( isset( $info[ 'page_info' ][ 'taxonomy' ] ) && $info[ 'page_info' ][ 'taxonomy' ] === 'search' ) {
        $keyword = isset( $info[ 'page_info' ][ 'term_id' ] ) ? $info[ 'page_info' ][ 'term_id' ] : '';
    }
    $placeholder = isset( $option[ 'text' ] ) ? ' placeholder="' . $option[ 'text' ] . '" aria-label="' . $option[ 'text' ] . '"' :'';
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'search-input search-item ' . $option[ 'class' ] : 'search-input search-item';
    $realtime_cnt = '';
    if ( isset( $info[ 'realtime' ] ) && $info[ 'realtime' ] === '1' ) {
        $class .= ' realtime-search';
    }
    return '<input type="search" name="s" class="' . $class . '"' . $placeholder . ' value="' . $keyword . '"' . $realtime_cnt . '>';
}

function get_part_item_search_btns( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( ( $name !== 'submit' && $name !== 'speech' && $name !== 'free' ) ) return false;
    $tag = 'button';
    $class = '';
    $attr = '';
    $aria_label = '';
    switch ( $name ) {
        case 'submit' :
            $class = 'search-button';
            $attr = ' type="submit"';
            $aria_label = ' aria-label="' . __( '検索する', 'dg-style' ) . '"';
            break;
        case 'speech' :
            $class = 'speech-button';
            $attr = ' type="button"';
            $aria_label = ' aria-label="' . __( '音声入力する', 'dg-style' ) . '"';
            break;
        case 'free' :
            $tag = isset( $option[ 'tag' ] ) ? $option[ 'tag' ] :'h2';
            $class = 'search-free-text';
            break;
    }
    if ( isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ) {
        $class .= ' ' . $option[ 'class' ];
    }
    $text = isset( $option[ 'text' ] ) ? $option[ 'text' ] :'';
    return '<' . $tag . ' class="' . $class . '"' . $attr . $aria_label . '>' . $text . '</' . $tag . '>';
}

function get_part_item_search_lang( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( $name !== 'lang' ) return false;
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'lang-select ' . $option[ 'class' ] : 'lang-select';
    $options = '';
    $langs = array( 'ja-JP' => '日本語', 'en-US' => 'United States', 'en-GB' => 'United Kingdom', 'zh-CN' => '中文', 'ko-KR' => '한국어' );
    foreach( (array)$langs as $key => $name ) {
        $selected = '';
        if ( isset( $info[ 'page_info' ][ 'slang' ] ) && $info[ 'page_info' ][ 'slang' ] === $key ) {
            $selected = ' selected';
        } elseif ( !isset( $info[ 'page_info' ][ 'slang' ] ) && $key === 'ja-JP' ) {
            $selected = ' selected';
        }
        $options .= '<option value="' . $key . '"' . $selected . '>' . $name . '</option>';
    }
    return '<select class="' . $class . '" name="slang" aria-label="' . __( '音声言語選択', 'dg-style' ) . '">' . $options . '</select>';
}

function get_part_item_search_srange( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( $name !== 'srange' ) return false;
    $type = isset( $option[ 'type' ] ) ? $option[ 'type' ] :'1';
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'search-range search-item ' . $option[ 'class' ] : 'search-range search-item';
    if ( $type === '3' ) {
        $srange_checked = '';
        $srange1_checked = '';
        $srange2_checked = '';
        if ( isset( $info[ 'page_info' ][ 'taxonomy' ] ) && $info[ 'page_info' ][ 'taxonomy' ] === 'search' ) {
            $srange_checked = isset( $info[ 'page_info' ][ 'srange' ] ) && $info[ 'page_info' ][ 'srange' ] === '' ? ' selected' : '';
            $srange1_checked = isset( $info[ 'page_info' ][ 'srange' ] ) && $info[ 'page_info' ][ 'srange' ] === '1' ? ' selected' : '';
            $srange2_checked = isset( $info[ 'page_info' ][ 'srange' ] ) && $info[ 'page_info' ][ 'srange' ] === '2' ? ' selected' : '';
        }
        $text_select1 = __( 'タイトル＋本文', 'dg-style' );
        $text_select2 = __( 'タイトルのみ', 'dg-style' );
        $text_select3 = __( '本文のみ', 'dg-style' );
        $text_srange_aria_label = __( '検索範囲選択', 'dg-style' );
        return <<< EOM
            <select class="search-select {$class}" name="srange" aria-label="{$text_srange_aria_label}">
                <option value=""{$srange_checked}>{$text_select1}</option>
                <option value="1"{$srange1_checked}>{$text_select2}</option>
                <option value="2"{$srange2_checked}>{$text_select3}</option>
            </select>
EOM;
    } else {
        return '<input type="hidden" name="srange" class="' . $class . '" value="' . $type . '">';
    }
}

function get_part_item_search_taxonomy( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    $tax_slug = str_replace( 'tax-', '', $name );
    if ( strpos( $name, 'tax-' ) === false || !isset( $info[ 'terms' ][ $tax_slug ] ) ) return false;
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? ' ' . $option[ 'class' ] : '';
    $stax_value = array();
    if ( isset( $info[ 'page_info' ][ 'taxonomy' ] ) && $info[ 'page_info' ][ 'taxonomy' ] === 'search' ) {
        $stax_value = isset( $info[ 'page_info' ][ 'stax' ] ) && $info[ 'page_info' ][ 'stax' ] !== '' ? explode( ',', $info[ 'page_info' ][ 'stax' ] ) : array();
    }
    if ( isset( $option[ 'form' ] ) && $option[ 'form' ] === '2' ) {
        $tax_name = '';
        $check_list = '';
        foreach( (array)$info[ 'terms' ][ $tax_slug ] as $term ) {
            $term_slug = $term[ 'slug' ] !== '' ? $tax_slug . '-' . $term[ 'slug' ] : '';
            if ( $term_slug !== '' ) {
                $checked = '';
                if ( in_array( $term_slug, $stax_value, true ) === true ) {
                    $checked = ' checked';
                }
                $check_list .= '<label class="search-checkbox-label"><input type="checkbox" class="search-checkbox" value="' . $term_slug . '"' . $checked . '><span class="search-checkbox-name">' . $term[ 'name' ] . '</span></label>';
            } elseif ( $term_slug === '' && isset( $option[ 'title' ] ) && $option[ 'title' ] !== '' ) {
                $tax_name = '<p class="search-taxonomy-title ' . $tax_slug . '">' . $term[ 'name' ] . '</p>';
            }
        }
        return '<div class="taxonomy-search-area ' . $tax_slug . $class . '">' . $tax_name . '<div class="taxonomy-check-list ' . $tax_slug . '">' . $check_list . '</div></div>';
    } else {
        $tax_select = '';
        foreach( (array)$info[ 'terms' ][ $tax_slug ] as $term ) {
            $term_slug = $term[ 'slug' ] !== '' ? $tax_slug . '-' . $term[ 'slug' ] : '';
            $selected = '';
            if ( in_array( $term_slug, $stax_value, true ) === true ) {
                $selected = ' selected';
            }
            $tax_select .= '<option value="' . $term_slug . '"' . $selected . '>' . $term[ 'name' ] . '</option>';
        }
        return '<select class="search-select search-taxonomy-select' . $class . '">' . $tax_select . '</select>';
    }
}

function get_part_item_paging_button( $arr ) {
    extract( $arr );
    if ( ( $option[ 'type' ] !== '2' && $option[ 'type' ] !== '4' ) || $option[ 'next' ][ 'one' ] === 'none' ) return false;
    $more_text = isset( $option[ 'more' ] ) && $option[ 'more' ] !== '' ? $option[ 'more' ] : __( 'もっと見る', 'dg-style' );
    $count_text = '';
    if ( isset( $option[ 'count' ] ) && $option[ 'count' ] === '1' && isset( $archive[ 'postCount' ][ 'until' ] ) && isset( $archive[ 'postCount' ][ 'total' ] ) ) {
        $count = (int)$archive[ 'postCount' ][ 'total' ] - (int)$archive[ 'postCount' ][ 'until' ];
        $remnant = $count;
        if ( isset( $option[ 'count-text' ] ) && preg_match( '/\[count\]/', $option[ 'count-text' ] ) ) {
            $remnant = str_replace( '[count]', $remnant, $option[ 'count-text' ] );
        }
        $count_text = '<span class="post-count count-' . $count . '">' . $remnant . '</span>';
    }
    $add_class = '';
    if ( $option[ 'type' ] === '4' ) {
        $add_class = ' DGEVENTITEM scroll-paging-area';
    }
    $exclusive = '';
    if ( isset( $option[ 'target' ] ) && $option[ 'target' ] !== '' ) {
        $exclusive = ' data-exclusive="' . $option[ 'target' ] . '"';
    }
    return '<button class="paging-more-btn' . $add_class . '" type="button" value="' . $option[ 'next' ][ 'one' ] . '" aria-label="' . __( '次の記事を表示する', 'dg-style' ) . '"' . $exclusive . '>' . $more_text . $count_text . '</button>';
}

function get_paging_part_around( $arr ) {
    extract( $arr );
    $button = '';
    if ( isset( $option[ $key ] ) && $option[ $key ] === '1' ) {
        $text = isset( $option[ $key . 'n' ] ) ? $option[ $key . 'n' ] : '';
        if ( $option[ $way ][ $unit ] === 'none' ) {
            $button = '<span class="paging-link disabled ' . $class. '" aria-label="' . $label . '" aria-disabled="true">' . $text . '</span>';
        } else {
            $button = '<a class="paging-link ' . $class. '" href="' . get_pagenum_link( $option[ $way ][ $unit ] ) . '" aria-label="' . $label . '">' . $text . '</a>';
        }
    }
    return $button;
}
function get_paging_part_both( $option, $way ) {
    $button = '';
    if ( isset( $option[ 'both' ] ) && $option[ 'both' ] === '1' && $option[ $way ][ 'max' ] !== 'none' && ( ( $way === 'prev' && ( (int)$option[ 'number' ][ 'current' ] - (int)$option[ 'range' ] ) > (int)$option[ $way ][ 'max' ] ) || ( $way === 'next' && ( (int)$option[ 'number' ][ 'current' ] + (int)$option[ 'range' ] ) < (int)$option[ $way ][ 'max' ] ) ) ) {
        if ( $way === 'next' ) {
            $button .= '<span class="paging-link abb first-abb">...</span>';
        }
        $button .= '<a class="paging-link first" href="' . get_pagenum_link( $option[ $way ][ 'max' ] ) . '">' . $option[ $way ][ 'max' ] . '</a>';
        if ( $way === 'prev' ) {
            $button .= '<span class="paging-link abb first-abb">...</span>';
        }
    }
    return $button;
}
function get_paging_part_numbers( $option, $way ) {
    $button = '';
    $way_cnt = count( $option[ 'number' ][ $way ] );
    if ( is_array( $option[ 'number' ][ $way ] ) && $way_cnt > 0 ) {
        if ( $way === 'prev' ) {
            $cnt = (int)$option[ 'range' ] - (int)$way_cnt;
        } else {
            $cnt = (int)$option[ 'range' ];
        }
        foreach( (array)$option[ 'number' ][ $way ] as $num ) {
            if ( $way === 'prev' ) {
                ++$cnt;
            }
            $url = get_pagenum_link( $num );
            $button .= '<a class="paging-link num' . $cnt . '" href="' . $url . '">' . $num . '</a>';
            if ( $way === 'next' ) {
                --$cnt;
            }
        }
    }
    return $button;
}
function get_part_item_paging_numbers( $arr ) {
    extract( $arr );
    if ( $option[ 'type' ] === '2' || $option[ 'type' ] === '4' ) return false;
    $paged = (int)$archive[ 'paged' ];
    //prevmax
    $prev_max = get_paging_part_around( [ 'option' => $option, 'key' => 'pm', 'way' => 'prev', 'unit' => 'max', 'class' => 'prev-max', 'label' => 'First Page' ] );
    $next_max = get_paging_part_around( [ 'option' => $option, 'key' => 'nm', 'way' => 'next', 'unit' => 'max', 'class' => 'next-max', 'label' => 'Last Page' ] );
    $prev = get_paging_part_around( [ 'option' => $option, 'key' => 'p', 'way' => 'prev', 'unit' => 'one', 'class' => 'prev', 'label' => 'Previous' ] );
    $next = get_paging_part_around( [ 'option' => $option, 'key' => 'n', 'way' => 'next', 'unit' => 'one', 'class' => 'next', 'label' => 'Next' ] );
    $paging = '';
    switch ( $option[ 'type' ] ) {
        case '3' :
            $max = $option[ 'maxCount' ];
            for( $i = 1; $i <= $max; ++$i ) {
                $selected = '';
                if ( $i === $paged ) {
                    $selected = ' selected';
                }
                $url = get_pagenum_link( $i );
                $paging .= '<option value="' . $url . '"' . $selected . '>' . $i . ' / ' . $max . '</option>';
            }
            $paging = '<div class="archive-paging-area">' . $prev_max . $prev . '<select class="paging-link-select">' . $paging . '</select>' . $next . $next_max . '</div>';
            break;
        default :
            $numbers = get_paging_part_both( $option, 'prev' );
            $numbers .= get_paging_part_numbers( $option, 'prev' );
            $numbers .= '<span class="paging-link current">' . $option[ 'number' ][ 'current' ] . '</span>';
            $numbers .= get_paging_part_numbers( $option, 'next' );
            $numbers .= get_paging_part_both( $option, 'next' );
            $paging = '<div class="archive-paging-area">' . $prev_max . $prev . $numbers . $next . $next_max . '</div>';
            break;
    }
    return $paging;
}

function get_part_item_sort_orderby( $option, $archive ) {
    $orderby_display = isset( $option[ 'orderby-display' ] ) ? $option[ 'orderby-display' ] : '1';
    if ( $orderby_display !== '1' ) return false;
    $orderby_type = isset( $option[ 'orderby-type' ] ) ? $option[ 'orderby-type' ] : '1';
    $order_by = array( 'date' => __( '公開日', 'dg-style' ), 'modified' => __( '更新日', 'dg-style' ), 'views' => __( '人気順（全体）', 'dg-style' ), 'w_views' => __( '人気順（週間）', 'dg-style' ), 'm_views' => __( '人気順（月間）', 'dg-style' ), 'y_views' => __( '人気順（年間）', 'dg-style' ), 'evaluate' => __( '評価順', 'dg-style' ), 'bookmark' => __( 'ブックマーク数順', 'dg-style' ), 'comment_count' => __( 'コメント多い順', 'dg-style' ), 'author' => __( '作成者順', 'dg-style' ), 'rand' => __( 'ランダム', 'dg-style' ), 'title' => __( '記事タイトル', 'dg-style' ), );
    $orderby = '';
    switch ( $orderby_type ) {
        case '2' :
            foreach( (array)$order_by as $key => $name ) {
                if ( !isset( $option[ $key ] ) || ( isset( $option[ $key ] ) && $option[ $key ] === '1' ) ) {
                    $checked = '';
                    if ( isset( $archive[ 'order_value' ][ 'orderby' ] ) && $archive[ 'order_value' ][ 'orderby' ] === $key ) {
                        $checked = ' checked';
                    } elseif ( $key === 'date' ) {
                        $checked = ' checked';
                    }
                    $orderby .= '<label class="orderby-label sort-label"><input type="radio" name="' . $value[ 'id' ] . '-orderby-radio" class="archive-orderby-input archive-sort-input" value="' . $key . '"' . $checked . '><span class="orderby-name sort-name">' . $name . '</span></label>';
                }
            }
            $orderby = '<div class="archive-sort-radio archive-orderby-radio">' . $orderby . '</div>';
            break;
        default :
            foreach( (array)$order_by as $key => $name ) {
                if ( !isset( $option[ $key ] ) || ( isset( $option[ $key ] ) && $option[ $key ] === '1' ) ) {
                    $selected = '';
                    if ( $archive[ 'order_value' ][ 'orderby' ] === $key ) {
                        $selected = ' selected';
                    }
                    $orderby .= '<option value="' . $key . '"' . $selected . '>' . $name . '</option>';
                }
            }
            $orderby = '<select class="archive-orderby-input archive-sort-input">' . $orderby . '</select>';
            break;
    }
    $orderby_title = isset( $option[ 'orderby-title' ] ) && $option[ 'orderby-title' ] !== '' ? '<strong class="archive-sort-title archive-orderby-title">' . $option[ 'orderby-title' ] . '</strong>' : '';
    return '<div class="archive-orderby-area">' . $orderby_title . $orderby . '</div>';
}

function get_part_item_sort_order( $option, $archive ) {
    $order_display = isset( $option[ 'order-display' ] ) ? $option[ 'order-display' ] : '1';
    if ( $order_display !== '1' ) return false;
    $order_title = isset( $option[ 'order-title' ] ) && $option[ 'order-title' ] !== '' ? '<strong class="archive-sort-title archive-order-title">' . $option[ 'order-title' ] . '</strong>' : '';
    $text_desc = __( '降順', 'dg-style' );
    $text_asc = __( '昇順', 'dg-style' );
    $order = '';
    switch ( isset( $option[ 'order-type' ] ) && $option[ 'order-type' ] === '2' ) {
        case true :
            $desc = $archive[ 'order_value' ][ 'order' ] === 'DESC' ? ' checked' : '';
            $asc = $archive[ 'order_value' ][ 'order' ] === 'ASC' ? ' checked' : '';
            $order = <<< EOM
                <div class="archive-sort-radio archive-order-radio">
                    <label class="order-label sort-label">
                        <input type="radio" name="{$value[ 'id' ]}-order-radio" class="archive-order-input archive-sort-input" value="desc"{$desc}>
                        <span class="order-name sort-name">{$text_desc}</span>
                    </label>
                    <label class="order-label sort-label">
                        <input type="radio" name="{$value[ 'id' ]}-order-radio" class="archive-order-input archive-sort-input" value="asc"{$asc}>
                        <span class="order-name sort-name">{$text_asc}</span>
                    </label>
                </div>
EOM;
            break;
        default :
            $desc = $archive[ 'order_value' ][ 'order' ] === 'DESC' ? ' selected' : '';
            $asc = $archive[ 'order_value' ][ 'order' ] === 'ASC' ? ' selected' : '';
            $order = '<select class="archive-order-input archive-sort-input"><option value="desc"' . $desc . '>' . $text_desc . '</option><option value="asc"' . $asc . '>' . $text_asc . '</option></select>';
            break;
    }
    return '<div class="archive-order-area">' . $order_title . $order . '</div>';
}

function get_part_item_sort_count( $option, $archive ) {
    $count_display = isset( $option[ 'count-display' ] ) ? $option[ 'count-display' ] : '1';
    if ( $count_display !== '1' ) return false;
    $text_count_unit = __( '件', 'dg-style' );
    $count_type = isset( $option[ 'count-type' ] ) ? $option[ 'count-type' ] : '1';
    $count_item = isset( $option[ 'count-item' ] ) && $option[ 'count-item' ] !== '' ? $option[ 'count-item' ] : '15,30,45';
    $counts = explode( ',', $count_item );
    $display = '';
    switch ( $count_type ) {
        case '2' :
            foreach( (array)$counts as $num ) {
                $checked = '';
                if ( (int)$archive[ 'order_value' ][ 'count' ] === (int)$num ) {
                    $checked = ' checked';
                }
                $display .= '<label class="count-label sort-label"><input type="radio" name="' . $value[ 'id' ] . '-order-radio" class="archive-count-input archive-sort-input" value="' . $num . '"' . $checked . '><span class="count-name sort-name">' . $num . $text_count_unit . '</span></label>';
            }
            $display = '<div class="archive-sort-radio archive-count-radio">' . $display . '</div>';
            break;
        default :
            foreach( (array)$counts as $num ) {
                $selected = '';
                if ( (int)$archive[ 'order_value' ][ 'count' ] === (int)$num ) {
                    $selected = ' selected';
                }
                $display .= '<option value="' . $num . '"' . $selected . '>' . $num . $text_count_unit . '</option>';
            }
            $display = '<select class="archive-count-input archive-sort-input">' . $display . '</select>';
            break;
    }
    $count_title = isset( $option[ 'count-title' ] ) && $option[ 'count-title' ] !== '' ? '<strong class="archive-sort-title archive-count-title">' . $option[ 'count-title' ] . '</strong>' : '';
    return '<div class="archive-count-area">' . $count_title . $display . '</div>';
}

function get_part_item_child_taxonomy( $option, $type, $archive, $info ) {
    $page_type = $info[ 'page_info' ][ 'page_type' ];
    $count = isset( $option[ 'count' ] ) && $option[ 'count' ] === '1' ? true : false;
    $taxonomy = '';
    switch ( isset( $option[ 'type' ] ) && $option[ 'type' ] === '2' ) {
        case true :
            $child = '<option value="">' . __( 'カテゴリー選択', 'dg-style' ) . '</option>';
            foreach( (array)$archive[ $type ] as $term ) {
                $text = $term[ 'name' ];
                $count_text = $count ? '（' . $term[ 'count' ] . '）' : '';
                $selected = $term[ 'current' ] === '1' ? ' selected' : '';
                
                if ( $term[ 'parent' ] === $term[ 'term_id' ] ) {
                    if ( isset( $option[ 'p' ] ) && $option[ 'p' ] === '1' ) {
                        if ( isset( $option[ 'pn' ] ) && $option[ 'pn' ] !== '' ) {
                            $text = $option[ 'pn' ];
                        }
                        $child .= '<option value="' . $term[ 'url' ] . '" class="term-link parent-term ' . $term[ 'slug' ] . '"' . $selected . '>' . $text . $count_text . '</option>';
                    }
                } else {
                    $child .= '<option value="' . $term[ 'url' ] . '" class="term-link ' . $term[ 'slug' ] . '"' . $selected . '>' . $text . $count_text . '</option>';
                }
            }
            $taxonomy = '<div class="' . $type . '-terms terms-list"><select class="child-terms-select">' . $child . '</select></div>';
            break;
        default :
            $text_aria_label = __( 'のページをもっと見る', 'dg-style' );
            $child = '';
            $cnt = 1;
            $all_cnt = count( $archive[ $type ] );
            $n_point = isset( $option[ 'point-class' ][ 'n' ] ) ? $option[ 'point-class' ][ 'n' ] : array();
            $e_point = isset( $option[ 'point-class' ][ 'e' ] ) && is_array( $option[ 'point-class' ][ 'e' ] ) && count( $option[ 'point-class' ][ 'e' ] ) > 0 ? $option[ 'point-class' ][ 'e' ] : false;
            foreach( (array)$archive[ $type ] as $term ) {
                $text = $term[ 'name' ];
                $current = $term[ 'current' ] === '1' ? ' current' : '';
                $count_text = $count ? '（' . $term[ 'count' ] . '）' : '';
                $rel = '';
                if ( $page_type === 'post_tag' ) {
                    $rel = ' rel="tag"';
                }
                $add_class = 'term-item ' . $term[ 'slug' ] . $current;
                if ( $cnt === 1 ) {
                    $add_class .= ' first-item';
                }
                if ( $cnt === $all_cnt ) {
                    $add_class .= ' last-item';
                }
                if ( $e_point !== false ) {
                    foreach( (array)$e_point as $p => $p_class ) {
                        if ( $cnt % (int)$p === 0 ) {
                            $add_class .= ' ' . $p_class;
                        }
                    }
                }
                if ( isset( $n_point[ $cnt ] ) ) {
                    $add_class .= ' ' . $n_point[ $cnt ];
                }
                ++$cnt;
                if ( $term[ 'parent' ] === $term[ 'term_id' ] ) {
                    if ( isset( $option[ 'p' ] ) && $option[ 'p' ] === '1' ) {
                        if ( isset( $option[ 'pn' ] ) && $option[ 'pn' ] !== '' ) {
                            $text = $option[ 'pn' ];
                        }
                        $child .= '<li class="' . $add_class . ' parent-term"><a href="' . $term[ 'url' ] . '" class="term-link ' . $term[ 'slug' ] . '" aria-label="' . $term[ 'name' ] . $text_aria_label . '"' . $rel . '>' . $text . $count_text . '</a></li>';
                    }
                } else {
                    $child .= '<li class="' . $add_class . '"><a href="' . $term[ 'url' ] . '" class="term-link ' . $term[ 'slug' ] . '" aria-label="' . $term[ 'name' ] . $text_aria_label . '"' . $rel . '>' . $text . $count_text . '</a></li>';
                }
            }
            $taxonomy = '<ul class="' . $type . '-terms terms-list">' . $child . '</ul>';
            break;
    }
    return $taxonomy;
}

function get_part_item_page_count_text( $arr ) {
    extract( $arr );
    $name = $item[ 'slug' ];
    if ( ( in_array( $name, [ 'from', 'until', 'total', 'page' ], true ) !== true || !isset( $value[ $name ] ) ) && !( $name === 'free' && isset( $option[ 'text' ] ) && $option[ 'text' ] !== '' ) ) return false;
    switch ( $name ) {
        case 'free' :
            $text = $option[ 'text' ];
            $tag = 'span';
            if ( $part_slug === 'taxonomy-title' ) {
                $tag = isset( $option[ 'tag' ] ) && $option[ 'tag' ] !== '' ? $option[ 'tag' ] : 'none';
            }
            if ( $tag === 'none' ) {
                return $text;
            } else {
                $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'free-text ' . $option[ 'class' ] : 'free-text';
                return '<' . $tag . ' class="' . $class . '">' . $text . '</' . $tag . '>';
            }
            break;
        default :
            $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'count-text ' . $option[ 'class' ] : 'count-text';
            return '<span class="' . $class . '">' . $value[ $name ] . '</span>';
            break;
    }
}

/*
 * Gメニュー
*/
function get_part_item_gmenu_list( $list, $option ) {
    if ( !( is_array( $list ) && count( $list ) > 0 ) ) return false;
    $html = '';
    foreach( (array)$list as $item ) {
        $child = '';
        $class = ( $item[ 'class' ] !== '' ? ' ' . $item[ 'class' ] : '' ) . ' ' . $item[ 'slug' ];
        if ( isset( $item[ 'child' ] ) ) {
            $class .= ' has-child';
            $child = get_part_item_gmenu_list( $item[ 'child' ], $option );
            $child = '<ul class="sub-menu menu-list menu-level-' . $item[ 'child-num' ] . '">' . $child . '</ul>';
        }
        $menu_name = '<span class="text name">' . $item[ 'title' ] . '</span>';
        if ( isset( $option[ 'sub' ] ) ) {
            switch ( $option[ 'sub' ] ) {
                case '4' :
                    if ( isset( $item[ 'sub' ] ) && $item[ 'sub' ] !== '' ) {
                        $menu_name .= '<span class="text sub">' . $item[ 'sub' ] . '</span>';
                    }
                    if ( isset( $item[ 'attr' ] ) && $item[ 'attr' ] !== '' ) {
                        $menu_name .= '<span class="text sub2">' . $item[ 'attr' ] . '</span>';
                    }
                    break;
                case '3' :
                    $text = isset( $item[ 'attr' ] ) ? $item[ 'attr' ] : '';
                    if ( $text === '' ) {
                        $text = isset( $item[ 'sub' ] ) ? $item[ 'sub' ] : '';
                    }
                    if ( $text !== '' ) {
                        $menu_name .= '<span class="text sub">' . $text . '</span>';
                    }
                    break;
                case '2' :
                    $text = isset( $item[ 'sub' ] ) ? $item[ 'sub' ] : '';
                    if ( $text === '' ) {
                        $text = isset( $item[ 'attr' ] ) ? $item[ 'attr' ] : '';
                    }
                    if ( $text !== '' ) {
                        $menu_name .= '<span class="text sub">' . $text . '</span>';
                    }
                    break;
            }
        }
        $toggle_btn = '';
        if ( isset( $item[ 'child' ] ) && isset( $option[ 'toggle' ] ) && $option[ 'toggle' ] === '1' ) {
            $toggle_class = 'multi';
            if ( isset( $option[ 'toggle-type' ] ) && $option[ 'toggle-type' ] === '2' ) {
                $toggle_class = 'only';
            }
            $toggle_btn = '<button type="button" class="menu-toggle-btn ' . $toggle_class . '" aria-label="' . __( 'サブメニューを開く', 'dg-style' ) . '">' . $menu_name . '</button>';
        }
        $html .= '<li class="menu-item' . $class . '"><a href="' . $item[ 'url' ] . '" class="menu-link link-tag">' . $menu_name . '</a>' . $toggle_btn . $child . '</li>';
        
    }
    return $html;
}

/*
 * カテゴリータイトル
*/
function get_part_item_taxonomy_title( $archive, $option ) {
    $title = '';
    switch ( $archive[ 'taxonomy' ] ) {
        case 'top' :
            if ( isset( $option[ 'top' ] ) && $option[ 'top' ] !== '' ) {
                $title = $option[ 'top' ];
            } else {
                $title = $archive[ 'title' ];
            }
            break;
        case 'search' :
            $title = isset( $option[ 'other-search' ] ) && $option[ 'other-search' ] !== '' ? $option[ 'other-search' ] : '[keyword]';
            $title = str_replace( '[keyword]', $archive[ 'title' ], $title );
            break;
        case 'author' :
            $title = isset( $option[ 'other-author' ] ) && $option[ 'other-author' ] !== '' ? $option[ 'other-author' ] : '[name]';
            $title = str_replace( '[name]', $archive[ 'title' ], $title );
            break;
        case '404' :
            if ( isset( $option[ '404' ] ) && $option[ '404' ] !== '' ) {
                $title = $option[ '404' ];
            }
            break;
        default :
            if ( $archive[ 'taxonomy' ] === 'date' ) {
                $title = isset( $option[ 'taxonomy-date' ] ) && $option[ 'taxonomy-date' ] !== '' ? $option[ 'taxonomy-date' ] : __( '[year:年][month:月][day:日]', 'dg-style' );
                $date = explode( '-', $archive[ 'title' ] );
                if ( isset( $date[ 0 ] ) && preg_match( '/\[year:(.*?)\]/', $title ) ) {
                    $title = preg_replace( '/\[year:(.*?)\]/', $date[ 0 ] . '$1', $title );
                }
                if ( isset( $date[ 1 ] ) && preg_match( '/\[month:(.*?)\]/', $title ) ) {
                    $title = preg_replace( '/\[month:(.*?)\]/', $date[ 1 ] . '$1', $title );
                } else {
                    $title = preg_replace( '/\[month:(.*?)\]/', '', $title );
                }
                if ( isset( $date[ 2 ] ) && preg_match( '/\[day:(.*?)\]/', $title ) ) {
                    $title = preg_replace( '/\[day:(.*?)\]/', $date[ 2 ] . '$1', $title );
                } else {
                    $title = preg_replace( '/\[day:(.*?)\]/', '', $title );
                }
                $title = trim( $title );
            } else {
                $title = isset( $option[ 'taxonomy-' . $archive[ 'taxonomy' ] ] ) && $option[ 'taxonomy-' . $archive[ 'taxonomy' ] ] !== '' ? $option[ 'taxonomy-' . $archive[ 'taxonomy' ] ] : '[title]';
                $title = str_replace( '[title]', $archive[ 'title' ], $title );
            }
            break;
    }
    $sub_title = isset( $archive[ 'subTitle' ] ) ? $archive[ 'subTitle' ] : '';
    return [ 'title' => $title, 'sub' => $sub_title ];
}

function get_part_item_breadcrumb( $breadcrumb, $option ) {
    $bread = '';
    $cnt = count( $breadcrumb ) - 1;
    foreach( (array)$breadcrumb as $key => $item ) {
        $bread_attr = '';
        $taxonomy = $item[ 'taxonomy' ];
        $page_type = $item[ 'page_type' ];
        $title = $item[ 'name' ];
        switch ( $page_type ) {
            case 'top' :
                if ( isset( $option[ 'top' ] ) && $option[ 'top' ] !== '' ) {
                    $title = $option[ 'top' ];
                }
                break;
            case '404' :
                $title = isset( $option[ 'other-404' ] ) && $option[ 'other-404' ] !== '' ? $option[ 'other-404' ] : __( 'ページが見つかりませんでした', 'dg-style' );
                break;
            case 'other' :
                if ( $taxonomy === 'search' && isset( $option[ 'other-search' ] ) && $option[ 'other-search' ] !== '' ) {
                    $title = str_replace( '[keyword]', $item[ 'name' ], $option[ 'other-search' ] );
                } elseif ( $taxonomy === 'author' && isset( $option[ 'other-author' ] ) && $option[ 'other-author' ] !== '' ) {
                    $title = str_replace( '[name]', $item[ 'name' ], $option[ 'other-author' ] );
                }
                if ( $taxonomy === 'author' ) {
                    $bread_attr = ' rel="author"';
                }
                break;
            case 'taxonomy' :
                if ( $taxonomy === 'post_tag' ) {
                    $bread_attr = ' rel="tag"';
                }
                if ( $taxonomy === 'date' ) {
                    $date_type = $item[ 'date_type' ];
                    if ( isset( $option[ 'taxonomy-' . $date_type ] ) && $option[ 'taxonomy-' . $date_type ] !== '' ) {
                        $title = $option[ 'taxonomy-' . $date_type ];
                        if ( $date_type === 'year' ) {
                            $title = str_replace( '[year]', $item[ 'name' ], $title );
                        } elseif ( $date_type === 'monthnum' ) {
                            $title = str_replace( '[month]', $item[ 'name' ], $title );
                        } elseif ( $date_type === 'day' ) {
                            $title = str_replace( '[day]', $item[ 'name' ], $title );
                        }
                    }
                } elseif ( isset( $option[ 'taxonomy-' . $taxonomy ] ) && $option[ 'taxonomy-' . $taxonomy ] !== '' ) {
                    $title = str_replace( '[title]', $item[ 'name' ], $option[ 'taxonomy-' . $taxonomy ] );
                }
                break;
            case 'single' :
                if ( isset( $option[ 'single-' . $taxonomy ] ) && $option[ 'single-' . $taxonomy ] !== '' ) {
                    $title = str_replace( '[title]', $item[ 'name' ], $option[ 'single-' . $taxonomy ] );
                }
                break;
        }
        $bread_class = 'bread-link link-tag';
        if ( $cnt === $key ) {
            $bread_attr = ' aria-current="page"';
            $bread_class .= ' current';
        }
        $bread .= '<li class="bread-item"><a href="' . $item[ 'url' ] . '" class="' . $bread_class . '" aria-label="' . $title . __( 'のページをもっと見る', 'dg-style' ) . '"' . $bread_attr . '>' . $title . '</a></li>';
    }
    return '<ul class="breadcrumb-list">' . $bread . '</ul>';
}

function get_part_item_post_list( $value, $info ) {
    $post_list = '';
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    if ( isset( $option[ 'postList' ] ) && is_array( $option[ 'postList' ] ) && count( $option[ 'postList' ] ) > 0 ) {
        //差し込みエリア
        $childs = array();
        $childs_noplug = '';
        if ( isset( $value[ 'child' ] ) && is_array( $value[ 'child' ] ) && count( $value[ 'child' ] ) > 0 ) {
            foreach( (array)$value[ 'child' ] as $item ) {
                if ( $item[ 'id' ] !== $value[ 'id' ] . '-none-post' ) {
                    if ( isset( $item[ 'class' ] ) && $item[ 'class' ] !== '') {
                        $item[ 'class' ] .= ' plug-area';
                    } else {
                        $item[ 'class' ] = 'plug-area';
                    }
                    $child_item = create_area_html( $item, $info, false );
                    if ( isset( $option[ 'plug' ][ $item[ 'id' ] ] ) ) {
                        $plug = $option[ 'plug' ][ $item[ 'id' ] ];
                        $count = isset( $plug[ 'count' ] ) && $plug[ 'count' ] !== '' ? (int)$plug[ 'count' ] - 1 : 0;
                        $way = isset( $plug[ 'way' ] ) ? $plug[ 'way' ] : '';
                        $childs[ $count ] = array( 'way' => $way, 'item' => $child_item );
                    } else {
                        $childs_noplug .= $child_item;
                    }
                }
            }
        }
        //記事リスト作成
        $area = isset( $option[ 'area' ] ) ? $option[ 'area' ] : array();
        $area_list = false;
        if ( is_array( $area ) && count( $area ) > 0 ) {
            $area_list = create_post_parts_tree( $area, 'all' );
        }
        $cnt = 1;
        $article_tag = isset( $option[ 'article_tag' ] ) ? $option[ 'article_tag' ] : 'article';
        $lazyload = isset( $value[ 'lazyload' ] ) ? $value[ 'lazyload' ] : '';
        $all_cnt = count( $option[ 'postList' ] );
        $n_point = isset( $option[ 'point-class' ][ 'n' ] ) ? $option[ 'point-class' ][ 'n' ] : array();
        $e_point = isset( $option[ 'point-class' ][ 'e' ] ) && is_array( $option[ 'point-class' ][ 'e' ] ) && count( $option[ 'point-class' ][ 'e' ] ) > 0 ? $option[ 'point-class' ][ 'e' ] : false;
        foreach( (array)$option[ 'postList' ] as $key => $post ) {
            if ( isset( $post[ 'part' ] ) ) {
                $one_post = '';
                if ( $area_list !== false ) {
                    $one_post = create_part_items_area( array( 'item_fun' => 'create_one_post_part', 'area_list' => $area_list, 'post_value' => $post[ 'part' ], 'url' => $post[ 'url' ], 'info' => $info, 'lazyload' => $lazyload, 'part_slug' => $value[ 'slug' ] ) );
                } else {
                    foreach( (array)$post[ 'part' ] as $name => $post_value ) {
                        $one_post .= create_one_post_part( array( 'value' => $post[ 'part' ], 'item' => array( 'id' => '', 'slug' => $name ), 'url' => $post[ 'url' ], 'option' => array(), 'info' => $info, 'lazyload' => $lazyload, 'part_slug' => $value[ 'slug' ] ) );
                    }
                }
                $add_class = 'post-item';
                if ( $cnt === 1 ) {
                    $add_class .= ' first-item';
                }
                if ( $cnt === $all_cnt ) {
                    $add_class .= ' last-item';
                }
                if ( $e_point !== false ) {
                    foreach( (array)$e_point as $p => $p_class ) {
                        if ( $cnt % (int)$p === 0 ) {
                            $add_class .= ' ' . $p_class;
                        }
                    }
                }
                if ( isset( $n_point[ $cnt ] ) ) {
                    $add_class .= ' ' . $n_point[ $cnt ];
                }
                ++$cnt;
                if ( isset( $post[ 'class' ] ) && $post[ 'class' ] !== '' ) {
                    $add_class .= $post[ 'class' ];
                }
                //差し込みエリア（前）
                if ( isset( $childs[ $key ][ 'way' ] ) && $childs[ $key ][ 'way' ] === '' ) {
                    $post_list .= $childs[ $key ][ 'item' ];
                }
                $post_list .= '<' . $article_tag . ' class="' . $add_class . '" data-post_id="' .  $post[ 'part' ][ 'postId' ] . '">' . $one_post . '</' . $article_tag . '>';
                //差し込みエリア（後）
                if ( isset( $childs[ $key ][ 'way' ] ) && $childs[ $key ][ 'way' ] === '1' ) {
                    $post_list .= $childs[ $key ][ 'item' ];
                }
            }
        }
        //差し込みエリアありで設定はなしの場合最後に追加
        if ( $childs_noplug !== '' ) {
            $post_list .= $childs_noplug;
        }
        //スライド設定
        $slide_class = '';
        $slide_attr = '';
        if ( isset( $value[ 'slide' ][ 'display' ] ) && $value[ 'slide' ][ 'display' ] === '1' ) {
            $slide_class = ' DGSLIDERITEM';
            $slide_attr = set_slide_attr( $value[ 'slide' ] );
        }
        $post_list = '<div class="post-list' . $slide_class . '"' . $slide_attr . '>' . $post_list . '</div>';
    } else {
        if ( isset( $value[ 'child' ] ) && is_array( $value[ 'child' ] ) && count( $value[ 'child' ] ) > 0 && isset( $option[ 'none' ] ) && $option[ 'none' ] === '1' ) {
            foreach( (array)$value[ 'child' ] as $item ) {
                if ( $item[ 'id' ] === $value[ 'id' ] . '-none-post' ) {
                    $post_list .= create_area_html( $item, $info, false );
                }
            }
        }
    }
    return $post_list;
}

/*
 * snsボタン
*/
function get_part_item_sns_list( $value, $url ) {
    $list = '';
    $sns_list = array( 'facebook', 'twitter', 'line', 'pocket', 'tumblr', 'hatebu', 'pinterest' );
    $url = rawurlencode( $url );
    foreach( (array)$sns_list as $key ) {
        if ( !isset( $value[ $key ] ) || $value[ $key ] === '1' ) {
            $share_url = '';
            $sns_text = isset( $value[ $key . 'n' ] ) ? $value[ $key . 'n' ] : $key;
            switch ( $key ) {
                case 'facebook' :
                    $share_url = 'https://www.facebook.com/share.php?u=' . $url;
                    break;
                case 'twitter' :
                    $share_url = 'https://twitter.com/share?url=' . $url;
                    break;
                case 'line' :
                    $share_url = 'https://social-plugins.line.me/lineit/share?url=' . $url;
                    break;
                case 'pocket' :
                    $share_url = 'https://getpocket.com/edit?url=' . $url;
                    break;
                case 'tumblr' :
                    $share_url = 'https://www.tumblr.com/share/link?url=' . $url;
                    break;
                case 'hatebu' :
                    $share_url = 'https://b.hatena.ne.jp/add?mode=confirm&url=' . $url;
                    break;
                case 'pinterest' :
                    $share_url = 'https://www.pinterest.com/pin/create/button/?url=' . $url;
                    break;
            }
            $list .= '<a href="' . $share_url . '" class="sns-btn ' . $key . '" rel="nofollow noreferrer" target="_blank" aria-label="Share to ' . $key . '">' . $sns_text . '</a>';
        }
    }
    if ( $list !== '' ) {
        $class = isset( $value[ 'class' ] ) && $value[ 'class' ] !== '' ? 'sns-btn-area ' . $value[ 'class' ] : 'sns-btn-area';
        return '<div class="' . $class . '">' . $list . '</div>';
    }
    return '';
}

/*
 * 評価まとめ
*/
function get_part_item_evaluate_summary( $value, $option ) {
    $total = isset( $value[ 'total' ] ) ? (int)$value[ 'total' ] : 0;
    $click = 0;
    $evaluate_list = array( 'very-good' => [ 5, 4,5 ], 'good' => [ 4, 3.5 ], 'average' => [ 3, 2.5 ], 'fair' => [ 2, 1.5 ], 'poor' => [ 1, 0.5 ] );
    foreach( (array)$evaluate_list as $slug => $point ) {
        if ( isset( $value[ 'table' ][ $slug ] ) ) {
            $click += (int)$value[ 'table' ][ $slug ];
        }
    }
    $click_average = $click > 0 ? $total / $click : 0;
    $default_texts = array(
        'very-good' => __( 'すごく', 'dg-style' ),
        'good' => __( 'いいね', 'dg-style' ),
        'average' => __( 'ふつう', 'dg-style' ),
        'fair' => __( 'あんまり', 'dg-style' ),
        'poor' => __( 'ぜんぜん', 'dg-style' ),
    );
    $list = '';
    foreach( (array)$evaluate_list as $slug => $point ) {
        $addClass = '';
        if ( $click_average >= $point[ 0 ] ) {
            $addClass = ' full';
        } else if ( $click_average >= $point[ 1 ] ) {
            $addClass = ' half';
        }
        $number = isset( $value[ 'table' ][ $slug ] ) ? $value[ 'table' ][ $slug ] : 0;
        $text = isset( $option[ $slug ] ) ? $option[ $slug ] : $default_texts[ $slug ];
        $list .= '<div class="evaluate-item ' . $slug . $addClass . '"><span class="evaluate-name">' . $text . '</span><span class="evaluate-number">' . $number . '</span></div>';
    }
    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'evaluate-result-area ' . $option[ 'class' ] : 'evaluate-result-area';
    return '<div class="' . $class . '">' . $list . '</div>';
}

function get_part_item_evaluate_result( $option, $post ) {
    $result_flg = isset( $option[ 'result' ] ) ? $option[ 'result' ] : '1';
    if ( $result_flg !== '1' ) return false;
    $total = isset( $post[ 'postMeta' ][ 'evaluate_total' ] ) ? $post[ 'postMeta' ][ 'evaluate_total' ] : 0;
    $table = isset( $post[ 'postMeta' ][ 'evaluate_table' ] ) ? $post[ 'postMeta' ][ 'evaluate_table' ] : array();
    $evaluate = array( 'total' => $total, 'table' => $table, );
    return get_part_item_evaluate_summary( $evaluate, $option );
}

function get_part_item_evaluate_form( $value, $post ) {
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $form_flg = isset( $option[ 'form' ] ) ? $option[ 'form' ] : '1';
    if ( $form_flg !== '1' ) return false;
    $disabled_flg = false;
    if ( isset( $_COOKIE[ 'evaluatePosts' ] ) && $_COOKIE[ 'evaluatePosts' ] !== '' ) {
        $cookie = json_decode( wp_unslash( $_COOKIE[ 'evaluatePosts' ] ), true );
        if ( isset( $cookie[ $post[ 'postId' ] ] ) ) {
            $disabled_flg = $cookie[ $post[ 'postId' ] ];
        }
    }
    $inputs = '';
    $labels = '';
    $types = array( 'very-good' => '5', 'good' => '4', 'average' => '3', 'fair' => '2', 'poor' => '1', );
    $texts = array( 'very-good' => __( 'すごく', 'dg-style' ), 'good' => __( 'いいね', 'dg-style' ), 'average' => __( 'ふつう', 'dg-style' ), 'fair' => __( 'あんまり', 'dg-style' ), 'poor' => __( 'ぜんぜん', 'dg-style' ), );
    foreach( (array)$types as $type => $num ) {
        $text = isset( $option[ $type ] ) ? $option[ $type ] : $texts[ $type ];
        $disabled = '';
        $checked = '';
        if ( $disabled_flg !== false ) {
            $disabled = ' disabled';
            if ( (int)$num === $disabled_flg ) {
                $checked = ' checked';
            }
        }
        $inputs .= '<input type="radio" id="' . $value[ 'id' ] . '-' . $type . '" name="' . $value[ 'id' ] . '-evaluate-input" class="evaluate-input ' . $type . '" value="' . $num . '"' . $disabled . $checked . '>';
        $labels .= '<label for="' . $value[ 'id' ] . '-' . $type . '" class="evaluate-label ' . $type . '"><span class="evaluate-text">' . $text . '</span></label>';
    }
    $confirm_text = isset( $option[ 'confirm' ] ) && $option[ 'confirm' ] !== '' ? $option[ 'confirm' ] : __( '選択した内容で評価しますか？', 'dg-style' );
    return '<div data-post_id="' . $post[ 'postId' ] . '" data-confirm="' . $confirm_text . '" class="evaluate-form-area">' . $inputs . $labels . '</div>';
}

function get_part_item_post_date( $option, $post, $type ) {
    $display_flg = isset( $option[ $type ] ) ? $option[ $type ] : '1';
    if ( $display_flg !== '1' ) return false;
    $tag = isset( $option[ $type . '-tag' ] ) && $option[ $type . '-tag' ] !== '' ? $option[ $type . '-tag' ] : 'time';
    $date = new DateTime( $post[ $type ] );
    $format = isset( $option[ $type . '-format' ] ) && $option[ $type . '-format' ] !== '' ? $option[ $type . '-format' ] : 'Y-m-d';
    $time = $date->format( $format );
    $attr = '';
    if ( $tag === 'time' ) {
        $attr = ' datetime="' . $post[ $type ] . '"';
    }
    return '<' . $tag . ' class="post-date ' . $type . '"' . $attr . '>' . $time . '</' . $tag . '>';
}

function get_part_item_post_taxonomy( $option, $post ) {
    if ( is_array( $option ) && count( $option ) === 0 ) {
        $option[ 'category' ] = '1';
    }
    $term_list = '';
    foreach( (array)$post[ 'taxonomy' ] as $tax => $terms ) {
        if ( !( isset( $option[ $tax ] ) && $option[ $tax ] !== '1' ) && is_array( $terms ) && count( $terms ) > 0 ) {
            if ( isset( $option[ $tax . '-count' ] ) && $option[ $tax . '-count' ] !== '' ) {
                $terms = array_slice( $terms, 0, (int)$option[ $tax . '-count' ] );
            }
            foreach( (array)$terms as $term ) {
                $rel = '';
                if ( $tax === 'post_tag' ) {
                    $rel = ' rel="tag"';
                }
                $term_list .= '<li class="term-item ' . $term[ 'slug' ] . ' ' . $tax . '-item"><a class="' . $tax . '-link term-link link-tag" href="' . $term[ 'term_link' ] . '" aria-label="' . $term[ 'name' ] . __( 'のページをもっと見る', 'dg-style' ) . '"' . $rel . '>' . $term[ 'name' ] . '</a></li>';
            }
        }
    }
    if ( $term_list === '' ) {
        return false;
    }
    return '<ul class="taxonomy-list">' . $term_list . '</ul>';
}

function get_part_item_post_content_split( $content, $option ) {
    if ( !( isset( $option[ 'split' ] ) && $option[ 'split' ] === '1' && isset( $option[ 'split-n' ] ) && $option[ 'split-n' ] !== '' ) ) return $content;
    $post_content = $content;
    $split_cnt = (int)$option[ 'split-n' ] - 1;
    $content_arr = explode( '<!--DGMORELINE-->', $post_content );
    if ( ( is_array( $content_arr ) && count( $content_arr ) === 1 && $split_cnt === 0 ) || !isset( $content_arr[ $split_cnt ] ) ) {
        if ( isset( $option[ 'split-d' ] ) && $option[ 'split-d' ] === '1' ) {
            $post_content = '';
        }
    } else {
        $post_content = $content_arr[ $split_cnt ];
    }
    return $post_content;
}

function get_part_item_post_content_password( $content, $value, $info ) {
    $post = $info[ 'post' ];
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    if ( !isset( $post[ 'password' ] ) ) return $content;
    $error_mesagge = '';
    if ( isset( $_COOKIE[ 'wp-postpass_' . COOKIEHASH ] ) ) {
        $error_mesagge = '<div class="password-error-message">' . __( 'パスワードが一致しません。', 'dg-style' ) . '</div>';
    }
    $word = isset( $option[ 'pass' ] ) && $option[ 'pass' ] !== '' ? nl2br( $option[ 'pass' ] ) : __( 'このコンテンツはパスワードで保護されています。閲覧するには以下にパスワードを入力してください。', 'dg-style' );
    $placeholder = isset( $option[ 'placeholder' ] ) && $option[ 'placeholder' ] !== '' ? $option[ 'placeholder' ] : __( '記事のパスワードを入力', 'dg-style' );
    $button = isset( $option[ 'button' ] ) && $option[ 'button' ] !== '' ? $option[ 'button' ] : __( '確定', 'dg-style' );
    $text_password = __( '入力したパスワードで記事を開く', 'dg-style' );
    return <<< EOM
        <p class="notice-password-text">{$word}</p>
        <form class="post-password-form" action="{$info[ 'homeUrl' ]}/wp-login.php?action=postpass" method="post">
            <input type="password" name="post_password" class="post-password-input" placeholder="{$placeholder}" aria-label="{$placeholder}">
            <button type="submit" class="post-password-submit" value="Submit" aria-label="{$text_password}">{$button}</button>
            {$error_mesagge}
        </form>
EOM;
}

function get_part_item_post_content_child( $content, $value, $info ) {
    $post = $info[ 'post' ];
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $post_content = $content;
    if ( !( isset( $value[ 'child' ] ) && is_array( $value[ 'child' ] ) && count( $value[ 'child' ] ) > 0 && !isset( $post[ 'password' ] ) ) ) return $post_content;
    $childs = array();
    foreach( (array)$value[ 'child' ] as $item ) {
        if ( isset( $item[ 'class' ] ) && $item[ 'class' ] !== '') {
            $item[ 'class' ] .= ' plug-area';
        } else {
            $item[ 'class' ] = 'plug-area';
        }
        $childs[ $item[ 'id' ] ] = create_area_html( $item, $info, false );
    }
    foreach( (array)$childs as $id => $item ) {
        if ( isset( $option[ 'plug' ][ $id ] ) ) {
            $tag = $option[ 'plug' ][ $id ][ 'tag' ] !== '' ? $option[ 'plug' ][ $id ][ 'tag' ] : 'p';
            $count = $option[ 'plug' ][ $id ][ 'count' ] !== '' ? (int)$option[ 'plug' ][ $id ][ 'count' ] : 1;
            $search_class = $option[ 'plug' ][ $id ][ 'class' ];
            $type = $option[ 'plug' ][ $id ][ 'type' ];
            $way = $option[ 'plug' ][ $id ][ 'way' ];
            if ( $type !== '' && $search_class !== '' ) {
                if ( $way !== '' ) {
                    $replace = '$1' . $item;
                } else {
                    $replace = $item . '$1';
                }
                $search_type = $type === '1' ? 'class' : 'id';
                $post_content = preg_replace( '/(<\s*(' . $tag . ')[^<>]*?' . $search_type . '=[\'\"][^<>\'\"]*?' . $search_class . '[^<>\'\"]*?[\'\"][^<>]*?>.*?<\s*\/\s*\2>)/s', $replace, $post_content );
            } elseif ( $type === '' ) {
                $new_content = str_replace( '<!-- DGSTYLE1STOP -->', '', $post_content );
                $new_content = preg_replace( '/(<\s*(' . $tag . ')[^>]*>.*?<\s*\/\s*\2>)/s', '<!-- DGSTYLE1STOP -->$1<!-- DGSTYLE1STOP -->', $new_content );
                $new_content = explode( '<!-- DGSTYLE1STOP -->', $new_content );
                if ( is_array( $new_content ) && count( $new_content ) > 0 ) {
                    $cnt = 1;
                    foreach( (array)$new_content as $key => $html ) {
                        if ( strpos( $html, '<' . $tag ) !== false ) {
                            if ( $cnt === $count ) {
                                if ( $way !== '' ) {
                                    $new_content[ $key ] = $html . $item;
                                } else {
                                    $new_content[ $key ] = $item . $html;
                                }
                            }
                            ++$cnt;
                        }
                    }
                    $post_content = implode( '', $new_content );
                }
            }
            
        } else {
            $post_content .= $item;
        }
    }
    return $post_content;
}

function get_part_item_select_content( $value, $option, $info ) {
    $inner = '';
    if ( isset( $option[ 'ids' ] ) && $option[ 'ids' ] !== '' ) {
        $post_ids = explode( ',', $option[ 'ids' ] );
        $cnt = 1;
        $all_cnt = count( $post_ids );
        $n_point = isset( $option[ 'point-class' ][ 'n' ] ) ? $option[ 'point-class' ][ 'n' ] : array();
        $e_point = isset( $option[ 'point-class' ][ 'e' ] ) && is_array( $option[ 'point-class' ][ 'e' ] ) && count( $option[ 'point-class' ][ 'e' ] ) > 0 ? $option[ 'point-class' ][ 'e' ] : false;
        foreach( (array)$post_ids as $id ) {
            if ( isset( $info[ 'selectPosts' ][ $id ] ) ) {
                $add_class = 'content-item content-' . $id;
                if ( $cnt === 1 ) {
                    $add_class .= ' first-item';
                }
                if ( $cnt === $all_cnt ) {
                    $add_class .= ' last-item';
                }
                if ( $e_point !== false ) {
                    foreach( (array)$e_point as $p => $p_class ) {
                        if ( $cnt % (int)$p === 0 ) {
                            $add_class .= ' ' . $p_class;
                        }
                    }
                }
                if ( isset( $n_point[ $cnt ] ) ) {
                    $add_class .= ' ' . $n_point[ $cnt ];
                }
                ++$cnt;
                $content = $info[ 'selectPosts' ][ $id ];
                if ( !isset( $value[ 'lazyload' ] ) ) {
                    $content = replace_post_content( $content, $info[ 'loadingImg' ] );
                }
                $inner .= '<div class="' . $add_class . '">' . $content . '</div>';
            }
        }
    }
    return '<div class="post-content-list">' . $inner . '</div>';
}

function get_part_item_author( $value, $info ) {
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    if ( !( isset( $option[ 'userList' ] ) && is_array( $option[ 'userList' ] ) && count( $option[ 'userList' ] ) > 0 ) ) {
        return '<p class="none-author-text">' . __( '作成者が選択されてません。', 'dg-style' ) . '</p>';
    }
    $area = isset( $option[ 'area' ] ) ? $option[ 'area' ] : array();
    $area_list = false;
    if ( is_array( $area ) && count( $area ) > 0 ) {
        $area_list = create_post_parts_tree( $area, 'all' );
    }
    $list = '';
    $cnt = 1;
    $lazyload = isset( $value[ 'lazyload' ] ) ? $value[ 'lazyload' ] : '';
    $all_cnt = count( $option[ 'userList' ] );
    $n_point = isset( $option[ 'point-class' ][ 'n' ] ) ? $option[ 'point-class' ][ 'n' ] : array();
    $e_point = isset( $option[ 'point-class' ][ 'e' ] ) && is_array( $option[ 'point-class' ][ 'e' ] ) && count( $option[ 'point-class' ][ 'e' ] ) > 0 ? $option[ 'point-class' ][ 'e' ] : false;
    foreach( (array)$option[ 'userList' ] as $item ) {
        $one_post = '';
        if ( isset( $item[ 'part' ] ) ) {
            if ( $area_list !== false ) {
                $one_post .= create_part_items_area( array( 'item_fun' => 'create_one_author_part', 'area_list' => $area_list, 'post_value' => $item[ 'part' ], 'url' => $item[ 'url' ], 'info' => $info, 'lazyload' => $lazyload, 'part_slug' => $value[ 'slug' ] ) );
            } else {
                foreach( (array)$item[ 'part' ] as $name => $post_value ) {
                    $one_post .= create_one_author_part( array( 'value' => $item[ 'part' ], 'item' => array( 'slug' => $name ), 'url' => $item[ 'url' ], 'option' => array(), 'info' => $info, 'lazyload' => $lazyload, 'part_slug' => $value[ 'slug' ] ) );
                }
            }
            $add_class = 'author-item';
            if ( $cnt === 1 ) {
                $add_class .= ' first-item';
            }
            if ( $cnt === $all_cnt ) {
                $add_class .= ' last-item';
            }
            if ( $e_point !== false ) {
                foreach( (array)$e_point as $p => $p_class ) {
                    if ( $cnt % (int)$p === 0 ) {
                        $add_class .= ' ' . $p_class;
                    }
                }
            }
            if ( isset( $n_point[ $cnt ] ) ) {
                $add_class .= ' ' . $n_point[ $cnt ];
            }
            ++$cnt;
            $list .= '<div class="' . $add_class . '">' . $one_post . '</div>';
        }
    }
    if ( $value[ 'slug' ] === 'author' ) {
        //スライド設定
        $slide_class = '';
        $slide_attr = '';
        if ( isset( $value[ 'slide' ][ 'display' ] ) && $value[ 'slide' ][ 'display' ] === '1' ) {
            $slide_class = ' DGSLIDERITEM';
            $slide_attr = set_slide_attr( $value[ 'slide' ] );
        }
        return '<div class="author-list' . $slide_class . '"' . $slide_attr . '>' . $list . '</div>';
    }
    return $list;
}

function get_part_item_comment_list( $value, $info ) {
    $comment_list = '';
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    if ( isset( $option[ 'none' ] ) ) {
        $comment_list = '<p class="none-post-text">' . __( 'コメントがありません', 'dg-style' ) . '</p>';
    } else if ( isset( $option[ 'list' ] ) && is_array( $option[ 'list' ] ) && count( $option[ 'list' ] ) > 0 ) {
        $area = isset( $option[ 'area' ] ) ? $option[ 'area' ] : array();
        $area_list = false;
        if ( is_array( $area ) && count( $area ) > 0 ) {
            $area_list = create_post_parts_tree( $area, 'all' );
        }
        $cnt = 1;
        $all_cnt = count( $option[ 'list' ] );
        $n_point = isset( $option[ 'point-class' ][ 'n' ] ) ? $option[ 'point-class' ][ 'n' ] : array();
        $e_point = isset( $option[ 'point-class' ][ 'e' ] ) && is_array( $option[ 'point-class' ][ 'e' ] ) && count( $option[ 'point-class' ][ 'e' ] ) > 0 ? $option[ 'point-class' ][ 'e' ] : false;
        foreach( (array)$option[ 'list' ] as $comment ) {
            $one_comment = '';
            if ( isset( $comment[ 'part' ] ) ) {
                if ( $area_list !== false ) {
                    $one_comment .= create_part_items_area( array( 'item_fun' => 'create_one_comment_part', 'area_list' => $area_list, 'post_value' => $comment[ 'part' ], 'url' => $comment[ 'url' ], 'info' => $info, 'lazyload' => '', 'part_slug' => $value[ 'slug' ] ) );
                } else {
                    foreach( (array)$comment[ 'part' ] as $name => $post_value ) {
                        $one_comment .= create_one_comment_part( [ 'value' => $comment[ 'part' ], 'item' => [ 'slug' => $name ], 'url' => $comment[ 'url' ], 'option' => [], 'info' => $info, 'lazyload' => '', 'part_slug' => $value[ 'slug' ] ] );
                    }
                }
                $add_class = 'comment-item';
                if ( $cnt === 1 ) {
                    $add_class .= ' first-item';
                }
                if ( $cnt === $all_cnt ) {
                    $add_class .= ' last-item';
                }
                if ( $e_point !== false ) {
                    foreach( (array)$e_point as $p => $p_class ) {
                        if ( $cnt % (int)$p === 0 ) {
                            $add_class .= ' ' . $p_class;
                        }
                    }
                }
                if ( isset( $n_point[ $cnt ] ) ) {
                    $add_class .= ' ' . $n_point[ $cnt ];
                }
                ++$cnt;
                $comment_list .= '<div class="' . $add_class . '">' . $one_comment . '</div>';
            }
        }
        //スライド設定
        $slide_class = '';
        $slide_attr = '';
        if ( isset( $value[ 'slide' ][ 'display' ] ) && $value[ 'slide' ][ 'display' ] === '1' ) {
            $slide_class = ' DGSLIDERITEM';
            $slide_attr = set_slide_attr( $value[ 'slide' ] );
        }
        $comment_list = '<div class="comment-list' . $slide_class . '"' . $slide_attr . '>' . $comment_list . '</div>';
    }
    return $comment_list;
}

function get_part_item_tag_cloud( $value ) {
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $list = '';
    if ( isset( $option[ 'none' ] ) ) {
        $list = '<ul class="tag-cloud-list"><li class="none-tag">' . __( 'タグがありません', 'dg-style' ) . '</li></ul>';
    } elseif ( isset( $option[ 'terms' ] ) && is_array( $option[ 'terms' ] ) && count( $option[ 'terms' ] ) ) {
        $count = array();
        foreach( (array)$option[ 'terms' ] as $term ) {
            $count[] = $term[ 'count' ];
        }
        $max = max( $count );
        $min = min( $count );
        $font_step = 10 / $max;
        $tag_list = '';
        foreach( (array)$option[ 'terms' ] as $term ) {
            $step = floor( 10 + ( (int)$term[ 'count' ] - $min ) * $font_step );
            $tag_list .= '<li class="tag-item ' . $term[ 'slug' ] . ' step' . $step . '"><a href="' . $term[ 'url' ] . '" class="tag-link link-tag">' . $term[ 'name' ] . '</a></li>';
        }
        //スライド設定
        $slide_class = '';
        $slide_attr = '';
        if ( isset( $value[ 'slide' ][ 'display' ] ) && $value[ 'slide' ][ 'display' ] === '1' ) {
            $slide_class = ' DGSLIDERITEM';
            $slide_attr = set_slide_attr( $value[ 'slide' ] );
        }
        $list = '<ul class="tag-cloud-list' . $slide_class . '"' . $slide_attr . '>' . $tag_list . '</ul>';
    }
    return $list;
}

function get_part_item_categories( $value, $info ) {
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    if ( !( isset( $option[ 'termList' ] ) && is_array( $option[ 'termList' ] ) && count( $option[ 'termList' ] ) > 0 ) ) return false;
    $area = isset( $option[ 'area' ] ) ? $option[ 'area' ] : array();
    $area_list = false;
    if ( is_array( $area ) && count( $area ) > 0 ) {
        $area_list = create_post_parts_tree( $area, 'all' );
    }
    $list = '';
    $cnt = 1;
    $lazyload = isset( $value[ 'lazyload' ] ) ? $value[ 'lazyload' ] : '';
    $all_cnt = count( $option[ 'termList' ] );
    $n_point = isset( $option[ 'point-class' ][ 'n' ] ) ? $option[ 'point-class' ][ 'n' ] : array();
    $e_point = isset( $option[ 'point-class' ][ 'e' ] ) && is_array( $option[ 'point-class' ][ 'e' ] ) && count( $option[ 'point-class' ][ 'e' ] ) > 0 ? $option[ 'point-class' ][ 'e' ] : false;
    foreach( (array)$option[ 'termList' ] as $item ) {
        $one_post = '';
        if ( isset( $item[ 'part' ] ) ) {
            if ( $area_list !== false ) {
                $one_post .= create_part_items_area( [ 'item_fun' => 'create_one_category_part', 'area_list' => $area_list, 'post_value' => $item[ 'part' ], 'url' => $item[ 'url' ], 'info' => $info, 'lazyload' => $lazyload, 'part_slug' => $value[ 'slug' ] ] );
            } else {
                foreach( (array)$item[ 'part' ] as $name => $post_value ) {
                    $one_post .= create_one_category_part( [ 'value' => $item[ 'part' ], 'item' => [ 'slug' => $name ], 'url' => $item[ 'url' ], 'option' => array(), 'info' => $info, 'lazyload' => $lazyload, 'part_slug' => $value[ 'slug' ] ] );
                }
            }
            $add_class = 'category-item ' . $item[ 'slug' ];
            if ( $cnt === 1 ) {
                $add_class .= ' first-item';
            }
            if ( $cnt === $all_cnt ) {
                $add_class .= ' last-item';
            }
            if ( $e_point !== false ) {
                foreach( (array)$e_point as $p => $p_class ) {
                    if ( $cnt % (int)$p === 0 ) {
                        $add_class .= ' ' . $p_class;
                    }
                }
            }
            if ( isset( $n_point[ $cnt ] ) ) {
                $add_class .= ' ' . $n_point[ $cnt ];
            }
            ++$cnt;
            $list .= '<div class="' . $add_class . '">' . $one_post . '</div>';
        }
    }
    //スライド設定
    $slide_class = '';
    $slide_attr = '';
    if ( isset( $value[ 'slide' ][ 'display' ] ) && $value[ 'slide' ][ 'display' ] === '1' ) {
        $slide_class = ' DGSLIDERITEM';
        $slide_attr = set_slide_attr( $value[ 'slide' ] );
    }
    return '<div class="category-list' . $slide_class . '"' . $slide_attr . '>' . $list . '</div>';
}

function get_part_item_post_comment_count( $option, $info ) {
    $count_flg = isset( $option[ 'count' ] ) ? $option[ 'count' ] : '1';
    if ( $count_flg !== '1' ) return false;
    $post = $info[ 'post' ];
    $count_text = isset( $option[ 'cct' ] ) ? $option[ 'cct' ] : 'comments';
    return '<div class="comment-count"><span class="count">' . $post[ 'commentCount' ] . '</span><span class="count-text">' . $count_text . '</span></div>';
}

function get_part_item_post_comment_list( $option, $info ) {
    $list_flg = isset( $option[ 'list' ] ) ? $option[ 'list' ] : '1';
    if ( $list_flg !== '1' ) return false;
    $post = $info[ 'post' ];
    $area = isset( $option[ 'area' ] ) && is_array( $option[ 'area' ] ) && count( $option[ 'area' ] ) > 0 ? htmlspecialchars( json_encode( $option[ 'area' ] ), ENT_QUOTES, 'UTF-8' ) : '{}';
    return '<div class="comment-list-area DGEVENTITEM GETCOMMENTS" data-post_id="' . $post[ 'postId' ] . '" data-area="' . $area . '" data-url="' . $info[ 'siteUrl' ] . '"></div>';
}

function get_part_item_post_comment_form( $value, $info ) {
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $form_on_flg = isset( $option[ 'form' ] ) ? $option[ 'form' ] : '1';
    $post = $info[ 'post' ];
    $form_flg = false;
    if ( $post[ 'commentReg' ] === '' && $form_on_flg === '1' ) {
        $form_flg = true;
    } elseif ( $post[ 'commentReg' ] === '1' && $form_on_flg === '1' && isset( $info[ 'logged' ] ) ) {
        $form_flg = true;
    }
    if ( !$form_flg ) return false;

    if ( isset( $info[ 'logged' ] ) ) {
        $names_inputs = '<p class="logged-label">' . $info[ 'logged' ] . __( 'でログインしています。', 'dg-style' ) . '</p>';
    } else {
        $name_place = isset( $option[ 'pn' ] ) && $option[ 'pn' ] !== '' ? ' placeholder="' .  $option[ 'pn' ] . '"' : '';
        $mail_place = isset( $option[ 'pm' ] ) && $option[ 'pm' ] !== '' ? ' placeholder="' .  $option[ 'pm' ] . '"' : '';
        $site_place = isset( $option[ 'ps' ] ) && $option[ 'ps' ] !== '' ? ' placeholder="' .  $option[ 'ps' ] . '"' : '';
        $text_comment_name = __( '名前', 'dg-style' );
        $text_comment_mail = __( 'メールアドレス', 'dg-style' );
        $text_comment_site = __( 'サイトURL', 'dg-style' );
        $names_inputs = <<< EOM
            <div class="comment-input-item comment-author-item">
                <label class="author-label comment-label" for="{$value[ 'id' ]}-author-label">{$text_comment_name}</label>
                <input class="comment-author-input comment-input" type="text" id="{$value[ 'id' ]}-author-label"{$name_place}>
            </div>
            <div class="comment-input-item comment-email-item">
                <label class="mail-label comment-label" for="{$value[ 'id' ]}-mail-label">{$text_comment_mail}</label>
                <input class="comment-email-input comment-input" type="email" id="{$value[ 'id' ]}-mail-label"{$mail_place}>
            </div>
            <div class="comment-input-item comment-url-item">
                <label class="site-label comment-label" for="{$value[ 'id' ]}-site-label">{$text_comment_site}</label>
                <input class="comment-url-input comment-input" type="text" id="{$value[ 'id' ]}-site-label"{$site_place}>
            </div>
EOM;
    }
    $comment_place = isset( $option[ 'pc' ] ) && $option[ 'pc' ] !== '' ? ' placeholder="' .  $option[ 'pc' ] . '"' : '';
    $text_comment_content = __( 'コメント本文', 'dg-style' );
    $text_comment_submit = __( 'コメントを送信', 'dg-style' );
    if ( isset( $option[ 'submit' ] ) ) {
        $text_comment_submit = $option[ 'submit' ];
    }
    return <<< EOM
        <div class="comment-input-area" data-post_id="{$post[ 'postId' ]}" data-commentNonce="{$info[ 'comment_nonce' ]}">
            {$names_inputs}
            <div class="comment-input-item comment-comment-item">
                <label class="comment-label comment-label" for="{$value[ 'id' ]}-comment-label">{$text_comment_content}</label>
                <textarea class="comment-comment-input comment-input" rows="3" id="{$value[ 'id' ]}-comment-label"{$comment_place}></textarea>
            </div>
            <div class="comment-input-item comment-submit-item"><button class="comment-submit-btn">{$text_comment_submit}</button></div>
        </div>
EOM;
}

/*
 * パーツのツリー作成
*/
function get_part_item_post_index( array &$list, $parentId = '', $level = 1 ) {
    $result = '';
    foreach( (array)$list as $part_id => &$value ) {
        if ( isset( $value[ 'parent' ] ) && $value[ 'parent' ] === $parentId ) {
            $children = get_part_item_post_index( $list, $part_id, $level + 1 );
            $result .= '<div class="index-item l' . $level . '"><a class="index-link" href="#' . $part_id . '">' . $value[ 'text' ] . '</a>' . $children . '</div>';
            unset( $list[ $part_id ] );
        }
    }
    return $result;
}