<?php
//ログイン時のスタイル
add_action( 'wp_enqueue_scripts', 'dony_tem_scripts' );
function dony_tem_scripts() {
    wp_deregister_style( 'wp-block-library' );
    wp_deregister_style( 'classic-theme-styles' );
    if ( !is_user_logged_in() ) {
        wp_deregister_script('jquery');
    } else {
        //シミュレーター用
        echo '<style>*::-webkit-scrollbar { display: none; }</style>';
    }
}

/*
 * スクリプトのtype削除
*/
add_filter( 'script_loader_tag', 'remove_script_type', 10, 2 );
function remove_script_type( $tag, $handle ) {
    $tag = str_replace( "type='text/javascript' ", "", $tag );
    if ( $handle === 'php_summary' || $handle === 'front_summary' ) {
        $tag = str_replace(' src=', ' defer src=', $tag );
    }
    return $tag;
}

/*-------------------------------
アクセス数カウント
-------------------------------*/
//検索エンジン判定
function is_search_robot() {
    $ua = $_SERVER[ 'HTTP_USER_AGENT' ];
    $bots = array( 'googlebot', 'bingbot', 'yahoo', );
    foreach( $bots as $bot ) {
        if ( stripos( $ua, $bot ) !== false ) {
            return true;
        }
    }
    return false;
}

/*-------------------------------
文字数制限
-------------------------------*/
function character_limit( $text, $count, $end = '' ) {
    if ( $text !== '' && $count !== null && $count !== '' ) {
        if ( mb_strlen( $text, 'UTF-8') > (int)$count ) {
            return mb_substr( strip_tags( $text, '<br>' ), 0, (int)$count, 'UTF-8' ) . $end;
        } else {
            return strip_tags( $text, '<br>' );
        }
    }
    return strip_tags( $text, '<br>' );
}

/*
 * 記事一覧用　タクソノミー一覧
 * $post_id：記事ID
 * $taxonomy：タクソノミータイプ
 * 返り値：タクソノミーの配列
*/
function front_part_taxonomy( $post_id, $taxonomy = 'category' ) {
    $terms = get_the_terms( $post_id, $taxonomy );
    $result = array();
    if ( !empty( $terms ) ) {
        $class = '';
        foreach( (array)$terms as $term ) {
            $result[] = [
                'term_id' => $term->term_id,
                'slug' => $term->slug,
                'name' => $term->name,
                'count' => $term->count,
                'parent' => $term->parent,
                'term_link' => get_term_link( $term->term_id, $taxonomy ),
            ];
            $class .= ' ' . $term->slug;
        }
        return array( 'terms' => $result, 'class' => $class );
    }
    return false;
}

/*
 * タクソノミーサムネイル
*/
function get_taxonomy_thumbnail_image( $term_id ) {
    $value = get_term_meta( $term_id, 'thumbnail', true );
    if ( $value !== '' ) {
        $image_arr = json_decode( $value, true );
        if ( isset( $image_arr[ 'type' ] ) && $image_arr[ 'type' ] === '2' && isset( $image_arr[ 'value' ] ) && $image_arr[ 'value' ] !== '' ) {
            return array( 'url' => $image_arr[ 'value' ] );
        } elseif ( isset( $image_arr[ 'type' ] ) && $image_arr[ 'type' ] === '1' && isset( $image_arr[ 'value' ] ) && $image_arr[ 'value' ] !== '' ) {
            return post_image_src_list( $image_arr[ 'value' ], null );
        }
    }
    return false;
}

/*
 * タクソノミーサムネイル
*/
function get_taxonomy_thumbnail_movie( $term_id ) {
    $value = get_term_meta( $term_id, 'movie_thumbnail', true );
    if ( $value !== '' ) {
        $movie = json_decode( $value, true );
        if ( isset( $movie[ 'value' ] ) && $movie[ 'value' ] !== '' ) {
            return $movie;
        }
    }
    return false;
}

/*
 * ユーザーイメージ
*/
function get_user_thumbnail_image( $user_id, $field ) {
    $value = get_user_meta( $user_id, $field, true );
    if ( $value !== '' ) {
        $value = wp_unslash( $value );
        $image_arr = json_decode( $value, true );
        if ( isset( $image_arr[ 'type' ] ) && $image_arr[ 'type' ] === '2' && isset( $image_arr[ 'value' ] ) && $image_arr[ 'value' ] !== '' ) {
            return array( 'url' => $image_arr[ 'value' ] );
        } elseif ( isset( $image_arr[ 'type' ] ) && $image_arr[ 'type' ] === '1' && isset( $image_arr[ 'value' ] ) && $image_arr[ 'value' ] !== '' ) {
            return post_image_src_list( $image_arr[ 'value' ], null );
        }
    }
    return false;
}

/*
 * 検索範囲（タイトルのみ）
*/
function custom_posts_where_title_only( $where, $wp_query ) {
    if ( !$wp_query->is_search ) {
        return $where;
    }
    global $wpdb;
    $posts = $wpdb->prefix . 'posts';
    $keyword = $wp_query->query[ 's' ];
    $pre = '';
    $keyword_arr = explode( ' ', $keyword );
    if ( is_array( $keyword_arr ) && count( $keyword_arr ) > 1 ) {
        foreach( (array)$keyword_arr as $word ) {
            if ( $word !== '' ) {
                if ( $pre !== '' ) {
                    $pre .= " AND ";
                }
                $pre .= "( {$posts}.post_title LIKE '%{$wor}d%' )";
            }
        }
        $pre = "OR ( {$pre} )";
    }
    $where .= " AND(( ( {$posts}.post_title LIKE '%{$keyword}%' ){$pre} ))";
    return $where;
}

/*
 * 検索範囲（本文のみ）
*/
function custom_posts_where_content_only( $where, $wp_query ) {
    if ( !$wp_query->is_search ) {
        return $where;
    }
    global $wpdb;
    $posts = $wpdb->prefix . 'posts';
    $keyword = $wp_query->query[ 's' ];
    $pre = '';
    $keyword_arr = explode( ' ', $keyword );
    if ( is_array( $keyword_arr ) && count( $keyword_arr ) > 1 ) {
        foreach( (array)$keyword_arr as $word ) {
            if ( $word !== '' ) {
                if ( $pre !== '' ) {
                    $pre .= " AND ";
                }
                $pre .= " ( ( {$posts}.post_excerpt LIKE '%{$word}%' ) OR ( {$posts}.post_content LIKE '%{$word}%' ) )";
            }
        }
        $pre = "OR ( {$pre} )";
    }
    $where .= " AND(( ( ( {$posts}.post_excerpt LIKE '%{$keyword}%' ) OR ( {$posts}.post_content LIKE '%{$keyword}%' ) ){$pre} ))";
    return $where;
}

/*
 * WPパラメータ追加
*/
add_filter( 'query_vars', 'add_query_archive_parm' );
function add_query_archive_parm( $vars ){
    $vars[] = 'orderby';
    $vars[] = 'order';
    $vars[] = 'count';
    $vars[] = 'srange';
    $vars[] = 'stax';
    $vars[] = 'slang';
    $vars[] = 'testab';
    return $vars;
}

/*
 * サイトViews
*/
function update_site_views() {
    $site_view_all = (int)get_option( 'dg_site_views', 0 );
    $site_view_y = (int)get_option( 'dg_site_views_y', 0 );
    $site_view_m = (int)get_option( 'dg_site_views_m', 0 );
    $site_view_w = (int)get_option( 'dg_site_views_w', 0 );
    ++$site_view_all;
    ++$site_view_y;
    ++$site_view_m;
    ++$site_view_w;
    update_option( 'dg_site_views', $site_view_all );
    update_option( 'dg_site_views_y', $site_view_y );
    update_option( 'dg_site_views_m', $site_view_m );
    update_option( 'dg_site_views_w', $site_view_w );
    return array(
        'views' => number_format( $site_view_all ),
        'y_views' => number_format( $site_view_y ),
        'm_views' => number_format( $site_view_m ),
        'w_views' => number_format( $site_view_w ),
    );
}