<?php
/*
 * ユーザーページにJSスクリプト追加
*/
add_action( 'admin_print_styles-user-edit.php', 'dg_style_user_style' );
add_action( 'admin_print_styles-profile.php', 'dg_style_user_style' );
function dg_style_user_style() {
    $site_update_time = date( 'YmdHis' );
    $directory_url = get_template_directory_uri();
    wp_register_style( 'taxonomy-admin-css', $directory_url . '/wp-admin/taxonomy/taxonomy-admin.css?ver=' . $site_update_time );
    wp_enqueue_style( 'taxonomy-admin-css' );
}

/*
 * ユーザーページにJSスクリプト追加
*/
add_action( 'admin_print_scripts-user-edit.php', 'dg_style_user_scripts' );
add_action( 'admin_print_scripts-profile.php', 'dg_style_user_scripts' );
function dg_style_user_scripts() {
    $site_update_time = date( 'YmdHis' );
    $directory_url = get_template_directory_uri();
    wp_enqueue_media();
    wp_enqueue_script( 'media-upload' );
    $wp_js = array( 'jquery', 'wp-i18n', );
    wp_enqueue_script( 'site_builder_js', $directory_url . '/wp-admin/user/user-admin.js', $wp_js, $site_update_time, true );
    //JS翻訳スクリプト追加
    wp_set_script_translations( 'site_builder_js', 'dg-style', get_template_directory() . '/languages' );
}

/*
 * ユーザー編集
*/

add_action( 'show_password_fields', 'custom_user_fields' );
function custom_user_fields( $bool ) {
    global $profileuser;
    global $user_id;
    $this_user_id = is_object( $profileuser ) ? $profileuser->ID : $user_id;

    $text_image_btn = __( 'イメージ選択', 'dg-style' );
    $text_image_delete = __( '削除', 'dg-style' );
    //ユーザーイメージ
    $wp_image = '<a href="#" class="user-upload-btn ui-btn">' . $text_image_btn . '</a><a class="user-remove-btn ui-btn">' . $text_image_delete . '</a>';
    $url_image = '';
    $url_value = '';
    $wp_check = ' checked';
    $url_check = '';
    $wp_on = ' on';
    $url_on = '';
    $user_image = '';
    
    if ( is_numeric( $this_user_id ) ) {
        $user_image = get_user_meta( $this_user_id, 'user_image', true );
        if ( $user_image !== '' ) {
            $user_image = wp_unslash( $user_image );
            $image_arr = json_decode( $user_image, true );
            if ( isset( $image_arr[ 'type' ] ) && $image_arr[ 'type' ] === '2' ) {
                $url_image = '<img src="' . $image_arr[ 'value' ] . '">';
                $url_value = $image_arr[ 'value' ];
                $url_check = ' checked';
                $url_on = ' on';
                $wp_check = '';
                $wp_on = '';
            } elseif ( isset( $image_arr[ 'type' ] ) && $image_arr[ 'type' ] === '1' && isset( $image_arr[ 'value' ] ) && $image_arr[ 'value' ] !== '' ) {
                $thumb = wp_get_attachment_image_src( $image_arr[ 'value' ], 'full' );
                $wp_image = '<a href="#" class="user-upload-btn"><img src="' . $thumb[ 0 ] . '"></a><a class="user-remove-btn ui-btn on">' . $text_image_delete . '</a>';
            }
            $user_image = htmlspecialchars( $user_image, ENT_QUOTES, 'UTF-8' );
        }
    }
    
    
    //背景イメージ
    //イメージ関連
    $wp_bg_image = '<a href="#" class="user-upload-btn ui-btn">' . $text_image_btn . '</a><a class="user-remove-btn ui-btn">' . $text_image_delete . '</a>';
    $url_bg_image = '';
    $url_bg_value = '';
    $wp_bg_check = ' checked';
    $url_bg_check = '';
    $wp_bg_on = ' on';
    $url_bg_on = '';
    $bg_image = '';
    if ( is_numeric( $this_user_id ) ) {
        $bg_image = get_user_meta( $this_user_id, 'bg_image', true );
        if ( $bg_image !== '' ) {
            $bg_image = wp_unslash( $bg_image );
            $bg_image_arr = json_decode( $bg_image, true );
            if ( isset( $bg_image_arr[ 'type' ] ) && $bg_image_arr[ 'type' ] === '2' ) {
                $url_bg_image = '<img src="' . $bg_image_arr[ 'value' ] . '">';
                $url_bg_value = $bg_image_arr[ 'value' ];
                $url_bg_check = ' checked';
                $url_bg_on = ' on';
                $wp_bg_check = '';
                $wp_bg_on = '';
            } elseif ( isset( $bg_image_arr[ 'type' ] ) && $bg_image_arr[ 'type' ] === '1' && isset( $bg_image_arr[ 'value' ] ) && $bg_image_arr[ 'value' ] !== '' ) {
                $thumb = wp_get_attachment_image_src( $bg_image_arr[ 'value' ], 'full' );
                $wp_bg_image = '<a href="#" class="user-upload-btn"><img src="' . $thumb[ 0 ] . '"></a><a class="user-remove-btn ui-btn on">' . $text_image_delete . '</a>';
            }
            $bg_image = htmlspecialchars( $bg_image, ENT_QUOTES, 'UTF-8' );
        }
    }
    
    //動画サムネイル
    $text_movie_btn = __( '動画を選択', 'dg-style' );
    $movie_value = '';
    $movie_wp_on = ' on';
    $movie_wp_check = ' checked';
    $movie_wp_btn = '<a href="#" class="movie-upload-btn ui-btn">' . $text_movie_btn . '</a><a class="movie-remove-btn ui-btn">' . $text_image_delete . '</a>';
    $movie_url_on = '';
    $movie_url_check = '';
    $movie_url_value = '';
    $movie_url_simulator = '';
    $iframe_on = '';
    $iframe_check = '';
    $iframe_value = '';
    $iframe_tag = '';
    if ( is_numeric( $this_user_id ) ) {
        $movie_thumbnail = get_user_meta( $this_user_id, 'movie_thumbnail', true );
        if ( $movie_thumbnail !== '' ) {
            $movie_thumbnail = wp_unslash( $movie_thumbnail );
            $movie_arr = json_decode( $movie_thumbnail, true );
            if ( isset( $movie_arr[ 'type' ] ) && $movie_arr[ 'type' ] === '1' ) {
                $movie_wp_on = ' on';
                $movie_wp_check = ' checked';
                if ( isset( $movie_arr[ 'value' ] ) && $movie_arr[ 'value' ] !== '' ) {
                    $movie_wp_btn = '<a href="#" class="movie-upload-btn"><video controls="true"><source src="' . $movie_arr[ 'value' ] . '"></video></a><a class="movie-remove-btn ui-btn on">' . $text_image_delete . '</a>';
                }
            } elseif ( isset( $movie_arr[ 'type' ] ) && $movie_arr[ 'type' ] === '2' ) {
                $movie_wp_on = '';
                $movie_wp_check = '';
                $movie_url_on = ' on';
                $movie_url_check = ' checked';
                if ( isset( $movie_arr[ 'value' ] ) && $movie_arr[ 'value' ] !== '' ) {
                    $movie_url_value = $movie_arr[ 'value' ];
                    $movie_url_simulator = '<video controls="true"><source src="' . $movie_arr[ 'value' ] . '"></video>';
                }
            } elseif ( isset( $movie_arr[ 'type' ] ) && $movie_arr[ 'type' ] === '3' ) {
                $movie_wp_on = '';
                $movie_wp_check = '';
                $iframe_on = ' on';
                $iframe_check = ' checked';
                if ( isset( $movie_arr[ 'value' ] ) && $movie_arr[ 'value' ] !== '' ) {
                    $iframe_value = htmlspecialchars( $movie_arr[ 'value' ], ENT_QUOTES, 'UTF-8' );
                    $iframe_tag = $movie_arr[ 'value' ];
                }
            }
            $movie_value = htmlspecialchars( $movie_thumbnail, ENT_QUOTES, 'UTF-8' );
        }
    }
    //SNS
    $sns_value = '';
    $sns_arr = array();
    $sns = array( 'facebook', 'twitter', 'line' );
    if ( is_numeric( $this_user_id ) ) {
        $sns_value = get_user_meta( $this_user_id, 'user_sns', true );
        if ( $sns_value !== '' ) {
            $sns_value = wp_unslash( $sns_value );
            $sns_arr = json_decode( $sns_value, true );
            $sns_value = htmlspecialchars( $sns_value, ENT_QUOTES, 'UTF-8' );
        }
    }
    $sns_list = '';
    foreach( (array)$sns as $key ) {
        $sns_data = '';
        if ( isset( $sns_arr[ $key ] ) ) {
            $sns_data = $sns_arr[ $key ];
        }
        $sns_list .= '<div class="sns-line"><strong class="sns-name">' . $key . '-URL</strong><input type="text" class="set-value" value="' . $sns_data . '" data-level="' . $key . '"></div>';
    }
    //翻訳
    $text_wp_image = __( 'WPイメージ', 'dg-style' );
    $text_image_url = __( 'イメージURL', 'dg-style' );
    $text_wp_movie = __( 'WP動画', 'dg-style' );
    $text_movie_url = __( '動画URL', 'dg-style' );
    $text_movie_iframe = __( 'iframeタグ', 'dg-style' );
    $text_title1 = __( 'SNS情報', 'dg-style' );
    $text_title2 = __( 'ユーザーイメージ', 'dg-style' );
    $text_title3 = __( '背景イメージ', 'dg-style' );
    $text_title4 = __( '動画サムネイル', 'dg-style' );
    
    echo <<< EOM
        <table class="form-table user-form-table" role="presentation">
            <tbody>
                <tr class="user-email-wrap">
                    <th>{$text_title1}</th>
                    <td>
                        <div class="set-inner">
                            {$sns_list}
                            <input type="hidden" class="summary-value-input" id="user_sns" name="user_sns" value="{$sns_value}">
                        </div>
                    </td>
                </tr>
                <tr class="user-thumb-wrap">
                    <th>{$text_title2}</th>
                    <td>
                        <div class="tab-inner image-select-tabs">
                            <div class="tab-list option-labels flex">
                                <label class="tab-label option-label{$wp_on}"><input type="radio" name="user-type" value="1" class="user-image-input none-display"{$wp_check}><span class="toggle-label">{$text_wp_image}</span></label>
                                <label class="tab-label option-label{$url_on}"><input type="radio" name="user-type" value="2" class="user-image-input none-display"{$url_check}><span class="toggle-label">{$text_image_url}</span></label>
                            </div>
                            <div class="tab-contents option-contents">
                                <div class="tab-content{$wp_on}">
                                    <div class="image-box user-wp-image">{$wp_image}</div>
                                </div>
                                <div class="tab-content{$url_on}">
                                    <div class="window-title">{$text_image_url}</div>
                                    <input type="text" class="user-url-value image-url-value user-url-input" value="{$url_value}">
                                    <div class="image-simulator user-url-simulator">{$url_image}</div>
                                </div>
                            </div>
                            <input type="hidden" name="user_image" id="user_image" class="user-image-input-value" value="{$user_image}">
                        </div>
                    </td>
                <tr>
                <tr class="user-bg-image-wrap">
                    <th>{$text_title3}</th>
                    <td>
                        <div class="tab-inner image-select-tabs">
                            <div class="tab-list option-labels flex">
                                <label class="tab-label option-label{$wp_bg_on}"><input type="radio" name="user-type" value="1" class="user-image-input none-display"{$wp_bg_check}><span class="toggle-label">{$text_wp_image}</span></label>
                                <label class="tab-label option-label{$url_bg_on}"><input type="radio" name="user-type" value="2" class="user-image-input none-display"{$url_bg_check}><span class="toggle-label">{$text_image_url}</span></label>
                            </div>
                            <div class="tab-contents option-contents">
                                <div class="tab-content{$wp_bg_on}">
                                    <div class="image-box user-wp-image">{$wp_bg_image}</div>
                                </div>
                                <div class="tab-content{$url_bg_on}">
                                    <div class="window-title">{$text_image_url}</div>
                                    <input type="text" class="user-url-value image-url-value user-url-input" value="{$url_bg_value}">
                                    <div class="image-simulator user-url-simulator">{$url_bg_image}</div>
                                </div>
                            </div>
                            <input type="hidden" name="bg_image" id="bg_image" class="user-image-input-value" value="{$bg_image}">
                        </div>
                    </td>
                <tr>
                <tr class="user-movie-wrap">
                    <th>{$text_title4}</th>
                    <td>
                        <div class="tab-inner movie-select-tabs">
                            <div class="tab-list movie-labels flex">
                                <label class="tab-label movie-label{$movie_wp_on}"><input type="radio" name="movie-thumbnail-type" value="1" class="movie-thumbnail-input none-display"{$movie_wp_check}><span class="toggle-label">{$text_wp_movie}</span></label>
                                <label class="tab-label movie-label{$movie_url_on}"><input type="radio" name="movie-thumbnail-type" value="2" class="movie-thumbnail-input none-display"{$movie_url_check}><span class="toggle-label">{$text_movie_url}</span></label>
                                <label class="tab-label movie-label{$iframe_on}"><input type="radio" name="movie-thumbnail-type" value="3" class="movie-thumbnail-input none-display"{$iframe_check}><span class="toggle-label">{$text_movie_iframe}</span></label>
                            </div>
                            <div class="tab-contents movie-contents">
                                <div class="tab-content{$movie_wp_on}">
                                    <div id="wp-movie-thumbnail" class="movie-box">{$movie_wp_btn}</div>
                                </div>
                                <div class="tab-content{$movie_url_on}">
                                    <label for="movie-thumbnail-url-input" class="dg-custom-title">{$text_movie_url}</label>
                                    <input id="movie-thumbnail-url-input" type="text" class="movie-thumbnail-url-value movie-url-value" value="{$movie_url_value}">
                                    <div id="movie-thumbnail-url-simulator" class="movie-thumbnail-simulator">{$movie_url_simulator}</div>
                                </div>
                                <div class="tab-content{$iframe_on}">
                                    <label for="movie-thumbnail-iframe-input" class="dg-custom-title">{$text_movie_iframe}</label>
                                    <input id="movie-thumbnail-iframe-input" type="text" class="movie-thumbnail-iframe-value movie-iframe-value" value="{$iframe_value}">
                                    <div id="movie-thumbnail-iframe-simulator" class="movie-thumbnail-simulator">{$iframe_tag}</div>
                                </div>
                            </div>
                            <input type="hidden" name="movie_thumbnail" id="movie-thumbnail-value" value="{$movie_value}">
                        </div>
                    </td>
                <tr>
            </tbody>
        </table>
EOM;
    return $bool;
}

/*
 * ユーザーカスタム情報保存
*/
add_action( 'personal_options_update', 'save_custom_user_meta' );
add_action( 'edit_user_profile_update', 'save_custom_user_meta' );
function save_custom_user_meta( $user_id ) {
    // 権限があるユーザーのみ編集可能
    if ( !current_user_can( 'edit_user', $user_id ) ) {
        return false;
    }
    if ( isset( $_POST[ 'user_image' ] ) ) {
        update_user_meta( $user_id, 'user_image', wp_slash( $_POST[ 'user_image' ] ) );
    }
    if ( isset( $_POST[ 'bg_image' ] ) ) {
        update_user_meta( $user_id, 'bg_image', wp_slash( $_POST[ 'bg_image' ] ) );
    }
    if ( isset( $_POST[ 'movie_thumbnail' ] ) ) {
        update_user_meta( $user_id, 'movie_thumbnail', wp_slash( $_POST[ 'movie_thumbnail' ] ) );
    }
    if ( isset( $_POST[ 'user_sns' ] ) ) {
        update_user_meta( $user_id, 'user_sns', wp_slash( $_POST[ 'user_sns' ] ) );
    }
    
}