<?php
/*
 * タクソノミーページにJSスクリプト追加
*/
add_action( 'admin_print_styles-edit-tags.php', 'dg_style_taxonomy_style' );
add_action( 'admin_print_styles-term.php', 'dg_style_taxonomy_style' );
function dg_style_taxonomy_style() {
    $site_update_time = date( 'YmdHis' );
    $directory_url = get_template_directory_uri();
    wp_register_style( 'taxonomy-admin-css', $directory_url . '/wp-admin/taxonomy/taxonomy-admin.css?ver=' . $site_update_time );
    wp_enqueue_style( 'taxonomy-admin-css' );
}

/*
 * タクソノミーページにJSスクリプト追加
*/
add_action( 'admin_print_scripts-edit-tags.php', 'dg_style_taxonomy_scripts' );
add_action( 'admin_print_scripts-term.php', 'dg_style_taxonomy_scripts' );
function dg_style_taxonomy_scripts() {
    $site_update_time = date( 'YmdHis' );
    $directory_url = get_template_directory_uri();
    wp_enqueue_media();
    wp_enqueue_script( 'media-upload' );
    $wp_js = array( 'jquery', 'wp-i18n', );
    wp_enqueue_script( 'site_builder_js', $directory_url . '/wp-admin/taxonomy/taxonomy-admin.js', $wp_js, $site_update_time, true );
    //JS翻訳スクリプト追加
    wp_set_script_translations( 'site_builder_js', 'dg-style', get_template_directory() . '/languages' );
}

/*
 * 今まで登録したタクソノミー全体に挿入
*/
add_action( 'admin_init', 'dg_style_add_taxonomy_custom_fields' );
function dg_style_add_taxonomy_custom_fields() {
    $taxonomise = default_taxonomy_exclusion( array( 'category', 'post_tag' ) );
    foreach( (array)$taxonomise as $tax ) {
        if ( $tax !== 'patterns_type' ) {
            add_action( $tax . '_add_form_fields', 'dg_style_taxonomy_custom_fields' );
            add_action ( $tax . '_edit_form_fields', 'dg_style_taxonomy_custom_fields');
            add_filter( 'manage_edit-' . $tax . '_columns' , 'dg_style_taxonomy_custom_value_display' );
            add_filter( 'manage_' . $tax . '_custom_column' , 'dg_style_taxonomy_custom_value', 10, 3 );
        }
    }
}
/*
 * タクソノミー一覧にカスタム情報表示
*/
function dg_style_taxonomy_custom_value_display( $columns ) {
    $columns[ 'thumbnail' ] = 'Thumbnail';
    $columns[ 'sub-title' ] = __( 'サブタイトル', 'dg-style' );
    $columns[ 'dg_meta_title' ] = __( 'METAタイトル', 'dg-style' );
    $columns[ 'dg_meta_description' ] = __( 'METAディスクリプション', 'dg-style' );
    $columns[ 'dg_meta_noindex' ] = 'noindex';
    return $columns;
}

/*
 * タクソノミー一覧にカスタム情報表示
*/
function dg_style_taxonomy_custom_value( $content, $column_name, $term_id ) {
    if ( $column_name === 'thumbnail' ) {
        $thumb = get_taxonomy_thumbnail_image( $term_id );
        if ( $thumb !== false ) {
            if ( isset( $thumb[ 'url' ] ) ) {
                $content = '<img src="' . $thumb[ 'url' ] . '" width="50" height="50">';
            } else {
                if ( isset( $thumb[ 'thumbnail' ][ 'url' ] ) ) {
                    $content = '<img src="' . $thumb[ 'thumbnail' ][ 'url' ] . '" width="50" height="50">';
                } elseif ( isset( $thumb[ 'full' ][ 'url' ] ) ) {
                    $content = '<img src="' . $thumb[ 'full' ][ 'url' ] . '" width="50" height="50">';
                }
            }
        }
    } elseif ( $column_name === 'sub-title' ) {
        $sub_title = get_term_meta( $term_id, 'sub_title', true );
        if ( $sub_title !== '' ) {
            $content = '<span class="meta-text">' . $sub_title . '</span>';
        }
    } elseif ( $column_name === 'dg_meta_title' ) {
        $title = '';
        $meta_info = get_term_meta( $term_id, 'meta_info', true );
        if ( $meta_info !== '' ) {
            $meta_info = json_decode( $meta_info, true );
            $title = isset( $meta_info[ 'title' ] ) ? $meta_info[ 'title' ] : '';
        }
        if ( $title !== '' ) {
            $content = '<span class="meta-text">' . $title . '</span>';
        }
    } elseif ( $column_name === 'dg_meta_description' ) {
        $description = '';
        $meta_info = get_term_meta( $term_id, 'meta_info', true );
        if ( $meta_info !== '' ) {
            $meta_info = json_decode( $meta_info, true );
            $description = isset( $meta_info[ 'description' ] ) ? $meta_info[ 'description' ] : '';
        }
        if ( $description !== '' ) {
            $content = '<span class="meta-text">' . $description . '</span>';
        }
    } elseif ( $column_name === 'dg_meta_noindex' ) {
        $noindex = '';
        $meta_info = get_term_meta( $term_id, 'meta_info', true );
        if ( $meta_info !== '' ) {
            $meta_info = json_decode( $meta_info, true );
            $noindex = isset( $meta_info[ 'noindex' ] ) ? $meta_info[ 'noindex' ] : '';
        }
        if ( $noindex !== '' ) {
            $content = '<span class="meta-text">Noindex中</span>';
        }
    }
    if ( $content !== '' ) {
        return $content;
    } else {
        return 'None';
    }
}


/*
 * タクソノミーカスタム情報追加
*/
function dg_style_taxonomy_custom_fields( $term ) {
    $text_image_btn = __( 'イメージ選択', 'dg-style' );
    $text_movie_btn = __( '動画を選択', 'dg-style' );
    $text_image_delete = __( '削除', 'dg-style' );
    //イメージ関連
    $wp_image = '<a href="#" class="taxonomy-upload-btn ui-btn">' . $text_image_btn . '</a><a class="taxonomy-remove-btn ui-btn">' . $text_image_delete . '</a>';
    $url_image = '';
    $url_value = '';
    $wp_check = ' checked';
    $url_check = '';
    $wp_on = ' on';
    $url_on = '';
    $value = '';
    //META
    $meta_title = '';
    $meta_description = '';
    $meta_noindex = '';
    //表示数
    $count = '';
    $orderby = '';
    $order = '';
    //サブタイトル
    $sub_title = '';
    //動画サムネイル
    $movie_value = '';
    $movie_wp_on = ' on';
    $movie_wp_check = ' checked';
    $movie_wp_btn = '<a href="#" class="movie-upload-btn ui-btn">' . $text_movie_btn . '</a><a class="movie-remove-btn ui-btn">' . $text_image_delete . '</a>';
    $movie_url_on = '';
    $movie_url_check = '';
    $movie_url_value = '';
    $movie_url_simulator = '';
    $iframe_on = '';
    $iframe_check = '';
    $iframe_value = '';
    $iframe_tag = '';
    if ( is_object( $term ) ) {
        //イメージ関連
        $value = get_term_meta( $term->term_id, 'thumbnail', true );
        if ( $value !== '' ) {
            $image_arr = json_decode( $value, true );
            if ( isset( $image_arr[ 'type' ] ) && $image_arr[ 'type' ] === '2' ) {
                $url_image = '<img src="' . $image_arr[ 'value' ] . '">';
                $url_value = $image_arr[ 'value' ];
                $url_check = ' checked';
                $url_on = ' on';
                $wp_check = '';
                $wp_on = '';
            } elseif ( isset( $image_arr[ 'type' ] ) && $image_arr[ 'type' ] === '1' && isset( $image_arr[ 'value' ] ) && $image_arr[ 'value' ] !== '' ) {
                $thumb = wp_get_attachment_image_src( $image_arr[ 'value' ], 'full' );
                $wp_image = '<a href="#" class="taxonomy-upload-btn"><img src="' . $thumb[ 0 ] . '"></a><a class="taxonomy-remove-btn ui-btn on">' . $text_image_delete . '</a>';
            }
            $value = htmlspecialchars( $value, ENT_QUOTES, 'UTF-8' );
        }

        //METAタイトル
        $meta_info = get_term_meta( $term->term_id, 'meta_info', true );
        if ( $meta_info !== '' ) {
            $meta_info = json_decode( $meta_info, true );
            $meta_title = isset( $meta_info[ 'title' ] ) ? $meta_info[ 'title' ] : '';
            $meta_description = isset( $meta_info[ 'description' ] ) ? $meta_info[ 'description' ] : '';
            $meta_noindex = isset( $meta_info[ 'noindex' ] ) && $meta_info[ 'noindex' ] === '1' ? ' checked' : '';
        }
        // 表示数
        $count = get_term_meta( $term->term_id, 'count', true );
        $orderby = get_term_meta( $term->term_id, 'orderby', true );
        $order = get_term_meta( $term->term_id, 'order', true );

        //サブタイトル
        $sub_title = get_term_meta( $term->term_id, 'sub_title', true );
        
        //動画サムネイル
        $movie_thumbnail = get_term_meta( $term->term_id, 'movie_thumbnail', true );
        if ( $movie_thumbnail !== '' ) {
            $movie_arr = json_decode( $movie_thumbnail, true );
            if ( isset( $movie_arr[ 'type' ] ) && $movie_arr[ 'type' ] === '1' ) {
                $movie_wp_on = ' on';
                $movie_wp_check = ' checked';
                if ( isset( $movie_arr[ 'value' ] ) && $movie_arr[ 'value' ] !== '' ) {
                    $movie_wp_btn = '<a href="#" class="movie-upload-btn"><video controls="true"><source src="' . $movie_arr[ 'value' ] . '"></video></a><a class="movie-remove-btn ui-btn on">' . $text_image_delete . '</a>';
                }
            } elseif ( isset( $movie_arr[ 'type' ] ) && $movie_arr[ 'type' ] === '2' ) {
                $movie_wp_on = '';
                $movie_wp_check = '';
                $movie_url_on = ' on';
                $movie_url_check = ' checked';
                if ( isset( $movie_arr[ 'value' ] ) && $movie_arr[ 'value' ] !== '' ) {
                    $movie_url_value = $movie_arr[ 'value' ];
                    $movie_url_simulator = '<video controls="true"><source src="' . $movie_arr[ 'value' ] . '"></video>';
                }
            } elseif ( isset( $movie_arr[ 'type' ] ) && $movie_arr[ 'type' ] === '3' ) {
                $movie_wp_on = '';
                $movie_wp_check = '';
                $iframe_on = ' on';
                $iframe_check = ' checked';
                if ( isset( $movie_arr[ 'value' ] ) && $movie_arr[ 'value' ] !== '' ) {
                    $iframe_value = htmlspecialchars( $movie_arr[ 'value' ], ENT_QUOTES, 'UTF-8' );
                    $iframe_tag = $movie_arr[ 'value' ];
                }
            }
            $movie_value = htmlspecialchars( $movie_thumbnail, ENT_QUOTES, 'UTF-8' );
        }
    }
    // 表示数
    $order_by_option = '';
    $order_option = '';
    $order_by = array( 'date' => __( '公開日', 'dg-style' ), 'modified' => __( '更新日', 'dg-style' ), 'views' => __( '人気順（全体）', 'dg-style' ), 'w_views' => __( '人気順（週間）', 'dg-style' ), 'm_views' => __( '人気順（月間）', 'dg-style' ), 'y_views' => __( '人気順（年間）', 'dg-style' ), 'evaluate' => __( '評価順', 'dg-style' ), 'bookmark' => __( 'ブックマーク数順', 'dg-style' ), 'comment_count' => __( 'コメント多い順', 'dg-style' ), 'author' => __( '作成者順', 'dg-style' ), 'rand' => __( 'ランダム', 'dg-style' ), 'title' => __( '記事タイトル', 'dg-style' ), );
    foreach( (array)$order_by as $key => $name ) {
        $selected = $orderby === $key ? ' selected' : '';
        $order_by_option .= '<option value="' . $key . '"' . $selected . '>' . $name . '</option>';
    }
    foreach( array( 'DESC' => __( '降順（最新）', 'dg-style' ), 'ASC' => __( '昇順（古い）', 'dg-style' ), ) as $key => $name ) {
        $selected = $order === $key ? ' selected' : '';
        $order_option .= '<option value="' . $key . '"' . $selected . '>' . $name . '</option>';
    }

    //翻訳
    $text_wp_image = __( 'WPイメージ', 'dg-style' );
    $text_image_url = __( 'イメージURL', 'dg-style' );
    $text_wp_movie = __( 'WP動画', 'dg-style' );
    $text_movie_url = __( '動画URL', 'dg-style' );
    $text_movie_iframe = __( 'iframeタグ', 'dg-style' );
    $text_title1 = __( 'サブタイトル', 'dg-style' );
    $text_title1_caution = __( '名前とは別で表示できるサブタイトルを設定できます。', 'dg-style' );
    $text_title2 = __( 'サムネイル', 'dg-style' );
    $text_title3 = __( '動画サムネイル', 'dg-style' );
    $text_title4 = __( 'METAタイトル', 'dg-style' );
    $text_title4_caution = __( '検索エンジン用のタイトルを別途設定できます。', 'dg-style' );
    $text_title5 = __( 'METAディスクリプション', 'dg-style' );
    $text_title5_caution = __( '検索エンジン用のディスクリプションを別途設定できます。', 'dg-style' );
    $text_title6 = __( 'Noindexにする', 'dg-style' );
    $text_title7 = __( '記事表示数＆表示順', 'dg-style' );
    $text_title7_caution = __( '該当カテゴリーページでの記事表示数や表示順を指定します。', 'dg-style' );
    echo <<< EOM
        <tr class="form-field costom-taxonomy-field">
            <th><div class="custom-title">{$text_title7}</div></th>
            <td>
                <div class="form-field sub-title-area taxonomy-custom-contents">
                    <p>表示数：<input type="number" class="inline-input" name="taxonomy-count" value="{$count}"></p>
                    <p>表示順：<select name="taxonomy-orderby">{$order_by_option}</select>で<select name="taxonomy-order">{$order_option}</select></p>
                    <p class="description">※{$text_title7_caution}</p>
                </div>
            </td>
        </tr>
        <tr class="form-field costom-taxonomy-field">
            <th><div class="custom-title"><label for="taxonomy-sub-title">{$text_title1}</label></div></th>
            <td>
                <div class="form-field sub-title-area taxonomy-custom-contents">
                    <input id="taxonomy-sub-title" name="taxonomy-sub_title" type="text" value="{$sub_title}">
                    <p class="description">※{$text_title1_caution}</p>
                </div>
            </td>
        </tr>
        <tr class="form-field costom-taxonomy-field">
            <th><div class="custom-title">{$text_title2}</div></th>
            <td>
                <div class="form-field tab-inner image-select-tabs">
                    <div class="tab-list option-labels flex">
                        <label class="tab-label option-label{$wp_on}"><input type="radio" name="taxonomy-type" value="1" class="taxonomy-image-input none-display"{$wp_check}><span class="toggle-label">{$text_wp_image}</span></label>
                        <label class="tab-label option-label{$url_on}"><input type="radio" name="taxonomy-type" value="2" class="taxonomy-image-input none-display"{$url_check}><span class="toggle-label">{$text_image_url}</span></label>
                    </div>
                    <div class="tab-contents option-contents">
                        <div class="tab-content{$wp_on}">
                            <div id="taxonomy-wp-image" class="image-box">{$wp_image}</div>
                        </div>
                        <div class="tab-content{$url_on}">
                            <div class="window-title">{$text_image_url}</div>
                            <input id="taxonomy-url-input" type="text" class="taxonomy-url-value image-url-value" value="{$url_value}">
                            <div id="taxonomy-url-simulator" class="image-simulator">{$url_image}</div>
                        </div>
                    </div>
                    <input type="text" class="none-display" name="taxonomy-thumbnail" id="taxonomy-thumbnail" value="{$value}">
                </div>
            </td>
        </tr>
        <tr class="form-field costom-taxonomy-field">
            <th><div class="custom-title">{$text_title3}</div></th>
            <td>
                <div class="form-field tab-inner movie-select-tabs">
                    <div class="tab-list movie-labels flex">
                        <label class="tab-label movie-label{$movie_wp_on}"><input type="radio" name="movie-thumbnail-type" value="1" class="movie-thumbnail-input none-display"{$movie_wp_check}><span class="toggle-label">{$text_wp_movie}</span></label>
                        <label class="tab-label movie-label{$movie_url_on}"><input type="radio" name="movie-thumbnail-type" value="2" class="movie-thumbnail-input none-display"{$movie_url_check}><span class="toggle-label">{$text_movie_url}</span></label>
                        <label class="tab-label movie-label{$iframe_on}"><input type="radio" name="movie-thumbnail-type" value="3" class="movie-thumbnail-input none-display"{$iframe_check}><span class="toggle-label">{$text_movie_iframe}</span></label>
                    </div>
                    <div class="tab-contents movie-contents">
                        <div class="tab-content{$movie_wp_on}">
                            <div id="wp-movie-thumbnail" class="movie-box">{$movie_wp_btn}</div>
                        </div>
                        <div class="tab-content{$movie_url_on}">
                            <label for="movie-thumbnail-url-input" class="dg-custom-title">{$text_movie_url}</label>
                            <input id="movie-thumbnail-url-input" type="text" class="movie-thumbnail-url-value movie-url-value" value="{$movie_url_value}">
                            <div id="movie-thumbnail-url-simulator" class="movie-thumbnail-simulator">{$movie_url_simulator}</div>
                        </div>
                        <div class="tab-content{$iframe_on}">
                            <label for="movie-thumbnail-iframe-input" class="dg-custom-title">{$text_movie_iframe}</label>
                            <input id="movie-thumbnail-iframe-input" type="text" class="movie-thumbnail-iframe-value movie-iframe-value" value="{$iframe_value}">
                            <div id="movie-thumbnail-iframe-simulator" class="movie-thumbnail-simulator">{$iframe_tag}</div>
                        </div>
                    </div>
                    <input type="text" class="none-display" name="taxonomy-movie_thumbnail" id="movie-thumbnail-value" value="{$movie_value}">
                </div>
            </td>
        </tr>
        <tr class="form-field costom-taxonomy-field">
            <th><div class="custom-title"><label for="taxonomy-meta-title">{$text_title4}</label></div></th>
            <td>
                <div class="form-field meta-description-area taxonomy-custom-contents">
                    <input id="taxonomy-meta-title" name="taxonomy_meta_title" type="text" value="{$meta_title}">
                    <p class="description">※{$text_title4_caution}</p>
                </div>
            </td>
        </tr>
        <tr class="form-field costom-taxonomy-field">
            <th><div class="custom-title"><label for="taxonomy-meta-description">{$text_title5}</label></div></th>
            <td>
                <div class="form-field meta-description-area taxonomy-custom-contents">
                    <textarea id="taxonomy-meta-description" name="taxonomy_meta_description" rows="5">{$meta_description}</textarea>
                    <p class="description">※{$text_title5_caution}</p>
                </div>
            </td>
        </tr>
        <tr class="form-field costom-taxonomy-field">
            <th><div class="custom-title"><label for="taxonomy-meta-noindex">Noindex</label></div></th>
            <td>
                <div class="form-field meta-description-area taxonomy-custom-contents">
                    <label><input type="checkbox" id="taxonomy-meta-noindex" name="taxonomy_meta_noindex" value="1"{$meta_noindex}>{$text_title6}</label>
                </div>
            </td>
        </tr>
EOM;
}

/*
 * 値の保存
*/
add_action( 'create_term', 'dg_style_save_terms' );
add_action( 'edit_terms', 'dg_style_save_terms' );
function dg_style_save_terms( $term_id ) {
    $option_keys = array( 'count', 'orderby', 'order', 'thumbnail', 'movie_thumbnail', 'sub_title', );
    foreach( (array)$option_keys as $key ) {
        if ( isset( $_POST[ 'taxonomy-' . $key ] ) ) {
            update_term_meta( $term_id, $key, $_POST[ 'taxonomy-' . $key ] );
        }
    }
    // 表示数がデフォルト表示数より小さい場合起こるバグを防ぐ
    if ( isset( $_POST[ 'taxonomy-count' ] ) && $_POST[ 'taxonomy-count' ] !== '') {
        $posts_per_page = (int)get_option( 'posts_per_page' );
        if ( (int)$_POST[ 'taxonomy-count' ] < $posts_per_page ) {
            update_option( 'posts_per_page', $_POST[ 'taxonomy-count' ] );
        }
    }

    //META
    $meta_info = array();
    if ( isset( $_POST[ 'taxonomy_meta_title' ] ) ) {
        $meta_info[ 'title' ] = strip_tags( $_POST[ 'taxonomy_meta_title' ] );
    }
    if ( isset( $_POST[ 'taxonomy_meta_description' ] ) ) {
        $meta_info[ 'description' ] = strip_tags( $_POST[ 'taxonomy_meta_description' ] );
    }
    if ( isset( $_POST[ 'taxonomy_meta_noindex' ] ) ) {
        $meta_info[ 'noindex' ] = strip_tags( $_POST[ 'taxonomy_meta_noindex' ] );
    }
    if ( isset( $_POST[ 'taxonomy_meta_title' ] ) || isset( $_POST[ 'taxonomy_meta_description' ] ) || isset( $_POST[ 'taxonomy_meta_noindex' ] ) ) {
        update_term_meta( $term_id, 'meta_info', wp_slash( json_encode( $meta_info ) ) );
    }
}