<?php
/*
 * LPの追加
*/
add_action( 'init', 'add_dg_style_post_type_lp' );
function add_dg_style_post_type_lp() {
    $license_key = get_option( 'DG_license_key', '' );
    $license_type = get_option( 'DG_license_type', '' );
    $labels = array(
        'name' => 'LP',
        'singular_name' => 'LP',
        'menu_name' => 'LP',
        'name_admin_bar' => 'LP',
        'add_new' => __( '新規追加', 'dg-style' ),
        'add_new_item' => __( 'LP追加', 'dg-style' ),
        'new_item' => __( '新しいLP', 'dg-style' ),
        'edit_item' => __( 'LP修正', 'dg-style' ),
        'view_item' => __( 'LP表示', 'dg-style' ),
        'all_items' => __( 'LP一覧', 'dg-style' ),
        'search_items' => __( '検索', 'dg-style' ),
        'not_found' => __( 'LPが見つかりません。', 'dg-style' ),
        'not_found_in_trash' => __( 'ゴミ箱にLPが見つかりません。', 'dg-style' )
    );
    $args = array(
        'labels' => $labels,
        'menu_icon' => 'dashicons-id-alt',
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_rest' => false,
        'query_var' => true,
        'rewrite' => array( 'slug' => 'lp' ),
        'capability_type' => 'page',
        'capabilities' => array(
            'edit_post' => 'edit_others_posts',
            'read_post' => 'edit_others_posts',
            'delete_post' => 'edit_others_posts',
            'edit_posts' => 'edit_others_posts',
            'edit_others_posts' => 'edit_others_posts',
            'publish_posts' => 'edit_others_posts',
            'read_private_posts' => 'edit_others_posts',
        ),
        'exclude_from_search' => true,
        'hierarchical' => false,
        'menu_position' => null,
        'supports' => array()
    );
    if ( $license_key !== '' && $license_type !== '' ) {
        register_post_type( 'lp', $args );
    }
}
add_action( 'after_switch_theme', 'lp_rewrite_flush' );
function lp_rewrite_flush() {
    flush_rewrite_rules();
}

/*
 * フォームコンテンツ
*/
add_action( 'edit_form_after_title', 'dg_style_lp_editor' );
function dg_style_lp_editor() {
    global $post;
    if ( $post->post_type !== 'lp' ) {
        return false;
    }
    $post_id = $post->ID;
    $summary = array( 'page_type' => 'lp', 'site_design' => $post_id, 'current_device' => 'sp', 'device_option' => '', 'device' => array( 320 => 'sp', 560 => 'tb', 960 => 'pc' ), );
    echo site_builder_page_content( $summary );
}

/*
 * LP編集ヘッダーメニュー
*/
function site_builder_lp_header_menu( $post_id, $page_list ) {
    //定義
    $admin_url = admin_url();
    $home_url = home_url();
    $post = get_post( $post_id );
    $post_title = $post->post_title;
    $post_name = $post->post_name;
    $status_option = '';
    $status = array(
        'draft' => __( '下書き', 'dg-style' ),
        'pending' => __( 'レビュー待ち', 'dg-style' ),
        'publish' => __( '公開', 'dg-style' ),
        'private' => __( '非公開', 'dg-style' ),
    );
    foreach( (array)$status as $key => $name ) {
        $selected = '';
        if ( $key === $post->post_status ) {
            $selected = ' selected';
        }
        $status_option .= '<option value="' . $key . '"' . $selected . '>' . $name . '</option>';
    }
    //翻訳
    $text_save_btn_title = __( '変更を保存', 'dg-style' );
    $text_save_btn = __( '保存', 'dg-style' );
    $text_page_type_select_title = __( '指定ページに移動', 'dg-style' );
    $text_release_panel_title = __( '現在デザインで公開する', 'dg-style' );
    $text_release_panel_status = __( '公開中', 'dg-style' );
    $text_select_panel_title = __( '編集中のデザイン名', 'dg-style' );
    $text_select_panel_status = __( '編集中', 'dg-style' );
    $text_comparison_select_btn_title = __( '現在公開しているデザインと編集中のデザインを比較する', 'dg-style' );
    $text_comparison_select_btn = __( '公開デザインと比較', 'dg-style' );
    $text_hide_btn_title = __( '各ボタンを非表示にする', 'dg-style' );
    $text_hide_btn = __( 'ボタン非表示', 'dg-style' );
    $text_close_btn_title = __( '一覧ページに戻る', 'dg-style' );
    $text_lp_title = __( 'LPタイトルを入力', 'dg-style' );
    $text_lp_url = __( 'LP urlを入力', 'dg-style' );
    $text_lp_url_caution = __( '404ページになる場合は保存してください', 'dg-style' );
    $text_design_select_btn_title = __( '作成したLPリストを表示', 'dg-style' );
    $text_design_select_btn = __( 'LP複製', 'dg-style' );
    $text_template_select_btn_title = __( 'LPテンプレートリストを表示', 'dg-style' );
    $text_template_select_btn = __( 'テンプレート', 'dg-style' );
    $text_lp_design_placeholder = __( 'LP名入力', 'dg-style' );
    $text_lp_design_caution = __( '作成したLPを検索してをデザインをコピーすることができます。', 'dg-style' );
    return <<< EOM
        <div id="lp-header" class="header-menu-list">
            <button type="button" id="site-design-save-btn" class="site-builder-save-btn close-pass" title="{$text_save_btn_title}">{$text_save_btn}</button>
            <select id="post-status">{$status_option}</select>
            <div class="lp-title-area">
                <input type="text" name="lp-title" id="lp-title" value="{$post_title}" placeholder="{$text_lp_title}">
            </div>
            <div class="lp-url-area">
                <span id="lp-home-url" class="lp-url-text">{$home_url}/lp/</span>
                <input type="text" name="lp-url" id="lp-url" value="{$post_name}" placeholder="{$text_lp_url}">
                <a id="open-lp-url" href="{$home_url}/lp/{$post_name}" target="_blank" title="{$text_lp_url_caution}"></a>
            </div>
            <button type="button" id="release-design-panel" class="release-design design-status-area select" title="{$text_release_panel_title}">
                <span class="status-type">{$text_release_panel_status}</span>
                <span id="current-design-name" class="design-name">{$post_id}</span>
            </button>
            <div id="select-design-panel" class="select-design design-status-area" title="{$text_select_panel_title}">
                <span class="status-type">{$text_select_panel_status}</span>
                <span id="selected-design-name" class="design-name">{$post_id}</span>
            </div>
            <button type="button" id="site-design-menu-btn" class="design-select-btn" title="{$text_design_select_btn_title}">{$text_design_select_btn}</button>
            <button type="button" id="template-design-menu-btn" class="template-select-btn" title="{$text_template_select_btn_title}">{$text_template_select_btn}</button>
            <button type="button" id="site-design-comparison-btn" class="design-comparison-btn" title="{$text_comparison_select_btn_title}">{$text_comparison_select_btn}</button>
            <button type="button" id="hide-setting-btns" title="{$text_hide_btn_title}">{$text_hide_btn}</button>
        </div>
        <a id="page-close-btn" class="back-wp-admin-btn close-pass" href="{$admin_url}edit.php?post_type=lp" title="{$text_close_btn_title}"></a>
        <div id="site-design-list" class="lp-search-area">
            <div class="lp-search-form">
                <input type="text" id="lp-search-input" placeholder="{$text_lp_design_placeholder}">
                <button type="button" id="lp-search-submit"></button>
            </div>
            <div class="lp-design-caution">※{$text_lp_design_caution}</div>
            <div id="lp-search-result"></div>
        </div>
        <div id="site-template-list">
            <div id="site-template-labels" class="site-template-labels"></div>
            <div id="select-template-list"></div>
            <input type="hidden" id="template-site-design-value">
        </div>
EOM;
}

add_action( 'wp_ajax_get_lp_design_list', 'get_lp_design_list' );
add_action( 'wp_ajax_nopriv_get_lp_design_list', 'get_lp_design_list' );
function get_lp_design_list() {
    $result = array();
    if ( isset( $_POST[ 'title' ] ) && $_POST[ 'title' ] !== '' && isset( $_POST[ 'id' ] ) && $_POST[ 'id' ] !== '' && is_numeric( $_POST[ 'id' ] ) ) {
        $args = array(
            'post_type' => array( 'lp' ),
            'post_status' => 'any',
            'posts_per_page' => -1,
            's' => $_POST[ 'title' ],
            'post__not_in' => array( $_POST[ 'id' ] )
        );
        $wp_query = new WP_Query( $args );
        if ( $wp_query->have_posts() ) {
            while ( $wp_query->have_posts() ) {
                $wp_query->the_post();
                $result[] = array(
                    'title' => $wp_query->post->post_title,
                    'id' => $wp_query->post->ID,
                );
            }
            wp_reset_postdata();
        }
    }
    echo json_encode( array( 'result' => $result ) );
    exit();
}