<?php
function site_builder_option_script() {
    $site_update_time = date( 'YmdHis' );
    $directory_url = get_template_directory_uri();
    wp_register_style( 'dg_option_css', $directory_url . '/wp-admin/option-page/option_page.css?ver=' . $site_update_time );
    wp_enqueue_style( 'dg_option_css' );
    wp_enqueue_media();
    wp_enqueue_script( 'media-upload' );
    $wp_js = array( 'jquery', 'wp-i18n', );
    wp_enqueue_script( 'site_builder_js', $directory_url . '/wp-admin/option-page/option-admin.js', $wp_js, $site_update_time, true );
    //JS翻訳スクリプト追加
    wp_set_script_translations( 'site_builder_js', 'dg-style', get_template_directory() . '/languages' );
}

/*
 * オプションページ設定
*/
function site_builder_option_page() {
    $page_list = get_page_types( true );
    option_page_save_scripts( $page_list );
    $script_option = option_page_site_script( $page_list );
    $meta_option = option_page_meta_option( $page_list );
    $page_option = option_page_taxonomy_page_setting( $page_list );
    
    //翻訳
    $text_menu_title = __( 'サイトオプション', 'dg-style' );
    $text_menu_tab1 = __( '共通オプション', 'dg-style' );
    $text_menu_tab2 = __( 'METAオプション', 'dg-style' );
    $text_menu_tab3 = __( 'ページ設定', 'dg-style' );
    $text_save = __( '保存', 'dg-style' );
    echo <<< EOM
        <div class="site-builder-option-page">
            <h1 class="option-title">{$text_menu_title}</h1>
            <form class="options-list" method="post">
                <div class="tab-inner option-tab-inner">
                    <div class="tab-list option-labels">
                        <button type="button" class="tab-label option-label on">{$text_menu_tab1}</button>
                        <button type="button" class="tab-label option-label">{$text_menu_tab2}</button>
                        <button type="button" class="tab-label option-label">{$text_menu_tab3}</button>
                    </div>
                    <div class="tab-contents option-contents option-tab-contents">
                        <div class="tab-content on">{$script_option}</div>
                        <div class="tab-content">{$meta_option}</div>
                        <div class="tab-content">{$page_option}</div>
                    </div>
                </div>
                <div class="save-btn-area"><button type="submit" class="save-btn" name="save-option" value="1">{$text_save}</button></div>
            </form>
        </div>
EOM;
}

/*
 * ライセンス種類取得
*/
function get_dg_style_license_type( $key ) {
    $home_url = home_url();
    $response = wp_remote_post( 'https://member.dg-style.net/check.php', array(
            'method' => 'POST',
            'timeout' => 45,
            'redirection' => 5,
            'httpversion' => '1.0',
            'blocking' => true,
            'headers' => array(),
            'body' => array(
                'type' => 'type',
                'api_key' => $key,
                'home_url' => $home_url,
            ),
        )
    );
    if ( is_wp_error( $response ) ) {
        return false;
    }
    $result = json_decode( $response[ 'body' ], true );
    if ( $result !== false ) {
        update_option( 'DG_license_type', $result );
        return $result;
    }
    return false;
}

function option_page_save_scripts( $page_list ) {
    $scripts = get_option( 'DG_script_option' );
    if ( $scripts !== false ) {
        $scripts = json_decode( $scripts, true );
    } else {
        $scripts = array();
    }
    //ライセンス
    $license_key = get_option( 'DG_license_key', '' );
    $license_type = get_option( 'DG_license_type', '' );
    //保存
    if ( isset( $_POST[ 'save-option' ] ) ) {
        $script_types = array( 'google-tagmanager' => 'tagmanager', 'noscript' => 'noscript', 'yahoo-tagmanager' => 'yahoo', 'other-script' => 'other' );
        foreach( (array)$script_types as $type => $name ) {
            if ( isset( $_POST[ $type ] ) ) {
                $scripts[ $name ] = $_POST[ $type ];
            } else {
                $scripts[ $name ] = '';
            }
        }
        $preconnect_types = array( 'preconnect-double' => 'pre-dns', 'preconnect' => 'preconnect', 'dns-prefetch' => 'dns', );
        foreach( (array)$preconnect_types as $type => $name ) {
            if ( isset( $_POST[ $type ] ) ) {
                if ( $_POST[ $type ] !== '' ) {
                    $preconnect = explode( "\n", $_POST[ $type ] );
                    $preconnect = array_map( 'trim', $preconnect );
                    $preconnect = array_filter( $preconnect, 'strlen' );
                    $preconnect = array_values( $preconnect );
                } else {
                    $preconnect = false;
                }
                $scripts[ $name ] = $preconnect;
            }
        }
        //recapcha
        if ( isset( $_POST[ 'recaptcha_site' ] ) && isset( $_POST[ 'recaptcha_secret' ] ) ) {
            $scripts[ 'recaptcha' ] = array(
                'site' => $_POST[ 'recaptcha_site' ],
                'secret' => $_POST[ 'recaptcha_secret' ],
            );
        }
        // ページ別設定
        $update_posts_per_page = 1000;
        $recaptcha_flg = false;
        foreach( (array)$page_list as $key => $value ) {
            if ( $key === 'top' ) {
                if ( isset( $_POST[ 'recaptcha-page-' . $key ] ) && $_POST[ 'recaptcha-page-' . $key ] !== '' ) {
                    $recaptcha_flg = true;
                    $scripts[ 'recaptcha' ][ 'page' ][ $key ] = $_POST[ 'recaptcha-page-' . $key ];
                }
                
                // 表示数
                if ( isset( $_POST[ 'top-count' ] ) && $_POST[ 'top-count' ] !== '' ) {
                    $scripts[ 'page-setting' ][ 'top' ][ 'order-option' ][ 'count' ] = $_POST[ 'top-count' ];
                    if ( $update_posts_per_page > (int)$_POST[ 'top-count' ] ) {
                        $update_posts_per_page = (int)$_POST[ 'top-count' ];
                    }
                } else {
                    unset( $scripts[ 'page-setting' ][ 'top' ][ 'order-option' ][ 'count' ] );
                }
                if ( isset( $_POST[ 'top-orderby' ] ) ) {
                    $scripts[ 'page-setting' ][ 'top' ][ 'order-option' ][ 'orderby' ] = $_POST[ 'top-orderby' ];
                }
                if ( isset( $_POST[ 'top-order' ] ) ) {
                    $scripts[ 'page-setting' ][ 'top' ][ 'order-option' ][ 'order' ] = $_POST[ 'top-order' ];
                }
            } else {
                foreach( (array)$value as $slug => $name ) {
                    $page_slug = $key . '-' . $slug;
                    if ( $key === 'other' || ( $key === 'taxonomy' && $slug === 'date' ) ) {
                        if ( isset( $_POST[ 'recaptcha-page-' . $slug ] ) && $_POST[ 'recaptcha-page-' . $slug ] !== '' ) {
                            $recaptcha_flg = true;
                            $scripts[ 'recaptcha' ][ 'page' ][ $slug ] = $_POST[ 'recaptcha-page-' . $slug ];
                        }
                    } else {
                        if ( isset( $_POST[ 'recaptcha-page-' . $slug . '-flg' ] ) && $_POST[ 'recaptcha-page-' . $slug . '-flg' ] !== '' ) {
                            $recaptcha_flg = true;
                            if ( isset( $_POST[ 'recaptcha-page-' . $slug ] ) && $_POST[ 'recaptcha-page-' . $slug ] !== '' ) {
                                $scripts[ 'recaptcha' ][ 'page' ][ $slug ] = $_POST[ 'recaptcha-page-' . $slug ];
                            } else {
                                $scripts[ 'recaptcha' ][ 'page' ][ $slug ] = '';
                            }
                        }
                    }
                    // 表示数
                    if ( $key !== 'single' ) {
                        // 表示数
                        if ( isset( $_POST[ $page_slug . '-count' ] ) && $_POST[ $page_slug . '-count' ] !== '' ) {
                            $scripts[ 'page-setting' ][ $page_slug ][ 'order-option' ][ 'count' ] = $_POST[ $page_slug . '-count' ];
                            if ( $update_posts_per_page > (int)$_POST[ $page_slug . '-count' ] ) {
                                $update_posts_per_page = (int)$_POST[ $page_slug . '-count' ];
                            }
                        } else {
                            unset( $scripts[ 'page-setting' ][ $page_slug ][ 'order-option' ][ 'count' ] );
                        }
                        if ( isset( $_POST[ $page_slug . '-orderby' ] ) ) {
                            $scripts[ 'page-setting' ][ $page_slug ][ 'order-option' ][ 'orderby' ] = $_POST[ $page_slug . '-orderby' ];
                        }
                        if ( isset( $_POST[ $page_slug . '-order' ] ) ) {
                            $scripts[ 'page-setting' ][ $page_slug ][ 'order-option' ][ 'order' ] = $_POST[ $page_slug . '-order' ];
                        }
                    }
                }
            }
        }
        // 表示数がposts_per_pageより少ない場合、一番少ない表示数に変更（一覧ページページングURLの404対策）
        $posts_per_page = (int)get_option( 'posts_per_page' );
        if ( $update_posts_per_page !== $posts_per_page ) {
            update_option( 'posts_per_page', $update_posts_per_page );
        }
    
        //recaptchaページ設定がない場合は削除
        if ( $recaptcha_flg === false ) {
            unset( $scripts[ 'recaptcha' ][ 'page' ] );
        }
        
        $update_scripts = json_encode( $scripts );
        update_option( 'DG_script_option', $update_scripts );
        
        //テストデザイン用保存
        $ng_keys = array( 'css_path', 'critical', 'js_path', 'font', 'manifest', 'pwa', 'preload', 'pwa_theme', 'device', 'site_update', 'stylesheet_url', 'site_name', 'site_url', 'home_url', 'ajax_url', 'locale', );
        $DG_abtest_designs = get_option( 'DG_abtest_designs', '' );
        if ( $DG_abtest_designs !== '' ) {
            $DG_abtest_designs = json_decode( $DG_abtest_designs, true );
            if ( is_array( $DG_abtest_designs ) && count( $DG_abtest_designs ) > 0 ) {
                foreach( (array)$DG_abtest_designs as $design_name => $test_id ) {
                    $test_scripts = get_option( 'DG_script_option' . $test_id );
                    if ( $test_scripts !== false ) {
                        $test_scripts = json_decode( $test_scripts, true );
                    } else {
                        $test_scripts = array();
                    }
                    foreach( (array)$scripts as $sc_key => $sc_value ) {
                        if ( !in_array( $sc_key, $ng_keys, true ) ) {
                            $test_scripts[ $sc_key ] = $sc_value;
                        }
                    }
                    if ( $recaptcha_flg === false ) {
                        unset( $test_scripts[ 'recaptcha' ][ 'page' ] );
                    }
                    $update_test_scripts = json_encode( $test_scripts );
                    update_option( 'DG_script_option' . $test_id, $update_test_scripts );
                    
                }
            }
        }
        //LP用保存
        $args = array(
            'post_type' => array( 'lp' ),
            'post_status' => 'publish',
            'posts_per_page' => -1,
        );
        $wp_query = new WP_Query( $args );
        if ( $wp_query->have_posts() ) {
            while ( $wp_query->have_posts() ) {
                $wp_query->the_post();
                $lp_scripts = get_post_meta( $wp_query->post->ID, 'DG_script_option', true );
                if ( $lp_scripts !== '' ) {
                    $lp_scripts = json_decode( $lp_scripts, true );
                } else {
                    $lp_scripts = array();
                }
                foreach( (array)$scripts as $sc_key => $sc_value ) {
                    if ( !in_array( $sc_key, $ng_keys, true ) ) {
                        $lp_scripts[ $sc_key ] = $sc_value;
                    }
                }
                if ( $recaptcha_flg === false ) {
                    unset( $lp_scripts[ 'recaptcha' ][ 'page' ] );
                }
                $update_lp_scripts = wp_slash( json_encode( $lp_scripts ) );
                update_post_meta( $wp_query->post->ID, 'DG_script_option', $update_lp_scripts );
            }
            wp_reset_postdata();
        }
        
        if ( isset( $_POST[ 'site_display' ] ) ) {
            update_option( 'DG_display_flg', $_POST[ 'site_display' ] );
        }
        if ( isset( $_POST[ 'login_style_css' ] ) ) {
            update_option( 'DG_login_style_flg', $_POST[ 'login_style_css' ] );
        }
        if ( isset( $_POST[ 'ab_test_auto' ] ) ) {
            update_option( 'DG_abtest_auto', $_POST[ 'ab_test_auto' ] );
        }
        if ( $license_key === '' && $license_type === '' && isset( $_POST[ 'license_key' ] ) ) {
            $license_type = get_dg_style_license_type( $_POST[ 'license_key' ] );
            if ( $license_type !== false ) {
                update_option( 'DG_license_key', $_POST[ 'license_key' ] );
                $license_key = $_POST[ 'license_key' ];
            }
        }
    }
}

/*
 * METAオプション
*/
function option_page_site_script( $page_list ) {
    //ライセンス
    $license_key = get_option( 'DG_license_key', '' );
    $license_type = get_option( 'DG_license_type', '' );
    $scripts = get_option( 'DG_script_option' );
    if ( $scripts !== false ) {
        $scripts = json_decode( $scripts, true );
    } else {
        $scripts = array();
    }
    //スクリプト関連呼び出し
    $tagmanager = '';
    $other_script = '';
    $noscript = '';
    $yahoo_tagmanager = '';
    $preconnect_double = '';
    $preconnect = '';
    $dns_prefetch = '';
    $recaptcha_site = isset( $scripts[ 'recaptcha' ][ 'site' ] ) ? $scripts[ 'recaptcha' ][ 'site' ] : '';
    $recaptcha_secret = isset( $scripts[ 'recaptcha' ][ 'secret' ] ) ? $scripts[ 'recaptcha' ][ 'secret' ] : '';
    if ( isset( $scripts[ 'tagmanager' ] ) ) {
        $tagmanager = wp_unslash( $scripts[ 'tagmanager' ] );
    }
    if ( isset( $scripts[ 'yahoo' ] ) ) {
        $yahoo_tagmanager = wp_unslash( $scripts[ 'yahoo' ] );
    }
    if ( isset( $scripts[ 'noscript' ] ) ) {
        $noscript = wp_unslash( $scripts[ 'noscript' ] );
    }
    if ( isset( $scripts[ 'other' ] ) ) {
        $other_script = wp_unslash( $scripts[ 'other' ] );
    }
    if ( isset( $scripts[ 'pre-dns' ] ) && $scripts[ 'pre-dns' ] !== false ) {
        $preconnect_double = implode( PHP_EOL, $scripts[ 'pre-dns' ] );
    }
    if ( isset( $scripts[ 'preconnect' ] ) && $scripts[ 'preconnect' ] !== false ) {
        $preconnect = implode( PHP_EOL, $scripts[ 'preconnect' ] );
    }
    if ( isset( $scripts[ 'dns' ] ) && $scripts[ 'dns' ] !== false ) {
        $dns_prefetch = implode( PHP_EOL, $scripts[ 'dns' ] );
    }
    //サイト表示
    $php_check = ' checked';
    $spa_check = '';
    $site_display = get_option( 'DG_display_flg', '1' );
    if ( $site_display === '2' ) {
        $php_check = '';
        $spa_check = ' checked';
    }
    
    //サイト表示
    $login_on_check = ' checked';
    $login_off_check = '';
    $login_style = get_option( 'DG_login_style_flg', '1' );
    if ( $login_style === '2' ) {
        $login_on_check = '';
        $login_off_check = ' checked';
    }
    //ABテスト自動表示
    $abauto_on_check = '';
    $abauto_off_check = ' checked';
    $abtest_auto = get_option( 'DG_abtest_auto', '2' );
    if ( $abtest_auto === '1' ) {
        $abauto_on_check = ' checked';
        $abauto_off_check = '';
    }
    //ライセンス
    $license_text = __( 'ライセンスキー登録をしないとサイト公開ができませんので、ご注意ください。', 'dg-style' );
    $license_disabled = '';
    if ( $license_key !== '' && ( $license_type === 'pro' || $license_type === 'standard' || $license_type === 'acting' ) ) {
        $license_disabled = ' disabled';
        if ( $license_type === 'pro' ) {
            $license = __( 'プロ（無制限）', 'dg-style' );
        } elseif ( $license_type === 'standard' ) {
            $license = __( 'スタンダード（3ドメイン）', 'dg-style' );
        } elseif ( $license_type === 'acting' ) {
            $license = __( '代行（1ドメイン）', 'dg-style' );
        }
        $license_text = __( '「DG-STYLE」テーマライセンスは', 'dg-style' ) . '「<strong class="license">' . $license . '</strong>」' . __( 'になります。', 'dg-style' );
        //最初にライセンスキー登録時にデフォルトのデザインを公開する
        if ( isset( $_POST[ 'license_key' ] ) && $_POST[ 'license_key' ] !== '' ) {
            first_dg_style_design_setting();
        }
    } elseif ( isset( $_POST[ 'license_key' ] ) && $_POST[ 'license_key' ] !== '' ) {
        $license_text = __( 'ライセンスキーが登録ドメイン数の上限を超えている（スタンダード／代行ライセンス）もしくは無効になっています。<br>詳細についてはお問い合わせください。サイトビルダーページの右下のボタンよりお問い合わせできます。', 'dg-style' );
    }
    
    //recaptchaページ指定
    $text_recaptcha_placeholder = __( 'ページタイトルで検索', 'dg-style' );
    $recaptcha_page_select = '';
    foreach( (array)$page_list as $key => $value ) {
        if ( $key === 'top' ) {
            $checked = isset( $scripts[ 'recaptcha' ][ 'page' ][ $key ] ) && $scripts[ 'recaptcha' ][ 'page' ][ $key ] === '1' ? ' checked' : '';
            $recaptcha_page_select .= '<div class="recaptcha-page-item"><label class="recaptcha-page-label"><input type="checkbox" name="recaptcha-page-' . $key . '" value="1"' . $checked . '>' . $value . '</label></div>';
        } else {
            if ( $key !== 'other' ) {
                $recaptcha_page_select .= '<div class="recaptcha-page-inner">';
            }
            foreach( (array)$value as $slug => $name ) {
                if ( $key === 'other' ) {
                    $checked = isset( $scripts[ 'recaptcha' ][ 'page' ][ $slug ] ) && $scripts[ 'recaptcha' ][ 'page' ][ $slug ] === '1' ? ' checked' : '';
                    $recaptcha_page_select .= '<div class="recaptcha-page-item"><label class="recaptcha-page-label"><input type="checkbox" name="recaptcha-page-' . $slug . '" value="1"' . $checked . '>' . $name . '</label></div>';
                } elseif ( $key === 'taxonomy' && $slug === 'date' ) {
                    $checked = isset( $scripts[ 'recaptcha' ][ 'page' ][ $slug ] ) && $scripts[ 'recaptcha' ][ 'page' ][ $slug ] === '1' ? ' checked' : '';
                    $recaptcha_page_select .= '<div class="recaptcha-page-item"><label class="recaptcha-page-label"><input type="checkbox" name="recaptcha-page-' . $slug . '" value="1"' . $checked . '>' . $name . '</label></div>';
                } else {
                    $checked = isset( $scripts[ 'recaptcha' ][ 'page' ][ $slug ] ) ? ' checked' : '';
                    $select_page = '';
                    if ( isset( $scripts[ 'recaptcha' ][ 'page' ][ $slug ] ) && $scripts[ 'recaptcha' ][ 'page' ][ $slug ] !== '' ) {
                        $page_ids = explode( ',', $scripts[ 'recaptcha' ][ 'page' ][ $slug ] );
                        if ( $key === 'single' ) {
                            $args = array(
                                'post_type' => $slug,
                                'orderby' => 'date',
                                'order' => 'DESC',
                                'posts_per_page' => -1,
                                'post__in' => $page_ids,
                            );
                            $query = new WP_Query( $args );
                            if ( $query->have_posts() ) {
                                while ( $query->have_posts() ) {
                                    $query->the_post();
                                    $post = $query->post;
                                    $select_page .= '<div class="page-item">' . $post->post_title . '<button type="button" class="page-delete-btn" value="' . $post->ID . '" data-level="' . $slug . '"></button></div>';
                                }
                                wp_reset_postdata();
                            }
                        } else {
                            $child = get_terms( $slug, array( 'include' => $page_ids, 'hide_empty' => false ) ) ;
                            if ( is_array( $child ) && count( $child ) > 0 && !is_wp_error( $child ) ) {
                                foreach ( $child as $child_term ) {
                                    $select_page .= '<div class="page-item">' . $child_term->name . '<button type="button" class="page-delete-btn" value="' . $child_term->term_id . '" data-level="' . $slug . '"></button></div>';
                                }
                            }
                        }
                    }
                    $recaptcha_value = isset( $scripts[ 'recaptcha' ][ 'page' ][ $slug ] ) ? $scripts[ 'recaptcha' ][ 'page' ][ $slug ] : '';
                    if ( $key === 'taxonomy' ) {
                        $recaptcha_page_select .= <<< EOM
                            <div class="recaptcha-page-search recaptcha-page-item">
                                <div class="recaptcha-search-header">
                                    <div class="recaptcha-page-title"><label class="recaptcha-page-label"><input type="checkbox" name="recaptcha-page-{$slug}-flg" value="1"{$checked}>{$name}</label></div>
                                    <input type="text" class="page-search-input" data-level="{$slug}" placeholder="{$text_recaptcha_placeholder}">
                                </div>
                                <div id="recaptcha-page-{$slug}-box" class="page-list-box">{$select_page}</div>
                                <input type="hidden" name="recaptcha-page-{$slug}" id="recaptcha-page-{$slug}" value="{$recaptcha_value}">
                            </div>
EOM;
                    } else {
                        $recaptcha_page_select .= <<< EOM
                            <div class="recaptcha-page-search recaptcha-page-item">
                                <div class="recaptcha-search-header">
                                    <div class="recaptcha-page-title"><label class="recaptcha-page-label"><input type="checkbox" name="recaptcha-page-{$slug}-flg" value="1"{$checked}>{$name}</label></div>
                                    <input type="text" class="page-search-input" data-level="post" data-page_type="{$slug}" placeholder="{$text_recaptcha_placeholder}">
                                </div>
                                <div id="recaptcha-page-{$slug}-box" class="page-list-box">{$select_page}</div>
                                <input type="hidden" name="recaptcha-page-{$slug}" id="recaptcha-page-{$slug}" value="{$recaptcha_value}">
                            </div>
EOM;
                    }
                }
            }
            if ( $key !== 'other' ) {
                $recaptcha_page_select .= '</div>';
            }
        }
    }
    //翻訳
    $text_menu_title = __( '「DG-STYLE」ライセンス登録', 'dg-style' );
    $text_menu1_title = __( '「DG-STYLE」API KEY入力', 'dg-style' );
    $text_menu2_title = __( 'スクリプト追加', 'dg-style' );
    $text_menu2_option1 = __( '分析用スクリプト', 'dg-style' );
    $text_menu2_option2 = __( 'その他スクリプト', 'dg-style' );
    $text_menu2_option3 = __( 'Yahooスクリプト', 'dg-style' );
    $text_menu2_caution1 = __( 'Googleタグマネージャー、Googleアナリティクス', 'dg-style' );
    $text_menu2_caution2 = __( '直下、なるべく上に設置', 'dg-style' );
    $text_menu2_caution4 = __( 'の直後', 'dg-style' );
    $text_menu2_caution3 = __( 'の直前', 'dg-style' );
    $text_menu3_title = __( 'サイト表示オプション', 'dg-style' );
    $text_menu4_title = __( 'SPAサイト', 'dg-style' );
    $text_menu7_title = __( 'ABテストランダム表示', 'dg-style' );
    $text_menu4_option1 = __( '通常表示', 'dg-style' );
    $text_menu4_option2 = __( 'SPAにする', 'dg-style' );
    $text_menu4_caution = __( 'SPAの場合はPWAは利用できません。', 'dg-style' );
    $text_menu5_title = __( 'ログインページデザイン反映', 'dg-style' );
    $text_menu5_option1 = __( '使用する', 'dg-style' );
    $text_menu5_option2 = __( '使用しない', 'dg-style' );
    $text_menu6_title = __( '事前接続', 'dg-style' );
    $text_menu6_caution = __( '改行で区切ります。', 'dg-style' );
    $text_recaptcha_site_key = __( 'サイトキー', 'dg-style' );
    $text_recaptcha_secret = __( 'シークレットキー', 'dg-style' );
    $text_recaptcha_page = __( 'reCAPTCHA ページ設定', 'dg-style' );
    $text_recaptcha_page_caution1 = __( 'reCAPTCHAスクリプトを表示するページを選択します。', 'dg-style' );
    $text_recaptcha_page_caution2 = __( '空欄の場合は全ページに表示されます。', 'dg-style' );
    $text_recaptcha_page_caution3 = __( 'からサイトキー・シクレットキーを発行できます。', 'dg-style' );
    return <<< EOM
        <h2 class="sub-title">{$text_menu_title}</h2>
        <table class="option-table">
            <tbody>
                <tr>
                    <th><label for="dg-style-license">{$text_menu1_title}</label></th>
                    <td><p class="license-text">{$license_text}</p><input type="text" id="dg-style-license" name="license_key" value="{$license_key}"{$license_disabled}></td>
                </tr>
            </tbody>
        </table>
        <h2 class="sub-title">{$text_menu2_title}</h2>
        <table class="option-table">
            <tbody>
                <tr>
                    <th><label for="google-tagmanager">{$text_menu2_option1}</label><p class="caution">（{$text_menu2_caution1}）<br>&lt;head&gt;{$text_menu2_caution2}</p></th>
                    <td><textarea id="google-tagmanager" name="google-tagmanager" rows="10">{$tagmanager}</textarea></td>
                </tr>
                <tr>
                    <th><label for="other-script">{$text_menu2_option2}</label><p class="caution">&lt;/head&gt;{$text_menu2_caution3}</p></th>
                    <td><textarea id="other-script" name="other-script" rows="15">{$other_script}</textarea></td>
                </tr>
                <tr>
                    <th><label for="yahoo-tagmanager">noscript</label><p class="caution">&lt;body&gt;{$text_menu2_caution4}</p></th>
                    <td><textarea id="noscript" name="noscript" rows="10">{$noscript}</textarea></td>
                </tr>
                <tr>
                    <th><label for="yahoo-tagmanager">{$text_menu2_option3}</label><p class="caution">&lt;/body&gt;{$text_menu2_caution3}</p></th>
                    <td><textarea id="yahoo-tagmanager" name="yahoo-tagmanager" rows="10">{$yahoo_tagmanager}</textarea></td>
                </tr>
            </tbody>
        </table>
        <h2 class="sub-title">{$text_menu6_title}</h2>
        <table class="option-table">
            <tbody>
                <tr>
                    <th>
                        <label for="preconnect-double">preconnect dns-prefetch</label>
                        <div class="caution">※{$text_menu6_caution}</div>
                    </th>
                    <td><textarea id="preconnect-double" name="preconnect-double" rows="5">{$preconnect_double}</textarea></td>
                </tr>
                <tr>
                    <th>
                        <label for="preconnect">preconnect</label>
                        <div class="caution">※{$text_menu6_caution}</div>
                    </th>
                    <td><textarea id="preconnect" name="preconnect" rows="5">{$preconnect}</textarea></td>
                </tr>
                <tr>
                    <th>
                        <label for="dns-prefetch">dns-prefetch</label>
                        <div class="caution">※{$text_menu6_caution}</div>
                    </th>
                    <td><textarea id="dns-prefetch" name="dns-prefetch" rows="5">{$dns_prefetch}</textarea></td>
                </tr>
            </tbody>
        </table>
        <h2 class="sub-title">{$text_menu3_title}</h2>
        <table class="option-table">
            <tbody>
                <tr>
                    <th>{$text_menu4_title}</th>
                    <td>
                        <label class=""><input type="radio" name="site_display" value="1"{$php_check}><span class="text">{$text_menu4_option1}</span></label>
                        <label class=""><input type="radio" name="site_display" value="2"{$spa_check}><span class="text">{$text_menu4_option2}</span></label>
                        <p class="caution">※{$text_menu4_caution}</p>
                    </td>
                </tr>
                <tr>
                    <th>{$text_menu5_title}</th>
                    <td>
                        <label class=""><input type="radio" name="login_style_css" value="1"{$login_on_check}><span class="text">{$text_menu5_option1}</span></label>
                        <label class=""><input type="radio" name="login_style_css" value="2"{$login_off_check}><span class="text">{$text_menu5_option2}</span></label>
                    </td>
                </tr>
                <tr>
                    <th>{$text_menu7_title}</th>
                    <td>
                        <label class=""><input type="radio" name="ab_test_auto" value="1"{$abauto_on_check}><span class="text">{$text_menu5_option1}</span></label>
                        <label class=""><input type="radio" name="ab_test_auto" value="2"{$abauto_off_check}><span class="text">{$text_menu5_option2}</span></label>
                    </td>
                </tr>
            </tbody>
        </table>
        <h2 class="sub-title">Google reCAPTCHA v3</h2>
        <p class="">「<a href="https://www.google.com/recaptcha/admin" target="_blank">Google reCAPTCHA</a>」{$text_recaptcha_page_caution3}</p>
        <table class="option-table">
            <tbody>
                <tr>
                    <th>{$text_recaptcha_site_key}</th>
                    <td><input type="text" name="recaptcha_site" value="{$recaptcha_site}"></td>
                </tr>
                <tr>
                    <th>{$text_recaptcha_secret}</th>
                    <td><input type="text" name="recaptcha_secret" value="{$recaptcha_secret}"></td>
                </tr>
                <tr>
                    <th>
                        {$text_recaptcha_page}
                        <p class="caution">※{$text_recaptcha_page_caution1}<br>※{$text_recaptcha_page_caution2}</p>
                    </th>
                    <td><div class="recaptcha-script-area">{$recaptcha_page_select}</div></td>
                </tr>
            </tbody>
        </table>
EOM;
}

/*
 * METAオプション
*/
function option_page_meta_option( $page_list ) {
    //保存
    if ( isset( $_POST[ 'save-option' ] ) ) {
        $save_value = array();
        $save_value[ 'site-text' ] = isset( $_POST[ 'site-text' ] ) ? $_POST[ 'site-text' ] : '';
        $save_value[ 'top-title' ] = isset( $_POST[ 'top-title' ] ) ? $_POST[ 'top-title' ] : '';
        $save_value[ 'top-description' ] = isset( $_POST[ 'top-description' ] ) ? $_POST[ 'top-description' ] : '';
        $save_value[ 'top-noindex' ] = isset( $_POST[ 'top-noindex' ] ) ? $_POST[ 'top-noindex' ] : '';
        $save_value[ 'app_id' ] = isset( $_POST[ 'app_id' ] ) ? $_POST[ 'app_id' ] : '';
        $save_value[ 'twitter-card' ] = isset( $_POST[ 'twitter-card' ] ) ? $_POST[ 'twitter-card' ] : '';
        $save_value[ 'sns-default-image' ] = isset( $_POST[ 'sns-default-image' ] ) ? $_POST[ 'sns-default-image' ] : '';
        foreach( (array)$page_list as $key => $value ) {
            if ( $key !== 'top' ) {
                foreach( (array)$value as $slug => $name ) {
                    if ( $key === 'other' ) {
                        $input_name = $slug;
                    } else {
                        $input_name = $key . '-' . $slug;
                    }
                    if ( $slug === 'date' ) {
                        $save_value[ $input_name . '-year-title' ] = isset( $_POST[ $input_name . '-year-title' ] ) ? $_POST[ $input_name . '-year-title' ] : '';
                        $save_value[ $input_name . '-month-title' ] = isset( $_POST[ $input_name . '-month-title' ] ) ? $_POST[ $input_name . '-month-title' ] : '';
                        $save_value[ $input_name . '-day-title' ] = isset( $_POST[ $input_name . '-day-title' ] ) ? $_POST[ $input_name . '-day-title' ] : '';
                    } else {
                        $save_value[ $input_name . '-title' ] = isset( $_POST[ $input_name . '-title' ] ) ? $_POST[ $input_name . '-title' ] : '';
                    }
                    $save_value[ $input_name . '-noindex' ] = isset( $_POST[ $input_name . '-noindex' ] ) ? $_POST[ $input_name . '-noindex' ] : '';
                }
            }
        }
        update_option( 'DG_meta_option', json_encode( $save_value ) );
    }
    //値設定
    $meta_option_arr = array();
    $meta_option = get_option( 'DG_meta_option' );
    if ( $meta_option !== false ) {
        $meta_option_arr = json_decode( $meta_option, true );
    }
    $site_text = isset( $meta_option_arr[ 'site-text' ] ) ? $meta_option_arr[ 'site-text' ] : '';
    $top_title = isset( $meta_option_arr[ 'top-title' ] ) ? $meta_option_arr[ 'top-title' ] : '';
    $top_description = isset( $meta_option_arr[ 'top-description' ] ) ? $meta_option_arr[ 'top-description' ] : '';
    $page_list_option = '';
    $noindex_option = '';
    //翻訳
    $text_year = __( 'タイトル（年）', 'dg-style' );
    $text_month = __( 'タイトル（年月）', 'dg-style' );
    $text_day = __( 'タイトル（年月日）', 'dg-style' );
    $text_year_example = __( '[year]年', 'dg-style' );
    $text_month_example = __( '[year]年[month]月', 'dg-style' );
    $text_day_example = __( '[year]年[month]月[day]日', 'dg-style' );
    $text_page_title = __( 'タイトル', 'dg-style' );
    $text_noindex_title = __( 'ページのNo-Index', 'dg-style' );
    $text_page = __( 'ページ', 'dg-style' );
    foreach( (array)$page_list as $key => $value ) {
        if ( $key !== 'top' ) {
            $noindex_option .= '<th>' . $key . __( 'ページのNo-Index', 'dg-style' ) . '</th><td>';
            foreach( (array)$value as $slug => $name ) {
                if ( $key === 'other' ) {
                    $input_name = $slug;
                } else {
                    $input_name = $key . '-' . $slug;
                }
                $placeholder = '';
                if ( $slug === 'search' ) {
                    $placeholder = '[keyword]';
                } elseif ( $slug === 404 ) {
                    $placeholder = '自由入力';
                } else {
                    $placeholder = '[title]';
                }
                //noindex
                $checked = isset( $meta_option_arr[ $input_name . '-noindex' ] ) && $meta_option_arr[ $input_name . '-noindex' ] === '1' ? ' checked' : '';
                $noindex_option .= '<div class="mb10"><label class="check-label"><input type="checkbox" name="' . $input_name . '-noindex" value="1"' . $checked . '><span class="check-name">' . $slug . $text_page . '</span></label></div>';
                //title
                if ( $slug === 'date' ) {
                    $year_title = isset( $meta_option_arr[ $input_name . '-year-title' ] ) ? $meta_option_arr[ $input_name . '-year-title' ] : '';
                    $month_title = isset( $meta_option_arr[ $input_name . '-month-title' ] ) ? $meta_option_arr[ $input_name . '-month-title' ] : '';
                    $day_title = isset( $meta_option_arr[ $input_name . '-day-title' ] ) ? $meta_option_arr[ $input_name . '-day-title' ] : '';
                    $page_list_option .= <<< EOM
                        <tr>
                            <th><label for="{$input_name}-year-title-input">{$name}{$text_year}</label><br>[year]</th>
                            <td>
                                <input id="{$input_name}-year-title-input" type="text" name="{$input_name}-year-title" value="{$year_title}" placeholder="{$text_year_example} | [site-text]">
                            </td>
                        </tr>
                        <tr>
                            <th><label for="{$input_name}-month-title-input">{$name}{$text_month}</label><br>[year] [month]</th>
                            <td>
                                <input id="{$input_name}-month-title-input" type="text" name="{$input_name}-month-title" value="{$month_title}" placeholder="{$text_month_example} | [site-text]">
                            </td>
                        </tr>
                        <tr>
                            <th><label for="{$input_name}-day-title-input">{$name}{$text_day}</label><br>[year] [month] [day]</th>
                            <td>
                                <input id="{$input_name}-day-title-input" type="text" name="{$input_name}-day-title" value="{$day_title}" placeholder="{$text_day_example} | [site-text]">
                            </td>
                        </tr>
EOM;
                } else {
                    $page_title = isset( $meta_option_arr[ $input_name . '-title' ] ) ? $meta_option_arr[ $input_name . '-title' ] : '';
                    $page_list_option .= <<< EOM
                        <tr>
                            <th><label for="{$input_name}-title-input">{$name}{$text_page_title}</label><br>{$placeholder}</th>
                            <td>
                                <input id="{$input_name}-title-input" type="text" name="{$input_name}-title" value="{$page_title}" placeholder="{$placeholder} | [site-text]">
                            </td>
                        </tr>
EOM;
                }
            }
            $noindex_option .= '</td></tr>';
        } else {
            $checked = isset( $meta_option_arr[ 'top-noindex' ] ) && $meta_option_arr[ 'top-noindex' ] === '1' ? ' checked' : '';
            $noindex_option .= <<< EOM
                <tr>
                    <th>{$key}{$text_noindex_title}</th>
                    <td>
                        <label class="check-label"><input type="checkbox" name="{$key}-noindex" value="1"{$checked}><span class="check-name">{$key}{$text_page}</span></label>
                    </td>
                </tr>
EOM;
        }
    }
    
    //OGP設定
    $app_id = isset( $meta_option_arr[ 'app_id' ] ) && $meta_option_arr[ 'app_id' ] !== '' ? $meta_option_arr[ 'app_id' ] : '';
    $card_type_option = '';
    $card_type = array( 'summary', 'summary_large_image', 'app', 'player' );
    foreach( (array)$card_type as $type ) {
        $selected = '';
        if ( $type === 'summary' && ( !isset( $meta_option_arr[ 'twitter-card' ] ) || ( isset( $meta_option_arr[ 'twitter-card' ] ) && $meta_option_arr[ 'twitter-card' ] === '' ) ) ) {
            $selected = ' selected';
        } elseif ( isset( $meta_option_arr[ 'twitter-card' ] ) && $type === $meta_option_arr[ 'twitter-card' ] ) {
            $selected = ' selected';
        }
        $card_type_option .= '<option value="' . $type . '"' . $selected . '>' . $type . '</option>';
    }
    //イメージ関連
    $text_image_delete = __( '削除', 'dg-style' );
    $wp_sns_image = '<a href="#" class="sns-default-image-upload-btn ui-btn">' . __( 'イメージ選択', 'dg-style' ) . '</a><a class="sns-default-image-remove-btn ui-btn">' . $text_image_delete . '</a>';
    $url_sns_image = '';
    $url_bg_value = '';
    $wp_bg_check = ' checked';
    $url_bg_check = '';
    $wp_bg_on = ' on';
    $url_bg_on = '';
    $sns_default_value = '';
    if ( isset( $meta_option_arr[ 'sns-default-image' ] ) && $meta_option_arr[ 'sns-default-image' ] !== '' ) {
        $sns_image_arr = json_decode( wp_unslash( $meta_option_arr[ 'sns-default-image' ] ), true );
        if ( isset( $sns_image_arr[ 'type' ] ) && $sns_image_arr[ 'type' ] === '2' ) {
            $url_sns_image = '<img src="' . $sns_image_arr[ 'value' ] . '">';
            $url_bg_value = $sns_image_arr[ 'value' ];
            $url_bg_check = ' checked';
            $url_bg_on = ' on';
            $wp_bg_check = '';
            $wp_bg_on = '';
        } elseif ( isset( $sns_image_arr[ 'type' ] ) && $sns_image_arr[ 'type' ] === '1' && isset( $sns_image_arr[ 'value' ] ) && $sns_image_arr[ 'value' ] !== '' ) {
            $thumb = wp_get_attachment_image_src( $sns_image_arr[ 'value' ], 'full' );
            $wp_sns_image = '<a href="#" class="sns-default-image-upload-btn"><img src="' . $thumb[ 0 ] . '"></a><a class="sns-default-image-remove-btn ui-btn on">' . $text_image_delete . '</a>';
        }
        $sns_default_value = htmlspecialchars( wp_unslash( $meta_option_arr[ 'sns-default-image' ] ), ENT_QUOTES, 'UTF-8' );
    }
    
    //翻訳
    $text_menu_title = __( 'TOPページMETA', 'dg-style' );
    $text_menu1_title = __( 'METAタイトル', 'dg-style' );
    $text_menu2_title = __( 'METAディスクリプション', 'dg-style' );
    $text_menu3_title = __( 'ページごとMETAタイトル設定', 'dg-style' );
    $text_menu4_title = __( '共通テキスト', 'dg-style' );
    $text_menu5_title = __( 'OGP設定（SNS用）', 'dg-style' );
    $text_menu6_title = __( 'デフォルトOGPイメージ', 'dg-style' );
    $text_menu7_title = __( 'カードタイプ', 'dg-style' );
    $text_menu8_title = __( 'NoIndex設定', 'dg-style' );
    $text_count = __( '文字数', 'dg-style' );
    $text_wp_image = __( 'WPイメージ', 'dg-style' );
    $text_image_url = __( 'イメージURL', 'dg-style' );
    
    return <<< EOM
        <h2 class="sub-title">{$text_menu_title}</h2>
        <table class="option-table">
            <tbody>
                <tr>
                    <th>
                        <label for="top-title-input">{$text_menu1_title}</label>
                        <div class="text-count">{$text_count}：<span id="top-title-count"></span></div>
                    </th>
                    <td>
                        <input id="top-title-input" type="text" name="top-title" value="{$top_title}" placeholder="{$text_page_title} | [site-text]">
                    </td>
                </tr>
                <tr>
                    <th>
                        <label for="top-description-input">{$text_menu2_title}</label>
                        <div class="text-count">{$text_count}：<span id="top-description-count"></span></div>
                    </th>
                    <td>
                        <textarea id="top-description-input" name="top-description" rows="4">{$top_description}</textarea>
                    </td>
                </tr>
            </tbody>
        </table>
        <h2 class="sub-title">{$text_menu3_title}</h2>
        <table class="option-table">
            <tbody>
                <tr>
                    <th><label for="site-text-input">{$text_menu4_title}</label><br>[site-text]</th>
                    <td>
                        <input id="site-text-input" type="text" name="site-text" value="{$site_text}">
                    </td>
                </tr>
                {$page_list_option}
            </tbody>
        </table>
        <h2 class="sub-title">{$text_menu5_title}</h2>
        <table class="option-table">
            <tbody>
                <tr>
                    <th>{$text_menu6_title}</th>
                    <td>
                        <div class="tab-inner image-select-tabs">
                            <div class="tab-list option-labels flex">
                                <label class="tab-label option-label{$wp_bg_on}"><input type="radio" name="sns-default-image-type" value="1" class="sns-default-image-input none-display"{$wp_bg_check}><span class="toggle-label">{$text_wp_image}</span></label>
                                <label class="tab-label option-label{$url_bg_on}"><input type="radio" name="sns-default-image-type" value="2" class="sns-default-image-input none-display"{$url_bg_check}><span class="toggle-label">{$text_image_url}</span></label>
                            </div>
                            <div class="tab-contents option-contents">
                                <div class="tab-content{$wp_bg_on}">
                                    <div class="image-box sns-default-image-wp-image">{$wp_sns_image}</div>
                                </div>
                                <div class="tab-content{$url_bg_on}">
                                    <div class="window-title">{$text_image_url}</div>
                                    <input type="text" class="sns-default-image-url-value image-url-value sns-default-image-url-input" value="{$url_bg_value}">
                                    <div class="image-simulator sns-default-image-url-simulator">{$url_sns_image}</div>
                                </div>
                            </div>
                            <input type="hidden" name="sns-default-image" id="sns-default-image" class="sns-default-image-image-input-value" value="{$sns_default_value}">
                        </div>
                    </td>
                </tr>
                <tr>
                    <th><label for="site-app_id-input">Facebook app_id</label></th>
                    <td>
                        <input id="site-app_id-input" type="text" name="app_id" value="{$app_id}">
                    </td>
                </tr>
                <tr>
                    <th><label for="site-app_id-input">Twitter {$text_menu7_title}</label></th>
                    <td>
                        <select name="twitter-card">{$card_type_option}</select>
                    </td>
                </tr>
            </tbody>
        </table>
        <h2 class="sub-title">{$text_menu8_title}</h2>
        <table class="option-table">
            <tbody>
                {$noindex_option}
            </tbody>
        </table>
EOM;
}

function option_page_taxonomy_page_setting( $page_list ) {
    $scripts = get_option( 'DG_script_option' );
    if ( $scripts !== false ) {
        $scripts = json_decode( $scripts, true );
    } else {
        $scripts = array();
    }
    // 翻訳
    $text_menu_title = __( '一覧ページ表示オプション', 'dg-style' );

    $posts_per_page = (int)get_option( 'posts_per_page' );
    $order_by = array( 'date' => __( '公開日', 'dg-style' ), 'modified' => __( '更新日', 'dg-style' ), 'views' => __( '人気順（全体）', 'dg-style' ), 'w_views' => __( '人気順（週間）', 'dg-style' ), 'm_views' => __( '人気順（月間）', 'dg-style' ), 'y_views' => __( '人気順（年間）', 'dg-style' ), 'evaluate' => __( '評価順', 'dg-style' ), 'bookmark' => __( 'ブックマーク数順', 'dg-style' ), 'comment_count' => __( 'コメント多い順', 'dg-style' ), 'author' => __( '作成者順', 'dg-style' ), 'rand' => __( 'ランダム', 'dg-style' ), 'title' => __( '記事タイトル', 'dg-style' ), );
    $order = array( 'DESC' => __( '降順（最新）', 'dg-style' ), 'ASC' => __( '昇順（古い）', 'dg-style' ), );
    $page_table = '';
    foreach( (array)$page_list as $key => $value ) {
        if ( $key !== 'single' ) {
            if ( $key !== 'top' ) {
                $page = '';
                foreach( (array)$value as $slug => $name ) {
                    if ( ( (string)$slug !== '404' && $key === 'other' ) || $key !== 'other' ) {
                        $page_data = isset( $scripts[ 'page-setting' ][ $key . '-' . $slug ][ 'order-option' ] ) ? $scripts[ 'page-setting' ][ $key . '-' . $slug ][ 'order-option' ] : array();
                        $count = isset( $page_data[ 'count' ] ) ? $page_data[ 'count' ] : $posts_per_page;
                        $order_by_option = '';
                        $order_option = '';
                        foreach( (array)$order_by as $order_key => $order_name ) {
                            $selected = '';
                            if ( isset( $page_data[ 'orderby' ] ) && $page_data[ 'orderby' ] === $order_key ) {
                                $selected = ' selected';
                            }
                            $order_by_option .= '<option value="' . $order_key . '"' . $selected . '>' . $order_name . '</option>';
                        }
                        foreach( (array)$order as $order_key => $order_name ) {
                            $selected = '';
                            if ( isset( $page_data[ 'order' ] ) && $page_data[ 'order' ] === $order_key ) {
                                $selected = ' selected';
                            }
                            $order_option .= '<option value="' . $order_key . '"' . $selected . '>' . $order_name . '</option>';
                        }
                        $page .= <<< EOM
                            <div class="page-item">
                                <strong class="page-item-title">{$name}</strong>
                                <p>表示数：<input type="number" class="inline-input" name="{$key}-{$slug}-count" value="{$count}"></p>
                                <p>表示順：<select name="{$key}-{$slug}-orderby">{$order_by_option}</select>で<select name="{$key}-{$slug}-order">{$order_option}</select></p>
                            </div>
EOM;
                    }
                }
                $page_table .= <<< EOM
                    <tr>
                        <th>{$key}ページ</th>
                        <td>{$page}</td>
                    </tr>
EOM;
            } else {
                $page_data = isset( $scripts[ 'page-setting' ][ $key ][ 'order-option' ] ) ? $scripts[ 'page-setting' ][ $key ][ 'order-option' ] : array();
                $count = isset( $page_data[ 'count' ] ) ? $page_data[ 'count' ] : $posts_per_page;
                $order_by_option = '';
                $order_option = '';
                foreach( (array)$order_by as $order_key => $order_name ) {
                    $selected = '';
                    if ( isset( $page_data[ 'orderby' ] ) && $page_data[ 'orderby' ] === $order_key ) {
                        $selected = ' selected';
                    }
                    $order_by_option .= '<option value="' . $order_key . '"' . $selected . '>' . $order_name . '</option>';
                }
                foreach( (array)$order as $order_key => $order_name ) {
                    $selected = '';
                    if ( isset( $page_data[ 'order' ] ) && $page_data[ 'order' ] === $order_key ) {
                        $selected = ' selected';
                    }
                    $order_option .= '<option value="' . $order_key . '"' . $selected . '>' . $order_name . '</option>';
                }
                $page_table .= <<< EOM
                    <tr>
                        <th>{$key}ページ</th>
                        <td>
                            <div class="page-item">
                                <strong class="page-item-title">{$key}</strong>
                                <p>表示数：<input type="number" class="inline-input" name="{$key}-count" value="{$count}"></p>
                                <p>表示順：<select name="{$key}-orderby">{$order_by_option}</select>で<select name="{$key}-order">{$order_option}</select></p>
                            </div>
                        </td>
                    </tr>
EOM;
            }
        }
    }
    
    return <<< EOM
        <h2 class="sub-title">{$text_menu_title}</h2>
        <table class="option-table">
            <tbody>{$page_table}</tbody>
        </table>
EOM;
}