<?php
class FrontScript {
    private $globalJs = '';
    private $css = '';
    private $criticalCss = '';
    private $tagmanager = '';
    private $otherScript = '';
    private $preload = '';
    private $firstTag = '';
    public function __construct( $page_obj ) {
        if ( !( $page_obj instanceof CreatePageInfo ) ){
            return false;
        }
        $page_info = $page_obj->getPageInfo();
        $term_object = $page_obj->getTermObject();
        $post = $page_obj->getPost();
        $testab = $page_obj->getTestab();
        $site_display = $page_obj->getSiteDisplay();
        $page_type = $page_obj->getPageType();
        $scripts = $page_obj->getScripts();
        $site_option = $page_obj->getSiteOption();
        extract( $scripts );
        if ( $site_url === null ) {
            $site_url = site_url();
        }
        if ( $home_url === null ) {
            $home_url = home_url();
        }
        if ( $ajax_url === null ) {
            $ajax_url = admin_url( 'admin-ajax.php' );
        }
        if ( $site_name === null ) {
            $site_name = get_option( 'blogname', '' );
        }
        if ( $stylesheet_url === null ) {
            $stylesheet_url = get_template_directory_uri();
        }
        if ( $site_update === null ) {
            $site_update = get_option( 'DG_site_value_update', date( 'Ymd' ) );
        }
        if ( $locale === null ) {
            $locale = get_locale();
        }
        $this->cssStyle( $scripts, $page_type, $stylesheet_url );
        $this->addJsScript( $page_info, $scripts, $page_type, $stylesheet_url, $site_update, $site_display );
        if ( isset( $scripts[ 'tagmanager' ] ) && $scripts[ 'tagmanager' ] !== '' ) {
            $this->setTagmanager( wp_unslash( $scripts[ 'tagmanager' ] ) );
        }
        if ( isset( $scripts[ 'other' ] ) && $scripts[ 'other' ] !== '' ) {
            $other_script .= wp_unslash( $scripts[ 'other' ] );
        }
        $this->setFont( $scripts );
        $this->setPreload( $scripts, $page_info, $page_type, $testab, $term_object, $post );
        $this->setFirstTag( $scripts, $stylesheet_url, $site_update );
        $this->setRecaptcha( $scripts, $page_info, $term_object, $post );
        
        $other_script = $this->getOtherScript();
        $script_var = $this->getGlobalJs();
        $script_var .= 'let homeUrl = "' . $home_url . '";let siteUrl = "' . $site_url . '";let siteName = "' . $site_name . '";let ajaxUrl = "' . $ajax_url . '";let siteLanguage = "' . $locale . '";let loadingImage = "' . $site_option[ 'loading_image' ] . '";let noImage = "' . $site_option[ 'no_image' ] . '";let fixedImage = ' . json_encode( $site_option[ 'fixedImage' ] ) . ';';
        //nonce
        if ( $site_display !== '1' ) {
            $comment_nonce = wp_create_nonce( 'post_comment_insert' );
            $script_var .= 'let commentNonce = "' . $comment_nonce . '";';
        }
        //ABテスト
        if ( $testab !== '' ) {
            $script_var .= 'let testType = "' . $testab . '";';
        }
        //記事独自CSS
        if ( $page_info[ 'page_type' ] === 'single' ) {
            $dg_post_css = get_post_meta( $post->ID, 'dg_post_css', true );
            if ( $dg_post_css !== '' ) {
                $other_script .= '<style id="dg-post-design">' . $dg_post_css . '</style>';
            }
        }
        $this->setGlobalJs( $script_var );
        $this->setOtherScript( $other_script );
    }
    public function printScript() {
        $js_vars = '<script>/* <![CDATA[ */' . $this->getGlobalJs() . '/* ]]> */</script>';
        return $this->getFirstTag() . $this->getCriticalCss() . $js_vars . $this->getCss() . $this->getTagmanager() . $this->getTagmanager() . $this->getPreload() . $this->getOtherScript();
    }
    
    //tagmanager取得
    public function getTagmanager() {
        return $this->tagmanager;
    }
    //tagmanagerセット
    public function setTagmanager( $str ) {
        $this->tagmanager = $str;
    }
    //otherScript取得
    public function getOtherScript() {
        return $this->otherScript;
    }
    //otherScriptセット
    public function setOtherScript( $str ) {
        $this->otherScript = $str;
    }
    
    //Global JS変数取得
    public function getGlobalJs() {
        return $this->globalJs;
    }
    //Global JS変数セット
    public function setGlobalJs( $str ) {
        $this->globalJs = $str;
    }
    //css取得
    public function getCss() {
        return $this->css;
    }
    //getCriticalCss取得
    public function getCriticalCss() {
        return $this->criticalCss;
    }
    //getCriticalCssセット
    public function setCriticalCss( $str ) {
        $this->criticalCss = $str;
    }
    //recaptchaセット
    public function setRecaptcha( $scripts, $page_info, $term_object, $post ) {
        $recaptcha = '';
        if ( isset( $scripts[ 'recaptcha' ][ 'site' ] ) && $scripts[ 'recaptcha' ][ 'site' ] !== '' && isset( $scripts[ 'recaptcha' ][ 'secret' ] ) && $scripts[ 'recaptcha' ][ 'secret' ] !== '' ) {
            $recaptcha_flg = false;
            if ( isset( $scripts[ 'recaptcha' ][ 'page' ] ) ) {
                if ( ( ( $page_info[ 'taxonomy' ] !== 'date' && $page_info[ 'page_type' ] === 'taxonomy' ) || $page_info[ 'page_type' ] === 'single' ) && isset( $scripts[ 'recaptcha' ][ 'page' ][ $page_info[ 'taxonomy' ] ] ) ) {
                    if ( $scripts[ 'recaptcha' ][ 'page' ][ $page_info[ 'taxonomy' ] ] !== '' ) {
                        $page_ids = explode( ',', $scripts[ 'recaptcha' ][ 'page' ][ $page_info[ 'taxonomy' ] ] );
                        if ( $page_info[ 'page_type' ] === 'taxonomy' ) {
                            if ( in_array( (string)$term_object->term_id, $page_ids, true ) === true ) {
                                $recaptcha_flg = true;
                            }
                        } elseif ( $page_info[ 'page_type' ] === 'single' ) {
                            if ( in_array( (string)$post->ID, $page_ids, true ) === true ) {
                                $recaptcha_flg = true;
                            }
                        }
                    } else {
                        $recaptcha_flg = true;
                    }
                } elseif ( isset( $scripts[ 'recaptcha' ][ 'page' ][ $page_info[ 'taxonomy' ] ] ) ) {
                    $recaptcha_flg = true;
                }
            } else {
                $recaptcha_flg = true;
            }
            if ( $recaptcha_flg ) {
                $order_script = $this->getOtherScript();
                $order_script .= '<script src="https://www.google.com/recaptcha/api.js?render=' . $scripts[ 'recaptcha' ][ 'site' ] . '"></script>';
                $this->setOtherScript( $order_script );
                $script_var = $this->getGlobalJs();
                $script_var .= 'let dgRecaptchaKey = "' . $scripts[ 'recaptcha' ][ 'site' ] . '";';
                $this->setGlobalJs( $script_var );
            }
        }
    }
    //preload取得
    public function getPreload() {
        return $this->preload;
    }
    //preloadセット
    public function setPreload( $scripts, $page_info, $page_type, $testab, $term_object, $post ) {
        $preload = '';
        if ( isset( $scripts[ 'post_preload' ][ $page_type ] ) ) {
            foreach( (array)$scripts[ 'post_preload' ][ $page_type ] as $part_id => $slug ) {
                $cache_name = 'DG_' . $part_id . $testab;
                if ( isset( $page_info[ 'lpFlg' ] ) ) {
                    $cache_name = 'DG_' . $part_id . $post->ID;
                }
                $cache = get_transient( $cache_name );
                $list_key = 'postList';
                switch ( $slug ) {
                    case 'categories' :
                        $list_key = 'termList';
                        break;
                    case 'author' :
                        $list_key = 'userList';
                        break;
                }
                if ( $cache !== false && isset( $cache[ $list_key ] ) ) {
                    foreach( (array)$cache[ $list_key ] as $item ) {
                        $preload .= $this->createPreloadImages( $item[ 'part' ][ 'thumbnail' ] );
                    }
                }
            }
        }
        if ( isset( $scripts[ 'preload' ][ $page_type ] ) && is_array( $scripts[ 'preload' ][ $page_type ] ) && count( $scripts[ 'preload' ][ $page_type ] ) > 0 ) {
            foreach( (array)$scripts[ 'preload' ][ $page_type ] as $value ) {
                if ( isset( $value[ 'url' ] ) && $value[ 'url' ] !== '' ) {
                    $type = '';
                    if ( isset( $value[ 'type' ] ) && $value[ 'type' ] !== '' ) {
                        $type = ' type="' . $value[ 'type' ] . '"';
                    }
                    if ( isset( $value[ 'imagesrcset' ] ) && $value[ 'imagesrcset' ] !== '' ) {
                        $type .= ' imagesrcset="' . $value[ 'imagesrcset' ] . '"';
                    }
                    $preload .= '<link rel="preload" href="' . rawurldecode( $value[ 'url' ] ) . '" as="' . $value[ 'as' ] . '"' . $type . '>';
                }
            }
        }
        $image_arr = array();
        $movie_arr = array();
        if ( ( $page_info[ 'page_type' ] === 'taxonomy' && $page_info[ 'taxonomy' ] !== 'date' ) || $page_info[ 'taxonomy' ] === 'author' ) {
            //タクソノミーイメージ
            if ( isset( $scripts[ 'preload' ][ 'taxonomy-thumbnail' ] ) ) {
                $image_arr = get_taxonomy_thumbnail_image( $term_object->term_id );
            }
            //タクソノミー動画
            if ( isset( $scripts[ 'preload' ][ 'taxonomy-movie' ] ) ) {
                $movie_arr = get_taxonomy_thumbnail_movie( $term_object->term_id );
            }
        }
        //記事イメージ
        if ( $page_info[ 'page_type' ] === 'single' ) {
            if ( isset( $scripts[ 'preload' ][ 'single-thumbnail' ] ) ) {
                $image_arr = post_thumbnail_src( $post );
            }
            //記事動画
            if ( isset( $scripts[ 'preload' ][ 'single-movie' ] ) ) {
                $single_movie = get_post_meta( $post->ID, 'movie_thumbnail', true );
                if ( $single_movie !== '' ) {
                    $movie_arr = json_decode( $single_movie, true );
                }
            }
        }
        $preload .= $this->createPreloadImages( $image_arr );
        if ( isset( $movie_arr[ 'type' ] ) && ( $movie_arr[ 'type' ] === '1' || $movie_arr[ 'type' ] === '2' ) ) {
            $ext = substr( $movie_arr[ 'value' ], strrpos( $movie_arr[ 'value' ], '.' ) + 1 );
            $preload .= '<link rel="preload" href="' . $movie_arr[ 'value' ] . '" as="video" type="video/' . $ext . '">';
        }
        $this->preload = $preload;
    }
    
    /*
     * preload用イメージ作成
    */
    public function createPreloadImages( $images ) {
        $preload = '';
        if ( isset( $images[ 'full' ][ 'url' ] ) ) {
            $src_set = '';
            foreach( (array)$images as $key => $img ) {
                if ( $key !== 'full' ) {
                    if ( isset( $img[ 'width' ] ) && $img[ 'width' ] !== '' ) {
                        if ( $src_set !== '' ) {
                            $src_set .= ',';
                        }
                        $src_set .= $img[ 'url' ] . ' ' . $img[ 'width' ] . 'w';
                    }
                }
            }
            if ( $src_set !== '' ) {
                $src_set = ' imagesrcset="' . $src_set . '"';
            }
            $preload .= '<link rel="preload" href="' . $images[ 'full' ][ 'url' ] . '" as="image"' . $src_set . '>';
        } elseif ( isset( $images[ 'url' ] ) && $images[ 'url' ] !== '' ) {
            $preload .= '<link rel="preload" href="' . $images[ 'url' ] . '" as="image">';
        }
        return $preload;
    }
    
    //優先スクリプト取得
    public function getFirstTag() {
        return $this->firstTag;
    }
    //優先スクリプトセット
    public function setFirstTag( $scripts, $stylesheet_url, $site_update ) {
        //PWA
        $first_tag = '';
        //事前読み込み
        if ( ( isset( $scripts[ 'pre-dns' ] ) && $scripts[ 'pre-dns' ] !== false ) || ( isset( $scripts[ 'preconnect' ] ) && $scripts[ 'preconnect' ] !== false ) || ( isset( $scripts[ 'dns' ] ) && $scripts[ 'dns' ] !== false ) ) {
            $first_tag .= '<meta http-equiv="x-dns-prefetch-control" content="on">';
            if ( isset( $scripts[ 'pre-dns' ] ) && $scripts[ 'pre-dns' ] !== false ) {
                foreach( (array)$scripts[ 'pre-dns' ] as $url ) {
                    $first_tag .= '<link rel="preconnect dns-prefetch" href="' . $url . '">';
                }
            }
            if ( isset( $scripts[ 'preconnect' ] ) && $scripts[ 'preconnect' ] !== false ) {
                foreach( (array)$scripts[ 'preconnect' ] as $url ) {
                    $first_tag .= '<link rel="preconnect" href="' . $url . '">';
                }
            }
            if ( isset( $scripts[ 'dns' ] ) && $scripts[ 'dns' ] !== false ) {
                foreach( (array)$scripts[ 'dns' ] as $url ) {
                    $first_tag .= '<link rel="dns-prefetch" href="' . $url . '">';
                }
            }
        }
        $pwa_var = '';
        if ( isset( $scripts[ 'pwa_theme' ] ) && $scripts[ 'pwa_theme' ] !== '' ) {
            $first_tag .= '<meta name="theme-color" content="' . $scripts[ 'pwa_theme' ] . '">';
        }
        if ( isset( $scripts[ 'pwa' ] ) ) {
            $pwa_var = 'let pwaUrl = "' . $scripts[ 'pwa' ] . '";';
            $first_tag .= '<link rel="manifest" href="' . $scripts[ 'manifest' ] . '" />';
            $css .= '<link rel="preload" href="' . $stylesheet_url . '/js/pwa.js?update=' . $site_update . '" as="script">';
            wp_enqueue_script( 'pwa_js', $stylesheet_url . '/js/pwa.js?update=' . $site_update . '"', null, null, true );
        } elseif ( isset( $scripts[ 'manifest' ] ) ) {
            $first_tag .= '<link rel="manifest" href="' . $scripts[ 'manifest' ] . '" />';
        }
        $this->firstTag = $first_tag;
    }
    //フォント設定
    public function setFont( $scripts ) {
        if ( isset( $scripts[ 'font' ][ 'free' ] ) && $scripts[ 'font' ][ 'free' ] !== '' ) {
            $order_script = $this->getOtherScript();
            $order_script .= $scripts[ 'font' ][ 'free' ];
            $this->setOtherScript( $order_script );
        } elseif ( isset( $scripts[ 'font' ][ 'fonts' ] ) && is_array( $scripts[ 'font' ][ 'fonts' ] ) && count( $scripts[ 'font' ][ 'fonts' ] ) > 0 ) {
            $font_type = '';
            foreach( (array)$scripts[ 'font' ][ 'fonts' ] as $family => $font ) {
                if ( $font_type !== '' ) {
                    $font_type .= ',';
                }
                $font_type .= "'" . $font . "'";
            }
            $script_var = $this->getGlobalJs();
            $script_var .= 'let googleFonts = [' . $font_type . '];';
            if ( isset( $scripts[ 'font' ][ 'lazyload' ] ) && $scripts[ 'font' ][ 'lazyload' ] === '2' ) {
                $script_var .= 'let googleFontNoneLazy = true;';
            }
            $this->setGlobalJs( $script_var );
        }
    }
    //CSS作成
    public function cssStyle( $scripts, $page_type, $stylesheet_url ) {
        // デバイス設定
        $device = array( 320 => 'sp', 560 => 'tb', 960 => 'pc' );
        if ( isset( $scripts[ 'device' ] ) ) {
            $device = $scripts[ 'device' ];
        }
        $cnt = 0;
        $css = '';
        $css .= '<link href="' . $stylesheet_url . '/css/webicon/icomoon.ttf?wwza6v" rel="preload" as="font" type="font/ttf" crossorigin>';
        $css .= '<link href="' . $stylesheet_url . '/css/webicon/icomoon.woff?wwza6v" rel="preload" as="font" type="font/woff" crossorigin>';
        $critical_css = '';
        $critical_css_obj = array();
        $cri_flg = isset( $scripts[ 'critical' ][ $page_type ] ) && is_array( $scripts[ 'critical' ][ $page_type ] ) && count( $scripts[ 'critical' ][ $page_type ] ) > 0;
        foreach( (array)$device as $size => $type ) {
            $css_url = isset( $scripts[ 'css_path' ][ $page_type ][ $type ] ) ? $scripts[ 'css_path' ][ $page_type ][ $type ] : '';
            if ( $cnt === 0 ) {
                if ( $cri_flg ) {
                    $critical_css .= $scripts[ 'critical' ][ $page_type ][ $type ];
                    if ( $css_url !== '' ) {
                        $critical_css_obj[] = "'{$type}_style':{'url':'{$css_url}','media':''}";
                        $css .= '<link id="' . $type . '_style_preload" href="' . $css_url . '" rel="preload" as="style">';
                        $css .= '<noscript><link id="' . $type . '_style" href="' . $css_url . '" rel="stylesheet" type="text/css"></noscript>';
                    }
                } elseif ( $css_url !== '' ) {
                    $css .= '<link id="' . $type . '_style" href="' . $css_url . '" rel="stylesheet" type="text/css">';
                }
            } else {
                if ( $cri_flg ) {
                    if ( isset( $scripts[ 'critical' ][ $page_type ][ $type ] ) ) {
                        $critical_css .= '@media screen and (min-width:' . $size . 'px) {' . $scripts[ 'critical' ][ $page_type ][ $type ] . '}';
                    }
                    if ( $css_url !== '' ) {
                        $css .= '<link id="' . $type . '_style_preload" href="' . $css_url . '" rel="preload" as="style">';
                        $critical_css_obj[] = "'{$type}_style':{'url':'{$css_url}','media':'screen and (min-width:{$size}px)'}";
                        $css .= '<noscript><link id="' . $type . '_style" href="' . $css_url . '" rel="stylesheet" type="text/css" media="screen and (min-width:' . $size . 'px)"></noscript>';
                    }
                } elseif ( $css_url !== '' ) {
                    $css .= '<link id="' . $type . '_style" href="' . $css_url . '" rel="stylesheet" type="text/css" media="screen and (min-width:' . $size . 'px)">';
                }
            }
            ++$cnt;
        }
        $this->css = $css;
        if ( $critical_css !== '' ) {
            $this->setCriticalCss( '<style id="dg-critical-style">' . $critical_css . '</style>' );
            $script_var = $this->getGlobalJs();
            $script_var .= 'let DGCriticalCSS = {' . implode( ',', $critical_css_obj ) . '};';
            $this->setGlobalJs( $script_var );
        }
    }
    
    //JSスクリプトファイル追加
    public function addJsScript( $page_info, $scripts, $page_type, $stylesheet_url, $site_update, $site_display ) {
        if ( $site_display === '1' ) {
            if ( isset( $scripts[ 'js_path' ][ $page_type ] ) && $scripts[ 'js_path' ][ $page_type ] !== '' ) {
                wp_enqueue_script( 'php_summary', $scripts[ 'js_path' ][ $page_type ] . '"', null, null, true );
            } else {
                if ( $page_info[ 'page_type' ] === 'single' ) {
                    wp_enqueue_script( 'php_summary', $stylesheet_url . '/js/php_summary-post.js?update=' . $site_update . '"', null, null, true );
                } else {
                    wp_enqueue_script( 'php_summary', $stylesheet_url . '/js/php_summary.js?update=' . $site_update . '"', null, null, true );
                }
            }
        } else {
            wp_enqueue_script( 'front_summary', $stylesheet_url . '/js/front_summary.js?update=' . $site_update . '"', null, null, true );
        }
    }
}