<?php
class CreatePageInfoUrl extends CreatePageInfo {
    //宣言時実行
    public function __construct( $url ) {
        $this->homeUrl = home_url();
        $this->setSiteName( get_option( 'blogname', '' ) );
        $page_info = $this->setPageidByUrl( $url );
        $this->setPageInfo( $page_info );
        $this->setTestab( $page_info );
        $this->setPageData( $page_info );
    }
    //現在ページの情報セット
    protected function setPageData( $page_info ) {
        $page_slug = 'top';
        $site_name = $this->getSiteName();
        $page_flg = array(
            'is_home' => false,
            'is_search' => false,
            'is_author' => false,
            'is_post_type_archive' => false,
            'is_archive' => false,
            'is_date' => false,
            'is_single' => false,
            'is_404' => false,
        );
        if ( isset( $page_info[ 'page_type' ] ) && $page_info[ 'page_type' ] === 'single' ) {
            $post = get_post( $page_info[ 'post_id' ] );
            $description = character_limit( preg_replace( '/[\s\n]{1,}/s', '', strip_tags( $post->post_content ) ), 120 );
            $this->setTitle( $post->post_title );
            $this->setDescription( $description );
            $this->setPageClass( 'single ' . $page_info[ 'taxonomy' ] . ' post-' . $page_info[ 'post_id' ] );
            $page_flg[ 'is_single' ] = true;
        } elseif ( $page_info[ 'taxonomy' ] !== '404' ) {
            if ( $page_info[ 'taxonomy' ] === 'top' ) {
                $this->setTitle( $site_name );
                $this->setDescription( get_option( 'blogdescription', '' ) );
                $this->setPageClass( 'top' );
                $page_flg[ 'is_home' ] = true;
            } elseif ( $page_info[ 'taxonomy' ] === 'search' ) {
                $this->setTitle( $page_info[ 'term_id' ] );
                $this->setPageClass( 'search' );
                $page_flg[ 'is_search' ] = true;
                $page_slug = 'other-search';
            } elseif ( $page_info[ 'taxonomy' ] === 'author' ) {
                $this->setTitle( get_the_author_meta( 'display_name', $page_info[ 'term_id' ] ) );
                $this->setDescription( get_the_author_meta( 'description', $page_info[ 'term_id' ] ) );
                $this->setPageClass( 'author' );
                $page_flg[ 'is_author' ] = true;
                $page_slug = 'other-author';
            } elseif ( $page_info[ 'taxonomy' ] === 'date' ) {
                $year = $this->getYear();
                $month = $this->getMonth();
                $day = $this->getDay();
                $page_flg[ 'is_date' ] = true;
                $page_slug = 'taxonomy-data';
                if ( $day !== 0 && $month !== 0 && $year !== 0 ) {
                    $this->setTitle( $year .'-' . $month . '-' . $day );
                    $this->setPageClass( 'taxonomy date' );
                } elseif ( $month !== 0 && $year !== 0 ) {
                    $this->setTitle( $year .'-' . $month );
                    $this->setPageClass( 'taxonomy date' );
                } elseif ( $year !== 0 ) {
                    $this->setTitle( $year );
                    $this->setPageClass( 'taxonomy date' );
                }
            } elseif ( $page_info[ 'page_type' ] === 'custom-post-archive' ) {
                $post_type_data = get_post_type_object( $page_info[ 'taxonomy' ] );
                $this->setTitle( $post_type_data->label );
                $this->setDescription( $post_type_data->description );
                $this->setPageClass( 'post-archive ' . $post_type_data->name );
                $page_flg[ 'is_post_type_archive' ] = true;
                $page_slug = $page_info[ 'page_type' ] . '-' . $post_type_data->name;
            } else {
                //タクソノミーサムネイル取得
                $term = get_term( $page_info[ 'term_id' ], $page_info[ 'taxonomy' ] );
                if ( !is_wp_error( $term ) ) {
                    $this->setTitle( $term->name );
                    $this->setDescription( $term->description );
                    $this->setTermCount( $term->count );
                    $this->setTermSlug( $term->slug );
                    $this->setPageClass( 'taxonomy ' . $page_info[ 'taxonomy' ] . ' ' . $term->slug );
                    $this->setTaxonomyThumbnail( get_taxonomy_thumbnail_image( $page_info[ 'term_id' ] ) );
                    $this->setTaxonomySubTitle( get_term_meta( $page_info[ 'term_id' ], 'sub_title', true ) );
                    $this->setTermParentId( $term->parent );
                    $page_flg[ 'is_archive' ] = true;
                    $page_slug = 'taxonomy-' . $page_info[ 'taxonomy' ];
                } else {
                    $this->setTitle( __( 'お探しのページが見つかりませんでした', 'dg-style' ) );
                    $this->setPageClass( 'page404' );
                    $page_flg[ 'is_404' ] = true;
                }
            }
        } else {
            $this->setTitle( __( 'お探しのページが見つかりませんでした', 'dg-style' ) );
            $this->setPageClass( 'page404' );
            $page_flg[ 'is_404' ] = true;
        }
        $this->setPageFlg( $page_flg );
        $this->setPageSlug( $page_slug );
    }
    //送信されたURLからpageInfo作成
    private function setPageidByUrl( $url ) {
        $this->setPageUrl( $url );
        $page_url = $this->getPageUrl();
        $home_url = $this->getHomeUrl();
        $page_404 = array( 'taxonomy' => '404', 'page_type' => '404' );
        //正しいURLじゃない場合はエラー処理
        if ( !$page_url ) {
            return $page_404;
        }
        //検索エンジンキャッシュ対策
        $url_pattern = str_replace( '/', '\/', $home_url );
        $url_pattern = str_replace( '-', '\-', $url_pattern );
        $url_pattern = str_replace( '.', '\.', $url_pattern );
        $url_pattern = str_replace( '?', '\?', $url_pattern );
        $url_pattern = str_replace( '+', '\+', $url_pattern );
        if ( !preg_match( '/^' . $url_pattern . '/', $page_url ) ) {
            preg_match( '/' . $url_pattern . '[^+*]*/s', $page_url, $match_url );
            if ( isset( $match_url[ 0 ] ) ) {
                $page_url = $match_url[ 0 ];
            }
        }
        if ( $page_url === null ) {
            return $page_404;
        }
        global $wp_rewrite;
        $page_info = array();
        $current_url = str_replace( $home_url, '', $page_url );
        $current_url = str_replace( '//', '/', $current_url );
        $url_arr = parse_url( $current_url );
        if ( isset( $url_arr[ 'query' ] ) ) {
            parse_str( $url_arr[ 'query' ], $current_parm );
        }

        //ページ番号削除
        if ( isset( $url_arr[ 'path' ] ) ) {
            if ( preg_match( '/\/page\/([0-9]{0,})\//s', $url_arr[ 'path' ], $paged ) ) {
                $url_arr[ 'path' ] = preg_replace( '/page\/[0-9]{0,}(\/)?/s', '', $url_arr[ 'path' ] );
            }
        }

        if ( $wp_rewrite->permalink_structure === '' ) {
            $post_id = url_to_postid( $url );
        } else {
            if ( isset( $url_arr[ 'path' ] ) ) {
                $post_id = url_to_postid( $url_arr[ 'path' ] );
            } else {
                $url_arr[ 'path' ] = '/';
                $post_id = 0;
            }
        }
        if ( isset( $current_parm ) ) {
            $page_info[ 'parm' ] = $current_parm;
        }
        $page_info[ 'testab' ] = '';
        if ( isset( $current_parm[ 'testab' ] ) ) {
            if ( get_option( 'DG_site_design_' . $current_parm[ 'testab' ], '' ) !== '' ) {
                $page_info[ 'testab' ] = $current_parm[ 'testab' ];
            }
        }
        //ページナンバー
        if ( isset( $current_parm[ 'paged' ] ) ) {
            $page_info[ 'paged' ] = isset( $current_parm[ 'paged' ] ) && is_numeric( $current_parm[ 'paged' ] ) ? $current_parm[ 'paged' ] : 1;
        } else {
            $page_info[ 'paged' ] = isset( $paged[ 1 ] ) && is_numeric( $paged[ 1 ] ) ? $paged[ 1 ] : 1;
        }

        //プレビューの場合
        if ( isset( $current_parm[ 'preview' ] ) && $current_parm[ 'preview' ] === 'true' ) {
            if ( isset( $current_parm[ 'p' ] ) && $current_parm[ 'p' ] !== '' ) {
                $post_id = $current_parm[ 'p' ];
            } elseif ( isset( $current_parm[ 'preview_id' ] ) && $current_parm[ 'preview_id' ] !== '' ) {
                $post_id = $current_parm[ 'preview_id' ];
            }
        }

        //記事IDが取得できない場合、その他ページとして処理
        if ( (int)$post_id === 0 ) {
            //デフォルトのパーマリンクの場合
            if ( $wp_rewrite->permalink_structure === '' ) {
                $param_arr = array( 'category' => 'cat', 'post_tag' => 'tag', 'author' => 'author', 'search' => 's', );
                $taxonomies = default_taxonomy_exclusion( $param_arr );
                //404処理
                if ( !isset( $url_arr[ 'query' ] ) && isset( $url_arr[ 'path' ] ) && str_replace( '/', '', $url_arr[ 'path' ] ) !== '' ) {
                    return $page_404;
                }
                if ( isset( $url_arr[ 'query' ] ) ) {
                    foreach( (array)$taxonomies as $key => $name ) {
                        if ( isset( $current_parm[ $name ] ) ) {
                            $page_info[ 'taxonomy' ] = $key;
                            $page_info[ 'term_id' ] = $current_parm[ $name ];
                            break;
                        }
                    }
                    if ( isset( $current_parm[ 'post_type' ] ) ) {
                        $post_type_data = get_post_type_object( $current_parm[ 'post_type' ] );
                        if ( $post_type_data->has_archive === true ) {
                            $page_info[ 'taxonomy' ] = $post_type_data->name;
                            $page_info[ 'post_type' ] = array( $post_type_data->name );
                            $page_info[ 'page_type' ] = 'custom-post-archive';
                        } else {
                            return $page_404;
                        }
                    }
                }

                //日付
                if ( !isset( $page_info[ 'taxonomy' ] ) && !isset( $page_info[ 'term_id' ] ) && ( isset( $current_parm[ 'year' ] ) || isset( $current_parm[ 'monthnum' ] ) || isset( $current_parm[ 'day' ] ) || isset( $current_parm[ 'm' ] ) || isset( $current_parm[ 'w' ] ) ) ) {
                    $date_param = array( 'year' => 'year', 'monthnum' => 'monthnum', 'day' => 'day', 'm' => 'm', 'w' => 'w', );
                    foreach( (array)$date_param as $key => $name ) {
                        $page_info[ 'taxonomy' ] = 'date';
                        if ( isset( $current_parm[ $name ] ) ) {
                            $page_info[ 'term_id' ][ $name ] = $current_parm[ $name ];
                        }
                    }
                }
                if ( isset( $current_parm[ 'paged' ] ) ) {
                    $current_parm[ 'paged' ] = $page_info[ 'paged' ];
                }
                if ( isset( $url_arr[ 'query' ] ) ) {
                    $new_url_query = '?' . http_build_query( $current_parm, '', '&');
                } else {
                    $new_url_query = '';
                }
                //ページングの設定
                if ( isset( $url_arr[ 'path' ] ) && str_replace( '/', '', $url_arr[ 'path' ] ) === '' ) {
                    $page_info[ 'result_url' ] = urlencode( $home_url . $new_url_query );
                } else {
                    $page_info[ 'result_url' ] = urlencode( $home_url . $url_arr[ 'path' ] . $new_url_query );
                }
            } else {
                $match_url = array();
                $custom_post_types = get_post_types( array( 'public' => true, 'has_archive' => true, '_builtin' => false ) );//記事のタイプを取得
                $post_types = get_post_types( array( 'public' => true, 'has_archive' => true, '_builtin' => true ) );//記事のタイプを取得
                $rewrite_list = array_merge( $wp_rewrite->extra_permastructs, array( 'author' => array( 'struct' => '/' . $wp_rewrite->author_base . '/%author%' ) ) );
                foreach ( $rewrite_list as $name => $value ) {
                    if ( in_array( $name, $post_types, true ) === false && $name !== 'post_format' ) {
                        $match_url[ $name ] = str_replace( $wp_rewrite->rewritecode, '', $value[ 'struct' ] );
                    }
                }
                $match_site_url = $home_url . $url_arr[ 'path' ];
                $pattern_url = str_replace( '/', '\/', $home_url );
                foreach( (array)$match_url as $name => $type ) {
                    $pattern = preg_replace( '/^(\/)?/s', '/', $type );
                    $pattern = str_replace( '/', '\/', $pattern );
                    if ( preg_match( '/' . $pattern_url . $pattern . '/s', $match_site_url ) ) {
                        if ( in_array( $name, $custom_post_types, true ) === true ) {
                            $page_info[ 'taxonomy' ] = $name;
                            $page_info[ 'page_type' ] = 'custom-post-archive';
                            $page_info[ 'post_type' ] = array( $name );
                            break;
                        } else {
                            $page_info[ 'taxonomy' ] = $name;
                            $term_id = preg_replace( '/(' . $pattern . ')/s', '', $url_arr[ 'path' ] );
                            break;
                        }
                    }
                }
                if ( isset( $term_id ) ) {
                    $term_id = explode( '/', $term_id );
                    $term_id = array_filter( $term_id, 'strlen' );
                    $term_id = array_values( $term_id );
                    $page_info[ 'term_id' ] = end( $term_id );
                }

                if ( !isset( $page_info[ 'taxonomy' ] ) && !isset( $page_info[ 'term_id' ] ) && ( preg_match( '/\/?[0-9]{4}\//s', $url_arr[ 'path' ] ) || isset( $current_parm[ 'm' ] ) || isset( $current_parm[ 'w' ] ) ) ) {
                    $page_info[ 'taxonomy' ] = 'date';
                    if ( preg_match( '/\/[0-9]{4}\//s', $url_arr[ 'path' ] ) ) {
                        $date_arr = explode( '/', $url_arr[ 'path' ] );
                        $date_arr = array_filter( $date_arr, 'strlen' );
                        $date_arr = array_values( $date_arr );
                        if ( isset( $date_arr[ 0 ] ) ) {
                            $page_info[ 'term_id' ][ 'year' ] = $date_arr[ 0 ];
                            $this->setYear( (int)$date_arr[ 0 ] );
                        }
                        if ( isset( $date_arr[ 1 ] ) ) {
                            $page_info[ 'term_id' ][ 'monthnum' ] = $date_arr[ 1 ];
                            $this->setMonth( (int)$date_arr[ 1 ] );
                        }
                        if ( isset( $date_arr[ 2 ] ) ) {
                            $page_info[ 'term_id' ][ 'day' ] = $date_arr[ 2 ];
                            $this->setDay( (int)$date_arr[ 2 ] );
                        }
                        if ( isset( $current_parm[ 'm' ] ) ) {
                            $page_info[ 'term_id' ][ 'm' ] = $current_parm[ 'm' ];
                        }
                        if ( isset( $current_parm[ 'w' ] ) ) {
                            $page_info[ 'term_id' ][ 'w' ] = $current_parm[ 'w' ];
                        }
                    }
                }

                if ( isset( $current_parm[ 'paged' ] ) ) {
                    $current_paged = $current_parm[ 'paged' ];
                    unset( $current_parm[ 'paged' ] );
                }
                if ( isset( $current_parm ) && count( $current_parm ) > 0 ) {
                    $new_url_query = '?' . http_build_query( $current_parm, '', '&');
                } else {
                    $new_url_query = '';
                }
                //ソートパラメータ
                if ( isset( $current_parm[ 'orderby' ] ) ) {
                    $page_info[ 'orderby' ] = $current_parm[ 'orderby' ];
                }
                if ( isset( $current_parm[ 'order' ] ) ) {
                    $page_info[ 'order' ] = $current_parm[ 'order' ];
                }
                if ( isset( $current_parm[ 'count' ] ) ) {
                    $page_info[ 'count' ] = $current_parm[ 'count' ];
                }
                if ( isset( $current_parm[ 'srange' ] ) ) {
                    $page_info[ 'srange' ] = $current_parm[ 'srange' ];
                }
                if ( isset( $current_parm[ 'stax' ] ) ) {
                    $page_info[ 'stax' ] = $current_parm[ 'stax' ];
                }
                if ( isset( $current_parm[ 'slang' ] ) ) {
                    $page_info[ 'slang' ] = $current_parm[ 'slang' ];
                }
                //ページング設定
                if ( isset( $current_paged ) && (int)$current_paged > 1 ) {
                    if ( isset( $url_arr[ 'path' ] ) && str_replace( '/', '', $url_arr[ 'path' ] ) === '' ) {
                        $page_info[ 'result_url' ] = urlencode( $home_url . '/page/' . $current_paged . '/' . $new_url_query );
                    } else {
                        $page_info[ 'result_url' ] = urlencode( $home_url . $url_arr[ 'path' ] . 'page/' . $current_paged . '/' . $new_url_query );
                    }
                } else {
                    if ( isset( $url_arr[ 'path' ] ) && str_replace( '/', '', $url_arr[ 'path' ] ) === '' ) {
                        $page_info[ 'result_url' ] = urlencode( $home_url . $new_url_query );
                    } else {
                        $page_info[ 'result_url' ] = urlencode( $home_url . $url_arr[ 'path' ] . $new_url_query );
                    }
                }

            }
            //検索結果
            if ( isset( $current_parm[ 's' ] ) && ( !isset( $url_arr[ 'path' ] ) || ( isset( $url_arr[ 'path' ] ) && str_replace( '/', '', $url_arr[ 'path' ] ) === '' ) ) ) {
                $page_info[ 'taxonomy' ] = 'search';
                $page_info[ 'page_type' ] = 'search';
                $page_info[ 'term_id' ] = $current_parm[ 's' ];
            }
            //TOPページ処理
            if ( 
                ( 
                    ( 
                        !isset( $page_info[ 'taxonomy' ] ) || ( isset( $page_info[ 'taxonomy' ] ) && $page_info[ 'taxonomy' ] === '' ) 
                    ) && (
                        !isset( $page_info[ 'term_id' ] ) || ( isset( $page_info[ 'term_id' ] ) && $page_info[ 'term_id' ] === '' ) 
                    )
                ) && ( 
                    !isset( $url_arr[ 'path' ] ) || ( isset( $url_arr[ 'path' ] ) && $url_arr[ 'path' ] === '/' || $url_arr[ 'path' ] === '' ) 
                ) 
            ) {
                $page_info[ 'taxonomy' ] = 'top';
                $page_info[ 'term_id' ] = 'top';
                $page_info[ 'page_type' ] = 'top';
                return $page_info;
            }
            //404処理
            if ( !isset( $page_info[ 'page_type' ] ) && ( !isset( $page_info[ 'taxonomy' ] ) || ( isset( $page_info[ 'taxonomy' ] ) && $page_info[ 'taxonomy' ] !== 'search' ) ) && ( !isset( $page_info[ 'term_id' ] ) || ( isset( $page_info[ 'term_id' ] ) && $page_info[ 'term_id' ] === '' ) ) ) {
                return $page_404;
            }
            //タクソノミースラッグの場合、IDに変更
            if ( ( $page_info[ 'taxonomy' ] !== 'search' && $page_info[ 'taxonomy' ] !== 'date' ) && ( isset( $page_info[ 'term_id' ] ) && $page_info[ 'term_id' ] !== '' ) && !is_numeric( $page_info[ 'term_id' ] ) ) {
                if ( $page_info[ 'taxonomy' ] === 'author' ) {
                    $user = get_user_by( 'slug', $page_info[ 'term_id' ] );
                    if ( $user !== false ) {
                        $page_info[ 'term_id' ] = $user->ID;
                        $page_info[ 'page_type' ] = 'author';
                    } else {
                        $page_info[ 'taxonomy' ] = '404';
                    }
                } else {
                    $term = get_term_by( 'slug', $page_info[ 'term_id' ], $page_info[ 'taxonomy' ] );
                    if ( $term !== false ) {
                        $page_info[ 'term_id' ] = $term->term_id;
                    } else {
                        $page_info[ 'taxonomy' ] = '404';
                    }
                }
            }
            if ( !isset( $page_info[ 'page_type' ] ) && $page_info[ 'taxonomy' ] !== 'top' && $page_info[ 'taxonomy' ] !== 'search' && $page_info[ 'taxonomy' ] !== '404' && $page_info[ 'taxonomy' ] !== 'author' ) {
                $page_info[ 'pageClass' ] = 'taxonomy';
                $page_info[ 'page_type' ] = 'taxonomy';
            } elseif ( !isset( $page_info[ 'page_type' ] ) ) {
                $page_info[ 'page_type' ] = $page_info[ 'taxonomy' ];
            }
            return $page_info;
        } else {
            $post_type = get_post_type( $post_id );
            if ( in_array( $post_type, POST_TYPE_EXCLUSION, true ) === true ) {
                return $page_404;
            }
            if ( $post_type === 'lp' ) {
                $page_info[ 'lpFlg' ] = true;
            }
            $page_info[ 'pageClass' ] = 'single';
            $page_info[ 'page_type' ] = 'single';
            $page_info[ 'taxonomy' ] = $post_type;
            $page_info[ 'post_id' ] = $post_id;
            $page_info[ 'result_url' ] = $url;
            return $page_info;
        }
        return $page_404;
    }
    
    //表示項目振り分け
    public function sortingDisplayParts( $post, $reload ) {
        $main_value = $this->getSiteOption();
        if ( !isset( $main_value[ 'main' ] ) ) {
            return false;
        }
        $design_value = $main_value[ 'main' ];
        $testab = $this->getTestab();
        $this_page = $this->getPageType();
        $post_summary = $this->getPostSummary();
        $archive = $this->getArchive();
        $result = array();
        $sub_value = array();
        $site_sub_value = get_option( 'DG_site_sub_value' . $testab );
        if ( $site_sub_value !== false ) {
            $sub_value = json_decode( $site_sub_value, true );
        }
        $hidden = isset( $sub_value[ 'hidden' ][ $this_page ] ) ? $sub_value[ 'hidden' ][ $this_page ] : array();
        $page_none_display = array();
        if ( $post_summary !== false ) {
            $hidden = array_merge( $hidden, $sub_value[ 'taxonomy' ] );
            $page_none_display = $sub_value[ 'taxonomy' ];
        } elseif ( $archive !== false ) {
            $hidden = array_merge( $hidden, $sub_value[ 'single' ] );
            $page_none_display = $sub_value[ 'single' ];
        }
        
        $front_parts = isset( $post[ 'ids' ] ) && $post[ 'ids' ] !== '' ? explode( ',', $post[ 'ids' ] ) : array();
        $page_display = isset( $sub_valuee[ 'display' ] ) ? $sub_value[ 'display' ] : array();
        //必須コンテンツの重複読み込み防止
        $result[ 'hidden' ] = $hidden;
        
        
        //非表示解除アイテム取得
        $part_keys = array_keys( $design_value );
        if ( $reload === true ) {
            /* 前ページでは非表示で現ページでは表示する場合 */
            $part_keys = array_diff( $part_keys, $hidden );
            /* ページごと再度読み込むべきのパーツを取得 */
            if ( isset( $sub_value[ 'real' ] ) && isset( $sub_value[ 'hidden' ][ $this_page ] ) ) {
                $part_keys = array_merge( $part_keys, array_diff( $sub_value[ 'real' ], $sub_value[ 'hidden' ][ $this_page ] ) );
            } elseif ( isset( $sub_value[ 'real' ] ) ) {
                $part_keys = array_merge( $part_keys, $sub_value[ 'real' ] );
            }
            /* 非表示設定をしていないパーツから重複で値を返さないようにフィルター */
            if ( isset( $page_display[ $this_page ] ) ) {
                $part_keys = array_merge( $part_keys, array_diff( $page_display[ $this_page ], $part_keys, $page_none_display, $front_parts ) );
            }
            /* ページ専用パーツが非表示設定か確認 */
            if ( isset( $sub_value[ 'hidden' ][ $this_page ] ) ) {
                $part_keys = array_diff( $part_keys, $sub_value[ 'hidden' ][ $this_page ] );
            }
            $result[ 'device' ] = $sub_value[ 'device' ];
            $result[ 'css' ] = $sub_value[ 'css' ][ $this_page ];
            if ( isset( $sub_value[ 'critical' ][ $this_page ] ) ) {
                $result[ 'critical' ] = $sub_value[ 'critical' ][ $this_page ];
            }
        } else {
            $part_keys = array_diff( $part_keys, $hidden );
        }
        return array( 'result' => $result, 'part_keys' => $part_keys );
    }
    
    // もっと見るの場合のページデータ取得
    public function setCurrentPageInfoMore( $post ) {
        $main_value = $this->getSiteOption();
        if ( !$main_value ) {
            return false;
        }
        $result = array();
        $page_info = $this->getPageInfo();
        $title = $this->getTitle();
        $description = $this->getDescription();
        $term_parent_id = $this->getTermParentId();
        $taxonomy_thumbnail = $this->getTaxonomyThumbnail();
        $taxonomy_sub_title = $this->getTaxonomySubTitle();
        $term_slug = $this->getTermSlug();
        $term_count = $this->getTermCount();
        $page_info = $this->setPageOrderOption( $page_info );
        $loading_img = $main_value[ 'loading_image' ];
        $post_summary = false;
        $archive = false;
        $pass = isset( $post[ 'pw' ] ) ? $post[ 'pw' ] : '';
        if ( isset( $page_info[ 'pageClass' ] ) && $page_info[ 'pageClass' ] === 'single' ) {
            $page_info[ 'meta_keys' ] = isset( $main_value[ 'meta_keys' ] ) ? $main_value[ 'meta_keys' ] : array();
            $post_data = front_single_post_get( $page_info, $pass );
            if ( $post_data !== false ) {
                $post_summary = $post_data[ 'postData' ];
                $post_summary[ 'user_id' ] = $post_data[ 'user_id' ];
                $post_summary[ 'parent' ] = $post_data[ 'parent' ];
                $result[ 'post' ] = $post_data[ 'postData' ];
            }
        } elseif ( $page_info[ 'taxonomy' ] !== '404' ) {
            if ( isset( $main_value[ 'main_post_flg' ] ) ) {
                $page_info[ 'none_main_post' ] = true;
            }
            $archive = front_main_part_archive_query( $page_info );
            $result[ 'archive' ][ 'postCount' ] = $archive[ 'postCount' ];
        }
        $this->setPageInfo( $page_info );
        $this->setPostSummary( $post_summary );
        $this->setArchive( $archive );
        return $result;
    }
}