<?php
    $page_obj = new CreatePageInfoPhp();
    $head_script = new FrontScript( $page_obj );
    $front_head = new FrontHead( $page_obj );
    $scripts = $page_obj->getScripts();
    $site_display = $page_obj->getSiteDisplay();
    $noscript = '';
    $yahoo = '';
    if ( isset( $scripts[ 'noscript' ] ) && $scripts[ 'noscript' ] !== '' ) {
        $noscript = wp_unslash( $scripts[ 'noscript' ] );
    }
    if ( isset( $scripts[ 'yahoo' ] ) && $scripts[ 'yahoo' ] !== '' ) {
        $yahoo = wp_unslash( $scripts[ 'yahoo' ] );
    }
    $body_class = '';
    $main = '';
    if ( $site_display === '1' ) {
        $body_class = ' class="' . esc_attr( implode( ' ', get_body_class() ) ) . '"';
        $main = output_php_display( $page_obj );
    }
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php echo $front_head->getHead(); ?>
    <?php wp_head(); ?>
    <?php echo $head_script->printScript(); ?>
</head>
<body<?php echo $body_class; ?>>
<?php
    echo $noscript;
    echo $main;
    wp_footer();
    echo $yahoo;
?>
</body>
</html>