<?php
// ページの追加
add_action( 'admin_menu', 'site_builder_setting' );
function site_builder_setting() {
    $text_sitebuilder = __( 'サイトビルダー', 'dg-style' );
    $text_option = __( 'オプション', 'dg-style' );
    $text_avatar = __( 'エディターオプション', 'dg-style' );
    add_menu_page( $text_sitebuilder, $text_sitebuilder, 'edit_others_posts', 'site_builder', 'site_builder_page', 'dashicons-art', 60 );
    $hook_suffix_basic = add_submenu_page( 'site_builder', $text_sitebuilder, $text_sitebuilder, 'edit_others_posts', 'site_builder', 'site_builder_page' );
    $hook_suffix_option = add_submenu_page( 'site_builder', $text_option, $text_option, 'edit_others_posts', 'site_builder_option', 'site_builder_option_page' );
    $hook_suffix_avatar = add_submenu_page( 'site_builder', $text_avatar, $text_avatar, 'edit_others_posts', 'site_builder_editor_option', 'site_builder_editor_option_page' );
    /*
    $hook_suffix_custom_field = add_submenu_page( 'site_builder', 'カスタムフィールド追加', 'カスタムフィールド追加', 'edit_others_posts', 'site_builder_add_custom_field', 'site_builder_custom_field_page' );
    $hook_suffix_taxonomy = add_submenu_page( 'site_builder', 'タクソノミー追加', 'タクソノミー追加', 'edit_others_posts', 'site_builder_add_taxonomy', 'site_builder_taxonomy_page' );
    $hook_suffix_costom_post = add_submenu_page( 'site_builder', '投稿タイプ追加', '投稿タイプ追加', 'edit_others_posts', 'site_builder_custom_post_type', 'site_builder_custom_post_page' );*/
    /* jaの追加 */
    add_action( 'load-' . $hook_suffix_basic, 'site_builder_script' );
    add_action( 'load-' . $hook_suffix_option, 'site_builder_option_script' );
    add_action( 'load-' . $hook_suffix_avatar, 'site_builder_avatar_script' );
    /*add_action( 'load-' . $hook_suffix_costom_post, 'site_builder_custom_post_script' );*/
}

/* ----------------------------------------------------------
 * ページスクリプト
---------------------------------------------------------- */
function site_builder_script() {
    $site_update_time = date( 'YmdHis' );
    $directory_url = get_template_directory_uri();
    wp_enqueue_media();
    wp_enqueue_script( 'media-upload' );
    wp_enqueue_script( 'jquery-ui-droppable' );
    wp_enqueue_script( 'jquery-ui-sortable' );
    wp_enqueue_script( 'jquery-ui-resizable' );
    wp_register_style( 'dg_slider_css', $directory_url . '/css/temp/slide.css?ver=' . $site_update_time );
    $wp_js = array( 'jquery', 'wp-i18n', );
    wp_enqueue_script( 'site_builder_js', $directory_url . '/wp-admin/site_builder/site_builder.js', $wp_js, $site_update_time, true );
    wp_enqueue_script( 'site_tutorial_js', $directory_url . '/wp-admin/site_builder/site_tutorial.js', $wp_js, $site_update_time, true );
    //JS翻訳スクリプト追加
    wp_set_script_translations( 'site_builder_js', 'dg-style', get_template_directory() . '/languages' );
    wp_register_style( 'site_builder_css', $directory_url . '/wp-admin/site_builder/site_builder.css?ver=' . $site_update_time );
    wp_register_style( 'dg_color_picker', $directory_url . '/wp-admin/site_builder/color-picker.css?ver=' . $site_update_time );
    wp_enqueue_style( 'dg_slider_css' );
    wp_enqueue_style( 'site_builder_css' );
    wp_enqueue_style( 'dg_color_picker' );
    add_action( 'admin_enqueue_scripts', 'dg_mirror_editor' );
}
function dg_mirror_editor() {
    wp_enqueue_script( 'wp-codemirror' );
    $code = array();
    $code[ 'dg_html_editor' ] = wp_enqueue_code_editor( array( 'type' => 'text/html' ) );
    wp_localize_script( 'jquery', 'dg_code_mirror_code', $code );
    wp_enqueue_script( 'wp-theme-plugin-editor' );
    wp_enqueue_style( 'wp-codemirror' );
}

/* ----------------------------------------------------------
 * サイトビルダーページ
---------------------------------------------------------- */
function site_builder_page() {
    if ( !is_user_logged_in() || ( !current_user_can( 'administrator' ) && !current_user_can( 'editor' ) ) ) {
        return false;
    }
    $creds_url = wp_nonce_url( 'admin.php?page=site_builder' );
    if ( false === ( $creds = request_filesystem_credentials( $creds_url, '', false, false, null ) ) ) {
        return false;
    }
    require_once( ABSPATH . 'wp-admin/includes/file.php' );
    //デザイン呼び出し
    $site_design = get_option( 'DG_site_design' );
    if ( $site_design === false ) {
        $site_design = 'default';
    }
    $upload_dir = wp_upload_dir();
    $directory_path = $upload_dir[ 'basedir' ];
    //最初のデザイン値呼び出し
    if ( $site_design === 'default' ) {
        $design_path = $directory_path . '/design-json/default.json';
        if ( !is_file( $design_path ) ) {
            first_dg_style_design_setting();
        }
    } else {
        $design_path = $directory_path . '/design-json/' . $site_design . '.json';
    }
    if ( !is_file( $design_path ) && WP_Filesystem( $creds ) ) {
        save_new_site_design( 'default' );
        $site_design = 'default';
    }
    //デバイス取得
    $current_device = 'sp';
    $device_option = get_option( 'DG_device_value', '' );
    $device = array( 320 => 'sp', 560 => 'tb', 960 => 'pc' );
    if ( $device_option !== '' ) {
        $device = json_decode( $device_option, true );
    }
    if ( is_array( $device ) && count( $device ) > 0 ) {
        $cnt = 0;
        foreach( (array)$device as $size => $type ) {
            if ( $cnt === 0 ) {
                $current_device = $type;
            }
            ++$cnt;
        }
    }
    $summary = array( 'page_type' => 'site-builder', 'site_design' => $site_design, 'current_device' => $current_device, 'device_option' => $device_option, 'device' => $device, );
    echo site_builder_page_content( $summary );
}

function site_builder_page_content( $summary ) {
    extract( $summary );
    //パーツ取得
    $page_list = get_page_types();
    $summary[ 'page_list' ] = $page_list;
    $header_menu = '';
    if ( $page_type === 'site-builder' ) {
        $header_menu = site_builder_header_menu( $site_design, $page_list );
    } else {
        $header_menu = site_builder_lp_header_menu( $site_design, $page_list );
    }
    $main_content = site_builder_main_content( $summary );
    $bug_reporting = site_builder_bug_reporting();
    //翻訳
    $text_download_title = __( 'サイトデザインダウンロード', 'dg-style' );
    $text_upload_title = __( 'サイトデザインアップロード', 'dg-style' );
    $text_upload_caution = __( 'クリップボードにコピーした値を貼り付けて適用してください。', 'dg-style' );
    $text_submit_btn = __( '適用', 'dg-style' );
    $text_cancel_btn = __( '取り消し', 'dg-style' );
    $text_clipboard = __( 'クリップボードにコピーしました。', 'dg-style' );
    return <<< EOM
        <div id="site-builder-container">
            <div id="header-menu">{$header_menu}</div>
            <div id="main-content" class="set-value-area" data-level="{$site_design}" data-page_type="top" data-device="{$current_device}">{$main_content}</div>
            <div id="upload-field-area">
                <button type="button" id="upload-site-design" class="accordion-title" title="{$text_upload_title}"></button>
                <div id="upload-form-area">
                    <div class="window-title">{$text_upload_title}</div>
                    <textarea id="upload-site-design-input" rows="5"></textarea>
                    <div id="uploda-error-message"></div>
                    <p class="caution">※{$text_upload_caution}</p>
                    <div class="upload-btns">
                        <button type="button" id="site-design-upload-sumit" class="upload-btn upload">{$text_submit_btn}</button>
                        <button type="button" id="site-design-upload-cancel" class="upload-btn cancel">{$text_cancel_btn}</button>
                    </div>
                </div>
            </div>
            <button type="button" id="download-site-design" title="{$text_download_title}"></button>
            {$bug_reporting}
            <div id="clipboard-copy-message">{$text_clipboard}</div>
        </div>
EOM;
}

/*
 * バグレポーティング
*/
function site_builder_bug_reporting() {
    $locale = get_locale();
    $language = '';
    if ( $locale === 'ko_KR' ) {
        $language = 'kr';
    } elseif ( $locale === 'ja' ) {
        $language = 'jp';
    } else {
        $language = 'eng';
    }
    $home_url = home_url();
    $email = get_option( 'admin_email' );
    //翻訳
    $text_inquiry_form_title = __( 'お問い合わせフォーム', 'dg-style' );
    $text_inquiry_type_title = __( 'お問い合わせ種類', 'dg-style' );
    $text_required = __( '必須', 'dg-style' );
    $text_name_title = __( 'お名前', 'dg-style' );
    $text_mail_title = __( 'メール', 'dg-style' );
    $text_site_url_title = __( 'サイトURL', 'dg-style' );
    $text_subject_title = __( '件名', 'dg-style' );
    $text_content_title = __( '本文', 'dg-style' );
    $text_characters = __( '80文字以上', 'dg-style' );
    $text_send_btn = __( '送信', 'dg-style' );
    $text_form_btn = __( 'テーマお問い合わせフォームを開く', 'dg-style' );
    $text_type_select1 = __( '選択してください', 'dg-style' );
    $text_type_select2 = __( 'ライセンスについて', 'dg-style' );
    $text_type_select3 = __( 'バグについて', 'dg-style' );
    $text_type_select4 = __( 'ご意見・ご要望', 'dg-style' );
    $text_type_select5 = __( 'テーマに関する質問', 'dg-style' );
    $text_type_select6 = __( 'その他', 'dg-style' );
    $text_caution1 = __( '「DG-STYLE」関連のお問い合わせのみ受け付けしております。', 'dg-style' );
    $text_caution2 = __( '問い合わせ内容に関するご返信は、3～14営業日ほどかかる場合があります。', 'dg-style' );
    $text_caution3 = __( 'また、営業の連絡などお問い合わせではない内容の場合はご返信致しませんのでご注意ください。', 'dg-style' );
    $text_caution4 = __( '良かったら利用後の', 'dg-style' );
    $text_caution5 = __( 'アンケート', 'dg-style' );
    $text_caution6 = __( 'にご協力お願い致します。', 'dg-style' );
    
    return <<< EOM
        <div id="bug-reporting-area">
            <button type="button" class="accordion-title" id="open-reporting-form-btn" title="{$text_form_btn}"></button>
            <div class="reporting-form-area">
                <div class="reporting-title">{$text_inquiry_form_title}</div>
                <table class="reporting-form">
                    <tbody>
                        <tr>
                            <th>{$text_inquiry_type_title}<span class="caution">（{$text_required}）</span></th>
                            <td>
                                <select class="reporting-input reporting-type-input" data-level="type">
                                    <option value="">{$text_type_select1}</option>
                                    <option value="license">{$text_type_select2}</option>
                                    <option value="bug">{$text_type_select3}</option>
                                    <option value="want">{$text_type_select4}</option>
                                    <option value="faq">{$text_type_select5}</option>
                                    <option value="other">{$text_type_select6}</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th>{$text_name_title}<span class="caution">（{$text_required}）</span></th>
                            <td><input type="text" class="reporting-input reporting-name-input" data-level="name"></td>
                        </tr>
                        <tr>
                            <th>{$text_mail_title}</th>
                            <td><input type="email" class="reporting-input" data-level="mail" value="{$email}"></td>
                        </tr>
                        <tr>
                            <th>{$text_site_url_title}</th>
                            <td><input type="text" class="reporting-input" data-level="url" value="{$home_url}"></td>
                        </tr>
                        <tr>
                            <th>{$text_subject_title}<span class="caution">（{$text_required}）</span></th>
                            <td><input type="text" class="reporting-input reporting-subject-input" data-level="subject"></td>
                        </tr>
                        <tr>
                            <th>{$text_content_title}<span class="caution">（{$text_required}）</span></th>
                            <td>
                                <p class="caution">※{$text_characters}</p>
                                <textarea rows="4" class="reporting-input reporting-content-input" data-level="content"></textarea>
                                <input type="hidden" class="reporting-input" data-level="language" value="{$language}">
                            </td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" id="send-reporting-btn">{$text_send_btn}</button>
                <p class="caution">※{$text_caution1}<br>※{$text_caution1}<br>{$text_caution3}</p>
                <p>{$text_caution4}「<a href="http://info.dg-style.net/" target="_blank" id="worksheet-link">{$text_caution5}</a>」{$text_caution6}</p>
            </div>
        </div>
EOM;
}

/*
 * 左メニュー
*/
function site_builder_header_menu( $site_design, $page_list ) {
    $license_key = get_option( 'DG_license_key', '' );
    $license_type = get_option( 'DG_license_type', '' );
    
    //定義
    $admin_url = admin_url();
    $design_list = site_design_select_list( $site_design, $license_key, $license_type );
    $page_list_option = '';
    foreach( (array)$page_list as $key => $value ) {
        if ( $key === 'top' ) {
            $page_list_option .= '<option value="top">' . __( 'TOPページ', 'dg-style' ) . '</option>';
        } else {
            if ( $key === 'taxonomy' ) {
                $label = __( 'カテゴリー種類', 'dg-style' );
            } elseif ( $key === 'custom-post-archive' ) {
                $label = __( '記事タイプ種類', 'dg-style' );
            } elseif ( $key === 'single' ) {
                $label = __( '記事種類', 'dg-style' );
            } elseif ( $key === 'other' ) {
                $label = __( 'その他', 'dg-style' );
            }
            $page_list_option .= '<optgroup label="' . $label . '">';
            foreach( (array)$value as $slug => $name ) {
                if ( $key === 'other' ) {
                    $page_list_option .= '<option value="' . $slug . '">' . $name . '</option>';
                } else {
                    $page_list_option .= '<option value="' . $key . '-' . $slug . '">' . $name . '</option>';
                }
            }
            $page_list_option .= '</optgroup>';
        }
    }
    $search_page_list = site_search_page_list_content();
    //翻訳
    $text_save_btn_title = __( '変更を保存', 'dg-style' );
    $text_save_btn = __( '保存', 'dg-style' );
    $text_page_type_select_title = __( '指定ページに移動', 'dg-style' );
    $text_release_panel_title = __( '現在デザインで公開する', 'dg-style' );
    $text_release_panel_status = __( '公開中', 'dg-style' );
    $text_select_panel_title = __( '編集中のデザイン名', 'dg-style' );
    $text_select_panel_status = __( '編集中', 'dg-style' );
    $text_design_select_btn_title = __( 'サイトデザインリストを表示', 'dg-style' );
    $text_design_select_btn = __( 'デザイン選択', 'dg-style' );
    $text_template_select_btn_title = __( 'サイトデザインテンプレートリストを表示', 'dg-style' );
    $text_template_select_btn = __( 'テンプレート', 'dg-style' );
    $text_comparison_select_btn_title = __( '現在公開しているデザインと編集中のデザインを比較する', 'dg-style' );
    $text_comparison_select_btn = __( '公開デザインと比較', 'dg-style' );
    $text_hide_btn_title = __( '各ボタンを非表示にする', 'dg-style' );
    $text_hide_btn = __( 'ボタン非表示', 'dg-style' );
    $text_close_btn_title = __( 'サイトビルダーを終了', 'dg-style' );
    
    $disabled = '';
    if ( $license_key === '' && $license_type === '' ) {
        $disabled = ' disabled';
        $text_design_select_btn_title = __( '無料版では利用できません。', 'dg-style' );
    }
    return <<< EOM
        <div class="header-menu-list">
            <button type="button" id="site-design-save-btn" class="site-builder-save-btn none-confrim-area close-pass" title="{$text_save_btn_title}">{$text_save_btn}</button>
            <select id="site-moving-page-select" class="page-type-list" title="{$text_page_type_select_title}">{$page_list_option}</select>
            <div class="search-page-type">
                <button type="button" class="search-page-btn accordion-title"></button>
                {$search_page_list}
            </div>
            <button type="button" id="release-design-panel" class="release-design design-status-area select" title="{$text_release_panel_title}">
                <span class="status-type">{$text_release_panel_status}</span>
                <span id="current-design-name" class="design-name">{$site_design}</span>
            </button>
            <div id="select-design-panel" class="select-design design-status-area" title="{$text_select_panel_title}">
                <span class="status-type">{$text_select_panel_status}</span>
                <span id="selected-design-name" class="design-name">{$site_design}</span>
            </div>
            <button type="button" id="site-design-menu-btn" class="design-select-btn" title="{$text_design_select_btn_title}"{$disabled}>{$text_design_select_btn}</button>
            <button type="button" id="template-design-menu-btn" class="template-select-btn" title="{$text_template_select_btn_title}">{$text_template_select_btn}</button>
            <button type="button" id="site-design-comparison-btn" class="design-comparison-btn" title="{$text_comparison_select_btn_title}">{$text_comparison_select_btn}</button>
            <button type="button" id="hide-setting-btns" title="{$text_hide_btn_title}">{$text_hide_btn}</button>
        </div>
        <a id="page-close-btn" class="back-wp-admin-btn none-confrim-area" href="{$admin_url}" title="{$text_close_btn_title}"></a>
        {$design_list}
        <div id="site-template-list">
            <div id="site-template-labels" class="site-template-labels"></div>
            <div id="select-template-list"></div>
            <input type="hidden" id="template-site-design-value">
        </div>
EOM;
}

/*
 * 右コンテンツ
*/
function site_builder_main_content( $summary ) {
    extract( $summary );
    $stylesheet_url = get_template_directory_uri();
    //パーツリスト配列
    $part_list = array(
        'area' => array(
            'type' => 'all',
            'name' => __( 'エリア追加', 'dg-style' ),
        ),
        'text' => array(
            'type' => 'all',
            'name' => __( 'テキスト', 'dg-style' ),
        ),
        'image' => array(
            'type' => 'all',
            'name' => __( 'イメージ', 'dg-style' ),
        ),
        'html' => array(
            'type' => 'all',
            'name' => 'HTML',
        ),
        'movie' => array(
            'type' => 'all',
            'name' => __( '動画', 'dg-style' ),
        ),
        'music' => array(
            'type' => 'all',
            'name' => __( '音楽', 'dg-style' ),
        ),
        'gmenu' => array(
            'type' => 'all',
            'name' => __( 'グローバルメニュー', 'dg-style' ),
        ),
        'post_list' => array(
            'type' => 'all',
            'name' => __( '記事リスト', 'dg-style' ),
        ),
        'breadcrumb' => array(
            'type' => 'all',
            'name' => __( 'パンくずリスト', 'dg-style' ),
        ),
        'search-form' => array(
            'type' => 'all',
            'name' => __( '検索フォーム', 'dg-style' ),
        ),
        'sns' => array(
            'type' => 'all',
            'name' => __( 'SNSボタン', 'dg-style' ),
        ),
        'categories' => array(
            'type' => 'all',
            'name' => __( 'カテゴリーリスト', 'dg-style' ),
        ),
        'tag-cloud' => array(
            'type' => 'all',
            'name' => __( 'タグクラウド', 'dg-style' ),
        ),
        'archive' => array(
            'type' => 'all',
            'name' => __( 'アーカイブ', 'dg-style' ),
        ),
        'new-comments' => array(
            'type' => 'all',
            'name' => __( '最新コメント', 'dg-style' ),
        ),
        'author' => array(
            'type' => 'all',
            'name' => __( '作成者プロフィール', 'dg-style' ),
        ),
        'post-content' => array(
            'type' => 'all',
            'name' => __( '記事コンテンツ', 'dg-style' ),
        ),
        'contact' => array(
            'type' => 'all',
            'name' => __( 'お問い合わせフォーム', 'dg-style' ),
        ),
        'site-views' => array(
            'type' => 'all',
            'name' => __( 'サイトViews', 'dg-style' ),
        ),
    );
    if ( $page_type !== 'lp' ) {
        $part_list2 = array(
            'taxonomy-title' => array(
                'type' => 'taxonomy',
                'name' => __( '一覧ページタイトル', 'dg-style' ),
            ),
            'taxonomy-thumbnail' => array(
                'type' => 'taxonomy',
                'name' => __( '一覧ページサムネイル', 'dg-style' ),
            ),
            'taxonomy-movie' => array(
                'type' => 'taxonomy',
                'name' => __( '一覧ページ動画サムネイル', 'dg-style' ),
            ),
            'taxonomy-description' => array(
                'type' => 'taxonomy',
                'name' => __( '一覧ページ説明文', 'dg-style' ),
            ),
            'taxonomy-brother' => array(
                'type' => 'taxonomy',
                'name' => __( '一覧ページ兄弟タクソノミー', 'dg-style' ),
            ),
            'taxonomy-child' => array(
                'type' => 'taxonomy',
                'name' => __( '一覧ページ子タクソノミー', 'dg-style' ),
            ),
            'taxonomy-sort' => array(
                'type' => 'taxonomy',
                'name' => __( '一覧ページ並び替え', 'dg-style' ),
            ),
            'taxonomy-post_list' => array(
                'type' => 'taxonomy',
                'name' => __( '一覧ページ記事リスト', 'dg-style' ),
            ),
            'taxonomy-paging' => array(
                'type' => 'taxonomy',
                'name' => __( '一覧ページページング', 'dg-style' ),
            ),
            'taxonomy-page_count' => array(
                'type' => 'taxonomy',
                'name' => __( '一覧ページページカウント', 'dg-style' ),
            ),
            'taxonomy-user_sns' => array(
                'type' => 'taxonomy',
                'name' => __( '作成者ページSNS・連絡先', 'dg-style' ),
            ),
            'single-title' => array(
                'type' => 'single',
                'name' => __( '記事タイトル', 'dg-style' ),
            ),
            'single-thumbnail' => array(
                'type' => 'single',
                'name' => __( '記事サムネイル', 'dg-style' ),
            ),
            'single-movie' => array(
                'type' => 'single',
                'name' => __( '記事動画サムネイル', 'dg-style' ),
            ),
            'single-date' => array(
                'type' => 'single',
                'name' => __( '記事日付', 'dg-style' ),
            ),
            'single-taxonomy' => array(
                'type' => 'single',
                'name' => __( '記事タクソノミー', 'dg-style' ),
            ),
            'single-author' => array(
                'type' => 'single',
                'name' => __( '記事作成者', 'dg-style' ),
            ),
            'single-views' => array(
                'type' => 'single',
                'name' => __( '記事Views', 'dg-style' ),
            ),
            'single-index' => array(
                'type' => 'single',
                'name' => __( '記事目次', 'dg-style' ),
            ),
            'single-evaluate' => array(
                'type' => 'single',
                'name' => __( '記事評価', 'dg-style' ),
            ),
            'single-content' => array(
                'type' => 'single',
                'name' => __( '記事本文', 'dg-style' ),
            ),
            'single-paging' => array(
                'type' => 'single',
                'name' => __( '記事ページング', 'dg-style' ),
            ),
            'single-comment' => array(
                'type' => 'single',
                'name' => __( '記事コメント', 'dg-style' ),
            ),
            'single-recommend' => array(
                'type' => 'single',
                'name' => __( '関連記事リスト', 'dg-style' ),
            ),
            'single-bookmark' => array(
                'type' => 'single',
                'name' => __( 'ブックマークボタン', 'dg-style' ),
            ),
            'single-postmeta' => array(
                'type' => 'single',
                'name' => __( 'カスタムフィールド', 'dg-style' ),
            ),
        );
        $part_list = array_merge( $part_list, $part_list2 );
    }
    $text_favicon_menu = __( 'Favicon＆PWA設定', 'dg-style' );
    //LP作成の場合はMETAフォームに変更
    if ( $page_type === 'lp' ) {
        $text_favicon_menu = __( 'カスタムMETA', 'dg-style' );
    }
    $option_list = array(
        'logo' => array(
            'type' => 'logo',
            'name' => __( 'ロゴ設定', 'dg-style' ),
        ),
        'color' => array(
            'type' => 'color',
            'name' => __( 'カラー設定', 'dg-style' ),
        ),
        'device' => array(
            'type' => 'device',
            'name' => __( 'デバイス設定', 'dg-style' ),
        ),
        'fixed' => array(
            'type' => 'fixed',
            'name' => __( '固定サムネイル設定', 'dg-style' ),
        ),
        'noimage' => array(
            'type' => 'noimage',
            'name' => __( 'No-image設定', 'dg-style' ),
        ),
        'loading' => array(
            'type' => 'loading',
            'name' => __( 'Loading-image設定', 'dg-style' ),
        ),
        'font' => array(
            'type' => 'font',
            'name' => __( 'フォント設定', 'dg-style' ),
        ),
        'favicon' => array(
            'type' => 'favicon',
            'name' => $text_favicon_menu,
        ),
    );
    
    //記事タイプ別　カスタムフィールド取得
    $field_list = get_option( 'DG_postmeta_list', '' );
    if ( $field_list === '' ) {
        $field_list = save_postmeta_list_value();
        $field_list = implode( ',', $field_list );
    }
    //翻訳
    $text_image_tag_size = __( 'イメージタグサイズ', 'dg-style' );
    $text_add_page_link = __( 'リンク追加', 'dg-style' );
    $text_add_class = __( 'Class追加', 'dg-style' );
    $text_movie_caution = __( 'サムネイルイメージが動画サムネイルとして利用されます。', 'dg-style' );
    $text_select_tags = __( 'タグ設定', 'dg-style' );
    $text_word_count = __( '文字数', 'dg-style' );
    $text_abbreviations = __( '省略文字', 'dg-style' );
    $text_placeholder_example = __( '例）', 'dg-style' );
    $text_text_title = __( 'テキスト', 'dg-style' );
    //記事リスト用配列
    $item_list = array(
        'thumbnail' => array(
            'name' => __( 'サムネイル', 'dg-style' ),
            'options' => array(
                'thumbnail-size' => array( 'title' => __( 'サイズ', 'dg-style' ), 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_image_tag_size, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_add_page_link, 'type' => 'check', 'insert' => true, ),
                'link-type' => array( 'title' => __( 'リンク種類', 'dg-style' ), 'type' => 'select', 'list2' => array( '' => __( '記事URL', 'dg-style' ), '1' => __( 'イメージURL', 'dg-style' ), ), ),
                'caution' => array( 'type' => 'caution', 'content' => '※' . __( 'イメージURLの場合、LIGHTBOXが設定されます', 'dg-style' ), ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'movie' => array(
            'name' => __( '動画サムネイル', 'dg-style' ),
            'options' => array(
                'caution' => array( 'type' => 'caution', 'content' => '※' . $text_movie_caution, ),
                'thumbnail-size' => array( 'title' => __( '動画サムネイルサイズ', 'dg-style' ), 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_image_tag_size, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_add_page_link, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'fixed' => array(
            'name' => __( '固定サムネイル', 'dg-style' ),
            'options' => array(
                'thumbnail-size' => array( 'title' => __( 'サイズ', 'dg-style' ), 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_image_tag_size, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_add_page_link, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'title' => array(
            'name' => __( 'タイトル', 'dg-style' ),
            'options' => array(
                'tag' => array( 'title' => $text_select_tags, 'type' => 'select', 'list' => 'h2,h3,h4,h5,h6,strong,div,span,p', 'insert' => true, ),
                'count' => array( 'title' => $text_word_count, 'type' => 'number', 'insert' => true, ),
                'after' => array( 'title' => $text_abbreviations, 'type' => 'text', 'placeholder' => $text_placeholder_example . ' …', 'insert' => true, ),
                'link' => array( 'title' => $text_add_page_link, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'content' => array(
            'name' => __( '本文', 'dg-style' ),
            'options' => array(
                'count' => array( 'title' => $text_word_count, 'type' => 'number', 'insert' => true, ),
                'after' => array( 'title' => $text_abbreviations, 'type' => 'text', 'placeholder' => $text_placeholder_example . ' read more', 'insert' => true, ),
                'link' => array( 'title' => $text_add_page_link, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'date' => array(
            'name' => __( '日付', 'dg-style' ),
            'options' => array(
                'tag' => array( 'title' => $text_select_tags, 'type' => 'select', 'list' => 'time,strong,div,span,p', 'insert' => true, ),
                'type' => array( 'title' => __( '表示日', 'dg-style' ), 'type' => 'select', 'list2' => array( 'date' => __( '公開日', 'dg-style' ), 'update' => __( '更新日', 'dg-style' ), ), ),
                'format' => array( 'title' => __( '日付フォーマット', 'dg-style' ), 'type' => 'text', 'placeholder' => $text_placeholder_example . ' ' . __( 'Y年m月d日', 'dg-style' ), ),
                'days' => array( 'title' => __( '日数表示', 'dg-style' ), 'type' => 'check', ),
                'caution' => array( 'type' => 'caution', 'content' => '※' . __( '指定した期間内の場合日数で表示します。例）3日前', 'dg-style' ), ),
                'terms' => array( 'title' => __( '条件設定', 'dg-style' ), 'type' => 'unit', 'text' => array( 'type' => 'number', 'placeholder' => '7' ), 'select1' => array( 'day' => __( '日内', 'dg-style' ), 'week' => __( '週内', 'dg-style' ), 'month' => __( 'ヵ月内', 'dg-style' ), 'all' => __( 'すべて', 'dg-style' ), ), ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'author' => array(
            'name' => __( '作成者', 'dg-style' ),
            'options' => array(
                'link' => array( 'title' => $text_add_page_link, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'author_image' => array(
            'name' => __( '作成者イメージ', 'dg-style' ),
            'options' => array(
                'type' => array( 'title' => __( 'イメージ種類', 'dg-style' ), 'type' => 'select', 'list2' => array( 'user_image' => __( 'ユーザーイメージ', 'dg-style' ), 'bg_image' => __( '背景イメージ', 'dg-style' ), ), ),
                'thumbnail-size' => array( 'title' => __( 'サイズ', 'dg-style' ), 'type' => 'select', 'list' => 'thumbnail,medium,large,full', 'insert' => true, ),
                'image-size' => array( 'title' => $text_image_tag_size, 'type' => 'size', 'insert' => true, ),
                'link' => array( 'title' => $text_add_page_link, 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'views' => array(
            'name' => __( '記事View数', 'dg-style' ),
            'options' => array(
                'type' => array( 'title' => __( '表示する期間', 'dg-style' ), 'type' => 'select', 'list2' => array( 'views' => __( '全体', 'dg-style' ), 'w_views' => __( '週間', 'dg-style' ), 'm_views' => __( '月間', 'dg-style' ), 'y_views' => __( '年間', 'dg-style' ), ), ),
                'text' => array( 'title' => __( '単位', 'dg-style' ), 'type' => 'text', 'placeholder' => $text_placeholder_example . ' view', 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'evaluate' => array(
            'name' => __( '評価', 'dg-style' ),
            'options' => array(
                'text' => array( 'title' => $text_text_title, 'type' => 'evaluate' ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'comment' => array(
            'name' => __( 'コメント数', 'dg-style' ),
            'options' => array(
                'text' => array( 'title' => $text_text_title, 'type' => 'text', 'placeholder' => $text_placeholder_example . ' comments', 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'sns' => array(
            'name' => __( 'SNSボタン', 'dg-style' ),
            'options' => array(
                'facebook' => array( 'title' => 'facebook', 'type' => 'check', 'insert' => true, ),
                'twitter' => array( 'title' => 'twitter', 'type' => 'check', 'insert' => true, ),
                'line' => array( 'title' => 'line', 'type' => 'check', 'insert' => true, ),
                'pocket' => array( 'title' => 'pocket', 'type' => 'check', 'insert' => true, ),
                'tumblr' => array( 'title' => 'tumblr', 'type' => 'check', 'insert' => true, ),
                'hatebu' => array( 'title' => 'hatebu', 'type' => 'check', 'insert' => true, ),
                'pinterest' => array( 'title' => 'pinterest', 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'new' => array(
            'name' => __( 'Newマーク', 'dg-style' ),
            'options' => array(
                'text' => array( 'title' => $text_text_title, 'type' => 'text', 'placeholder' => 'New', 'insert' => true, ),
                'caution' => array( 'type' => 'caution', 'content' => '※' . __( '空白も可', 'dg-style' ), ),
                'terms' => array( 'title' => __( '条件設定', 'dg-style' ), 'type' => 'unit', 'text' => array( 'type' => 'number', 'placeholder' => '3' ), 'select1' => array( 'day' => __( '日内', 'dg-style' ), 'week' => __( '週内', 'dg-style' ), 'month' => __( 'ヵ月内', 'dg-style' ), ), 'select2' => array( 'date' => __( '公開日基準', 'dg-style' ), 'update' => __( '更新日基準', 'dg-style' ), ), ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'hot' => array(
            'name' => __( '今注目', 'dg-style' ),
            'options' => array(
                'text' => array( 'title' => $text_text_title, 'type' => 'text', 'placeholder' => 'Topic', 'insert' => true, ),
                'caution' => array( 'type' => 'caution', 'content' => '※' . __( '空白も可', 'dg-style' ), ),
                'type' => array( 'title' => __( '参照元', 'dg-style' ), 'type' => 'select', 'list2' => array( 'views' => __( '全体', 'dg-style' ), 'w_views' => __( '週間', 'dg-style' ), 'm_views' => __( '月間', 'dg-style' ), 'y_views' => __( '年間', 'dg-style' ), ), ),
                'count' => array( 'title' => __( '基準値', 'dg-style' ), 'type' => 'number', 'placeholder' => '1000', ),
                'caution2' => array( 'type' => 'caution', 'content' => '※' . __( '指定した参照元の数値が基準値以上の場合表示されます。', 'dg-style' ), ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'bookmark' => array(
            'name' => __( 'ブックマークボタン', 'dg-style' ),
            'options' => array(
                'text' => array( 'title' => $text_text_title, 'type' => 'text', 'placeholder' => __( 'ブックマーク', 'dg-style' ), 'insert' => true, ),
                'caution' => array( 'type' => 'caution', 'content' => '※' . __( '空白も可', 'dg-style' ), ),
                'count' => array( 'title' => __( 'ブックマーク数表示', 'dg-style' ), 'type' => 'check', 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
            ),
        ),
        'more' => array(
            'name' => __( 'ページリンク', 'dg-style' ),
            'options' => array(
                'text' => array( 'title' => $text_text_title, 'type' => 'text', 'placeholder' => __( 'もっと見る', 'dg-style' ), 'insert' => true, ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
                'link-type' => array( 'title' => __( 'リンク種類', 'dg-style' ), 'type' => 'select', 'list2' => array( '' => __( '記事URL', 'dg-style' ), '2' => __( 'リアルタイム記事取得', 'dg-style' ), ), ),
            ),
        ),
        'postmeta' => array(
            'name' => __( 'カスタムフィールド', 'dg-style' ),
            'options' => array(
                'type' => array( 'title' => __( 'カスタムフィールド選択', 'dg-style' ), 'type' => 'select', 'list' => $field_list, 'class' => 'postmeta-select-input' ),
                'caution' => array( 'type' => 'caution', 'content' => '※' . ' <button type="button" class="update-postmeta-list">' . __( 'リスト更新', 'dg-style' ) . '</button>', ),
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
                'tag' => array( 'title' => $text_select_tags, 'type' => 'text', 'placeholder' => 'divなど', 'insert' => true, ),
                'attr' => array( 'title' => __( '属性指定', 'dg-style' ), 'type' => 'text', 'placeholder' => __( '文字表示の場合は空欄', 'dg-style' ), 'insert' => true, ),
                'caution2' => array( 'type' => 'caution', 'content' => '※' . __( 'hrefやsrcなどカスタムフィールドを適用したいHTML属性を指定', 'dg-style' ), ),
                'subtext' => array( 'title' => __( '代用テキスト', 'dg-style' ), 'type' => 'text', 'placeholder' => '', 'insert' => true, ),
                'caution3' => array( 'type' => 'caution', 'content' => '※' . __( 'hrefなどカスタムフィールドを属性に設定した場合、代用テキストで文字を表示できます', 'dg-style' ), ),
            ),
        ),
        'tax-category' => array(
            'name' => __( 'カテゴリー', 'dg-style' ),
            'options' => array(
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
                'count' => array( 'title' => __( '表示数', 'dg-style' ), 'type' => 'number', 'insert' => true, ),
            ),
        ),
        'tax-post_tag' => array(
            'name' => __( 'タグ', 'dg-style' ),
            'options' => array(
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
                'count' => array( 'title' => __( '表示数', 'dg-style' ), 'type' => 'number', 'insert' => true, ),
            ),
        ),
    );
    $tax_labels = '';
    $taxonomise = default_taxonomy_exclusion();
    foreach( (array)$taxonomise as $tax ) {
        $taxonomy = get_taxonomy( $tax );
        $item_list[ 'tax-' . $tax ] = array(
            'name' => $taxonomy->label,
            'options' => array(
                'class' => array( 'title' => $text_add_class, 'type' => 'text', 'placeholder' => 'part-01', 'insert' => true, ),
                'count' => array( 'title' => __( '表示数', 'dg-style' ), 'type' => 'number', 'insert' => true, ),
            ),
        );
        $tax_labels .= <<< EOM
            <li class="term-item">
                <div class="term-names">
                    <label class="term-label"><input type="checkbox" class="term-input" value="{$tax}">{$taxonomy->label}</label>
                </div>
            </li>
EOM;
    }
    
    //デバイス取得
    $text_device_width = __( '横幅', 'dg-style' );
    
    $device_list = '';
    if ( is_array( $device ) && count( $device ) > 0 ) {
        $cnt = 0;
        foreach( (array)$device as $size => $type ) {
            $on_class = '';
            if ( $cnt === 0 ) {
                $on_class = ' on';
            }
            $label = $type;
            $type_class = preg_replace( '/[0-9]{0,}/s', '', $type );
            $device_list .= '<div class="device-btn ' . $type_class . $on_class . '" data-device="' . $label . '" title="横幅' . $size . '"></div>';
            ++$cnt;
        }
    } else {
        $device_list = <<< EOM
            <div class="device-btn sp on" data-device="sp" title="{$text_device_width}320"></div>
            <div class="device-btn tb" data-device="tb" title="{$text_device_width}560"></div>
            <div class="device-btn pc" data-device="pc" title="{$text_device_width}960"></div>
EOM;
    }
    //共通オプション
    $upload_dir = wp_upload_dir();
    $directory_path = $upload_dir[ 'basedir' ];
    $design_path = $directory_path . '/design-json/template/color.json';
    $color_input_value = htmlspecialchars( '{"palette":{"palette-1":{"label":"palette01","main":"#E63946","base":"#F1FAEE","text":"#141414","sub1":"#457B9D","sub2":"#1D3557"},"palette-2":{"label":"palette02","main":"#14213D","base":"#fff","text":"#000","sub1":"#FCA311","sub2":"#E5E5E5"},"palette-3":{"label":"palette03","main":"#f4acb7","base":"#ffe5d9","text":"#474747","sub1":"#d8e2dc","sub2":"#ffcad4"},"palette-4":{"label":"palette04","main":"#2ec4b6","base":"#fdfffc","text":"#011627","sub1":"#e71d36","sub2":"#ff9f1c"},"palette-5":{"label":"palette05","main":"#0a2463","base":"#fffaff","text":"#1e1b18","sub1":"#3e92cc","sub2":"#d8315b"},"palette-6":{"label":"palette06","main":"#ff6b35","base":"#efefd0","text":"#141414","sub1":"#f7c59f","sub2":"#004e89"},"palette-7":{"label":"palette07","main":"#c0b9dd","base":"#f7f4ea","text":"#141414","sub1":"#80a1d4","sub2":"#75c9c8"}},"select":"palette-1","colorset":{"color-1":{"color":"#fff","name":"white"},"color-2":{"color":"#000","name":"black"},"color-3":{"color":"#ccc","name":"gray"},"color-4":{"color":"#11abe8","name":"link"},"color-5":{"color":"#e81311","name":"active"},"color-6":{"color":"#e411e8","name":"visited"},"color-7":{"color":"#f3f2f2","name":"white-gray"},"color-8":{"color":"rgba(255,255,255,0.3)","name":"\u767d\u900f\u660e"},"color-9":{"color":"#1DA1F2","name":"twitter"},"color-10":{"color":"#3B5998","name":"facebook"},"color-11":{"color":"#BD081C","name":"pinterest"},"color-12":{"color":"#00c300","name":"line"},"color-13":{"color":"rgba(0,0,0,0.8)","name":"\u900f\u660e\u9ed2"},"color-14":{"color":"#00a4de","name":"hatebu"},"color-15":{"color":"#9d9d9d","name":"dark-gray"},"color-16":{"color":"#ef4155","name":"pocket"},"color-17":{"color":"#011835","name":"tumblr"}}}', ENT_QUOTES, 'UTF-8' );
    $color_value = json_decode( htmlspecialchars_decode( $color_input_value ), true );
    $logo_option_value = '';
    $logo_value = false;
    if ( $page_type !== 'lp' ) {
        //ロゴ
        $logo_option = get_option( 'DG_logo_value' );
        if ( $logo_option !== false ) {
            $logo_value = json_decode( $logo_option, true );
            $logo_option_value = wp_unslash( htmlspecialchars( $logo_option, ENT_QUOTES, 'UTF-8' ) );
        }
        
        //カラー
        if ( is_file( $design_path ) ) {
            global $wp_filesystem;
            $part_file = $wp_filesystem->get_contents( $design_path );
            $color_input_value = htmlspecialchars( $part_file, ENT_QUOTES, 'UTF-8' );
            $color_value = json_decode( $part_file, true );
        }
    }
    
    //パーツウィンドー
    $none_display_windows = window_add_new_part( $part_list, $page_type );
    $none_display_windows .= window_site_option( $option_list );
    $none_display_windows .= window_animation_design();
    $none_display_windows .= window_part_map();
    $none_display_windows .= window_simple_design_menus( $page_list );
    $none_display_windows .= window_site_builder_manual();
    $none_display_windows .= window_site_builder_history();
    $none_display_windows .= window_part_option_menus();
    $none_display_windows .= window_css_total( $page_list, $device_list, $page_type );
    $none_display_windows .= option_part_template_window( $part_list );
    $none_display_windows .= window_design_setting( $page_list, $device_list, $current_device );
    $none_display_windows .= create_css_selector_option();
    $none_display_windows .= window_dark_mode_setting();
    if ( $page_type === 'lp' ) {
        $none_display_windows .= common_window_custom_meta( $site_design );
    } else {
        $none_display_windows .= common_window_favion( $color_value );
    }
    $none_display_windows .= option_window_search_page_link();
    $none_display_windows .= option_window_part_event();
    $none_display_windows .= option_window_add_area();
    $none_display_windows .= option_window_select_area();
    $none_display_windows .= option_window_moving_area_list();
    $none_display_windows .= option_window_part_slide( $device_list );
    $none_display_windows .= option_window_post_list( $item_list );
    $none_display_windows .= option_window_part_name_edit();
    $none_display_windows .= option_window_part_title();
    $none_display_windows .= option_window_gmenu( $item_list );
    $none_display_windows .= option_window_sns_btn();
    $none_display_windows .= option_window_breadcrumb( $page_list );
    $none_display_windows .= option_window_search_form( $item_list );
    $none_display_windows .= option_window_html();
    $none_display_windows .= option_window_movie();
    $none_display_windows .= option_window_music();
    $none_display_windows .= option_window_categories();
    $none_display_windows .= option_window_tag_cloud();
    $none_display_windows .= option_window_archive();
    $none_display_windows .= option_window_new_comments();
    $none_display_windows .= option_window_author();
    $none_display_windows .= option_window_post_content();
    $none_display_windows .= option_window_contact();
    $none_display_windows .= option_window_site_views();
    $none_display_windows .= option_window_taxonomy_title( $page_list );
    $none_display_windows .= option_window_taxonomy_description();
    $none_display_windows .= option_window_taxonomy_thumbnail();
    $none_display_windows .= option_window_taxonomy_movie();
    $none_display_windows .= option_window_taxonomy_page_count();
    $none_display_windows .= option_window_taxonomy_brother();
    $none_display_windows .= option_window_taxonomy_child();
    $none_display_windows .= option_window_taxonomy_post_list( $item_list );
    $none_display_windows .= option_window_taxonomy_sort();
    $none_display_windows .= option_window_taxonomy_paging();
    $none_display_windows .= option_window_taxonomy_user_sns();
    $none_display_windows .= option_window_single_title();
    $none_display_windows .= option_window_single_index();
    $none_display_windows .= option_window_single_thumbnail();
    $none_display_windows .= option_window_single_movie();
    $none_display_windows .= option_window_single_views();
    $none_display_windows .= option_window_single_date();
    $none_display_windows .= option_window_single_taxonomy();
    $none_display_windows .= option_window_single_evaluate();
    $none_display_windows .= option_window_single_content();
    $none_display_windows .= option_window_single_paging( $item_list );
    $none_display_windows .= option_window_single_comment();
    $none_display_windows .= option_window_single_recommend( $item_list, $tax_labels );
    $none_display_windows .= option_window_single_author();
    $none_display_windows .= option_window_single_bookmark();
    $none_display_windows .= option_window_single_postmeta( $field_list );
    $none_display_windows .= option_window_area();
    $none_display_windows .= option_window_text();
    $none_display_windows .= option_window_image( $logo_value );
    $none_display_windows .= option_window_hidden_page( $page_list, $page_type );
    $none_display_windows .= common_window_logo( $logo_value, $logo_option_value );
    $none_display_windows .= common_window_color( $color_value, $color_input_value );
    $none_display_windows .= common_window_device( $device_option, $device );
    $none_display_windows .= common_window_fixedimage( $page_type );
    $none_display_windows .= common_window_noimage( $page_type );
    $none_display_windows .= common_window_loading_image( $page_type );
    $none_display_windows .= common_window_font( $page_type );
    $none_display_windows .= window_web_icon_list();
    $none_display_windows .= window_tutorial_menu( $stylesheet_url, $page_type );
    $site_builder_nonce = wp_create_nonce( 'site_builder_nonce' );
    
    //翻訳
    $text_add_part_btn_title = __( '各種パーツ追加', 'dg-style' );
    $text_site_option_btn_title = __( '共通オプション設定', 'dg-style' );
    $text_css_anime_btn_title = __( 'CSSアニメーション設定', 'dg-style' );
    $text_css_total_btn_title = __( '独自CSS設定', 'dg-style' );
    $text_part_map_title = __( 'パーツマップ', 'dg-style' );
    $text_tutorial_btn_title = __( 'チュートリアル', 'dg-style' );
    $text_history_btn_title = __( 'ヒストリー', 'dg-style' );
    $text_darkmode_btn_title = __( 'ダークモード切り替え', 'dg-style' );
    $text_reload_simulator_btn_title = __( 'シミュレーターリロード', 'dg-style' );
    $text_none_display_view_btn_title = __( 'CSSでdisplay:noneのパーツを表示', 'dg-style' );
    $text_none_get_param_title = __( 'GETパラメータ入力', 'dg-style' );
    $text_none_get_param_text = __( 'テストでGETパラメータを指定し、GETで非表示したパーツを確認できます。', 'dg-style' );
    $text_empty_area_btn_title = __( '空白エリアの案内テキスト表示切替', 'dg-style' );
    $text_loading_image_btn_title = __( 'ローディングイメージを一時表示する', 'dg-style' );
    $text_switching_view_btn_title = __( '公開中のデザインと切り替え', 'dg-style' );
    $text_simple_design_btn_title = __( '簡単デザイン', 'dg-style' );
    return <<< EOM
        <div class="site-operation-area">
            <button type="button" class="site-operation-btn add-part-btn" id="common-add-part" title="{$text_add_part_btn_title}"></button>
            <button type="button" class="site-operation-btn site-option-btn" id="common-site-option" title="{$text_site_option_btn_title}"></button>
            <button type="button" class="site-operation-btn site-anime-btn" id="common-site-anime" title="{$text_css_anime_btn_title}"></button>
            <button type="button" class="site-operation-btn site-css-total-btn" id="common-original-css" title="{$text_css_total_btn_title}"></button>
            <button type="button" class="site-operation-btn part-map event-cancel" id="open-part-map" title="{$text_part_map_title}" disabled></button>
            <button type="button" class="site-operation-btn site-tutorial-btn" id="open-tutorial-menu" title="{$text_tutorial_btn_title}"><img class="tutorial-image" src="{$stylesheet_url}/image/logo.png"></button>
            <button type="button" class="site-operation-btn site-history-btn" id="common-site-history" title="{$text_history_btn_title}"></button>
            <div class="site-device-select">
                {$device_list}
                <button type="button" id="dark-mode-view" class="dark-mode-view-btn none-confrim-area" title="{$text_darkmode_btn_title}"></button>
                <button type="button" id="reload-simulator" title="{$text_reload_simulator_btn_title}"></button>
                <div id="none-display-area">
                    <button type="button" id="none-display-btn" class="accordion-title none-confrim-area"></button>
                    <div class="none-display-inner">
                        <button type="button" id="none-display-view" title="{$text_none_display_view_btn_title}">display:noneパーツ表示</button>
                        <div class="window-title">{$text_none_get_param_title}</div>
                        <input type="text" id="get-parameter-input" placeholder="aaa=1&test=2">
                        <p class="caution">{$text_none_get_param_text}</p>
                    </div>
                </div>
                <button type="button" id="empty-area-display" title="{$text_empty_area_btn_title}"></button>
                <button type="button" id="loading-image-display" title="{$text_loading_image_btn_title}"></button>
                <button type="button" id="simple-design" title="{$text_simple_design_btn_title}"></button>
                <button type="button" id="switching-view" title="{$text_switching_view_btn_title}"></button>
            </div>
        </div>
        <div class="site-preview-area">
            <div id="site-simulator" class="site-simulator-design" data-level="{$current_device}">
                <div class="simulator-header"></div>
                <div id="simulator-main" class="simulator-main-design">
                    <iframe id="site-simulator-iframe" class="site-simulator-iframe-design"></iframe>
                </div>
                <div class="simulator-footer"></div>
            </div>
        </div>
        <div id="none-display-parts">
        {$none_display_windows}
        </div>
        <input type="hidden" class="set-summary-input" id="site-design-value" value="">
        <input type="hidden" class="set-summary-input" id="site-design-value-original-css" value="">
        <input type="hidden" class="set-summary-input" id="site-design-value-color" value="">
        <input type="hidden" class="set-summary-input" id="site-design-value-font" value="">
        <input type="hidden" class="set-summary-input" id="site-design-value-device" value="">
        <input type="hidden" class="set-summary-input" id="site-design-value-logo" value="">
        <input type="hidden" class="set-summary-input" id="site-design-value-loading" value="">
        <input type="hidden" class="set-summary-input" id="site-design-value-noimage" value="">
        <input type="hidden" class="set-summary-input" id="site-design-value-fixed" value="">
        <input type="hidden" class="set-summary-input" id="site-design-value-animation" value="">
        <input type="hidden" id="extra-site-value-input">
        <input type="hidden" id="extra-site-value-input-temporary">
        <input type="hidden" id="site-builder-nonce" value="{$site_builder_nonce}">
EOM;
}

/* ----------------------------------------------------------
 * デザイン選択
---------------------------------------------------------- */
function site_design_select_list( $main_design, $license_key, $license_type ) {
    //翻訳
    $text_apply_name = __( 'メイン', 'dg-style' );
    $text_enter_design_name = __( 'デザイン名入力', 'dg-style' );
    $text_half_width_text = __( '半角英数字のみ', 'dg-style' );
    //デザインリスト取得
    $DG_abtest_designs_value = '';
    $DG_abtest_designs = get_option( 'DG_abtest_designs', '' );
    if ( $DG_abtest_designs !== '' ) {
        $DG_abtest_designs_value = htmlspecialchars( $DG_abtest_designs );
        $DG_abtest_designs = json_decode( $DG_abtest_designs, true );
    } else {
        $DG_abtest_designs = array();
    }
    $upload_dir = wp_upload_dir();
    $designn_dir = $upload_dir[ 'basedir' ] . '/design-json';
    $design_list = glob( $designn_dir . '/*.json' );
    $site_items = '';
    if ( count( $design_list ) > 0 && $license_key !== '' && $license_type !== '' ) {
        foreach( (array)$design_list as $file ) {
            if ( is_file( $file ) ) {
                $update = filemtime( $file );
                $date = wp_date( 'Y-n-d H:i:s', strval( $update ) );
                $name = basename( $file, ".json" );
                $class = $name === $main_design ? ' select' : '';
                $checked = $name === $main_design ? ' checked' : '';
                $abtest_checked = isset( $DG_abtest_designs[ $name ] ) ? ' checked' : '';
                $abtest_disabled = isset( $DG_abtest_designs[ $name ] ) ? ' disabled' : '';
                $abtext_name = isset( $DG_abtest_designs[ $name ] ) ? $DG_abtest_designs[ $name ] : '';
                $site_items .= <<< EOM
                    <div class="site-design-item select-design-item{$class}" data-name="{$name}">
                        <div class="apply-design-btn-area">
                            <label class="apply-design-select main">
                                <input type="radio" name="apply-design-radio" class="apply-design-radio none-display" value="{$name}"{$checked}>
                                <span class="apply-name">{$text_apply_name}</span>
                            </label>
                            <label class="apply-design-select abtest">
                                <input type="radio" class="abtest-design-radio none-display" value="{$name}"{$abtest_checked}>
                                <span class="apply-name"><span class="text">AB</span><input type="text" class="abtest-name-input" placeholder="ab" value="{$abtext_name}"{$abtest_disabled}></span>
                            </label>
                        </div>
                        <div class="design-name">{$name}</div>
                        <div class="option-btns">
                            <span class="copy-site-design"></span>
                            <span class="delete-site-design"></span>
                        </div>
                        <span class="file-update">Update：{$date}</span>
                    </div>
EOM;
            }
        }
    }
    
    $add_design_btn = <<< EOM
        <div class="site-design-item site-design-add-btn flex">
            <strong class="title">{$text_enter_design_name}</strong>
            <input type="text" class="add-site-design-name">
            <p class="caution">※{$text_half_width_text}</p>
            <button type="button" class="add-icon add-site-design-btn"></button>
        </div>
EOM;
    
    if ( $license_key === '' && $license_type === '' ) {
        $default = glob( $designn_dir . '/default.json' );
        $date = '';
        if ( isset( $default[ 0 ] ) ) {
            $update = filemtime( $default[ 0 ] );
            $date = wp_date( 'Y-n-d H:i:s', strval( $update ) );
        }
        $site_items = <<< EOM
            <div class="site-design-item select-design-item select" data-name="default">
                <div class="apply-design-btn-area">
                    <label class="apply-design-select main">
                        <input type="radio" name="apply-design-radio" class="apply-design-radio none-display" value="default" checked>
                        <span class="apply-name">{$text_apply_name}</span>
                    </label>
                </div>
                <div class="design-name">default</div>
                <span class="file-update">Update：{$date}</span>
            </div>
EOM;
        $add_design_btn = '';
    }
    
    return <<< EOM
        <div id="site-design-list">
            <div class="select-design-list">
                {$add_design_btn}
                {$site_items}
            </div>
            <input type="hidden" id="abtest-design-name" value="{$DG_abtest_designs_value}">
        </div>
EOM;
}

/* ----------------------------------------------------------
 * ページ検索
---------------------------------------------------------- */
function site_search_page_list_content() {
    //翻訳
    $text_search_page = __( 'ページ検索', 'dg-style' );
    $text_search_page_date = __( '日付', 'dg-style' );
    $text_search_page_article = __( '記事', 'dg-style' );
    $text_search_page_author = __( '作成者', 'dg-style' );
    $text_search_placeholder = __( '検索キーワード入力', 'dg-style' );
    $text_search_caution = __( '例）「2021-01-01」', 'dg-style' );
    //定義
    $first_tax = '';
    $tax_labels = '';
    $taxonomise = default_taxonomy_exclusion( array( 'category', 'post_tag' ) );
    foreach( (array)$taxonomise as $key => $tax ) {
        $taxonomy = get_taxonomy( $tax );
        $class = '';
        if ( $key === 0 ) {
            $first_tax = $tax;
            $class = ' on';
        }
        $tax_labels .= '<button type="button" class="narrow-label page-link-label' . $class . '" data-level="' . $tax . '">' . $taxonomy->label . '</button>';
    }
    return <<< EOM
        <div id="search-page-list">
            <div class="window-title">{$text_search_page}</div>
            <div class="narrow-inner">
                <div class="search-page-link-labels">
                    {$tax_labels}
                    <button type="button" class="narrow-label page-link-label" data-level="date">{$text_search_page_date}</button>
                    <button type="button" class="narrow-label page-link-label" data-level="post">{$text_search_page_article}</button>
                    <button type="button" class="narrow-label page-link-label" data-level="author">{$text_search_page_author}</button>
                </div>
                <div class="narrow-contents search-page-link-contents" data-level="{$first_tax}">
                    <input type="search" id="search-wp-site-page-input" placeholder="{$text_search_placeholder}">
                    <p class="date-caution">{$text_search_caution}</p>
                    <div id="search-wp-site-link-result"></div>
                </div>
            </div>
        </div>
EOM;
}