<?php
/*
 * 新規追加メニュー
*/
function window_add_new_part( $part_list, $page_type ) {
    $text_add_part = __( 'パーツを追加する', 'dg-style' );
    $parts = '';
    $taxonomy = '';
    $single = '';
    $area_parts = '';
    $area_taxonomy = '';
    $area_single = '';
    foreach( (array)$part_list as $slug => $value ) {
        $class = ' add-part-item';
        $area_class = ' area-add-part-item';
        if ( $value[ 'type' ] === 'all' ) {
            $parts .= '<div class="commomn-item' . $class . '" data-type="' . $value[ 'type' ] . '" data-part="' . $slug . '" title="' . $value[ 'name' ] . $text_add_part . '">' . $value[ 'name' ] . '</div>';
            $area_parts .= '<div class="commomn-item' . $area_class . '" data-type="' . $value[ 'type' ] . '" data-part="' . $slug . '" title="' . $value[ 'name' ] . $text_add_part . '">' . $value[ 'name' ] . '</div>';
        } elseif ( $value[ 'type' ] === 'taxonomy' ) {
            $taxonomy .= '<div class="commomn-item' . $class . '" data-type="' . $value[ 'type' ] . '" data-part="' . $slug . '" title="' . $value[ 'name' ] . $text_add_part . '">' . $value[ 'name' ] . '</div>';
            $area_taxonomy .= '<div class="commomn-item' . $area_class . '" data-type="' . $value[ 'type' ] . '" data-part="' . $slug . '" title="' . $value[ 'name' ] . $text_add_part . '">' . $value[ 'name' ] . '</div>';
        } elseif ( $value[ 'type' ] === 'single' ) {
            $single .= '<div class="commomn-item' . $class . '" data-type="' . $value[ 'type' ] . '" data-part="' . $slug . '" title="' . $value[ 'name' ] . $text_add_part . '">' . $value[ 'name' ] . '</div>';
            $area_single .= '<div class="commomn-item' . $area_class . '" data-type="' . $value[ 'type' ] . '" data-part="' . $slug . '" title="' . $value[ 'name' ] . $text_add_part . '">' . $value[ 'name' ] . '</div>';
        }
        
    }
    
    //翻訳
    $text_menu_title = __( 'パーツ追加', 'dg-style' );
    $text_menu_tab1 = __( '共通', 'dg-style' );
    $text_menu_tab2 = __( '一覧専用', 'dg-style' );
    $text_menu_tab3 = __( '記事専用', 'dg-style' );
    $text_tax_caution = __( '記事、404以外のページに表示できます。', 'dg-style' );
    $text_post_caution = __( '記事ページのみ表示できます。', 'dg-style' );
    
    $tabs = '<button type="button" class="tab-label new-part-label">' . $text_menu_tab2 . '</button><button type="button" class="tab-label new-part-label">' . $text_menu_tab3 . '</button>';
    //LPの場合は非表示
    if ( $page_type === 'lp' ) {
        $tabs = '';
    }
    return <<< EOM
        <div id="new-part-area" class="common-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content part-list">
                <div class="tab-inner new-part-tab-inner">
                    <div class="tab-list new-part-labels">
                        <button type="button" class="tab-label new-part-label on">{$text_menu_tab1}</button>
                        {$tabs}
                    </div>
                    <div class="tab-contents option-contents new-part-tab-contents">
                        <div class="tab-content on">{$parts}</div>
                        <div class="tab-content">
                            <p class="caution">※{$text_tax_caution}</p>
                            {$taxonomy}
                        </div>
                        <div class="tab-content">
                            <p class="caution">※{$text_post_caution}</p>
                            {$single}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="area-add-part" class="part-menu-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content part-list">
                <div class="tab-inner new-part-tab-inner">
                    <div class="tab-list new-part-labels">
                        <button type="button" class="tab-label new-part-label on">{$text_menu_tab1}</button>
                        {$tabs}
                    </div>
                    <div class="tab-contents option-contents new-part-tab-contents">
                        <div class="tab-content on">{$area_parts}</div>
                        <div class="tab-content">
                            <p class="caution">※{$text_tax_caution}</p>
                            {$area_taxonomy}
                        </div>
                        <div class="tab-content">
                            <p class="caution">※{$text_post_caution}</p>
                            {$area_single}
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * 共通オプション
*/
function window_site_option( $part_list ) {
    $parts = '';
    foreach( (array)$part_list as $slug => $value ) {
        $parts .= '<div class="common-option-item commomn-item" data-type="' . $value[ 'type' ] . '" data-part="' . $slug . '" title="' . __( 'サイトの', 'dg-style' ) . $value[ 'name' ] . __( 'をします。', 'dg-style' ) . '">' . $value[ 'name' ] . '</div>';
    }
    
    $text_menu_title = __( '共通オプション', 'dg-style' );
    return <<< EOM
        <div id="common-option-area" class="common-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content part-list">
                {$parts}
            </div>
        </div>
EOM;
}

/*
 * パーツマップ
*/
function window_part_map() {
    $text_menu_title = __( 'パーツマップ', 'dg-style' );
    $text_hidden_check = __( '非表示中パーツも表示する', 'dg-style' );
    return <<< EOM
        <div id="part-map-menu" class="common-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">
                <label class="check-toggle-label">
                    <input type="checkbox" id="part-map-hidden-check" class="display-none" value="1">
                    <span class="check-name">{$text_hidden_check}</span><span class="check-button"></span>
                </label>
                <ul id="part-map-list"></ul>
            </div>
        </div>
EOM;
}

/*
 * タークモードオプション
*/
function window_dark_mode_setting() {
    $text_menu_title = __( 'ダークモード設定', 'dg-style' );
    $text_root_title = __( 'root設定', 'dg-style' );
    $text_dark_title = __( 'ダークモード時設定', 'dg-style' );
    $text_body_title = __( 'body設定', 'dg-style' );
    $text_caution = __( 'CSS変数を設定してください', 'dg-style' );
    return <<< EOM
        <div id="dark-mode-setting-option" class="part-menu-window css-design-setting-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content root-design-area">
                <div class="window-title">:{$text_root_title}</div>
                <div class="design-setting-area adding-area root" data-level="root">
                    <div class="design-line adding-line"><input type="text" class="dark-design-input css-design-input adding-input"></div>
                </div>
                <p class="caution">※{$text_caution}</p>
                <div class="window-title">{$text_dark_title}</div>
                <div class="design-setting-area adding-area dark" data-level="dark">
                    <div class="design-line adding-line"><input type="text" class="dark-design-input css-design-input adding-input"></div>
                </div>
                <p class="caution">※{$text_caution}</p>
                <div class="window-title">{$text_body_title}</div>
                <div class="design-setting-area adding-area body" data-level="body">
                    <div class="design-line adding-line"><input type="text" class="dark-design-input css-design-input adding-input"></div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * デザイン設定
*/
function window_design_setting( $page_list, $device_list, $current_device ) {
    $page_list_option = '<option value="">' . __( 'ページ指定なし', 'dg-style' ) . '</option>';
    foreach( (array)$page_list as $key => $value ) {
        if ( $key === 'top' ) {
            $page_list_option .= '<option value="top">' . __( 'TOPページ', 'dg-style' ) . '</option>';
        } else {
            if ( $key === 'taxonomy' ) {
                $label = __( 'カテゴリー種類', 'dg-style' );
                $label_type = __( '全カテゴリー', 'dg-style' );
            } elseif ( $key === 'custom-post-archive' ) {
                $label = __( '記事タイプ種類', 'dg-style' );
                $label_type = __( '全カスタム投稿タイプ', 'dg-style' );
            } elseif ( $key === 'single' ) {
                $label = __( '記事種類', 'dg-style' );
                $label_type = __( '全記事', 'dg-style' );
            } elseif ( $key === 'other' ) {
                $label = __( 'その他', 'dg-style' );
                $label_type = '';
            }
            $page_list_option .= '<optgroup label="' . $label . '">';
            if ( $key === 'taxonomy' || $key === 'single' || $key === 'custom-post-archive' ) {
                $page_list_option .= '<option value="' . $key . '">' . $label_type . '</option>';
            }
            foreach( (array)$value as $slug => $name ) {
                if ( $slug === 404 ) {
                    $page_list_option .= '<option value="page' . $slug . '">' . $name . '</option>';
                } else {
                    $page_list_option .= '<option value="' . $slug . '">' . $name . '</option>';
                }
            }
            $page_list_option .= '</optgroup>';
        }
    }
    $page_list_option .= '<option value="freetext">' . __( '自由入力', 'dg-style' ) . '</option>';
    $property = css_property_list();
    //翻訳
    $text_menu_title = __( 'デザイン設定', 'dg-style' );
    $text_end_design_list = __( '設定済みデザインリスト', 'dg-style' );
    $text_add_group = __( 'グループ化', 'dg-style' );
    $text_add_css_category = __( 'CSSカテゴリー追加', 'dg-style' );
    $text_css_category_all = __( '全体', 'dg-style' );
    $text_add_design = __( 'デザイン追加', 'dg-style' );
    $text_not_save = __( '保存せずに戻る', 'dg-style' );
    $text_comparison = __( '前後比較', 'dg-style' );
    $text_save = __( '保存', 'dg-style' );
    $text_design_label = __( 'デザインラベル', 'dg-style' );
    $text_select_part = __( 'パーツ指定', 'dg-style' );
    $text_select_part_name = __( 'パーツ名指定', 'dg-style' );
    $text_css_design = __( 'デザイン（CSS）設定', 'dg-style' );
    $text_simple_embedded = __( '簡単デザイン埋め込み', 'dg-style' );
    $text_solid_css = __( 'べた書き', 'dg-style' );
    $text_simple_move = __( '簡単デザインを開く', 'dg-style' );
    return <<< EOM
        <div id="design-setting-option" class="part-menu-window css-design-setting-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="move-simple-design header-btn close-pass" title="{$text_simple_move}"></div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content design-inner">
                <div id="design-select-list" class="open">
                    <div id="applying-template"></div>
                    <div class="site-device-select">
                        {$device_list}
                    </div>
                    <div class="window-title css-design-title-area">
                        <span>{$text_end_design_list}</span>
                        <div id="css-design-group">{$text_add_group}</div>
                    </div>
                    <div id="css-category-popup-area"></div>
                    <div class="css-category-label-list">
                        <button id="add-css-category-label" type="button" title="{$text_add_css_category}"></button>
                        <div id="css-category-labels">
                            <button class="css-category-label on" data-category="all" type="button">{$text_css_category_all}</button>
                        </div>
                    </div>
                    <div id="updated-design-list" class="done-design-list"></div>
                    <div class="design-btns-area">
                        <button type="button" class="add-design-btn">{$text_add_design}</button>
                        <button type="button" id="solid-css-design">{$text_solid_css}</button>
                        <button type="button" id="simple-design-embedded" title="{$text_simple_embedded}"></button>
                    </div>
                </div>
                <div id="design-update-content" data-device="{$current_device}" class="selector-edit-area new-design">
                    <div class="design-option-btns">
                        <div class="back-btn">{$text_not_save}</div>
                        <div class="compare-btn compare-css-design">{$text_comparison}</div>
                        <div class="save-btn save-css-design">{$text_save}</div>
                    </div>
                    <div class="design-inner-area">
                        <div class="window-title">{$text_design_label}</div>
                        <input type="text" class="set-value set-value-label" data-level="label" placeholder="{$text_design_label}">
                        <hr class="hr-design">
                        <div class="window-title current-selector-title">
                            {$text_select_part}
                            <div class="current-items-area">
                                <div class="accordion-title current-items-title"></div>
                                <div id="current-item-class-area">
                                    <div id="current-item-class-list"></div>
                                </div>
                            </div>
                        </div>
                        <div class="selector-line-list adding-area">
                            <div class="selector-line-item adding-line">
                                <select class="page-selector-select">{$page_list_option}</select>
                                <div class="page-selector-free">
                                    <input type="text" class="free-page-selector-input">
                                    <button type="button" class="close-free-selector" title="cancel"></button>
                                </div>
                                <input type="text" class="selector-item-input adding-input active-selector-input" placeholder="{$text_select_part_name}">
                            </div>
                        </div>
                        <div class="window-title">{$text_css_design}</div>
                        <div class="design-setting-area adding-area">
                            <div class="design-line adding-line"><input type="text" class="design-line-input css-design-input adding-input"></div>
                        </div>
                        <div class="none-display">{$property}</div>
                        <input type="hidden" class="set-value set-value-selector" data-level="selector">
                        <input type="hidden" class="set-value set-value-design" data-level="design">
                        <input type="hidden" class="set-value set-value-order" data-level="order">
                        <input type="hidden" class="set-value set-value-category" data-level="category">
                        <input type="hidden" class="compare-selector" data-level="selector">
                        <input type="hidden" class="compare-design" data-level="design">
                    </div>
                </div>
                <div id="solid-design-content" data-device="{$current_device}">
                    <div class="design-option-btns">
                        <div class="solid-back-btn">{$text_not_save}</div>
                        <div class="compare-btn solid-compare-css-design">{$text_comparison}</div>
                        <div class="save-btn solid-save-css-design">{$text_save}</div>
                    </div>
                    <textarea id="solid-css-textarea" rows="15"></textarea>
                    <input type="hidden" id="compare-solid-design">
                </div>
            </div>
        </div>
EOM;
}

/*
 * セレクター作成
*/
function create_css_selector_option() {
    //翻訳
    $text_menu1_option1 = __( '属性指定', 'dg-style' );
    $text_menu1_option2 = __( '親直系要素', 'dg-style' );
    $text_menu1_option3 = __( '兄弟要素', 'dg-style' );
    $text_menu1_option4 = __( '隣要素', 'dg-style' );
    $text_menu2_option1 = __( '一番最初の場合', 'dg-style' );
    $text_menu2_option2 = __( '一番最後の場合', 'dg-style' );
    $text_menu2_option3 = __( '最初の指定パーツ', 'dg-style' );
    $text_menu2_option4 = __( '最後の指定パーツ', 'dg-style' );
    $text_menu2_option5 = __( '奇数の順番の場合', 'dg-style' );
    $text_menu2_option6 = __( '偶数の順番の場合', 'dg-style' );
    $text_menu2_option7 = __( '前から', 'dg-style' );
    $text_menu2_option8 = __( '後ろから', 'dg-style' );
    $text_menu2_option9 = __( '指定パーツで前から', 'dg-style' );
    $text_menu2_option10 = __( '指定パーツで後ろから', 'dg-style' );
    $text_menu2_unit = __( '番目', 'dg-style' );
    $text_menu5_option1 = __( '最初の文字', 'dg-style' );
    $text_menu5_option2 = __( '最初の一行', 'dg-style' );
    $text_menu6_option1 = __( '中身が空の場合', 'dg-style' );
    $text_menu6_option2 = __( '子要素が1つしかない場合', 'dg-style' );
    $text_menu6_option3 = __( '指定パーツの子要素が1つの場合', 'dg-style' );
    $text_menu6_option4 = __( '括弧内要素除外', 'dg-style' );
    return <<< EOM
        <div id="css-selector-area" class="css-selector-list popup-item-list">
            <ul class="selector-content-area search-result-area"></ul>
            <ul class="selector-type-list">
                <button type="button" class="selector-type attr" data-selector='[attr="value"]'>{$text_menu1_option1}</button>
                <button type="button" class="selector-type relation" data-selector=">">{$text_menu1_option2}</button>
                <button type="button" class="selector-type relation" data-selector="~">{$text_menu1_option3}</button>
                <button type="button" class="selector-type relation" data-selector="+">{$text_menu1_option4}</button>
                <button type="button" class="selector-type order" data-selector=":first-child">{$text_menu2_option1}</button>
                <button type="button" class="selector-type order" data-selector=":last-child">{$text_menu2_option2}</button>
                <button type="button" class="selector-type order" data-selector=":first-of-type">{$text_menu2_option3}</button>
                <button type="button" class="selector-type order" data-selector=":last-of-type">{$text_menu2_option4}</button>
                <button type="button" class="selector-type order" data-selector=":nth-child(odd)">{$text_menu2_option5}</button>
                <button type="button" class="selector-type order" data-selector=":nth-child(even)">{$text_menu2_option6}</button>
                <button type="button" class="selector-type order input-in" data-selector=":nth-child">{$text_menu2_option7}<input type="text" class="select-nth-number pseudo-input">{$text_menu2_unit}</button>
                <button type="button" class="selector-type order input-in" data-selector=":nth-last-child">{$text_menu2_option8}<input type="text" class="select-nth-number pseudo-input">{$text_menu2_unit}</button>
                <button type="button" class="selector-type order input-in" data-selector=":nth-of-type">{$text_menu2_option9}<input type="text" class="select-nth-number pseudo-input">{$text_menu2_unit}</button>
                <button type="button" class="selector-type order input-in" data-selector=":nth-last-of-type">{$text_menu2_option10}<input type="text" class="select-nth-number pseudo-input">{$text_menu2_unit}</button>
                <button type="button" class="selector-type event" data-selector=":hover">hover</button>
                <button type="button" class="selector-type event" data-selector=":focus">focus</button>
                <button type="button" class="selector-type event" data-selector=":visited">visited</button>
                <button type="button" class="selector-type event" data-selector=":link">link</button>
                <button type="button" class="selector-type event" data-selector=":active">active</button>
                <button type="button" class="selector-type pseudo" data-selector=":before">before</button>
                <button type="button" class="selector-type pseudo" data-selector=":after">after</button>
                <button type="button" class="selector-type text" data-selector=":first-letter">{$text_menu5_option1}</button>
                <button type="button" class="selector-type text" data-selector=":first-line">{$text_menu5_option2}</button>
                <button type="button" class="selector-type other" data-selector=":empty">{$text_menu6_option1}</button>
                <button type="button" class="selector-type order" data-selector=":only-child">{$text_menu6_option2}</button>
                <button type="button" class="selector-type order" data-selector=":only-of-type">{$text_menu6_option3}</button>
                <button type="button" class="selector-type order input-in" data-selector=":not">{$text_menu6_option4}(<input type="text" class="select-nth-number pseudo-input" placeholder="n">)</button>
            </ul>
            <ul id="css-element-class-list" class="element-class-list"></ul>
        </div>
EOM;
}

function css_property_list() {
    $size_unit = array( ''=>__( '手入力', 'dg-style' ), 'px'=>'px', 'rem'=>'rem', 'em'=>'em', '%'=>'%', 'vmin'=>'vmin', 'vmax'=>'vmax', 'vw'=>'vw', 'vh'=>'vh', );
    $size_select = '';
    foreach( (array)$size_unit as $key => $name ) {
        $size_select .= '<option value="' . $key . '">' . $name . '</option>';
    }
    $size_set = '<input type="text" class="css-property-input size-input"><select class="css-property-input unit-input">' . $size_select . '</select>';
    
    $property = css_text_property_summary( $size_set );
    $property .= css_bg_property_summary( $size_set );
    $property .= css_shadow_property_summary( $size_set );
    $property .= css_filter_property_summary();
    $property .= css_size_property_summary( $size_set );
    $property .= css_mp_property_summary( $size_set );
    $property .= css_border_property_summary( $size_set );
    $property .= css_display_property_summary( $size_set );
    $property .= css_position_property_summary( $size_set );
    $property .= css_list_property_summary( $size_set );
    $property .= css_table_property_summary( $size_set );
    $property .= css_content_property_summary( $size_set );
    $property .= css_outline_property_summary( $size_set );
    $property .= css_cursor_property_summary();
    $property .= css_animation_property_summary();
    $property .= css_transition_property_summary();
    $property .= css_print_property_summary();
    $property .= css_other_property_summary();
    $text_close_btn = __( '閉じる', 'dg-style' );
    return <<< EOM
        <div class="css-property-list popup-item-list">
            <div class="list-area search-result-area"></div>
            <div class="list-area original-list-area">
                {$property}
            </div>
            <button type="button" class="close-css-property close-popup-area">{$text_close_btn}(ESC)</button>
        </div>
EOM;
}

function css_text_property_summary( $size_set ) {
    //翻訳
    $text_select = __( '選択', 'dg-style' );
    // 垂直
    $vertical_unit = array( 'baseline', 'top', 'middle', 'bottom', 'text-top', 'text-bottom', 'super', 'sub', '16px', );
    $vertical_select = '';
    foreach( (array)$vertical_unit as $key ) {
        $vertical_select .= '<option value="' . $key . '">';
    }
    $vertical_select = '<datalist id="vertical">' . $vertical_select . '</datalist>';
    
    // decoration-type
    $text_deco_type = array( 'none', 'underline', 'overline', 'line-through', );
    $deco_type_select = '';
    foreach( (array)$text_deco_type as $key ) {
        $deco_type_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $deco_type_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $deco_type_select . '</select>';
    
    // decoration-style
    $text_deco_style = array( 'solid', 'double', 'dotted', 'dashed', 'wavy', );
    $deco_style_select = '';
    foreach( (array)$text_deco_style as $key ) {
        $deco_style_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $deco_style_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $deco_style_select . '</select>';
    
    // white-space
    $white_space = array( 'nowrap', 'pre', );
    $white_space_select = '';
    foreach( (array)$white_space as $key ) {
        $white_space_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $white_space_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $white_space_select . '</select>';
    
    // word-break
    $word_break = array( 'normal', 'break-all', 'keep-all', 'inherit', 'initial', 'unset', );
    $word_break_select = '';
    foreach( (array)$word_break as $key ) {
        $word_break_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $word_break_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $word_break_select . '</select>';
    
    // text-transform
    $text_transform_unit = array( 'uppercase', 'lowercase', 'capitalize', 'none', );
    $text_transform_select = '';
    foreach( (array)$text_transform_unit as $key ) {
        $text_transform_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $text_transform_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $text_transform_select . '</select>';
    //翻訳
    $text_menu_title = __( 'テキスト関連', 'dg-style' );
    $text_menu1_title = __( '文字サイズ', 'dg-style' );
    $text_menu2_title = __( '文字太さ', 'dg-style' );
    $text_menu3_title = __( '文字スタイル', 'dg-style' );
    $text_menu4_title = __( '文字揃え', 'dg-style' );
    $text_menu5_title = __( '行の高さ', 'dg-style' );
    $text_menu6_title = __( 'その他文字デザイン', 'dg-style' );
    $text_menu6_option1 = __( '垂直方向', 'dg-style' );
    $text_menu6_option2 = __( '文字の装飾', 'dg-style' );
    $text_menu6_option3 = __( '1行目の字下げ', 'dg-style' );
    $text_menu6_option4 = __( '大文字と小文字の変換', 'dg-style' );
    $text_menu6_option5 = __( '文字の間隔', 'dg-style' );
    $text_menu6_option6 = __( '単語の間隔', 'dg-style' );
    $text_menu6_option7 = __( '改行、スペース、タブ設定', 'dg-style' );
    $text_menu7_title = __( 'シャドー', 'dg-style' );
    $text_menu7_option1 = __( 'X座標', 'dg-style' );
    $text_menu7_option2 = __( 'Y座標', 'dg-style' );
    $text_menu7_option3 = __( 'ぼかし', 'dg-style' );
    $text_menu7_option4 = __( '色', 'dg-style' );
    
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <div class="beginner-property-item css-property-item css-design-item" data-value="font-size">
                    <span class="property-name">{$text_menu1_title}</span>
                    {$size_set}
                </div>
                <div class="font-property-list">
                    <div class="beginner-property-item css-property-item css-design-item" data-value="color">
                        <div class="color-picker-btn"><input type="hidden" class="css-property-input"></div>
                    </div>
                    <div class="beginner-property-item css-property-item css-design-item" data-value="font-weight">
                        <span class="property-name">{$text_menu2_title}</span>
                        <input type="text" class="css-property-input">
                    </div>
                    <div class="beginner-property-item css-property-item css-design-item" data-value="font-style">
                        <span class="property-name">{$text_menu3_title}</span>
                        <select class="css-property-input">
                            <option value="normal">normal</option>
                            <option value="italic">italic</option>
                            <option value="oblique">oblique</option>
                        </select>
                    </div>
                    <div class="beginner-property-item css-property-item css-design-item" data-value="text-align">
                        <span class="property-name">{$text_menu4_title}</span>
                        <select class="css-property-input">
                            <option value="left">left</option>
                            <option value="center">center</option>
                            <option value="right">right</option>
                        </select>
                    </div>
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="line-height">
                    <span class="property-name">{$text_menu5_title}</span>
                    {$size_set}
                </div>
                <div class="accordion-area">
                    <div class="accordion-title other-design-title">{$text_menu6_title}</div>
                    <div class="accordion-content other-design-content">
                        <div class="beginner-property-item css-property-item css-design-item" data-value="vertical-align">
                            <span class="property-name">{$text_menu6_option1}</span>
                            <input type="text" class="css-property-input" list="vertical">
                        </div>
                        <div class="beginner-property-item css-property-item css-design-item" data-value="text-decoration">
                            <span class="property-name">{$text_menu6_option2}</span>
                            {$deco_type_select}
                            {$deco_style_select}
                        </div>
                        <div class="beginner-property-item css-property-item css-design-item" data-value="text-indent">
                            <span class="property-name">{$text_menu6_option3}</span>
                            {$size_set}
                        </div>
                        <div class="beginner-property-item css-property-item css-design-item" data-value="text-transform">
                            <span class="property-name">{$text_menu6_option4}</span>
                            {$text_transform_select}
                        </div>
                        <div class="beginner-property-item css-property-item css-design-item" data-value="letter-spacing">
                            <span class="property-name">{$text_menu6_option5}</span>
                            {$size_set}
                        </div>
                        <div class="beginner-property-item css-property-item css-design-item" data-value="word-spacing">
                            <span class="property-name">{$text_menu6_option6}</span>
                            {$size_set}
                        </div>
                        <div class="beginner-property-item css-property-item css-design-item" data-value="white-space">
                            <span class="property-name">{$text_menu6_option7}</span>
                            {$white_space_select}
                        </div>
                        <div class="beginner-property-item css-property-item css-design-item" data-value="word-break">
                            <span class="property-name">{{$text_menu6_option7}}</span>
                            {$word_break_select}
                        </div>
                        <div class="beginner-property-item css-property-item css-design-item dynamic block-design" data-value="text-shadow">
                            <div class="property-name">{$text_menu7_title}</div>
                            <div class="dynamic-item-area">
                                <div class="dynamic-item shadow-item">
                                    <div class="flex"><span class="property-name">{$text_menu7_option1}</span>{$size_set}</div>
                                    <div class="flex"><span class="property-name">{$text_menu7_option2}</span>{$size_set}</div>
                                    <div class="flex"><span class="property-name">{$text_menu7_option3}</span>{$size_set}</div>
                                    <div class="flex"><span class="property-name">{$text_menu7_option4}</span><div class="color-picker-btn"><input type="hidden" class="css-property-input"></div></div>
                                    <div class="option-btns">
                                        <div class="add-btn option-btn add-property-item"></div>
                                        <div class="delete-btn option-btn delete-property-item"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div><!-- accodion-inner -->
            </div>
        </div>
EOM;
}

function css_bg_property_summary( $size_set ) {
    //翻訳
    $text_menu_title = __( '背景', 'dg-style' );
    $text_menu1_title = __( '背景イメージ', 'dg-style' );
    $text_menu1_option1 = __( 'WPイメージ', 'dg-style' );
    $text_menu1_option2 = __( 'イメージURL', 'dg-style' );
    $text_menu1_option3 = __( 'イメージ選択', 'dg-style' );
    $text_menu1_option4 = __( '削除', 'dg-style' );
    $text_menu2_title = __( '背景繰り返し', 'dg-style' );
    $text_menu3_title = __( '背景位置', 'dg-style' );
    $text_menu4_title = __( '背景サイズ', 'dg-style' );
    $text_menu5_title = __( '背景固定表示', 'dg-style' );
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <div class="beginner-property-item css-property-item css-design-item" data-value="background">{$text_menu_title}</div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="background-color"><div class="color-picker-btn"><input type="hidden" class="css-property-input"></div></div>
                <div class="beginner-property-item css-property-item css-design-item block-design" data-value="background-image">
                    <span class="property-name">{$text_menu1_title}</span>
                    <div class="tab-inner image-select-tabs">
                        <div class="tab-list option-labels flex">
                            <label class="tab-label option-label on"><input type="radio" name="css-bg-img-type" value="1" class="css-bg-img-type-input none-display" checked><span class="toggle-label">{$text_menu1_option1}</span></label>
                            <label class="tab-label option-label"><input type="radio" name="css-bg-img-type" value="2" class="css-bg-img-type-input none-display"><span class="toggle-label">{$text_menu1_option2}</span></label>
                        </div>
                        <div class="tab-contents option-contents">
                            <div class="tab-content on">
                                <div class="image-box">
                                    <a href="#" class="css-bg-upload-btn ui-btn">{$text_menu1_option3}</a><a class="css-bg-remove-btn ui-btn">{$text_menu1_option4}</a>
                                    <input type="hidden" class="css-property-input css-bg-img-url image-url">
                                </div>
                            </div>
                            <div class="tab-content">
                                <div class="window-title">{$text_menu1_option2}</div>
                                <input type="text" class="css-property-input css-bg-img-url image-url-value">
                                <div class="image-simulator"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="background-repeat">
                    <span class="property-name">{$text_menu2_title}</span>
                    <select class="css-property-input">
                        <option value="initial">initial</option>
                        <option value="inherit">inherit</option>
                        <option value="repeat">repeat</option>
                        <option value="no-repeat">no-repeat</option>
                        <option value="repeat-x">repeat-x</option>
                        <option value="repeat-y">repeat-y</option>
                    </select>
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="background-position">
                    <span class="property-name">{$text_menu3_title}</span>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="background-size">
                    <span class="property-name">{$text_menu4_title}</span>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="background-attachment">
                    <span class="property-name">{$text_menu5_title}</span>
                    <select class="css-property-input">
                        <option value="initial">initial</option>
                        <option value="inherit">inherit</option>
                        <option value="fixed">fixed</option>
                        <option value="scroll">scroll</option>
                    </select>
                </div>
            </div>
        </div>
EOM;
}

function css_shadow_property_summary( $size_set ) {
    //翻訳
    $text_menu_title = __( 'シャドー', 'dg-style' );
    $text_option1 = __( 'X座標', 'dg-style' );
    $text_option2 = __( 'Y座標', 'dg-style' );
    $text_option3 = __( 'ぼかし', 'dg-style' );
    $text_option4 = __( '色', 'dg-style' );
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <div class="beginner-property-item css-property-item css-design-item dynamic block-design" data-value="box-shadow">
                    <span class="property-name">{$text_menu_title}</span>
                    <div class="dynamic-item-area">
                        <div class="dynamic-item shadow-item">
                            <div class="flex"><span class="property-name">{$text_option1}</span>{$size_set}</div>
                            <div class="flex"><span class="property-name">{$text_option2}</span>{$size_set}</div>
                            <div class="flex"><span class="property-name">{$text_option3}</span>{$size_set}</div>
                            <div class="flex"><span class="property-name">{$text_option4}</span><div class="color-picker-btn"><input type="hidden" class="css-property-input"></div></div>
                            <div class="option-btns">
                                <div class="add-btn option-btn add-property-item"></div>
                                <div class="delete-btn option-btn delete-property-item"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

function css_filter_property_summary() {
    $size_unit = array( ''=>__( '手入力', 'dg-style' ), 'px'=>'px', '%'=>'%', 'deg'=>'deg' );
    $size_select = '';
    foreach( (array)$size_unit as $key => $name ) {
        $size_select .= '<option value="' . $key . '">' . $name . '</option>';
    }
    $size_set = '<input type="text" class="css-property-input size-input"><select class="css-property-input unit-input">' . $size_select . '</select>';
    
    $filter_unit = array( ''=>__( '選択', 'dg-style' ), 'none'=>__( 'なし', 'dg-style' ), 'brightness'=>__( '明るさ', 'dg-style' ), 'contrast'=>__( 'コントラスト', 'dg-style' ), 'grayscale'=>__( 'グレースケール', 'dg-style' ), 'saturate'=>__( '彩度', 'dg-style' ), 'sepia'=>__( 'セピア', 'dg-style' ), 'hue-rotate'=>__( '色相回転', 'dg-style' ), 'invert'=>__( '階調反転', 'dg-style' ), 'blur'=>__( 'ぼかし', 'dg-style' ), );
    $filter_select = '';
    foreach( (array)$filter_unit as $key => $name ) {
        $filter_select .= '<option value="' . $key . '">' . $name . '</option>';
    }
    $filter_select = '<select class="css-property-input">' . $filter_select . '</select>';
    //翻訳
    $text_menu_title = __( 'フィルター', 'dg-style' );
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <div class="beginner-property-item css-property-item css-design-item dynamic block-design" data-value="filter">
                    <span class="property-name">{$text_menu_title}</span>
                    <div class="dynamic-item-area">
                        <div class="dynamic-item filter-item">
                            <div class="flex">
                            {$filter_select}
                            {$size_set}
                            </div>
                            <div class="option-btns">
                                <div class="add-btn option-btn add-property-item"></div>
                                <div class="delete-btn option-btn delete-property-item"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

function css_size_property_summary( $size_set ) {
    //翻訳
    $text_menu_title = __( '横・縦サイズ', 'dg-style' );
    $text_menu1_title = __( '横幅', 'dg-style' );
    $text_menu2_title = __( '高さ', 'dg-style' );
    $text_menu3_title = __( '最大の横幅', 'dg-style' );
    $text_menu4_title = __( '最小の横幅', 'dg-style' );
    $text_menu5_title = __( '最大の高さ', 'dg-style' );
    $text_menu6_title = __( '最小の高さ', 'dg-style' );
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <span class="beginner-property-item css-property-item css-design-item" data-value="width">
                    <span class="property-name">{$text_menu1_title}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="height">
                    <span class="property-name">{$text_menu2_title}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="max-width">
                    <span class="property-name">{$text_menu3_title}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="min-width">
                    <span class="property-name">{$text_menu4_title}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="max-height">
                    <span class="property-name">{$text_menu5_title}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="min-height">
                    <span class="property-name">{$text_menu6_title}</span>
                    {$size_set}
                </span>
            </div>
        </div>
EOM;
}

function css_mp_property_summary( $size_set ) {
    //翻訳
    $text_menu_title = __( '余白', 'dg-style' );
    $text_menu1_title = __( 'マージン', 'dg-style' );
    $text_menu2_title = __( 'パーディング', 'dg-style' );
    $text_way = __( 'まとめて設定', 'dg-style' );
    $text_way1 = __( '上', 'dg-style' );
    $text_way2 = __( '右', 'dg-style' );
    $text_way3 = __( '下', 'dg-style' );
    $text_way4 = __( '左', 'dg-style' );
    
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <span class="popup-title">{$text_menu1_title}</span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="margin">
                    <span class="property-name">{$text_way}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="margin-top">
                    <span class="property-name">{$text_way1}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="margin-right">
                    <span class="property-name">{$text_way2}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="margin-bottom">
                    <span class="property-name">{$text_way3}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="margin-left">
                    <span class="property-name">{$text_way4}</span>
                    {$size_set}
                </span>
                <span class="popup-title">{$text_menu2_title}</span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="padding">
                    <span class="property-name">{$text_way}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="padding-top">
                    <span class="property-name">{$text_way1}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="padding-right">
                    <span class="property-name">{$text_way2}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="padding-bottom">
                    <span class="property-name">{$text_way3}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="padding-left">
                    <span class="property-name">{$text_way4}</span>
                    {$size_set}
                </span>
            </div>
        </div>
EOM;
}

function css_border_property_summary( $size_set ) {
    $style_unit = array( ''=>__( '選択', 'dg-style' ), 'none'=>__( 'なし', 'dg-style' ), 'solid'=>__( '1本線', 'dg-style' ), 'double'=>__( '2本線', 'dg-style' ), 'dashed'=>__( '破線', 'dg-style' ), 'dotted'=>__( '点線', 'dg-style' ), 'groove'=>__( '凹線', 'dg-style' ), 'ridge'=>__( '凸線', 'dg-style' ), 'inset'=>__( '埋め込み線', 'dg-style' ), 'outset'=>__( '出っ張り線', 'dg-style' ), );
    $style_select = '';
    foreach( (array)$style_unit as $key => $name ) {
        $style_select .= '<option value="' . $key . '">' . $name . '</option>';
    }
    $style_select = '<select class="css-property-input">' . $style_select . '</select>';
    //翻訳
    $text_menu_title = __( '境界線', 'dg-style' );
    $text_way = __( 'まとめて設定', 'dg-style' );
    $text_way1 = __( '上', 'dg-style' );
    $text_way2 = __( '右', 'dg-style' );
    $text_way3 = __( '下', 'dg-style' );
    $text_way4 = __( '左', 'dg-style' );
    
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <div class="beginner-property-item css-property-item css-design-item" data-value="border">
                    <span class="property-name">{$text_way}</span>
                    {$size_set}
                    {$style_select}
                    <div class="color-picker-btn"><input type="hidden" class="css-property-input"></div>
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="border-top">
                    <span class="property-name">{$text_way1}</span>
                    {$size_set}
                    {$style_select}
                    <div class="color-picker-btn"><input type="hidden" class="css-property-input"></div>
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="border-right">
                    <span class="property-name">{$text_way2}</span>
                    {$size_set}
                    {$style_select}
                    <div class="color-picker-btn"><input type="hidden" class="css-property-input"></div>
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="border-bottom">
                    <span class="property-name">{$text_way3}</span>
                    {$size_set}
                    {$style_select}
                    <div class="color-picker-btn"><input type="hidden" class="css-property-input"></div>
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="border-left">
                    <span class="property-name">{$text_way4}</span>
                    {$size_set}
                    {$style_select}
                    <div class="color-picker-btn"><input type="hidden" class="css-property-input"></div>
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="border-radius">
                    <span class="property-name">border-radius</span>
                    <input type="text" class="css-property-input">
                </div>
            </div>
        </div>
EOM;
}

function css_display_property_summary( $size_set ) {
    $text_select = __( '選択', 'dg-style' );
    
    // display
    $display_unit = array( 'none', 'block', 'inline', 'inline-block', 'flex', 'inline-flex', 'grid', 'inline-grid', 'list-item', 'table', 'table-cell', 'table-column', 'table-column-group', 'table-row', 'table-row-group', 'table-header-group', 'table-footer-group', );
    $display_select = '';
    foreach( (array)$display_unit as $key ) {
        $display_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $display_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $display_select . '</select>';
    
    // wrap
    $wrap_unit = array( 'initial', 'wrap', 'nowrap', 'row-reverse', 'column', 'column-reverse' );
    $wrap_select = '';
    foreach( (array)$wrap_unit as $key ) {
        $wrap_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $wrap_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $wrap_select . '</select>';
    
    // derection
    $direction_unit = array( 'initial', 'row', 'row-reverse', 'column', 'column-reverse' );
    $direction_select = '';
    foreach( (array)$direction_unit as $key ) {
        $direction_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $direction_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $direction_select . '</select>';
    
    //justify-content
    $justify_content_unit = array( 'initial', 'center', 'start', 'end', 'flex-start', 'flex-end', 'left', 'right', 'space-between', 'space-around', 'space-evenly', );
    $justify_content_select = '';
    foreach( (array)$justify_content_unit as $key ) {
        $justify_content_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $justify_content_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $justify_content_select . '</select>';
    
    // justify-items
    $justify_items_unit = array( 'initial', 'center', 'start', 'end', 'flex-start', 'flex-end', 'left', 'right', );
    $justify_items_select = '';
    foreach( (array)$justify_items_unit as $key ) {
        $justify_items_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $justify_items_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $justify_items_select . '</select>';
    
    // align-self
    $align_self_unit = array( 'initial', 'center', 'start', 'end', 'flex-start', 'flex-end', 'left', 'right', );
    $align_self_select = '';
    foreach( (array)$align_self_unit as $key ) {
        $align_self_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $align_self_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $align_self_select . '</select>';
    
    // float
    $text_none = __( 'なし', 'dg-style' );
    $text_way1 = __( '左', 'dg-style' );
    $text_way2 = __( '右', 'dg-style' );
    $text_way3 = __( '両方', 'dg-style' );
    $float_unit = array( ''=>$text_select, 'left'=>$text_way1, 'right'=>$text_way2, 'none'=>$text_none, );
    $float_select = '';
    foreach( (array)$float_unit as $key => $name ) {
        $float_select .= '<option value="' . $key . '">' . $name . '</option>';
    }
    $float_select = '<select class="css-property-input">' . $float_select . '</select>';
    
    // clear
    $clear_unit = array( ''=>$text_select, 'left'=>$text_way1, 'right'=>$text_way2, 'both'=>$text_way3, 'none'=>$text_none, );
    $clear_select = '';
    foreach( (array)$clear_unit as $key => $name ) {
        $clear_select .= '<option value="' . $key . '">' . $name . '</option>';
    }
    $clear_select = '<select class="css-property-input">' . $clear_select . '</select>';
    
    //翻訳
    $text_menu_title = __( '表示', 'dg-style' );
    $text_menu1_title = __( '表示形式', 'dg-style' );
    $text_menu2_title = __( 'flex関連', 'dg-style' );
    $text_menu2_option1 = __( '初期サイズ', 'dg-style' );
    $text_menu2_option2 = __( '改行', 'dg-style' );
    $text_menu2_option3 = __( '横／縦並び', 'dg-style' );
    $text_menu2_option4 = __( '伸長比率', 'dg-style' );
    $text_menu2_option5 = __( '縮小比率', 'dg-style' );
    $text_menu2_option6 = __( '順番', 'dg-style' );
    $text_menu2_option7 = __( '横寄せ方／間隔', 'dg-style' );
    $text_menu2_option8 = __( '横配置', 'dg-style' );
    $text_menu2_option9 = __( '縦寄せ方／間隔', 'dg-style' );
    $text_menu2_option10 = __( '縦配置', 'dg-style' );
    $text_menu2_option11 = __( '個別配置', 'dg-style' );
    $text_menu3_option = __( 'float解除', 'dg-style' );
    
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <span class="beginner-property-item css-property-item css-design-item" data-value="display">
                    <span class="property-name">{$text_menu1_title}</span>
                    {$display_select}
                </span>
                <div class="accordion-area">
                    <div class="accordion-title other-design-title">{$text_menu2_title}</div>
                    <div class="accordion-content other-design-content">
                        <span class="beginner-property-item css-property-item css-design-item" data-value="flex">
                            <span class="property-name">flex</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="flex-basis">
                            <span class="property-name">{$text_menu2_option1}</span>
                            {$size_set}
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="flex-flow">
                            <span class="property-name">flex-flow</span>
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="flex-wrap">
                            <span class="property-name">{$text_menu2_option2}</span>
                            {$wrap_select}
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="flex-direction">
                            <span class="property-name">{$text_menu2_option3}</span>
                            {$direction_select}
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="flex-grow">
                            <span class="property-name">{$text_menu2_option4}</span>
                            <input type="number" class="css-property-input" step="0.1">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="flex-shrink">
                            <span class="property-name">{$text_menu2_option5}</span>
                            <input type="number" class="css-property-input" step="0.1">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="order">
                            <span class="property-name">{$text_menu2_option6}</span>
                            <input type="number" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="justify-content">
                            <span class="property-name">{$text_menu2_option7}</span>
                            {$justify_content_select}
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="justify-items">
                            <span class="property-name">{$text_menu2_option8}</span>
                            {$justify_items_select}
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="align-content">
                            <span class="property-name">{$text_menu2_option9}</span>
                            {$justify_content_select}
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="align-items">
                            <span class="property-name">{$text_menu2_option10}</span>
                            {$justify_items_select}
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="align-self">
                            <span class="property-name">{$text_menu2_option11}</span>
                            {$align_self_select}
                        </span>
                    </div>
                </div>
                <div class="accordion-area">
                    <div class="accordion-title other-design-title">grid</div>
                    <div class="accordion-content other-design-content">
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid">
                            <span class="property-name">grid</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-area">
                            <span class="property-name">grid-area</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-auto-columns">
                            <span class="property-name">grid-auto-columns</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-auto-flow">
                            <span class="property-name">grid-auto-flow</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-auto-rows">
                            <span class="property-name">grid-auto-rows</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-column">
                            <span class="property-name">grid-column</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-column-end">
                            <span class="property-name">grid-column-end</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-column-start">
                            <span class="property-name">grid-column-start</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-column-gap">
                            <span class="property-name">grid-column-gap</span>
                            {$size_set}
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-gap">
                            <span class="property-name">grid-gap</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-row">
                            <span class="property-name">grid-row</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-row-end">
                            <span class="property-name">grid-row-end</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-row-start">
                            <span class="property-name">grid-row-start</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-row-gap">
                            <span class="property-name">grid-row-gap</span>
                            {$size_set}
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-template">
                            <span class="property-name">grid-template</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-template-areas">
                            <span class="property-name">grid-template-areas</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-template-columns">
                            <span class="property-name">grid-template-columns</span>
                            <input type="text" class="css-property-input">
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="grid-template-rows">
                            <span class="property-name">grid-template-rows</span>
                            <input type="text" class="css-property-input">
                        </span>
                    </div>
                </div>
                <div class="accordion-area">
                    <div class="accordion-title other-design-title">float</div>
                    <div class="accordion-content other-design-content">
                        <span class="beginner-property-item css-property-item css-design-item" data-value="float">
                            <span class="property-name">float</span>
                            {$float_select}
                        </span>
                        <span class="beginner-property-item css-property-item css-design-item" data-value="clear">
                            <span class="property-name">{$text_menu3_option}</span>
                            {$clear_select}
                        </span>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

function css_position_property_summary( $size_set ) {
    $text_select = __( '選択', 'dg-style' );
    // position
    $position_unit = array( 'static', 'relative', 'absolute', 'fixed', 'sticky', );
    $position_select = '';
    foreach( (array)$position_unit as $key ) {
        $position_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $position_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $position_select . '</select>';
    
    // overflow
    $overflow_unit = array( 'visible', 'hidden', 'clip', 'scroll', 'auto', 'overlay', );
    $overflow_select = '';
    foreach( (array)$overflow_unit as $key ) {
        $overflow_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $overflow_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $overflow_select . '</select>';
    //翻訳
    $text_menu_title = __( '配置', 'dg-style' );
    $text_option1 = __( '上からの距離', 'dg-style' );
    $text_option2 = __( '右からの距離', 'dg-style' );
    $text_option3 = __( '下からの距離', 'dg-style' );
    $text_option4 = __( '左からの距離', 'dg-style' );
    $text_option5 = __( 'はみ出し(全体)', 'dg-style' );
    $text_option6 = __( 'はみ出し(横)', 'dg-style' );
    $text_option7 = __( 'はみ出し(縦)', 'dg-style' );
    $text_option8 = __( '重なり順', 'dg-style' );
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <span class="beginner-property-item css-property-item css-design-item" data-value="position">
                    <span class="property-name">{$text_menu_title}</span>
                    {$position_select}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="top">
                    <span class="property-name">{$text_option1}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="right">
                    <span class="property-name">{$text_option2}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="bottom">
                    <span class="property-name">{$text_option3}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="left">
                    <span class="property-name">{$text_option4}</span>
                    {$size_set}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="overflow">
                    <span class="property-name">{$text_option5}</span>
                    {$overflow_select}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="overflow-x">
                    <span class="property-name">{$text_option6}</span>
                    {$overflow_select}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="overflow-y">
                    <span class="property-name">{$text_option7}</span>
                    {$overflow_select}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="z-index">
                    <span class="property-name">{$text_option8}</span>
                    <input type="number" class="css-property-input">
                </span>
            </div>
        </div>
EOM;
}

function css_list_property_summary( $size_set ) {
    $text_select = __( '選択', 'dg-style' );
    // style
    $style_unit = array( 'none'=>__( 'なし', 'dg-style' ), 'disc'=>__( '黒丸', 'dg-style' ), 'circle'=>__( '白丸', 'dg-style' ), 'square'=>__( '黒四角', 'dg-style' ), 'lower-roman'=>__( '小文字ローマ数字', 'dg-style' ), 'upper-roman'=>__( '大文字ローマ数字', 'dg-style' ), 'lower-greek'=>__( '小文字ギリシャ数字', 'dg-style' ), 'decimal'=>__( '数字', 'dg-style' ), 'decimal-leading-zero'=>__( '先頭0あり数字', 'dg-style' ), 'lower-alpha'=>__( '小文字アルファベット', 'dg-style' ), 'upper-alpha'=>__( '大文字アルファベット', 'dg-style' ), 'armenian'=>__( 'アルメニア数字', 'dg-style' ), 'georgian'=>__( 'グルジア数字', 'dg-style' ), );
    $style_select = '';
    foreach( (array)$style_unit as $key => $name ) {
        $style_select .= '<option value="' . $key . '">' . $name . '</option>';
    }
    $style_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $style_select . '</select>';
    
    // position
    $position_unit = array( 'initial', 'inside', 'outside', );
    $position_select = '';
    foreach( (array)$position_unit as $key ) {
        $position_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $position_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $position_select . '</select>';
    //翻訳
    $text_menu_title = __( 'リストマーカー', 'dg-style' );
    $text_option1 = __( 'マーカーまとめ', 'dg-style' );
    $text_option2 = __( 'マーカー種類', 'dg-style' );
    $text_option3 = __( 'マーカー位置', 'dg-style' );
    $text_option4 = __( 'マーカーイメージ', 'dg-style' );
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <span class="beginner-property-item css-property-item css-design-item" data-value="list-style">
                    <span class="property-name">{$text_option1}</span>
                    {$style_select}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="list-style-type">
                    <span class="property-name">{$text_option2}</span>
                    {$style_select}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="list-style-position">
                    <span class="property-name">{$text_option3}</span>
                    {$position_select}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="list-style-image">
                    <span class="property-name">{$text_option4}</span>
                    <input type="text" class="css-property-input">
                </span>
            </div>
        </div>
EOM;
}

function css_table_property_summary( $size_set ) {
    $text_select = __( '選択', 'dg-style' );
    // position
    $layout_unit = array( 'initial', 'auto', 'fixed', );
    $layout_select = '';
    foreach( (array)$layout_unit as $key ) {
        $layout_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $layout_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $layout_select . '</select>';
    
    // collapse
    $collapse_unit = array( 'initial', 'collapse', 'separate', );
    $collapse_select = '';
    foreach( (array)$collapse_unit as $key ) {
        $collapse_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $collapse_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $collapse_select . '</select>';
    
    // empty
    $empty_unit = array( 'initial', 'show', 'hide', );
    $empty_select = '';
    foreach( (array)$empty_unit as $key ) {
        $empty_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $empty_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $empty_select . '</select>';
    //翻訳
    $text_menu_title = __( 'テーブル', 'dg-style' );
    $text_option1 = __( '表レイアウト', 'dg-style' );
    $text_option2 = __( '線の表示方法', 'dg-style' );
    $text_option3 = __( '線の間隔', 'dg-style' );
    $text_option4 = __( '空白セルの線', 'dg-style' );
    $text_option5 = __( '表題位置', 'dg-style' );
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <span class="beginner-property-item css-property-item css-design-item" data-value="table-layout">
                    <span class="property-name">{$text_option1}</span>
                    {$layout_select}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="border-collapse">
                    <span class="property-name">{$text_option2}</span>
                    {$collapse_select}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="border-spacing">
                    <span class="property-name">{$text_option3}</span>
                    <input type="text" class="css-property-input">
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="empty-cells">
                    <span class="property-name">{$text_option4}</span>
                    {$empty_select}
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="caption-side">
                    <span class="property-name">{$text_option5}</span>
                    <input type="text" class="css-property-input">
                </span>
            </div>
        </div>
EOM;
}

function css_content_property_summary( $size_set ) {
    //翻訳
    $text_menu_title = __( 'コンテンツ追加', 'dg-style' );
    $text_option1 = __( '内容追加', 'dg-style' );
    $text_option2 = __( '引用符設定', 'dg-style' );
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <span class="beginner-property-item css-property-item css-design-item web-icon-design" data-value="content">
                    <span class="property-name">{$text_option1}</span>
                    <input type="text" class="css-property-input web-icon-input">
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="quotes">
                    <span class="property-name">{$text_option2}</span>
                    <input type="text" class="css-property-input">
                </span>
            </div>
        </div>
EOM;
}

function css_outline_property_summary( $size_set ) {
    //翻訳
    $text_menu_title = __( 'アウトライン', 'dg-style' );
    $text_option1 = __( 'アウトラインまとめ', 'dg-style' );
    $text_option2 = __( '太さ', 'dg-style' );
    $text_option3 = __( '色', 'dg-style' );
    $text_option4 = __( 'スタイル', 'dg-style' );
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <span class="beginner-property-item css-property-item css-design-item" data-value="outline">
                    <span class="property-name">{$text_option1}</span>
                    <input type="text" class="css-property-input">
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="outline-width">
                    <span class="property-name">{$text_option2}</span>
                    <input type="text" class="css-property-input">
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="outline-color">
                    <span class="property-name">{$text_option3}</span>
                    <input type="text" class="css-property-input">
                </span>
                <span class="beginner-property-item css-property-item css-design-item" data-value="outline-style">
                    <span class="property-name">{$text_option4}</span>
                    <input type="text" class="css-property-input">
                </span>
            </div>
        </div>
EOM;
}

function css_cursor_property_summary() {
    $cursor_unit = array( 'default', 'auto', 'none', 'context-menu', 'help', 'pointer', 'progress', 'wait', 'cell', 'crosshair', 'text', 'vertical-text', 'alias', 'copy', 'move', 'no-drop', 'not-allowed', 'grab', 'grabbing', 'all-scroll', 'col-resize', 'row-resize', 'n-resize', 'e-resize', 's-resize', 'w-resize', 'ne-resize', 'nw-resize', 'se-resize', 'sw-resize', 'ew-resize', 'ns-resize', 'nesw-resize', 'nwse-resize', );
    $cursor_select = '';
    foreach( (array)$cursor_unit as $key ) {
        $cursor_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $cursor_select = '<select class="css-property-input">' . $cursor_select . '</select>';
    //翻訳
    $text_menu_title = __( 'カーソル', 'dg-style' );
    $text_option1 = __( 'カソールの形', 'dg-style' );
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <span class="beginner-property-item css-property-item css-design-item" data-value="cursor">
                    <span class="property-name">{$text_option1}</span>
                    {$cursor_select}
                </span>
            </div>
        </div>
EOM;
}

function css_animation_property_summary() {
    //翻訳
    $text_menu_title = __( 'アニメーション', 'dg-style' );
    $text_option1 = __( 'アニメーションリスト', 'dg-style' );
    
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <div class="beginner-property-item css-property-item css-design-item block-design" data-value="animation">
                    <div class="property-name">animation</div>
                    <button type="button" class="open-anime-list">{$text_option1}</button>
                    <input type="hidden" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item block-design" data-value="animation-delay">
                    <div class="property-name">animation-delay</div>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item block-design" data-value="animation-direction">
                    <div class="property-name">animation-direction</div>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item block-design" data-value="animation-duration">
                    <div class="property-name">animation-duration</div>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item block-design" data-value="animation-fill-mode">
                    <div class="property-name">animation-fill-mode</div>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item block-design" data-value="animation-iteration-count">
                    <div class="property-name">animation-iteration-count</div>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item block-design" data-value="animation-name">
                    <div class="property-name">animation-name</div>
                    <button type="button" class="open-anime-list">{$text_option1}</button>
                    <input type="hidden" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item block-design" data-value="animation-play-state">
                    <div class="property-name">animation-play-state</div>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item block-design" data-value="animation-timing-function">
                    <div class="property-name">animation-timing-function</div>
                    <input type="text" class="css-property-input">
                </div>
            </div>
        </div>
EOM;
}

function css_transition_property_summary() {
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">transition</div>
            <div class="accordion-content css-property-content">
                <div class="beginner-property-item css-property-item css-design-item" data-value="transition">
                    <div class="property-name">transition</div>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="transition-delay">
                    <div class="property-name">transition-delay</div>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="transition-duration">
                    <div class="property-name">transition-duration</div>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="transition-property">
                    <div class="property-name">transition-property</div>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="transition-timing-function">
                    <div class="property-name">transition-timing-function</div>
                    <input type="text" class="css-property-input">
                </div>
            </div>
        </div>
EOM;
}

function css_print_property_summary() {
    //翻訳
    $text_menu_title = __( '印刷', 'dg-style' );
    $text_option1 = __( '直前の改ページ', 'dg-style' );
    $text_option2 = __( '直後の改ページ', 'dg-style' );
    $text_option3 = __( '要素内の改ページ', 'dg-style' );
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <div class="beginner-property-item css-property-item css-design-item" data-value="page-break-before">
                    <div class="property-name">{$text_option1}</div>
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="page-break-after">
                    <div class="property-name">{$text_option2}</div>
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="page-break-inside">
                    <div class="property-name">{$text_option3}</div>
                </div>
            </div>
        </div>
EOM;
}

function css_other_property_summary() {
    $text_select = __( '選択', 'dg-style' );
    $blend_unit = array( 'normal', 'multiply', 'screen', 'overlay', 'darken', 'lighten', 'color-dodge', 'color-burn', 'hard-light', 'soft-light', 'difference', 'exclusion', 'hue', 'saturation', 'color', 'luminosity', );
    $blend_select = '';
    foreach( (array)$blend_unit as $key ) {
        $blend_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $blend_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $blend_select . '</select>';
    //object-fif
    $fit_unit = array( 'fill', 'contain', 'cover', 'none', 'scale-down', );
    $fit_select = '';
    foreach( (array)$fit_unit as $key ) {
        $fit_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $fit_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $fit_select . '</select>';
    
    //appearance
    $appearance_unit = array( 'none', 'auto', 'button', 'textfield', 'searchfield', 'textarea', 'push-button', 'button-bevel', 'slider-horizontal', 'checkbox', 'radio', 'square-button', 'menulist', 'menulist-button', 'listbox', 'meter', 'progress-bar', );
    $appearance_select = '';
    foreach( (array)$appearance_unit as $key ) {
        $appearance_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $appearance_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $appearance_select . '</select>';
    
    //visibility
    $visibility_unit = array( 'visible', 'hidden', 'collapse', 'inherit', 'initial', 'unset', );
    $visibility_select = '';
    foreach( (array)$visibility_unit as $key ) {
        $visibility_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $visibility_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $visibility_select . '</select>';
    
    //transform
    $trans_unit = array( 'matrix', 'matrix3d', 'perspective', 'rotate', 'rotate3d', 'rotateX', 'rotateY', 'rotateZ', 'translate', 'translate3d', 'translateX', 'translateY', 'translateZ', 'scale', 'scale3d', 'scaleX', 'scaleY', 'scaleZ', 'skew', 'skewX', 'skewY', 'inherit', 'initial', 'unset', );
    $trans_select = '';
    foreach( (array)$trans_unit as $key ) {
        $trans_select .= '<option value="' . $key . '">' . $key . '</option>';
    }
    $trans_select = '<select class="css-property-input"><option value="">' . $text_select . '</option>' . $trans_select . '</select>';
    
    //翻訳
    $text_menu_title = __( 'その他', 'dg-style' );
    return <<< EOM
        <div class="accordion-area css-property-inner">
            <div class="accordion-title css-property-title">{$text_menu_title}</div>
            <div class="accordion-content css-property-content">
                <div class="beginner-property-item css-property-item css-design-item" data-value="mix-blend-mode">
                    <div class="property-name">mix-blend-mode</div>
                    {$blend_select}
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="background-blend-mode">
                    <div class="property-name">background-blend-mode</div>
                    {$blend_select}
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="object-fit">
                    <div class="property-name">object-fit</div>
                    {$fit_select}
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="object-position">
                    <div class="property-name">object-position</div>
                    <input type="number" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="opacity">
                    <div class="property-name">opacity</div>
                    <input type="number" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="appearance">
                    <div class="property-name">appearance</div>
                    {$appearance_select}
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="visibility">
                    <div class="property-name">visibility</div>
                    {$visibility_select}
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="counter-increment">
                    <div class="property-name">counter-increment</div>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="counter-reset">
                    <div class="property-name">counter-reset</div>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="scroll-snap-type">
                    <div class="property-name">scroll-snap-type</div>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item" data-value="scroll-snap-align">
                    <div class="property-name">scroll-snap-align</div>
                    <input type="text" class="css-property-input">
                </div>
                <div class="beginner-property-item css-property-item css-design-item dynamic block-design" data-value="transform">
                    <span class="property-name">transform</span>
                    <div class="dynamic-item-area">
                        <div class="dynamic-item transform-item">
                            <div class="flex">
                                {$trans_select}
                                <input type="text" class="css-property-input">
                            </div>
                            <div class="option-btns">
                                <div class="add-btn option-btn add-property-item"></div>
                                <div class="delete-btn option-btn delete-property-item"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
EOM;
}

/*
 * アニメーションデザイン
*/
function window_animation_design() {
    $upload_dir = wp_upload_dir();
    $directory_path = $upload_dir[ 'basedir' ];
    $design_path = $directory_path . '/design-json/template/animation.json';
    $template_value = '';
    $template_list = array();
    $html_list = '';
    if ( is_file( $design_path ) ) {
        global $wp_filesystem;
        $part_file = $wp_filesystem->get_contents( $design_path );
        $template_value = htmlspecialchars( $part_file, ENT_QUOTES, 'UTF-8' );
        $template_list = json_decode( $part_file, true );
    } else {
        $template_value = htmlspecialchars( '{"anime-0":{"label":"\u62e1\u5927","design":{"css-0":{"order":"1","category":"all","selector":"0%","design":"transform:scale(1);","label":"0%"},"css-1":{"order":"2","category":"all","selector":"100%","design":"transform:scale(1.2);","label":"100%"}},"select":true},"anime-1":{"label":"\u53f3\u304b\u3089\u30b9\u30e9\u30a4\u30c9","design":{"css-0":{"order":"1","category":"all","label":"0%","selector":"0%","design":"position:relative;left:50%;opacity:0;"},"css-1":{"order":"2","category":"all","label":"100%","selector":"100%","design":"left:0%;opacity:1;"}},"select":true},"anime-2":{"label":"\u80cc\u666f\u30b9\u30e9\u30a4\u30c9","design":{"css-0":{"order":"0","category":"all","label":"0%","design":"transform:translateX(-25%);","selector":"0%"},"css-1":{"order":"1","category":"all","design":"transform:translateX(25%);","selector":"100%","label":"100%"}},"select":true},"anime-3":{"label":"\u4e0b\u304b\u3089\u4e0a\u3078","design":{"css-0":{"order":"0","category":"all","label":"0%","selector":"0%","design":"transform:translateY(100px);opacity:0;"},"css-1":{"order":"1","category":"all","label":"100%","selector":"100%","design":"transform:translateY(0);opacity:1;"}},"select":true},"anime-5":{"label":"\u4e0a\u304b\u3089\u4e0b\u3078\uff12","design":{"css-0":{"order":"0","category":"all","label":"0%","selector":"0%","design":"opacity:0;margin-top:50px;"},"css-1":{"order":"1","category":"all","label":"100%","selector":"100%","design":"opacity:1;margin-top:0;"}},"select":true},"anime-6":{"label":"\u30d1\u30fc\u30c7\u30a3\u30f3\u30b0\uff12","design":{"css-0":{"order":"0","category":"all","label":"0%","selector":"0%","design":"padding:0;"},"css-1":{"order":"1","category":"all","label":"100%","selector":"100%","design":"padding:50px;"}},"select":true},"anime-7":{"label":"\u30d1\u30fc\u30c7\u30a3\u30f3\u30b0","design":{"css-0":{"order":"0","category":"all","label":"0%","selector":"0%","design":"padding:0;"},"css-1":{"order":"1","category":"all","label":"100%","selector":"100%","design":"padding:25px;"}},"select":true}}', ENT_QUOTES, 'UTF-8' );
        $template_list = json_decode( htmlspecialchars_decode( $template_value ), true );
    }
    
    if ( is_array( $template_list ) && count( $template_list ) > 0 ) {
        foreach( (array)$template_list as $key => $value ) {
            $select = isset( $value[ 'select' ] ) ? ' select' : '';
            $html_list .= <<< EOM
                <div class="design-item anime-item{$select}" data-level="{$key}" data-name="{$value[ 'label' ]}">
                    <div class="anime-name-inner"><div class="anime-name" style="animation-name:{$key};">{$value[ 'label' ]}</div></div>
                    <div class="delete-anime-btn none-confrim-area option-btn"></div>
                    <div class="edit-anime-btn none-confrim-area option-btn"></div>
                    <div class="copy-anime-btn none-confrim-area option-btn"></div>
                </div>
EOM;
        }
    }
    
    //翻訳
    $text_menu_title = __( 'アニメーションデザイン', 'dg-style' );
    $text_option1 = __( 'デザインリスト', 'dg-style' );
    $text_option2 = __( 'ローディングデザインを追加する', 'dg-style' );
    
    return <<< EOM
        <div id="animation-design-area" class="common-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn none-confrim-area"></div>
                <div class="window-close header-btn none-confrim-area"></div>
            </div>
            <div class="window-content part-list">
                <div class="window-title">{$text_option1}</div>
                <div id="anime-design-list" class="anime-design-list-design">
                    {$html_list }
                    <div class="design-item add-anime-design" title="{$text_option2}"></div>
                </div>
                <input type="hidden" class="template-value-input" id="animation-template-input" value="{$template_value}" data-level="animation">
            </div>
        </div>
EOM;
}

/*
 * Informationウィンドウ
*/
function window_site_builder_manual() {
    //翻訳
    $text_menu_title = __( 'マニュアル', 'dg-style' );
    return <<< EOM
        <div id="site-builder-manual" class="common-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="manual-close header-btn none-confrim-area"></div>
            </div>
            <div class="window-content">
                <div id="site-builder-manual-content"></div>
            </div>
        </div>
EOM;
}

/*
 * historyウィンドー
*/
function window_site_builder_history() {
    //翻訳
    $text_menu_title = __( 'ヒストリー', 'dg-style' );
    $text_title = __( '作業履歴', 'dg-style' );
    return <<< EOM
        <div id="site-builder-history" class="common-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn none-confrim-area"></div>
                <div class="window-close header-btn none-confrim-area"></div>
            </div>
            <div class="window-content">
                <div class="window-title">{$text_title}</div>
                <div id="history-list"></div>
            </div>
        </div>
EOM;
}

/*
 * Informationウィンドウ
*/
function window_css_total( $page_list, $device_list, $lp_flg ) {
    $text_top_page = __( 'TOPページ', 'dg-style' );
    $text_css_all = __( '共通', 'dg-style' );
    $text_critical_css = __( 'クリティカルCSS登録', 'dg-style' );
    $page_type = '';
    $page_content = '';
    foreach( (array)$page_list as $key => $value ) {
        if ( $key === 'top' ) {
            $page_type .= '<button type="button" class="tab-label css-total-label top">' . $text_top_page . '</button>';
            $page_content .= '<div class="tab-content css-total-content top"><div class="css-total-critical-area"><label class="check-toggle-label"><input type="checkbox" class="css-total-critical" value="1" data-level="top"><span class="check-name">' . $text_critical_css . '</span><span class="check-button"></span></label></div><textarea class="css-total-input" data-level="top" rows="15" placeholder="' . $text_top_page . '"></textarea></div>';
        } elseif ( $lp_flg !== 'lp' ) {
            if ( $key === 'taxonomy' ) {
                $label = __( 'カテゴリー種類', 'dg-style' );
            } elseif ( $key === 'custom-post-archive' ) {
                $label = __( '記事タイプ種類', 'dg-style' );
            } elseif ( $key === 'single' ) {
                $label = __( '記事種類', 'dg-style' );
            } elseif ( $key === 'other' ) {
                $label = __( 'その他', 'dg-style' );
            }
            $page_type .= '<button type="button" class="tab-label css-total-label ' . $key . '">' . $label . '</button>';
            $child_tabs = '';
            $child_contents = '';
            if ( $key === 'taxonomy' || $key === 'single' ) {
                $child_tabs .= '<button type="button" class="tab-label css-total-child-label ' . $key . ' on">' . $text_css_all . '</button>';
                $child_contents .= '<div class="tab-content css-total-child-content ' . $key . ' on"><div class="css-total-critical-area"><label class="check-toggle-label"><input type="checkbox" class="css-total-critical" value="1" data-level="' . $key . '"><span class="check-name">' . $text_critical_css . '</span><span class="check-button"></span></label></div><textarea class="css-total-input" data-level="' . $key . '" rows="15" placeholder="' . $text_css_all . '"></textarea></div>';
            }
            foreach( (array)$value as $slug => $name ) {
                $on_class = '';
                if ( $key !== 'taxonomy' && $key !== 'single' && $name === reset( $value ) ) {
                    $on_class = ' on';
                }
                $child_tabs .= '<button type="button" class="tab-label css-total-child-label ' . $key . '-' . $slug . $on_class . '">' . $name . '</button>';
                $child_contents .= '<div class="tab-content css-total-child-content ' . $key . '-' . $slug . $on_class . '"><div class="css-total-critical-area"><label class="check-toggle-label"><input type="checkbox" class="css-total-critical" value="1" data-level="' . $key . '-' . $slug . '"><span class="check-name">' . $text_critical_css . '</span><span class="check-button"></span></label></div><textarea class="css-total-input" data-level="' . $key . '-' . $slug . '" rows="15" placeholder="' . $name . '"></textarea></div>';
            }
            $page_content .= '<div class="tab-content css-total-content ' . $key . '"><div class="tab-inner css-total-child-tab-inner"><div class="tab-list css-total-child-labels">' . $child_tabs . '</div><div class="tab-contents css-total-child-tab-content">' . $child_contents . '</div></div></div>';
        }
    }
    //共有タブ
    $common_label = '';
    $common_content = '';
    if ( $lp_flg !== 'lp' ) {
        $common_label = '<button type="button" class="tab-label css-total-label all on">' . $text_css_all . '</button>';
        $common_content = <<< EOM
            <div class="tab-content css-total-content all on">
                <div class="css-total-critical-area">
                    <label class="check-toggle-label">
                        <input type="checkbox" class="css-total-critical" value="1" data-level="all">
                        <span class="check-name">{$text_critical_css}</span><span class="check-button"></span>
                    </label>
                </div>
                <textarea class="css-total-input" data-level="all" rows="15" placeholder="{$text_css_all}"></textarea>
            </div>
EOM;
    }
    //翻訳
    $text_menu_title = __( '独自CSS設定', 'dg-style' );
    $text_caution = __( '各ページごとCSSを自由に追加できます。', 'dg-style' );
    return <<< EOM
        <div id="css-total-setting" class="option-window add-part-window">
            <div class="window-header">
                <div class="window-name">{$text_menu_title}</div>
                <div class="window-info header-btn none-confrim-area"></div>
                <div class="window-close header-btn none-confrim-area"></div>
            </div>
            <div class="window-content">
                <div class="site-device-select css-total-device">{$device_list}</div>
                <div class="tab-inner css-total-tab-inner">
                    <div class="tab-list css-total-labels">
                        {$common_label}
                        {$page_type}
                    </div>
                    <div class="tab-contents css-total-tab-contents">
                        {$common_content}
                        {$page_content}
                    </div>
                </div>
                <p class="caution">※{$text_caution}</p>
            </div>
        </div>
EOM;
}

/*
 * アイコンリスト
*/
function window_part_option_menus() {
    $text_label_edit = __( 'デザインラベル編集', 'dg-style' );
    $text_label_placeholder = __( 'ラベル入力', 'dg-style' );
    $text_label_lock = __( 'パーツロック', 'dg-style' );
    $text_label_critical = __( 'クリティカルCSS', 'dg-style' );
    $text_label_critical_reset = __( 'クリティカルCSSリセット', 'dg-style' );
    $text_label_cache = __( 'キャッシュ保存', 'dg-style' );
    $text_label_preload = __( 'preload登録', 'dg-style' );
    $text_label_lazyload = __( 'lazyload解除', 'dg-style' );
    $text_label_moveup = __( '上に移動', 'dg-style' );
    $text_label_movedown = __( '下に移動', 'dg-style' );
    $text_label_movearea = __( 'エリア移動', 'dg-style' );
    $text_label_copy = __( 'パーツコピー', 'dg-style' );
    $text_label_delete = __( 'パーツ削除', 'dg-style' );
    $text_label_title = __( 'パーツタイトル', 'dg-style' );
    $text_label_template = __( 'テンプレート', 'dg-style' );
    $text_label_design = __( 'デザイン設定', 'dg-style' );
    $text_label_option = __( 'オプション', 'dg-style' );
    $text_label_event = __( 'イベント', 'dg-style' );
    $text_label_hidden = __( '非表示設定', 'dg-style' );
    $text_label_dark = __( 'ダークモード', 'dg-style' );
    $text_label_slide = __( 'スライド設定', 'dg-style' );
    $text_label_parent = __( '親エリア', 'dg-style' );
    $text_label_add = __( 'パーツ追加', 'dg-style' );
    return <<< EOM
        <div id="part-option-menu-area">
            <div class="moving-panel none-confrim-area">
                <div class="part-name-panel">
                    <span id="part-names"></span>
                    <button type="button" id="edit-part-name-btn" title="{$text_label_edit}"></button>
                    <input type="text" id="edit-part-name-input" placeholder="{$text_label_placeholder}" title="{$text_label_edit}">
                </div>
                <button type="button" class="btn-design" id="part-lock-btn" title="{$text_label_lock}"></button>
                <button type="button" class="btn-design" id="part-critical-btn" title="{$text_label_critical}"></button>
                <button type="button" class="btn-design" id="reset-critical-css" title="{$text_label_critical_reset}"></button>
                <button type="button" class="btn-design" id="part-cache-btn" title="{$text_label_cache}"></button>
                <button type="button" class="btn-design" id="part-preload-btn" title="{$text_label_preload}"></button>
                <button type="button" class="btn-design" id="part-lazyload-btn" title="{$text_label_lazyload}"></button>
                <button type="button" class="btn-design" id="part-copy-btn" title="{$text_label_copy}"></button>
            </div>
            <div class="menu-btns">
                <button type="button" class="menu-btn-design part-option-btn title" title="{$text_label_title}"></button>
                <button type="button" class="menu-btn-design part-option-btn template" title="{$text_label_template}"></button>
                <button type="button" class="menu-btn-design part-option-btn design" title="{$text_label_design}"></button>
                <button type="button" class="menu-btn-design part-option-btn option" title="{$text_label_option}"></button>
                <button type="button" class="menu-btn-design part-option-btn event" title="{$text_label_event}"></button>
                <button type="button" class="menu-btn-design part-option-btn hidden" title="{$text_label_hidden}"></button>
                <button type="button" class="menu-btn-design part-option-btn slide" title="{$text_label_slide}"></button>
                <button type="button" class="menu-btn-design part-option-btn dark" title="{$text_label_dark}"></button>
                <button type="button" class="menu-btn-design part-option-btn move-up" title="{$text_label_moveup}"></button>
                <button type="button" class="menu-btn-design part-option-btn move-down" title="{$text_label_movedown}"></button>
                <button type="button" class="menu-btn-design part-option-btn move-area" title="{$text_label_movearea}"></button>
                <button type="button" class="menu-btn-design part-option-btn parent" title="{$text_label_parent}"></button>
                <button type="button" class="menu-btn-design part-option-btn add-part" title="{$text_label_add}"></button>
                <button type="button" class="menu-btn-design part-option-btn delete" title="{$text_label_delete}"></button>
            </div>
            <div id="part-menu-content"></div>
        </div>
EOM;
}

/*
 * アイコンリスト
*/
function window_web_icon_list() {
    $icon_list = array( 'icon-home','icon-home2','icon-home3','icon-office','icon-newspaper','icon-pencil','icon-pencil2','icon-quill','icon-pen','icon-blog','icon-eyedropper','icon-droplet','icon-paint-format','icon-image','icon-images','icon-camera','icon-headphones','icon-music','icon-play','icon-film','icon-video-camera','icon-dice','icon-pacman','icon-spades','icon-clubs','icon-diamonds','icon-bullhorn','icon-connection','icon-podcast','icon-feed','icon-mic','icon-book','icon-books','icon-library','icon-file-text','icon-profile','icon-file-empty','icon-files-empty','icon-file-text2','icon-file-picture','icon-file-music','icon-file-play','icon-file-video','icon-file-zip','icon-copy','icon-paste','icon-stack','icon-folder','icon-folder-open','icon-folder-plus','icon-folder-minus','icon-folder-download','icon-folder-upload','icon-price-tag','icon-price-tags','icon-barcode','icon-qrcode','icon-ticket','icon-cart','icon-coin-dollar','icon-coin-euro','icon-coin-pound','icon-coin-yen','icon-credit-card','icon-calculator','icon-lifebuoy','icon-phone','icon-phone-hang-up','icon-address-book','icon-envelop','icon-pushpin','icon-location','icon-location2','icon-compass','icon-compass2','icon-map','icon-map2','icon-history','icon-clock','icon-clock2','icon-alarm','icon-bell','icon-stopwatch','icon-calendar','icon-printer','icon-keyboard','icon-display','icon-laptop','icon-mobile','icon-mobile2','icon-tablet','icon-tv','icon-drawer','icon-drawer2','icon-box-add','icon-box-remove','icon-download','icon-upload','icon-floppy-disk','icon-drive','icon-database','icon-undo','icon-redo','icon-undo2','icon-redo2','icon-forward','icon-reply','icon-bubble','icon-bubbles','icon-bubbles2','icon-bubble2','icon-bubbles3','icon-bubbles4','icon-user','icon-users','icon-user-plus','icon-user-minus','icon-user-check','icon-user-tie','icon-quotes-left','icon-quotes-right','icon-hour-glass','icon-spinner','icon-spinner2','icon-spinner3','icon-spinner4','icon-spinner5','icon-spinner6','icon-spinner7','icon-spinner8','icon-spinner9','icon-spinner10','icon-spinner11','icon-binoculars','icon-search','icon-zoom-in','icon-zoom-out','icon-enlarge','icon-shrink','icon-enlarge2','icon-shrink2','icon-key','icon-key2','icon-lock','icon-unlocked','icon-wrench','icon-equalizer','icon-equalizer2','icon-cog','icon-cogs','icon-hammer','icon-magic-wand','icon-aid-kit','icon-bug','icon-pie-chart','icon-stats-dots','icon-stats-bars','icon-stats-bars2','icon-trophy','icon-gift','icon-glass','icon-glass2','icon-mug','icon-spoon-knife','icon-leaf','icon-rocket','icon-meter','icon-meter2','icon-hammer2','icon-fire','icon-lab','icon-magnet','icon-bin','icon-bin2','icon-briefcase','icon-airplane','icon-truck','icon-road','icon-accessibility','icon-target','icon-shield','icon-power','icon-switch','icon-power-cord','icon-clipboard','icon-list-numbered','icon-list','icon-list2','icon-tree','icon-menu','icon-menu2','icon-menu3','icon-menu4','icon-cloud','icon-cloud-download','icon-cloud-upload','icon-cloud-check','icon-download2','icon-upload2','icon-download3','icon-upload3','icon-sphere','icon-earth','icon-link','icon-flag','icon-attachment','icon-eye','icon-eye-plus','icon-eye-minus','icon-eye-blocked','icon-bookmark','icon-bookmarks','icon-sun','icon-night','icon-brightness-contrast','icon-star-empty','icon-star-half','icon-star-full','icon-heart','icon-heart-broken','icon-man','icon-woman','icon-man-woman','icon-happy','icon-happy2','icon-smile','icon-smile2','icon-tongue','icon-tongue2','icon-sad','icon-sad2','icon-wink','icon-wink2','icon-grin','icon-grin2','icon-cool','icon-cool2','icon-angry','icon-angry2','icon-evil','icon-evil2','icon-shocked','icon-shocked2','icon-baffled','icon-baffled2','icon-confused','icon-confused2','icon-neutral','icon-neutral2','icon-hipster','icon-hipster2','icon-wondering','icon-wondering2','icon-sleepy','icon-sleepy2','icon-frustrated','icon-frustrated2','icon-crying','icon-crying2','icon-point-up','icon-point-right','icon-point-down','icon-point-left','icon-warning','icon-notification','icon-question','icon-plus','icon-minus','icon-info','icon-cancel-circle','icon-blocked','icon-cross','icon-checkmark','icon-checkmark2','icon-spell-check','icon-enter','icon-exit','icon-play2','icon-pause','icon-stop','icon-previous','icon-next','icon-backward','icon-forward2','icon-play3','icon-pause2','icon-stop2','icon-backward2','icon-forward3','icon-first','icon-last','icon-previous2','icon-next2','icon-eject','icon-volume-high','icon-volume-medium','icon-volume-low','icon-volume-mute','icon-volume-mute2','icon-volume-increase','icon-volume-decrease','icon-loop','icon-loop2','icon-infinite','icon-shuffle','icon-arrow-up-left','icon-arrow-up','icon-arrow-up-right','icon-arrow-right','icon-arrow-down-right','icon-arrow-down','icon-arrow-down-left','icon-arrow-left','icon-arrow-up-left2','icon-arrow-up2','icon-arrow-up-right2','icon-arrow-right2','icon-arrow-down-right2','icon-arrow-down2','icon-arrow-down-left2','icon-arrow-left2','icon-circle-up','icon-circle-right','icon-circle-down','icon-circle-left','icon-tab','icon-move-up','icon-move-down','icon-sort-alpha-asc','icon-sort-alpha-desc','icon-sort-numeric-asc','icon-sort-numberic-desc','icon-sort-amount-asc','icon-sort-amount-desc','icon-command','icon-shift','icon-ctrl','icon-opt','icon-checkbox-checked','icon-checkbox-unchecked','icon-radio-checked','icon-radio-checked2','icon-radio-unchecked','icon-crop','icon-make-group','icon-ungroup','icon-scissors','icon-filter','icon-font','icon-ligature','icon-ligature2','icon-text-height','icon-text-width','icon-font-size','icon-bold','icon-underline','icon-italic','icon-strikethrough','icon-omega','icon-sigma','icon-page-break','icon-superscript','icon-subscript','icon-superscript2','icon-subscript2','icon-text-color','icon-pagebreak','icon-clear-formatting','icon-table','icon-table2','icon-insert-template','icon-pilcrow','icon-ltr','icon-rtl','icon-section','icon-paragraph-left','icon-paragraph-center','icon-paragraph-right','icon-paragraph-justify','icon-indent-increase','icon-indent-decrease','icon-share','icon-new-tab','icon-embed','icon-embed2','icon-terminal','icon-share2','icon-mail','icon-mail2','icon-mail3','icon-mail4','icon-amazon','icon-google','icon-google2','icon-google3','icon-google-plus','icon-google-plus2','icon-google-plus3','icon-hangouts','icon-google-drive','icon-facebook','icon-facebook2','icon-instagram','icon-whatsapp','icon-spotify','icon-telegram','icon-twitter','icon-vine','icon-vk','icon-renren','icon-sina-weibo','icon-rss','icon-rss2','icon-youtube','icon-youtube2','icon-twitch','icon-vimeo','icon-vimeo2','icon-lanyrd','icon-flickr','icon-flickr2','icon-flickr3','icon-flickr4','icon-dribbble','icon-behance','icon-behance2','icon-deviantart','icon-500px','icon-steam','icon-steam2','icon-dropbox','icon-onedrive','icon-github','icon-npm','icon-basecamp','icon-trello','icon-wordpress','icon-joomla','icon-ello','icon-blogger','icon-blogger2','icon-tumblr','icon-tumblr2','icon-yahoo','icon-yahoo2','icon-tux','icon-appleinc','icon-finder','icon-android','icon-windows','icon-windows8','icon-soundcloud','icon-soundcloud2','icon-skype','icon-reddit','icon-hackernews','icon-wikipedia','icon-linkedin','icon-linkedin2','icon-lastfm','icon-lastfm2','icon-delicious','icon-stumbleupon','icon-stumbleupon2','icon-stackoverflow','icon-pinterest','icon-pinterest2','icon-xing','icon-xing2','icon-flattr','icon-foursquare','icon-yelp','icon-paypal','icon-chrome','icon-firefox','icon-IE','icon-edge','icon-safari','icon-opera','icon-file-pdf','icon-file-openoffice','icon-file-word','icon-file-excel','icon-libreoffice','icon-html-five','icon-html-five2','icon-css3','icon-git','icon-codepen','icon-svg','icon-IcoMoon','icon-line1','icon-line2','icon-arrow-up3','icon-arrow-right3','icon-arrow-down3','icon-arrow-left3','hatena', 'pocket', 'jagged', 'crown', 'crown2', );
    $cnt = 1;
    $icon = '';
    foreach( (array)$icon_list as $name ) {
        $code = 'e' . sprintf('%03d', $cnt );
        $icon .= '<button type="button" class="web-icon-item ' . $name . '" data-icon="' . $name . '" data-code="' . $code . '"></button>';
        ++$cnt;
    }
    //翻訳
    $text_menu_title = __( 'アイコン検索', 'dg-style' );
    return <<< EOM
        <div id="web-icon-area" class="web-icon-area">
            <input type="text" class="search-web-icon" placeholder="{$text_menu_title}">
            <div class="web-icon-list search-web-icons"></div>
            <div class="web-icon-list all-web-icons">{$icon}</div>
        </div>
EOM;
}