<?php
/*
 * wp_head()の要らない削除
*/
remove_action( 'wp_head', 'rel_canonical' );
remove_action( 'wp_head', 'wp_generator'); /* WPバージョン */
remove_action( 'wp_head', 'rsd_link'); /* 外部ツールでの記事更新URL */
remove_action( 'wp_head', 'wlwmanifest_link'); /* Windows Live Writerを使って記事を投稿 */
remove_action( 'wp_head', 'wp_oembed_add_host_js'); /* wp-embed.min.js削除 */
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );
remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
remove_action( 'wp_print_styles', 'print_emoji_styles' );
remove_filter( 'the_content', 'wpautop' );

/*
 * wp_head()の中に追加＆各種設定
*/
add_action( 'after_setup_theme', 'dony_tem_setup', 10 );
function dony_tem_setup() {	
    register_nav_menus( array(
        'gmenu' => __( 'グローバルメニュー', 'dg-style' ),
    ) );
}

function post_thumbnail_src( $post ) {
    if ( $result = post_thum_img( $post ) ) {
        return $result;
    } elseif ( $result = post_first_image( $post ) ) {
        return $result;
    }
    return false;
}

function post_thum_img( $post ) {
    $thumb_id = get_post_thumbnail_id( $post->ID );
    if ( empty( $thumb_id ) ) {
        return false;
    }
    return post_image_src_list( $thumb_id, $post );
}

function post_image_src_list( $thumb_id, $post = null ) {
    $image_meta = wp_get_attachment_metadata( $thumb_id );
    if ( $image_meta === false || $image_meta === '' ) {
        return false;
    }
    $result = array();
    $dirname = _wp_get_attachment_relative_path( $image_meta[ 'file' ] );
    if ( $dirname ) {
        $dirname = trailingslashit( $dirname );
    }
    $upload_dir = wp_get_upload_dir();
    $image_baseurl = trailingslashit( $upload_dir[ 'baseurl' ] ) . $dirname;
    $image_basename = wp_basename( $image_meta[ 'file' ] );
    $alt = get_post_meta( $thumb_id, '_wp_attachment_image_alt', true );
    if ( $alt === '' && $post !== null && is_object( $post ) ) {
        $alt = $post->post_title;
    }
    $result[ 'alt' ] = $alt;
    $result[ 'full' ] = array(
        'url' => $image_baseurl . $image_basename,
        'width' => $image_meta[ 'width' ],
        'height' => $image_meta[ 'height' ],
    );
    if ( is_array( $image_meta[ 'sizes' ] ) && count( $image_meta[ 'sizes' ] ) > 0 ) {
        foreach( (array)$image_meta[ 'sizes' ] as $size => $value ) {
            $result[ $size ] = array(
                'url' => $image_baseurl . $value[ 'file' ],
                'width' => $value[ 'width' ],
                'height' => $value[ 'height' ],
            );
        }
    }
    return $result;
}

function post_first_image( $post ) {
    $post_id = $post->ID;
    $result = false;
    $first_img = '';
    $output = preg_match_all( '/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches );
    if ( empty( $matches[1][0] ) ) {
        return false;
    }
    $first_img = $matches[1][0];
    $first_img = preg_replace( '/-[0-9]{2,4}x[0-9]{2,4}/', '', $first_img );

    if ( $thumb_id = get_attachment_src_conversion_id( $first_img ) ) {
        $result = post_image_src_list( $thumb_id, $post_id );
    }
    if ( $result === false ) {
        $result = array();
        $result[ 'url' ] = $first_img;
        $result[ 'width' ] = '';
        $result[ 'height' ] = '';
        $result[ 'alt' ] = $post->post_title;
    }
    return $result;
}

function get_attachment_src_conversion_id( $image_src ) {
    global $wpdb;
    $posts = $wpdb->prefix . 'posts';
    $pre = $wpdb->prepare( "SELECT ID FROM $posts WHERE 1=%d AND guid LIKE %s", 1, "%" . $image_src . "%" );
    if( $result = $wpdb->get_results( $pre ) ) {
        return $result[0]->ID;
    }
    return false;
}

/*
 * イメージのURL相対パスに変更
*/
//add_filter( 'wp_get_attachment_url', 'delete_host_from_attachment_url',10 );
function delete_host_from_attachment_url( $url ) {
    $regex = '/^http(s)?:\/\/[^\/\s]+(.*)$/';
    if ( preg_match( $regex, $url, $m ) ) {
        $url = $m[ 2 ];
    }
    return $url;
}

/*
 * WEBP許可
*/
add_filter( 'upload_mimes', 'add_file_types_to_uploads' );
function add_file_types_to_uploads( $mimes ) {
    $mimes[ 'webp' ] = 'image/webp';
    return $mimes;
}

/*
 * メディアのサムネイルからWEBP表示させる
*/
add_filter( 'file_is_displayable_image', 'webp_is_displayable', 10, 2 );
function webp_is_displayable( $result, $path ) {
    if ( $result === false ) {
        $displayable_image_types = array( IMAGETYPE_WEBP );
        $info = @getimagesize( $path );
        if ( empty( $info ) ) {
            $result = false;
        } elseif ( !in_array( $info[ 2 ], $displayable_image_types ) ) {
            $result = false;
        } else {
            $result = true;
        }
    }
    return $result;
}

/*
 * テーマ有効化時にパターン記事の初期設定
*/
add_action( 'after_switch_theme', 'set_init_gutenberg_patterns' );
function set_init_gutenberg_patterns() {
    //初期パターンカテゴリー
    $terms = get_terms( 'patterns_type', array( 'hide_empty' => false ) );
    if ( !is_wp_error( $terms ) && empty( $terms ) ) {
        $result = wp_insert_term( 'Basic', 'patterns_type', array( 'description'=> '', 'slug' => 'basic' ) );
        if ( isset( $result[ 'term_id' ] ) ) {
            //パターンの初期値設定
            $args = array(
                'post_type' => 'dg_patterns',
                'post_status' => 'any',
                'posts_per_page' => -1,
            );
            $query = new WP_Query( $args );
            if ( !$query->have_posts() ) {
                $data = array(
                    'post_title' => 'Service',
                    'post_content' => "<!-- wp:cover {\"overlayColor\":\"post-text\",\"minHeight\":200,\"contentPosition\":\"bottom center\",\"align\":\"full\"} -->\n<div class=\"wp-block-cover alignfull has-post-text-background-color has-background-dim has-custom-content-position is-position-bottom-center\" style=\"min-height:200px\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"タイトルを入力...\",\"fontSize\":\"large\"} -->\n<p class=\"has-text-align-center has-large-font-size\">Service</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:dg-style/service {\"image\":\"circle\"} -->\n<div class=\"wp-block-dg-style-service service-column undefined circle column3\"><!-- wp:dg-style/servicepart {\"childClass\":\"bo-no bow1\"} -->\n<div class=\"wp-block-dg-style-servicepart service-part bo-no bow1\"><div class=\"service-title\">Service-1</div><div class=\"service-content\"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:dg-style/servicepart -->\n\n<!-- wp:dg-style/servicepart {\"childClass\":\"bo-no bow1\"} -->\n<div class=\"wp-block-dg-style-servicepart service-part bo-no bow1\"><div class=\"service-title\">Service-2</div><div class=\"service-content\"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:dg-style/servicepart -->\n\n<!-- wp:dg-style/servicepart {\"childClass\":\"bo-no bow1\"} -->\n<div class=\"wp-block-dg-style-servicepart service-part bo-no bow1\"><div class=\"service-title\">Service-3</div><div class=\"service-content\"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:dg-style/servicepart --></div>\n<!-- /wp:dg-style/service -->\n\n<!-- wp:cover {\"overlayColor\":\"post-sub-1\",\"minHeight\":200,\"contentPosition\":\"bottom center\",\"align\":\"full\"} -->\n<div class=\"wp-block-cover alignfull has-post-sub-1-background-color has-background-dim has-custom-content-position is-position-bottom-center\" style=\"min-height:200px\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"タイトルを入力...\",\"fontSize\":\"large\"} -->\n<p class=\"has-text-align-center has-large-font-size\">About</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:media-text -->\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\"><figure class=\"wp-block-media-text__media\"></figure><div class=\"wp-block-media-text__content\"><!-- wp:paragraph -->\n<p>それならば、この郷士は暇な時 (もっとも、ほとんど一年中暇なのでしたが)、騎士道の本を熱心に読みふけって、狩猟はおろか、財産の管理さえもほとんど完全に忘れるほどだったことを彼らは知っていたに違いありません。さらに彼の情熱は何エーカーもの耕作地を売って読みたい騎士道の本を買い求めるほどで、手に入る限りの本を持ち帰ったのでした。</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaPosition\":\"right\"} -->\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\"><figure class=\"wp-block-media-text__media\"></figure><div class=\"wp-block-media-text__content\"><!-- wp:paragraph -->\n<p>それならば、この郷士は暇な時 (もっとも、ほとんど一年中暇なのでしたが)、騎士道の本を熱心に読みふけって、狩猟はおろか、財産の管理さえもほとんど完全に忘れるほどだったことを彼らは知っていたに違いありません。さらに彼の情熱は何エーカーもの耕作地を売って読みたい騎士道の本を買い求めるほどで、手に入る限りの本を持ち帰ったのでした。</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->",
                    'post_status' => 'publish',
                    'post_author' => get_current_user_id(),
                    'post_type' => 'dg_patterns',
                    'tax_input' => array( 'patterns_type' => array( $result[ 'term_id' ] ) ),
                );
                wp_insert_post( $data );
            }
        }
    }
}