<?php
function output_php_display( $page_obj ) {
    $testab = $page_obj->getTestab();
    $site_name = $page_obj->getSiteName();
    $page_class = $page_obj->getPageClass();
    $main_value = $page_obj->getSiteOption();
    $home_url = $page_obj->getHomeUrl();
    if ( !$main_value ) {
        echo json_encode( false );
        exit();
    }
    $design_value = $main_value[ 'main' ];
    if ( !is_array( $design_value ) || ( is_array( $design_value ) && count( $design_value ) < 1 ) ) {
        return false;
    }
    /* ページ情報取得 */
    $page_info = $page_obj->setCurrentPageInfo();
    $post_summary = $page_obj->getPostSummary();
    $archive = $page_obj->getArchive();
    $result = $page_obj->getCacheDatas();
    $result[ 'post' ] = $post_summary;
    $result[ 'archive' ] = $archive;
    $result[ 'pageClass' ] = $page_class;
    $breadcrumb_obj = new FrontBreadcrumb( $page_obj );
    $breadcrumb = $breadcrumb_obj->getBreadcrumb();
    /* viewリセットチェック */
    check_site_views_reset();
    /* コンテンツ作成 */
    $part_keys = array_keys( $design_value );
    $loading_img = $main_value[ 'loading_image' ];
    $front_summary = array(
        'archive' => $archive,
        'post_summary' => $post_summary,
        'page_info' => $page_info,
        'loading_img' => $loading_img,
        'home_url' => $home_url,
    );
    $summary = array(
        'part_keys' => $part_keys,
        'design_value' => $design_value,
        'front_summary' => $front_summary,
        'today' => new DateTime( wp_date( 'Y-m-d H:i:s' ) ),
        'get' => $_GET,
    );
    $part = front_part_summary( $summary );
    
    $result[ 'page_info' ] = $page_info;
    $result[ 'site_name' ] = $site_name;
    $result[ 'homeUrl' ] = $home_url;
    $result[ 'siteUrl' ] = isset( $main_value[ 'siteUrl' ] ) ? $main_value[ 'siteUrl' ] : site_url();
    $result[ 'breadcrumb' ] = $breadcrumb;
    $result[ 'pcLogo' ] = $main_value[ 'pc_logo' ];
    $result[ 'spLogo' ] = $main_value[ 'sp_logo' ];
    $result[ 'noImage' ] = $main_value[ 'no_image' ];
    $result[ 'fixedImage' ] = isset( $main_value[ 'fixedImage' ] ) ? $main_value[ 'fixedImage' ] : array();
    $result[ 'loadingImg' ] = $loading_img;
    //サイト全体Views
    $result[ 'siteViews' ] = update_site_views();
    if ( is_user_logged_in() ) {
        $current_user = wp_get_current_user();
        $result[ 'logged' ] = $current_user->display_name;
    }
    $result[ 'comment_nonce' ] = wp_create_nonce( 'post_comment_insert' );
    $html = get_site_html( $part, $result );
    //構造化データ
    $html .= create_structured_jsonLD( $page_info, $result );
    $html .= create_structured_breadcrumb_jsonLD( $breadcrumb );
    $page_attr = '';
    if ( isset( $main_value[ 'scroll' ][ 'move' ] ) ) {
        $page_attr .= ' data-move="' . $main_value[ 'scroll' ][ 'move' ] . '"';
    }
    if ( isset( $main_value[ 'scroll' ][ 'speed' ] ) ) {
        $page_attr .= ' data-speed="' . $main_value[ 'scroll' ][ 'speed' ] . '"';
    }
    return '<div id="page" class="' . $page_class . '"' . $page_attr . '>' . $html . '</div>';
}

/*
 * HTML取得
*/
function get_site_html( $part, $result ) {
    $list = create_parts_tree( $part, 'page', 0 );
    ksort( $list );
    return create_site_html( $list, $result );
}

/*
 * パーツのツリー作成
*/
function create_parts_tree( array &$list, $parentId = 'page' ) {
    $result = array();
    foreach( (array)$list as $part_id => &$value ) {
        if ( isset( $value[ 'parent' ] ) && $value[ 'parent' ] === $parentId ) {
            $children = create_parts_tree( $list, $part_id );
            if ( is_array( $children ) && count( $children ) > 0 ) {
                $value[ 'child' ] = $children;
            }
            $value[ 'id' ] = $part_id;
            $result[ $value[ 'order' ] ] = $value;
            unset( $list[ $part_id ] );
        }
    }
    return $result;
}

/*
 * パーツツリーからHTML作成
*/
function create_site_html( $list, $summary, $tab = false ) {
    if ( is_array( $list ) && count( $list ) > 0 ) {
        $html = '';
        $cnt = 0;
        foreach( (array)$list as $value ) {
            $tab_flg = false;
            if ( $cnt === 0 && $tab ) {
                $tab_flg = true;
            } elseif ( $cnt > 0 && $tab ) {
                $tab_flg = 'child';
            }
            ++$cnt;
            if ( $value[ 'type' ] === 'area' ) {
                $html .= create_area_html( $value, $summary, $tab_flg );
            } else {
                $html .= create_parts_html( $value, $summary, $tab_flg );
            }
        }
        return $html;
    }
    return '';
}

/*
 * エリア作成
*/
function create_area_html( $value, $summary, $tab = false ) {
    $html = '';
    $tab_flg = isset( $value[ 'area-type' ] ) && $value[ 'area-type' ] === '2' ? true : false;
    $slide_flg = isset( $value[ 'area-type' ] ) && $value[ 'area-type' ] === '3' ? true : false;
    if ( isset( $value[ 'child' ] ) ) {
        ksort( $value[ 'child' ] );
        $html .= create_site_html( $value[ 'child' ], $summary, $tab_flg );
    }
    //タブコンテンツ
    if ( $tab_flg && isset( $value[ 'child' ] ) ) {
        $label = '';
        $cnt = 0;
        foreach( (array)$value[ 'child' ] as $item ) {
            $label_name = 'tab' . ( $cnt + 1 );
            if ( isset( $value[ 'label' ][ $item[ 'id' ] ] ) && $value[ 'label' ][ $item[ 'id' ] ] !== '' ) {
                $label_name = $value[ 'label' ][ $item[ 'id' ] ];
            }
            $tab_class = '';
            $tab_select = 'false';
            $tabindex = ' tabindex="-1"';
            if ( $cnt === 0 ) {
                $tab_class = ' on';
                $tab_select = 'true';
                $tabindex = '';
                ++$cnt;
            }
            $label .= '<button class="tab-label' . $tab_class . '" type="button" id="' . $value[ 'id' ] . '-' . $item[ 'id' ] . '" role="tab" aria-selected="' . $tab_select . '" aria-controls="' . $item[ 'id' ] . '"' . $tabindex . '><span class="text">' . $label_name . '</span></button>';
        }
        $html = '<div class="tab-labels" role="tablist">' . $label . '</div><div class="tab-contents special-area">' . $html . '</div>';
    }
    //スライド
    if ( $slide_flg === true ) {
        $slide_attr = set_slide_attr( isset( $value[ 'slide' ] ) ? $value[ 'slide' ] : array() );
        $html = '<div class="DGSLIDERITEM special-area"' . $slide_attr . '>' . $html . '</div>';
    }
    $tag = isset( $value[ 'tag' ] ) ? $value[ 'tag' ] : 'div';
    $class = isset( $value[ 'class' ] ) && $value[ 'class' ] !== '' ? 'DGITEM ' . $value[ 'class' ] : 'DGITEM';
    $attr = set_part_attr( $class, $value, $tab );
    return '<' . $tag . ' id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $html . '</' . $tag . '>';
}

/*
 * パーツ出力
*/
function create_parts_html( $value, $summary, $tab = false ) {
    $fun_arr = [
        'image' => 'create_image_part',
        'text' => 'create_text_part',
        'html' => 'create_html_part',
        'movie' => 'create_movie_part',
        'music' => 'create_music_part',
        'post_list' => 'create_post_list_part',
        'taxonomy-post_list' => 'create_post_list_part',
        'single-recommend' => 'create_post_list_part',
        'gmenu' => 'create_gmenu_part',
        'search-form' => 'create_search_form_part',
        'sns' => 'create_page_sns_part',
        'breadcrumb' => 'create_breadcrumb_part',
        'categories' => 'create_category_list_part',
        'tag-cloud' => 'create_tag_cloud_part',
        'archive' => 'create_archive_part',
        'new-comments' => 'create_new_comment_part',
        'author' => 'create_author_part',
        'single-author' => 'create_author_part',
        'post-content' => 'create_select_post_content_part',
        'contact' => 'create_select_contact_part',
        'site-views' => 'create_post_views_part',
        'taxonomy-title' => 'create_taxonomy_title_part',
        'taxonomy-description' => 'create_taxonomy_description_part',
        'taxonomy-page_count' => 'create_taxonomy_page_count_part',
        'taxonomy-brother' => 'create_taxonomy_child_part',
        'taxonomy-child' => 'create_taxonomy_child_part',
        'taxonomy-thumbnail' => 'create_page_thumbnail_part',
        'taxonomy-movie' => 'create_page_thumbnail_movie_part',
        'taxonomy-sort' => 'create_taxonomy_sort_part',
        'taxonomy-paging' => 'create_taxonomy_paging_part',
        'taxonomy-user_sns' => 'create_taxonomy_author_sns_part',
        'single-title' => 'create_post_title_part',
        'single-content' => 'create_post_content_part',
        'single-index' => 'create_post_index_part',
        'single-views' => 'create_post_views_part',
        'single-thumbnail' => 'create_page_thumbnail_part',
        'single-movie' => 'create_page_thumbnail_movie_part',
        'single-taxonomy' => 'create_post_taxonomy_part',
        'single-date' => 'create_post_date_part',
        'single-evaluate' => 'create_post_evaluate_part',
        'single-paging' => 'create_post_paging_part',
        'single-comment' => 'create_post_comment_part',
        'single-postmeta' => 'create_post_postmeta_part',
        'single-bookmark' => 'create_post_bookmark_part',
    ];
    if ( isset( $fun_arr[ $value[ 'slug' ] ] ) ) {
        return $fun_arr[ $value[ 'slug' ] ]( $value, $summary, $tab );
    }
    return '';
}

function get_text_html( $option ) {
    $text = isset( $option[ 'text' ] ) ? $option[ 'text' ] : __( 'テキストを入力してください。', 'dg-style' );
    $span_flg = isset( $option[ 'span' ] ) ? $option[ 'span' ] : '';
    switch ( $span_flg ) {
        case '1' :
            $text = '<span class="text">' . nl2br( $text ) . '</span>';
            break;
        case '2' :
            $text_arr = explode( "\n", $text );
            $cnt = 0;
            $text = '';
            foreach( (array)$text_arr as $txt ) {
                if ( $txt !== '' ) {
                    $text .= '<span class="text no' . ( ++$cnt ) . '">' . $txt . '</span>';
                }
            }
            break;
        default :
            $text = nl2br( $text );
            break;
    }
    return $text;
}

/*
 * パーツタイトル
*/
function create_part_title( $value ) {
    if ( !( isset( $value[ 'title' ][ 'text' ] ) && $value[ 'title' ][ 'text' ] !== '' ) ) return false;
    $title = $value[ 'title' ];
    $tag = isset( $title[ 'tag' ] ) ? $title[ 'tag' ] : 'h2';
    $class = isset( $title[ 'class' ] ) && $title[ 'class' ] !== '' ? ' ' . $title[ 'class' ] : '';
    $text = get_text_html( $title );
    if ( isset( $title[ 'toggle-type' ] ) && $title[ 'toggle-type' ] === '2' ) {
        $text = '<button type="button" class="toggle-btn" data-toggle="' . $value[ 'id' ] . '">' . $text . '</button>';
    }
    return '<' . $tag . ' class="part-title' . $class . '">' . $text . '</' . $tag . '>';
}

/*
 * テキスト作成
*/
function create_text_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'text' ) return false;
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $arr = [
        'tag' => isset( $option[ 'tag' ] ) && $option[ 'tag' ] !== '' ? $option[ 'tag' ] : 'p',
        'item_html' => get_text_html( $option ),
        'option' => $option
    ];
    extract( get_text_image_btn_html( $arr ) );
    $class = 'DGITEM text-part' . $class;
    $attr .= set_part_attr( $class, $value, $tab );
    return '<' . $tag . ' id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"'. $attr . '>' . $item_html . '</' . $tag . '>';
}

/*
 * イメージパーツ
*/
function create_image_part( $value, $summary, $tab = false ) {
    if ( $value[ 'slug' ] !== 'image' ) return false;
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    /* イメージ作成 */
    $type = isset( $option[ 'image-type' ] ) && $option[ 'image-type' ] !== '' ? $option[ 'image-type' ] : '1';
    
    $src = '';
    $src_set = '';
    if ( $type === '5' && isset( $summary[ 'fixedImage' ] ) && is_array( $summary[ 'fixedImage' ] ) && count( $summary[ 'fixedImage' ] ) > 0 ) {
        extract( get_image_src_srcset( $summary[ 'fixedImage' ], $option ) );
    } elseif ( $type === '4' && $summary[ 'spLogo' ] !== '' ) {
        $src = $summary[ 'spLogo' ];
    } elseif ( $type === '3' && $summary[ 'pcLogo' ] !== '' ) {
        $src = $summary[ 'pcLogo' ];
    } elseif ( $type === '2' && isset( $option[ 'image-url' ] ) && $option[ 'image-url' ] !== '' ) {
        $src = $option[ 'image-url' ];
    } elseif ( $type === '1' && isset( $option[ 'image-url' ] ) && is_array( $option[ 'image-url' ] ) && count( $option[ 'image-url' ] ) > 0 ) {
        extract( get_image_src_srcset( $option[ 'image-url' ], $option ) );
    }
    $item_data_arr = [
        'src' => $src,
        'src_set' => $src_set,
        'option' => $option,
        'lazy_flg' => ( isset( $value[ 'lazyload' ] ) && $value[ 'lazyload' ] === '1' ),
        'alt' => isset( $option[ 'image-alt' ] ) ? $option[ 'image-alt' ] : '',
        'loading_img' => $summary[ 'loadingImg' ],
        'no_image' => $summary[ 'noImage' ],
        'no_image_flg' => true,
        'class' => 'image-item',
    ];
    extract( get_image_item_data( $item_data_arr ) );

    $arr = [
        'tag' => isset( $option[ 'tag' ] ) && $option[ 'tag' ] !== '' ? $option[ 'tag' ] : 'div',
        'item_html' => $image,
        'option' => $option
    ];
    extract( get_text_image_btn_html( $arr ) );
    $class = 'DGITEM image-part' . $class . $no_image_class;
    $attr .= set_part_attr( $class, $value, $tab );
    return '<' . $tag . ' id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $item_html . '</' . $tag . '>';
}

/*
 * 動画パーツ
*/
function create_movie_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'movie' ) return false;
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $class = 'DGITEM video-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $movie_arr = [
        'type' => 'movie',
        'option' => $option,
        'attr' => ' playsinline',
        'image_flg' => ( isset( $option[ 'image-url' ] ) && $option[ 'image-url' ] !== '' ),
        'image_src' => isset( $option[ 'image-url' ] ) ? $option[ 'image-url' ] : ''
    ];
    $video_attr = get_movie_music_attr( $movie_arr );
    /* 動画 */
    $source = '';
    if ( isset( $option[ 'movie-url' ] ) && $option[ 'movie-url' ] !== '' ) {
        $movie_src = $option[ 'movie-url' ];
        $video_type = '';
        preg_match( '/\.([^.\?]+)((\?|#).*?)?$/s', $movie_src, $video_match );
        if ( isset( $video_match[ 1 ] ) && $video_match[ 1 ] !== '' ) {
            $video_type = ' type="video/' . $video_match[ 1 ] . '"';
        }
        $source = '<source src="' . $movie_src . '"' . $video_type . '>';
    }
    $video = '<video class="video-item"' . $video_attr . '>' . $source . '</video>';
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $video . '</div>';
}

/*
 * 音楽パーツ
*/
function create_music_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'music' ) return false;
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $class = 'DGITEM music-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $music_arr = [
        'type' => 'music',
        'option' => $option,
        'attr' => ' controls',
        'image_flg' => false,
        'image_src' => false
    ];
    $music_attr = get_movie_music_attr( $music_arr );
    /* 動画 */
    $source = '';
    if ( isset( $option[ 'music-url' ] ) && $option[ 'music-url' ] !== '' ) {
        $audio_type = '';
        preg_match( '/\.([^.\?]+)((\?|#).*?)?$/s', $option[ 'music-url' ], $video_match );
        if ( isset( $video_match[ 1 ] ) && $video_match[ 1 ] !== '' ) {
            $audio_type = ' type="audio/' . $video_match[ 1 ] . '"';
        }
        $source = '<source src="' . $option[ 'music-url' ] . '"' . $audio_type . '>';
    }
    $music = '<audio class="music-item"' . $music_attr . '>' . $source . '</audio>';
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $music . '</div>';
}

/*
 * カテゴリーリスト用パーツ
*/
function create_one_category_part( $summary ) {
    extract( $summary );
    $fun_arr = [
        'thumbnail' => 'get_part_item_thumbnail',
        'fixed' => 'get_part_item_thumbnail',
        'movie' => 'get_part_item_thumbnail',
        'title' => 'get_part_item_text',
        'sub' => 'get_part_item_text',
        'content' => 'get_part_item_description',
        'more' => 'get_part_item_more',
    ];
    if ( isset( $fun_arr[ $item[ 'slug' ] ] ) ) {
        return $fun_arr[ $item[ 'slug' ] ]( $summary );
    }
    return '';
}

/*
 * カテゴリーリスト用エリア作成
*/
function create_part_items_area( $summary ) {
    extract( $summary );
    $html = '';
    foreach( (array)$area_list as $value ) {
        $child = '';
        if ( isset( $value[ 'child' ] ) ) {
            $child = create_part_items_area( array( 'item_fun' => $item_fun, 'area_list' => $value[ 'child' ], 'post_value' => $post_value, 'url' => $url, 'info' => $info, 'lazyload' => $lazyload, 'part_slug' => $part_slug ) );
        }
        if ( $value[ 'slug' ] === 'area' && $value[ 'id' ] !== 'all' ) {
            $html .= '<div class="' . $value[ 'id' ] . '">' . $child . '</div>';
        } elseif ( $value[ 'slug' ] !== 'area' ) {
            $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
            $html .= $item_fun( array( 'value' => $post_value, 'item' => $value, 'url' => $url, 'option' => $option, 'info' => $info, 'lazyload' => $lazyload, 'part_slug' => $part_slug ) );
        }
    }
    return $html;
}

/*
 * カテゴリーリスト
*/
function create_category_list_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'categories' ) return false;
    $part_title = create_part_title( $value );
    $list = get_part_item_categories( $value, $info );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $class = 'DGITEM category-list-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $list . '</div>';
}

/*
 * タグクラウド
*/
function create_tag_cloud_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'tag-cloud' ) return false;
    $part_title = create_part_title( $value );
    $list = get_part_item_tag_cloud( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $class = 'DGITEM tag-cloud-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $list . '</div>';
}

/*
 * アカイブ
*/
function create_archive_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'archive' ) return false;
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $class = 'DGITEM archive-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    if ( $option[ 'format' ] === 'html' ) {
        $list = '<ul class="archive-list">' . $option[ 'list' ] . '</ul>';
    } else {
        $list = '<select class="archive-list child-terms-select">' . $option[ 'list' ] . '</select>';
    }
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $list . '</div>';
}

/*
 * 記事リストパーツ作成
*/
function create_one_comment_part( $summary ) {
    extract( $summary );
    $fun_arr = [
        'title' => 'get_part_item_text',
        'comment' => 'get_part_item_text',
        'author' => 'get_part_item_text',
        'date' => 'get_part_item_date',
        'more' => 'get_part_item_more',
    ];
    if ( isset( $fun_arr[ $item[ 'slug' ] ] ) ) {
        return $fun_arr[ $item[ 'slug' ] ]( $summary );
    }
    return '';
}

/*
 * 最新コメント
*/
function create_new_comment_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'new-comments' ) return false;
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $comment_list = get_part_item_comment_list( $value, $info );
    $class = 'DGITEM new-comment-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $comment_list . '</div>';
}

/*
 * HTML
*/
function create_html_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'html' ) return false;
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $tag = isset( $option[ 'tag' ] ) && $option[ 'tag' ] !== '' ? $option[ 'tag' ] : 'div';
    $content = isset( $option[ 'content' ] ) ? $option[ 'content' ] : '';
    $class = 'DGITEM html-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<' . $tag . ' id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $content . '</' . $tag . '>';
}

/*
 * 作成者プロフィールパーツ
*/
function create_one_author_part( $summary ) {
    extract( $summary );
    $fun_arr = [
        'user_image' => 'get_part_item_thumbnail',
        'bg_image' => 'get_part_item_thumbnail',
        'fixed' => 'get_part_item_thumbnail',
        'movie_thumbnail' => 'get_part_item_thumbnail',
        'gravatar' => 'get_part_item_gravatar',
        'user_sns' => 'get_part_item_user_sns',
        'name' => 'get_part_item_text',
        'description' => 'get_part_item_description',
        'more' => 'get_part_item_more',
    ];
    if ( isset( $fun_arr[ $item[ 'slug' ] ] ) ) {
        return $fun_arr[ $item[ 'slug' ] ]( $summary );
    }
    return '';
}

/*
 * 作成者プロフィール
*/
function create_author_part( $value, $info, $tab = false ) {
    if ( !( $value[ 'slug' ] === 'author' || ( $info[ 'post' ] && $value[ 'slug' ] === 'single-author' ) ) ) return false;
    $part_title = create_part_title( $value );
    $list = get_part_item_author( $value, $info );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $class = 'DGITEM author-part';
    if ( $value[ 'slug' ] === 'single-author' ) {
        $class = 'DGITEM single-author-part';
    }
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $list . '</div>';
}

/*
 * 記事コンテンツパーツ用
*/
function create_select_post_content_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'post-content' || !isset( $info[ 'selectPosts' ] ) ) return false;
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $inner = get_part_item_select_content( $value, $option, $info );
    $class = 'DGITEM post-contents-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $inner . '</div>';
}

/*
 * 記事コンテンツパーツ用
*/
function create_select_contact_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'contact' || !isset( $info[ 'contactList' ] ) ) return false;
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $inner = '';
    if ( isset( $option[ 'id' ] ) && $option[ 'id' ] !== '' ) {
        if ( isset( $info[ 'contactList' ][ $option[ 'id' ] ] ) ) {
            $nonce = wp_create_nonce( 'dg_contact' . $option[ 'id' ] . $value[ 'id' ] );
            $inner = '<form method="post" data-form="' . $option[ 'id' ] . '" class="dg-contact-form" data-nonce="' . $nonce . '">' . $info[ 'contactList' ][ $option[ 'id' ] ] . '<div class="dg-contact-message"></div></form>';
        }
    }
    $class = 'DGITEM contact-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $inner . '</div>';
}

/* -------------------------------
 * 記事リストパーツ作成
------------------------------- */
/*
 * サムネイル作成
*/
function create_one_post_thumbnail( $summary ) {
    extract( $summary );
    $size = 'thumbnail';
    if ( isset( $option[ 'thumbnail-size' ] ) ) {
        $size = $option[ 'thumbnail-size' ];
    }
    extract( get_image_src_srcset( $value, $option ) );
    $item_data_arr = [
        'src' => $src,
        'src_set' => $src_set,
        'option' => $option,
        'lazy_flg' => ( isset( $option[ 'nolazy' ] ) || isset( $lazyload ) && $lazyload === '1' ),
        'alt' => isset( $value[ 'alt' ] ) && $value[ 'alt' ] !== '' ? $value[ 'alt' ] : $title . __( 'のサムネイル', 'dg-style' ),
        'loading_img' => $info[ 'loadingImg' ],
        'no_image' => $info[ 'noImage' ],
        'no_image_flg' => true,
        'class' => 'thumb-img',
    ];
    extract( get_image_item_data( $item_data_arr ) );

    $class = isset( $option[ 'class' ] ) && $option[ 'class' ] !== '' ? 'thumb-image ' . $option[ 'class' ] : 'thumb-image';
    $class .= $no_image_class;
    if ( $add_class !== '' ) {
        $class .= ' ' . $add_class;
    }
    //動画サムネイルの場合
    $movie_class = '';
    $movie_attr = '';
    if ( isset( $option[ 'movie' ] ) && $option[ 'movie' ] !== '' ) {
        $class .= ' movie-thumbnail';
        $movie_class = ' play-video-item';
        $movie_attr = ' data-movie="' . $option[ 'movie' ] . '"';
    }
    if ( isset( $option[ 'link' ] ) && $option[ 'link' ] === '1' ) {
        $link_url = $url;
        if ( isset( $option[ 'link-type' ] ) && $option[ 'link-type' ] === '1' ) {
            if ( isset( $value[ 'full' ][ 'url' ] ) && $value[ 'full' ][ 'url' ] !== '' ) {
                $link_url = $value[ 'full' ][ 'url' ];
                $movie_class .= ' DGLIGHTBOX';
            } elseif ( isset( $value[ 'url' ] ) ) {
                $link_url = $value[ 'url' ];
                $movie_class .= ' DGLIGHTBOX';
            } else {
                $link_url = '';
            }
        }
        if ( $link_url ) {
            $rel = '';
            if ( $add_class === 'author-image' ) {
                $rel = ' rel="author"';
            }
            $image = '<a href="' . $link_url . '" class="page-link link-tag' . $movie_class . '"' . $movie_attr . ' aria-label="' . $title . __( 'のページをもっと見る', 'dg-style' ) . '"' . $rel . '>' . $image . '</a>';
            $movie_class = '';
            $movie_attr = '';
        }
    }
    return '<div class="' . $class . $movie_class .'"' . $movie_attr . '>' . $image . '</div>';
}

/*
 * 記事リストパーツ作成
*/
function create_one_post_part( $summary ) {
    extract( $summary );
    $fun_arr = [
        'thumbnail' => 'get_part_item_thumbnail',
        'fixed' => 'get_part_item_thumbnail',
        'movie' => 'get_part_item_thumbnail',
        'title' => 'get_part_item_text',
        'content' => 'get_part_item_description',
        'date' => 'get_part_item_date',
        'views' => 'get_part_item_views_hot',
        'hot' => 'get_part_item_views_hot',
        'evaluate' => 'get_part_item_evaluate',
        'comment' => 'get_part_item_comment',
        'author' => 'get_part_item_author_name',
        'author_image' => 'get_part_item_thumbnail',
        'postmeta' => 'get_part_item_postmeta',
        'new' => 'get_part_item_new_mark',
        'bookmark' => 'get_part_item_bookmark',
        'sns' => 'get_part_item_sns',
        'more' => 'get_part_item_more',
    ];
    if ( isset( $fun_arr[ $item[ 'slug' ] ] ) ) {
        return $fun_arr[ $item[ 'slug' ] ]( $summary );
    } else {
        return get_part_item_taxonomy( $summary );
    }
    return '';
}

/*
 * 記事リスト用エリアツリー作成
*/
function create_post_parts_tree( array &$list, $parentId = 'page' ) {
    $result = array();
    foreach( (array)$list as $part_id => &$value ) {
        if ( isset( $value[ 'parent' ] ) && $value[ 'parent' ] === $parentId ) {
            $children = create_post_parts_tree( $list, $part_id );
            if ( !empty( $children ) ) {
                $value[ 'child' ] = $children;
            }
            $value[ 'id' ] = $part_id;
            $result[ $value[ 'id' ] ] = $value;
            unset( $list[ $part_id ] );
        }
    }
    return $result;
}

/*
 * 記事リスト作成
*/
function create_post_list_part( $value, $info, $tab = false ) {
    if ( !( $value[ 'slug' ] === 'post_list' || ( $info[ 'archive' ] !== false && $value[ 'slug' ] === 'taxonomy-post_list' ) || ( $info[ 'post' ] !== false && $value[ 'slug' ] === 'single-recommend' ) ) ) return false;
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $post_list = get_part_item_post_list( $value, $info );
    $class = 'DGITEM post-list-area';
    $slug = isset( $value[ 'slug' ] ) ? $value[ 'slug' ] : '';
    if ( $slug === 'taxonomy-post_list' ) {
        $class .= ' DGTAXITEM taxonomy-post-list-part';
    } else if ( $slug === 'single-recommend' ) {
        $class .= ' recommend-post-list-part';
    } else {
        $class .= ' post-list-part';
    }
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    if ( isset( $option[ 'bookmark' ] ) && $option[ 'bookmark' ] === '1' ) {
        $class .= ' DGBOOKMARKLIST';
    }
    $attr = set_part_attr( $class, $value, $tab );
    $part_id = '';
    if ( isset( $value[ 'id' ] ) ) {
        $part_id = ' id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"';
    }
    return '<div' . $part_id . $attr . '>' . $part_title . $post_list . '</div>';
}

/*
 * SNSボタン
*/
function create_page_sns_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'sns' ) return false;
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $url = ( empty( $_SERVER[ 'HTTPS' ] ) ? 'http://' : 'https://') . $_SERVER[ 'HTTP_HOST' ] . $_SERVER[ 'REQUEST_URI' ];
    $sns_btn = get_part_item_sns_list( $option, $url );
    $class = 'DGITEM sns-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $sns_btn . '</div>';
}

/*
 * パンくずリスト
*/
function create_breadcrumb_part( $value, $info, $tab = false ) {
    $breadcrumb = $info[ 'breadcrumb' ];
    if ( $value[ 'slug' ] !== 'breadcrumb' || !( is_array( $breadcrumb ) && count( $breadcrumb ) > 0 ) ) return false;
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) && $value[ 'option' ] !== '' && $value[ 'option' ] !== false ? $value[ 'option' ] : '';
    $bread = get_part_item_breadcrumb( $breadcrumb, $option );
    $class = 'DGITEM breadcrumb-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $bread . '</div>';
}


function create_gmenu_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'gmenu' ) return false;
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    if ( isset( $option[ 'gmenu-type' ] ) && $option[ 'gmenu-type' ] !== '' && isset( $info[ 'gmenu' ][ $option[ 'gmenu-type' ] ] ) && $info[ 'gmenu' ][ $option[ 'gmenu-type' ] ] !== false ) {
        $gmenu = get_part_item_gmenu_list( $info[ 'gmenu' ][ $option[ 'gmenu-type' ] ], $option );
        $gmenu = '<ul class="menu-list menu-level-0">' . $gmenu . '</ul>';
    } else {
        $gmenu = '<p class="none-menu-text">' . __( 'メニューが選択されてません。', 'dg-style' ) . '</p>';
    }
    $class = 'DGITEM gmenu-part global-menu';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . '<nav class="g-nav">' . $gmenu . '</nav></div>';
}

/*
 * 検索フォーム
*/
function create_one_search_part( $summary ) {
    extract( $summary );
    $fun_arr = [
        'input' => 'get_part_item_search_input',
        'submit' => 'get_part_item_search_btns',
        'speech' => 'get_part_item_search_btns',
        'free' => 'get_part_item_search_btns',
        'lang' => 'get_part_item_search_lang',
        'srange' => 'get_part_item_search_srange',
    ];
    if ( isset( $fun_arr[ $item[ 'slug' ] ] ) ) {
        return $fun_arr[ $item[ 'slug' ] ]( $summary );
    } else {
        return get_part_item_search_taxonomy( $summary );
    }
    return '';
}

function create_search_form_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'search-form' ) return false;
    $home_url = $info[ 'homeUrl' ];
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $area = isset( $option[ 'area' ] ) ? $option[ 'area' ] : array();
    if ( is_array( $area ) && count( $area ) <= 1 ) {
        $area = array(
            'all' => array(
                'slug' => 'area'
            ),
            'input-1' => array(
                'slug' => 'input',
                'parent' => 'all',
                'option' => array(
                    'text' => __( 'キーワードを入力', 'dg-style' ),
                    'class' => '',
                ),
            ),
            'submit-2' => array(
                'slug' => 'submit',
                'parent' => 'all',
                'option' => array(
                    'text' => __( '検索', 'dg-style' ),
                    'class' => '',
                ),
            ),
        );
    }
    if ( isset( $option[ 'realtime' ] ) ) {
        $info[ 'realtime' ] = $option[ 'realtime' ];
    }
    $area_list = create_post_parts_tree( $area, 'all' );
    $search_item = create_part_items_area( [ 'item_fun' => 'create_one_search_part', 'area_list' => $area_list, 'post_value' => [], 'url' => '', 'info' => $info, 'lazyload' => '', 'part_slug' => $value[ 'slug' ] ] );
    $tax_select = '';
    $tax_flg = false;
    foreach( (array)$area as $key => $val ) {
        if ( strpos( $key, 'tax-' ) !== false ) {
            $tax_flg = true;
            break;
        }
    }
    if ( $tax_flg ) {
        $stax_value = isset( $info[ 'page_info' ][ 'stax' ] ) ? $info[ 'page_info' ][ 'stax' ] : '';
        $tax_select = '<input type="hidden" class="selected-taxonomy-input search-item" name="stax" value="' . $stax_value . '">';
    }
    $testab_input = '';
    if ( isset( $info[ 'page_info' ][ 'testab' ] ) && $info[ 'page_info' ][ 'testab' ] !== '' ) {
        $testab_input = '<input type="hidden" name="testab" value="' . $info[ 'page_info' ][ 'testab' ] . '">';
    }
    $search_form = '<form method="get" action="' . $home_url . '" class="search-form-area">' . $tax_select . $search_item . $testab_input . '</form>';
    $class = 'DGITEM search-form-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    if ( isset( $option[ 'realtime' ] ) && $option[ 'realtime' ] === '1' ) {
        $realtime_area = isset( $option[ 'real' ] ) && is_array( $option[ 'real' ] ) && count( $option[ 'real' ] ) > 0 ? htmlspecialchars( json_encode( $option[ 'real' ] ), ENT_QUOTES, 'UTF-8' ) : '{}';
        $attr .= ' data-area="' . $realtime_area . '"';
        $real_cnt = isset( $option[ 'realcnt' ] ) && $option[ 'realcnt' ] !== '' ? $option[ 'realcnt' ] : 5;
        $attr .= ' data-realcnt="' . $real_cnt . '"';
        $real_none = isset( $option[ 'realnone' ] ) && $option[ 'realnone' ] !== '' ? $option[ 'realnone' ] : 'Not Found';
        $attr .= ' data-realnone="' . $real_none . '"';
    }
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $search_form . '</div>';
}

/* -------------------------------------------
 * 記事一覧ページパーツ
------------------------------------------- */
function create_one_taxonomy_title_part( $summary ) {
    extract( $summary );
    $fun_arr = [
        'title' => 'get_part_item_text',
        'sub' => 'get_part_item_text',
        'free' => 'get_part_item_page_count_text',
    ];
    if ( isset( $fun_arr[ $item[ 'slug' ] ] ) ) {
        return $fun_arr[ $item[ 'slug' ] ]( $summary );
    }
    return '';
}

/*
 * 記事一覧タイトル
*/
function create_taxonomy_title_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'taxonomy-title' || !$info[ 'archive' ] ) return false;
    $page_type = $info[ 'page_info' ][ 'page_type' ];
    $archive = $info[ 'archive' ];
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $area = isset( $option[ 'area' ] ) && is_array( $option[ 'area' ] ) && count( $option[ 'area' ] ) > 1 ? $option[ 'area' ] : array( 'all' => array( 'slug' => 'area' ), 'title-1' => array( 'slug' => 'title', 'parent' => 'all' ) );
    $title_value = get_part_item_taxonomy_title( $archive, $option );
    $area_list = create_post_parts_tree( $area, 'all' );
    $inner = create_part_items_area( [ 'item_fun' => 'create_one_taxonomy_title_part', 'area_list' => $area_list, 'post_value' => $title_value, 'url' => '', 'info' => [], 'lazyload' => '', 'part_slug' => $value[ 'slug' ] ] );
    $class = 'DGITEM DGTAXITEM taxonomy-title-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    $tag = isset( $option[ 'tag' ] ) ? $option[ 'tag' ] : 'h1';
    return '<' . $tag . ' id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $inner . '</' . $tag . '>';
}

/*
 * 記事一覧説明文
*/
function create_taxonomy_description_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'taxonomy-description' || !$info[ 'archive' ] ) return false;
    $archive = $info[ 'archive' ];
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $text = isset( $archive[ 'description' ] ) ? $archive[ 'description' ] : '';
    $class = 'DGITEM DGTAXITEM taxonomy-description-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<p id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $text . '</p>';
}

/*
 * 記事一覧サムネイル
*/
function create_page_thumbnail_part( $value, $info, $tab = false ) {
    if ( ( ( $value[ 'slug' ] !== 'taxonomy-thumbnail' && $value[ 'slug' ] !== 'taxonomy-movie' ) || !$info[ 'archive' ] ) && ( ( $value[ 'slug' ] !== 'single-thumbnail' && $value[ 'slug' ] !== 'single-movie' ) || !$info[ 'post' ] ) ) return false;
    $type = strpos( $value[ 'slug' ], 'taxonomy' ) !== false ? 'archive' : 'post';
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $image = isset( $info[ $type ][ 'thumbnail' ] ) ? $info[ $type ][ 'thumbnail' ] : array();
    $thumb_arr = get_part_item_thumbnail_src( $image, $option, $info );
    $src = $thumb_arr[ 'src' ];
    $src_set = $thumb_arr[ 'src_set' ];
    if ( isset( $option[ 'fixed' ] ) && ( $option[ 'fixed' ] === '1' || ( $option[ 'fixed' ] === '2' && $src === '' ) ) ) {
        $fixed_arr = get_part_item_thumbnail_src( $info[ 'fixedImage' ], $option, $info );
        $src = $fixed_arr[ 'src' ];
        $src_set = $fixed_arr[ 'src_set' ];
    }
    $no_image_flg = ( !isset( $option[ 'none' ] ) || ( isset( $option[ 'none' ] ) && $option[ 'none' ] === '1' ) );
    if ( $src === '' && !$no_image_flg ) return false;
    $alt = $thumb_arr[ 'alt' ];
    if ( $alt === '' ) {
        if ( $type === 'post' ) {
            $alt = $info[ $type ][ 'postTitle' ];
        } else {
            $alt = $info[ $type ][ 'title' ];
        }
    }
    $item_data_arr = [
        'src' => $src,
        'src_set' => $src_set,
        'option' => $option,
        'lazy_flg' => ( isset( $value[ 'lazyload' ] ) && $value[ 'lazyload' ] === '1' ),
        'alt' => $alt,
        'loading_img' => $info[ 'loadingImg' ],
        'no_image' => $info[ 'noImage' ],
        'no_image_flg' => $no_image_flg,
        'class' => 'thumb-img',
    ];
    extract( get_image_item_data( $item_data_arr ) );
    $class = 'DGITEM thumbnail-part ' . $type . '-thumbnail-part' . $no_image_class;
    if ( $type === 'archive' ) {
        $class .= ' DGTAXITEM';
    }
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $image . '</div>';
}

/*
 * 記事動画サムネイル
*/
function create_page_thumbnail_movie_part( $value, $info, $tab = false ) {
    if ( ( $value[ 'slug' ] !== 'taxonomy-movie' || !$info[ 'archive' ] ) && ( $value[ 'slug' ] !== 'single-movie' || !$info[ 'post' ] ) ) return false;
    $type = strpos( $value[ 'slug' ], 'taxonomy' ) !== false ? 'archive' : 'post';
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $movie_value = false;
    if ( $type === 'archive' && isset( $info[ $type ][ 'movie' ] ) ) {
        $movie_value = $info[ $type ][ 'movie' ];
    } elseif ( $type === 'post' && isset( $info[ $type ][ 'postMeta' ][ 'movie_thumbnail' ] ) ) {
        $movie_value = $info[ $type ][ 'postMeta' ][ 'movie_thumbnail' ];
    }
    if ( isset( $movie_value[ 'value' ] ) && $movie_value[ 'value' ] !== '' ) {
        /* 動画サムネイル */
        $thumb_flg = isset( $option[ 'thumb' ] ) ? $option[ 'thumb' ] : '1';
        $image_src = '';
        if ( $thumb_flg === '1' && $movie_value[ 'type' ] !== '3' ) {
            $image = isset( $info[ $type ][ 'thumbnail' ] ) ? $info[ $type ][ 'thumbnail' ] : array();
            $thumb_arr = get_part_item_thumbnail_src( $image, $option, $info );
            $image_src = $thumb_arr[ 'src' ];
        }
        
        /* 動画作成 */
        $inner = '';
        if ( $movie_value[ 'type' ] === '3' ) {
            $inner = get_part_item_movie_src( $movie_value[ 'value' ] );
        } else {
            $movie_src = $movie_value[ 'value' ];
            $movie_arr = [
                'type' => 'movie',
                'option' => $option,
                'attr' => ' playsinline',
                'image_flg' => ( $thumb_flg === '1' ),
                'image_src' => $image_src
            ];
            $video_attr = get_movie_music_attr( $movie_arr );
            $video_type = '';
            preg_match( '/\.([^.\?]+)((\?|#).*?)?$/s', $movie_src, $video_match );
            if ( isset( $video_match[ 1 ] ) && $video_match[ 1 ] !== '' ) {
                $video_type = ' type="video/' . $video_match[ 1 ] . '"';
            }
            /* 動画 */
            $source = '<source src="' . $movie_src . '"' . $video_type . '>';
            $inner = '<video class="video-item"' . $video_attr . '>' . $source . '</video>';
        }
        $class = 'DGITEM thumbnail-movie-part ' . $type . '-thumbnail-movie-part';
        if ( $type === 'archive' ) {
            $class .= ' DGTAXITEM';
        }
        if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
            $class .= ' ' . $option[ 'part-class' ];
        }
        $attr = set_part_attr( $class, $value, $tab );
        return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $inner . '</div>';
    } elseif ( !isset( $option[ 'none' ] ) || ( isset( $option[ 'none' ] ) && $option[ 'none' ] === '1' ) ) {
        return create_page_thumbnail_part( $value, $info, $tab );
    }
    return '';
}

/*
 * 記事数カウント
*/
function create_taxonomy_page_count_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'taxonomy-page_count' || !$info[ 'archive' ] ) return false;
    $archive = $info[ 'archive' ];
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $area = isset( $option[ 'area' ] ) ? $option[ 'area' ] : array();
    $inner = '';
    $area_list = false;
    if ( is_array( $area ) && count( $area ) > 0 ) {
        $area_list = create_post_parts_tree( $area, 'all' );
    }
    if ( $area_list !== false ) {
        $inner .= create_part_items_area( [ 'item_fun' => 'get_part_item_page_count_text', 'area_list' => $area_list, 'post_value' => $archive[ 'postCount' ], 'url' => '', 'info' => $info, 'lazyload' => '', 'part_slug' => $value[ 'slug' ] ] );
    } else {
        foreach( (array)$archive[ 'postCount' ] as $name => $post_value ) {
            $inner .= get_part_item_page_count_text( [ 'value' => $archive[ 'postCount' ], 'item' => [ 'slug' => $name ], 'url' => '', 'option' => array(), 'info' => $info, 'lazyload' => '', 'part_slug' => $value[ 'slug' ] ] );
        }
    }
    if ( $inner === '' ) {
        $inner = '<p class="none-post-text">情報がありません。</p>';
    }
    $class = 'DGITEM DGTAXITEM taxonomy-count-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . '<div class="page-count-area">' . $inner . '</div></div>';
}

/*
 * 子タームリスト
*/
function create_taxonomy_child_part( $value, $info, $tab = false ) {
    if ( ( $value[ 'slug' ] !== 'taxonomy-brother' && $value[ 'slug' ] !== 'taxonomy-child' ) || !$info[ 'archive' ] ) return false;
    $archive = $info[ 'archive' ];
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $type = $value[ 'slug' ] === 'taxonomy-brother' ? 'brother' : 'child';
    if ( ( !isset( $option[ 'display' ] ) ||  $option[ 'display' ] === '' ) || !isset( $archive[ $type ] ) || ( isset( $archive[ $type ] ) && $archive[ $type ] === false ) ) {
        return '';
    }
    $part_title = create_part_title( $value );
    $child = get_part_item_child_taxonomy( $option, $type, $archive, $info );
    $class = 'DGITEM DGTAXITEM taxonomy-' . $type . '-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $child . '</div>';
}

/*
 * 並び替え
*/
function create_taxonomy_sort_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'taxonomy-sort' || !$info[ 'archive' ] ) return false;
    $archive = $info[ 'archive' ];
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $orderby = get_part_item_sort_orderby( $option, $archive );
    $order = get_part_item_sort_order( $option, $archive );
    $display = get_part_item_sort_count( $option, $archive );
    $class = 'DGITEM DGTAXITEM ' . $value[ 'slug' ] . '-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . '<div class="archive-sort-area">' . $orderby . $order . $display . '</div></div>';
}

/*
 * ページング
*/
function create_taxonomy_paging_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'taxonomy-paging' || !$info[ 'archive' ] || !$value[ 'option' ] ) return false;
    $archive = $info[ 'archive' ];
    $part_title = create_part_title( $value );
    $option = $value[ 'option' ];
    $paging_type = isset( $option[ 'type' ] ) ? $option[ 'type' ] : '1';
    $fun_arr = [
        '1' => 'get_part_item_paging_numbers',
        '3' => 'get_part_item_paging_numbers',
        '2' => 'get_part_item_paging_button',
        '4' => 'get_part_item_paging_button'
    ];
    $paging = '';
    if ( isset( $fun_arr[ $paging_type ] ) ) {
        $paging = $fun_arr[ $paging_type ]( [ 'option' => $option, 'archive' => $archive ] );
    }
    
    $class = 'DGITEM DGTAXITEM taxonomy-paging-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $paging . '</div>';
}

/*
 * 作成者ページSNS・連絡先
*/
function create_taxonomy_author_sns_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'taxonomy-user_sns' || !$info[ 'archive' ] || !$value[ 'option' ] || !isset( $info[ 'archive' ][ 'user_sns' ] ) ) return false;
    $archive = $info[ 'archive' ];
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $part_title = create_part_title( $value );
    $inner = '';
    foreach( (array)$archive[ 'user_sns' ] as $sns => $sns_url ) {
        if ( !isset( $option[ $sns ] ) || ( isset( $option[ $sns ] ) && $option[ $sns ] === '1' ) ) {
            if ( $sns === 'mail' ) {
                $sns_url = 'mailto:' . $sns_url;
            }
            $name = isset( $option[ $sns . 'n' ] ) ? $option[ $sns . 'n' ] : $sns;
            $inner .= '<a href="' . $sns_url . '" class="sns-item link-tag ' . $sns . '" target="_blank">' . $name . '</a>';
        }
    }
    $inner = '<div class="user-sns-list">' . $inner . '</div>';
    $class = 'DGITEM DGTAXITEM author-sns-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $inner . '</div>';
}

/*
 * 記事タイトル
*/
function create_post_title_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'single-title' || !$info[ 'post' ] ) return false;
    $post = $info[ 'post' ];
    $class = 'DGITEM post-title-part';
    if ( isset( $value[ 'option' ][ 'part-class' ] ) && $value[ 'option' ][ 'part-class' ] !== '' ) {
        $class .= ' ' . $value[ 'option' ][ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    $tag = isset( $value[ 'option' ][ 'tag' ] ) ? $value[ 'option' ][ 'tag' ] : 'h1';
    return '<' . $tag . ' id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '><span class="text">' . $post[ 'postTitle' ] . '</span></' . $tag . '>';
}

/*
 * 記事views
*/
function create_post_views_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'site-views' && $value[ 'slug' ] !== 'single-views' ) return false;
    $type = $value[ 'slug' ] === 'site-views' ? 'site' : 'post';
    $part_title = create_part_title( $value );
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $class = 'DGITEM ' . $type . '-view-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    $view_type = isset( $option[ 'type' ] ) ? $option[ 'type' ] : 'views';
    $views = $type === 'post' && isset( $info[ 'post' ][ 'postMeta' ][ $view_type ] ) ? $info[ 'post' ][ 'postMeta' ][ $view_type ] : $info[ 'siteViews' ][ $view_type ];
    $text = isset( $option[ 'text' ] ) ? $option[ 'text' ] : '';
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . '<div class="view-area"><span class="view-count">' . $views . '</span><span class="view-text">' . $text . '</span></div></div>';
}

/*
 * 記事コンテンツ
*/
function create_post_content_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'single-content' || !$info[ 'post' ] ) return false;
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $post_content = $info[ 'post' ][ 'postContent' ];
    if ( !isset( $value[ 'lazyload' ] ) ) {
        $post_content = replace_post_content( $post_content, $info[ 'loadingImg' ] );
    }
    $post_content = get_part_item_post_content_split( $post_content, $option );
    $post_content = get_part_item_post_content_password( $post_content, $option, $info );
    $post_content = get_part_item_post_content_child( $post_content, $value, $info );
    $class = 'DGITEM post-content-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $post_content . '</div>';
}

/*
 * 記事タクソノミー
*/
function create_post_taxonomy_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'single-taxonomy' || !$info[ 'post' ] ) return false;
    $post = $info[ 'post' ];
    if ( !( isset( $post[ 'taxonomy' ] ) && is_array( $post[ 'taxonomy' ] ) && count( $post[ 'taxonomy' ] ) > 0 ) ) return false;
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $part_title = create_part_title( $value );
    $term_list = get_part_item_post_taxonomy( $option, $post );
    
    $class = 'DGITEM post-taxonomy-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $term_list . '</div>';
}

/*
 * 記事日付
*/
function create_post_date_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'single-date' || !$info[ 'post' ] ) return false;
    $post = $info[ 'post' ];
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    //公開日
    $date_inner = get_part_item_post_date( $option, $post, 'date' );
    $update_inner = get_part_item_post_date( $option, $post, 'update' );
    $class = 'DGITEM post-date-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $date_inner . $update_inner . '</div>';
}

/*
 * 記事ページング
*/
function create_post_paging_part( $value, $info, $tab = false ) {
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    if ( $value[ 'slug' ] !== 'single-paging' || !$info[ 'post' ] || ( !isset( $option[ 'prev' ] ) && !isset( $option[ 'next' ] ) ) ) return false;
    $area = isset( $option[ 'area' ] ) ? $option[ 'area' ] : array();
    $part_title = create_part_title( $value );
    $area_list = false;
    if ( is_array( $area ) && count( $area ) > 0 ) {
        $area_list = create_post_parts_tree( $area, 'all' );
    }
    $lazyload = isset( $value[ 'lazyload' ] ) ? $value[ 'lazyload' ] : '';
    $ways = array( 'prev', 'next', );
    $paging = '';
    foreach( (array)$ways as $way ) {
        if ( isset( $option[ $way ] ) ) {
            $one_post = '';
            if ( $area_list !== false ) {
                $one_post .= create_part_items_area( array( 'item_fun' => 'create_one_post_part', 'area_list' => $area_list, 'post_value' => $option[ $way ][ 'part' ], 'url' => $option[ $way ][ 'url' ], 'info' => $info, 'lazyload' => $lazyload, 'part_slug' => $value[ 'slug' ] ) );
            } else {
                foreach( (array)$option[ $way ] as $name => $post_value ) {
                    $one_post .= create_one_post_part( array( 'value' => $option[ $way ][ 'part' ], 'item' => array( 'id' => '', 'slug' => $name ), 'url' => $option[ $way ][ 'url' ], 'option' => array(), 'info' => $info, 'lazyload' => $lazyload, 'part_slug' => $value[ 'slug' ] ) );
                }
            }
            $paging .= '<article class="post-item paging-item ' . $way . '">' . $one_post . '</article>';
        }
    }
    $paging_area = '<div class="paging-area post-list">' . $paging . '</div>';
    $class = 'DGITEM post-paging-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $paging_area . '</div>';
}

/*
 * 記事評価
*/
function create_post_evaluate_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'single-evaluate' || !$info[ 'post' ] ) return false;
    $post = $info[ 'post' ];
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $part_title = create_part_title( $value );
    $evaluate_result = get_part_item_evaluate_result( $option, $post );
    $evaluate_form = get_part_item_evaluate_form( $value, $post );
    $class = 'DGITEM post-evaluate-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $evaluate_result . $evaluate_form . '</div>';
}

function create_post_comment_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'single-comment' || !$info[ 'post' ] || $info[ 'post' ][ 'commentStatus' ] !== 'open' ) return false;
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $part_title = create_part_title( $value );
    $count = get_part_item_post_comment_count( $option, $info );
    $list = get_part_item_post_comment_list( $option, $info );
    $form = get_part_item_post_comment_form( $value, $info );
    $class = 'DGITEM post-comment-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $count . $list . $form . '</div>';
}

/*
 * 記事目次
*/
function create_post_index_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'single-index' || !$info[ 'post' ] || !isset( $info[ 'post' ][ 'indexList' ] ) || !$info[ 'post' ][ 'indexList' ] ) return false;
    $post = $info[ 'post' ];
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $index_list = get_part_item_post_index( $post[ 'indexList' ] );
    if ( !isset( $value[ 'title' ][ 'text' ] ) ) {
        $value[ 'title' ][ 'text' ] = __( '目次', 'dg-style' );
    }
    $part_title = create_part_title( $value );
    
    $class = 'DGITEM post-index-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . '<div class="post-index-list">' . $index_list . '</div></div>';
}

/*
 * カスタムフィールド
*/
function create_post_postmeta_part( $value, $info, $tab = false ) {
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    if ( $value[ 'slug' ] !== 'single-postmeta' || !$info[ 'post' ] || !( isset( $option[ 'type' ] ) && $option[ 'type' ] !== '' ) ) return false;
    $post = $info[ 'post' ];
    $part_title = create_part_title( $value );
    $class = 'DGITEM post-meta-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $attr = set_part_attr( $class, $value, $tab );
    $type = $option[ 'type' ];
    $meta_value = isset( $post[ 'postMeta' ][ $type ] ) ? $post[ 'postMeta' ][ $type ] : 0;

    $post_meta_html = '';
    $tag = isset( $option[ 'tag' ] ) && $option[ 'tag' ] !== '' ? $option[ 'tag' ] : 'div';
    if ( isset( $option[ 'attr' ] ) && $option[ 'attr' ] !== '' ) {
        $attr = $option[ 'attr' ];
        $add_attr = $tag === 'button' ? ' type="button"' : '';
        $subtext = isset( $option[ 'subtext' ] ) ? $option[ 'subtext' ] : '';
        $post_meta_html = '<' . $tag . ' class="post-meta-value" ' . $attr . '="' . $meta_value . '"' . $add_attr . '>' . $subtext . '</' . $tag . '>';
    } else {
        $post_meta_html = '<' . $tag . ' class="post-meta-value">' . $meta_value . '</' . $tag . '>';
    }
    return '<div id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '"' . $attr . '>' . $part_title . $post_meta_html . '</div>';
}

/*
 * ブックマーク
*/
function create_post_bookmark_part( $value, $info, $tab = false ) {
    if ( $value[ 'slug' ] !== 'single-index' || !$info[ 'post' ] || !( isset( $info[ 'post' ][ 'postId' ] ) && $info[ 'post' ][ 'postId' ] !== '' ) ) return false;
    $post = $info[ 'post' ];
    $option = isset( $value[ 'option' ] ) ? $value[ 'option' ] : array();
    $part_title = create_part_title( $value );
    $class = 'DGITEM add-bookmark post-bookmark-part';
    if ( isset( $option[ 'part-class' ] ) && $option[ 'part-class' ] !== '' ) {
        $class .= ' ' . $option[ 'part-class' ];
    }
    $count = '';
    if ( isset( $option[ 'count' ] ) && $option[ 'count' ] === '1' && isset( $post[ 'postMeta' ][ 'dg_bookmark' ] ) ) {
        $count = '<span class="count">' . $post[ 'postMeta' ][ 'dg_bookmark' ] . '</span>';
    }
    $attr = set_part_attr( $class, $value, $tab );
    $text = isset( $option[ 'text' ] ) ? $option[ 'text' ] : __( 'ブックマーク', 'dg-style' );
    return '<button type="button" id="' . $value[ 'id' ] . '" data-order="' . $value[ 'order' ] . '" value="' . $post[ 'postId' ] . '"' . $attr . ' aria-label="' . __( 'この記事をブックマークする', 'dg-style' ) . '"><span class="text">' . $text . '</span>' . $count . '</button>';
}

/* ---------------------------------------------
 * 構造化
--------------------------------------------- */
/*
 * パンくずリスト構造化
*/
function create_structured_breadcrumb_jsonLD( $value ) {
    if ( !$value ) {
        return '';
    }
    $result = array(
        '@context' => 'http://schema.org',
        '@type' => 'BreadcrumbList',
    );
    $cnt = 0;
    foreach( (array)$value as $key => $list ) {
        $title = $list[ 'name' ];
        ++$cnt;
        $result[ 'itemListElement' ][] = array(
            '@type' => $list[ 'type' ],
            'position' => $cnt,
            'item' => array(
                '@id' => $list[ 'url' ],
                'name' => $title,
            ),
        );
    }
    return '<script id="breadcrumb-jsonld" type="application/ld+json">' . json_encode( $result ) . '</script>';
}

function create_structured_jsonLD( $page_info, $summary ) {
    $archive = $summary[ 'archive' ];
    $post = $summary[ 'post' ];
    $result = array();
    $logo = '';
    $url = ( empty( $_SERVER[ 'HTTPS' ] ) ? 'http://' : 'https://') . $_SERVER[ 'HTTP_HOST' ] . $_SERVER[ 'REQUEST_URI' ];
    if ( $summary[ 'pcLogo' ] !== '' ) {
        $logo = $summary[ 'pcLogo' ];
    } else if ( $summary[ 'spLogo' ] !== '' ) {
        $logo = $summary[ 'spLogo' ];
    } else if ( $summary[ 'noImage' ] !== '' ) {
        $logo = $summary[ 'noImage' ];
    }
    $result[ '@context' ] = 'http://schema.org';
    switch ( $page_info[ 'page_type' ] ) {
        case 'top' :
            $result[ '@type' ] = 'WebSite';
            $result[ 'name' ] = $summary[ 'site_name' ];
            $result[ 'publisher' ] = array();
            $result[ 'publisher' ][ '@type' ] = 'Organization';
            $result[ 'publisher' ][ 'name' ] = $summary[ 'site_name' ];
            $result[ 'publisher' ][ 'logo' ] = array( '@type' => 'ImageObject', 'url' => $logo );
            $result[ 'headline' ] = $archive[ 'title' ];
            $result[ 'description' ] = strip_tags( $archive[ 'description' ] );
            $result[ 'url' ] = $url;
            break;
        case 'search' :
            $result[ '@type' ] = 'website';
            $result[ 'url' ] = $url;
            $result[ 'potentialAction' ] = array();
            $result[ 'potentialAction' ][ '@type' ] = 'SearchAction';
            $result[ 'potentialAction' ][ 'target' ] = $summary[ 'homeUrl' ] . '/?s={search_term_string}';
            $result[ 'potentialAction' ][ 'query-input' ] = 'required name=search_term_string';
            break;
        case 'single' :
            $result[ '@type' ] = 'BlogPosting';
            $result[ 'mainEntityOfPage' ] = array( '@type' => 'WebPage', '@id' => $url );
            $result[ 'headline' ] = $post[ 'postTitle' ];
            $result[ 'description' ] = $post[ 'description' ];
            $result[ 'articleBody' ] = strip_tags( $post[ 'postContent' ] );
            $result[ 'datePublished' ] = $post[ 'date' ];
            $result[ 'dateModified' ] = $post[ 'update' ];
            if ( isset( $post[ 'thumbnail' ] ) ) {
                if ( isset( $post[ 'thumbnail' ][ 'full' ] ) ) {
                    $result[ 'image' ] = $post[ 'thumbnail' ][ 'full' ][ 'url' ];
                } else if ( isset( $post[ 'thumbnail' ][ 'url' ] ) ) {
                    $result[ 'image' ] = $post[ 'thumbnail' ][ 'url' ];
                } else {
                    $result[ 'image' ] = $logo;
                }
            } else {
                $result[ 'image' ] = $logo;
            }
            if ( isset( $post[ 'author' ][ 'name' ] ) ) {
                $result[ 'author' ] = array( '@type' => 'Person', 'name' => $post[ 'author' ][ 'name' ], 'url' => $post[ 'author' ][ 'url' ] );
            }
            $result[ 'publisher' ] = array();
            $result[ 'publisher' ][ '@type' ] = 'Organization';
            $result[ 'publisher' ][ 'name' ] = $summary[ 'site_name' ];
            $result[ 'publisher' ][ 'logo' ] = array( '@type' => 'ImageObject', 'url' => $logo );
            break;
    }
    if ( is_array( $result ) && count( $result ) > 1 ) {
        return '<script id="page-jsonld" type="application/ld+json">' . json_encode( $result ) . '</script>';
    }
    return '';
}