<?php
/*
 * フロントパーツ取得
*/
add_action( 'wp_ajax_front_content_summary', 'front_content_summary' );
add_action( 'wp_ajax_nopriv_front_content_summary', 'front_content_summary' );
function front_content_summary() {
    if ( isset( $_POST[ 'page_url' ] ) && $_POST[ 'page_url' ] !== '' ) {
        /* URLからページ情報取得 */
        $page_obj = new CreatePageInfoUrl( $_POST[ 'page_url' ] );
        $home_url = $page_obj->getHomeUrl();
        $test_type = $page_obj->getTestab();
        $main_value = $page_obj->getSiteOption();
        $this_page = $page_obj->getPageType();
        if ( !$main_value ) {
            echo json_encode( false );
            exit();
        }
        $design_value = $main_value[ 'main' ];
        if ( !( is_array( $design_value ) && count( $design_value ) > 0 ) ) {
            echo json_encode( false );
            exit();
        }
        
        //ページに合わせて事前に情報取得
        $page_info = $page_obj->setCurrentPageInfo();
        $post_summary = $page_obj->getPostSummary();
        $archive = $page_obj->getArchive();
        $page_class = $page_obj->getPageClass();
        $result = $page_obj->getCacheDatas();
        $result[ 'post' ] = $post_summary;
        $result[ 'archive' ] = $archive;
        $result[ 'pageClass' ] = $page_class;
        $breadcrumb_obj = new FrontBreadcrumb( $page_obj );
        $result[ 'breadcrumb' ] = $breadcrumb_obj->getBreadcrumb();
        /* viewリセットチェック */
        check_site_views_reset();
        //SPA専用リロードパーツ振り分け
        $reload = isset( $_POST[ 'reload' ] ) ? true : false;
        $sort_result = $page_obj->sortingDisplayParts( $_POST, $reload );
        if ( $sort_result !== false ) {
            $result = array_merge( $result, $sort_result[ 'result' ] );
            $part_keys = $sort_result[ 'part_keys' ];
        }
        $loading_img = $main_value[ 'loading_image' ];
        $result[ 'pageType' ] = $page_info[ 'taxonomy' ];
        //コンテンツまとめ
        $front_summary = array(
            'archive' => $archive,
            'post_summary' => $post_summary,
            'page_info' => $page_info,
            'loading_img' => $loading_img,
            'home_url' => $home_url,
        );
        $summary = array(
            'part_keys' => $part_keys,
            'design_value' => $design_value,
            'front_summary' => $front_summary,
            'today' => new DateTime( wp_date( 'Y-m-d H:i:s' ) ),
            'get' => isset( $page_info[ 'parm' ] ) ? $page_info[ 'parm' ] : array(),
        );
        $parts = front_part_summary( $summary );
        if ( is_array( $parts ) && count( $parts ) > 0 ) {
            foreach( (array)$parts as $part_id => $part ) {
                if ( $part === false ) {
                    $result[ 'hidden' ][] = $part_id;
                }
                if ( isset( $part[ 'slug' ] ) && $part[ 'slug' ] === 'contact' && isset( $part[ 'option' ][ 'id' ] ) && $part[ 'option' ][ 'id' ] !== '' ) {
                    $parts[ $part_id ][ 'option' ][ 'nonce' ] = wp_create_nonce( 'dg_contact' . $part[ 'option' ][ 'id' ] . $part_id );
                }
            }
        }
        $result[ 'parts' ] = $parts;
        $result[ 'reload' ] = $reload;
        //ロゴとnoimage
        $result[ 'scroll' ] = isset( $main_value[ 'scroll' ] ) ? $main_value[ 'scroll' ] : array();
        $result[ 'pcLogo' ] = $main_value[ 'pc_logo' ];
        $result[ 'spLogo' ] = $main_value[ 'sp_logo' ];
        $result[ 'noImage' ] = $main_value[ 'no_image' ];
        $result[ 'fixedImage' ] = $main_value[ 'fixedImage' ];
        $result[ 'loadingImg' ] = $loading_img;
        //サイト全体Views
        $result[ 'siteViews' ] = update_site_views();
        
        //更新URL
        if ( isset( $page_info[ 'result_url' ] ) ) {
            $result[ 'result_url' ] = $page_info[ 'result_url' ] ;
        } elseif ( $page_info[ 'taxonomy' ] === '404' ) {
            $result[ 'result_url' ] = $_POST[ 'page_url' ];
        }
        $result[ 'blogPublic' ] = get_option( 'blog_public', '1' );
        $result[ 'siteUrl' ] = isset( $main_value[ 'siteUrl' ] ) ? $main_value[ 'siteUrl' ] : site_url();
        if ( is_user_logged_in() ) {
            $current_user = wp_get_current_user();
            $user = $current_user->display_name;
            $result[ 'logged' ] = $current_user->display_name;
        }
        echo json_encode( $result );
        exit();
    }
    echo json_encode( false );
    exit();
}

/*-------------------------------
もっと見るボタンで記事取得
-------------------------------*/
add_action( 'wp_ajax_front_more_post_list', 'front_more_post_list' );
add_action( 'wp_ajax_nopriv_front_more_post_list', 'front_more_post_list' );
function front_more_post_list() {
    if ( isset( $_POST[ 'page_url' ] ) && $_POST[ 'page_url' ] !== '' && isset( $_POST[ 'ids' ] ) && $_POST[ 'ids' ] !== '' ) {
        $page_obj = new CreatePageInfoUrl( $_POST[ 'page_url' ] );
        $home_url = $page_obj->getHomeUrl();
        $test_type = $page_obj->getTestab();
        $main_value = $page_obj->getSiteOption();
        if ( !$main_value ) {
            echo json_encode( false );
            exit();
        }
        $design_value = $main_value[ 'main' ];
        if ( !( is_array( $design_value ) && count( $design_value ) > 0 ) ) {
            echo json_encode( false );
            exit();
        }
        
        $result = $page_obj->setCurrentPageInfoMore( $_POST );
        $page_info = $page_obj->getPageInfo();
        $post_summary = $page_obj->getPostSummary();
        $archive = $page_obj->getArchive();
        $page_class = $page_obj->getPageClass();
        
        //コンテンツまとめ
        $front_parts = isset( $_POST[ 'ids' ] ) && $_POST[ 'ids' ] !== '' ? explode( ',', $_POST[ 'ids' ] ) : false;
        //子パーツ取得
        $ids = array();
        foreach( (array)$front_parts as $part_id ) {
            $child_list = create_part_child_tree( $design_value, $part_id );
            if ( is_array( $child_list ) && count( $child_list ) > 0 ) {
                $ids = array_merge( $ids, $child_list );
            }
        }
        $front_parts = array_merge( $ids, $front_parts );
        $front_parts = array_unique( $front_parts );
        $front_parts = array_values( $front_parts );
        $front_summary = array(
            'archive' => $archive,
            'post_summary' => $post_summary,
            'page_info' => $page_info,
            'home_url' => $home_url,
            'more_flg' => true,
        );
        $summary = array(
            'part_keys' => $front_parts,
            'design_value' => $design_value,
            'front_summary' => $front_summary,
            'today' => new DateTime( wp_date( 'Y-m-d H:i:s' ) ),
            'get' => isset( $page_info[ 'parm' ] ) ? $page_info[ 'parm' ] : array(),
        );
        $result[ 'parts' ] = front_part_summary( $summary );
        
        //ロゴとnoimage
        $result[ 'pcLogo' ] = $main_value[ 'pc_logo' ];
        $result[ 'spLogo' ] = $main_value[ 'sp_logo' ];
        $result[ 'noImage' ] = $main_value[ 'no_image' ];
        $result[ 'fixedImage' ] = $main_value[ 'fixedImage' ];
        $result[ 'loadingImg' ] = $main_value[ 'loading_image' ];
        echo json_encode( $result );
        exit();
    }
    echo json_encode( false );
    exit();
}

/*
 * コメントリスト取得
*/
add_action( 'wp_ajax_get_post_comment_list', 'get_post_comment_list' );
add_action( 'wp_ajax_nopriv_get_post_comment_list', 'get_post_comment_list' );
function get_post_comment_list() {
    $result = false;
    if ( isset( $_POST[ 'postId' ] ) && $_POST[ 'postId' ] !== '' ) {
        $post_id = $_POST[ 'postId' ];
        $args = array( 
            'post_id' => $post_id,
            'orderby' => 'comment_date',
            'order' => 'ASC',
            'offset' => 0,
        );
        $admin_url = get_admin_url();
        $comments = get_comments( $args );
        if ( !empty( $comments ) ) {
            $result = array();
            $comment_list = array();
            foreach ( (array)$comments as $key => $comment ) {
                if ( $comment->comment_approved === '1' ) {
                    $comment_list[ $key ][ 'id' ] = $comment->comment_ID;
                    $comment_list[ $key ][ 'author' ] = $comment->comment_author;
                    $comment_list[ $key ][ 'comment' ] = wpautop( $comment->comment_content );
                    $comment_list[ $key ][ 'date' ] = $comment->comment_date;
                    $comment_list[ $key ][ 'parent' ] = $comment->comment_parent;
                }
            }
            $result[ 'commentList' ] = create_comment_tree( $comment_list );
        }
    }
    echo json_encode( $result );
    exit();
}

/*
 * コメントツリー作成
*/
function create_comment_tree( array &$comment, $parentId = 0 ) {
    $result = array();
    foreach( $comment as &$item ) {
        if ( (int)$item[ 'parent' ] === (int)$parentId ) {
            $children = create_comment_tree( $comment, $item[ 'id' ] );
            if ( $children ) {
                foreach ( $children as &$value ) {
                    $value[ 'parent_author' ] = $item[ 'author' ];
                }
                $item[ 'child' ] = $children;
                $item[ 'has_children' ] = 1;
            }
            $result[ $item[ 'id' ] ] = $item;
            unset( $item );
        }
    }
    return $result;
}

/*
 * テーブル内容確認
*/
function confirm_table_contents( $table, $select, $type, $value ) {
    global $wpdb;
    $sql_table = $wpdb->prefix . $table;
    $pre = $wpdb->prepare( "SELECT $select FROM $sql_table WHERE 1=%d AND `$type` = %s", 1, $value );
    if( $result = $wpdb->get_results( $pre ) ) {
        return $result;
    }
    return false;
}

/*
 * コメント登録
*/
add_action( 'wp_ajax_insert_post_comment', 'insert_post_comment' );
add_action( 'wp_ajax_nopriv_insert_post_comment', 'insert_post_comment' );
function insert_post_comment() {
    /* nonceチェック */
    $comment_nonce = $_POST[ 'commentNonce' ];
    $nonce_result = wp_verify_nonce( $comment_nonce, 'post_comment_insert' );
    if ( !$nonce_result ) {
        echo json_encode( array( 'result' => $nonce_result ) );
        exit();
    }
    /* コメント登録 */
    $comment = wp_handle_comment_submission( wp_unslash( $_POST ) );
    if ( is_wp_error( $comment ) ) {
        $error_data = (int)$comment->get_error_data();
        if ( !empty( $error_data ) ) {
            echo json_encode( array( 'result' => $error_data ) );
            exit();
        } else {
            echo json_encode( array( 'result' => $comment ) );
            exit();
        }
    }
    
    //お知らせメール送信
    $text_comment_title = __( 'で登録したコメントに返信がありました。', 'dg-style' );
    $text_comment_content1 = __( '様の登録したコメントに返信がありました。', 'dg-style' );
    $text_comment_content2 = __( '該当記事のURL', 'dg-style' );
    if ( $comment->comment_parent !== '0' ) {
        $admin_name = get_bloginfo( 'name' );
        $admin_email = get_bloginfo( 'admin_email' );
        $mail_info = confirm_table_contents( 'comments', 'comment_author, comment_author_email', 'comment_ID', $_POST[ 'comment_parent' ] );
        if ( $mail_info !== false ) {
            $post_url = get_permalink( $comment->comment_post_ID );
            $mailto = $mail_info[ 0 ]->comment_author . "<" . $mail_info[ 0 ]->comment_author_email . ">";
            $mail_title = "【" . $admin_name . "】" . $text_comment_title;
            $mail_content = "「" . $mail_info[ 0 ]->comment_author . "」" . $text_comment_content1 . "\n" . $text_comment_content2 . "：" . $post_url;
            $mail_header = "From: " . $admin_name ."<" . $admin_email . ">\n";
            $mail_header .= "Bcc:" . $admin_name ."<" . $admin_email . ">";
            if ( !wp_mail( $mailto, $mail_title, $mail_content, $mail_header ) ) {
                $text_fail_title = __( 'コメント返信お知らせメールの送信が失敗しました。', 'dg-style' );
                $text_fail_url = __( '記事URL', 'dg-style' );
                $text_fail_to = __( '既存コメント登録者', 'dg-style' );
                $text_fail_from = __( '返信コメント登録者', 'dg-style' );
                $fail_mail_to = $admin_name ."<" . $admin_email . ">";
                $fail_mail_title = $text_fail_title;
                $fail_mail_content = $text_fail_title . "\n";
                $fail_mail_content .= $text_fail_url . "：" . $post_url . "\n";
                $fail_mail_content .= $text_fail_to . "：" . $mail_info[ 0 ]->comment_author . $mail_info[ 0 ]->comment_author . "\n";
                $fail_mail_content .= $text_fail_from . "：" . $comment->comment_author;
                wp_mail( $fail_mail_to, $fail_mail_title, $fail_mail_content );
            }
        }
    }
    //コメント結果取得
    $comment_list = array();
    $comment_flg = false;
    if ( is_user_logged_in() ) {
        $comment_flg = true;
    }
    if ( '1' === get_option( 'comment_whitelist' ) ) {
        global $wpdb;
        $comment_table = $wpdb->prefix . 'comments';
        $already_user = $wpdb->get_results( "SELECT count( comment_author_email ) AS CNT FROM {$comment_table} WHERE 1=1 AND `comment_author_email` = '{$comment->comment_author_email}' AND `comment_approved` = '1' GROUP BY 'comment_author_email'", ARRAY_A );
        //すでに承認したことがあるメールの場合は承認する
        if( isset( $already_user[ 0 ][ 'CNT' ] ) && (int)$already_user[ 0 ][ 'CNT' ] > 0 ) {
            $update_pre = $wpdb->prepare( "UPDATE $comment_table SET `comment_approved` = '1' WHERE `comment_ID` = %s", array( $comment->comment_ID ) );
            if( $wpdb->query( $update_pre ) ) {
                $comment_flg = true;
            }
        }
    }
    if ( $comment_flg === true ) {
        //コメントの設定
        $comment_list[ 'id' ] = $comment->comment_ID;
        $comment_list[ 'author' ] = $comment->comment_author;
        $comment_list[ 'comment' ] = wpautop( $comment->comment_content );
        $comment_list[ 'date' ] = $comment->comment_date;
        $comment_list[ 'parent' ] = $comment->comment_parent;
        $comment_list[ 'post_id' ] = $comment->comment_post_ID;
    } else {
        $comment_list[ 'waiting' ] = __( 'コメントが管理者の承認を待っています。', 'dg-style' );
    }
    echo json_encode( array( 'result' => $comment_list ) );
    exit();
}

/*
 * 評価保存
*/
add_action( 'wp_ajax_save_post_evaluate', 'save_post_evaluate' );
add_action( 'wp_ajax_nopriv_save_post_evaluate', 'save_post_evaluate' );
function save_post_evaluate() {
    $result = false;
    if ( isset( $_POST[ 'id' ] ) && $_POST[ 'id' ] !== '' && isset( $_POST[ 'type' ] ) && $_POST[ 'type' ] !== '' ) {
        $post_id = $_POST[ 'id' ];
        $type = $_POST[ 'type' ];
        switch ( $type ) {
            case 'very-good' :
                $score = 5;
                break;
            case 'good' :
                $score = 4;
                break;
            case 'average' :
                $score = 3;
                break;
            case 'fair' :
                $score = 2;
                break;
            case 'poor' :
                $score = 1;
                break;
        }
        //トータル値取得
        $total = get_post_meta( $post_id, 'evaluate_total', true );
        if ( $total === '' ) {
            $total = 0;
        }
        $total = (int)$total + $score;
        update_post_meta( $post_id, 'evaluate_total', $total );
        
        //各ボタン押された値
        $table = get_post_meta( $post_id, 'evaluate_table', true );
        if ( $table === '' ) {
            $table = array(
                'very-good' => 0,
                'good' => 0,
                'average' => 0,
                'fair' => 0,
                'poor' => 0,
            );
        } else {
            $table = json_decode( $table, true );
        }
        $count = (int)$table[ $type ];
        ++$count;
        $table[ $type ] = $count;
        update_post_meta( $post_id, 'evaluate_table', json_encode( $table ) );
        $result = true;
        echo json_encode( array( 'result' => $result, 'total' => $total, 'table' => $table ) );
        exit();
    }
    echo json_encode( array( 'result' => $result ) );
    exit();
}

/*
 * ブックマーク保存
*/
add_action( 'wp_ajax_save_post_bookmark', 'save_post_bookmark' );
add_action( 'wp_ajax_nopriv_save_post_bookmark', 'save_post_bookmark' );
function save_post_bookmark() {
    if ( isset( $_POST[ 'id' ] ) && $_POST[ 'id' ] !== '' && isset( $_POST[ 'type' ] ) && $_POST[ 'type' ] !== '' ) {
        $post_id = $_POST[ 'id' ];
        //トータル値取得
        $bookmark = get_post_meta( $post_id, 'dg_bookmark', true );
        if ( $bookmark === '' ) {
            $bookmark = 0;
        }
        if ( $_POST[ 'type' ] === 'add' ) {
            ++$bookmark;
        } else {
            --$bookmark;
        }
        if ( $bookmark < 0 ) {
            $bookmark = 0;
        }
        update_post_meta( $post_id, 'dg_bookmark', $bookmark );
        echo json_encode( array( 'result' => number_format( $bookmark ) ) );
        exit();
    }
    echo json_encode( array( 'result' => false ) );
    exit();
}

/*
 * viewリセット
*/
add_action( 'wp_ajax_reset_page_view_count', 'reset_page_view_count' );
add_action( 'wp_ajax_nopriv_reset_page_view_count', 'reset_page_view_count' );
function reset_page_view_count() {
    if ( isset( $_POST[ 'type' ] ) && $_POST[ 'type' ] !== '' ) {
        global $wpdb;
        $postmeta = $wpdb->prefix . 'postmeta';
        $type = $_POST[ 'type' ];
        $meta_key = 'w_views';
        switch ( $type ) {
            case 'month' :
                $meta_key = 'm_views';
                break;
            case 'year' :
                $meta_key = 'y_views';
                break;
        }
        $pre = $wpdb->prepare( "UPDATE $postmeta SET `meta_value` = '0' WHERE `meta_key` = %s", array( $meta_key ) );
        if( $wpdb->get_results( $pre ) ) {
            echo true;
            exit();
        }
    }
    echo false;
    exit();
}

/*
 * リアルタイム検索
*/
add_action( 'wp_ajax_realtime_post_search', 'realtime_post_search' );
add_action( 'wp_ajax_nopriv_realtime_post_search', 'realtime_post_search' );
function realtime_post_search() {
    $result = array();
    if ( ( isset( $_POST[ 's' ] ) && $_POST[ 's' ] !== '' ) || ( isset( $_POST[ 'srange' ] ) && $_POST[ 'srange' ] !== '' ) || ( isset( $_POST[ 'stax' ] ) && $_POST[ 'stax' ] !== '' ) ) {
        $keyword = isset( $_POST[ 's' ] ) && $_POST[ 's' ] !== '' ? $_POST[ 's' ] : '';
        $args = array( 'post_status' => 'publish', 'ignore_sticky_posts' => 1, );
        $args[ 'posts_per_page' ] = isset( $_POST[ 'count' ] ) && $_POST[ 'count' ] !== '' ? (int)$_POST[ 'count' ] : 5;
        $args[ 's' ] = $keyword;
        $srange = '';
        if ( isset( $_POST[ 'srange' ] ) && $_POST[ 'srange' ] === '1' ) {
            $srange = 'custom_posts_where_title_only';
        } elseif ( isset( $_POST[ 'srange' ] ) && $_POST[ 'srange' ] === '2' ) {
            $srange = 'custom_posts_where_content_only';
        }
        
        $area_value = array();
        if ( isset( $_POST[ 'area' ] ) && $_POST[ 'area' ] !== '' ) {
            $area_value = json_decode( stripslashes( rawurldecode( $_POST[ 'area' ] ) ), true );
        }
        if ( isset( $_POST[ 'stax' ] ) && $_POST[ 'stax' ] !== '' ) {
            $stax = explode( ',', $_POST[ 'stax' ] );
            $stax = array_filter( $stax, 'strlen' );
            $stax = array_values( $stax );
            $tax_list = array();
            foreach( (array)$stax as $value ) {
                $tax = explode( '-', $value );
                $tax_list[ $tax[ 0 ] ][] = $tax[ 1 ];
            }
            if ( is_array( $tax_list ) && count( $tax_list ) > 0 ) {
                foreach( (array)$tax_list as $taxonomy => $value ) {
                    $args[ 'tax_query' ][] = array(
                        'taxonomy' => $taxonomy,
                        'field' => 'slug',
                        'terms' => $value,
                    );
                }
            }
        }
        if ( $srange !== '' ) {
            add_filter( 'posts_where', $srange, 10, 2 );
        }
        $query = new WP_Query( $args );
        if ( $srange !== '' ) {
            remove_filter( 'posts_where', $srange, 10, 2 );
        }
        $today = new DateTime( wp_date( 'Y-m-d H:i:s' ) );
        $value = array( 'option' => array( 'area' => $area_value, ) );
        $result = part_taxonomy_post_list( $query, $value, $today );
    }
    echo json_encode( $result );
    exit();
}

add_action( 'wp_ajax_realtime_post_content', 'realtime_post_content' );
add_action( 'wp_ajax_nopriv_realtime_post_content', 'realtime_post_content' );
function realtime_post_content() {
    if ( !( isset( $_POST[ 'id' ] ) && is_numeric( $_POST[ 'id' ] ) ) ) {
        echo json_encode( array( 'content' => false ) );
        exit();
    }
    $post = get_post( $_POST[ 'id' ] );
    if ( $post === null || $post->post_password !== '' ) {
        echo json_encode( array( 'content' => false ) );
        exit();
    }
    $content = apply_filters( 'the_content', $post->post_content );
    $content = str_replace( ']]>', ']]&gt;', $content );
    $content = replace_content_lightbox( $content );
    echo json_encode( array( 'content' => $content ) );
    exit();
}

/*add_filter('user_trailingslashit', 'rem_cat_func');
function rem_cat_func($link) {
    return str_replace("/category/", "/", $link);
}
add_action('init', 'rem_cat_flush_rules');
function rem_cat_flush_rules() {
    global $wp_rewrite;
    $wp_rewrite->flush_rules();
}
add_filter('generate_rewrite_rules', 'rem_cat_rewrite');
function rem_cat_rewrite($wp_rewrite) {
    $new_rules = array('(.+)/page/(.+)/?' => 'index.php?category_name='.$wp_rewrite->preg_index(1).'&paged='.$wp_rewrite->preg_index(2));
    $wp_rewrite->rules = $new_rules + $wp_rewrite->rules;
}*/
