<?php
class FrontHead {
    private $head;
    public function __construct( $page_obj ) {
        if ( !( $page_obj instanceof CreatePageInfo ) ){
            return false;
        }
        $this->setHead( $page_obj );
    }
    public function getHead() {
        return $this->head;
    }
    public function setHead( $page_obj ) {
        $post = $page_obj->getPost();
        $term_object = $page_obj->getTermObject();
        $home_url = $page_obj->getHomeUrl();
        $page_flg = $page_obj->getPageFlg();
        $blog_name = $page_obj->getSiteName();
        $page_title = $page_obj->getTitle();
        $meta_option = get_option( 'DG_meta_option', false );
        if ( $meta_option !== false ) {
            $meta_option = json_decode( $meta_option, true );
        } else {
            $meta_option = array();
        }
        $title = '';
        $description = '';
        $canonical = '';
        $url = '';
        $robot_flg = false;
        $og_type = 'article';
        $og_image = '';
        //デフォルトSNSイメージ
        if ( isset( $meta_option[ 'sns-default-image' ] ) && $meta_option[ 'sns-default-image' ] !== '' ) {
            $sns_image_arr = json_decode( wp_unslash( $meta_option[ 'sns-default-image' ] ), true );
            if ( isset( $sns_image_arr[ 'type' ] ) && $sns_image_arr[ 'type' ] === '2' ) {
                $og_image = $sns_image_arr[ 'value' ];
            } elseif ( isset( $sns_image_arr[ 'type' ] ) && $sns_image_arr[ 'type' ] === '1' && isset( $sns_image_arr[ 'value' ] ) && $sns_image_arr[ 'value' ] !== '' ) {
                $thumb = wp_get_attachment_image_src( $sns_image_arr[ 'value' ], 'full' );
                $og_image = $thumb[ 0 ];
            }
        }
        switch ( true ) {
            case ( $page_flg[ 'is_home' ] ) :
            case ( $page_flg[ 'is_search' ] ) :
                $url = $home_url;
                //title
                if ( isset( $meta_option[ 'top-title' ] ) && $meta_option[ 'top-title' ] !== '' ) {
                    $title = $meta_option[ 'top-title' ];
                } else {
                    $title = $page_title;
                }
                //description
                if ( isset( $meta_option[ 'top-description' ] ) && $meta_option[ 'top-description' ] !== '' ) {
                    $description = $meta_option[ 'top-description' ];
                } else {
                    $description = get_option( 'blogdescription', '' );
                }
                //noindex
                if ( isset( $meta_option[ 'top-noindex' ] ) && $meta_option[ 'top-noindex' ] === '1' ) {
                    $robot_flg = true;
                }
                if ( $page_flg[ 'is_search' ] ) {
                    if ( isset( $meta_option[ 'search-title' ] ) && $meta_option[ 'search-title' ] !== '' ) {
                        $title = str_replace( '[keyword]', $page_title, $meta_option[ 'search-title' ] );
                    } else {
                        $title = '「' . $page_title . '」' . __( 'の検索結果', 'dg-style' );
                    }
                    //noindex
                    if ( isset( $meta_option[ 'search-noindex' ] ) && $meta_option[ 'search-noindex' ] === '1' ) {
                        $robot_flg = true;
                    }
                }
                $og_type = 'website';
                break;
            case ( $page_flg[ 'is_author' ] ) :
                $author_id = $term_object->ID;
                if ( isset( $meta_option[ 'author-title' ] ) && $meta_option[ 'author-title' ] !== '' ) {
                    $title = str_replace( '[title]', $page_title, $meta_option[ 'author-title' ] );
                } else {
                    $title = $page_title;
                }
                $author = front_part_author_profile( $author_id, array( 'description', 'user_image' ), array() );
                $description = $author[ 'description' ];
                if ( isset( $author[ 'user_image' ][ 'full' ][ 'url' ] ) && $author[ 'user_image' ][ 'full' ][ 'url' ] !== '' ) {
                    $og_image = $author[ 'user_image' ][ 'full' ][ 'url' ];
                }
                $url = $author[ 'url' ];
                //noindex
                if ( isset( $meta_option[ 'author-noindex' ] ) && $meta_option[ 'author-noindex' ] === '1' ) {
                    $robot_flg = true;
                }
                break;
            case ( $page_flg[ 'is_post_type_archive' ] ) :
                $title = $term_object->label;
                $description = $term_object->description;
                $taxonomy = $term_object->name;
                if ( isset( $meta_option[ 'custom-post-archive-' . $taxonomy . '-title' ] ) && $meta_option[ 'custom-post-archive-' . $taxonomy . '-title' ] !== '' ) {
                    $title = str_replace( '[title]', $title, $meta_option[ 'custom-post-archive-' . $taxonomy . '-title' ] );
                }
                //noindex
                if ( isset( $meta_option[ 'custom-post-archive-' . $taxonomy . '-noindex' ] ) && $meta_option[ 'custom-post-archive-' . $taxonomy . '-noindex' ] === '1' ) {
                    $robot_flg = true;
                }
                break;
            case ( $page_flg[ 'is_archive' ] ) :
                $term_id = $term_object->term_id;
                $title = $term_object->name;
                $description = $term_object->description;
                $taxonomy = $term_object->taxonomy;
                $meta_info = get_term_meta( $term_id, 'meta_info', true );
                if ( $meta_info !== '' ) {
                    $meta_info = json_decode( $meta_info, true );
                    if ( isset( $meta_info[ 'title' ] ) && $meta_info[ 'title' ] !== '' ) {
                        $title = $meta_info[ 'title' ];
                    }
                    if ( isset( $meta_info[ 'description' ] ) && $meta_info[ 'description' ] !== '' ) {
                        $description = $meta_info[ 'description' ];
                    }
                    if ( isset( $meta_info[ 'noindex' ] ) && $meta_info[ 'noindex' ] === '1' ) {
                        $robot_flg = true;
                    }
                }
                if ( isset( $meta_option[ 'taxonomy-' . $taxonomy . '-title' ] ) && $meta_option[ 'taxonomy-' . $taxonomy . '-title' ] !== '' ) {
                    $title = str_replace( '[title]', $title, $meta_option[ 'taxonomy-' . $taxonomy . '-title' ] );
                }

                $url = get_term_link( $term_id, $taxonomy );
                $image = get_taxonomy_thumbnail_image( $term_id );
                if ( isset( $image[ 'full' ][ 'url' ] ) && $image[ 'full' ][ 'url' ] !== '' ) {
                    $og_image = $image[ 'full' ][ 'url' ];
                }
                //noindex
                if ( isset( $meta_option[ 'taxonomy-' . $taxonomy . '-noindex' ] ) && $meta_option[ 'taxonomy-' . $taxonomy . '-noindex' ] === '1' ) {
                    $robot_flg = true;
                }
                break;
            case ( $page_flg[ 'is_date' ] ) :
                $year = $page_obj->getYear();
                $month = $page_obj->getMonth();
                $day = $page_obj->getDay();
                if ( $day !== 0 && $month !== 0 && $year !== 0 ) {
                    $url = get_day_link( $year, $month, $day );
                    if ( isset( $meta_option[ 'taxonomy-date-day-title' ] ) && $meta_option[ 'taxonomy-date-day-title' ] !== '' ) {
                        $title = str_replace( '[year]', $year, $meta_option[ 'taxonomy-date-day-title' ] );
                        $title = str_replace( '[month]', $month, $title );
                        $title = str_replace( '[day]', $day, $title );
                    } else {
                        $title = $year . '-' . $month . '-' . $day;
                    }
                    //noindex
                    if ( isset( $meta_option[ 'taxonomy-date-noindex' ] ) && $meta_option[ 'taxonomy-date-noindex' ] === '1' ) {
                        $robot_flg = true;
                    }
                } elseif ( $month !== 0 && $year !== 0 ) {
                    $url = get_month_link( $year, $month );
                    if ( isset( $meta_option[ 'taxonomy-date-month-title' ] ) && $meta_option[ 'taxonomy-date-month-title' ] !== '' ) {
                        $title = str_replace( '[year]', $year, $meta_option[ 'taxonomy-date-month-title' ] );
                        $title = str_replace( '[month]', $month, $title );
                    } else {
                        $title = $year . '-' . $month;
                    }
                    //noindex
                    if ( isset( $meta_option[ 'taxonomy-date-noindex' ] ) && $meta_option[ 'taxonomy-date-noindex' ] === '1' ) {
                        $robot_flg = true;
                    }
                } elseif ( $year !== 0 ) {
                    $url = get_year_link( $year );
                    if ( isset( $meta_option[ 'taxonomy-date-year-title' ] ) && $meta_option[ 'taxonomy-date-year-title' ] !== '' ) {
                        $title = str_replace( '[year]', $year, $meta_option[ 'taxonomy-date-year-title' ] );
                    } else {
                        $title = $year;
                    }
                    //noindex
                    if ( isset( $meta_option[ 'taxonomy-date-noindex' ] ) && $meta_option[ 'taxonomy-date-noindex' ] === '1' ) {
                        $robot_flg = true;
                    }
                }
                break;
            case ( $page_flg[ 'is_single' ] ) :
                $post_type = $post->post_type;
                $title = $post->post_title;
                if ( $post->post_password === '' && $post_type !== 'lp' ) {
                    $description = character_limit( preg_replace( '/[\s\n]{1,}/s', '', strip_tags( $post->post_content ) ), 120 );
                }
                $url = get_permalink( $post->ID );
                $dg_meta = get_post_meta( $post->ID, 'dg_meta', true );
                if ( $dg_meta !== '' ) {
                    $dg_meta = json_decode( $dg_meta, true );
                    if ( isset( $dg_meta[ 'title' ] ) && $dg_meta[ 'title' ] !== '' ) {
                        $title = $dg_meta[ 'title' ];
                    }
                    if ( isset( $dg_meta[ 'description' ] ) && $dg_meta[ 'description' ] !== '' ) {
                        $description = $dg_meta[ 'description' ];
                    }
                    if ( isset( $dg_meta[ 'canonical' ] ) && $dg_meta[ 'canonical' ] !== '' ) {
                        $url = $dg_meta[ 'canonical' ];
                    }
                    if ( isset( $dg_meta[ 'noindex' ] ) && $dg_meta[ 'noindex' ] === '1' ) {
                        $robot_flg = true;
                    }
                }
                if ( isset( $meta_option[ 'single-' . $post_type . '-title' ] ) && $meta_option[ 'single-' . $post_type . '-title' ] !== '' ) {
                    $title = str_replace( '[title]', $title, $meta_option[ 'single-' . $post_type . '-title' ] );
                }
                if ( $post_type === 'lp' ) {
                    $blog_name = $title;
                    $og_type = 'website';
                }
                $thumbnail = post_thumbnail_src( $post );
                if ( isset( $thumbnail[ 'full' ][ 'url' ] ) && $thumbnail[ 'full' ][ 'url' ] !== '' ) {
                    $og_image = $thumbnail[ 'full' ][ 'url' ];
                } elseif ( isset( $thumbnail[ 'url' ] ) && $thumbnail[ 'url' ] !== '' ) {
                    $og_image = $thumbnail[ 'url' ];
                }
                //noindex
                if ( isset( $meta_option[ 'single-' . $post_type . '-noindex' ] ) && $meta_option[ 'single-' . $post_type . '-noindex' ] === '1' ) {
                    $robot_flg = true;
                }
                break;
            case ( $page_flg[ 'is_404' ] ) :
                if ( isset( $meta_option[ '404-title' ] ) && $meta_option[ '404-title' ] !== '' ) {
                    $title = $meta_option[ '404-title' ];
                } else {
                    $title = $page_title;
                }
                //noindex
                if ( isset( $meta_option[ '404-noindex' ] ) && $meta_option[ '404-noindex' ] === '1' ) {
                    $robot_flg = true;
                }
                break;
            default :
                $url = $home_url;
                $title = $page_title;
                $description = get_option( 'blogdescription', '' );
                break;
        }
        //タグ作成
        $og_title = '';
        $og_description = '';
        if ( $title !== '' ) {
            if ( strpos( $title, '[site-text]' ) !== false ) {
                if (  isset( $meta_option[ 'site-text' ] ) ) {
                    $title = str_replace( '[site-text]', $meta_option[ 'site-text' ], $title );
                } else {
                    $title = str_replace( '[site-text]', '', $title );
                }
            }
            $title = htmlspecialchars( $title, ENT_QUOTES, 'UTF-8' );
            $og_title = $title;
            $title = '<title>' . $title . '</title>';
        }
        if ( $description !== '' ) {
            $description = htmlspecialchars( strip_tags( $description ), ENT_QUOTES, 'UTF-8' );
            $og_description = $description;
            $description = '<meta name="description" content="' . $description . '">';
        }
        if ( $url !== '' ) {
            $canonical = '<link rel="canonical" href="' . $url . '">';
        }
        $robot = '';
        if ( $robot_flg === true ) {
            $robot = '<meta name="robots" content="noindex,nofollow">';
            remove_filter( 'wp_robots', 'wp_robots_max_image_preview_large' );
        }
        //OG設定
        $og_type = '<meta property="og:type" content="' . $og_type . '">';
        $og_title = '<meta property="og:title" content="' . $og_title . '">';
        $og_description = '<meta property="og:description" content="' . $og_description . '">';
        $og_url = '<meta property="og:url" content="' . $url . '">';
        $blog_name = '<meta property="og:site_name" content="' . $blog_name . '">';
        if ( $og_image !== '' ) {
            $og_image = '<meta property="og:image" content="' . $og_image . '">';
        }
        $app_id = '';
        if ( isset( $meta_option[ 'app_id' ] ) && $meta_option[ 'app_id' ] !== '' ) {
            $app_id = '<meta property="fb:app_id" content="' . $meta_option[ 'app_id' ] . '">';
        }
        $twitter_card = '';
        if ( isset( $meta_option[ 'twitter-card' ] ) && $meta_option[ 'twitter-card' ] !== '' ) {
            $twitter_card = '<meta property="twitter:card" content="' . $meta_option[ 'twitter-card' ] . '">';
        }
        $this->head = $title . $description . $canonical . $robot . $og_title . $og_type . $og_description . $blog_name . $og_image . $og_url . $app_id . $twitter_card;
    }
}