<?php
class FrontBreadcrumb {
    private $breadcrumb;
    public function __construct( $page_obj ) {
        if ( !( $page_obj instanceof CreatePageInfo ) ){
            return false;
        }
        $this->setBreadcrumb( $page_obj );
    }
    /*
     * パンくずリスト
    */
    public function getBreadcrumb() {
        return $this->breadcrumb;
    }
    private function setBreadcrumb( $page_obj ) {
        $home_url = $page_obj->getHomeUrl();
        $page_info = $page_obj->getPageInfo();
        $site_name = $page_obj->getSiteName();
        $post = $page_obj->getPostSummary();
        $archive = $page_obj->getArchive();
        
        if ( $page_info === false || !isset( $page_info[ 'taxonomy' ] ) || !isset( $page_info[ 'page_type' ] ) ) {
            return false;
        }
        $breadcrumb = array();
        $type = $page_info[ 'taxonomy' ];
        $page_type = $page_info[ 'page_type' ];
        switch ( $page_type ) {
            case 'author' :
                $id = $page_info[ 'term_id' ];
                break;
            case 'search' :
                $search_key = $page_info[ 'term_id' ];
                break;
            case 'taxonomy' :
                if ( $page_info[ 'taxonomy' ] === 'date' ) {
                    $page_type = 'date';
                } elseif ( $page_info[ 'taxonomy' ] !== 'top' ) {
                    $id = $page_info[ 'term_id' ];
                }
                break;
            case 'single' :
                $id = $page_info[ 'post_id' ];
                break;
        }
        $exclusion_ids = array();//除外項目　準備中ベーシック設定で変更するように…
        $breadcrumb[] = array(
            'type' => 'ListItem',
            'url' => $home_url,
            'name' => $site_name . ' TOP',
            'taxonomy' => 'top',
            'page_type' => 'top',
        );
        /* 投稿のページ */
        switch ( $page_type ) {
            case 'single' :
                switch ( $type ) {
                    case 'page' :
                        if ( isset( $post[ 'parent' ] ) && (int)$post[ 'parent' ] !== 0 ) {
                            $ancestors = array_reverse( get_post_ancestors( $id ) );
                            foreach( $ancestors as $ancestor ) {
                                if ( !in_array( (string)$ancestor, $exclusion_ids, true ) ) {
                                    $breadcrumb[] = array(
                                        'type' => 'ListItem',
                                        'url' => get_permalink( $ancestor ),
                                        'name' => get_the_title( $ancestor ),
                                        'taxonomy' => 'page',
                                        'page_type' => 'single',
                                    );
                                }
                            }
                        }
                        $breadcrumb[] = array(
                            'type' => 'ListItem',
                            'url' => get_permalink( $id ),
                            'name' => $post[ 'postTitle' ],
                            'taxonomy' => 'page',
                            'page_type' => 'single',
                        );
                        break;
                    case 'lp' :
                        $breadcrumb[] = array(
                            'type' => 'ListItem',
                            'url' => get_permalink( $id ),
                            'name' => $post[ 'postTitle' ],
                            'taxonomy' => 'page',
                            'page_type' => 'single',
                        );
                        break;
                    default :
                        $terms = get_the_terms( $id, 'category' );
                        if ( !$terms ) {
                            $taxs = default_taxonomy_exclusion();
                            foreach ( $taxs as $tax ) {
                                $terms = get_the_terms( $id, $tax );
                                $get_tax = $this->getExclusionTaxonomy( $terms, $exclusion_ids );
                            }
                        } else {
                            $get_tax = $this->getExclusionTaxonomy( $terms, $exclusion_ids );
                        }
                        
                        // カスタム投稿タイプ
                        if ( $type !== 'post' ) {
                            $post_type_data = get_post_type_object( $type );
                            if ( $post_type_data->has_archive === true ) {
                                $url = get_post_type_archive_link( $type );
                                $breadcrumb[] = array(
                                    'type' => 'ListItem',
                                    'url' => $url,
                                    'name' => $post_type_data->label,
                                    'taxonomy' => $type,
                                    'page_type' => 'custom-post-archive',
                                );
                            }
                        }
                        if ( isset( $post[ 'parent' ] ) && (int)$post[ 'parent' ] !== 0 ) {
                            $ancestors = array_reverse( get_post_ancestors( $id ) );
                            foreach( $ancestors as $ancestor ) {
                                if ( !in_array( (string)$ancestor, $exclusion_ids, true ) ) {
                                    $breadcrumb[] = array(
                                        'type' => 'ListItem',
                                        'url' => get_permalink( $ancestor ),
                                        'name' => get_the_title( $ancestor ),
                                        'taxonomy' => 'page',
                                        'page_type' => 'single',
                                    );
                                }
                            }
                        }
                        if ( isset( $get_tax[ 'parent_id' ] ) && $get_tax[ 'parent_id' ] !== 'none' && (int)$get_tax[ 'parent_id' ] !== 0 ) {
                            $parent_list = array();
                            $parent_list = $this->getBreadcrumbParent( $get_tax[ 'parent_id' ], $get_tax[ 'current_taxonomy' ], $exclusion_ids );
                            $breadcrumb = array_merge( $breadcrumb, $parent_list[ 'item' ] );
                        }

                        //最後のタクソノミー
                        if ( isset( $get_tax[ 'parent_id' ] ) && $get_tax[ 'current_term' ] !== 'none' ) {
                            $term_link = get_term_link( $get_tax[ 'current_term' ]->term_id, $get_tax[ 'current_taxonomy' ] );
                            // エラーなら次のタームへ進む。
                            if ( is_wp_error( $term_link ) ) {
                                $term_link = null;
                            }
                            $breadcrumb[] = array(
                                'type' => 'ListItem',
                                'url' => $term_link,
                                'name' => $get_tax[ 'current_term' ]->name,
                                'taxonomy' => 'category',
                                'page_type' => 'taxonomy',
                            );
                        }
                        //現在ページ
                        $breadcrumb[] = array(
                            'type' => 'ListItem',
                            'url' => get_permalink( $id ),
                            'name' => $post[ 'postTitle' ],
                            'taxonomy' => $page_info[ 'taxonomy' ],
                            'page_type' => 'single',
                        );
                        break;
                }
                break;
            case 'custom-post-archive' :
                $post_type_data = get_post_type_object( $type );
                $url = get_post_type_archive_link( $type );
                $breadcrumb[] = array(
                    'type' => 'ListItem',
                    'url' => $url,
                    'name' => $post_type_data->label,
                    'taxonomy' => $type,
                    'page_type' => 'custom-post-archive',
                );
                break;
            case 'taxonomy' :
                $term = $page_info[ 'term' ];
                if ( (int)$term[ 'parent' ] !== 0 ) {
                    $parent_list = array();
                    $parent_list = $this->getBreadcrumbParent( $term[ 'parent' ], $term[ 'taxonomy' ], $exclusion_ids );
                    $breadcrumb = array_merge( $breadcrumb, $parent_list['item'] );
                }
                $term_link = get_term_link( $id, $term[ 'taxonomy' ] );
                // エラーなら次のタームへ進む。
                if ( is_wp_error( $term_link ) ) {
                    $term_link = null;
                }
                $breadcrumb[] = array(
                    'type' => 'ListItem',
                    'url' => $term_link,
                    'name' => $term[ 'name' ],
                    'taxonomy' => $term[ 'taxonomy' ],
                    'page_type' => 'taxonomy',
                );
                break;
            case 'date' :
                $date_param = array( 'year' => '年', 'monthnum' => '月', 'day' => '日', 'm' => '公開', 'w' => '週目', );
                foreach( (array)$date_param as $unit => $name ) {
                    if ( isset( $page_info[ 'term_id' ][ $unit ] ) ) {
                        $url = '';
                        switch ( $unit ) {
                            case 'year' :
                                $url = get_year_link( $page_info[ 'term_id' ][ $unit ] );
                                break;
                            case 'monthnum' :
                                $url = get_month_link( $page_info[ 'term_id' ][ 'year' ], $page_info[ 'term_id' ][ $unit ] );
                                break;
                            case 'day' :
                                $url = get_day_link( $page_info[ 'term_id' ][ 'year' ], $page_info[ 'term_id' ][ 'monthnum' ], $page_info[ 'term_id' ][ $unit ] );
                                break;
                        }
                        $breadcrumb[] = array(
                            'type' => 'ListItem',
                            'url' => $url,
                            'name' => $page_info[ 'term_id' ][ $unit ],
                            'date_type' => $unit,
                            'taxonomy' => 'date',
                            'page_type' => 'taxonomy',
                        );
                    }
                }
                break;
            case 'author' :
                $author = $page_info[ 'author' ];
                $breadcrumb[] = array(
                    'type' => 'ListItem',
                    'url' => $author[ 'url' ],
                    'name' => $author[ 'name' ],
                    'taxonomy' => 'author',
                    'page_type' => 'other',
                );
                break;
            case 'search' :
                $breadcrumb[] = array(
                    'type' => 'ListItem',
                    'url' => $home_url . '?s=' . $search_key,
                    'name' => $search_key,
                    'taxonomy' => 'search',
                    'page_type' => 'other',
                );
                break;
            case '404' :
                $breadcrumb[] = array(
                    'type' => 'ListItem',
                    'url' => $home_url . '/404',
                    'name' => '404',
                    'taxonomy' => '404',
                    'page_type' => '404',
                );
                break;
        }
        $this->breadcrumb = $breadcrumb;
    }

    /* 親タクソノミー取得 */
    public function getBreadcrumbParent( $parent_id, $taxonomy, $exclusion_ids ) {
        $result = array();
        $result['item'] = array();
        $term = get_term( $parent_id, $taxonomy );
        if ( $term !== false ) {
            if ( !in_array( (string)$term->term_id, $exclusion_ids, true ) ) {
                $term_link = get_term_link( $term->term_id, $taxonomy );
                // エラーなら次のタームへ進む。
                if ( is_wp_error( $term_link ) ) {
                    $term_link = null;
                }
                $result['item'][] = array(
                    'type' => 'ListItem',
                    'url' => $term_link,
                    'name' => $term->name,
                    'taxonomy' => $term->taxonomy,
                    'page_type' => 'taxonomy',
                );
            }
            if ( (int)$term->parent !== 0 ) {
                $parent = $this->getBreadcrumbParent( $term->parent, $taxonomy, $exclusion_ids );
                if ( !empty( $parent ) ) {
                    if ( isset( $result['item'] ) ) {
                        $result['item'] = array_merge( $parent['item'], $result['item'] );
                    } else {
                        $result['item'] = $parent['item'];
                    }
                }
            }
            return $result;
        }
        return $result;
    }
    /*
     * 除外タクソノミーを除いて取得
    */
    public function getExclusionTaxonomy( $terms, $exclusion_ids ) {
        $result = array();
        $result['current_term'] = 'none';
        $result['parent_id'] = 'none';
        $result['current_taxonomy'] = null;
        if ( $terms !== false ) {
            if ( count( $terms ) > 1 ) {
                foreach( $terms as $term ) {
                    if ( !in_array( (string)$term->term_id, $exclusion_ids, true ) ) {
                        $result['current_term'] = $term;
                        $result['parent_id'] = $term->parent;
                        $result['current_taxonomy'] = $term->taxonomy;
                        break;
                    }
                }
            } else {
                if ( !in_array( (string)$terms[0]->term_id, $exclusion_ids, true ) ) {
                    $result['current_term'] = $terms[0];
                    $result['parent_id'] = $terms[0]->parent;
                } else {
                    $result['current_term'] = 'none';
                    $result['parent_id'] = $terms[0]->parent;
                }
                $result['current_taxonomy'] = $terms[0]->taxonomy;
            }
        }
        return $result;
    }
}