<?php
class CreatePageInfo {
    protected $pageUrl;
    protected $pageInfo;
    protected $testab = '';
    protected $homeUrl;
    protected $siteName = '';
    protected $siteOption = false;
    protected $title = '';
    protected $description = '';
    protected $termParentId = 0;
    protected $taxonomyThumbnail = false;
    protected $taxonomySubTitle = '';
    protected $pageClass = '';
    protected $termSlug = '';
    protected $termCount = '';
    protected $year = 0;
    protected $month = 0;
    protected $day = 0;
    protected $pageFlg = array();
    protected $postSummary = false;
    protected $archive = false;
    protected $scripts = array();
    protected $pageSlug = 'top';
    
    //pageInfo取得
    public function getPageInfo() {
        return $this->pageInfo;
    }
    //pageInfoセット ※クラス内部のみ
    protected function setPageInfo( $arr ) {
        if ( is_array( $arr ) && isset( $arr[ 'taxonomy' ] ) ) {
            $this->pageInfo = $arr;
        }
    }

    public function getPageSlug() {
        return $this->pageSlug;
    }

    protected function setPageSlug( $str ) {
        $this->pageSlug = $str;
    }

    //pageFlg取得
    public function getPageFlg() {
        return $this->pageFlg;
    }
    //pageFlgセット
    protected function setPageFlg( $arr ) {
        if ( is_array( $arr ) ) {
            $this->pageFlg = $arr;
        }
    }
    //タイトル取得
    public function getTitle() {
        return $this->title;
    }
    //タイトルセット
    protected function setTitle( $str ) {
        $this->title = $str;
    }
    
    //description取得
    public function getDescription() {
        return $this->description;
    }
    
    //descriptionセット
    protected function setDescription( $str ) {
        $this->description = $str;
    }
    
    //term_parent_id取得
    public function getTermParentId() {
        return $this->termParentId;
    }
    
    //term_parent_idセット
    protected function setTermParentId( $id ) {
        if ( is_numeric( $id ) ) {
            $this->termParentId = (int)$id;
        }
    }
    
    //taxonomy_thumbnail取得
    public function getTaxonomyThumbnail() {
        return $this->taxonomyThumbnail;
    }
    
    //taxonomy_thumbnailセット
    protected function setTaxonomyThumbnail( $arr ) {
        if ( is_array( $arr ) ) {
            $this->taxonomyThumbnail = $arr;
        }
    }
    
    //taxonomy_sub_title取得
    public function getTaxonomySubTitle() {
        return $this->taxonomySubTitle;
    }
    
    //taxonomy_sub_titleセット
    protected function setTaxonomySubTitle( $str ) {
        $this->taxonomySubTitle = $str;
    }
    
    //page_class取得
    public function getPageClass() {
        return $this->pageClass;
    }
    
    //page_classセット
    protected function setPageClass( $str ) {
        $this->pageClass = $str;
    }
    
    //termSlug取得
    public function getTermSlug() {
        return $this->termSlug;
    }
    
    //termSlugセット
    protected function setTermSlug( $str ) {
        $this->termSlug = $str;
    }
    
    //termCount取得
    public function getTermCount() {
        return $this->termCount;
    }
    
    //termCountセット
    protected function setTermCount( $str ) {
        $this->termCount = $str;
    }
        //year取得
    public function getYear() {
        return $this->year;
    }
    public function setYear( $cnt ) {
        $this->year = $cnt;
    }
    //month取得
    public function getMonth() {
        return $this->month;
    }
    public function setMonth( $cnt ) {
        $this->month = $cnt;
    }
    //year取得
    public function getDay() {
        return $this->day;
    }
    public function setDay( $cnt ) {
        $this->day = $cnt;
    }
    //postSummary取得
    public function getPostSummary() {
        return $this->postSummary;
    }
    //postSummaryセット
    protected function setPostSummary( $arr ) {
        if ( is_array( $arr ) ) {
            $this->postSummary = $arr;
        }
    }
    //postSummary取得
    public function getArchive() {
        return $this->archive;
    }
    //postSummaryセット
    protected function setArchive( $arr ) {
        if ( is_array( $arr ) ) {
            $this->archive = $arr;
        }
    }
    
    //site_name取得
    public function getSiteName() {
        return $this->siteName;
    }
    //site_nameセット
    protected function setSiteName( $str ) {
        $this->siteName = $str;
    }
    
    //ABテスト種類取得
    public function getTestab() {
        return $this->testab;
    }
    //ABテストセット
    public function setTestab( $page_info ) {
        $test_type = isset( $page_info[ 'testab' ] ) && $page_info[ 'testab' ] !== '' ? $page_info[ 'testab' ] : '';
        if ( get_option( 'DG_site_design_' . $test_type, '' ) === '' ) {
            $test_type = '';
        }
        $this->testab = $test_type;
    }
    
    //サイトhome urlセット
    public function getHomeUrl() {
        return $this->homeUrl;
    }
    
    //送信されたページURL取得
    public function getPageUrl() {
        return $this->pageUrl;
    }
    
    //送信されたURL保存
    protected function setPageUrl( $url ) {
        $url = urldecode( $url );
        if ( preg_match( '/^https?:\/{2}/', $url ) ) {
            $this->pageUrl = $url;
        } else {
            $this->pageUrl = false;
        }
    }
    //サイトデータ取得
    public function getPageType() {
        $page_info = $this->getPageInfo();
        if ( !( is_array( $page_info ) && isset( $page_info[ 'page_type' ] ) ) ) {
            return false;
        }
        $page_type = '';
        switch ( $page_info[ 'page_type' ] ) {
            case 'top' :
                $page_type = 'top';
                break;
            case 'taxonomy' :
            case 'single' :
            case 'custom-post-archive' :
                if ( $page_info[ 'page_type' ] . '-' . $page_info[ 'taxonomy' ] === 'single-lp' ) {
                    $page_type = 'top';
                } else {
                    $page_type = $page_info[ 'page_type' ] . '-' . $page_info[ 'taxonomy' ];
                }
                break;
            default :
                $page_type = 'other-' . $page_info[ 'taxonomy' ];
                break;
        }
        return $page_type;
    }
    //スクリプト取得
    public function getScripts() {
        return $this->scripts;
    }
    protected function setScripts() {
        $page_info = $this->getPageInfo();
        $testab = $this->getTestab();
        if ( $page_info[ 'page_type' ] === 'single' && $page_info[ 'taxonomy' ] === 'lp' ) {
            $scripts = get_post_meta( $page_info[ 'post_id' ], 'DG_script_option', true );
        } else {
            $scripts = get_option( 'DG_script_option' . $testab, false );
        }
        if ( $scripts !== false && $scripts !== '' ) {
            $this->scripts = json_decode( $scripts, true );
        }
    }
    protected function setPageOrder( $type, $page_info, $page_setting ) {
        if ( ( !isset( $page_info[ $type ] ) || $page_info[ $type ] === '') && isset( $page_setting[ $type ] ) ) {
            $page_info[ $type ] = $page_setting[ $type ];
        }
        return $page_info;
    }
    //サイトデータ取得
    public function getSiteOption() {
        $this->setSiteOption();
        return $this->siteOption;
    }
    public function setSiteOption() {
        $page_info = $this->getPageInfo();
        $testab = $this->getTestab();
        if ( !( is_array( $page_info ) && isset( $page_info[ 'page_type' ] ) ) ) {
            $this->siteOption = false;
            return false;
        }
        $site_value = false;
        switch ( $page_info[ 'page_type' ] ) {
            case 'top' :
                $site_value = get_option( 'DG_site_value_' . $testab . 'top' );
                break;
            case 'taxonomy' :
            case 'single' :
            case 'custom-post-archive' :
                if ( $page_info[ 'page_type' ] . '-' . $page_info[ 'taxonomy' ] === 'single-lp' ) {
                    $lp_post = get_post( $page_info[ 'post_id' ] );
                    $site_value = $lp_post->post_content;
                    $page_info[ 'lpFlg' ] = true;
                } else {
                    $site_value = get_option( 'DG_site_value_' . $testab . $page_info[ 'page_type' ] . '-' . $page_info[ 'taxonomy' ] );
                }
                break;
            default :
                $site_value = get_option( 'DG_site_value_' . $testab . 'other-' . $page_info[ 'taxonomy' ] );
                break;
        }
        if ( !$site_value ) {
            $this->siteOption = false;
            return false;
        }
        $this->siteOption = json_decode( $site_value, true );
    }

    protected function setPageOrderOption( $page_info ) {
        $page_flg = $this->getPageFlg();
        $page_slug = $this->getPageSlug();
        $scripts = $this->getScripts();
        if ( is_array( $scripts ) && count( $scripts ) === 0 ) {
            $this->setScripts();
            $scripts = $this->getScripts();
        }
        if ( $page_flg[ 'is_archive' ] && isset( $page_info[ 'term_id' ] ) ) {
            if ( $page_info[ 'count' ] === '' ) {
                $page_info[ 'count' ] = get_term_meta( $page_info[ 'term_id' ], 'count', true );
            }
            if ( $page_info[ 'orderby' ] === '' ) {
                $page_info[ 'orderby' ] = get_term_meta( $page_info[ 'term_id' ], 'orderby', true );
            }
            if ( $page_info[ 'order' ] === '' ) {
                $page_info[ 'order' ] = get_term_meta( $page_info[ 'term_id' ], 'order', true );
            }
        }
        // 共通ページ表示数・順番設定
        if ( isset( $scripts[ 'page-setting' ][ $page_slug ] ) ) {
            $page_info = $this->setPageOrder( 'count', $page_info, $scripts[ 'page-setting' ][ $page_slug ][ 'order-option' ] );
            $page_info = $this->setPageOrder( 'orderby', $page_info, $scripts[ 'page-setting' ][ $page_slug ][ 'order-option' ] );
            $page_info = $this->setPageOrder( 'order', $page_info, $scripts[ 'page-setting' ][ $page_slug ][ 'order-option' ] );
        }
        return $page_info;
    }

    //記事・カテゴリー情報設定
    public function setCurrentPageInfo() {
        $main_value = $this->getSiteOption();
        if ( !$main_value ) {
            return false;
        }
        $page_info = $this->getPageInfo();
        $title = $this->getTitle();
        $description = $this->getDescription();
        $term_parent_id = $this->getTermParentId();
        $taxonomy_thumbnail = $this->getTaxonomyThumbnail();
        $taxonomy_sub_title = $this->getTaxonomySubTitle();
        $term_slug = $this->getTermSlug();
        $term_count = $this->getTermCount();
        $loading_img = $main_value[ 'loading_image' ];
        $post_summary = false;
        $archive = false;
        $page_info = $this->setPageOrderOption( $page_info );
        
        if ( isset( $page_info[ 'post_id' ] ) ) {
            $page_info[ 'meta_keys' ] = isset( $main_value[ 'meta_keys' ] ) ? $main_value[ 'meta_keys' ] : array();
            $post_data = front_single_post_get( $page_info );
            if ( $post_data !== false ) {
                $post_summary = $post_data[ 'postData' ];
                $post_summary[ 'user_id' ] = $post_data[ 'user_id' ];
                $post_summary[ 'parent' ] = $post_data[ 'parent' ];
            }
        } elseif ( $page_info[ 'taxonomy' ] !== '404' ) {
            if ( isset( $main_value[ 'main_post_flg' ] ) ) {
                $page_info[ 'none_main_post' ] = true;
            }
            $archive = front_main_part_archive_query( $page_info );
            $archive[ 'title' ] = $title;
            $archive[ 'description' ] = nl2br( $description );
            $archive[ 'subTitle' ] = $taxonomy_sub_title;
            $archive[ 'brother' ] = false;
            $archive[ 'child' ] = false;
            if ( $page_info[ 'page_type' ] === 'author' ) {
                $user_fields = isset( $main_value[ 'user_fields' ] ) ? $main_value[ 'user_fields' ] : array( 'field' => array(), 'option' => array(), );
                $author_fields = array_merge( array( 'name', 'description' ), $user_fields[ 'field' ] );
                $author = front_part_author_profile( $page_info[ 'term_id' ], $author_fields, $user_fields[ 'option' ] );
                $page_info[ 'author' ] = $author;
                $taxonomy_thumbnail = array();
                if ( isset( $author[ 'user_image' ] ) ) {
                    $taxonomy_thumbnail[ 'user_image' ] = $author[ 'user_image' ];
                }
                if ( isset( $author[ 'bg_image' ] ) ) {
                    $taxonomy_thumbnail[ 'bg_image' ] = $author[ 'bg_image' ];
                }
                if ( is_array( $taxonomy_thumbnail ) && count( $taxonomy_thumbnail ) === 0 ) {
                    $taxonomy_thumbnail = false;
                }
                if ( isset( $author[ 'user_sns' ] ) ) {
                    $archive[ 'user_sns' ] = $author[ 'user_sns' ];
                }
                if ( isset( $author[ 'movie_thumbnail' ] ) ) {
                    $archive[ 'movie' ] = $author[ 'movie_thumbnail' ];
                }
            }
            $archive[ 'thumbnail' ] = $taxonomy_thumbnail;
            if ( $page_info[ 'page_type' ] === 'taxonomy' && $page_info[ 'taxonomy' ] !== 'date' ) {
                $page_info[ 'term' ] = array(
                    'name' => $title,
                    'slug' => isset( $term_slug ) ? $term_slug : '',
                    'taxonomy' => $page_info[ 'taxonomy' ],
                    'parent' => $term_parent_id,
                );
                $child_flg = isset( $main_value[ 'child_flg' ] ) ? $main_value[ 'child_flg' ] : array();
                /* 動画サムネイル */
                if ( isset( $child_flg[ 'movie_thumbnail' ] ) ) {
                    $archive[ 'movie' ] = get_taxonomy_thumbnail_movie( $page_info[ 'term_id' ] );
                }
                /* 兄弟カテゴリー取得 */
                if ( isset( $child_flg[ 'brother' ] ) ) {
                    $child = get_terms( $page_info[ 'taxonomy' ], array( 'parent' => $term_parent_id, ) ) ;
                    if ( is_array( $child ) && count( $child ) > 0 && !is_wp_error( $child ) ) {
                        $archive[ 'brother' ] = array();
                        if ( (int)$term_parent_id !== 0 ) {
                            $parent_term = get_term( $term_parent_id, $page_info[ 'taxonomy' ] );
                            if ( !is_wp_error( $parent_term ) ) {
                                $archive[ 'brother' ][] = array(
                                    'current' => '',
                                    'term_id' => $parent_term->term_id,
                                    'slug' => $parent_term->slug,
                                    'name' => $parent_term->name,
                                    'count' => $parent_term->count,
                                    'parent' => $term_parent_id,
                                    'url' => get_term_link( $parent_term->slug, $page_info[ 'taxonomy' ] ),
                                );
                            }
                        }
                        foreach ( $child as $child_term ) {
                            $archive[ 'brother' ][] = array(
                                'current' => (int)$child_term->term_id === (int)$page_info[ 'term_id' ] ? '1' : '',
                                'term_id' => $child_term->term_id,
                                'slug' => $child_term->slug,
                                'name' => $child_term->name,
                                'count' => $child_term->count,
                                'parent' => $child_term->parent,
                                'url' => get_term_link( $child_term->slug, $page_info[ 'taxonomy' ] ),
                            );
                        }
                    }
                }
                /* 子カテゴリー取得 */
                if ( isset( $child_flg[ 'child' ] ) ) {
                    $child = get_terms( $page_info[ 'taxonomy' ], array( 'parent' => $page_info[ 'term_id' ], ) ) ;
                    if ( is_array( $child ) && count( $child ) > 0 && !is_wp_error( $child ) ) {
                        $archive[ 'child' ] = array();
                        $archive[ 'child' ][] = array(
                            'current' => '1',
                            'term_id' => $page_info[ 'term_id' ],
                            'slug' => isset( $term_slug ) ? $term_slug : '',
                            'name' => $title,
                            'count' => isset( $term_count ) ? $term_count : '',
                            'parent' => $page_info[ 'term_id' ],
                            'url' => get_term_link( $page_info[ 'term_id' ], $page_info[ 'taxonomy' ] ),
                        );
                        foreach ( $child as $child_term ) {
                            $archive[ 'child' ][] = array(
                                'current' => (int)$child_term->term_id === (int)$page_info[ 'term_id' ] ? '1' : '',
                                'term_id' => $child_term->term_id,
                                'slug' => $child_term->slug,
                                'name' => $child_term->name,
                                'count' => $child_term->count,
                                'parent' => $child_term->parent,
                                'url' => get_term_link( $child_term->slug, $page_info[ 'taxonomy' ] ),
                            );
                        }
                    }
                }
            }
        } else {
            $archive[ 'title' ] = $title;
            $archive[ 'taxonomy' ] = '404';
        }
        $this->setPageInfo( $page_info );
        $this->setPostSummary( $post_summary );
        $this->setArchive( $archive );
        return $this->getPageInfo();
    }
    
    // キャッシュパーツ取得
    public function getCacheDatas() {
        $data = array();
        $main_value = $this->getSiteOption();
        $testab = $this->getTestab();
        if ( isset( $main_value[ 'terms' ] ) && is_array( $main_value[ 'terms' ] ) && count( $main_value[ 'terms' ] ) > 0 ) {
            $terms_list = get_transient( 'DG_terms' . $testab );
            if ( $terms_list === false ) {
                $terms_list = array();
                foreach( (array)$main_value[ 'terms' ] as $tax ) {
                    $args = array();
                    $terms = get_terms( $tax, $args );
                    if ( !empty( $terms ) && !is_wp_error( $terms ) ){
                        $taxonomy = get_taxonomy( $tax );
                        $terms_list[ $tax ][] = array(
                            'slug' => '',
                            'name' => $taxonomy->label
                        );
                        foreach( (array)$terms as $term ) {
                            $terms_list[ $tax ][] = array(
                                'slug' => $term->slug,
                                'name' => $term->name
                            );
                        }
                    }
                }
                set_transient( 'DG_terms' . $testab, $terms_list, DAY_IN_SECONDS );
            }
            $data[ 'terms' ] = $terms_list;
        }
        //グローバルメニュー
        if ( isset( $main_value[ 'gmenu' ] ) && is_array( $main_value[ 'gmenu' ] ) && count( $main_value[ 'gmenu' ] ) > 0 ) {
            $gmenu = get_transient( 'DG_gmenu_list' . $testab );
            if ( $gmenu === false ) {
                $gmenu = array();
                foreach( (array)$main_value[ 'gmenu' ] as $name ) {
                    $gmenu[ $name ] = create_menu_list_part( $name );
                }
                set_transient( 'DG_gmenu_list' . $testab, $gmenu, DAY_IN_SECONDS );
            }
            $data[ 'gmenu' ] = $gmenu;
        }
        //記事コンテンツ指定記事取得
        if ( isset( $main_value[ 'select_post_ids' ] ) ) {
            $select_posts = get_transient( 'DG_select_posts' . $testab );
            if ( $select_posts === false ) {
                $select_posts = get_select_post_content( $main_value[ 'select_post_ids' ] );
                set_transient( 'DG_select_posts' . $testab, $select_posts, DAY_IN_SECONDS );
            }
            $data[ 'selectPosts' ] = $select_posts;
        }
        //お問い合わせ取得
        if ( isset( $main_value[ 'contact_ids' ] ) ) {
            $contacts = get_transient( 'DG_contacts' . $testab );
            if ( $contacts === false ) {
                $contacts = array();
                foreach( (array)$main_value[ 'contact_ids' ] as $contact_id ) {
                    $contact = get_post( $contact_id );
                    if ( $contact !== null ) {
                        $contacts[ $contact_id ] = $contact->post_content;
                    }
                }
                set_transient( 'DG_contacts' . $testab, $contacts, DAY_IN_SECONDS );
            }
            $data[ 'contactList' ] = $contacts;
        }
        return $data;
    }
}