<?php
class CreatePageInfoPhp extends CreatePageInfo {
    private $siteDisplay = '1';
    private $post;
    private $termObject;
    
    //宣言時実行
    public function __construct() {
        $this->homeUrl = home_url();
        $this->setPageByPhp();
    }
    //サイト表示タイプ取得
    public function getSiteDisplay() {
        return $this->siteDisplay;
    }
    //サイト表示タイプセット
    protected function setSiteDisplay( $str ) {
        $this->siteDisplay = $str;
    }
    //post取得
    public function getPost() {
        return $this->post;
    }
    //postセット
    protected function setPost( $obj ) {
        $this->post = $obj;
    }
    
    //termObject取得
    public function getTermObject() {
        return $this->termObject;
    }
    //termObjectセット
    protected function setTermObject( $obj ) {
        $this->termObject = $obj;
    }
    
    //送信されたURLからpageInfo作成
    private function setPageByPhp() {
        global $post;
        $term_object = get_queried_object();
        $site_display = get_option( 'DG_display_flg', '1' );
        $this->setSiteDisplay( $site_display );
        $this->setTermObject( $term_object );
        $this->setPost( $post );
        //ABテスト判定
        $testab = get_query_var( 'testab' );
        if ( get_option( 'DG_site_design_' . $testab, '' ) === '' ) {
            $testab = '';
            //メインデザインの場合ABテストランダム表示
            $DG_abtest_designs = get_option( 'DG_abtest_designs', '' );
            if ( $DG_abtest_designs !== '' && get_option( 'DG_abtest_auto', '2' ) === '1' ) {
                $DG_abtest_designs = json_decode( $DG_abtest_designs, true );
                $DG_abtest_designs[ 'DGMAINDESIGN' ] = '';
                $testab = $DG_abtest_designs[ array_rand( $DG_abtest_designs ) ] ;
            }
        }
        $page_flg = array(
            'is_home' => ( is_front_page() || is_home() ),
            'is_search' => is_search(),
            'is_author' => is_author(),
            'is_post_type_archive' => is_post_type_archive(),
            'is_archive' => is_archive() && !is_date(),
            'is_date' => is_date(),
            'is_single' => is_single() || is_page(),
            'is_404' => is_404(),
        );
        $this->setPageFlg( $page_flg );
        /* ページタイプ定義 */
        $paged = get_query_var( 'paged' );
        $site_name = get_option( 'blogname', '' );
        $this->setSiteName( $site_name );
        $page_info = array();
        $page_info[ 'paged' ] = $paged === 0 ? 1 : $paged;
        $page_info[ 'testab' ] = $testab;
        $page_info[ 'orderby' ] = get_query_var( 'orderby' );
        $page_info[ 'order' ] = get_query_var( 'order' );
        $page_info[ 'count' ] = get_query_var( 'count' );
        $page_info[ 'srange' ] = get_query_var( 'srange' );
        $page_info[ 'stax' ] = get_query_var( 'stax' );
        $page_info[ 'slang' ] = get_query_var( 'slang' );
        $page_slug = 'top';
        switch ( true ) {
            case ( $page_flg[ 'is_home' ] ) :
                $page_info[ 'taxonomy' ] = 'top';
                $page_info[ 'page_type' ] = 'top';
                $this->setTitle( $site_name );
                $this->setDescription( get_option( 'blogdescription', '' ) );
                $this->setPageClass( 'top' );
                break;
            case ( $page_flg[ 'is_search' ] ) :
                $search = get_search_query();
                $page_info[ 'term_id' ] = $search;
                $page_info[ 'taxonomy' ] = 'search';
                $page_info[ 'page_type' ] = 'search';
                $page_slug = 'other-search';
                $this->setTitle( $search );
                $this->setPageClass( 'search' );
                break;
            case ( $page_flg[ 'is_author' ] ) :
                $author_id = $term_object->ID;
                $page_info[ 'term_id' ] = $author_id;
                $page_info[ 'taxonomy' ] = 'author';
                $page_info[ 'page_type' ] = 'author';
                $page_slug = 'other-author';
                $this->setTitle( $term_object->display_name );
                $this->setDescription( get_the_author_meta( 'description', $author_id ) );
                $this->setPageClass( 'author' );
                break;
            case ( $page_flg[ 'is_post_type_archive' ] ) :
                $page_info[ 'taxonomy' ] = $term_object->name;
                $page_info[ 'page_type' ] = 'custom-post-archive';
                $page_info[ 'post_type' ] = array( $term_object->name );
                $page_slug = $page_info[ 'page_type' ] . '-' . $term_object->name;
                $this->setTitle( $term_object->label );
                $this->setDescription( $term_object->description );
                $this->setPageClass( 'post-archive ' . $term_object->name );
                break;
            case ( $page_flg[ 'is_archive' ] ) :
                $term_parent_id = $term_object->parent;
                $term_id = $term_object->term_id;
                $page_info[ 'term_id' ] = $term_id;
                $page_info[ 'parent_id' ] = $term_parent_id;
                $page_info[ 'taxonomy' ] = $term_object->taxonomy;
                $page_info[ 'page_type' ] = 'taxonomy';
                $page_slug = 'taxonomy-' . $term_object->taxonomy;
                $taxonomy_data = get_taxonomy( $term_object->taxonomy );
                if ( $taxonomy_data ) {
                    $page_info[ 'post_type' ] = $taxonomy_data->object_type;
                }
                if ( $page_info[ 'count' ] === '' ) {
                    $page_info[ 'count' ] = get_term_meta( $term_id, 'count', true );
                }
                if ( $page_info[ 'orderby' ] === '' ) {
                    $page_info[ 'orderby' ] = get_term_meta( $term_id, 'orderby', true );
                }
                if ( $page_info[ 'order' ] === '' ) {
                    $page_info[ 'order' ] = get_term_meta( $term_id, 'order', true );
                }
                $this->setTitle( $term_object->name );
                $this->setDescription( $term_object->description );
                $this->setTermCount( $term_object->count );
                $this->setTermSlug( $term_object->slug );
                $this->setPageClass( 'taxonomy ' . $page_info[ 'taxonomy' ] . ' ' . $term_object->slug );
                $this->setTaxonomyThumbnail( get_taxonomy_thumbnail_image( $term_id ) );
                $this->setTaxonomySubTitle( get_term_meta( $term_id, 'sub_title', true ) );
                $this->setTermParentId( $term_parent_id );
                break;
            case ( $page_flg[ 'is_date' ] ) :
                $year = get_query_var( 'year' );
                $month = get_query_var( 'monthnum' );
                $day = get_query_var( 'day' );
                $page_slug = 'taxonomy-date';
                $this->setYear( (int)$year );
                $this->setMonth( (int)$month );
                $this->setDay( (int)$day );
                if ( $day !== 0 && $month !== 0 && $year !== 0 ) {
                    $page_info[ 'term_id' ] = array(
                        'year' => $year,
                        'monthnum' => $month,
                        'day' => $day,
                    );
                    $page_info[ 'taxonomy' ] = 'date';
                    $page_info[ 'page_type' ] = 'taxonomy';
                    $this->setTitle( $year .'-' . $month . '-' . $day );
                    $this->setPageClass( 'taxonomy date' );
                } elseif ( $month !== 0 && $year !== 0 ) {
                    $page_info[ 'term_id' ] = array(
                        'year' => $year,
                        'monthnum' => $month,
                    );
                    $page_info[ 'taxonomy' ] = 'date';
                    $page_info[ 'page_type' ] = 'taxonomy';
                    $this->setTitle( $year .'-' . $month );
                    $this->setPageClass( 'taxonomy date' );
                } elseif ( $year !== 0 ) {
                    $page_info[ 'term_id' ][ 'year' ] = $year;
                    $page_info[ 'taxonomy' ] = 'date';
                    $page_info[ 'page_type' ] = 'taxonomy';
                    $this->setTitle( $year );
                    $this->setPageClass( 'taxonomy date' );
                }
                break;
            case ( $page_flg[ 'is_single' ] ) :
                $page_info[ 'post_id' ] = $post->ID;
                $page_info[ 'page_type' ] = 'single';
                $page_info[ 'taxonomy' ] = $post->post_type;
                $page_slug = 'single-' . $post->post_type;
                if ( $post->post_type === 'lp' ) {
                    $page_info[ 'lpFlg' ] = true;
                }
                $this->setPageClass( 'single ' . $post->post_type . ' post-' . $post->ID );
                break;
            case ( $page_flg[ 'is_404' ] ) :
                $page_info[ 'taxonomy' ] = '404';
                $page_info[ 'page_type' ] = '404';
                $this->setTitle( __( 'お探しのページが見つかりませんでした', 'dg-style' ) );
                $this->setPageClass( 'page404' );
                break;
            default :
                $page_info[ 'taxonomy' ] = 'top';
                $page_info[ 'page_type' ] = 'top';
                $this->setTitle( $site_name );
                $this->setDescription( get_option( 'blogdescription', '' ) );
                $this->setPageClass( 'top' );
                break;
        }
        $this->setPageSlug( $page_slug );
        $this->setPageInfo( $page_info );
        $this->setTestab( $page_info );
        $this->setScripts();
    }
}