<?php
/*
 * チュートリアル
*/
function window_tutorial_menu( $stylesheet_url, $page_type ) {
    if ( $page_type === 'lp' ) {
        $template_label = __( 'LPテンプレートの利用', 'dg-style' );
    } else {
        $template_label = __( 'サイトテンプレートの利用', 'dg-style' );
    }
    $menus = [];
    $menus[] = array(
        'key' => 'addArea',
        'tab' => 'area,part',
        'label' => __( 'エリア追加', 'dg-style' ),
    );
    if ( $page_type !== 'lp' ) {
        $menus[] = array(
            'key' => 'allBtns',//javascript関数名と連動する
            'tab' => 'basic',
            'label' => __( '各種ボタンの説明', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'pageMove',
            'tab' => 'basic',
            'label' => __( 'ページ移動方法', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'searchMovePage',
            'tab' => 'basic',
            'label' => __( 'ページを検索して移動', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'addSiteDesign',
            'tab' => 'basic,sitedesign',
            'label' => __( 'サイトデザイン追加', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'deleteSiteDesign',
            'tab' => 'basic,sitedesign',
            'label' => __( 'サイトデザイン削除', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'releaseSiteDesign',
            'tab' => 'basic,sitedesign',
            'label' => __( 'サイトデザイン公開', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'selectSiteDesign',
            'tab' => 'basic,sitedesign',
            'label' => __( 'サイトデザイン選択', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'copySiteDesign',
            'tab' => 'basic,sitedesign',
            'label' => __( 'サイトデザインコピー', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'abTestSiteDesign',
            'tab' => 'basic,sitedesign',
            'label' => __( 'ABテスト登録', 'dg-style' ),
        );
    }
    $menus[] = array(
        'key' => 'optionMenus',
        'tab' => 'basic,area,part',
        'label' => __( 'パーツオプションメニュー説明', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'applyTemplete',
        'tab' => 'template,sitedesign',
        'label' => $template_label,
    );
    $menus[] = array(
        'key' => 'comparisonDesign',
        'tab' => 'basic',
        'label' => __( '公開デザインと比較', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'hiddenBtns',
        'tab' => 'basic',
        'label' => __( 'ボタン非表示', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'saveSiteDesign',
        'tab' => 'basic',
        'label' => __( 'デザイン保存', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'closeSiteBuilder',
        'tab' => 'basic',
        'label' => __( 'サイトビルダーを閉じる', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partMap',
        'tab' => 'basic',
        'label' => __( 'パーツマップ', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'useHistory',
        'tab' => 'basic',
        'label' => __( 'ヒストリー使い方', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'siteDesignUpDownload',
        'tab' => 'basic',
        'label' => __( 'サイトデザインのアップロード＆ダウンロード方法', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'dgstyleContactForm',
        'tab' => 'basic',
        'label' => __( 'DG-STYLEへお問い合わせ方法', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'changeDevice',
        'tab' => 'basic',
        'label' => __( 'デバイス表示切り替え', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'changeDarkmode',
        'tab' => 'basic',
        'label' => __( 'ダークモード表示', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'reloadSimulator',
        'tab' => 'basic',
        'label' => __( 'シミュレーターリロード', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'emptyAreaDisplay',
        'tab' => 'basic',
        'label' => __( '空白エリア表示', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'showLoadingImage',
        'tab' => 'basic',
        'label' => __( 'Loading-Image表示', 'dg-style' ),
    );
    //共通オプション関連
    $menus[] = array(
        'key' => 'siteLogo',
        'tab' => 'common',
        'label' => __( 'ロゴ設定方法', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'selectColorPalatte',
        'tab' => 'common',
        'label' => __( 'パレット選択', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'addColorPalatte',
        'tab' => 'common',
        'label' => __( 'パレット追加', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'deleteColorPalatte',
        'tab' => 'common',
        'label' => __( 'パレット削除', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'changeColorPalatte',
        'tab' => 'common',
        'label' => __( 'パレット色修正', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'addColorSet',
        'tab' => 'common',
        'label' => __( 'カラーセット追加', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'deleteColorSet',
        'tab' => 'common',
        'label' => __( 'カラーセット削除', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'changeColorSet',
        'tab' => 'common',
        'label' => __( 'カラーセット変更', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'selectDevice',
        'tab' => 'common',
        'label' => __( 'デバイス選択', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'movingDeviceData',
        'tab' => 'common',
        'label' => __( 'デバイス引っ越し', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'fixedImageSet',
        'tab' => 'common',
        'label' => __( '固定サムネイル設定', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'setNoImage',
        'tab' => 'common',
        'label' => __( 'No-Image設定', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'setLoadingImage',
        'tab' => 'common',
        'label' => __( 'Loading-Image設定', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'setFonts',
        'tab' => 'common',
        'label' => __( 'フォント設定', 'dg-style' ),
    );
    if ( $page_type !== 'lp' ) {
        $menus[] = array(
            'key' => 'setFavicon',
            'tab' => 'common',
            'label' => __( 'Favicon設定', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'setPwa',
            'tab' => 'common',
            'label' => __( 'PWA設定', 'dg-style' ),
        );
    }
    //パーツ関連
    $menus[] = array(
        'key' => 'addPart',
        'tab' => 'part',
        'label' => __( 'パーツ追加', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partName',
        'tab' => 'part',
        'label' => __( 'パーツ名変更', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partLock',
        'tab' => 'part',
        'label' => __( 'パーツロック', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partCriticalCss',
        'tab' => 'design,part',
        'label' => __( 'クリティカルCSS', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partCache',
        'tab' => 'part',
        'label' => __( 'キャッシュ登録', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partPreload',
        'tab' => 'part',
        'label' => __( 'Preload登録', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'lazyLoadOff',
        'tab' => 'part',
        'label' => __( 'LazyLoad解除', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partUpDown',
        'tab' => 'area,part',
        'label' => __( 'パーツ上下移動', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partMovingArea',
        'tab' => 'area,part',
        'label' => __( 'パーツエリア移動', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'copyPart',
        'tab' => 'area,part',
        'label' => __( 'パーツ・エリアコピー', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partTitle',
        'tab' => 'part',
        'label' => __( 'パーツタイトル設定', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partTemplate',
        'tab' => 'area,part,template',
        'label' => __( 'パーツテンプレート', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partDesign',
        'tab' => 'area,part,design',
        'label' => __( 'デザイン設定', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partOption',
        'tab' => 'area,part',
        'label' => __( '専用オプション', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partSlide',
        'tab' => 'area,part',
        'label' => __( 'スライド設定', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partEvent',
        'tab' => 'area,part',
        'label' => __( 'イベント設定', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'csssEvent',
        'tab' => 'area,part',
        'label' => __( 'CSS連動イベント設定', 'dg-style' ),
    );
    if ( $page_type !== 'lp' ) {
        $menus[] = array(
            'key' => 'partHidden',
            'tab' => 'area,part',
            'label' => __( '非表示設定', 'dg-style' ),
        );
    }
    $menus[] = array(
        'key' => 'selectChildParts',
        'tab' => 'area',
        'label' => __( '子パーツ選択（非表示パーツも）', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partParent',
        'tab' => 'area,part',
        'label' => __( '親エリア', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'addPartByArea',
        'tab' => 'area',
        'label' => __( 'エリアからパーツ追加', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'partDelete',
        'tab' => 'area,part',
        'label' => __( 'パーツ・エリア削除', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'areaTab',
        'tab' => 'area',
        'label' => __( 'エリアタブ設定', 'dg-style' ),
    );
    //デザイン関連
    $menus[] = array(
        'key' => 'setDarkmode',
        'tab' => 'design',
        'label' => __( 'ダークモード設定方法', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'simpleDesign',
        'tab' => 'simple',
        'label' => __( '簡単デザインの使い方', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'simpleEditName',
        'tab' => 'simple',
        'label' => __( 'デザインラベル編集', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'simpleEditSelector',
        'tab' => 'simple',
        'label' => __( 'セレクター編集', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'simpleDesignList',
        'tab' => 'simple',
        'label' => __( '登録済のデザインリスト', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'simpleOuterCss',
        'tab' => 'simple',
        'label' => __( '外部CSS貼り付け', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'simpleDesignReset',
        'tab' => 'simple',
        'label' => __( 'デザインリセット', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'simpleOpenDesignSet',
        'tab' => 'simple',
        'label' => __( 'デザイン設定を開く', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'cssAnimation',
        'tab' => 'design',
        'label' => __( 'CSSアニメーション作成', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'selectCssAnimation',
        'tab' => 'simple',
        'label' => __( 'CSSアニメーション選択', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'originalCss',
        'tab' => 'design',
        'label' => __( '独自CSS設定方法', 'dg-style' ),
    );
    $menus[] = array(
        'key' => 'solidCss',
        'tab' => 'design',
        'label' => __( 'CSSべた書き', 'dg-style' ),
    );
    if ( $page_type === 'lp' ) {
        $menus[] = array(
            'key' => 'lpStatus',
            'tab' => 'basic',
            'label' => __( '公開ステータス', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'lpTitle',
            'tab' => 'basic',
            'label' => __( 'LPタイトル', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'lpUrl',
            'tab' => 'basic',
            'label' => 'LP URL',
        );
        $menus[] = array(
            'key' => 'lpCopy',
            'tab' => 'basic',
            'label' => __( 'LP複製', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'setCustomMeta',
            'tab' => 'basic',
            'label' => __( 'カスタムMETA設定', 'dg-style' ),
        );
    }
    //応用篇
    $menus[] = array(
        'key' => 'rankingPost',
        'tab' => 'application',
        'label' => __( '人気記事設定', 'dg-style' ),
    );
    if ( $page_type !== 'lp' ) {
        $menus[] = array(
            'key' => 'recommendPost',
            'tab' => 'application',
            'label' => __( '関連記事設定', 'dg-style' ),
        );
    }
    $menus[] = array(
        'key' => 'editCssDesign',
        'tab' => 'simple,application',
        'label' => __( '簡単デザインでデザイン修正', 'dg-style' ),
    );
    //サイトテンプレート
    if ( $page_type !== 'lp' ) {
        $menus[] = array(
            'key' => 'templateBlog1',
            'tab' => 'template',
            'label' => __( 'ブログ1', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'templateBlog2',
            'tab' => 'template',
            'label' => __( 'ブログ2', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'templateBlog3',
            'tab' => 'template',
            'label' => __( 'ブログ3', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'templateBlog4',
            'tab' => 'template',
            'label' => __( 'ブログ4', 'dg-style' ),
        );
        $menus[] = array(
            'key' => 'templateBlog5',
            'tab' => 'template',
            'label' => __( 'ブログ5', 'dg-style' ),
        );
    }
    //ボタン作成
    $html_menu = '';
    foreach( (array)$menus as $val ) {
        $html_menu .= '<button type="button" class="tutorial-start-btn" data-type="' . $val[ 'key' ] . '" data-tab="' . $val[ 'tab' ] . '">' . $val[ 'label' ] . '</button>';
    }
    //タブラベル作成
    $label_arr = array(
        'basic' => __( '基礎', 'dg-style' ),
        'common' => __( '共通オプション', 'dg-style' ),
        'sitedesign' => __( 'サイトデザイン', 'dg-style' ),
        'template' => __( 'テンプレート', 'dg-style' ),
        'simple' => __( '簡単デザイン', 'dg-style' ),
        'design' => __( 'デザイン', 'dg-style' ),
        'area' => __( 'エリア関連', 'dg-style' ),
        'part' => __( 'パーツ関連', 'dg-style' ),
        'application' => __( '応用', 'dg-style' ),
    );
    $html_label = '';
    foreach( (array)$label_arr as $key => $name ) {
        $html_label .= '<button type="button" class="tutorial-tab-label" data-tab="' . $key . '">' . $name . '</button>';
    }
    //翻訳
    $menu_title = __( 'どの機能を見る？', 'dg-style' );
    $close_title1 = __( '戻る', 'dg-style' );
    $close_title2 = __( '閉じる', 'dg-style' );
    $label_all = __( '全て', 'dg-style' );
    return <<< EOM
        <div id="tutorial-menu">
            <div id="tutorial-icon">
                <img src="{$stylesheet_url}/image/tutorial-icon.png" id="tutorial-icon-image">
                <button type="button" id="close-tutorial">
                    <span class="return-text">{$close_title1}</span>
                    <span class="close-text">{$close_title2}</span>
                </button>
            </div>
            <div class="tutorial-area">
                <div class="tutorial-title">{$menu_title}</div>
                <div class="tutorial-tab-labels">
                    <button type="button" class="tutorial-tab-label on" data-tab="all">{$label_all}</button>
                    {$html_label}
                </div>
                <div id="tutorial-btns">{$html_menu}</div>
            </div>
            <div id="tutorial-message"></div>
        </div>
EOM;
}