<?php
/*
 * ユーザーページにJSスクリプト追加
*/
add_action( 'admin_print_styles-post-new.php', 'dg_style_post_style' );
add_action( 'admin_print_styles-post.php', 'dg_style_post_style' );
function dg_style_post_style() {
    $site_update_time = date( 'YmdHis' );
    $directory_url = get_template_directory_uri();
    $post_type = get_post_type();
    if ( $post_type === 'dg_contact' ) {
        echo <<< EOM
        <style>
            @font-face {
                font-family: 'webicon';
                src:  url('{$directory_url}/css/webicon/icomoon.eot?wwza6v');
                src:  url('{$directory_url}/css/webicon/icomoon.eot?wwza6v#iefix') format('embedded-opentype'),
                url('{$directory_url}/css/webicon/icomoon.ttf?wwza6v') format('truetype'),
                url('{$directory_url}/css/webicon/icomoon.woff?wwza6v') format('woff'),
                url('{$directory_url}/css/webicon/icomoon.svg?wwza6v#icomoon') format('svg');
                font-weight: normal;
                font-style: normal;
                font-display: swap;
            }
        </style>
EOM;
        wp_register_style( 'dg-post-admin-css', $directory_url . '/wp-admin/post/post-contact.css?ver=' . $site_update_time );
    } elseif ( $post_type === 'lp' ) {
        wp_register_style( 'dg_slider_css', $directory_url . '/css/temp/slide.css?ver=' . $site_update_time );
        wp_register_style( 'site_builder_css', $directory_url . '/wp-admin/site_builder/site_builder.css?ver=' . $site_update_time );
        wp_register_style( 'dg_color_picker', $directory_url . '/wp-admin/site_builder/color-picker.css?ver=' . $site_update_time );
        wp_enqueue_style( 'dg_slider_css' );
        wp_enqueue_style( 'site_builder_css' );
        wp_enqueue_style( 'dg_color_picker' );
    } else {
        wp_register_style( 'dg-post-admin-css', $directory_url . '/wp-admin/post/post-admin.css?ver=' . $site_update_time );
    }
    wp_enqueue_style( 'dg-post-admin-css' );
}

/*
 * ユーザーページにJSスクリプト追加
*/
add_action( 'admin_print_scripts-post-new.php', 'dg_style_post_scripts' );
add_action( 'admin_print_scripts-post.php', 'dg_style_post_scripts' );
function dg_style_post_scripts() {
    $site_update_time = date( 'YmdHis' );
    $directory_url = get_template_directory_uri();
    $post_type = get_post_type();
    $wp_js = array( 'jquery', 'wp-i18n', );
    if ( $post_type === 'dg_contact' ) {
        wp_enqueue_media();
        wp_enqueue_script( 'media-upload' );
        wp_enqueue_script( 'jquery-ui-droppable' );
        wp_enqueue_script( 'jquery-ui-sortable' );
        wp_enqueue_script( 'jquery-ui-resizable' );
        wp_enqueue_script( 'site_builder_js', $directory_url . '/wp-admin/post/post-contact.js', $wp_js, $site_update_time, true );
    } elseif ( $post_type === 'lp' ) {
        $directory_url = get_template_directory_uri();
        wp_enqueue_media();
        wp_enqueue_script( 'media-upload' );
        wp_enqueue_script( 'jquery-ui-droppable' );
        wp_enqueue_script( 'jquery-ui-sortable' );
        wp_enqueue_script( 'jquery-ui-resizable' );
        $wp_js = array( 'jquery', 'wp-i18n', );
        wp_enqueue_script( 'site_builder_js', $directory_url . '/wp-admin/site_builder/site_builder.js', $wp_js, $site_update_time, true );
        wp_enqueue_script( 'site_tutorial_js', $directory_url . '/wp-admin/site_builder/site_tutorial.js', $wp_js, $site_update_time, true );
        //JS翻訳スクリプト追加
        wp_set_script_translations( 'site_builder_js', 'dg-style', get_template_directory() . '/languages' );
        dg_mirror_editor();
    } else {
        wp_enqueue_script( 'site_builder_js', $directory_url . '/wp-admin/post/post-admin.js', $wp_js, $site_update_time, true );
    }
    //JS翻訳スクリプト追加
    wp_set_script_translations( 'site_builder_js', 'dg-style', get_template_directory() . '/languages' );
}

/*
 * カスタムフィールド追加
*/
add_action( 'admin_menu', 'dg_style_post_custom_field_menu' );
function dg_style_post_custom_field_menu() {
    if ( function_exists( 'add_meta_box' ) ) {
        $post_types = get_post_types( array( 'public' => true, ), 'objects' );
        foreach ( $post_types as $post_type ) {
            if ( $post_type->name !== 'attachment' && $post_type->name !== 'dg_contact' && $post_type->name !== 'lp' && $post_type->name !== 'dg_patterns' ) {
                add_meta_box( 'movie-thumbnail', __( '動画サムネイル', 'dg-style' ), 'dg_custom_movie_thumbnail', $post_type->name, 'side', 'high' );
                add_meta_box( 'meta-information', __( 'カスタムMETA', 'dg-style' ), 'dg_custom_meta_information', $post_type->name, 'side', 'high' );
                add_meta_box( 'dg-recommend-posts', __( '関連記事', 'dg-style' ), 'dg_custom_recommend_post_list', $post_type->name, 'side', 'high' );
            }
        }
    }
}

/*
 * 動画サムネイル
*/
function dg_custom_movie_thumbnail() {
    global $post;
    $text_image_btn = __( '動画を選択', 'dg-style' );
    $text_image_delete = __( '削除', 'dg-style' );
    $post_id = $post->ID;
    $movie_thumbnail = get_post_meta( $post_id, 'movie_thumbnail', true );
    $input_value = '';
    $wp_on = ' on';
    $wp_check = ' checked';
    $wp_movie = '<a href="#" class="movie-upload-btn ui-btn">' . $text_image_btn . '</a><a class="movie-remove-btn ui-btn">' . $text_image_delete . '</a>';
    $url_on = '';
    $url_check = '';
    $movie_url_value = '';
    $movie_url_simulator = '';
    $iframe_on = '';
    $iframe_check = '';
    $iframe_value = '';
    $iframe_tag = '';
    if ( $movie_thumbnail !== '' ) {
        $movie_arr = json_decode( $movie_thumbnail, true );
        if ( isset( $movie_arr[ 'type' ] ) && $movie_arr[ 'type' ] === '1' ) {
            $wp_on = ' on';
            $wp_check = ' checked';
            if ( isset( $movie_arr[ 'value' ] ) && $movie_arr[ 'value' ] !== '' ) {
                $wp_movie = '<a href="#" class="movie-upload-btn"><video controls="true"><source src="' . $movie_arr[ 'value' ] . '"></video></a><a class="movie-remove-btn ui-btn on">' . $text_image_delete . '</a>';
            }
        } elseif ( isset( $movie_arr[ 'type' ] ) && $movie_arr[ 'type' ] === '2' ) {
            $wp_on = '';
            $wp_check = '';
            $url_on = ' on';
            $url_check = ' checked';
            if ( isset( $movie_arr[ 'value' ] ) && $movie_arr[ 'value' ] !== '' ) {
                $movie_url_value = $movie_arr[ 'value' ];
                $movie_url_simulator = '<video controls="true"><source src="' . $movie_arr[ 'value' ] . '"></video>';
            }
        } elseif ( isset( $movie_arr[ 'type' ] ) && $movie_arr[ 'type' ] === '3' ) {
            $wp_on = '';
            $wp_check = '';
            $iframe_on = ' on';
            $iframe_check = ' checked';
            if ( isset( $movie_arr[ 'value' ] ) && $movie_arr[ 'value' ] !== '' ) {
                $iframe_value = htmlspecialchars( $movie_arr[ 'value' ], ENT_QUOTES, 'UTF-8' );
                $iframe_tag = $movie_arr[ 'value' ];
            }
        }
        $input_value = htmlspecialchars( $movie_thumbnail, ENT_QUOTES, 'UTF-8' );
    }
    
    $text_wp_image = __( 'WP動画', 'dg-style' );
    $text_image_url = __( '動画URL', 'dg-style' );
    $text_image_iframe = __( 'iframeタグ', 'dg-style' );
    echo <<< EOM
        <div class="dg-custom-area">
            <div class="tab-inner movie-select-tabs">
                <div class="tab-list movie-labels flex">
                    <label class="tab-label movie-label{$wp_on}"><input type="radio" name="movie-thumbnail-type" value="1" class="movie-thumbnail-input none-display"{$wp_check}><span class="toggle-label">{$text_wp_image}</span></label>
                    <label class="tab-label movie-label{$url_on}"><input type="radio" name="movie-thumbnail-type" value="2" class="movie-thumbnail-input none-display"{$url_check}><span class="toggle-label">{$text_image_url}</span></label>
                    <label class="tab-label movie-label{$iframe_on}"><input type="radio" name="movie-thumbnail-type" value="3" class="movie-thumbnail-input none-display"{$iframe_check}><span class="toggle-label">{$text_image_iframe}</span></label>
                </div>
                <div class="tab-contents movie-contents">
                    <div class="tab-content{$wp_on}">
                        <div id="wp-movie-thumbnail" class="movie-box">{$wp_movie}</div>
                    </div>
                    <div class="tab-content{$url_on}">
                        <label for="movie-thumbnail-url-input" class="dg-custom-title">{$text_image_url}</label>
                        <input id="movie-thumbnail-url-input" type="text" class="movie-thumbnail-url-value movie-url-value" value="{$movie_url_value}">
                        <div id="movie-thumbnail-url-simulator" class="movie-thumbnail-simulator">{$movie_url_simulator}</div>
                    </div>
                    <div class="tab-content{$iframe_on}">
                        <label for="movie-thumbnail-iframe-input" class="dg-custom-title">{$text_image_iframe}</label>
                        <input id="movie-thumbnail-iframe-input" type="text" class="movie-thumbnail-iframe-value movie-iframe-value" value="{$iframe_value}">
                        <div id="movie-thumbnail-iframe-simulator" class="movie-thumbnail-simulator">{$iframe_tag}</div>
                    </div>
                </div>
                <input type="hidden" name="movie_thumbnail" id="movie-thumbnail-value" value="{$input_value}">
            </div>
        </div>
EOM;
}

/*
 * META情報フィールド
*/
function dg_custom_meta_information() {
    global $post;
    $post_id = $post->ID;
    $dg_meta = get_post_meta( $post_id, 'dg_meta', true );
    $title = '';
    $description = '';
    $canonical = '';
    $noindex = '';
    if ( $dg_meta !== '' ) {
        $dg_meta = json_decode( $dg_meta, true );
        $title = isset( $dg_meta[ 'title' ] ) ? $dg_meta[ 'title' ] : '';
        $description = isset( $dg_meta[ 'description' ] ) ? $dg_meta[ 'description' ] : '';
        $canonical = isset( $dg_meta[ 'canonical' ] ) ? $dg_meta[ 'canonical' ] : '';
        $noindex = isset( $dg_meta[ 'noindex' ] ) && $dg_meta[ 'noindex' ] === '1' ? ' checked' : '';
    }
    //翻訳
    $text_title1 = __( 'METAタイトル', 'dg-style' );
    $text_title2 = __( 'METAディスクリプション', 'dg-style' );
    $text_title3 = __( 'Canonical設定', 'dg-style' );
    $text_title4 = __( 'Noindexにする', 'dg-style' );
    $text_count = __( '文字数', 'dg-style' );
    echo <<< EOM
        <div class="dg-custom-area">
            <label class="dg-custom-title" for="dg_meta_title">{$text_title1} {$text_count}：<strong id="dg_meta_title_count"></strong></label>
            <input type="text" name="dg_meta_title" id="dg_meta_title" value="{$title}">
        </div>
        <div class="dg-custom-area">
            <label class="dg-custom-title" for="dg_meta_description">{$text_title2} {$text_count}：<strong id="dg_meta_description_count"></strong></label>
            <textarea name="dg_meta_description" id="dg_meta_description" rows="4">{$description}</textarea>
        </div>
        <div class="dg-custom-area">
            <label class="dg-custom-title" for="dg_meta_canonical">{$text_title3}</label>
            <input type="text" name="dg_meta_canonical" id="dg_meta_canonical" value="{$canonical}">
        </div>
        <div class="dg-custom-area">
            <label class="dg-custom-title" for="dg_meta_noindex"><input type="checkbox" name="dg_meta_noindex" id="dg_meta_noindex" value="1"{$noindex}>{$text_title4}</label>
        </div>
EOM;
}

/*
 * META情報フィールド
*/
function dg_custom_recommend_post_list() {
    global $post;
    $post_id = $post->ID;
    $post_list = '';
    $recommend_post = get_post_meta( $post_id, 'dg_recommend_post', true );
    $dg_post_css_json = get_post_meta( $post_id, 'dg_post_css_json', true );
    if ( $dg_post_css_json !== '' ) {
        $dg_post_css_json = htmlspecialchars( $dg_post_css_json );
    }
    $dg_post_css_ori = get_post_meta( $post_id, 'dg_post_css_ori', true );
    if ( $dg_post_css_ori !== '' ) {
        $dg_post_css_ori = htmlspecialchars( $dg_post_css_ori );
    }
    $dg_post_css = get_post_meta( $post_id, 'dg_post_css', true );
    if ( $recommend_post !== '' ) {
        $post_ids = explode( ',', $recommend_post );
        if ( is_array( $post_ids ) && count( $post_ids ) > 0 ) {
            foreach( (array)$post_ids as $id ) {
                $title = get_the_title( $id );
                $post_list .= '<div class="recommend-item">' . $title . '<button type="button" class="delete-recommend-post" value="' . $id . '">' . __( '削除', 'dg-style' ) . '</button></div>';
            }
        }
    }
    $simple_design = window_simple_design_menus( false );
    $css_selector = create_css_selector_option();
    $webicon = window_web_icon_list();
    //翻訳
    $text_title = __( '記事検索', 'dg-style' );
    $text_placeholder = __( 'キーワード入力', 'dg-style' );
    $text_title1 = __( '選択した記事', 'dg-style' );
    $text_original_css = __( '独自CSS設定', 'dg-style' );
    $text_clipboard = __( 'クリップボードにコピーしました。', 'dg-style' );
    echo <<< EOM
        <div class="post-recommend-search-form">
            <label for="recommend-post-search-input" class="dg-custom-title">{$text_title}</label>
            <div class="search-input-area">
                <input type="text" id="recommend-post-search-input" class="search-posts-input" data-post_id="{$post_id}" placeholder="{$text_placeholder}">
            </div>
            <div class="dg-custom-title">{$text_title1}</div>
            <div id="selected-post-list">{$post_list}</div>
            <input type="hidden" id="dg_recommend_post" name="dg_recommend_post" value="{$recommend_post}">
        </div>
        <div id="none-display-parts">
            {$simple_design}
            <div id="dg-preview-inputs-area">
                <input type="hidden" id="site-design-value">
                <input type="hidden" id="site-design-value-original-css">
                <input type="hidden" id="site-design-value-color">
                <input type="hidden" id="site-design-value-font">
                <input type="hidden" id="site-design-value-device">
                <input type="hidden" id="site-design-value-logo">
                <input type="hidden" id="site-design-value-loading">
                <input type="hidden" id="site-design-value-noimage">
                <input type="hidden" id="site-design-value-fixed">
                <input type="hidden" id="site-design-value-animation">
                <input type="hidden" id="site-design-css-path">
                <input type="hidden" id="site-design-css-critical">
                <input type="hidden" id="dg_post_css_json" name="dg_post_css_json" value="{$dg_post_css_json}">
                <input type="hidden" id="dg_post_css_ori" name="dg_post_css_ori" value="{$dg_post_css_ori}">
                <input type="hidden" id="dg_post_css" name="dg_post_css" value="{$dg_post_css}">
            </div>
            {$css_selector}
            {$webicon}
            <div id="original-post-css-area">
                <div class="original-post-title">{$text_original_css}</div>
                <textarea id="original-post-css-textarea" rows="20"></textarea>
            </div>
            <div id="dg-preview-area" class="close">
                <div class="site-simulator-wrap">
                    <div class="site-simulator">
                        <div class="simulator-header"></div>
                        <div id="simulator-main" class="simulator-main-design">
                            <iframe id="site-simulator-iframe"></iframe>
                        </div>
                        <div class="simulator-footer"></div>
                    </div>
                </div>
                <div id="preview-option-btns">
                    <div id="preview-device-list"></div>
                    <button type="button" id="origianl-css-open" title="{$text_original_css}"></button>
                </div>
                <button type="button" id="dg-preview-close"></button>
            </div>
            <div id="clipboard-copy-message">{$text_clipboard}</div>
        </div>
EOM;
}

/*
 * デフォルトMETAデータ保存
*/
add_action( 'save_post', 'save_dg_custom_post_meta', 13, 3 );
function save_dg_custom_post_meta( $post_id, $post ){
    //リビジョンの場合実際の記事IDを取得
    if ( $parent_id = wp_is_post_revision( $post_id ) ) {
        $post_id = $parent_id;
    }
    $post_type = get_post_type( $post_id );
    //自動保存防止
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return $post_id;
    }
    //クィック編集防止
    if ( defined( 'DOING_AJAX' ) ) {
        return $post_id;
    }
    //権限確認
    if ( $post_type === 'lp' || $post_type === 'dg_contact' || ( $post_type === 'page' && !current_user_can( 'edit_page', $post_id ) ) ) {
        return $post_id;
    } elseif ( !current_user_can( 'edit_post', $post_id ) ) {
        return $post_id;
    }
    //公開の記事場合、キャッシュをリセット
    $post_status = get_post_status( $post_id );
    if ( $post_status === 'publish' ) {
        delete_all_transients();
    }
    //META保存
    $dg_meta = array( 'title' => '', 'description' => '', );
    //METAタイトル
    if ( isset( $_POST[ 'dg_meta_title' ] ) ) {
        $dg_meta[ 'title' ] = strip_tags( $_POST[ 'dg_meta_title' ] );
    }
    //METAディスクリプション
    if ( isset( $_POST[ 'dg_meta_description' ] ) ) {
        $dg_meta[ 'description' ] = strip_tags( $_POST[ 'dg_meta_description' ] );
    }
    if ( isset( $_POST[ 'dg_meta_canonical' ] ) ) {
        $dg_meta[ 'canonical' ] = strip_tags( $_POST[ 'dg_meta_canonical' ] );
    }
    if ( isset( $_POST[ 'dg_meta_noindex' ] ) ) {
        $dg_meta[ 'noindex' ] = $_POST[ 'dg_meta_noindex' ];
    }
    $dg_meta = wp_slash( json_encode( $dg_meta ) );
    $data_list = array(
        'dg_meta' => 'META情報',
        'dg_recommend_post' => '関連記事',
        'movie_thumbnail' => '動画サムネイル',
        'dg_post_css_json' => '記事デザイン',
        'dg_post_css_ori' => '独自CSS',
        'dg_post_css' => '記事デザイン',
    );
    foreach( (array)$data_list as $key => $value ) {
        //同じキーが重複してある場合削除する
        $postmeta = get_post_meta( $post_id, $key, false );
        if ( is_array( $postmeta ) && count( $postmeta ) > 1 ) {
            delete_post_meta( $post_id, $key );
        }
        if ( $key === 'dg_meta' ) {
            update_post_meta( $post_id, $key, $dg_meta );
        } elseif ( isset( $_POST[ $key ] ) ) {
            update_post_meta( $post_id, $key, $_POST[ $key ] );
        }
    }
    //同一キーの値が複数ある場合一つにする
    $double_list = array(
        'views',
        'w_views',
        'm_views',
        'y_views',
        'evaluate_total',
        'evaluate_table',
        'dg_bookmark',
    );
    foreach( (array)$double_list as $key ) {
        //同じキーが重複してある場合削除する
        $postmeta = get_post_meta( $post_id, $key, false );
        if ( is_array( $postmeta ) && count( $postmeta ) > 1 ) {
            $meta_value = $postmeta[ 0 ];
            delete_post_meta( $post_id, $key );
            update_post_meta( $post_id, $key, $meta_value );
        }
    }
}

/*
 * デフォルトMETAデータ保存
*/
add_action( 'save_post', 'save_default_post_meta', 13, 3 );
function save_default_post_meta( $post_id, $post, $update ){
    //新規記事の場合のみ更新する
    if ( $update === true ) {
        return;
    }
    //キャッシュを削除する
    delete_all_transients();
    
    //リビジョンの場合実際の記事IDを取得
    if ( $parent_id = wp_is_post_revision( $post_id ) ) {
        $post_id = $parent_id;
    }
    $post_type = get_post_type( $post_id );
    //自動保存防止
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return $post_id;
    }
    //クィック編集防止
    if ( defined( 'DOING_AJAX' ) ) {
        return $post_id;
    }
    //権限確認
    if ( $post_type === 'page' && !current_user_can( 'edit_page', $post_id ) ) {
        return $post_id;
    } elseif ( !current_user_can( 'edit_post', $post_id ) ) {
        return $post_id;
    }
    
    //META保存
    $data_list = array(
        'views' => 0,
        'w_views' => 0,
        'm_views' => 0,
        'y_views' => 0,
        'evaluate_total' => 0,
        'dg_recommend_post' => '',
        'movie_thumbnail' => '',
    );
    if ( $post_type === 'lp' ) {
        unset( $data_list[ 'dg_recommend_post' ] );
        unset( $data_list[ 'movie_thumbnail' ] );
    }
    foreach( (array)$data_list as $key => $value ) {
        //同じキーが重複してある場合削除する
        $postmeta = get_post_meta( $post_id, $key, false );
        if ( is_array( $postmeta ) && count( $postmeta ) > 1 ) {
            delete_post_meta( $post_id, $key );
        }
        ${$key} = isset( $_POST[ $key ] ) ? $_POST[ $key ] : $data_list[ $key ];
        update_post_meta( $post_id, $key, ${$key} );
    }
}

/*
 * 記事検索結果表示
*/
add_action( 'wp_ajax_search_recommed_post_list', 'search_recommed_post_list' );
add_action( 'wp_ajax_nopriv_search_recommed_post_list', 'search_recommed_post_list' );
function search_recommed_post_list() {
    $result = false;
    if ( isset( $_POST[ 'keyword' ] ) ) {
        $result = array();
        $args = array(
            'paged' => isset( $_POST[ 'paged' ] ) ? $_POST[ 'paged' ] : 1,
            'post_status' => 'publish',
            'posts_per_page' => 10,
            's' => $_POST[ 'keyword' ],
            'post__not_in' => isset( $_POST[ 'ids' ] ) ? explode( ',', $_POST[ 'ids' ] ) : array(),
        );
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) {
            while ( $query->have_posts() ) {
                $query->the_post();
                $result[] = array(
                    'id' => $query->post->ID,
                    'title' => $query->post->post_title,
                );
            }
            wp_reset_postdata();
        }
        if ( is_array( $result ) && count( $result ) === 0 ) {
            $result = false;
        }
    }
    echo json_encode( array( 'items' => $result ) );
    exit();
}
