<?php
/*
 * 今まで登録したカスタム投稿タイプ全体に挿入
*/
add_action( 'admin_init', 'dg_style_add_custom_post_type_page' );
function dg_style_add_custom_post_type_page() {
    $args = array(
        'public' => true,
    );
    $post_types = get_post_types( $args, 'objects' );
    foreach ( $post_types as $post_type ) {
        if ( !in_array( $post_type->name, POST_TYPE_EXCLUSION, true ) ) {
            add_filter( 'manage_' . $post_type->name . '_posts_columns', 'add_admin_post_list_columns_display' );
            add_action( 'manage_' . $post_type->name . '_posts_custom_column', 'add_admin_post_list_columns', 10, 2 );
        }
    }
}

/*
 * 表示オプションに項目追加
*/
function add_admin_post_list_columns_display( $columns ) {
    $columns[ 'thumbnail' ] = 'Thumbnail';
    $columns[ 'dg_meta_title' ] = __( 'METAタイトル', 'dg-style' );
    $columns[ 'dg_meta_description' ] = __( 'METAディスクリプション', 'dg-style' );
    $columns[ 'dg_meta_canonical' ] = 'canonical';
    $columns[ 'dg_meta_noindex' ] = 'noindex';
    return $columns;
}

/*
 * 記事リストにサムネイル追加
*/
function add_admin_post_list_columns( $column_name, $post_id ) {
    $result = false;
    //アイキャッチ取得
    if ( $column_name === 'thumbnail' ) {
        $this_post = get_post( $post_id );
        $thumb = post_thumbnail_src( $this_post );
        if ( $thumb !== false ) {
            if ( isset( $thumb[ 'url' ] ) ) {
                $result = '<img src="' . $thumb[ 'url' ] . '" width="50" height="50">';
            } else {
                if ( isset( $thumb[ 'thumbnail' ][ 'url' ] ) ) {
                    $result = '<img src="' . $thumb[ 'thumbnail' ][ 'url' ] . '" width="50" height="50">';
                } elseif ( isset( $thumb[ 'full' ][ 'url' ] ) ) {
                    $result = '<img src="' . $thumb[ 'full' ][ 'url' ] . '" width="50" height="50">';
                }
            }
        }
    } elseif ( $column_name === 'dg_meta_title' ) {
        //METAタイトル
        $dg_meta = get_post_meta( $post_id, 'dg_meta', true );
        $title = '';
        if ( $dg_meta !== '' ) {
            $dg_meta = json_decode( $dg_meta, true );
            $title = $dg_meta[ 'title' ];
        }
        if ( $title !== '' ) {
            $result = '<span class="meta-text">' . $title . '</span>';
        }
    } elseif ( $column_name === 'dg_meta_description' ) {
        //METAディスクリプション
        $dg_meta = get_post_meta( $post_id, 'dg_meta', true );
        $description = '';
        if ( $dg_meta !== '' ) {
            $dg_meta = json_decode( $dg_meta, true );
            $description = $dg_meta[ 'description' ];
        }
        if ( $description !== '' ) {
            $result = '<span class="meta-text">' . $description . '</span>';
        }
    } elseif ( $column_name === 'dg_meta_canonical' ) {
        //canonical
        $dg_meta = get_post_meta( $post_id, 'dg_meta', true );
        $canonical = '';
        if ( $dg_meta !== '' ) {
            $dg_meta = json_decode( $dg_meta, true );
            $canonical = isset( $dg_meta[ 'canonical' ] ) ? $dg_meta[ 'canonical' ] : '';
        }
        if ( $canonical !== '' ) {
            $result = '<span class="meta-text">' . $canonical . '</span>';
        }
    } elseif ( $column_name === 'dg_meta_noindex' ) {
        //noindex
        $dg_meta = get_post_meta( $post_id, 'dg_meta', true );
        $noindex = '';
        if ( $dg_meta !== '' ) {
            $dg_meta = json_decode( $dg_meta, true );
            $noindex = isset( $dg_meta[ 'noindex' ] ) ? $dg_meta[ 'noindex' ] : '';
        }
        if ( $noindex !== '' ) {
            $result = '<span class="meta-text">Noindex 〇</span>';
        }
    }
    //使用していない場合「なし」を表示
    if ( $result !== false ) {
        echo $result;
    } else {
        echo 'None';
    }
}