<?php
/*
 * お問い合わせフォームの追加
*/
add_action( 'init', 'add_dg_style_post_type_contact' );
function add_dg_style_post_type_contact() {
    $labels = array(
        'name' => __( 'お問い合わせ', 'dg-style' ),
        'singular_name' => __( 'お問い合わせ', 'dg-style' ),
        'menu_name' => __( 'お問い合わせ', 'dg-style' ),
        'name_admin_bar' => __( 'お問い合わせ', 'dg-style' ),
        'add_new' => __( '新規追加', 'dg-style' ),
        'add_new_item' => __( 'お問い合わせフォーム追加', 'dg-style' ),
        'new_item' => __( '新しいお問い合わせフォーム', 'dg-style' ),
        'edit_item' => __( 'お問い合わせフォーム修正', 'dg-style' ),
        'view_item' => __( 'お問い合わせフォーム表示', 'dg-style' ),
        'all_items' => __( 'お問い合わせ一覧', 'dg-style' ),
        'search_items' => __( '検索', 'dg-style' ),
        'not_found' => __( 'お問い合わせフォームが見つかりません。', 'dg-style' ),
        'not_found_in_trash' => __( 'ゴミ箱にお問い合わせフォームが見つかりません。', 'dg-style' )
    );
    $args = array(
        'labels' => $labels,
        'menu_icon' => 'dashicons-email-alt',
        'public' => false,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_rest' => true,
        'query_var' => false,
        'rewrite' => false,
        'capability_type' => 'page',
        'capabilities' => array(
            'edit_post' => 'edit_others_posts',
            'read_post' => 'edit_others_posts',
            'delete_post' => 'edit_others_posts',
            'edit_posts' => 'edit_others_posts',
            'edit_others_posts' => 'edit_others_posts',
            'publish_posts' => 'edit_others_posts',
            'read_private_posts' => 'edit_others_posts',
        ),
        'hierarchical' => false,
        'menu_position' => null,
        'supports' => array( 'title', 'author' )
    );
    register_post_type( 'dg_contact', $args );
}
/*
 * フォームコンテンツ
*/
add_action( 'edit_form_after_title', 'dg_style_contact_form_editor' );
function dg_style_contact_form_editor() {
    global $post;
    if ( $post->post_type !== 'dg_contact' ) {
        return false;
    }
    $content = $post->post_content;
    $content_value = htmlspecialchars( $post->post_content );
    $layout = dg_contact_form_layout( $content );
    //オプション
    $option = dg_contact_option_moving_area();
    $option .= dg_contact_option_area();
    $option .= dg_contact_option_label();
    $option .= dg_contact_option_input();
    $option .= dg_contact_option_textarea();
    $option .= dg_contact_option_check();
    $option .= dg_contact_option_radio();
    $option .= dg_contact_option_select();
    $option .= dg_contact_option_submit();
    $option .= dg_contact_option_reset();
    $option .= dg_contact_option_file();
    $option .= dg_contact_option_text();
    //メール
    $mail_format = get_post_meta( $post->ID, 'dg_mail', true );
    if ( $mail_format !== '' ) {
        $mail_format = json_decode( $mail_format, true );
        $mail_format = wp_unslash( $mail_format );
    } else {
        $mail_format = array();
    }
    $mail_option = dg_contact_mail_content_option( $mail_format );
    $message_option = dg_contact_message( $mail_format );
    //翻訳
    $label1 = __( 'フォームレイアウト', 'dg-style' );
    $label2 = __( 'メール文', 'dg-style' );
    $label3 = __( 'お知らせメッセージ', 'dg-style' );
    $text_clipboard = __( 'クリップボードにコピーしました。', 'dg-style' );
    echo <<< EOM
        <div id="contact-main-area" class="main-tab-area">
            <div class="main-tab-labels">
                <button type="button" class="main-label tab-label on">{$label1}</button>
                <button type="button" class="main-label tab-label">{$label2}</button>
                <button type="button" class="main-label tab-label">{$label3}</button>
            </div>
            <div class="main-tab-contents">
                <div class="main-tab-inner on">{$layout}</div>
                <div class="main-tab-inner">{$mail_option}</div>
                <div class="main-tab-inner">{$message_option}</div>
            </div>
        </div>
        <input type="text" id="contact-content" name="content" class="display-none" value="{$content_value}">
        <div id="contact-option-menus" class="display-none">{$option}</div>
        <div id="clipboard-copy-message">{$text_clipboard}</div>
EOM;
}

/*
 * お問い合わせフォームレイアウト
*/
function dg_contact_form_layout( $content ) {
    //翻訳
    $btn1 = __( 'エリア追加', 'dg-style' );
    $btn2 = __( 'ラベル追加', 'dg-style' );
    $btn3 = __( '入力フィールド', 'dg-style' );
    $btn4 = __( 'チェックボックス', 'dg-style' );
    $btn5 = __( 'ラジオボタン', 'dg-style' );
    $btn6 = __( 'セレクター', 'dg-style' );
    $btn7 = __( '送信ボタン', 'dg-style' );
    $btn8 = __( 'リセットボタン', 'dg-style' );
    $btn9 = __( 'テキスト', 'dg-style' );
    $btn10 = __( 'テキストエリア', 'dg-style' );
    return <<< EOM
        <div id="builder-menus" class="builder-menus-area">
            <button type="button" class="layout-menu-btn" value="area">{$btn1}</button>
            <button type="button" class="layout-menu-btn" value="label">{$btn2}</button>
            <button type="button" class="layout-menu-btn" value="input">{$btn3}</button>
            <button type="button" class="layout-menu-btn" value="textarea">{$btn10}</button>
            <button type="button" class="layout-menu-btn" value="check">{$btn4}</button>
            <button type="button" class="layout-menu-btn" value="radio">{$btn5}</button>
            <button type="button" class="layout-menu-btn" value="select">{$btn6}</button>
            <button type="button" class="layout-menu-btn" value="submit">{$btn7}</button>
            <button type="button" class="layout-menu-btn" value="reset">{$btn8}</button>
            <button type="button" class="layout-menu-btn" value="text">{$btn9}</button>
        </div>
        <div id="contact-builder" class="contact-builder-area">{$content}</div>
EOM;
}

function dg_contact_common_html( $type, $label, $content ) {
    return <<< EOM
        <div id="contact-menu-{$type}" class="option-window" data-type="{$type}">
            <div class="window-header">
                <div class="window-name">{$label}</div>
                <div class="window-info header-btn"></div>
                <div class="window-close header-btn"></div>
            </div>
            <div class="window-content">{$content}</div>
        </div>
EOM;
}

/*
 * エリア移動
*/
function dg_contact_option_moving_area() {
    $label = __( '移動先エリア選択', 'dg-style' );
    $text_current_area_list = __( '現在のエリアリスト', 'dg-style' );
    $text_page_all = __( '全体', 'dg-style' );
    $content = <<< EOM
        <div class="window-title">{$text_current_area_list}</div>
        <ul id="moving-area-list" class="select-area-list">
            <li class="area-list-item" data-area="page">
                <div class="area-item select moving-area-item">{$text_page_all}</div>
            </li>
        </ul>
EOM;
    return dg_contact_common_html( 'moving', $label, $content );
}

/*
 * エリア
*/
function dg_contact_option_area() {
    $label = __( 'エリア', 'dg-style' );
    $content = <<< EOM
        <div class="window-title">Class追加</div>
        <input type="text" class="set-value contact-value" data-level="class">
EOM;
    return dg_contact_common_html( 'area', $label, $content );
}

/*
 * ラベル
*/
function dg_contact_option_label() {
    $label = __( 'ラベル', 'dg-style' );
    $title1 = __( 'ラベル名', 'dg-style' );
    $title2 = __( '入力フィールド指定', 'dg-style' );
    $title_class = __( 'Class追加', 'dg-style' );
    $title_label = __( 'パーツ名（区別名）', 'dg-style' );
    $caution1 = __( '入力フィールドを選択して反映されます。', 'dg-style' );
    $caution2 = __( '入力フィールドを指定するとラベルをクリックした場合、該当フィールドを活性させます。', 'dg-style' );
    $content = <<< EOM
        <div class="window-title">{$title_label}</div>
        <input type="text" class="set-value contact-value" data-level="label">
        <div class="window-title">{$title1}</div>
        <input type="text" class="set-value contact-value" data-level="title">
        <div class="window-title">{$title2}</div>
        <input type="text" class="set-value contact-value contact-for-value" data-level="for">
        <p class="caution">※{$caution1}</p>
        <p class="caution">※{$caution2}</p>
        <div class="window-title">{$title_class}</div>
        <input type="text" class="set-value contact-value" data-level="class">
EOM;
    return dg_contact_common_html( 'label', $label, $content );
}

/*
 * input
*/
function dg_contact_option_input() {
    $label = __( '入力フィールド', 'dg-style' );
    $title1 = __( '例文設定', 'dg-style' );
    $title2 = __( 'タイプ選択', 'dg-style' );
    $title_class = __( 'Class追加', 'dg-style' );
    $title3 = __( 'デフォルト値', 'dg-style' );
    $title_name = __( 'name属性', 'dg-style' );
    $title_label = __( 'パーツ名（区別名）', 'dg-style' );
    $type_select = '';
    $types = array( 'text' => __( 'テキスト', 'dg-style' ), 'tel' => __( '電話', 'dg-style' ), 'url' => 'URL', 'email' => __( 'メール', 'dg-style' ), 'password' => __( 'パスワード', 'dg-style' ), 'datetime-local' => __( '日時', 'dg-style' ), 'date' => __( '日付', 'dg-style' ), 'month' => __( '月', 'dg-style' ), 'week' => __( '週', 'dg-style' ), 'time' => __( '時間', 'dg-style' ), 'number' => __( '数字', 'dg-style' ), 'color' => __( '色', 'dg-style' ), );
    foreach( (array)$types as $key => $name ) {
        $type_select .= '<option value="' . $key . '">' . $name . '</option>';
    }
    $type_select = '<select class="set-value contact-value" data-level="type">' . $type_select . '</select>';
    $title_required = __( '必須項目指定', 'dg-style' );
    $title_required_check = __( '必須項目指定', 'dg-style' );
    $content = <<< EOM
        <div class="window-title">{$title_label}</div>
        <input type="text" class="set-value contact-value" data-level="label">
        <div class="window-title">{$title1}（Placeholder）</div>
        <input type="text" class="set-value contact-value" data-level="placeholder">
        <div class="window-title">{$title2}</div>
        {$type_select}
        <div class="window-title">{$title3}</div>
        <input type="text" class="set-value contact-value" data-level="default">
        <div class="window-title">{$title_name}</div>
        <input type="text" class="set-value contact-value" data-level="name">
        <div class="window-title">{$title_required}</div>
        <label class="check-toggle-label">
            <input type="checkbox" class="set-value contact-value" value="1" data-level="required">
            <span class="check-name">{$title_required_check}</span><span class="check-button"></span>
        </label>
        <div class="window-title">{$title_class}</div>
        <input type="text" class="set-value contact-value" data-level="class">
EOM;
    return dg_contact_common_html( 'input', $label, $content );
}

/*
 * ラベル
*/
function dg_contact_option_textarea() {
    $label = __( 'テキストエリア', 'dg-style' );
    $title1 = __( '例文設定', 'dg-style' );
    $title2 = __( '高さ', 'dg-style' );
    $title_name = __( 'name属性', 'dg-style' );
    $title_class = __( 'Class追加', 'dg-style' );
    $title_required = __( '必須項目指定', 'dg-style' );
    $title_required_check = __( '必須項目指定', 'dg-style' );
    $title_label = __( 'パーツ名（区別名）', 'dg-style' );
    $content = <<< EOM
        <div class="window-title">{$title_label}</div>
        <input type="text" class="set-value contact-value" data-level="label">
        <div class="window-title">{$title1}（Placeholder）</div>
        <input type="text" class="set-value contact-value" data-level="placeholder">
        <div class="window-title">{$title2}（rows）</div>
        <input type="number" class="set-value contact-value" data-level="rows">
        <div class="window-title">{$title_name}</div>
        <input type="text" class="set-value contact-value" data-level="name">
        <div class="window-title">{$title_required}</div>
        <label class="check-toggle-label">
            <input type="checkbox" class="set-value contact-value" value="1" data-level="required">
            <span class="check-name">{$title_required_check}</span><span class="check-button"></span>
        </label>
        <div class="window-title">{$title_class}</div>
        <input type="text" class="set-value contact-value" data-level="class">
EOM;
    return dg_contact_common_html( 'textarea', $label, $content );
}

/*
 * check
*/
function dg_contact_option_check() {
    $label = __( 'チェックボックス', 'dg-style' );
    $title1 = __( '説明テキスト', 'dg-style' );
    $title_required = __( '必須項目指定', 'dg-style' );
    $title_required_check = __( '必須項目指定', 'dg-style' );
    $title_name = __( 'name属性', 'dg-style' );
    $title_label = __( 'パーツ名（区別名）', 'dg-style' );
    $title_class = __( 'Class追加', 'dg-style' );
    $content = <<< EOM
        <div class="window-title">{$title_label}</div>
        <input type="text" class="set-value contact-value" data-level="label">
        <div class="window-title">{$title1}</div>
        <textarea class="set-value contact-value" data-level="title"></textarea>
        <div class="window-title">{$title_required}</div>
        <label class="check-toggle-label">
            <input type="checkbox" class="set-value contact-value" value="1" data-level="required">
            <span class="check-name">{$title_required_check}</span><span class="check-button"></span>
        </label>
        <div class="window-title">{$title_name}</div>
        <input type="text" class="set-value contact-value" data-level="name">
        <div class="window-title">{$title_class}</div>
        <input type="text" class="set-value contact-value" data-level="class">
EOM;
    return dg_contact_common_html( 'check', $label, $content );
}

/*
 * radio
*/
function dg_contact_option_radio() {
    $label = __( 'ラジオボタン', 'dg-style' );
    $title1 = __( 'ボタン追加', 'dg-style' );
    $title_required = __( '必須項目指定', 'dg-style' );
    $title_required_check = __( '必須項目指定', 'dg-style' );
    $title_name = __( 'name属性', 'dg-style' );
    $title_class = __( 'Class追加', 'dg-style' );
    $title_label = __( 'パーツ名（区別名）', 'dg-style' );
    $content = <<< EOM
        <div class="window-title">{$title_label}</div>
        <input type="text" class="set-value contact-value" data-level="label">
        <div class="window-title">{$title1}</div>
        <div class="add-boxs">
            <div class="box-item">
                <input type="text" class="add-box-input" placeholder="value" data-level="value">：<input type="text" class="add-box-input" placeholder="label" data-level="label">
                <button type="button" class="add-box-btn add"></button>
                <button type="button" class="add-box-btn del"></button>
            </div>
        </div>
        <div class="window-title">{$title_required}</div>
        <label class="check-toggle-label">
            <input type="checkbox" class="set-value contact-value" value="1" data-level="required">
            <span class="check-name">{$title_required_check}</span><span class="check-button"></span>
        </label>
        <div class="window-title">{$title_name}</div>
        <input type="text" class="set-value contact-value" data-level="name">
        <div class="window-title">{$title_class}</div>
        <input type="text" class="set-value contact-value" data-level="class">
EOM;
    return dg_contact_common_html( 'radio', $label, $content );
}

/*
 * select
*/
function dg_contact_option_select() {
    $label = __( 'セレクター', 'dg-style' );
    $title1 = __( 'オプション追加', 'dg-style' );
    $title_required = __( '必須項目指定', 'dg-style' );
    $title_required_check = __( '必須項目指定', 'dg-style' );
    $title_name = __( 'name属性', 'dg-style' );
    $title_class = __( 'Class追加', 'dg-style' );
    $title_label = __( 'パーツ名（区別名）', 'dg-style' );
    $content = <<< EOM
        <div class="window-title">{$title_label}</div>
        <input type="text" class="set-value contact-value" data-level="label">
        <div class="window-title">{$title1}</div>
        <div class="add-boxs">
            <div class="box-item">
                <input type="text" class="add-box-input" placeholder="value" data-level="value">：<input type="text" class="add-box-input" placeholder="label" data-level="label">
                <button type="button" class="add-box-btn add"></button>
                <button type="button" class="add-box-btn del"></button>
            </div>
        </div>
        <div class="window-title">{$title_required}</div>
        <label class="check-toggle-label">
            <input type="checkbox" class="set-value contact-value" value="1" data-level="required">
            <span class="check-name">{$title_required_check}</span><span class="check-button"></span>
        </label>
        <div class="window-title">{$title_name}</div>
        <input type="text" class="set-value contact-value" data-level="name">
        <div class="window-title">{$title_class}</div>
        <input type="text" class="set-value contact-value" data-level="class">
EOM;
    return dg_contact_common_html( 'select', $label, $content );
}

/*
 * submit
*/
function dg_contact_option_submit() {
    $label = __( '送信ボタン', 'dg-style' );
    $title1 = __( 'ボタン名', 'dg-style' );
    $title_class = __( 'Class追加', 'dg-style' );
    $title_label = __( 'パーツ名（区別名）', 'dg-style' );
    $content = <<< EOM
        <div class="window-title">{$title_label}</div>
        <input type="text" class="set-value contact-value" data-level="label">
        <div class="window-title">{$title1}</div>
        <input type="text" class="set-value contact-value" data-level="title">
        <div class="window-title">{$title_class}</div>
        <input type="text" class="set-value contact-value" data-level="class">
EOM;
    return dg_contact_common_html( 'submit', $label, $content );
}

/*
 * reset
*/
function dg_contact_option_reset() {
    $label = __( 'リセットボタン', 'dg-style' );
    $title1 = __( 'ボタン名', 'dg-style' );
    $title_class = __( 'Class追加', 'dg-style' );
    $title_label = __( 'パーツ名（区別名）', 'dg-style' );
    $content = <<< EOM
        <div class="window-title">{$title_label}</div>
        <input type="text" class="set-value contact-value" data-level="label">
        <div class="window-title">{$title1}</div>
        <input type="text" class="set-value contact-value" data-level="title">
        <div class="window-title">{$title_class}</div>
        <input type="text" class="set-value contact-value" data-level="class">
EOM;
    return dg_contact_common_html( 'reset', $label, $content );
}

/*
 * file
*/
function dg_contact_option_file() {
    $label = __( 'ファイル', 'dg-style' );
    $content = <<< EOM
        
EOM;
    return dg_contact_common_html( 'file', $label, $content );
}

/*
 * text
*/
function dg_contact_option_text() {
    $label = __( 'テキスト', 'dg-style' );
    $title1 = __( 'テキスト', 'dg-style' );
    $title_class = __( 'Class追加', 'dg-style' );
    $title_label = __( 'パーツ名（区別名）', 'dg-style' );
    $content = <<< EOM
        <div class="window-title">{$title_label}</div>
        <input type="text" class="set-value contact-value" data-level="label">
        <div class="window-title">{$title1}</div>
        <input type="text" class="set-value contact-value" data-level="title">
        <div class="window-title">{$title_class}</div>
        <input type="text" class="set-value contact-value" data-level="class">
EOM;
    return dg_contact_common_html( 'text', $label, $content );
}

/*
 * メール文
*/
function dg_contact_mail_content_option( $mail_format ) {
    $dg_mail_from1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_from1' ] ) ? htmlspecialchars( $mail_format[ 'mail1' ][ 'dg_mail_from1' ] ) : '';
    $dg_mail_to1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_to1' ] ) ? htmlspecialchars( $mail_format[ 'mail1' ][ 'dg_mail_to1' ] ) : '';
    $dg_mail_cc1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_cc1' ] ) ? htmlspecialchars( $mail_format[ 'mail1' ][ 'dg_mail_cc1' ] ) : '';
    $dg_mail_bcc1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_bcc1' ] ) ? htmlspecialchars( $mail_format[ 'mail1' ][ 'dg_mail_bcc1' ] ) : '';
    $dg_mail_reply1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_reply1' ] ) ? htmlspecialchars( $mail_format[ 'mail1' ][ 'dg_mail_reply1' ] ) : '';
    $dg_mail_subject1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_subject1' ] ) ? htmlspecialchars( $mail_format[ 'mail1' ][ 'dg_mail_subject1' ] ) : '';
    $dg_mail_content1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_content1' ] ) ? htmlspecialchars( $mail_format[ 'mail1' ][ 'dg_mail_content1' ] ) : '';
    $dg_mail_html1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_html1' ] ) && $mail_format[ 'mail1' ][ 'dg_mail_html1' ] === '1' ? ' checked' : '';
    $dg_mail_atta1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_atta1' ] ) ? $mail_format[ 'mail1' ][ 'dg_mail_atta1' ] : '';
    $dg_mail_from2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_from2' ] ) ? htmlspecialchars( $mail_format[ 'mail2' ][ 'dg_mail_from2' ] ) : '';
    $dg_mail_to2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_to2' ] ) ? htmlspecialchars( $mail_format[ 'mail2' ][ 'dg_mail_to2' ] ) : '';
    $dg_mail_cc2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_cc2' ] ) ? htmlspecialchars( $mail_format[ 'mail2' ][ 'dg_mail_cc2' ] ) : '';
    $dg_mail_bcc2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_bcc2' ] ) ? htmlspecialchars( $mail_format[ 'mail2' ][ 'dg_mail_bcc2' ] ) : '';
    $dg_mail_reply2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_reply2' ] ) ? htmlspecialchars( $mail_format[ 'mail2' ][ 'dg_mail_reply2' ] ) : '';
    $dg_mail_subject2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_subject2' ] ) ? htmlspecialchars( $mail_format[ 'mail2' ][ 'dg_mail_subject2' ] ) : '';
    $dg_mail_content2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_content2' ] ) ? htmlspecialchars( $mail_format[ 'mail2' ][ 'dg_mail_content2' ] ) : '';
    $dg_mail_html2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_html2' ] ) && $mail_format[ 'mail2' ][ 'dg_mail_html2' ] === '1' ? ' checked' : '';
    $dg_mail_atta2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_atta2' ] ) ? $mail_format[ 'mail2' ][ 'dg_mail_atta2' ] : '';
    $mail2use = isset( $mail_format[ 'mail2use' ] ) && $mail_format[ 'mail2use' ] === true ? ' checked' : '';
    //添付ファイル
    $atta_items1 = '';
    $atta_items2 = '';
    if ( $dg_mail_atta1 !== '' ) {
        $atta1_arr = explode( ',', $dg_mail_atta1 );
        foreach( (array)$atta1_arr as $atta_id ) {
            $atta = get_post( $atta_id );
            $path = wp_get_attachment_url( $atta->ID );
            if ( preg_match( '/^image/', $atta->post_mime_type ) ) {
                $atta_items1 .= '<div class="atta-item"><img src="' . $path . '"><span class="atta-name">' . $atta->post_title . '</span><button type="button" class="delete-atta-btn" value="' . $atta->ID . '" data-level="1"></button></div>';
            } elseif ( preg_match( '/^video/', $atta->post_mime_type ) ) {
                $atta_items1 .= '<div class="atta-item"><video controls=""><source src="' . $path . '"></video><span class="atta-name">' . $atta->post_title . '</span><button type="button" class="delete-atta-btn" value="' . $atta->ID . '" data-level="1"></button></div>';
            } elseif ( preg_match( '/^audio/', $atta->post_mime_type ) ) {
                $atta_items1 .= '<div class="atta-item"><audio controls=""><source src="' . $path . '"></audio><span class="atta-name">' . $atta->post_title . '</span><button type="button" class="delete-atta-btn" value="' . $atta->ID . '" data-level="1"></button></div>';
            } else {
                preg_match( '/[^\.][a-zA-Z0-9]+$/s', $path, $match );
                $atta_items1 .= '<div class="atta-item"><div class="atta-icon"></div><span class="atta-name">' . $atta->post_title . '(' . $match[ 0 ] . ')</span><button type="button" class="delete-atta-btn" value="' . $atta->ID . '" data-level="1"></button></div>';
            }
        }
    }
    if ( $dg_mail_atta2 !== '' ) {
        $atta1_arr2 = explode( ',', $dg_mail_atta2 );
        foreach( (array)$atta1_arr2 as $atta_id ) {
            $atta = get_post( $atta_id );
            $path = wp_get_attachment_url( $atta->ID );
            if ( preg_match( '/^image/', $atta->post_mime_type ) ) {
                $atta_items2 .= '<div class="atta-item"><img src="' . $path . '"><span class="atta-name">' . $atta->post_title . '</span><button type="button" class="delete-atta-btn" value="' . $atta->ID . '" data-level="2"></button></div>';
            } elseif ( preg_match( '/^video/', $atta->post_mime_type ) ) {
                $atta_items2 .= '<div class="atta-item"><video controls=""><source src="' . $path . '"></video><span class="atta-name">' . $atta->post_title . '</span><button type="button" class="delete-atta-btn" value="' . $atta->ID . '" data-level="2"></button></div>';
            } elseif ( preg_match( '/^audio/', $atta->post_mime_type ) ) {
                $atta_items2 .= '<div class="atta-item"><audio controls=""><source src="' . $path . '"></audio><span class="atta-name">' . $atta->post_title . '</span><button type="button" class="delete-atta-btn" value="' . $atta->ID . '" data-level="2"></button></div>';
            } else {
                preg_match( '/[^\.][a-zA-Z0-9]+$/s', $path, $match );
                $atta_items2 .= '<div class="atta-item"><div class="atta-icon"></div><span class="atta-name">' . $atta->post_title . '(' . $match[ 0 ] . ')</span><button type="button" class="delete-atta-btn" value="' . $atta->ID . '" data-level="2"></button></div>';
            }
        }
    }
    $common_title = __( 'メール文作成', 'dg-style' );
    $read_text = __( 'お問い合わせが送信された時にお知らせメールを送ることができます。', 'dg-style' );
    $sub_title = __( 'メールタグリスト', 'dg-style' );
    $sub_title1 = __( 'メール', 'dg-style' );
    $sub_title_check = __( 'メール2を使用する', 'dg-style' );
    $mail_tag_caution = __( 'タグを選択し、コピーしたタグの貼り付けることで、入力された内容をメールに反映することができます。', 'dg-style' );
    $mail_tag_title1 = __( '共通メールタグ', 'dg-style' );
    $mail_tag_title2 = __( '入力フィールドタグ', 'dg-style' );
    $th1 = __( '差出人', 'dg-style' );
    $th2 = __( '宛先', 'dg-style' );
    $th3 = __( '返信先', 'dg-style' );
    $th4 = __( '件名', 'dg-style' );
    $th5 = __( '本文', 'dg-style' );
    $th6 = __( '添付ファイル', 'dg-style' );
    $th7 = __( 'HTMLメールを使う', 'dg-style' );
    $atta_btn = __( '添付ファイル追加', 'dg-style' );
    $common_tag1 = __( 'サイトタイトル', 'dg-style' );
    $common_tag2 = __( '管理者用メールアドレス', 'dg-style' );
    $common_tag3 = __( 'サイトURL', 'dg-style' );
    $common_tag4 = __( 'ユーザーIP', 'dg-style' );
    $common_tag5 = __( 'ユーザーエージェント', 'dg-style' );
    $common_tag6 = __( '日時', 'dg-style' );
    $common_tag7 = __( '記事ID', 'dg-style' );
    $common_tag8 = __( '記事URL', 'dg-style' );
    $common_tag9 = __( '記事作成者ID', 'dg-style' );
    $common_tag10 = __( '記事作成者名', 'dg-style' );
    $common_tag11 = __( '記事作成者メールアドレス', 'dg-style' );
    $common_tag12 = __( 'ログインユーザーID', 'dg-style' );
    $common_tag13 = __( 'ログインユーザー名', 'dg-style' );
    $common_tag14 = __( 'ログインユーザーメールアドレス', 'dg-style' );
    return <<< EOM
        <div id="contact-mail-option">
            <div class="contact-common-title">{$common_title}</div>
            <p class="">{$read_text}</p>
            <div class="common-sub-title">{$sub_title}</div>
            <p class="caution">※{$mail_tag_caution}</p>
            <div id="common-mail-tag" class="mail-tag-list" title="{$mail_tag_title1}">
                <button type="button" class="mail-item-btn" value="[DGSITETITLE]">{$common_tag1}</button>
                <button type="button" class="mail-item-btn" value="[DGADMINMAIL]">{$common_tag2}</button>
                <button type="button" class="mail-item-btn" value="[DGSITEURL]">{$common_tag3}</button>
                <button type="button" class="mail-item-btn" value="[DGUSERIP]">{$common_tag4}</button>
                <button type="button" class="mail-item-btn" value="[DGUSERAGENT]">{$common_tag5}</button>
                <button type="button" class="mail-item-btn" value="[DGDATE]">{$common_tag6}</button>
                <button type="button" class="mail-item-btn" value="[DGPOSTID]">{$common_tag7}</button>
                <button type="button" class="mail-item-btn" value="[DGPOSTURL]">{$common_tag8}</button>
                <button type="button" class="mail-item-btn" value="[DGPOSTAUTHORID]">{$common_tag9}</button>
                <button type="button" class="mail-item-btn" value="[DGPOSTAUTHOR]">{$common_tag10}</button>
                <button type="button" class="mail-item-btn" value="[DGPOSTAUTHORMAIL]">{$common_tag11}</button>
                <button type="button" class="mail-item-btn" value="[DGLOGINID]">{$common_tag12}</button>
                <button type="button" class="mail-item-btn" value="[DGLOGINNAME]">{$common_tag13}</button>
                <button type="button" class="mail-item-btn" value="[DGLOGINMAIL]">{$common_tag14}</button>
            </div>
            <div id="mail-field-names" class="mail-tag-list" title="{$mail_tag_title2}"></div>
            <div class="common-sub-title">{$sub_title1}1</div>
            <table id="dg-mail-table1" class="mail-table">
                <tbody>
                    <tr>
                        <th>{$th1}</th>
                        <td><input type="text" name="dg_mail_from1" class="mail-input mail-set-value" value="{$dg_mail_from1}" placeholder="Name <test@test.com>,Name2 <test2@test.com>"></td>
                    </tr>
                    <tr>
                        <th>{$th2}</th>
                        <td><input type="text" name="dg_mail_to1" class="mail-input mail-set-value" value="{$dg_mail_to1}" placeholder="Name <test@test.com>,Name2 <test2@test.com>"></td>
                    </tr>
                    <tr>
                        <th>CC</th>
                        <td><input type="text" name="dg_mail_cc1" class="mail-input mail-set-value" value="{$dg_mail_cc1}" placeholder="Name <test@test.com>,Name2 <test2@test.com>"></td>
                    </tr>
                    <tr>
                        <th>BCC</th>
                        <td><input type="text" name="dg_mail_bcc1" class="mail-input mail-set-value" value="{$dg_mail_bcc1}" placeholder="Name <test@test.com>,Name2 <test2@test.com>"></td>
                    </tr>
                    <tr>
                        <th>{$th3}</th>
                        <td><input type="text" name="dg_mail_reply1" class="mail-input mail-set-value" value="{$dg_mail_reply1}" placeholder="Name <test@test.com>,Name2 <test2@test.com>"></td>
                    </tr>
                    <tr>
                        <th>{$th4}</th>
                        <td><input type="text" name="dg_mail_subject1" class="mail-input mail-set-value" value="{$dg_mail_subject1}"></td>
                    </tr>
                    <tr>
                        <th>{$th5}</th>
                        <td>
                            <textarea name="dg_mail_content1" class="mail-input mail-set-value" rows="10">{$dg_mail_content1}</textarea>
                            <label class="html-mail-label"><input type="checkbox" name="dg_mail_html1" value="1"{$dg_mail_html1}>{$th7}</label>
                        </td>
                    </tr>
                    <tr>
                        <th>{$th6}</th>
                        <td>
                            <div id="dg-mail-atta1-box" class="atta-list">{$atta_items1}</div>
                            <button type="button" class="add-atta-btn" value="1">{$atta_btn}</button>
                            <input type="text" name="dg_mail_atta1" id="dg-mail-atta1-input" class="display-none" value="{$dg_mail_atta1}">
                        </td>
                    </tr>
                </tbody>
            </table>
            <label class="mail2-checkbox"><input type="checkbox" name="user-mail2" value="1"{$mail2use}>{$sub_title_check}</label>
            <div class="common-sub-title">{$sub_title1}2</div>
            <table id="dg-mail-table1" class="mail-table">
                <tbody>
                    <tr>
                        <th>{$th1}</th>
                        <td><input type="text" name="dg_mail_from2" class="mail-input mail-set-value" value="{$dg_mail_from2}" placeholder="Name <test@test.com>,Name2 <test2@test.com>"></td>
                    </tr>
                    <tr>
                        <th>{$th2}</th>
                        <td><input type="text" name="dg_mail_to2" class="mail-input mail-set-value" value="{$dg_mail_to2}" placeholder="Name <test@test.com>,Name2 <test2@test.com>"></td>
                    </tr>
                    <tr>
                        <th>CC</th>
                        <td><input type="text" name="dg_mail_cc2" class="mail-input mail-set-value" value="{$dg_mail_cc2}" placeholder="Name <test@test.com>,Name2 <test2@test.com>"></td>
                    </tr>
                    <tr>
                        <th>BCC</th>
                        <td><input type="text" name="dg_mail_bcc2" class="mail-input mail-set-value" value="{$dg_mail_bcc2}" placeholder="Name <test@test.com>,Name2 <test2@test.com>"></td>
                    </tr>
                    <tr>
                        <th>{$th3}</th>
                        <td><input type="text" name="dg_mail_reply2" class="mail-input mail-set-value" value="{$dg_mail_reply2}" placeholder="Name <test@test.com>,Name2 <test2@test.com>"></td>
                    </tr>
                    <tr>
                        <th>{$th4}</th>
                        <td><input type="text" name="dg_mail_subject2" class="mail-input mail-set-value" value="{$dg_mail_subject2}"></td>
                    </tr>
                    <tr>
                        <th>{$th5}</th>
                        <td>
                            <textarea name="dg_mail_content2" class="mail-input mail-set-value" rows="10">{$dg_mail_content2}</textarea>
                            <label class="html-mail-label"><input type="checkbox" name="dg_mail_html2" value="1"{$dg_mail_html2}>{$th7}</label>
                        </td>
                    </tr>
                    <tr>
                        <th>{$th6}</th>
                        <td>
                            <div id="dg-mail-atta2-box" class="atta-list">{$atta_items2}</div>
                            <button type="button" class="add-atta-btn" value="2">{$atta_btn}</button>
                            <input type="text" name="dg_mail_atta2" id="dg-mail-atta2-input" class="display-none" value="{$dg_mail_atta2}">
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
EOM;
}

/*
 * メッセージ
*/
function dg_contact_message( $mail_format ) {
    $message_keys = array(
        'submit' => array(
            'label' => __( '送信成功した場合', 'dg-style' ),
            'default' => __( '送信できました。ご利用ありがとうございます。', 'dg-style' ),
        ),
        'fail' => array(
            'label' => __( '送信失敗した場合', 'dg-style' ),
            'default' => __( '送信できませんでした。時間を置いて再度試してください。', 'dg-style' ),
        ),
    );
    $message_items = '';
    foreach( (array)$message_keys as $key => $name ) {
        $value = isset( $mail_format[ 'message' ][ $key ] ) ? $mail_format[ 'message' ][ $key ] : $name[ 'default' ];
        $message_items .= <<< EOM
            <div class="message-item">
                <label class="message-label" for="dg-message-{$key}">{$name[ 'label' ]}</label>
                <input type="text" id="dg-message-{$key}" name="message-{$key}" class="message-input" value="{$value}">
            </div>
EOM;
    }
    $common_title = __( 'お知らせメッセージ', 'dg-style' );
    $common_description = __( 'お問い合わせフォーム関連のメッセージを編集できます。', 'dg-style' );
    return <<< EOM
        <div id="contact-message-option">
            <div class="contact-common-title">{$common_title}</div>
            <p>{$common_description}</p>
            <div class="message-area">{$message_items}</div>
        </div>
EOM;
}

/*
 * お問い合わせフォーム保存
*/
add_action( 'save_post', 'save_dg_style_contact_values', 13, 3 );
function save_dg_style_contact_values( $post_id, $post ){
    //リビジョンの場合実際の記事IDを取得
    if ( $parent_id = wp_is_post_revision( $post_id ) ) {
        $post_id = $parent_id;
    }
    $post_type = get_post_type( $post_id );
    //自動保存防止
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return $post_id;
    }
    //クィック編集防止
    if ( defined( 'DOING_AJAX' ) ) {
        return $post_id;
    }
    //権限確認
    if ( $post_type !== 'dg_contact' ) {
        return $post_id;
    } elseif ( !current_user_can( 'edit_post', $post_id ) ) {
        return $post_id;
    }
    $result = array();
    $keys1 = array( 'dg_mail_from1', 'dg_mail_to1', 'dg_mail_cc1', 'dg_mail_bcc1', 'dg_mail_reply1', 'dg_mail_subject1', 'dg_mail_content1', 'dg_mail_atta1', 'dg_mail_html1' );
    $keys2 = array( 'dg_mail_from2', 'dg_mail_to2', 'dg_mail_cc2', 'dg_mail_bcc2', 'dg_mail_reply2', 'dg_mail_subject2', 'dg_mail_content2', 'dg_mail_atta2', 'dg_mail_html2' );
    foreach( (array)$keys1 as $key ) {
        if ( isset( $_POST[ $key ] ) ) {
            $result[ 'mail1' ][ $key ] = $_POST[ $key ];
        }
    }
    foreach( (array)$keys2 as $key ) {
        if ( isset( $_POST[ $key ] ) ) {
            $result[ 'mail2' ][ $key ] = $_POST[ $key ];
        }
    }
    $result[ 'mail2use' ] = isset( $_POST[ 'user-mail2' ] ) && $_POST[ 'user-mail2' ] === '1' ? true : false;
    
    //メッセージ
    $message_keys = array( 'submit', 'fail', );
    foreach( (array)$message_keys as $key ) {
        if ( isset( $_POST[ 'message-' . $key ] ) ) {
            $result[ 'message' ][ $key ] = $_POST[ 'message-' . $key ];
        }
    }
    $dg_mail = wp_slash( json_encode( $result ) );
    update_post_meta( $post_id, 'dg_mail', $dg_mail );
}

/*
 * メールフォーム送信
*/
add_action( 'wp_ajax_send_contact_form_mail', 'send_contact_form_mail' );
add_action( 'wp_ajax_nopriv_send_contact_form_mail', 'send_contact_form_mail' );
function send_contact_form_mail() {
    $error = false;
    $error_message = __( 'フォーム情報が正しくありません。', 'dg-style' );
    /* nonceチェック */
    $form_id = $_POST[ 'formId' ];
    $part_id = '';
    if ( isset( $_POST[ 'partId' ] ) && $_POST[ 'partId' ] !== '' ) {
        $part_id = $_POST[ 'partId' ];
    }
    $comment_nonce = $_POST[ 'dgcontactnonce' ];
    $nonce_result = wp_verify_nonce( $comment_nonce, 'dg_contact' . $form_id . $part_id );
    if ( !$nonce_result ) {
        $error = true;
        $error_message = __( 'フォーム情報が古いため、リロードしてから試してください。', 'dg-style' );
    }
    //メール文取得
    $mail_format = get_post_meta( $form_id, 'dg_mail', true );
    if ( $mail_format === '' ) {
        $error = true;
        $error_message = __( 'フォームの形式に誤りがあります。詳しくはサイト管理者までお問い合わせください。', 'dg-style' );
    }
    //reCAPTCHA
    if ( isset( $_POST[ 'dgRecaptchaKey' ] ) && $_POST[ 'dgRecaptchaKey' ] !== '' ) {
        $scripts = get_option( 'DG_script_option', false );
        if ( $scripts !== false ) {
            $scripts = json_decode( $scripts, true );
            $secret = $scripts[ 'recaptcha' ][ 'secret' ];
            $verifyResponse = file_get_contents( 'https://www.google.com/recaptcha/api/siteverify?secret=' . $secret . '&response=' . $_POST[ 'dgRecaptchaKey' ] );
            $reCAPTCHA = json_decode( $verifyResponse );
            if ( !$reCAPTCHA->success ) {
                $error = true;
                $error_message = __( '不正な方法による送信が検出されたため、送信できません。', 'dg-style' );
            }
        }
    }

    // エラー時処理
    if ( $error === true ) {
        echo json_encode( array( 'result' => 'error', 'massege' => $error_message ) );
        exit();
    }
    
    //情報取得
    $page_obj = new CreatePageInfoUrl( $_POST[ 'pageUrl' ] );
    $home_url = $page_obj->getHomeUrl();
    $page_info = $page_obj->getPageInfo();
    $page_id = '';
    $user_id = '';
    $user_name = '';
    $user_mail = '';
    if ( isset( $page_info[ 'pageClass' ] ) && $page_info[ 'pageClass' ] === 'single' ) {
        $page_id = $page_info[ 'post_id' ];
        $post = get_post( $page_id );
        $user = get_userdata( $post->post_author );
        $user_id = $user->id;
        $user_name = $user->user_nicename;
        $user_mail = $user->user_email;
    } elseif ( $page_info[ 'taxonomy' ] !== '404' && $page_info[ 'taxonomy' ] !== 'top' && $page_info[ 'taxonomy' ] !== 'search' && $page_info[ 'taxonomy' ] !== 'date' ) {
        $page_id = $page_info[ 'term_id' ];
    }
    $login_user = wp_get_current_user();
    $login_user_id = $login_user->id;
    $login_user_name = $login_user->user_nicename;
    $login_user_mail = $login_user->user_email;
    //置換用配列作成
    $replace_data = array(
        'DGSITETITLE' => get_bloginfo( 'name' ),
        'DGADMINMAIL' => get_bloginfo( 'admin_email' ),
        'DGSITEURL' => $home_url,
        'DGUSERIP' => $_SERVER[ 'REMOTE_ADDR' ],
        'DGUSERAGENT' => $_SERVER[ 'HTTP_USER_AGENT' ],
        'DGDATE' => wp_date( 'Y-m-d H:i:s' ),
        'DGPOSTID' => $page_id,
        'DGPOSTURL' => $_POST[ 'pageUrl' ],
        'DGPOSTAUTHORID' => $user_id,
        'DGPOSTAUTHOR' => $user_name,
        'DGPOSTAUTHORMAIL' => $user_mail,
        'DGLOGINID' => $login_user_id,
        'DGLOGINNAME' => $login_user_name,
        'DGLOGINMAIL' => $login_user_mail,
    );
    foreach( (array)$_POST as $key => $value ) {
        if ( $key !== 'dgcontactnonce' && $key !== 'formId' ) {
            $content = rawurldecode( $value );
            $content = sanitize_textarea_field( $content );
            $replace_data[ $key ] = $content;
        }
    }
    // カスタムフック設定
    do_action( 'dg_contact_hook', array( 'data' => $replace_data, 'page_info' => $page_info, 'mail_format' => $mail_format ) );
    
    //メール文作成
    $mail_format = json_decode( $mail_format, true );
    $mail_format = wp_unslash( $mail_format );
    $dg_mail_from1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_from1' ] ) ? $mail_format[ 'mail1' ][ 'dg_mail_from1' ] : '';
    $dg_mail_to1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_to1' ] ) ? $mail_format[ 'mail1' ][ 'dg_mail_to1' ] : '';
    $dg_mail_cc1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_cc1' ] ) ? $mail_format[ 'mail1' ][ 'dg_mail_cc1' ] : '';
    $dg_mail_bcc1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_bcc1' ] ) ? $mail_format[ 'mail1' ][ 'dg_mail_bcc1' ] : '';
    $dg_mail_reply1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_reply1' ] ) ? $mail_format[ 'mail1' ][ 'dg_mail_reply1' ] : '';
    $dg_mail_subject1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_subject1' ] ) ? $mail_format[ 'mail1' ][ 'dg_mail_subject1' ] : '';
    $dg_mail_content1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_content1' ] ) ? $mail_format[ 'mail1' ][ 'dg_mail_content1' ] : '';
    $dg_mail_html1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_html1' ] ) ? $mail_format[ 'mail1' ][ 'dg_mail_html1' ] : '';
    $dg_mail_atta1 = isset( $mail_format[ 'mail1' ][ 'dg_mail_atta1' ] ) ? $mail_format[ 'mail1' ][ 'dg_mail_atta1' ] : '';
    
    $dg_mail_from2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_from2' ] ) ? $mail_format[ 'mail2' ][ 'dg_mail_from2' ] : '';
    $dg_mail_to2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_to2' ] ) ? $mail_format[ 'mail2' ][ 'dg_mail_to2' ] : '';
    $dg_mail_cc2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_cc2' ] ) ? $mail_format[ 'mail2' ][ 'dg_mail_cc2' ] : '';
    $dg_mail_bcc2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_bcc2' ] ) ? $mail_format[ 'mail2' ][ 'dg_mail_bcc2' ] : '';
    $dg_mail_reply2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_reply2' ] ) ? $mail_format[ 'mail2' ][ 'dg_mail_reply2' ] : '';
    $dg_mail_subject2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_subject2' ] ) ? $mail_format[ 'mail2' ][ 'dg_mail_subject2' ] : '';
    $dg_mail_content2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_content2' ] ) ? $mail_format[ 'mail2' ][ 'dg_mail_content2' ] : '';
    $dg_mail_html2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_html2' ] ) ? $mail_format[ 'mail2' ][ 'dg_mail_html2' ] : '';
    $dg_mail_atta2 = isset( $mail_format[ 'mail2' ][ 'dg_mail_atta2' ] ) ? $mail_format[ 'mail2' ][ 'dg_mail_atta2' ] : '';
    
    foreach( (array)$replace_data as $key => $value ) {
        $dg_mail_from1 = str_replace( '[' . $key . ']', $value, $dg_mail_from1 );
        $dg_mail_to1 = str_replace( '[' . $key . ']', $value, $dg_mail_to1 );
        $dg_mail_cc1 = str_replace( '[' . $key . ']', $value, $dg_mail_cc1 );
        $dg_mail_bcc1 = str_replace( '[' . $key . ']', $value, $dg_mail_bcc1 );
        $dg_mail_reply1 = str_replace( '[' . $key . ']', $value, $dg_mail_reply1 );
        $dg_mail_subject1 = str_replace( '[' . $key . ']', $value, $dg_mail_subject1 );
        $dg_mail_content1 = str_replace( '[' . $key . ']', $value, $dg_mail_content1 );
        $dg_mail_atta1 = str_replace( '[' . $key . ']', $value, $dg_mail_atta1 );
        
        if ( isset( $mail_format[ 'mail2use' ] ) && $mail_format[ 'mail2use' ] === true ) {
            $dg_mail_from2 = str_replace( '[' . $key . ']', $value, $dg_mail_from2 );
            $dg_mail_to2 = str_replace( '[' . $key . ']', $value, $dg_mail_to2 );
            $dg_mail_cc2 = str_replace( '[' . $key . ']', $value, $dg_mail_cc2 );
            $dg_mail_bcc2 = str_replace( '[' . $key . ']', $value, $dg_mail_bcc2 );
            $dg_mail_reply2 = str_replace( '[' . $key . ']', $value, $dg_mail_reply2 );
            $dg_mail_subject2 = str_replace( '[' . $key . ']', $value, $dg_mail_subject2 );
            $dg_mail_content2 = str_replace( '[' . $key . ']', $value, $dg_mail_content2 );
            $dg_mail_atta2 = str_replace( '[' . $key . ']', $value, $dg_mail_atta2 );
        }
    }
    $result_flg = array( 'result' => 'submit', 'massege' => $mail_format[ 'message' ][ 'submit' ] );
    $dg_mail_to1 = explode( ',', $dg_mail_to1 );
    $atta1 = array();
    if ( $dg_mail_atta1 !== '' ) {
        $dg_mail_atta1 = explode( ',', $dg_mail_atta1 );
        foreach( (array)$dg_mail_atta1 as $atta_id ) {
            $atta1[] = get_attached_file( $atta_id );
        }
    }
    $mail_header = array();
    if ( $dg_mail_html1 === '1' ) {
        $mail_header[] = "Content-Type: text/html; charset=UTF-8";
    }
    $mail_header[] = "From: " . $dg_mail_from1;
    $mail_header[] = "Cc:" . $dg_mail_cc1;
    $mail_header[] = "Bcc:" . $dg_mail_bcc1;
    $mail_header[] = "Reply-to:" . $dg_mail_reply1;
    $mail_result = wp_mail( $dg_mail_to1, $dg_mail_subject1, $dg_mail_content1, $mail_header, $atta1 );
    if ( !$mail_result ) {
        $result_flg = array( 'result' => 'fail', 'massege' => $mail_format[ 'message' ][ 'fail' ] );
    }
    if ( isset( $mail_format[ 'mail2use' ] ) && $mail_format[ 'mail2use' ] === true && preg_match( '/[a-zA-Z0-9\._-]+@[a-zA-Z0-9\._-]+\.[a-zA-Z0-9]+/s', $dg_mail_to2 ) ) {
        $dg_mail_to2 = explode( ',', $dg_mail_to2 );
        $atta2 = array();
        if ( $dg_mail_atta2 !== '' ) {
            $dg_mail_atta2 = explode( ',', $dg_mail_atta2 );
            foreach( (array)$dg_mail_atta2 as $atta_id ) {
                $atta2[] = get_attached_file( $atta_id );
            }
        }
        $mail_header = array();
        if ( $dg_mail_html2 === '1' ) {
            $mail_header[] = "Content-Type: text/html; charset=UTF-8";
        }
        $mail_header[] = "From: " . $dg_mail_from2;
        $mail_header[] = "Cc:" . $dg_mail_cc2;
        $mail_header[] = "Bcc:" . $dg_mail_bcc2;
        $mail_header[] = "Reply-to:" . $dg_mail_reply2;
        $mail_result = wp_mail( $dg_mail_to2, $dg_mail_subject2, $dg_mail_content2, $mail_header, $atta2 );

        if ( !$mail_result ) {
            $result_flg = array( 'result' => 'fail', 'massege' => $mail_format[ 'message' ][ 'fail' ] );
        }
    }
    echo json_encode( $result_flg );
    exit();
}