<?php
const TAX_EXCLUSION = array( 'category', 'link_category', 'nav_menu', 'post_format', 'patterns_type', 'post_tag', 'wp_theme', 'wp_template_part_area', );
const POST_TYPE_EXCLUSION = array( 'attachment', 'revision', 'nav_menu_item', 'custom_css', 'customize_changeset', 'oembed_cache', 'user_request', 'wp_block', 'wp_template', 'wp_template_part', 'wp_global_styles', 'wp_navigation', );
/*-------------------------------
管理画面全体共通
-------------------------------*/
add_action( 'admin_enqueue_scripts', 'add_original_admin_script' );
function add_original_admin_script() {
    $home_url = home_url();
    $ajax_url = admin_url( 'admin-ajax.php' );
    $site_url = site_url();
    $directory_url = get_template_directory_uri();
    $license_key = get_option( 'DG_license_key', '' );
    $license_type = get_option( 'DG_license_type', '' );
    if ( $license_key === '' && $license_type === '' ) {
        $license_key = '';
    }
    //デバイス取得
    $device_option = get_option( 'DG_device_value', '' );
    $device = array( 320 => 'sp', 560 => 'tb', 960 => 'pc' );
    if ( $device_option !== '' ) {
        $device = json_decode( $device_option, true );
    }
    $device_list = json_encode( $device );
    //アバター
    $speech_avatars = get_option( 'DG_speech_avatars', false );
    $avatars_result = false;
    if ( $speech_avatars !== false ) {
        $speech_avatars = json_decode( wp_unslash( $speech_avatars ), true );
        if ( is_array( $speech_avatars ) && count( $speech_avatars ) > 0 ) {
            $avatars_result = array();
            foreach( (array)$speech_avatars as $key => $value ) {
                $src = '';
                if ( isset( $value[ 'type' ] ) && $value[ 'type' ] === '2' ) {
                    $src = $value[ 'src' ];
                } elseif ( isset( $value[ 'imgId' ] ) && $value[ 'imgId' ] !== '' ) {
                    $thumb = post_image_src_list( $value[ 'imgId' ] );
                    if ( isset( $thumb[ 'full' ][ 'url' ] ) && $thumb[ 'full' ][ 'url' ] !== '' ) {
                        $src = $thumb[ 'full' ][ 'url' ];
                    }
                }
                if ( isset( $value[ 'name' ] ) && $value[ 'name' ] !== '' && $src !== '' ) {
                    $avatars_result[] = array(
                        'slug' => $key,
                        'src' => $src,
                        'name' => $value[ 'name' ],
                    );
                }
            }
        }
    }
    if ( $avatars_result !== false ) {
        $avatars_result = json_encode( $avatars_result );
    } else {
        $avatars_result = 'false';
    }
    //ページ言語
    $locale = get_locale();
    $scripts = get_option( 'DG_script_option' );
    if ( $scripts !== false ) {
        $scripts = json_decode( $scripts, true );
        if ( isset( $scripts[ 'font' ][ 'free' ] ) && $scripts[ 'font' ][ 'free' ] !== '' ) {
            echo $scripts[ 'font' ][ 'free' ];
        } elseif ( isset( $scripts[ 'font' ][ 'fonts' ] ) && is_array( $scripts[ 'font' ][ 'fonts' ] ) && count( $scripts[ 'font' ][ 'fonts' ] ) > 0 ) {
            $font_type = '';
            foreach( (array)$scripts[ 'font' ][ 'fonts' ] as $family => $font ) {
                if ( $font_type !== '' ) {
                    $font_type .= ',';
                }
                $font_type .= "'" . $font . "'";
            }
            echo '<script src="https://ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js"></script>';
            echo '<script>let googleFonts = [' . $font_type . ']; WebFont.load({ google: { families: googleFonts } }); </script>';
        }
    }
    //チュートリアル用カテゴリー取得
    $category_name = '';
    $args = array(
        'orderby' => 'count',
        'order' => 'DESC',
        'hide_empty' => true,
        'number' => 1,
    );
    $terms = get_terms( 'category', $args );
    if ( !empty( $terms ) && !is_wp_error( $terms ) ) {
        $category_name = $terms[ 0 ]->name;
    }
    //チュートリアル用記事取得
    $post_name = '';
    echo <<< EOM
        <script>
            /* <![CDATA[ */
            let homeUrl = "{$home_url}";
            let siteUrl = "{$site_url}";
            let loadingImg = "{$directory_url}/image/loading.gif";
            let adminAjaxUrl = "{$ajax_url}";
            let commentNonce = '';
            let directoryUrl = "{$directory_url}";
            let DGlicenseKey = '{$license_key}';
            let DGDeviceList = {$device_list};
            let dgAvatarList = {$avatars_result};
            let siteLanguage = "{$locale}";
            let errorTutorialFlg = true;
            let ajaxTutorialFlg = true;
            let tutorialPartId = '';
            let tutorialPartSlug = '';
            let tutorialCatName = '{$category_name}';
            let tutorialPostName = '{$post_name}';
            /* ]]> */
        </script>
EOM;
}

/*
 * 管理画面アイキャッチ項目追加
*/
add_theme_support( 'post-thumbnails' );

/*
 * print_r
*/
function print_pre($str){
    echo '<pre>';
    print_r($str);
    echo '</pre>';
}

/*
 * 404リダイレクト
*/
add_action( 'template_redirect', 'redirect_404page' );
function redirect_404page() {
    if ( is_attachment() ) {
        global $wp_query;
        $wp_query->set_404();
        status_header( 404 );
    }
    //feedページNOINDEX設定
    if ( is_feed() && headers_sent() === false ) {
        header( 'X-Robots-Tag: noindex, follow', true );
    }
}

/*
 * デフォルトタクソノミーは除外
*/
function default_taxonomy_exclusion( $add_taxonomy = array(), $taxonomise = null ) {
    $result = array();
    if ( $taxonomise === null ) {
        $taxonomies = get_taxonomies();
    }
    foreach ( $taxonomies as $tax ) {
        if ( !in_array( $tax, TAX_EXCLUSION, true ) ) {
            $result[ $tax ] = $tax;
        }
    }
    return array_merge( $result, $add_taxonomy );
}

/*
 * タクソノミーごとのターム取得
*/
function get_terms_for_each_taxonomies( $level = '' ) {
    $cat_output = '';
    $tag_output = '';
    $terms_output = '';
    $taxonomise = default_taxonomy_exclusion( array( 'category', 'post_tag' ) );
    $args = array(
        'orderby' => 'id',
        'hide_empty' => false,
        'parent' => 0
    );
    $text_label_before = __( '設定する', 'dg-style' );
    $text_label_after = __( '名を入力', 'dg-style' );
    $text_selected = __( '選択した', 'dg-style' );
    foreach( (array)$taxonomise as $tax ) {
        $taxonomy = get_taxonomy( $tax );
        if ( $tax === 'category' ) {
            $cat_output = <<< EOM
                <div class="window-title">{$taxonomy->label}</div>
                <div class="narrow-search-area">
                    <input type="search" class="narrow-search-post-input" data-type="{$tax}" placeholder="{$text_label_before}「{$taxonomy->label}」{$text_label_after}">
                    <div class="narrow-search-result"></div>
                    <div class="narrow-title">{$text_selected}「{$taxonomy->label}」</div>
                    <div class="narrow-selected-posts"></div>
                    <input type="hidden" class="set-value narrow-search-value" data-level="select-terms-{$tax}{$level}" data-type="{$tax}">
                </div>
EOM;
        } elseif ( $tax === 'post_tag' ) {
            $tag_output = <<< EOM
                <div class="window-title">{$taxonomy->label}</div>
                <div class="narrow-search-area">
                    <input type="search" class="narrow-search-post-input" data-type="{$tax}" placeholder="{$text_label_before}「{$taxonomy->label}」{$text_label_after}">
                    <div class="narrow-search-result"></div>
                    <div class="narrow-title">{$text_selected}「{$taxonomy->label}」</div>
                    <div class="narrow-selected-posts"></div>
                    <input type="hidden" class="set-value narrow-search-value" data-level="select-terms-{$tax}{$level}" data-type="{$tax}">
                </div>
EOM;
        } else {
            $terms_output = <<< EOM
                <div class="window-title">{$taxonomy->label}</div>
                <div class="narrow-search-area">
                    <input type="search" class="narrow-search-post-input" data-type="{$tax}" placeholder="{$text_label_before}「{$taxonomy->label}」{$text_label_after}">
                    <div class="narrow-search-result"></div>
                    <div class="narrow-title">{$text_selected}「{$taxonomy->label}」</div>
                    <div class="narrow-selected-posts"></div>
                    <input type="hidden" class="set-value narrow-search-value" data-level="select-terms-{$tax}{$level}" data-type="{$tax}">
                </div>
EOM;
        }
    }
    return <<< EOM
        <div class="terms-area">
            {$cat_output}
            {$tag_output}
            {$terms_output}
        </div>
EOM;
}

/*
 * タクソノミーごとのターム取得
 * ※UIによって復活する
*/
function get_terms_for_each_taxonomies_bk( $level = '' ) {
    $cat_output = '';
    $tag_output = '';
    $terms_output = '';
    $taxonomise = default_taxonomy_exclusion( array( 'category', 'post_tag' ) );
    $args = array(
        'orderby' => 'id',
        'hide_empty' => false,
        'parent' => 0
    );
    foreach( (array)$taxonomise as $tax ) {
        $taxonomy = get_taxonomy( $tax );
        $terms = get_terms( $tax, $args );
        if ( !empty( $terms ) && !is_wp_error( $terms ) ) {
            if ( $tax === 'category' ) {
                $cat_output .= '<div class="check-value-inner">';
                $cat_output .= '<div class="window-title">' . $taxonomy->label . '</div>';
                $cat_output .= '<ul class="parent-taxonomy-area parent-items-area select-terms-' . $tax . '" data-tax="' . $tax . '">';
                foreach ( $terms as $term ) {
                    $cat_output .= <<< EOM
                        <li class="term-item">
                            <div class="term-names">
                                <label class="term-label"><input type="checkbox" class="term-input" value="{$term->term_id}">{$term->name}</label>
                                <button type="button" class="get-child-term" data-term="{$term->term_id}"></button>
                            </div>
                        </li>
EOM;
                }
                $cat_output .= '</ul>';
                $cat_output .= '<input type="hidden" data-level="select-terms-' . $tax . $level . '" class="check-value-summary set-value select-terms-' . $tax . '">';
                $cat_output .= '</div>';
            } elseif ( $tax === 'post_tag' ) {
                $tag_output .= '<div class="check-value-inner">';
                $tag_output .= '<div class="window-title">' . $taxonomy->label . '</div>';
                $tag_output .= '<ul class="parent-taxonomy-area parent-items-area select-terms-' . $tax . '" data-tax="' . $tax . '">';
                foreach ( $terms as $term ) {
                    $tag_output .= <<< EOM
                        <li class="term-item">
                            <div class="term-names">
                                <label class="term-label"><input type="checkbox" class="term-input" value="{$term->term_id}">{$term->name}</label>
                                <button type="button" class="get-child-term" data-term="{$term->term_id}"></button>
                            </div>
                        </li>
EOM;
                }
                $tag_output .= '</ul>';
                $tag_output .= '<input type="hidden" data-level="select-terms-' . $tax . $level . '" class="check-value-summary set-value select-terms-' . $tax . '">';
                $tag_output .= '</div>';
            } else {
                $terms_output .= '<div class="check-value-inner">';
                $terms_output .= '<div class="window-title">' . $taxonomy->label . '</div>';
                $terms_output .= '<ul class="parent-taxonomy-area parent-items-area select-terms-' . $tax . '" data-tax="' . $tax . '">';
                foreach ( $terms as $term ) {
                    $terms_output .= <<< EOM
                        <li class="term-item">
                            <div class="term-names">
                                <label class="term-label"><input type="checkbox" class="term-input" value="{$term->term_id}">{$term->name}</label>
                                <button type="button" class="get-child-term" data-term="{$term->term_id}"></button>
                            </div>
                        </li>
EOM;
                }
                $terms_output .= '</ul>';
                $terms_output .= '<input type="hidden" data-level="select-terms-' . $tax . $level . '" class="check-value-summary set-value select-terms-' . $tax . '">';
                $terms_output .= '</div>';
            }
        }
    }
    return <<< EOM
        <div class="terms-area">
            {$cat_output}
            {$tag_output}
            {$terms_output}
        </div>
EOM;
}

/*
 * カスタムフィールド取得&保存
*/
add_action( 'wp_ajax_save_postmeta_list_value_ajax', 'save_postmeta_list_value_ajax' );
add_action( 'wp_ajax_nopriv_save_postmeta_list_value_ajax', 'save_postmeta_list_value_ajax' );
function save_postmeta_list_value_ajax() {
    $list = save_postmeta_list_value();
    echo json_encode( array( 'items' => $list ) );
    exit();
}
function save_postmeta_list_value() {
    global $wpdb;
    $postmeta = $wpdb->prefix . 'postmeta';
    $result = $wpdb->get_results( "SELECT meta_key FROM $postmeta WHERE 1=1 GROUP BY meta_key", ARRAY_A );
    $list = array();
    foreach( (array)$result as $key => $value ) {
        if ( !preg_match( '/^_/', $value[ 'meta_key' ] ) && $value[ 'meta_key' ] !== 'dg_meta' && $value[ 'meta_key' ] !== 'evaluate_total' && $value[ 'meta_key' ] !== 'evaluate_table' ) {
            $list[] = $value[ 'meta_key' ];
        }
    }
    update_option( 'DG_postmeta_list', implode( ',', $list ) );
    return $list;
}

/*
 * ダッシュボードメニュー追加
*/
add_action('wp_dashboard_setup', 'dg_style_dashboard_widgets');
function dg_style_dashboard_widgets() {
    wp_add_dashboard_widget( 'dg_style_dashboard_widget', __( 'DG-STYLEお知らせ', 'dg-style' ), 'dg_style_dashboard_information' );
    
    //順番変更
    global $wp_meta_boxes;
    $dg_widget = $wp_meta_boxes[ 'dashboard' ][ 'normal' ][ 'core' ][ 'dg_style_dashboard_widget' ];
    unset( $wp_meta_boxes[ 'dashboard' ][ 'normal' ][ 'core' ][ 'dg_style_dashboard_widget' ] );
    $cnt = 0;
    $new_list = array();
    foreach( (array)$wp_meta_boxes[ 'dashboard' ][ 'normal' ][ 'core' ] as $key => $value ) {
        if ( $cnt === 0 ) {
            $new_list[ 'dg_style_dashboard_widget' ] = $dg_widget;
        }
        $new_list[ $key ] = $value;
        ++$cnt;
    }
    $wp_meta_boxes[ 'dashboard' ][ 'normal' ][ 'core' ] = $new_list;
}
function dg_style_dashboard_information() {
    $text_new_post = __( '新着情報', 'dg-style' );
    $text_more_btn = __( 'もっと見る', 'dg-style' );
    echo <<< EOM
        <script>
            const getDgstyleInfomation = function( url, parm ) {
                let xhr = new XMLHttpRequest();
                xhr.open( 'POST', url );
                xhr.setRequestHeader( "content-type", "application/x-www-form-urlencoded ; charset=UTF-8" );
                xhr.send( parm );
                xhr.onreadystatechange = function() {
                    if( xhr.readyState === 4 && xhr.status === 200 && xhr.responseText !== undefined && xhr.responseText !== '' ) {
                        let value = JSON.parse( xhr.responseText );
                        if ( value.items === false ) {
                            return false;
                        }
                        let listArea = document.getElementById( 'dg-style-info-list' );
                        listArea.innerHTML = '';
                        let tags = '';
                        Object.keys( value.items ).forEach(function( key ){
                            let post = value.items[ key ];
                            tags += '<li><a href="' + post.url + '" target="_blank">' + post.title + '</a></li>';
                        });
                        listArea.innerHTML = tags;
                    }
                };
            };
            getDgstyleInfomation( 'https://dg-style.net/wp-content/dg-style-manual-json/', 'information=1' );
        </script>
        <style>
            .dg-style-info-title {
                font-size:18px;
                font-weight:bold;
            }
            #dg-style-info-list {
                padding: 15px 15px 15px 30px;
                border: 1px solid #ccc;
                list-style: disc;
            }
            #dg-style-info-list li {
                margin: 0 0 10px;
                padding: 0 0 10px;
                border-bottom:1px dotted #ccc;
            }
            #dg-style-info-list li:last-child {
                margin:0;
                padding:0;
                border:none;
            }
            .text-right {
                text-align:right;
            }
        </style>
        <div class="dg-style-info-title">{$text_new_post}</div>
        <ul id="dg-style-info-list"></ul>
        <p class="text-right"><a href="https://www.dg-style.net/category/notice/" target="_blank">{$text_more_btn}</a></p>
EOM;
}

/*
 * ログインページカスタマイズ
*/
add_action( 'login_enqueue_scripts', 'dg_style_wp_login_page' );
function dg_style_wp_login_page() {
    $login_style_flg = get_option( 'DG_login_style_flg', '1' );
    if ( $login_style_flg === '1' ) {
        $login_style = get_option( 'DG_login_style', '' );
        if ( $login_style !== '' ) {
            echo '<style>' . $login_style . '</style>';
        }
    }
}

/*
 * ツールバーカスタマイズ
*/
add_action( 'admin_bar_menu', 'admin_bar_site_simulator_button', 100 );
function admin_bar_site_simulator_button( $wp_admin_bar ) {
    if ( !is_user_logged_in() || ( !current_user_can( 'administrator' ) && !current_user_can( 'editor' ) ) ) {
        return;
    }
    $admin_url = admin_url( 'admin.php?page=site_builder' );
    $page_url = ( empty($_SERVER[ 'HTTPS' ] ) ? 'http://' : 'https://' ) . $_SERVER[ 'HTTP_HOST' ] . $_SERVER[ 'REQUEST_URI' ];
    $parm = '';
    if ( !is_admin() ) {
        $parm = '&move=' . rawurlencode( $page_url );
    }
    if ( is_single() ) {
        global $post;
        if ( $post->post_type === 'lp' ) {
            return;
        }
    }
    $args = array(
        'id' => 'move-site-builder',
        'title' => '<span class="ab-icon"></span>' . __( 'サイトビルダー', 'dg-style' ),
        'href'  => $admin_url . $parm,
        'meta' => array(
            'title' => __( 'サイトビルダーに移動する', 'dg-style' )
        )
    );
    $wp_admin_bar->add_node( $args );
}

/*
 * 多言語対応
*/
add_action( 'after_setup_theme', 'dg_style_languages_setup' );
function dg_style_languages_setup(){
    load_theme_textdomain( 'dg-style', get_template_directory() . '/languages' );
}

/*
 * アップデート後に保存してない場合のお知らせ
*/
add_action( 'admin_notices', 'check_dg_style_version_notice' );
function check_dg_style_version_notice() {
    if ( !is_admin() ) {
        return '';
    }
    $theme = wp_get_theme( get_template() );
    $save_version = get_option( 'DG_STYLE_VERSION', '' );
    if ( $save_version === $theme->Version ) {
        return '';
    }
    $admin_url = admin_url( 'admin.php?page=site_builder' );
    echo <<< EOM
        <div class="error notice is-dismissible">
            <p>DG-STYLEのアップデート後は、最新データを適用する為に、<a href="{$admin_url}">サイトビルダー</a>で「公開デザインを保存」してください。</p>
        </div>
EOM;
}