<?php
function site_builder_avatar_script() {
    $site_update_time = date( 'YmdHis' );
    $directory_url = get_template_directory_uri();
    wp_register_style( 'dg_avatar_css', $directory_url . '/wp-admin/option-page/avatar_page.css?ver=' . $site_update_time );
    wp_enqueue_style( 'dg_avatar_css' );
    wp_enqueue_style( 'wp-color-picker' );
    wp_enqueue_media();
    wp_enqueue_script( 'media-upload' );
    wp_enqueue_script( 'wp-color-picker' );
    $wp_js = array( 'jquery', 'wp-i18n', );
    wp_enqueue_script( 'site_builder_js', $directory_url . '/wp-admin/option-page/avatar-admin.js', $wp_js, $site_update_time, true );
    //JS翻訳スクリプト追加
    wp_set_script_translations( 'site_builder_js', 'dg-style', get_template_directory() . '/languages' );
}
/*
 * アバターページ設定
*/
function site_builder_editor_option_page() {
    //翻訳
    $text_page_title = __( 'エディターオプション', 'dg-style' );
    $text_adsense_title = __( '広告ブロック', 'dg-style' );
    $text_marker_title = __( 'マーカー色', 'dg-style' );
    $text_avatar_title = __( 'アバター設定', 'dg-style' );
    $text_save = __( '保存', 'dg-style' );
    
    //保存ボタン
    ob_start();
    submit_button();
    settings_fields( 'dg_avatar_group' );
    do_settings_sections( 'site_builder_editor_option' );
    $submit_btn = ob_get_contents();
    ob_end_clean();
    
    //項目
    $adsense_tab = site_builder_block_option_tab();
    $marker_tab = site_builder_marker_tab();
    $avartar_tab = site_builder_avatar_tab();
    
    echo <<< EOM
        <div class="site-builder-option-page">
            <h1 class="option-title">{$text_page_title}</h1>
            <form class="options-list" method="post" action="options.php">
                <div class="tab-inner option-tab-inner">
                    <div class="tab-list option-labels">
                        <button type="button" class="tab-label option-label on">{$text_adsense_title}</button>
                        <button type="button" class="tab-label option-label">{$text_marker_title}</button>
                        <button type="button" class="tab-label option-label">{$text_avatar_title}</button>
                    </div>
                    <div class="tab-contents option-contents option-tab-contents">
                        <div class="tab-content on">{$adsense_tab}</div>
                        <div class="tab-content">{$marker_tab}</div>
                        <div class="tab-content">{$avartar_tab}</div>
                    </div>
                </div>
                {$submit_btn}
            </form>
        </div>
EOM;
}

/*
 * アバター
*/
function site_builder_block_option_tab() {
    $adsense_block = get_option( 'DG_adsense_block', false );
    $adsense_block_arr = array();
    if ( $adsense_block !== false ) {
        $adsense_block_arr = json_decode( wp_unslash( $adsense_block ), true );
    }
    //翻訳
    $text_label = __( '表示名', 'dg-style' );
    
    $item = '';
    if ( is_array( $adsense_block_arr ) && count( $adsense_block_arr ) ) {
        foreach( (array)$adsense_block_arr as $key => $val ) {
            $label = isset( $val[ 'label' ] ) ? $val[ 'label' ] : '';
            $script = isset( $val[ 'script' ] ) ? urldecode( $val[ 'script' ] ) : '';
            $item .= <<< EOM
                <div class="adsense-item" data-level="{$key}">
                    <div class="adsense-label">
                        <span class="text">{$text_label}</span>
                        <input type="text" class="adsense-input" data-level="label" value="{$label}">
                    </div>
                    <textarea class="adsense-input" data-level="script" rows="5" placeholder="script code">{$script}</textarea>
                    <button type="button" class="remove-adsense"></button>
                </div>
EOM;
        }
    } else {
        $item = <<< EOM
            <div class="adsense-item" data-level="item-1">
                <div class="adsense-label">
                    <span class="text">{$text_label}</span>
                    <input type="text" class="adsense-input" data-level="label">
                </div>
                <textarea class="adsense-input" data-level="script" rows="5" placeholder="script code"></textarea>
                <button type="button" class="remove-adsense"></button>
            </div>
EOM;
    }
    return '<div id="adsense-list">' . $item . '</div><button type="button" id="add-adsense"></button>';
}

/*
 * アバター
*/
function site_builder_marker_tab() {
    $marker_colors = get_option( 'DG_marker_colors', false );
    $marker_colors_arr = array();
    if ( $marker_colors !== false ) {
        $marker_colors_arr = json_decode( wp_unslash( $marker_colors ), true );
    }
    $text_marker = __( 'マーカー色', 'dg-style' );
    $text_caution = __( '色変更後、サイトビルダーで保存しないと反映されません。', 'dg-style' );
    $colors = array( 'blue' => '#9eceff', 'yellow' => '#fff799', 'pink' => '#ffc1e0', 'green' => '#b2ffb2', 'puple' => '#ce9eff', );
    $item = '';
    foreach( (array)$colors as $color => $code ) {
        $value = isset( $marker_colors_arr[ $color ] ) ? $marker_colors_arr[ $color ] : $code;
        $item .= '<div class="color-item"><span class="text">' . $text_marker . '(' . $color . ')</span><input class="color-picker" type="text" id="marker-color-' . $color . '" value="' . $value . '" placeholder="' . $code . '" data-default-color="' . $code . '" data-level="' . $color . '"></div>';
    }
    return $item . '<p class="caution">※' . $text_caution . '</p>';
}

/*
 * アバター
*/
function site_builder_avatar_tab() {
    $avatar_items = '';
    $speech_avatars = get_option( 'DG_speech_avatars', false );
    $speech_avatars_arr = array();
    if ( $speech_avatars !== false ) {
        $speech_avatars_arr = json_decode( wp_unslash( $speech_avatars ), true );
    }
    //翻訳
    $text_image_btn = __( 'イメージ選択', 'dg-style' );
    $text_image_delete = __( '削除', 'dg-style' );
    $text_avarta_name = __( 'アバター名', 'dg-style' );
    $text_wp_image = __( 'WPイメージ', 'dg-style' );
    $text_image_url = __( 'イメージURL', 'dg-style' );
    //アバターアイテム
    if ( is_array( $speech_avatars_arr ) && count( $speech_avatars_arr ) > 0 ) {
        foreach( (array)$speech_avatars_arr as $key => $value ) {
            $image_wp = '<a href="#" class="image-upload-btn ui-btn">' . $text_image_btn . '</a><a class="image-remove-btn ui-btn">' . $text_image_delete . '</a>';
            $image_img = '';
            $image_url = '';
            $check1 = '';
            $check2 = '';
            $on1 = '';
            $on2 = '';
            if ( isset( $value[ 'type' ] ) && $value[ 'type' ] === '2' ) {
                $check1 = '';
                $check2 = ' checked';
                $on1 = '';
                $on2 = ' on';
                if ( isset( $value[ 'src' ] ) && $value[ 'src' ] !== '' ) {
                    $image_img = '<img src="' . $value[ 'src' ] . '">';
                    $image_url = $value[ 'src' ];
                }
            } else {
                $check1 = ' checked';
                $check2 = '';
                $on1 = ' on';
                $on2 = '';
                if ( isset( $value[ 'imgId' ] ) && $value[ 'imgId' ] !== '' ) {
                    $thumb = post_image_src_list( $value[ 'imgId' ] );
                    if ( isset( $thumb[ 'full' ][ 'url' ] ) && $thumb[ 'full' ][ 'url' ] !== '' ) {
                        $image_wp = '<a href="#" class="no-image-upload-btn"><img src="' . $thumb[ 'full' ][ 'url' ] . '"></a><a class="image-remove-btn ui-btn on">' . $text_image_delete . '</a>';
                    }
                }
            }
            $name = isset( $value[ 'name' ] ) ? $value[ 'name' ] : '';
            $avatar_items .= <<< EOM
                <div class="avarta-item" data-level="{$key}">
                    <div class="avatar-name-area">
                        <span class="avatar-name">{$text_avarta_name}</span><input type="text" class="set-value avatar-name-input" value="{$name}" data-level="name">
                    </div>
                    <div class="tab-inner image-select-tabs">
                        <div class="tab-list option-labels flex">
                            <label class="tab-label option-label{$on1}"><input type="radio" name="avatar-image-type-{$key}" value="1" class="set-value none-display" data-level="type"{$check1}><span class="toggle-label">{$text_wp_image}</span></label>
                            <label class="tab-label option-label{$on2}"><input type="radio" name="avatar-image-type-{$key}" value="2" class="set-value none-display" data-level="type"{$check2}><span class="toggle-label">{$text_image_url}</span></label>
                        </div>
                        <div class="tab-contents option-contents">
                            <div class="tab-content{$on1}">
                                <div class="image-box image-wp-image">{$image_wp}</div>
                            </div>
                            <div class="tab-content{$on2}">
                                <div class="window-title">{$text_image_url}</div>
                                <input type="text" class="image-url-value image-url-value image-url-input set-value" data-level="src" value="{$image_url}">
                                <div class="image-simulator image-url-simulator">{$image_img}</div>
                            </div>
                        </div>
                    </div>
                    <button type="button" class="delete-avatar" value="{$key}"></button>
                </div>
EOM;
        }
    } else {
        $avatar_items = <<< EOM
            <div class="avarta-item" data-level="icon-1">
                <div class="avatar-name-area">
                    <span class="avatar-name">{$text_avarta_name}</span><input type="text" class="set-value avatar-name-input" value="" data-level="name">
                </div>
                <div class="tab-inner image-select-tabs">
                    <div class="tab-list option-labels flex">
                        <label class="tab-label option-label on"><input type="radio" name="avatar-image-type-icon-1" value="1" class="set-value none-display" data-level="type" checked><span class="toggle-label">{$text_wp_image}</span></label>
                        <label class="tab-label option-label "><input type="radio" name="avatar-image-type-icon-1" value="2" class="set-value none-display" data-level="type"><span class="toggle-label">{$text_image_url}</span></label>
                    </div>
                    <div class="tab-contents option-contents">
                        <div class="tab-content on">
                            <div class="image-box image-wp-image"><a href="#" class="image-upload-btn ui-btn">{$text_image_url}</a><a class="image-remove-btn ui-btn">{$text_image_delete}</a></div>
                        </div>
                        <div class="tab-content">
                            <div class="window-title">{$text_image_url}</div>
                            <input type="text" class="image-url-value image-url-value image-url-input set-value" data-level="src" value="">
                            <div class="image-simulator image-url-simulator"></div>
                        </div>
                    </div>
                </div>
                <button type="button" class="delete-avatar" value="icon-1"></button>
            </div>
EOM;
    }
    return <<< EOM
        <div class="avartar-list">
            {$avatar_items}
            <button type="button" id="add-avatar" class="avarta-item"></button>
        </div>
EOM;
}

/*
 * アバターフィールド作成
*/
add_action( 'admin_init', 'dg_speech_avatars_setting' );
function dg_speech_avatars_setting(){
    register_setting(
        'dg_avatar_group',
        'DG_speech_avatars',
        array(
            'type' => 'string',
            'show_in_rest' => true,
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    add_settings_section(
        'avatar_section',
        '',
        '',
        'site_builder_editor_option'
    );
    add_settings_field(
        'DG_speech_avatars',
        '',
        'dg_speech_avatar_input_field',
        'site_builder_editor_option',
        'avatar_section'
    );
    //adsense
    register_setting(
        'dg_avatar_group',
        'DG_adsense_block',
        array(
            'type' => 'string',
            'show_in_rest' => true,
            'sanitize_callback' => null,
        )
    );
    add_settings_field(
        'DG_adsense_block',
        '',
        'dg_adsense_block_input_field',
        'site_builder_editor_option',
        'avatar_section'
    );
    //color
    register_setting(
        'dg_avatar_group',
        'DG_marker_colors',
        array(
            'type' => 'string',
            'show_in_rest' => true,
            'sanitize_callback' => null,
        )
    );
    add_settings_field(
        'DG_marker_colors',
        '',
        'dg_marker_block_input_field',
        'site_builder_editor_option',
        'avatar_section'
    );
}

/*
 * アバター作成
*/
function dg_speech_avatar_input_field() {
    $avatars_value = '';
    $speech_avatars = get_option( 'DG_speech_avatars', false );
    if ( $speech_avatars !== false ) {
        $avatars_value = wp_unslash( htmlspecialchars( $speech_avatars, ENT_QUOTES, 'UTF-8' ) );
    }
    echo '<input type="hidden" id="DG_speech_avatars" name="DG_speech_avatars" value="' . $avatars_value . '">';
}

/*
 * 広告作成
*/
function dg_adsense_block_input_field() {
    $adsense_value = '';
    $adsense_block = get_option( 'DG_adsense_block', false );
    if ( $adsense_block !== false ) {
        $adsense_value = wp_unslash( htmlspecialchars( $adsense_block, ENT_QUOTES, 'UTF-8' ) );
    }
    echo '<input type="hidden" id="DG_adsense_block" name="DG_adsense_block" value="' . $adsense_value . '">';
}

/*
 * マーカー色作成
*/
function dg_marker_block_input_field() {
    $value = '';
    $colors = get_option( 'DG_marker_colors', '' );
    if ( $colors !== false ) {
        $value = wp_unslash( htmlspecialchars( $colors, ENT_QUOTES, 'UTF-8' ) );
    }
    echo '<input type="hidden" id="DG_marker_colors" name="DG_marker_colors" value="' . $value . '">';
}

add_action( 'rest_api_init', 'dg_speech_avatars_rest_api_setting', 99 );
function dg_speech_avatars_rest_api_setting() {
    register_setting(
        'dg_avatar_group',
        'DG_speech_avatars',
        array(
            'type' => 'string',
            'show_in_rest' => true,
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    //adsense
    register_setting(
        'dg_avatar_group',
        'DG_adsense_block',
        array(
            'type' => 'string',
            'show_in_rest' => true,
            'sanitize_callback' => null,
        )
    );
    //color
    register_setting(
        'dg_avatar_group',
        'DG_marker_colors',
        array(
            'type' => 'string',
            'show_in_rest' => true,
            'sanitize_callback' => null,
        )
    );
    //公開中のデザイン
    register_setting(
        'dg_avatar_group',
        'DG_site_design',
        array(
            'type' => 'string',
            'show_in_rest' => true,
            'sanitize_callback' => null,
        )
    );
    //ABテストデザイン
    register_setting(
        'dg_avatar_group',
        'DG_abtest_designs',
        array(
            'type' => 'string',
            'show_in_rest' => true,
            'sanitize_callback' => null,
        )
    );
    //デバイス取得エンドポイント
    register_rest_route( 'dg_style', '/device', array(
        'methods' => 'GET',
        'callback' => 'get_dg_style_device',
        'permission_callback' => false,
    ));
}

/*
 * デザインのデバイスリスト取得
*/
function get_dg_style_device( WP_REST_Request $request ) {
    $param = $request->get_params();
    $abtest = $param[ 'ab' ];
    $design = $param[ 'design' ];
    $page_type = 'single-' . $param[ 'type' ];
    $css = '';
    $critical_css = '';
    $device = array( 320 => 'sp', 560 => 'tb', 960 => 'pc' );
    $scripts = get_option( 'DG_script_option' . $abtest, false );
    if ( $scripts !== false ) {
        $scripts = json_decode( $scripts, true );
        if ( isset( $scripts[ 'device' ] ) ) {
            $device = $scripts[ 'device' ];
        }
        $cnt = 0;
        $cri_flg = isset( $scripts[ 'critical' ][ $page_type ] ) && is_array( $scripts[ 'critical' ][ $page_type ] ) && count( $scripts[ 'critical' ][ $page_type ] ) > 0;
        foreach( (array)$device as $size => $type ) {
            $css_url = isset( $scripts[ 'css_path' ][ $page_type ][ $type ] ) ? $scripts[ 'css_path' ][ $page_type ][ $type ] : '';
            if ( $cnt === 0 ) {
                if ( $cri_flg ) {
                    $critical_css .= $scripts[ 'critical' ][ $page_type ][ $type ];
                    if ( $css_url !== '' ) {
                        $css .= '<link id="' . $type . '_style" href="' . $css_url . '" rel="stylesheet" type="text/css">';
                    }
                } elseif ( $css_url !== '' ) {
                    $css .= '<link id="' . $type . '_style" href="' . $css_url . '" rel="stylesheet" type="text/css">';
                }
            } else {
                if ( $cri_flg ) {
                    if ( isset( $scripts[ 'critical' ][ $page_type ][ $type ] ) ) {
                        $critical_css .= '@media screen and (min-width:' . $size . 'px) {' . $scripts[ 'critical' ][ $page_type ][ $type ] . '}';
                    }
                    if ( $css_url !== '' ) {
                        $css .= '<link id="' . $type . '_style" href="' . $css_url . '" rel="stylesheet" type="text/css" media="screen and (min-width:' . $size . 'px)">';
                    }
                } elseif ( $css_url !== '' ) {
                    $css .= '<link id="' . $type . '_style" href="' . $css_url . '" rel="stylesheet" type="text/css" media="screen and (min-width:' . $size . 'px)">';
                }
            }
            ++$cnt;
        }
    }
    if ( $critical_css !== '' ) {
        $critical_css = '<style id="dg-critical-style">' . $critical_css . '</style>';
    }
    if ( $design === '' ) {
        $design = get_option( 'DG_site_design', '' );
    }
    $design_value = get_site_design_value( $design, true );
    $result = array( 'device' => $device, 'design' => $design_value, 'css' => $css, 'critical' => $critical_css );
    $response = new WP_REST_Response( $result );
    $response->set_status(200);
    return $response;
}