<?php
class CreatePageInfoPreview extends CreatePageInfoUrl {
    //宣言時実行
    public function __construct( $post ) {
        if ( !( isset( $post[ 'page_type' ] ) && $post[ 'page_type' ] !== '' ) ) {
            return false;
        }
        $this->setSiteName( get_option( 'blogname', '' ) );
        $this->homeUrl = home_url();
        $page_info = $this->setPageidByUrl( $post );
        $this->setPageData( $page_info );
    }
    //送信されたURLからpageInfo作成
    private function setPageidByUrl( $post ) {
        $page_type = $post[ 'page_type' ];
        $paged = isset( $post[ 'search_page_number' ] ) && $post[ 'search_page_number' ] !== '' ? $post[ 'search_page_number' ] : 1;
        $page_info = array();
        if ( $page_type === '404' ) {
            $page_info = array(
                'taxonomy' => $page_type,
                'page_type' => $page_type,
            );
        } else if ( $page_type === 'top' ) {
            $page_info = array(
                'taxonomy' => $page_type,
                'page_type' => $page_type,
                'paged' => $paged,
            );
        } elseif ( $page_type === 'search' ) {
            $keyword = 'テスト';
            if ( isset( $post[ 'search_page' ] ) && $post[ 'search_page' ] !== '' ) {
                $keyword = $post[ 'search_page' ];
            }
            $page_info = array(
                'taxonomy' => $page_type,
                'term_id' => $keyword,
                'page_type' => $page_type,
                'paged' => $paged,
            );
        } elseif ( $page_type === 'author' ) {
            $users = get_users( array( 'orderby' => 'ID','order'=> 'ASC', 'number' => 1 ) );
            $author_id = $users[ 0 ]->ID;
            if ( isset( $post[ 'search_page' ] ) && $post[ 'search_page' ] !== '' ) {
                $author_id = $post[ 'search_page' ];
            }
            $page_info = array(
                'taxonomy' => $page_type,
                'term_id' => $author_id,
                'page_type' => $page_type,
                'paged' => $paged,
            );
        } else {
            if ( strpos( $page_type, 'single-' ) !== false ) {
                $page_type = str_replace( 'single-', '', $page_type );
                if ( isset( $post[ 'search_page' ] ) && is_numeric( $post[ 'search_page' ] ) ) {
                    $refine_post = get_post( $post[ 'search_page' ] );
                    if ( $refine_post !== null ) {
                        $page_info = array(
                            'taxonomy' => $page_type,
                            'post_id' => $post[ 'search_page' ],
                            'page_type' => 'single',
                            'pageClass' => 'single',
                        );
                    } else {
                        $page_info = array(
                            'taxonomy' => '404',
                            'page_type' => '404',
                        );
                    }
                } else {
                    $query = new WP_Query( array( 'posts_per_page' => 1, 'post_type' => $page_type, 'post_status' => array( 'publish', 'private', ) ) );
                    if ( $query->have_posts() ) {
                        while ( $query->have_posts() ) {
                            $query->the_post();
                            $post_id = get_the_ID();
                        }
                        wp_reset_postdata();
                        $page_info = array(
                            'taxonomy' => $page_type,
                            'post_id' => $post_id,
                            'page_type' => 'single',
                            'pageClass' => 'single',
                        );
                    } else {
                        $page_info = array(
                            'taxonomy' => '404',
                            'page_type' => '404',
                        );
                    }
                }
            } else if ( strpos( $page_type, 'taxonomy-' ) !== false ) {
                $page_type = str_replace( 'taxonomy-', '', $page_type );
                if ( $page_type === 'date' ) {
                    $page_info = array(
                        'taxonomy' => $page_type,
                        'page_type' => 'taxonomy',
                        'paged' => $paged,
                    );
                    if ( isset( $post[ 'search_page' ] ) && $post[ 'search_page' ] !== '' ) {
                        $date = json_decode( stripslashes( $post[ 'search_page' ] ), true );
                        if ( isset( $date[ 'year' ] ) && $date[ 'year' ] !== '' ) {
                            $page_info[ 'term_id' ][ 'year' ] = $date[ 'year' ];
                        }
                        if ( isset( $date[ 'monthnum' ] ) && $date[ 'monthnum' ] !== '' ) {
                            $page_info[ 'term_id' ][ 'monthnum' ] = $date[ 'monthnum' ];
                        }
                        if ( isset( $date[ 'day' ] ) && $date[ 'day' ] !== '' ) {
                            $page_info[ 'term_id' ][ 'day' ] = $date[ 'day' ];
                        }
                    }
                    if ( !isset( $page_info[ 'term_id' ][ 'year' ] ) ) {
                        $page_info[ 'term_id' ][ 'year' ] = '2020';
                        $page_info[ 'term_id' ][ 'monthnum' ] = '01';
                        $page_info[ 'term_id' ][ 'day' ] = '01';
                    }
                    if ( isset( $page_info[ 'term_id' ][ 'year' ] ) ) {
                        $this->setYear( (int)$page_info[ 'term_id' ][ 'year' ] );
                    }
                    if ( isset( $page_info[ 'term_id' ][ 'monthnum' ] ) ) {
                        $this->setMonth( (int)$page_info[ 'term_id' ][ 'monthnum' ] );
                    }
                    if ( isset( $page_info[ 'term_id' ][ 'day' ] ) ) {
                        $this->setDay( (int)$page_info[ 'term_id' ][ 'day' ] );
                    }
                } else {
                    if ( isset( $post[ 'search_page' ] ) && $post[ 'search_page' ] !== '' ) {
                        $terms = get_term( $post[ 'search_page' ], $page_type );
                    } else {
                        $terms = get_terms( $page_type, array( 'orderby' => 'name', 'number' => 1 ) );
                    }
                    if ( !empty( $terms ) && !is_wp_error( $terms ) ){
                        if ( isset( $post[ 'search_page' ] ) && $post[ 'search_page' ] !== '' ) {
                            $term_id = $terms->term_id;
                        } else {
                            $term_id = reset( $terms )->term_id;
                        }
                        $page_info = array(
                            'taxonomy' => $page_type,
                            'term_id' => $term_id,
                            'page_type' => 'taxonomy',
                            'paged' => $paged,
                        );
                        $taxonomy_data = get_taxonomy( $page_type );
                        if ( $taxonomy_data ) {
                            $page_info[ 'post_type' ] = $taxonomy_data->object_type;
                        }
                    } else {
                        $page_info = array(
                            'taxonomy' => '404',
                            'page_type' => '404',
                        );
                    }
                }
            } else if ( strpos( $page_type, 'custom-post-archive-' ) !== false ) {
                $page_type = str_replace( 'custom-post-archive-', '', $page_type );
                $page_info = array(
                    'taxonomy' => $page_type,
                    'page_type' => 'custom-post-archive',
                    'post_type' => array( $page_type ),
                );
            }
        }
        //記事一覧の並び替え値反映
        if ( isset( $post[ 'orderby' ] ) ) {
            $page_info[ 'orderby' ] = $post[ 'orderby' ];
        }
        if ( isset( $post[ 'order' ] ) ) {
            $page_info[ 'order' ] = $post[ 'order' ];
        }
        if ( isset( $post[ 'count' ] ) ) {
            $page_info[ 'count' ] = $post[ 'count' ];
        }
        //GETパラメータ
        $get_param = array();
        if ( isset( $post[ 'get' ] ) && $post[ 'get' ] !== '' ) {
            parse_str( $post[ 'get' ], $get_param );
        }
        $page_info[ 'parm' ] = $get_param;
        $this->setPageInfo( $page_info );
        return $page_info;
    }
    
    public function getSiteOption() {
        return $this->siteOption;
    }
    // プレビュー用データセット
    public function createSiteOption( $main_value ) {
        if ( !isset( $main_value[ 'main' ] ) ) {
            return false;
        }
        $design_value = $main_value[ 'main' ];
        //各種ページごとの処理追加
        //作成者ページ用サムネイル種類選択
        $author_sns_types = array( 'site', 'mail', 'facebook', 'twitter', 'line' );
        $author_options = array();
        $user_image_type = array();
        //タクソノミー用
        $child_flg = array();
        //記事ページ用
        $postmeta_keys = array( 'evaluate_total', 'evaluate_table', );
        $post_ids = array();
        $contact_ids = array();
        $gmenu_names = array();
        $css_flg = array();
        $terms_list = array();
        foreach( (array)$design_value as $part_id => $part_value ) {
            //検索フォーム用のタクソノミーリスト取得
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'search-form' && isset( $part_value[ 'option' ][ 'area' ] ) && is_array( $part_value[ 'option' ][ 'area' ] ) ) {
                foreach( (array)$part_value[ 'option' ][ 'area' ] as $tax => $val ) {
                    if ( isset( $val[ 'slug' ] ) && strpos( $val[ 'slug' ], 'tax-' ) !== false ) {
                        $terms_list[] = str_replace( 'tax-' , '', $val[ 'slug' ] );
                    }
                }
            }
            //グローバルメニュー取得
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'gmenu' && isset( $part_value[ 'option' ][ 'gmenu-type' ] ) && $part_value[ 'option' ][ 'gmenu-type' ] !== '' ) {
                $gmenu_names[ $part_value[ 'option' ][ 'gmenu-type' ] ] = $part_value[ 'option' ][ 'gmenu-type' ];
            }

            //記事コンテンツ
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'post-content' && isset( $part_value[ 'option' ][ 'ids' ] ) && $part_value[ 'option' ][ 'ids' ] !== '' ) {
                $post_ids = array_merge( $post_ids, explode( ',', $part_value[ 'option' ][ 'ids' ] ) );
            }
            //お問い合わせ
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'contact' && isset( $part_value[ 'option' ][ 'id' ] ) && $part_value[ 'option' ][ 'id' ] !== '' ) {
                $contact_ids[] = $part_value[ 'option' ][ 'id' ];
            }
            //postmetaキーリストを取得
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'single-postmeta' && isset( $part_value[ 'option' ][ 'type' ] ) && $part_value[ 'option' ][ 'type' ] !== '' ) {
                $postmeta_keys[] = $part_value[ 'option' ][ 'type' ];
            }
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'single-views' ) {
                if ( isset( $part_value[ 'option' ][ 'type' ] ) && $part_value[ 'option' ][ 'type' ] !== '' ) {
                    $postmeta_keys[] = $part_value[ 'option' ][ 'type' ];
                } else {
                    $postmeta_keys[] = 'views';
                }
            }
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'single-views' ) {
                $postmeta_keys[] = 'views';
                $postmeta_keys[] = 'w_views';
                $postmeta_keys[] = 'm_views';
                $postmeta_keys[] = 'y_views';
            }
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'single-recommend' ) {
                $postmeta_keys[] = 'dg_recommend_post';
            }
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'single-movie' ) {
                $postmeta_keys[] = 'movie_thumbnail';
            }
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'single-bookmark' ) {
                $postmeta_keys[] = 'dg_bookmark';
            }

            //CSS判定
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'single-content' ) {
                if ( !isset( $part_value[ 'option' ][ 'block-css' ] ) || ( isset( $part_value[ 'option' ][ 'block-css' ] ) && $part_value[ 'option' ][ 'block-css' ] === '1' ) ) {
                    $css_flg[ 'block' ] = true;
                }
                if ( !isset( $part_value[ 'option' ][ 'dg-css' ] ) || ( isset( $part_value[ 'option' ][ 'dg-css' ] ) && $part_value[ 'option' ][ 'dg-css' ] === '1' ) ) {
                    $css_flg[ 'dg' ] = true;
                }
            }
            //作成者ページ用サムネイル種類選択
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'taxonomy-thumbnail' ) {
                $image_type = isset( $part_value[ 'option' ][ 'user' ] ) && $part_value[ 'option' ][ 'user' ] === '2' ? 'user_image' : 'bg_image';
                $user_image_type[] = $image_type;
            } elseif ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'taxonomy-user_sns' ) {
                $user_image_type[] = 'user_sns';
                foreach( (array)$author_sns_types as $sns_name ) {
                    if ( !isset( $part_value[ 'option' ][ $sns_name ] ) || ( isset( $part_value[ 'option' ][ $sns_name ] ) && $part_value[ 'option' ][ $sns_name ] === '1' ) ) {
                        $author_options[ 'user_sns' ][ $sns_name ] = true;
                    }
                }
            } elseif ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'taxonomy-movie' ) {
                $user_image_type[] = 'movie_thumbnail';
                $thumb_flg = isset( $part_value[ 'option' ][ 'thumb' ] ) ? $part_value[ 'option' ][ 'thumb' ] : '1';
                if ( $thumb_flg === '1' ) {
                    $image_type = isset( $part_value[ 'option' ][ 'user' ] ) && $part_value[ 'option' ][ 'user' ] === '2' ? 'user_image' : 'bg_image';
                    $user_image_type[] = $image_type;
                }
            }
            //タクソノミー用
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'taxonomy-brother' ) {
                $child_flg[ 'brother' ] = true;
            }
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'taxonomy-child' ) {
                $child_flg[ 'child' ] = true;
            }
            if ( isset( $part_value[ 'slug' ] ) && $part_value[ 'slug' ] === 'taxonomy-movie' ) {
                $child_flg[ 'movie_thumbnail' ] = true;
            }

            //非表示タイマー追加
            if ( isset( $part_value[ 'hidden' ][ 'start' ] ) && $part_value[ 'hidden' ][ 'start' ] !== '' ) {
                $design_value[ $part_id ][ 'timer' ][ 'start' ] = $part_value[ 'hidden' ][ 'start' ];
            }
            if ( isset( $part_value[ 'hidden' ][ 'end' ] ) && $part_value[ 'hidden' ][ 'end' ] !== '' ) {
                $design_value[ $part_id ][ 'timer' ][ 'end' ] = $part_value[ 'hidden' ][ 'end' ];
            }
        }
        $postmeta_keys = array_unique( $postmeta_keys );
        $postmeta_keys = array_values( $postmeta_keys );
        $user_image_type = array_unique( $user_image_type );
        $user_image_type = array_values( $user_image_type );
        $post_ids = array_unique( $post_ids );
        $post_ids = array_values( $post_ids );
        $contact_ids = array_unique( $contact_ids );
        $contact_ids = array_values( $contact_ids );
        $main_value[ 'meta_keys' ] = $postmeta_keys;
        $main_value[ 'child_flg' ] = $child_flg;
        $main_value[ 'select_post_ids' ] = $post_ids;
        $main_value[ 'contact_ids' ] = $contact_ids;
        $main_value[ 'gmenu' ] = $gmenu_names;
        $main_value[ 'terms' ] = $terms_list;
        $main_value[ 'css_flg' ] = $css_flg;
        $main_value[ 'user_fields' ] = array(
            'field' => $user_image_type,
            'option' => $author_options,
        );
        $main_value[ 'main' ] = $design_value;
        $this->siteOption = $main_value;
    }
    
    // キャッシュパーツ取得
    public function getCacheDatas() {
        $data = array();
        $main_value = $this->getSiteOption();
        //記事コンテンツ指定記事取得
        if ( isset( $main_value[ 'select_post_ids' ] ) ) {
            $data[ 'selectPosts' ] = get_select_post_content( $main_value[ 'select_post_ids' ] );
        }
        //お問い合わせ取得
        if ( isset( $main_value[ 'contact_ids' ] ) && is_array( $main_value[ 'contact_ids' ] ) && count( $main_value[ 'contact_ids' ] ) > 0 ) {
            foreach( (array)$main_value[ 'contact_ids' ] as $contact_id ) {
                $contact = get_post( $contact_id );
                if ( $contact !== null ) {
                    $data[ 'contactList' ][ $contact_id ] = $contact->post_content;
                }
            }
        }
        //検索フォーム用タクソノミーリスト
        if ( isset( $main_value[ 'terms' ] ) && is_array( $main_value[ 'terms' ] ) && count( $main_value[ 'terms' ] ) > 0 ) {
            foreach( (array)$main_value[ 'terms' ] as $tax ) {
                $args = array();
                $terms = get_terms( $tax, $args );
                if ( !empty( $terms ) && !is_wp_error( $terms ) ){
                    $taxonomy = get_taxonomy( $tax );
                    $data[ 'terms' ][ $tax ][] = array(
                        'slug' => '',
                        'name' => $taxonomy->label
                    );
                    foreach( (array)$terms as $term ) {
                        $data[ 'terms' ][ $tax ][] = array(
                            'slug' => $term->slug,
                            'name' => $term->name
                        );
                    }
                }
            }
        }
        if ( isset( $main_value[ 'gmenu' ] ) && is_array( $main_value[ 'gmenu' ] ) && count( $main_value[ 'gmenu' ] ) > 0 ) {
            foreach( (array)$main_value[ 'gmenu' ] as $name ) {
                $data[ 'gmenu' ][ $name ] = create_menu_list_part( $name );
            }
        }
        return $data;
    }
    // もっと見るの場合のページデータ取得
    public function setCurrentPageInfoMore( $post ) {
        $main_value = $this->getSiteOption();
        if ( !$main_value ) {
            return false;
        }
        $result = array();
        $page_info = $this->getPageInfo();
        $title = $this->getTitle();
        $description = $this->getDescription();
        $term_parent_id = $this->getTermParentId();
        $taxonomy_thumbnail = $this->getTaxonomyThumbnail();
        $taxonomy_sub_title = $this->getTaxonomySubTitle();
        $term_slug = $this->getTermSlug();
        $term_count = $this->getTermCount();
        $page_info = $this->setPageOrderOption( $page_info );
        $loading_img = $main_value[ 'loading_image' ];
        $post_summary = false;
        $archive = false;
        $pass = isset( $post[ 'pw' ] ) ? $post[ 'pw' ] : '';
        if ( isset( $page_info[ 'pageClass' ] ) && $page_info[ 'pageClass' ] === 'single' ) {
            $page_info[ 'meta_keys' ] = isset( $main_value[ 'meta_keys' ] ) ? $main_value[ 'meta_keys' ] : array();
            $post_data = front_single_post_get( $page_info, $pass );
            if ( $post_data !== false ) {
                $post_summary = $post_data[ 'postData' ];
                $post_summary[ 'user_id' ] = $post_data[ 'user_id' ];
                $post_summary[ 'parent' ] = $post_data[ 'parent' ];
                $result[ 'post' ] = $post_data[ 'postData' ];
                $result[ 'post' ][ 'commentNonce' ] = '';
            }
        } elseif ( $page_info[ 'taxonomy' ] !== '404' ) {
            if ( isset( $main_value[ 'main_post_flg' ] ) ) {
                $page_info[ 'none_main_post' ] = true;
            }
            $archive = front_main_part_archive_query( $page_info );
            $result[ 'archive' ][ 'postCount' ] = $archive[ 'postCount' ];
        }
        $this->setPageInfo( $page_info );
        $this->setPostSummary( $post_summary );
        $this->setArchive( $archive );
        return $result;
    }
}